/*
 * Decompiled with CFR 0.152.
 */
package com.mindprod.ledatastream;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LEDataOutputStream
implements DataOutput {
    private static final String EmbeddedCopyright = "copyright (c) 1998-2003 Roedy Green, Canadian Mind Products, http://mindprod.com";
    protected DataOutputStream d;
    byte[] w;

    public LEDataOutputStream(OutputStream out) {
        this.d = new DataOutputStream(out);
        this.w = new byte[8];
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.w[0] = (byte)v;
        this.w[1] = (byte)(v >> 8);
        this.d.write(this.w, 0, 2);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.w[0] = (byte)v;
        this.w[1] = (byte)(v >> 8);
        this.d.write(this.w, 0, 2);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.w[0] = (byte)v;
        this.w[1] = (byte)(v >> 8);
        this.w[2] = (byte)(v >> 16);
        this.w[3] = (byte)(v >> 24);
        this.d.write(this.w, 0, 4);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.w[0] = (byte)v;
        this.w[1] = (byte)(v >> 8);
        this.w[2] = (byte)(v >> 16);
        this.w[3] = (byte)(v >> 24);
        this.w[4] = (byte)(v >> 32);
        this.w[5] = (byte)(v >> 40);
        this.w[6] = (byte)(v >> 48);
        this.w[7] = (byte)(v >> 56);
        this.d.write(this.w, 0, 8);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public final void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public final synchronized void write(int b) throws IOException {
        this.d.write(b);
    }

    @Override
    public final synchronized void write(byte[] b, int off, int len) throws IOException {
        this.d.write(b, off, len);
    }

    public void flush() throws IOException {
        this.d.flush();
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.d.writeBoolean(v);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.d.writeByte(v);
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        this.d.writeBytes(s);
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        this.d.writeUTF(str);
    }

    public final int size() {
        return this.d.size();
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.d.write(b, 0, b.length);
    }

    public final void close() throws IOException {
        this.d.close();
    }
}

