/*
 * Decompiled with CFR 0.152.
 */
package dnl.utils.text.table;

import dnl.utils.text.table.SeparatorPolicy;
import dnl.utils.text.table.TextTableRenderer;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class TextTable {
    protected TableModel tableModel;
    protected List<SeparatorPolicy> separatorPolicies = new ArrayList<SeparatorPolicy>();
    protected boolean addRowNumbering;
    protected boolean headless;

    public TextTable(TableModel tableModel) {
        this.tableModel = tableModel;
    }

    public TextTable(TableModel tableModel, boolean addNumbering) {
        this.tableModel = tableModel;
        this.addRowNumbering = addNumbering;
    }

    public TextTable(String[] columnNames, Object[][] data) {
        this.tableModel = new DefaultTableModel(data, columnNames);
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setAddRowNumbering(boolean addNumbering) {
        this.addRowNumbering = addNumbering;
    }

    public void addSeparatorPolicy(SeparatorPolicy separatorPolicy) {
        this.separatorPolicies.add(separatorPolicy);
        separatorPolicy.setTableModel(this.tableModel);
    }

    public void printTable() {
        this.printTable(System.out, 0);
    }

    public void printTable(PrintStream ps, int indent) {
        TextTableRenderer renderer = new TextTableRenderer(this);
        renderer.render(ps, indent);
    }

    protected Object getValueAt(int row, int column) {
        int rowIndex = row;
        return this.tableModel.getValueAt(rowIndex, column);
    }

    protected boolean hasSeparatorAt(int row) {
        for (SeparatorPolicy separatorPolicy : this.separatorPolicies) {
            if (!separatorPolicy.hasSeparatorAt(row)) continue;
            return true;
        }
        return false;
    }
}

