/*
 * Decompiled with CFR 0.152.
 */
package dnl.utils.text.table;

import dnl.utils.text.table.TableRenderer;
import dnl.utils.text.table.TextTable;
import dnl.utils.text.table.TextTableModel;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;

public class TextTableRenderer
implements TableRenderer {
    protected String[] formats;
    protected int[] lengths;
    protected TextTable textTable;
    protected TableModel tableModel;
    private boolean showNulls = false;

    public TextTableRenderer(TextTable textTable) {
        this.textTable = textTable;
        this.tableModel = textTable.getTableModel();
    }

    public TextTableRenderer(TextTable textTable, boolean showNulls) {
        this.textTable = textTable;
        this.tableModel = textTable.getTableModel();
        this.showNulls = showNulls;
    }

    @Override
    public void render(OutputStream os, int indent) {
        PrintStream ps = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
        TableModel tableModel = this.textTable.getTableModel();
        String indentStr = StringUtils.repeat((String)" ", (int)indent);
        this.resolveColumnLengths();
        String separator = this.resolveSeparator(this.lengths);
        int rowCount = tableModel.getRowCount();
        int rowCountStrSize = Integer.toString(rowCount).length();
        String indexFormat1 = "%1$-" + rowCountStrSize + "s  ";
        String indexFormat2 = "%1$" + rowCountStrSize + "s. ";
        int totLength = this.resolveFormats();
        String headerStartSep = StringUtils.repeat((String)"_", (int)(totLength + tableModel.getColumnCount() * 2));
        ps.print(indentStr);
        this.indentAccordingToNumbering(ps, indexFormat1);
        ps.println(headerStartSep);
        ps.print(indentStr);
        this.indentAccordingToNumbering(ps, indexFormat1);
        for (int j = 0; j < tableModel.getColumnCount(); ++j) {
            ps.printf(this.formats[j], tableModel.getColumnName(j));
        }
        this.indentAccordingToNumbering(ps, indexFormat1);
        String headerSep = StringUtils.repeat((String)"=", (int)(totLength + tableModel.getColumnCount() * 2 - 1));
        ps.print(indentStr);
        ps.print("|");
        ps.print(headerSep);
        ps.println("|");
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            this.addSeparatorIfNeeded(ps, separator, indexFormat1, i, indentStr);
            ps.print(indentStr);
            if (this.textTable.addRowNumbering) {
                if (!this.modelAllowsNumberingAt(i)) {
                    this.indentAccordingToNumbering(ps, indexFormat1);
                } else {
                    ps.printf(indexFormat2, i + 1);
                }
            }
            for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                this.printValue(ps, i, j, false);
            }
        }
    }

    private void resolveColumnLengths() {
        this.lengths = new int[this.tableModel.getColumnCount()];
        for (int col = 0; col < this.tableModel.getColumnCount(); ++col) {
            for (int row = 0; row < this.tableModel.getRowCount(); ++row) {
                Object val = this.tableModel.getValueAt(row, col);
                String valStr = String.valueOf(val);
                if (!this.showNulls && val == null) {
                    valStr = "";
                }
                this.lengths[col] = Math.max(valStr.length(), this.lengths[col]);
            }
        }
    }

    private String resolveSeparator(int[] lengths) {
        StringBuilder sepSb = new StringBuilder();
        for (int j = 0; j < this.tableModel.getColumnCount(); ++j) {
            if (j == 0) {
                sepSb.append("|");
            }
            lengths[j] = Math.max(this.tableModel.getColumnName(j).length(), lengths[j]);
            sepSb.append(StringUtils.repeat((String)"-", (int)(lengths[j] + 1)));
            sepSb.append("|");
        }
        String separator = sepSb.toString();
        return separator;
    }

    private void addSeparatorIfNeeded(PrintStream ps, String separator, String indexFormat1, int i, String indentStr) {
        if (!this.textTable.separatorPolicies.isEmpty() && this.textTable.hasSeparatorAt(i) || this.tableModel instanceof TextTableModel && ((TextTableModel)this.tableModel).addSeparatorAt(i)) {
            this.indentAccordingToNumbering(ps, indexFormat1);
            ps.print(indentStr);
            ps.println(separator);
        }
    }

    protected boolean modelAllowsNumberingAt(int row) {
        if (row == 8) {
            System.out.print("");
        }
        if (this.tableModel instanceof TextTableModel) {
            TextTableModel ttm = (TextTableModel)this.tableModel;
            return ttm.allowNumberingAt(row);
        }
        return this.textTable.addRowNumbering;
    }

    protected void printValue(PrintStream ps, int row, int col, boolean empty) {
        int rowIndex = row;
        Object val = this.tableModel.getValueAt(rowIndex, col);
        if (val == null && !this.showNulls) {
            val = "";
        }
        Object value = empty ? "" : val;
        ps.printf(this.formats[col], value);
    }

    private int resolveFormats() {
        int totLength = 0;
        this.formats = new String[this.lengths.length];
        for (int i = 0; i < this.lengths.length; ++i) {
            StringBuilder sb = new StringBuilder();
            if (i == 0) {
                sb.append("|");
            }
            sb.append(" %1$-");
            sb.append(this.lengths[i]);
            sb.append("s|");
            sb.append(i + 1 == this.lengths.length ? "\n" : "");
            this.formats[i] = sb.toString();
            totLength += this.lengths[i];
        }
        return totLength;
    }

    private void indentAccordingToNumbering(PrintStream ps, String indexFormat1) {
        if (this.textTable.addRowNumbering) {
            ps.printf(indexFormat1, "");
        }
    }

    @Override
    public void render(Writer w, int indent) {
        throw new UnsupportedOperationException();
    }
}

