/*
 * Decompiled with CFR 0.152.
 */
package gestioneFatture;

import gestioneFatture.Db;
import gestioneFatture.DbChanges;
import gestioneFatture.dbDocumento;
import gestioneFatture.main;
import it.tnx.Util;
import it.tnx.commons.CastUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.FileUtils;
import it.tnx.commons.MicroBench;
import it.tnx.commons.RunnableWithArgs;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.SystemUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.invoicex.DbVersionChanges;
import it.tnx.invoicex.InvoicexUtil;
import it.tnx.invoicex.sync.Sync;
import it.tnx.shell.CurrentDir;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DbChanges2 {
    Statement statLog = null;
    public List logs = null;
    Integer max = null;
    List<Map> aggs = new ArrayList<Map>();
    boolean exist_ricevute = true;
    String nome_ricevute = "_ricevute";
    String testate_ricevute = "fatture_ricevute_teste";

    public DbChanges2() {
        try {
            this.checkLogExtra();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.statLog = it.tnx.Db.getConn().createStatement();
            this.logs = DbUtils.getList((Connection)it.tnx.Db.getConn(), (String)"select cast(concat(id_log,'|',IFNULL(id_plugin,''),'|',id_email) as CHAR) as mykey from log2");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (DbUtils.existTable((Connection)it.tnx.Db.getConn(), (String)"righ_fatt_acquisto")) {
                this.exist_ricevute = false;
                this.nome_ricevute = "_acquisto";
                this.testate_ricevute = "test_fatt_acquisto";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkLogExtra() {
        try {
            ArrayList log2 = DbUtils.getListMap((Connection)it.tnx.Db.getConn(), (String)"select * from log2");
        }
        catch (Exception ex) {
            System.out.println("log2 non esiste");
            this.creaLog2();
        }
    }

    private void creaLog2() {
        String sql = "create TABLE log2 (`id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,  `id_log` INTEGER UNSIGNED NOT NULL,  `id_plugin` VARCHAR(45),  `id_email` VARCHAR(45) NOT NULL,  `data` TIMESTAMP NOT NULL default current_timestamp,  `note` VARCHAR(45) ) ENGINE=MyISAM";
        System.out.println("sql = " + sql);
        String sql2 = "alter table log2 ADD UNIQUE INDEX `Index_2`(`id_log`, `id_email`, `id_plugin`);";
        System.out.println("sql2 = " + sql2);
        try {
            DbUtils.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)sql);
            DbUtils.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)sql2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean agg(int id_log, String id_plugin, String id_email, String sql, String note) {
        return this.agg(id_log, id_plugin, id_email, sql, note, false);
    }

    private boolean agg(int id_log, String id_plugin, String id_email, String sql, String note, boolean scriviOkComunque) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("id_log", id_log);
        m.put("id_plugin", id_plugin);
        m.put("id_email", id_email);
        m.put("sql", sql);
        m.put("note", note);
        m.put("okcomunque", scriviOkComunque);
        this.aggs.add(m);
        this.max = this.aggs.size();
        return true;
    }

    private void esegui_aggs() {
        int i = 0;
        for (Map m : this.aggs) {
            ++i;
            int id_log = (Integer)m.get("id_log");
            String id_plugin = (String)m.get("id_plugin");
            String id_email = (String)m.get("id_email");
            String sql = (String)m.get("sql");
            String note = (String)m.get("note");
            boolean okcomunque = (Boolean)m.get("okcomunque");
            main.splash("aggiornamenti struttura database: [2/2] " + i + "/" + this.max, 50 + i * 25 / this.max);
            if (id_plugin == null) {
                id_plugin = "";
            }
            this.pre_check(id_log, id_plugin, id_email);
            if (sql.toLowerCase().startsWith("insert ")) {
                okcomunque = true;
            }
            if (!this.checkLog(id_log, id_plugin, id_email)) {
                this.post_check(id_log, id_plugin, id_email);
                try {
                    if (it.tnx.Db.executeSql(sql)) {
                        this.post_execute_ok(id_log, id_plugin, id_email, sql);
                        this.writeLog(id_log, id_plugin, id_email, note);
                        continue;
                    }
                    if (okcomunque) {
                        this.writeLog(id_log, id_plugin, id_email, note);
                    }
                    this.post_execute_ko(id_log, id_plugin, id_email, sql);
                    System.out.println("!!! Errore in agg. db !!! " + id_log + "," + id_plugin + "," + id_email + ", sql: " + sql);
                }
                catch (Exception err) {
                    err.printStackTrace();
                    if (okcomunque) {
                        this.writeLog(id_log, id_plugin, id_email, note);
                    }
                    this.post_execute_ko(id_log, id_plugin, id_email, sql, err);
                    if (err.toString().indexOf("Duplicate column name") >= 0) continue;
                    System.out.println("!!! Errore in agg. db !!! " + id_log + "," + id_plugin + "," + id_email + ", sql: " + sql);
                    err.printStackTrace();
                }
                continue;
            }
            this.post_check_ok(id_log, id_plugin, id_email);
        }
    }

    private boolean aggMysql(int id_log, String id_plugin, String id_email, String sql, String note) {
        if (id_plugin == null) {
            id_plugin = "";
        }
        if (!this.checkLog(id_log, id_plugin, id_email)) {
            try {
                it.tnx.Db.executeSql("USE mysql");
                if (it.tnx.Db.executeSql(sql)) {
                    it.tnx.Db.executeSql("USE " + it.tnx.Db.dbNameDB);
                    this.writeLog(id_log, id_plugin, id_email, note);
                } else {
                    System.out.println("!!! Errore in agg. db !!!");
                }
                it.tnx.Db.executeSql("USE " + it.tnx.Db.dbNameDB);
            }
            catch (Exception err) {
                it.tnx.Db.executeSql("USE " + it.tnx.Db.dbNameDB);
                if (err.toString().indexOf("Duplicate column name") >= 0) {
                    return true;
                }
                System.out.println("!!! Errore in agg. db !!!");
                err.printStackTrace();
                return false;
            }
        }
        return true;
    }

    boolean writeLog(String fileName, String desc) {
        try {
            DataOutputStream outFile = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
            outFile.writeBytes(desc + "\r\n");
            outFile.writeBytes("ok");
            outFile.close();
            return true;
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    boolean writeLog(int id_log, String id_plugin, String id_email, String desc) {
        try {
            this.statLog.execute("insert into log2 (id_log, id_plugin, id_email, note) values (" + id_log + "," + it.tnx.Db.pc(id_plugin, "VARCHAR") + "," + it.tnx.Db.pc(id_email, "VARCHAR") + "," + it.tnx.Db.pc(desc, "VARCHAR") + ")");
            return true;
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    boolean checkLog(int id_log, String id_plugin, String id_email) {
        return this.logs.contains(id_log + "|" + id_plugin + "|" + id_email);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readfrom(String string) {
        InputStream is = null;
        try {
            is = DbChanges.class.getResourceAsStream("/it/tnx/invoicex/res/" + string);
            String string2 = FileUtils.readContent((InputStream)is);
            return string2;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void esegui_aggiornamenti() {
        MicroBench mb;
        block131: {
            mb = new MicroBench();
            mb.start();
            System.out.println("inizio controllo aggiornamenti db log2 " + this.getClass().toString());
            try {
                boolean ancorarunning;
                block130: {
                    long temposecondi;
                    Map running = (Map)dbu.getListMap((Connection)it.tnx.Db.getConn(), (String)"select *, now() as adesso from log2_running").get(0);
                    System.out.println("running = " + running);
                    ancorarunning = true;
                    do {
                        String chi = cu.s(running.get("chi"));
                        Date adessoserver = cu.toDate(running.get("adesso"));
                        Date quando = cu.toDate(running.get("quando"));
                        temposecondi = (adessoserver.getTime() - quando.getTime()) / 1000L;
                        main.splash("attendo aggiornamento db da altra postazione (" + temposecondi + " sec, " + chi + ")", true);
                        Thread.sleep(1000L);
                        try {
                            ArrayList listrunning = dbu.getListMap((Connection)it.tnx.Db.getConn(), (String)"select *, now() as adesso from log2_running");
                            System.out.println("attesa listrunning = " + listrunning);
                            if (listrunning.size() != 0) {
                                running = (Map)listrunning.get(0);
                                continue;
                            }
                            break block130;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } while (temposecondi <= 180L);
                    ancorarunning = true;
                }
                if (ancorarunning) {
                    System.out.println("*** log2_running ancorarunning : true ***");
                    try {
                        String sqlrun = "delete from log2_running";
                        dbu.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)sqlrun);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        SwingUtils.showExceptionMessage((Component)main.splash, (Exception)e);
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof IndexOutOfBoundsException) break block131;
                if (e instanceof SQLException) {
                    SQLException sqle = (SQLException)e;
                    System.out.println(sqle.getErrorCode() + " - " + sqle.getSQLState());
                    if (sqle.getErrorCode() == 1146) {
                        String sqlcreate = "CREATE TABLE `log2_running` (\n\t`chi` VARCHAR(100) NOT NULL,\n\t`quando` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,\n\tPRIMARY KEY (`chi`)\n) ENGINE=MyISAM";
                        try {
                            dbu.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)sqlcreate);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                            SwingUtils.showExceptionMessage((Component)main.splash, (Exception)e2);
                        }
                    }
                }
                e.printStackTrace();
            }
        }
        try {
            String hostname = SystemUtils.getHostname();
            System.out.println("hostname = " + hostname);
            String sqlrun = "insert into log2_running set chi = " + dbu.sql((Object)hostname);
            dbu.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)sqlrun);
        }
        catch (Exception e) {
            e.printStackTrace();
            SwingUtils.showExceptionMessage((Component)main.splash, (Exception)e);
        }
        try {
            int id;
            String sql;
            block133: {
                this.agg(1, "", "m.ceccarelli@tnx.it", DbChanges2.readfrom("agg_1_mc.sql"), "nuove tabelle per ordini acquisto");
                this.agg(2, "", "m.ceccarelli@tnx.it", DbChanges2.readfrom("agg_2_mc.sql"), "nuove tabelle per ordini acquisto - righe");
                this.agg(3, "", "m.ceccarelli@tnx.it", "alter table login modify column username varchar(250)", "username piccolo soprattutto su mac");
                this.agg(4, "", "m.ceccarelli@tnx.it", "alter table righ_ddt_temp modify column username varchar(250)", "username piccolo soprattutto su mac");
                this.agg(5, "", "m.ceccarelli@tnx.it", "alter table righ_fatt" + this.nome_ricevute + "_temp modify column username varchar(250)", "username piccolo soprattutto su mac");
                this.agg(6, "", "m.ceccarelli@tnx.it", "alter table righ_fatt_temp modify column username varchar(250)", "username piccolo soprattutto su mac");
                this.agg(7, "", "m.ceccarelli@tnx.it", "alter table righ_ordi_acquisto_temp modify column username varchar(250)", "username piccolo soprattutto su mac");
                this.agg(8, "", "m.ceccarelli@tnx.it", "alter table righ_ordi_temp modify column username varchar(250)", "username piccolo soprattutto su mac");
                this.agg(9, "", "m.ceccarelli@tnx.it", "alter table scadenze_sel modify column username varchar(250)", "username piccolo soprattutto su mac");
                this.agg(10, "", "m.ceccarelli@tnx.it", "alter table righ_ordi_acquisto add column quantita_evasa DECIMAL(8,2) NULL DEFAULT NULL", "qta evasa su ordini acquisto");
                this.agg(11, "", "m.ceccarelli@tnx.it", "alter table righ_ordi add column quantita_evasa DECIMAL(8,2) NULL DEFAULT NULL", "qta evasa su ordini");
                this.agg(12, "", "m.ceccarelli@tnx.it", "alter table test_ordi_acquisto add column evaso CHAR(1) NULL DEFAULT NULL", "ordine acq evaso");
                this.agg(13, "", "m.ceccarelli@tnx.it", "alter table test_ordi add column evaso CHAR(1) NULL DEFAULT NULL", "ordine evaso");
                this.agg(14, "", "m.ceccarelli@tnx.it", DbChanges2.readfrom("agg_14_mc.sql"), "nuove tabelle per ddt acquisto");
                this.agg(15, "", "m.ceccarelli@tnx.it", DbChanges2.readfrom("agg_15_mc.sql"), "nuove tabelle per ddt acquisto");
                this.agg(16, "", "m.ceccarelli@tnx.it", DbChanges2.readfrom("agg_16_mc.sql"), "nuove tabelle per ddt acquisto");
                this.agg(17, "", "m.ceccarelli@tnx.it", DbChanges2.readfrom("agg_17_mc.sql"), "nuove tabelle per ddt acquisto");
                this.agg18();
                this.agg(19, "", "m.ceccarelli@tnx.it", "alter table " + this.testate_ricevute + " add tipo_fattura TINYINT(4) NULL DEFAULT NULL;", "conf ddt acq");
                this.agg(20, "", "m.ceccarelli@tnx.it", "alter table " + this.testate_ricevute + " add codice_listino TINYINT(3) UNSIGNED NULL DEFAULT '1';", "conf ddt acq");
                this.agg(21, "", "m.ceccarelli@tnx.it", "alter table " + this.testate_ricevute + " add banca_iban VARCHAR(100) NULL DEFAULT NULL;", "conf ddt acq");
                this.agg(22, "", "m.ceccarelli@tnx.it", "alter table " + this.testate_ricevute + " add banca_abi VARCHAR(5) NULL DEFAULT NULL", "conf ddt acq");
                this.agg(23, "", "m.ceccarelli@tnx.it", "alter table " + this.testate_ricevute + " add banca_cab VARCHAR(5) NULL DEFAULT NULL", "conf ddt acq");
                this.agg(24, "", "m.ceccarelli@tnx.it", "alter table " + this.testate_ricevute + " add banca_cc VARCHAR(35) NULL DEFAULT NULL", "conf ddt acq");
                this.agg(25, "", "m.ceccarelli@tnx.it", "alter table " + this.testate_ricevute + " add note_pagamento TEXT NULL", "conf ddt acq");
                this.agg(26, "", "m.ceccarelli@tnx.it", "alter table righ_ordi add in_ddt INT NULL", "campi per giac. virtuale");
                this.agg(27, "", "m.ceccarelli@tnx.it", "alter table righ_ordi add in_fatt INT NULL", "campi per giac. virtuale");
                this.agg(28, "", "m.ceccarelli@tnx.it", "alter table righ_ddt add da_ordi INT NULL", "campi per giac. virtuale");
                this.agg(29, "", "m.ceccarelli@tnx.it", "alter table righ_ddt add in_fatt INT NULL", "campi per giac. virtuale");
                this.agg(30, "", "m.ceccarelli@tnx.it", "alter table righ_fatt add da_ordi INT NULL", "campi per giac. virtuale");
                this.agg(31, "", "m.ceccarelli@tnx.it", "alter table righ_fatt add da_ddt INT NULL", "campi per giac. virtuale");
                this.agg(32, "", "m.ceccarelli@tnx.it", "alter table righ_ordi_acquisto add in_ddt INT NULL", "campi per giac. virtuale");
                this.agg(33, "", "m.ceccarelli@tnx.it", "alter table righ_ordi_acquisto add in_fatt INT NULL", "campi per giac. virtuale");
                this.agg(34, "", "m.ceccarelli@tnx.it", "alter table righ_ddt_acquisto add da_ordi INT NULL", "campi per giac. virtuale");
                this.agg(35, "", "m.ceccarelli@tnx.it", "alter table righ_ddt_acquisto add in_fatt INT NULL", "campi per giac. virtuale");
                this.agg(36, "", "m.ceccarelli@tnx.it", "alter table righ_fatt" + this.nome_ricevute + " add da_ordi INT NULL", "campi per giac. virtuale");
                this.agg(37, "", "m.ceccarelli@tnx.it", "alter table righ_fatt" + this.nome_ricevute + " add da_ddt INT NULL", "campi per giac. virtuale");
                this.agg(38, "", "m.ceccarelli@tnx.it", "alter table righ_ordi add in_ddt_riga INT NULL", "campi per giac. virtuale");
                this.agg(39, "", "m.ceccarelli@tnx.it", "alter table righ_ordi add in_fatt_riga INT NULL", "campi per giac. virtuale");
                this.agg(40, "", "m.ceccarelli@tnx.it", "alter table righ_ddt add da_ordi_riga INT NULL", "campi per giac. virtuale");
                this.agg(41, "", "m.ceccarelli@tnx.it", "alter table righ_ddt add in_fatt_riga INT NULL", "campi per giac. virtuale");
                this.agg(42, "", "m.ceccarelli@tnx.it", "alter table righ_fatt add da_ordi_riga INT NULL", "campi per giac. virtuale");
                this.agg(43, "", "m.ceccarelli@tnx.it", "alter table righ_fatt add da_ddt_riga INT NULL", "campi per giac. virtuale");
                this.agg(44, "", "m.ceccarelli@tnx.it", "alter table righ_ordi_acquisto add in_ddt_riga INT NULL", "campi per giac. virtuale");
                this.agg(45, "", "m.ceccarelli@tnx.it", "alter table righ_ordi_acquisto add in_fatt_riga INT NULL", "campi per giac. virtuale");
                this.agg(46, "", "m.ceccarelli@tnx.it", "alter table righ_ddt_acquisto add da_ordi_riga INT NULL", "campi per giac. virtuale");
                this.agg(47, "", "m.ceccarelli@tnx.it", "alter table righ_ddt_acquisto add in_fatt_riga INT NULL", "campi per giac. virtuale");
                this.agg(48, "", "m.ceccarelli@tnx.it", "alter table righ_fatt" + this.nome_ricevute + " add da_ordi_riga INT NULL", "campi per giac. virtuale");
                this.agg(49, "", "m.ceccarelli@tnx.it", "alter table righ_fatt" + this.nome_ricevute + " add da_ddt_riga INT NULL", "campi per giac. virtuale");
                this.agg(50, "", "m.ceccarelli@tnx.it", "alter table test_ordi add convertito VARCHAR(250) NULL", "conversione multipla");
                this.agg(51, "", "m.ceccarelli@tnx.it", "alter table test_ddt add convertito VARCHAR(250) NULL", "conversione multipla");
                this.agg(52, "", "m.ceccarelli@tnx.it", "alter table test_ordi_acquisto add convertito VARCHAR(250) NULL", "conversione multipla");
                this.agg(53, "", "m.ceccarelli@tnx.it", "alter table test_ddt_acquisto add convertito VARCHAR(250) NULL", "conversione multipla");
                this.agg(54, "", "m.ceccarelli@tnx.it", "alter table righ_ddt_acquisto add column quantita_evasa DECIMAL(8,2) NULL DEFAULT NULL", "qta evasa su ddt acquisto");
                this.agg(55, "", "m.ceccarelli@tnx.it", "alter table righ_ddt add column quantita_evasa DECIMAL(8,2) NULL DEFAULT NULL", "qta evasa su ddt");
                this.agg(56, "", "m.ceccarelli@tnx.it", "alter table test_ddt_acquisto add column evaso CHAR(1) NULL DEFAULT NULL", "ddt acq evaso");
                this.agg(57, "", "m.ceccarelli@tnx.it", "alter table test_ddt add column evaso CHAR(1) NULL DEFAULT NULL", "ddt evaso");
                this.agg(58, "", "m.ceccarelli@tnx.it", "update test_ordi set evaso = 'S' where IFNULL(doc_tipo,'') != ''", "evasione");
                this.agg(59, "", "m.ceccarelli@tnx.it", "update test_ordi t, righ_ordi r set r.quantita_evasa = quantita where r.id_padre = t.id and IFNULL(t.doc_tipo,'') != ''", "evasione");
                this.agg(60, "", "m.ceccarelli@tnx.it", "update test_ddt set evaso = 'S' where IFNULL(fattura_numero,'') != ''", "evasione");
                this.agg(61, "", "m.ceccarelli@tnx.it", "update test_ddt t, righ_ddt r set r.quantita_evasa = quantita where r.id_padre = t.id and IFNULL(t.fattura_numero,'') != ''", "evasione");
                this.agg(62, "", "a.toce@tnx.it", "alter table righ_fatt" + this.nome_ricevute + " add column iva_deducibile DOUBLE(5,2) NOT NULL DEFAULT 100.00", "iva deducibile su riga fatture acquisto");
                this.agg(63, "", "a.toce@tnx.it", "alter table stampa_iva_semplice add column imp_deducibile DOUBLE(15,5) NULL DEFAULT NULL", "imponibile deducibile su stampa registro iva");
                this.agg(64, "", "a.toce@tnx.it", "alter table stampa_iva_semplice add column iva_deducibile DOUBLE(15,5) NULL DEFAULT NULL", "imponibile deducibile su stampa registro iva");
                this.agg(62, "", "m.ceccarelli@tnx.it", "alter table scadenze_parziali add tipo_pagamento varchar(35) NULL", "scadenze parziali client manager");
                this.agg(63, "", "m.ceccarelli@tnx.it", "alter table scadenze_parziali add note TEXT NULL", "scadenze parziali client manager");
                boolean mysqlproc = false;
                try {
                    if (DbUtils.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)"select * from mysql.proc limit 0")) {
                        mysqlproc = true;
                    }
                }
                catch (Exception sqlrun) {
                    // empty catch block
                }
                if (!mysqlproc) {
                    this.aggMysql(64, "", "m.ceccarelli@tnx.it", DbChanges2.readfrom("mysql_fix_privilege_tables.sql"), "aggiornamento tabelle mysql");
                }
                this.agg(67, "", "m.ceccarelli@tnx.it", "alter table temp_stampa_stat_ord_bol_fat add qta DECIMAL(15,5) NULL", "qta in statistiche");
                this.agg(67, "", "a.toce@tnx.it", "CREATE TABLE IF NOT EXISTS categorie (`id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY) ENGINE=MyISAM", "Creata tabella categorie per evitare errori");
                this.agg(68, "", "m.ceccarelli@tnx.it", "ALTER TABLE categorie ADD COLUMN descrizione VARCHAR(250) NULL DEFAULT NULL, ADD COLUMN id_padre INT(11) NULL DEFAULT NULL, ADD COLUMN livello INT(11) NULL DEFAULT NULL", "categorie");
                this.agg(69, "", "m.ceccarelli@tnx.it", "alter table articoli add cat1 INT NULL, add cat2 INT NULL, add cat3 INT NULL, add cat4 INT NULL, add cat5 INT NULL", "categorie");
                this.agg(70, "", "m.ceccarelli@tnx.it", "alter table articoli add modalita_vendita varchar(250) NULL, add dimensioni varchar(250) NULL, add colore varchar(250) NULL", "caratteristiche articoli");
                this.agg(71, "", "m.ceccarelli@tnx.it", "alter table articoli CHANGE COLUMN um_eng um_en CHAR(3) NULL DEFAULT NULL, CHANGE COLUMN descrizione_eng descrizione_en VARCHAR(255) NULL DEFAULT NULL", "internaz");
                this.agg(72, "", "m.ceccarelli@tnx.it", "alter table categorie add descrizione_en VARCHAR(250) NULL after descrizione, add descrizione_fr VARCHAR(250) after descrizione", "categorie");
                this.agg(73, "", "m.ceccarelli@tnx.it", "ALTER TABLE categorie ADD COLUMN immagine1 varchar(250) default ''", "articoli immagine");
                this.agg(74, "", "m.ceccarelli@tnx.it", "ALTER TABLE articoli ADD COLUMN visibile_online char(1) DEFAULT 'S'", "articoli");
                this.agg(75, "", "m.ceccarelli@tnx.it", "ALTER TABLE articoli ADD COLUMN codice_fornitore2 varchar(100) DEFAULT ''", "articoli codice fornitore");
                this.agg(76, "", "m.ceccarelli@tnx.it", "ALTER TABLE articoli ADD COLUMN codice_fornitore3 varchar(100) DEFAULT ''", "articoli codice fornitore");
                this.agg(77, "", "m.ceccarelli@tnx.it", "ALTER TABLE articoli ADD COLUMN codice_fornitore4 varchar(100) DEFAULT ''", "articoli codice fornitore");
                this.agg(78, "", "m.ceccarelli@tnx.it", "ALTER TABLE articoli ADD COLUMN codice_fornitore5 varchar(100) DEFAULT ''", "articoli codice fornitore");
                this.agg(75, "", "a.toce@tnx.it", "ALTER TABLE test_ordi ADD COLUMN id_ordine_ipsoa INT NULL DEFAULT NULL", "ordine ipsoa");
                this.agg(76, "", "a.toce@tnx.it", "ALTER TABLE clie_forn ADD COLUMN perc_sconto DECIMAL(5,2) NULL DEFAULT NULL", "percentuale di sconto prefissata");
                this.agg(77, "", "a.toce@tnx.it", "ALTER TABLE clie_forn ADD COLUMN flag_email INT NOT NULL DEFAULT 0", "flag per ricezione email");
                this.agg(78, "", "a.toce@tnx.it", "ALTER TABLE clie_forn ADD COLUMN id_cliente_ipsoa INT NULL DEFAULT NULL", "id cliente per import ipsoa");
                this.agg(79, "", "m.ceccarelli@tnx.it", "ALTER TABLE articoli ADD COLUMN codice_fornitore6 varchar(100) DEFAULT ''", "articoli codice fornitore");
                this.agg(80, "", "m.ceccarelli@tnx.it", "ALTER TABLE articoli ADD INDEX index_codice_fornitore2(codice_fornitore2)", "articoli indice codice fornitore");
                this.agg(81, "", "m.ceccarelli@tnx.it", "ALTER TABLE articoli ADD INDEX index_codice_fornitore3(codice_fornitore3)", "articoli indice codice fornitore");
                this.agg(82, "", "m.ceccarelli@tnx.it", "ALTER TABLE articoli ADD INDEX index_codice_fornitore4(codice_fornitore4)", "articoli indice codice fornitore");
                this.agg(83, "", "m.ceccarelli@tnx.it", "ALTER TABLE articoli ADD INDEX index_codice_fornitore5(codice_fornitore5)", "articoli indice codice fornitore");
                this.agg(84, "", "m.ceccarelli@tnx.it", "ALTER TABLE articoli ADD INDEX index_codice_fornitore6(codice_fornitore6)", "articoli indice codice fornitore");
                this.agg(85, "", "m.ceccarelli@tnx.it", "ALTER TABLE articoli ADD posizione_magazzino varchar(250)", "articoli posizione magazzino");
                this.agg(86, "", "m.ceccarelli@tnx.it", "alter table righ_fatt add column iva_deducibile DOUBLE(5,2) NOT NULL DEFAULT 100.00", "iva deducibile su altre tabelle");
                this.agg(87, "", "m.ceccarelli@tnx.it", "alter table righ_ddt add column iva_deducibile DOUBLE(5,2) NOT NULL DEFAULT 100.00", "iva deducibile su altre tabelle");
                this.agg(88, "", "m.ceccarelli@tnx.it", "alter table righ_ddt_acquisto add column iva_deducibile DOUBLE(5,2) NOT NULL DEFAULT 100.00", "iva deducibile su altre tabelle");
                this.agg(89, "", "m.ceccarelli@tnx.it", "alter table righ_ordi add column iva_deducibile DOUBLE(5,2) NOT NULL DEFAULT 100.00", "iva deducibile su altre tabelle");
                this.agg(90, "", "m.ceccarelli@tnx.it", "alter table righ_ordi_acquisto add column iva_deducibile DOUBLE(5,2) NOT NULL DEFAULT 100.00", "iva deducibile su altre tabelle");
                if (this.exist_ricevute) {
                    this.agg(91, "", "m.ceccarelli@tnx.it", "RENAME TABLE fatture_ricevute_teste TO test_fatt_acquisto", "fatture ricevute test_fatt_acquisto");
                    this.agg(92, "", "m.ceccarelli@tnx.it", "RENAME TABLE righ_fatt_ricevute TO righ_fatt_acquisto", "fatture ricevute test_fatt_acquisto");
                    this.agg(93, "", "m.ceccarelli@tnx.it", "RENAME TABLE righ_fatt_ricevute_temp TO righ_fatt_acquisto_temp", "fatture ricevute test_fatt_acquisto");
                    this.agg(94, "", "m.ceccarelli@tnx.it", "RENAME TABLE righ_fatt_ricevute_lotti TO righ_fatt_acquisto_lotti", "fatture ricevute test_fatt_acquisto");
                    this.agg(95, "", "m.ceccarelli@tnx.it", "RENAME TABLE righ_fatt_ricevute_matricole TO righ_fatt_acquisto_matricole", "fatture ricevute test_fatt_acquisto");
                }
                this.agg(96, "", "m.ceccarelli@tnx.it", "update movimenti_magazzino set da_tabella = 'test_fatt_acquisto' where da_tabella = 'test_fatt_ricevute'", "fatture ricevute test_fatt_acquisto");
                this.agg(97, "", "m.ceccarelli@tnx.it", "alter table categorie CHANGE COLUMN descrizione nome VARCHAR(250) NULL, CHANGE COLUMN descrizione_en nome_en VARCHAR(250) NULL, CHANGE COLUMN descrizione_fr nome_fr VARCHAR(250) NULL", "categorie");
                this.agg(98, "", "m.ceccarelli@tnx.it", "alter table categorie add descrizione TEXT NULL, add descrizione_en TEXT NULL, add descrizione_fr TEXT NULL", "categorie");
                this.agg(99, "", "m.ceccarelli@tnx.it", "alter table categorie add visibile_se_registrato CHAR(1) NULL", "categorie");
                this.agg(100, "", "m.ceccarelli@tnx.it", "alter table articoli add visibile_se_registrato CHAR(1) NULL", "articoli web");
                this.agg(101, "", "m.ceccarelli@tnx.it", "ALTER TABLE articoli ADD COLUMN immagine1_web varchar(250) default '' after immagine1", "articoli immagine");
                this.agg(102, "", "a.toce@tnx.it", "ALTER TABLE pagamenti ADD COLUMN id_pagamento_ipsoa INT NULL DEFAULT NULL", "id tipo di pagamento Ipsoa");
                this.agg(103, "", "m.ceccarelli@tnx.it", "alter table righ_fatt_acquisto modify column iva_deducibile DOUBLE(5,2) NULL DEFAULT 100.00", "possibilita di null");
                this.agg(104, "", "m.ceccarelli@tnx.it", "alter table righ_fatt modify column iva_deducibile DOUBLE(5,2) NULL DEFAULT 100.00", "possibilita di null");
                this.agg(105, "", "m.ceccarelli@tnx.it", "alter table righ_ddt modify column iva_deducibile DOUBLE(5,2) NULL DEFAULT 100.00", "possibilita di null");
                this.agg(106, "", "m.ceccarelli@tnx.it", "alter table righ_ddt_acquisto modify column iva_deducibile DOUBLE(5,2) NULL DEFAULT 100.00", "possibilita di null");
                this.agg(107, "", "m.ceccarelli@tnx.it", "alter table righ_ordi modify column iva_deducibile DOUBLE(5,2) NULL DEFAULT 100.00", "possibilita di null");
                this.agg(108, "", "m.ceccarelli@tnx.it", "alter table righ_ordi_acquisto modify column iva_deducibile DOUBLE(5,2) NULL DEFAULT 100.00", "possibilita di null");
                this.agg(109, "", "m.ceccarelli@tnx.it", "update righ_fatt_acquisto set iva_deducibile = null where iva_deducibile = 0", "possibilita di null");
                this.agg(110, "", "m.ceccarelli@tnx.it", "alter table test_ddt add column listino_consigliato varchar(10) null", "listino consigliato");
                this.agg(111, "", "m.ceccarelli@tnx.it", "alter table test_ordi add column listino_consigliato varchar(10) null", "listino consigliato");
                this.agg(112, "", "m.ceccarelli@tnx.it", "alter table test_fatt add column listino_consigliato varchar(10) null", "listino consigliato");
                this.agg(113, "", "m.ceccarelli@tnx.it", "alter table test_ddt_acquisto add column listino_consigliato varchar(10) null", "listino consigliato");
                this.agg(114, "", "m.ceccarelli@tnx.it", "alter table test_ordi_acquisto add column listino_consigliato varchar(10) null", "listino consigliato");
                this.agg(115, "", "m.ceccarelli@tnx.it", "alter table test_fatt_acquisto add column listino_consigliato varchar(10) null", "listino consigliato");
                this.agg(116, "", "a.toce@tnx.it", "ALTER TABLE dati_azienda ADD COLUMN testo_piede_fatt_v TEXT", "Aggiunte note a piede pagina su report fatture vendita");
                this.agg(117, "", "a.toce@tnx.it", "ALTER TABLE dati_azienda ADD COLUMN testo_piede_docu_v TEXT", "Aggiunte note a piede pagina su report ddt vendita");
                this.agg(118, "", "a.toce@tnx.it", "ALTER TABLE dati_azienda ADD COLUMN testo_piede_ordi_v TEXT", "Aggiunte note a piede pagina su report ordini vendita");
                this.agg(119, "", "a.toce@tnx.it", "ALTER TABLE dati_azienda ADD COLUMN testo_piede_fatt_a TEXT", "Aggiunte note a piede pagina su report fatture acquisto");
                this.agg(120, "", "a.toce@tnx.it", "ALTER TABLE dati_azienda ADD COLUMN testo_piede_docu_a TEXT", "Aggiunte note a piede pagina su report ddt acquisto");
                this.agg(121, "", "a.toce@tnx.it", "ALTER TABLE dati_azienda ADD COLUMN testo_piede_ordi_a TEXT", "Aggiunte note a piede pagina su report ordini acquisto");
                this.agg(122, "", "a.toce@tnx.it", "ALTER TABLE dati_azienda ADD COLUMN stampa_riga_invoicex INTEGER NOT NULL DEFAULT 1", "Flag per togliere riga a fondo report");
                this.agg(123, "", "a.toce@tnx.it", "ALTER TABLE dati_azienda ADD COLUMN immagine_firma_ordine MEDIUMBLOB NULL DEFAULT NULL", "Immagine per firma immagine");
                this.agg(126, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `logo_email` mediumblob NULL", "logo email in dati azienda");
                this.agg(127, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `sfondo` mediumblob NULL", "sfondo in dati azienda");
                this.agg(128, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `sfondo_email` mediumblob NULL", "sfondo email in dati azienda");
                this.agg(129, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `logo_nome_file` varchar(250) NULL", "logo");
                this.agg(130, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `logo_data_modifica` bigint NULL", "logo");
                this.agg(131, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `logo_dimensione` bigint NULL", "logo");
                this.agg(132, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `logo_email_nome_file` varchar(250) NULL", "logo");
                this.agg(133, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `logo_email_data_modifica` bigint NULL", "logo");
                this.agg(134, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `logo_email_dimensione` bigint NULL", "logo");
                this.agg(135, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `sfondo_nome_file` varchar(250) NULL", "sfondo");
                this.agg(136, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `sfondo_data_modifica` bigint NULL", "sfondo");
                this.agg(137, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `sfondo_dimensione` bigint NULL", "sfondo");
                this.agg(138, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `sfondo_email_nome_file` varchar(250) NULL", "sfondo");
                this.agg(139, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `sfondo_email_data_modifica` bigint NULL", "sfondo");
                this.agg(140, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `sfondo_email_dimensione` bigint NULL", "sfondo");
                this.agg(141, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `logo_in_db` char(1) NULL", "sfondo");
                this.agg(142, "", "a.toce@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `label_cliente` VARCHAR(100) DEFAULT 'Cliente'", "Etichetta cliente");
                this.agg(143, "", "a.toce@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `label_destinazione` VARCHAR(100) DEFAULT 'Destinazione Merce'", "Etichetta destinazione");
                this.agg(142, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` drop primary key", "dati azienda pk", true);
                this.agg(143, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` CHANGE COLUMN `id` `id` INT(11) NULL AUTO_INCREMENT,  ADD PRIMARY KEY (`id`)", "dati azienda pk", true);
                this.agg(144, "", "a.toce@tnx.it", "ALTER TABLE `clie_forn` ADD COLUMN `flag_update_listino` CHAR NOT NULL DEFAULT 'N'", "Aggiunto flag per aggiornamento automatico listino");
                this.agg(144, "", "m.ceccarelli@tnx.it", "ALTER TABLE `pagamenti` add COLUMN `iva30gg` char(1) NULL default 'N'", "iva30gg su pagamenti");
                this.agg(145, "", "m.ceccarelli@tnx.it", "update tipi_fatture set descrizione = 'FATTURA' where descrizione_breve = 'FI'", "tolto immediata da fattura");
                this.agg(145, "", "a.toce@tnx.it", "ALTER TABLE `test_fatt` ADD COLUMN `color` VARCHAR(20) DEFAULT ''", "Aggiunta colonna per segnalazione colore");
                this.agg(146, "", "a.toce@tnx.it", "ALTER TABLE `righ_fatt` ADD COLUMN `arrotondamento_parametro` VARCHAR(4) DEFAULT '0'", "Aggiunta colonna per salvataggio parametro di arrotondamento su righe fattura");
                this.agg(147, "", "a.toce@tnx.it", "ALTER TABLE `righ_fatt` ADD COLUMN `arrotondamento_tipo` VARCHAR(4) DEFAULT ''", "Aggiunta colonna per salvataggio tipo di arrotondamento su righe fattura");
                this.agg(148, "", "a.toce@tnx.it", "ALTER TABLE `righ_fatt` ADD COLUMN `totale_ivato` DECIMAL(15,5) NOT NULL DEFAULT '0.00000'", "Aggiunto totale iva arrotondato su righe fattura");
                this.agg(149, "", "a.toce@tnx.it", "ALTER TABLE `righ_fatt` ADD COLUMN `totale_imponibile` DECIMAL(15,5) NOT NULL DEFAULT '0.00000'", "Aggiunto totale iva arrotondato su righe fattura");
                this.agg(150, "", "a.toce@tnx.it", "ALTER TABLE `righ_ordi` ADD COLUMN `arrotondamento_parametro` VARCHAR(4) DEFAULT '0'", "Aggiunta colonna per salvataggio parametro di arrotondamento su righe ordini");
                this.agg(151, "", "a.toce@tnx.it", "ALTER TABLE `righ_ordi` ADD COLUMN `arrotondamento_tipo` VARCHAR(4) DEFAULT ''", "Aggiunta colonna per salvataggio tipo di arrotondamento su righe ordini");
                this.agg(152, "", "a.toce@tnx.it", "ALTER TABLE `righ_ordi` ADD COLUMN `totale_ivato` DECIMAL(15,5) NOT NULL DEFAULT '0.00000'", "Aggiunto totale iva arrotondato su righe ordini");
                this.agg(153, "", "a.toce@tnx.it", "ALTER TABLE `righ_ordi` ADD COLUMN `totale_imponibile` DECIMAL(15,5) NOT NULL DEFAULT '0.00000'", "Aggiunto totale iva arrotondato su righe ordini");
                this.agg(154, "", "a.toce@tnx.it", "ALTER TABLE `righ_ddt` ADD COLUMN `arrotondamento_parametro` VARCHAR(4) DEFAULT '0'", "Aggiunta colonna per salvataggio parametro di arrotondamento su righe ddt");
                this.agg(155, "", "a.toce@tnx.it", "ALTER TABLE `righ_ddt` ADD COLUMN `arrotondamento_tipo` VARCHAR(4) DEFAULT ''", "Aggiunta colonna per salvataggio tipo di arrotondamento su righe ddt");
                this.agg(156, "", "a.toce@tnx.it", "ALTER TABLE `righ_ddt` ADD COLUMN `totale_ivato` DECIMAL(15,5) NOT NULL DEFAULT '0.00000'", "Aggiunto totale iva arrotondato su righe ddt");
                this.agg(157, "", "a.toce@tnx.it", "ALTER TABLE `righ_ddt` ADD COLUMN `totale_imponibile` DECIMAL(15,5) NOT NULL DEFAULT '0.00000'", "Aggiunto totale iva arrotondato su righe ddt");
                this.agg(158, "", "a.toce@tnx.it", "ALTER TABLE `righ_fatt_acquisto` ADD COLUMN `arrotondamento_parametro` VARCHAR(4) DEFAULT '0'", "Aggiunta colonna per salvataggio parametro di arrotondamento su righe fattura_acquisto");
                this.agg(159, "", "a.toce@tnx.it", "ALTER TABLE `righ_fatt_acquisto` ADD COLUMN `arrotondamento_tipo` VARCHAR(4) DEFAULT ''", "Aggiunta colonna per salvataggio tipo di arrotondamento su righe fattura_acquisto");
                this.agg(160, "", "a.toce@tnx.it", "ALTER TABLE `righ_fatt_acquisto` ADD COLUMN `totale_ivato` DECIMAL(15,5) NOT NULL DEFAULT '0.00000'", "Aggiunto totale iva arrotondato su righe fattura_acquisto");
                this.agg(161, "", "a.toce@tnx.it", "ALTER TABLE `righ_fatt_acquisto` ADD COLUMN `totale_imponibile` DECIMAL(15,5) NOT NULL DEFAULT '0.00000'", "Aggiunto totale iva arrotondato su righe fattura_acquisto");
                this.agg(162, "", "a.toce@tnx.it", "ALTER TABLE `righ_ordi_acquisto` ADD COLUMN `arrotondamento_parametro` VARCHAR(4) DEFAULT '0'", "Aggiunta colonna per salvataggio parametro di arrotondamento su righe ordini_acquisto");
                this.agg(163, "", "a.toce@tnx.it", "ALTER TABLE `righ_ordi_acquisto` ADD COLUMN `arrotondamento_tipo` VARCHAR(4) DEFAULT ''", "Aggiunta colonna per salvataggio tipo di arrotondamento su righe ordini_acquisto");
                this.agg(164, "", "a.toce@tnx.it", "ALTER TABLE `righ_ordi_acquisto` ADD COLUMN `totale_ivato` DECIMAL(15,5) NOT NULL DEFAULT '0.00000'", "Aggiunto totale iva arrotondato su righe ordini_acquisto");
                this.agg(165, "", "a.toce@tnx.it", "ALTER TABLE `righ_ordi_acquisto` ADD COLUMN `totale_imponibile` DECIMAL(15,5) NOT NULL DEFAULT '0.00000'", "Aggiunto totale iva arrotondato su righe ordini_acquisto");
                this.agg(166, "", "a.toce@tnx.it", "ALTER TABLE `righ_ddt_acquisto` ADD COLUMN `arrotondamento_parametro` VARCHAR(4) DEFAULT '0'", "Aggiunta colonna per salvataggio parametro di arrotondamento su righe ddt_acquisto");
                this.agg(167, "", "a.toce@tnx.it", "ALTER TABLE `righ_ddt_acquisto` ADD COLUMN `arrotondamento_tipo` VARCHAR(4) DEFAULT ''", "Aggiunta colonna per salvataggio tipo di arrotondamento su righe ddt_acquisto");
                this.agg(168, "", "a.toce@tnx.it", "ALTER TABLE `righ_ddt_acquisto` ADD COLUMN `totale_ivato` DECIMAL(15,5) NOT NULL DEFAULT '0.00000'", "Aggiunto totale iva arrotondato su righe ddt_acquisto");
                this.agg(169, "", "a.toce@tnx.it", "ALTER TABLE `righ_ddt_acquisto` ADD COLUMN `totale_imponibile` DECIMAL(15,5) NOT NULL DEFAULT '0.00000'", "Aggiunto totale iva arrotondato su righe ddt_acquisto");
                this.agg(170, "", "a.toce@tnx.it", "UPDATE righ_fatt set totale_imponibile = CAST(IF(arrotondamento_parametro = '0', (prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - (prezzo*(IFNULL(sconto2, 0.00)/100))) * IFNULL(quantita, 0.00), IF(arrotondamento_tipo = 'Inf.', FLOOR(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - (prezzo*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00), CEIL(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - (prezzo*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00))) AS DECIMAL(10,2))", "Aggiornamento totali imponibili di riga fattura");
                this.agg(171, "", "a.toce@tnx.it", "UPDATE righ_ordi set totale_imponibile = CAST(IF(arrotondamento_parametro = '0', (prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - (prezzo*(IFNULL(sconto2, 0.00)/100))) * IFNULL(quantita, 0.00), IF(arrotondamento_tipo = 'Inf.', FLOOR(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - (prezzo*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00), CEIL(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - (prezzo*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00))) AS DECIMAL(10,2))", "Aggiornamento totali imponibili di riga ordine");
                this.agg(172, "", "a.toce@tnx.it", "UPDATE righ_ordi r LEFT JOIN codici_iva i ON r.iva = i.codice SET totale_ivato = totale_imponibile + (totale_imponibile * i.percentuale/100)", "Aggiornati totali iva righe ordine");
                this.agg(173, "", "a.toce@tnx.it", "UPDATE righ_ddt set totale_imponibile = CAST(IF(arrotondamento_parametro = '0', (prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - (prezzo*(IFNULL(sconto2, 0.00)/100))) * IFNULL(quantita, 0.00), IF(arrotondamento_tipo = 'Inf.', FLOOR(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - (prezzo*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00), CEIL(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - (prezzo*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00))) AS DECIMAL(10,2))", "Aggiornamento totali imponibili di riga ddt");
                this.agg(174, "", "a.toce@tnx.it", "UPDATE righ_ddt r LEFT JOIN codici_iva i ON r.iva = i.codice SET totale_ivato = totale_imponibile + (totale_imponibile * i.percentuale/100)", "Aggiornati totali iva righe ddt");
                this.agg(175, "", "a.toce@tnx.it", "UPDATE righ_fatt_acquisto set totale_imponibile = CAST(IF(arrotondamento_parametro = '0', (prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - (prezzo*(IFNULL(sconto2, 0.00)/100))) * IFNULL(quantita, 0.00), IF(arrotondamento_tipo = 'Inf.', FLOOR(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - (prezzo*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00), CEIL(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - (prezzo*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00))) AS DECIMAL(10,2))", "Aggiornamento totali imponibili di riga fattura acquisto");
                this.agg(176, "", "a.toce@tnx.it", "UPDATE righ_fatt_acquisto r LEFT JOIN codici_iva i ON r.iva = i.codice SET totale_ivato = totale_imponibile + (totale_imponibile * i.percentuale/100)", "Aggiornati totali iva righe fattura acquisto");
                this.agg(177, "", "a.toce@tnx.it", "UPDATE righ_ordi_acquisto set totale_imponibile = CAST(IF(arrotondamento_parametro = '0', (prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - (prezzo*(IFNULL(sconto2, 0.00)/100))) * IFNULL(quantita, 0.00), IF(arrotondamento_tipo = 'Inf.', FLOOR(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - (prezzo*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00), CEIL(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - (prezzo*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00))) AS DECIMAL(10,2))", "Aggiornamento totali imponibili di riga ordine acquisto");
                this.agg(178, "", "a.toce@tnx.it", "UPDATE righ_ordi_acquisto r LEFT JOIN codici_iva i ON r.iva = i.codice SET totale_ivato = totale_imponibile + (totale_imponibile * i.percentuale/100)", "Aggiornati totali iva righe ordine acquisto");
                this.agg(179, "", "a.toce@tnx.it", "UPDATE righ_ddt_acquisto set totale_imponibile = CAST(IF(arrotondamento_parametro = '0', (prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - (prezzo*(IFNULL(sconto2, 0.00)/100))) * IFNULL(quantita, 0.00), IF(arrotondamento_tipo = 'Inf.', FLOOR(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - (prezzo*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00), CEIL(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - (prezzo*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00))) AS DECIMAL(10,2))", "Aggiornamento totali imponibili di riga ddt acquisto");
                this.agg(180, "", "a.toce@tnx.it", "UPDATE righ_ddt_acquisto r LEFT JOIN codici_iva i ON r.iva = i.codice SET totale_ivato = totale_imponibile + (totale_imponibile * i.percentuale/100)", "Aggiornati totali iva righe ddt acquisto");
                this.agg(181, "", "a.toce@tnx.it", "ALTER TABLE articoli ADD COLUMN is_descrizione CHAR NOT NULL DEFAULT 'N'", "Aggiunta colonna per descrizioni in articoli");
                this.agg(182, "", "a.toce@tnx.it", "ALTER TABLE righ_fatt ADD COLUMN is_descrizione CHAR NOT NULL DEFAULT 'N'", "Aggiunta colonna per descrizioni in righe fatture");
                this.agg(183, "", "a.toce@tnx.it", "ALTER TABLE righ_ordi ADD COLUMN is_descrizione CHAR NOT NULL DEFAULT 'N'", "Aggiunta colonna per descrizioni in righe ordini");
                this.agg(184, "", "a.toce@tnx.it", "ALTER TABLE righ_ddt ADD COLUMN is_descrizione CHAR NOT NULL DEFAULT 'N'", "Aggiunta colonna per descrizioni in righe ddt");
                this.agg(185, "", "a.toce@tnx.it", "ALTER TABLE righ_fatt_acquisto ADD COLUMN is_descrizione CHAR NOT NULL DEFAULT 'N'", "Aggiunta colonna per descrizioni in righe fatture di acquistO");
                this.agg(186, "", "a.toce@tnx.it", "ALTER TABLE righ_ordi_acquisto ADD COLUMN is_descrizione CHAR NOT NULL DEFAULT 'N'", "Aggiunta colonna per descrizioni in righe ordini di acquistO");
                this.agg(187, "", "a.toce@tnx.it", "ALTER TABLE righ_ddt_acquisto ADD COLUMN is_descrizione CHAR NOT NULL DEFAULT 'N'", "Aggiunta colonna per descrizioni in righe ddt di acquistO");
                this.agg(188, "", "a.toce@tnx.it", "UPDATE righ_fatt r LEFT JOIN codici_iva i ON r.iva = i.codice SET totale_ivato = totale_imponibile + (totale_imponibile * i.percentuale/100)", "Aggiornati totali iva righe fattura");
                this.agg(146, "", "m.ceccarelli@tnx.it", "alter table movimenti_magazzino add column da_tipo_fattura tinyint", "movimenti magazzino per riconoscere scontrini");
                this.agg(147, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `codiceIvaDefault` VARCHAR(10)", "codiceIvaDefault");
                this.agg(148, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `codiceIvaSpese` VARCHAR(10)", "codiceIvaSpese");
                this.agg(149, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `iva21eseguito` CHAR(1)", "iva21eseguito");
                this.agg(150, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `iva21a20eseguito` CHAR(1)", "iva21a20eseguito");
                String codiceIvaDefault = null;
                String codiceIvaSpese = null;
                try {
                    codiceIvaDefault = main.fileIni.getValue("iva", "codiceIvaDefault", null);
                    codiceIvaSpese = main.fileIni.getValue("iva", "codiceIvaSpese", null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.agg(151, "", "m.ceccarelli@tnx.it", "update dati_azienda set codiceIvaDefault = " + it.tnx.Db.pcs(codiceIvaDefault), "codiceIvaDefault");
                this.agg(152, "", "m.ceccarelli@tnx.it", "update dati_azienda set codiceIvaSpese = " + it.tnx.Db.pcs(codiceIvaSpese), "codiceIvaSpese");
                if (!DbUtils.containRows((Connection)it.tnx.Db.getConn(), (String)"select * from codici_iva where codice = '21'")) {
                    this.agg(153, "", "m.ceccarelli@tnx.it", "insert into codici_iva set codice = '21', percentuale = 21, descrizione = 'Iva 21%', descrizione_breve = 'Iva 21%'", "iva21");
                }
                this.agg(154, "", "m.ceccarelli@tnx.it", "CREATE TABLE versioni_clients (hostname VARCHAR(250) not NULL primary key,versione VARCHAR(20) NULL, pacchetto VARCHAR(100) NULL, tempo TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP) ENGINE=MyISAM", "tabella per versioni clients di invoicex");
                this.agg(155, "", "m.ceccarelli@tnx.it", "ALTER TABLE articoli_prezzi ADD COLUMN sconto1 DECIMAL(5,2) NULL, ADD COLUMN sconto2 DECIMAL(5,2) NULL;", "sconti su articoli");
                this.agg(156, "", "m.ceccarelli@tnx.it", "ALTER TABLE clie_forn ADD COLUMN sconto1t DECIMAL(5,2) NULL, ADD COLUMN sconto2t DECIMAL(5,2) NULL, ADD COLUMN sconto3t DECIMAL(5,2) NULL, ADD COLUMN sconto1r DECIMAL(5,2) NULL, ADD COLUMN sconto2r DECIMAL(5,2) NULL;", "sconti su cliente");
                this.agg(157, "", "m.ceccarelli@tnx.it", "ALTER TABLE articoli ADD INDEX descrizione_25 (descrizione(25))", "indicie su descrizione articoli");
                this.agg(158, "", "m.ceccarelli@tnx.it", "UPDATE righ_fatt set totale_imponibile = ROUND(CAST(  IF(arrotondamento_parametro = '0',  (prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - ((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)))*(IFNULL(sconto2, 0.00)/100))) * IFNULL(quantita, 0.00), IF(arrotondamento_tipo = 'Inf.',   FLOOR(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - ((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)))*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00), CEIL(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - ((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)))*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00))) AS DECIMAL(10,2)),2)", "agg2 totali");
                this.agg(159, "", "m.ceccarelli@tnx.it", "UPDATE righ_ddt set totale_imponibile = ROUND(CAST(  IF(arrotondamento_parametro = '0',  (prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - ((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)))*(IFNULL(sconto2, 0.00)/100))) * IFNULL(quantita, 0.00), IF(arrotondamento_tipo = 'Inf.',   FLOOR(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - ((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)))*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00), CEIL(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - ((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)))*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00))) AS DECIMAL(10,2)),2)", "agg2 totali");
                this.agg(160, "", "m.ceccarelli@tnx.it", "UPDATE righ_ordi set totale_imponibile = ROUND(CAST(  IF(arrotondamento_parametro = '0',  (prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - ((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)))*(IFNULL(sconto2, 0.00)/100))) * IFNULL(quantita, 0.00), IF(arrotondamento_tipo = 'Inf.',   FLOOR(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - ((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)))*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00), CEIL(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - ((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)))*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00))) AS DECIMAL(10,2)),2)", "agg2 totali");
                this.agg(161, "", "m.ceccarelli@tnx.it", "UPDATE righ_fatt_acquisto set totale_imponibile = ROUND(CAST(  IF(arrotondamento_parametro = '0',  (prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - ((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)))*(IFNULL(sconto2, 0.00)/100))) * IFNULL(quantita, 0.00), IF(arrotondamento_tipo = 'Inf.',   FLOOR(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - ((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)))*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00), CEIL(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - ((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)))*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00))) AS DECIMAL(10,2)),2)", "agg2 totali");
                this.agg(162, "", "m.ceccarelli@tnx.it", "UPDATE righ_ddt_acquisto set totale_imponibile = ROUND(CAST(  IF(arrotondamento_parametro = '0',  (prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - ((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)))*(IFNULL(sconto2, 0.00)/100))) * IFNULL(quantita, 0.00), IF(arrotondamento_tipo = 'Inf.',   FLOOR(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - ((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)))*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00), CEIL(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - ((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)))*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00))) AS DECIMAL(10,2)),2)", "agg2 totali");
                this.agg(163, "", "m.ceccarelli@tnx.it", "UPDATE righ_ordi_acquisto set totale_imponibile = ROUND(CAST(  IF(arrotondamento_parametro = '0',  (prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - ((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)))*(IFNULL(sconto2, 0.00)/100))) * IFNULL(quantita, 0.00), IF(arrotondamento_tipo = 'Inf.',   FLOOR(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - ((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)))*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00), CEIL(((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)) - ((prezzo - (prezzo*(IFNULL(sconto1, 0.00)/100)))*(IFNULL(sconto2, 0.00)/100))) )/CAST(arrotondamento_parametro AS DECIMAL(5,2))) * CAST(arrotondamento_parametro AS DECIMAL(5,2)) * IFNULL(quantita, 0.00))) AS DECIMAL(10,2)),2)", "agg2 totali");
                this.agg(164, "", "m.ceccarelli@tnx.it", "UPDATE righ_fatt r LEFT JOIN codici_iva i ON r.iva = i.codice SET totale_ivato = round(totale_imponibile + (totale_imponibile * i.percentuale/100),2)", "agg2 totali righe");
                this.agg(165, "", "m.ceccarelli@tnx.it", "UPDATE righ_ddt r LEFT JOIN codici_iva i ON r.iva = i.codice SET totale_ivato = round(totale_imponibile + (totale_imponibile * i.percentuale/100),2)", "agg2 totali righe");
                this.agg(166, "", "m.ceccarelli@tnx.it", "UPDATE righ_ordi r LEFT JOIN codici_iva i ON r.iva = i.codice SET totale_ivato = round(totale_imponibile + (totale_imponibile * i.percentuale/100),2)", "agg2 totali righe");
                this.agg(167, "", "m.ceccarelli@tnx.it", "UPDATE righ_fatt_acquisto r LEFT JOIN codici_iva i ON r.iva = i.codice SET totale_ivato = round(totale_imponibile + (totale_imponibile * i.percentuale/100),2)", "agg2 totali righe");
                this.agg(168, "", "m.ceccarelli@tnx.it", "UPDATE righ_ddt_acquisto r LEFT JOIN codici_iva i ON r.iva = i.codice SET totale_ivato = round(totale_imponibile + (totale_imponibile * i.percentuale/100),2)", "agg2 totali righe");
                this.agg(169, "", "m.ceccarelli@tnx.it", "UPDATE righ_ordi_acquisto r LEFT JOIN codici_iva i ON r.iva = i.codice SET totale_ivato = round(totale_imponibile + (totale_imponibile * i.percentuale/100),2)", "agg2 totali righe");
                this.agg(194, "", "a.toce@tnx.it", "ALTER TABLE righ_ordi ADD COLUMN percentuale INTEGER NULL DEFAULT NULL", "Aggiunto campo percentuale");
                this.agg(195, "", "a.toce@tnx.it", "ALTER TABLE righ_ordi ADD COLUMN emissione_fattura INTEGER UNSIGNED NULL DEFAULT NULL", "Aggiunto campo emissione_fattura");
                this.agg(196, "", "a.toce@tnx.it", "ALTER TABLE righ_ordi ADD COLUMN termini_pagamento VARCHAR(35) NULL DEFAULT NULL", "Aggiunto campo tipo di pagamento");
                this.agg(197, "", "a.toce@tnx.it", "ALTER TABLE righ_ordi ADD COLUMN imponibile DECIMAL(12,5) NULL DEFAULT NULL", "Aggiunto campo imponibile");
                this.agg(198, "", "a.toce@tnx.it", "ALTER TABLE righ_ordi ADD COLUMN costo_giornaliero DECIMAL(12,5) NULL DEFAULT NULL", "Aggiunto campo imponibile");
                this.agg(199, "", "a.toce@tnx.it", "ALTER TABLE righ_ordi ADD COLUMN costo_mensile DECIMAL(12,5) NULL DEFAULT NULL", "Aggiunto campo imponibile");
                this.agg(200, "", "a.toce@tnx.it", "ALTER TABLE righ_ordi ADD COLUMN durata_consulenza INTEGER UNSIGNED NULL DEFAULT NULL", "Aggiunto campo imponibile");
                this.agg(201, "", "a.toce@tnx.it", "ALTER TABLE righ_ordi ADD COLUMN durata_contratto INTEGER UNSIGNED NULL DEFAULT NULL", "Aggiunto campo imponibile");
                this.agg(202, "", "a.toce@tnx.it", "CREATE TABLE tipi_durata_consulenza (`id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,  `descrizione` VARCHAR(255) NOT NULL) ENGINE=MyISAM", "Creazione tabella per anagrafica durata consulenza");
                this.agg(203, "", "a.toce@tnx.it", "CREATE TABLE tipi_durata_contratto (`id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,  `descrizione` VARCHAR(255) NOT NULL) ENGINE=MyISAM", "Creazione tabella per anagrafica durata contratto");
                this.agg(204, "", "a.toce@tnx.it", "CREATE TABLE tipi_emissione_fattura (`id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,  `descrizione` VARCHAR(255) NOT NULL) ENGINE=MyISAM", "Creazione tabella per anagrafica emissione fattura");
                this.agg(205, "", "a.toce@tnx.it", "CREATE TABLE stati_preventivo_ordine (`id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,  `descrizione` VARCHAR(255) NOT NULL) ENGINE=MyISAM", "Creazione tabella per anagrafica stati prev./ordine");
                this.agg(207, "", "a.toce@tnx.it", "INSERT INTO stati_preventivo_ordine SET descrizione = 'Preventivo'", "Inserimento Stati Preventivo/Ordine");
                this.agg(208, "", "a.toce@tnx.it", "INSERT INTO stati_preventivo_ordine SET descrizione = 'Preventivo Inviato'", "Inserimento Stati Preventivo/Ordine");
                this.agg(209, "", "a.toce@tnx.it", "INSERT INTO stati_preventivo_ordine SET descrizione = 'Preventivo Accettato'", "Inserimento Stati Preventivo/Ordine");
                this.agg(210, "", "a.toce@tnx.it", "INSERT INTO stati_preventivo_ordine SET descrizione = 'Conferma d\\'Ordine'", "Inserimento Stati Preventivo/Ordine");
                this.agg(211, "", "a.toce@tnx.it", "INSERT INTO stati_preventivo_ordine SET descrizione = 'Ordine'", "Inserimento Stati Preventivo/Ordine");
                this.agg(212, "", "a.toce@tnx.it", "INSERT INTO stati_preventivo_ordine SET descrizione = 'Ordine Inviato'", "Inserimento Stati Preventivo/Ordine");
                this.agg(213, "", "a.toce@tnx.it", "INSERT INTO stati_preventivo_ordine SET descrizione = 'Ordine Accettato'", "Inserimento Stati Preventivo/Ordine");
                this.agg(214, "", "a.toce@tnx.it", "INSERT INTO stati_preventivo_ordine SET descrizione = 'Ordine in lavorazione - 0%'", "Inserimento Stati Preventivo/Ordine");
                this.agg(215, "", "a.toce@tnx.it", "INSERT INTO stati_preventivo_ordine SET descrizione = 'Ordine in lavorazione - 25%'", "Inserimento Stati Preventivo/Ordine");
                this.agg(216, "", "a.toce@tnx.it", "INSERT INTO stati_preventivo_ordine SET descrizione = 'Ordine in lavorazione - 50%'", "Inserimento Stati Preventivo/Ordine");
                this.agg(217, "", "a.toce@tnx.it", "INSERT INTO stati_preventivo_ordine SET descrizione = 'Ordine in lavorazione - 75%'", "Inserimento Stati Preventivo/Ordine");
                this.agg(218, "", "a.toce@tnx.it", "INSERT INTO stati_preventivo_ordine SET descrizione = 'Ordine in lavorazione - Sospeso'", "Inserimento Stati Preventivo/Ordine");
                this.agg(219, "", "a.toce@tnx.it", "INSERT INTO stati_preventivo_ordine SET descrizione = 'Ordine Completato'", "Inserimento Stati Preventivo/Ordine");
                this.agg(220, "", "a.toce@tnx.it", "INSERT INTO stati_preventivo_ordine SET descrizione = 'Ordine Fatturato'", "Inserimento Stati Preventivo/Ordine");
                this.agg(221, "", "a.toce@tnx.it", "INSERT INTO stati_preventivo_ordine SET descrizione = 'Consuntivo in lavorazione'", "Inserimento Stati Preventivo/Ordine");
                this.agg(222, "", "a.toce@tnx.it", "INSERT INTO tipi_emissione_fattura SET descrizione = 'All\\'Ordine'", "Inserimento Tipi di Emissione Fattura");
                this.agg(223, "", "a.toce@tnx.it", "INSERT INTO tipi_emissione_fattura SET descrizione = 'Alla Consegna'", "Inserimento Tipi di Emissione Fattura");
                this.agg(224, "", "a.toce@tnx.it", "INSERT INTO tipi_emissione_fattura SET descrizione = 'Al Completamento'", "Inserimento Tipi di Emissione Fattura");
                this.agg(225, "", "a.toce@tnx.it", "INSERT INTO tipi_emissione_fattura SET descrizione = 'Consuntivo Fine Mese'", "Inserimento Tipi di Emissione Fattura");
                this.agg(226, "", "a.toce@tnx.it", "INSERT INTO tipi_emissione_fattura SET descrizione = 'A Fine Evento'", "Inserimento Tipi di Emissione Fattura");
                this.agg(227, "", "a.toce@tnx.it", "INSERT INTO tipi_emissione_fattura SET descrizione = 'Accettazione Grafica'", "Inserimento Tipi di Emissione Fattura");
                this.agg(228, "", "a.toce@tnx.it", "INSERT INTO tipi_emissione_fattura SET descrizione = 'Mensile anticipata'", "Inserimento Tipi di Emissione Fattura");
                this.agg(229, "", "a.toce@tnx.it", "INSERT INTO tipi_emissione_fattura SET descrizione = 'Bimestrale Anticpata'", "Inserimento Tipi di Emissione Fattura");
                this.agg(230, "", "a.toce@tnx.it", "INSERT INTO tipi_emissione_fattura SET descrizione = 'Ogni Fine Mese'", "Inserimento Tipi di Emissione Fattura");
                this.agg(231, "", "a.toce@tnx.it", "INSERT INTO tipi_emissione_fattura SET descrizione = 'Ogni Fine Bimestre'", "Inserimento Tipi di Emissione Fattura");
                this.agg(232, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_consulenza SET descrizione = 'Primi 5 gg'", "Inserimento Tipi di Durata Consulenza");
                this.agg(233, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_consulenza SET descrizione = 'Primi 10 gg'", "Inserimento Tipi di Durata Consulenza");
                this.agg(234, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_consulenza SET descrizione = 'Dal 6 gg al 15gg'", "Inserimento Tipi di Durata Consulenza");
                this.agg(235, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_consulenza SET descrizione = 'Dal 15 gg in poi'", "Inserimento Tipi di Durata Consulenza");
                this.agg(236, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_consulenza SET descrizione = 'Dal 5 gg in poi'", "Inserimento Tipi di Durata Consulenza");
                this.agg(237, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_consulenza SET descrizione = 'Dal 10 gg in poi'", "Inserimento Tipi di Durata Consulenza");
                this.agg(238, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_consulenza SET descrizione = 'Giornaliera'", "Inserimento Tipi di Durata Consulenza");
                this.agg(239, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_consulenza SET descrizione = '4 gg al mese x 6 mesi'", "Inserimento Tipi di Durata Consulenza");
                this.agg(240, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_consulenza SET descrizione = '8 gg al mese x 6 mesi'", "Inserimento Tipi di Durata Consulenza");
                this.agg(241, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_consulenza SET descrizione = '12 gg al mese x 6 mesi'", "Inserimento Tipi di Durata Consulenza");
                this.agg(242, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_consulenza SET descrizione = '4 gg al mese x 12 mesi'", "Inserimento Tipi di Durata Consulenza");
                this.agg(243, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_consulenza SET descrizione = '8 gg al mese x 12 mesi'", "Inserimento Tipi di Durata Consulenza");
                this.agg(244, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_consulenza SET descrizione = '12 gg al mese x 12 mesi'", "Inserimento Tipi di Durata Consulenza");
                this.agg(245, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_consulenza SET descrizione = 'Fino a Termine Progetto'", "Inserimento Tipi di Durata Consulenza");
                this.agg(246, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_contratto SET descrizione = 'X 2 Mesi'", "Inserimento Tipi di Durata Contratto");
                this.agg(247, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_contratto SET descrizione = 'X 3 Mesi'", "Inserimento Tipi di Durata Contratto");
                this.agg(248, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_contratto SET descrizione = 'X 4 Mesi'", "Inserimento Tipi di Durata Contratto");
                this.agg(249, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_contratto SET descrizione = 'X 6 Mesi'", "Inserimento Tipi di Durata Contratto");
                this.agg(250, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_contratto SET descrizione = 'X 8 Mesi'", "Inserimento Tipi di Durata Contratto");
                this.agg(251, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_contratto SET descrizione = 'X 12 Mesi'", "Inserimento Tipi di Durata Contratto");
                this.agg(252, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_contratto SET descrizione = 'X 18 Mesi'", "Inserimento Tipi di Durata Contratto");
                this.agg(253, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_contratto SET descrizione = 'X 24 Mesi'", "Inserimento Tipi di Durata Contratto");
                this.agg(254, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_contratto SET descrizione = 'X 32 Mesi'", "Inserimento Tipi di Durata Contratto");
                this.agg(255, "", "a.toce@tnx.it", "INSERT INTO tipi_durata_contratto SET descrizione = 'X 36 Mesi'", "Inserimento Tipi di Durata Contratto");
                this.agg(256, "", "a.toce@tnx.it", "ALTER TABLE test_ordi ADD COLUMN tipo_snj VARCHAR(1) NULL DEFAULT NULL", "Aggiunto campo tipo ordine SNJ");
                this.agg(257, "", "a.toce@tnx.it", "ALTER TABLE test_ordi_acquisto ADD COLUMN tipo_snj VARCHAR(1) NULL DEFAULT NULL", "Aggiunto campo tipo ordine SNJ");
                this.agg(258, "", "m.ceccarelli@tnx.it", "ALTER TABLE " + this.testate_ricevute + " MODIFY COLUMN numero_doc varchar(50)", "cambiato campo numero doc esterno in varchar!");
                this.agg(258, "", "a.toce@tnx.it", "ALTER TABLE codici_iva ADD COLUMN codice_readytec VARCHAR(3) NULL DEFAULT NULL", "Aggiunto campo di collegamento codice iva readytec");
                this.agg(259, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt add column prezzi_ivati char(1) not null default 'N'", "aggiunta gestione prezzi ivati");
                this.agg(260, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_fatt add column prezzo_ivato DECIMAL(15,5) NOT NULL DEFAULT 0", "aggiunta gestione prezzi ivati");
                this.agg(261, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ddt add column prezzi_ivati char(1) not null default 'N'", "aggiunta gestione prezzi ivati");
                this.agg(262, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt add column prezzo_ivato DECIMAL(15,5) NOT NULL DEFAULT 0", "aggiunta gestione prezzi ivati");
                this.agg(263, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi add column prezzi_ivati char(1) not null default 'N'", "aggiunta gestione prezzi ivati");
                this.agg(264, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ordi add column prezzo_ivato DECIMAL(15,5) NOT NULL DEFAULT 0", "aggiunta gestione prezzi ivati");
                this.agg(265, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt_acquisto add column prezzi_ivati char(1) not null default 'N'", "aggiunta gestione prezzi ivati");
                this.agg(266, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_fatt_acquisto add column prezzo_ivato DECIMAL(15,5) NOT NULL DEFAULT 0", "aggiunta gestione prezzi ivati");
                this.agg(267, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ddt_acquisto add column prezzi_ivati char(1) not null default 'N'", "aggiunta gestione prezzi ivati");
                this.agg(268, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt_acquisto add column prezzo_ivato DECIMAL(15,5) NOT NULL DEFAULT 0", "aggiunta gestione prezzi ivati");
                this.agg(269, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi_acquisto add column prezzi_ivati char(1) not null default 'N'", "aggiunta gestione prezzi ivati");
                this.agg(270, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ordi_acquisto add column prezzo_ivato DECIMAL(15,5) NOT NULL DEFAULT 0", "aggiunta gestione prezzi ivati");
                this.agg(271, "", "m.ceccarelli@tnx.it", "ALTER TABLE tipi_listino add column prezzi_ivati char(1) NOT NULL DEFAULT 'N'", "aggiunta gestione prezzi ivati");
                this.agg(272, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt add column sconto  DECIMAL(15,5) not null default 0", "gestione sconto a importo");
                this.agg(273, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ddt add column sconto  DECIMAL(15,5) not null default 0", "gestione sconto a importo");
                this.agg(274, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi add column sconto  DECIMAL(15,5) not null default 0", "gestione sconto a importo");
                this.agg(275, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt_acquisto add column sconto  DECIMAL(15,5) not null default 0", "gestione sconto a importo");
                this.agg(276, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ddt_acquisto add column sconto  DECIMAL(15,5) not null default 0", "gestione sconto a importo");
                this.agg(277, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi_acquisto add column sconto  DECIMAL(15,5) not null default 0", "gestione sconto a importo");
                this.agg(278, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt add column totale_imponibile_pre_sconto  DECIMAL(15,5) not null default 0", "gestione sconto a importo");
                this.agg(279, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ddt add column totale_imponibile_pre_sconto  DECIMAL(15,5) not null default 0", "gestione sconto a importo");
                this.agg(280, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi add column totale_imponibile_pre_sconto  DECIMAL(15,5) not null default 0", "gestione sconto a importo");
                this.agg(281, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt_acquisto add column totale_imponibile_pre_sconto  DECIMAL(15,5) not null default 0", "gestione sconto a importo");
                this.agg(282, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ddt_acquisto add column totale_imponibile_pre_sconto  DECIMAL(15,5) not null default 0", "gestione sconto a importo");
                this.agg(283, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi_acquisto add column totale_imponibile_pre_sconto  DECIMAL(15,5) not null default 0", "gestione sconto a importo");
                this.agg(284, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt add column totale_ivato_pre_sconto  DECIMAL(15,5) not null default 0", "gestione sconto a importo");
                this.agg(285, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ddt add column totale_ivato_pre_sconto  DECIMAL(15,5) not null default 0", "gestione sconto a importo");
                this.agg(286, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi add column totale_ivato_pre_sconto  DECIMAL(15,5) not null default 0", "gestione sconto a importo");
                this.agg(287, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt_acquisto add column totale_ivato_pre_sconto  DECIMAL(15,5) not null default 0", "gestione sconto a importo");
                this.agg(288, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ddt_acquisto add column totale_ivato_pre_sconto  DECIMAL(15,5) not null default 0", "gestione sconto a importo");
                this.agg(289, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi_acquisto add column totale_ivato_pre_sconto  DECIMAL(15,5) not null default 0", "gestione sconto a importo");
                this.agg(290, "", "m.ceccarelli@tnx.it", "update righ_fatt r join codici_iva i on r.iva = i.codice set r.prezzo_ivato = r.prezzo * ((i.percentuale / 100) + 1)", "prezzi ivati");
                this.agg(291, "", "m.ceccarelli@tnx.it", "update righ_ddt r join codici_iva i on r.iva = i.codice set r.prezzo_ivato = r.prezzo * ((i.percentuale / 100) + 1)", "prezzi ivati");
                this.agg(292, "", "m.ceccarelli@tnx.it", "update righ_ordi r join codici_iva i on r.iva = i.codice set r.prezzo_ivato = r.prezzo * ((i.percentuale / 100) + 1)", "prezzi ivati");
                this.agg(293, "", "m.ceccarelli@tnx.it", "update righ_fatt_acquisto r join codici_iva i on r.iva = i.codice set r.prezzo_ivato = r.prezzo * ((i.percentuale / 100) + 1)", "prezzi ivati");
                this.agg(294, "", "m.ceccarelli@tnx.it", "update righ_ddt_acquisto r join codici_iva i on r.iva = i.codice set r.prezzo_ivato = r.prezzo * ((i.percentuale / 100) + 1)", "prezzi ivati");
                this.agg(295, "", "m.ceccarelli@tnx.it", "update righ_ordi_acquisto r join codici_iva i on r.iva = i.codice set r.prezzo_ivato = r.prezzo * ((i.percentuale / 100) + 1)", "prezzi ivati");
                this.agg(296, "", "m.ceccarelli@tnx.it", "update test_fatt set totale_imponibile_pre_sconto = totale_imponibile, totale_ivato_pre_sconto = totale", "gestione sconto a importo");
                this.agg(297, "", "m.ceccarelli@tnx.it", "update test_ddt set totale_imponibile_pre_sconto = totale_imponibile, totale_ivato_pre_sconto = totale", "gestione sconto a importo");
                this.agg(298, "", "m.ceccarelli@tnx.it", "update test_ordi set totale_imponibile_pre_sconto = totale_imponibile, totale_ivato_pre_sconto = totale", "gestione sconto a importo");
                this.agg(299, "", "m.ceccarelli@tnx.it", "update test_fatt_acquisto set totale_imponibile_pre_sconto = imponibile, totale_ivato_pre_sconto = importo", "gestione sconto a importo");
                this.agg(300, "", "m.ceccarelli@tnx.it", "update test_ddt_acquisto set totale_imponibile_pre_sconto = totale_imponibile, totale_ivato_pre_sconto = totale", "gestione sconto a importo");
                this.agg(301, "", "m.ceccarelli@tnx.it", "update test_ordi_acquisto set totale_imponibile_pre_sconto = totale_imponibile, totale_ivato_pre_sconto = totale", "gestione sconto a importo");
                if (main.getPersonalContain("peroni")) {
                    this.agg(302, "", "m.ceccarelli@tnx.it", "alter table articoli add tipo_birra char(1) NULL DEFAULT ''", "peroni");
                }
                this.agg(303, "", "m.ceccarelli@tnx.it", "CREATE TABLE tipi_clie_forn (id varchar(10) NOT NULL PRIMARY KEY,  descrizione VARCHAR(255) NOT NULL default '') ENGINE=MyISAM", "Creazione tabella per tipi clie forn");
                if (main.getPersonalContain("peroni")) {
                    this.agg(304, "", "m.ceccarelli@tnx.it", "INSERT INTO tipi_clie_forn SET id = 'RIS', descrizione = 'Ristorante'", "tipi clie forn");
                    this.agg(305, "", "m.ceccarelli@tnx.it", "INSERT INTO tipi_clie_forn SET id = 'PIZ', descrizione = 'Pizzeria'", "tipi clie forn");
                    this.agg(306, "", "m.ceccarelli@tnx.it", "INSERT INTO tipi_clie_forn SET id = 'BAR', descrizione = 'Bar tradizionale'", "tipi clie forn");
                    this.agg(307, "", "m.ceccarelli@tnx.it", "INSERT INTO tipi_clie_forn SET id = 'BAR2', descrizione = 'Bar altro'", "tipi clie forn");
                    this.agg(308, "", "m.ceccarelli@tnx.it", "INSERT INTO tipi_clie_forn SET id = 'PUB', descrizione = 'Pub/Birreria'", "tipi clie forn");
                    this.agg(309, "", "m.ceccarelli@tnx.it", "INSERT INTO tipi_clie_forn SET id = 'HOT', descrizione = 'Hotel'", "tipi clie forn");
                    this.agg(310, "", "m.ceccarelli@tnx.it", "INSERT INTO tipi_clie_forn SET id = '', descrizione = 'Altro'", "tipi clie forn");
                }
                this.agg(311, "", "m.ceccarelli@tnx.it", "alter table clie_forn add tipo2 varchar(10) NOT NULL DEFAULT ''", "tipo2 su clienti fornitori");
                this.agg(314, "", "m.ceccarelli@tnx.it", "CREATE TABLE righ_ordi_lotti (id_padre INT(11) NULL DEFAULT NULL, id INT(11) NOT NULL AUTO_INCREMENT, lotto VARCHAR(200) NULL DEFAULT NULL, codice_articolo VARCHAR(20) NULL DEFAULT NULL, qta DECIMAL(8,2) NULL DEFAULT NULL, matricola VARCHAR(255) NULL DEFAULT NULL, PRIMARY KEY (id)) ENGINE=MyISAM", "righ_ordi_lotti");
                this.agg(315, "", "m.ceccarelli@tnx.it", "CREATE TABLE righ_ordi_acquisto_lotti (id_padre INT(11) NULL DEFAULT NULL, id INT(11) NOT NULL AUTO_INCREMENT, lotto VARCHAR(200) NULL DEFAULT NULL, codice_articolo VARCHAR(20) NULL DEFAULT NULL, qta DECIMAL(8,2) NULL DEFAULT NULL, matricola VARCHAR(255) NULL DEFAULT NULL, PRIMARY KEY (id)) ENGINE=MyISAM", "righ_ordi_acquisto_lotti");
                if (!main.pluginRitenute) {
                    this.agg(316, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_fatt ADD COLUMN flag_rivalsa char(1) DEFAULT 'S'", "flag_rivalsa");
                    this.agg(317, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_fatt" + this.nome_ricevute + " ADD COLUMN flag_rivalsa char(1) DEFAULT 'S'", "flag_rivalsa");
                    this.agg(318, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt ADD COLUMN flag_rivalsa char(1) DEFAULT 'S'", "flag_rivalsa");
                    this.agg(319, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt_acquisto ADD COLUMN flag_rivalsa char(1) DEFAULT 'S'", "flag_rivalsa");
                    this.agg(320, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ordi ADD COLUMN flag_rivalsa char(1) DEFAULT 'S'", "flag_rivalsa");
                    this.agg(321, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ordi_acquisto ADD COLUMN flag_rivalsa char(1) DEFAULT 'S'", "flag_rivalsa");
                    this.agg(322, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt ADD COLUMN rivalsa int NULL", "rivalsa fatture vendita");
                    this.agg(323, "", "m.ceccarelli@tnx.it", "ALTER TABLE " + this.testate_ricevute + " ADD COLUMN rivalsa int NULL", "rivalsa fatture acquisto");
                }
                this.agg(324, "", "m.ceccarelli@tnx.it", "ALTER TABLE `pagamenti`  ADD COLUMN `240` CHAR(1) NOT NULL DEFAULT '' AFTER `210`", "Aggiungo colonna 240gg");
                this.agg(325, "", "m.ceccarelli@tnx.it", "ALTER TABLE `pagamenti`  ADD COLUMN `270` CHAR(1) NOT NULL DEFAULT '' AFTER `240`", "Aggiungo colonna 270gg");
                this.agg(326, "", "m.ceccarelli@tnx.it", "ALTER TABLE `pagamenti`  ADD COLUMN `300` CHAR(1) NOT NULL DEFAULT '' AFTER `270`", "Aggiungo colonna 300gg");
                this.agg(327, "", "m.ceccarelli@tnx.it", "ALTER TABLE `pagamenti`  ADD COLUMN `330` CHAR(1) NOT NULL DEFAULT '' AFTER `300`", "Aggiungo colonna 330gg");
                this.agg(328, "", "m.ceccarelli@tnx.it", "ALTER TABLE `pagamenti`  ADD COLUMN `360` CHAR(1) NOT NULL DEFAULT '' AFTER `330`", "Aggiungo colonna 360gg");
                this.agg(324, "", "a.toce@tnx.it", "CREATE TABLE `accessi_utenti` (`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT, `username` VARCHAR(150) NOT NULL, `password` VARCHAR(32) NOT NULL, `id_role` INT UNSIGNED NOT NULL, PRIMARY KEY (`id`)) ENGINE=MyISAM", "Aggiunta tabella utenti");
                this.agg(325, "", "a.toce@tnx.it", "CREATE TABLE `accessi_ruoli` (`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT, `descrizione` VARCHAR(255) NOT NULL, PRIMARY KEY (`id`)) ENGINE=MyISAM", "Aggiunta tabella ruoli");
                this.agg(326, "", "a.toce@tnx.it", "CREATE TABLE `accessi_tipi_permessi` (`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT, `descrizione` VARCHAR(255) NOT NULL, `lettura` INT(10) UNSIGNED NOT NULL DEFAULT '1', `scrittura` INT(10) UNSIGNED NOT NULL DEFAULT '1', `cancella` INT(10) UNSIGNED NOT NULL DEFAULT '1', PRIMARY KEY (`id`)) ENGINE=MyISAM", "Aggiunta tabella privilegi");
                this.agg(327, "", "a.toce@tnx.it", "CREATE TABLE `accessi_ruoli_permessi` (`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT, `id_role` INT(10) UNSIGNED NOT NULL, `id_privilegio` INT(10) UNSIGNED NOT NULL, `lettura` INT(10) UNSIGNED NOT NULL DEFAULT '0', `scrittura` INT(10) UNSIGNED NOT NULL DEFAULT '0', `cancella` INT(10) UNSIGNED NOT NULL DEFAULT '0', PRIMARY KEY (`id`), UNIQUE INDEX `id_role_id_privilegio` (`id_role`, `id_privilegio`)) ENGINE=MyISAM", "Aggiunta tabella di collegamento fra ruoli e privilegi");
                this.agg(328, "", "a.toce@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 1, descrizione = 'Anagrafica Clienti'", "Aggiungo voci iniziali su gestione privilegi");
                this.agg(329, "", "a.toce@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 2, descrizione = 'Anagrafica Articoli e Listini'", "Aggiungo voci iniziali su gestione privilegi");
                this.agg(330, "", "a.toce@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 3, descrizione = 'Anagrafica Tipi di Pagamento'", "Aggiungo voci iniziali su gestione privilegi");
                this.agg(331, "", "a.toce@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 4, descrizione = 'Anagrafica Codici IVA'", "Aggiungo voci iniziali su gestione privilegi");
                this.agg(332, "", "a.toce@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 5, descrizione = 'Altre Anagrafiche'", "Aggiungo voci iniziali su gestione privilegi");
                this.agg(333, "", "a.toce@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 6, descrizione = 'Impostazioni', cancella = 0", "Aggiungo voci iniziali su gestione privilegi");
                this.agg(334, "", "a.toce@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 7, descrizione = 'Gestione Accesso Utenti'", "Aggiungo voci iniziali su gestione privilegi");
                this.agg(335, "", "a.toce@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 8, descrizione = 'Magazzino'", "Aggiungo voci iniziali su gestione privilegi");
                this.agg(336, "", "a.toce@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 9, descrizione = 'Statistiche', scrittura = 0, cancella = 0", "Aggiungo voci iniziali su gestione privilegi");
                this.agg(337, "", "a.toce@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 10, descrizione = 'Agente'", "Aggiungo voci iniziali su gestione privilegi");
                this.agg(338, "", "a.toce@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 11, descrizione = 'Preventivi/Ordini di Vendita'", "Aggiungo voci iniziali su gestione privilegi");
                this.agg(339, "", "a.toce@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 12, descrizione = 'DDT di Vendita'", "Aggiungo voci iniziali su gestione privilegi");
                this.agg(340, "", "a.toce@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 13, descrizione = 'Fatture di Vendita'", "Aggiungo voci iniziali su gestione privilegi");
                this.agg(341, "", "a.toce@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 14, descrizione = 'Preventivi/Ordini di Acquisto'", "Aggiungo voci iniziali su gestione privilegi");
                this.agg(342, "", "a.toce@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 15, descrizione = 'DDT di Acquisto'", "Aggiungo voci iniziali su gestione privilegi");
                this.agg(343, "", "a.toce@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 16, descrizione = 'Fatture di Acquisto'", "Aggiungo voci iniziali su gestione privilegi");
                this.agg(344, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli SET id = 1, descrizione = 'Administrator'", "Aggiungo ruolo amministratore");
                this.agg(345, "", "a.toce@tnx.it", "INSERT INTO accessi_utenti SET id = 1, username = 'admin', password = " + it.tnx.Db.pc((Object)InvoicexUtil.md5("admin"), 12) + ", id_role = '1'", "Aggiungo utente amministratore con password admin");
                this.agg(346, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli_permessi SET id_role = 1, id_privilegio = 1, lettura = '1', scrittura = '1', cancella = '1'", "Aggiungo privilegi completi per utente admin");
                this.agg(347, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli_permessi SET id_role = 1, id_privilegio = 2, lettura = '1', scrittura = '1', cancella = '1'", "Aggiungo privilegi completi per utente admin");
                this.agg(348, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli_permessi SET id_role = 1, id_privilegio = 3, lettura = '1', scrittura = '1', cancella = '1'", "Aggiungo privilegi completi per utente admin");
                this.agg(349, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli_permessi SET id_role = 1, id_privilegio = 4, lettura = '1', scrittura = '1', cancella = '1'", "Aggiungo privilegi completi per utente admin");
                this.agg(350, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli_permessi SET id_role = 1, id_privilegio = 5, lettura = '1', scrittura = '1', cancella = '1'", "Aggiungo privilegi completi per utente admin");
                this.agg(351, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli_permessi SET id_role = 1, id_privilegio = 6, lettura = '1', scrittura = '1', cancella = '0'", "Aggiungo privilegi completi per utente admin");
                this.agg(352, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli_permessi SET id_role = 1, id_privilegio = 7, lettura = '1', scrittura = '1', cancella = '1'", "Aggiungo privilegi completi per utente admin");
                this.agg(353, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli_permessi SET id_role = 1, id_privilegio = 8, lettura = '1', scrittura = '1', cancella = '1'", "Aggiungo privilegi completi per utente admin");
                this.agg(354, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli_permessi SET id_role = 1, id_privilegio = 9, lettura = '1', scrittura = '0', cancella = '0'", "Aggiungo privilegi completi per utente admin");
                this.agg(355, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli_permessi SET id_role = 1, id_privilegio = 10, lettura = '1', scrittura = '1', cancella = '1'", "Aggiungo privilegi completi per utente admin");
                this.agg(356, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli_permessi SET id_role = 1, id_privilegio = 11, lettura = '1', scrittura = '1', cancella = '1'", "Aggiungo privilegi completi per utente admin");
                this.agg(357, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli_permessi SET id_role = 1, id_privilegio = 12, lettura = '1', scrittura = '1', cancella = '1'", "Aggiungo privilegi completi per utente admin");
                this.agg(358, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli_permessi SET id_role = 1, id_privilegio = 13, lettura = '1', scrittura = '1', cancella = '1'", "Aggiungo privilegi completi per utente admin");
                this.agg(359, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli_permessi SET id_role = 1, id_privilegio = 14, lettura = '1', scrittura = '1', cancella = '1'", "Aggiungo privilegi completi per utente admin");
                this.agg(360, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli_permessi SET id_role = 1, id_privilegio = 15, lettura = '1', scrittura = '1', cancella = '1'", "Aggiungo privilegi completi per utente admin");
                this.agg(361, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli_permessi SET id_role = 1, id_privilegio = 16, lettura = '1', scrittura = '1', cancella = '1'", "Aggiungo privilegi completi per utente admin");
                this.agg(362, "", "a.toce@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 17, descrizione = 'Gestione Pagamenti e Scadenzario'", "Aggiungo voci iniziali su gestione privilegi");
                this.agg(363, "", "a.toce@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 18, descrizione = 'Gestione Iva', scrittura = 0, cancella = 0", "Aggiungo voci iniziali su gestione privilegi");
                this.agg(364, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli_permessi SET id_role = 1, id_privilegio = 17, lettura = '1', scrittura = '1', cancella = '1'", "Aggiungo privilegi completi per utente admin");
                this.agg(365, "", "a.toce@tnx.it", "INSERT INTO accessi_ruoli_permessi SET id_role = 1, id_privilegio = 18, lettura = '1', scrittura = '0', cancella = '0'", "Aggiungo privilegi completi per utente admin");
                this.agg(366, "", "a.toce@tnx.it", "CREATE TABLE accessi_log (id int(10) unsigned NOT NULL AUTO_INCREMENT, utente varchar(255) NOT NULL, timestamp_login timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (id)) ENGINE=MyISAM", "Creo tabella di log per accessi");
                this.agg(329, "", "m.ceccarelli@tnx.it", "ALTER TABLE dati_azienda ADD COLUMN provvigioni_tipo_data varchar(20) NOT NULL DEFAULT 'data_scadenza'", "tipo di generazione delle provvigioni se con data scadenza o data fattura");
                this.agg(330, "", "m.ceccarelli@tnx.it", "alter table stampa_iva_semplice add column data_doc DATE NULL DEFAULT NULL", "data documento su stampa reg. iva");
                this.agg(331, "", "m.ceccarelli@tnx.it", "ALTER TABLE dati_azienda ADD COLUMN gestione_utenti int NULL DEFAULT 0", "gestione utenti");
                this.agg(332, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli` (`id`, `descrizione`) VALUES (2, 'Standard (accesso completo eccetto impostazioni)')", "gestione utenti");
                this.agg(333, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli` (`id`, `descrizione`) VALUES (3, 'Sola lettura')", "gestione utenti");
                this.agg(334, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli` (`id`, `descrizione`) VALUES (4, 'DDT e Magazzino')", "gestione utenti");
                this.agg(335, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 2, 1, 1, 1, 1);", "gestione utenti");
                this.agg(336, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 2, 2, 1, 1, 1);", "gestione utenti");
                this.agg(337, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 2, 3, 1, 1, 1);", "gestione utenti");
                this.agg(338, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 2, 4, 1, 1, 1);", "gestione utenti");
                this.agg(339, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 2, 5, 1, 1, 1);", "gestione utenti");
                this.agg(340, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 2, 6, 1, 0, 0);", "gestione utenti");
                this.agg(341, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 2, 7, 1, 0, 0);", "gestione utenti");
                this.agg(342, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 2, 8, 1, 1, 1);", "gestione utenti");
                this.agg(343, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 2, 9, 1, 0, 0);", "gestione utenti");
                this.agg(344, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 2, 10, 1, 1, 1);", "gestione utenti");
                this.agg(345, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 2, 11, 1, 1, 1);", "gestione utenti");
                this.agg(346, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 2, 12, 1, 1, 1);", "gestione utenti");
                this.agg(347, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 2, 13, 1, 1, 1);", "gestione utenti");
                this.agg(348, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 2, 14, 1, 1, 1);", "gestione utenti");
                this.agg(349, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 2, 15, 1, 1, 1);", "gestione utenti");
                this.agg(350, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 2, 16, 1, 1, 1);", "gestione utenti");
                this.agg(351, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 2, 17, 1, 1, 1);", "gestione utenti");
                this.agg(352, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 2, 18, 1, 0, 0);", "gestione utenti");
                this.agg(353, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 3, 1, 1, 0, 0);", "gestione utenti");
                this.agg(354, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 3, 2, 1, 0, 0);", "gestione utenti");
                this.agg(355, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 3, 3, 1, 0, 0);", "gestione utenti");
                this.agg(356, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 3, 4, 1, 0, 0);", "gestione utenti");
                this.agg(357, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 3, 5, 1, 0, 0);", "gestione utenti");
                this.agg(358, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 3, 6, 1, 0, 0);", "gestione utenti");
                this.agg(359, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 3, 7, 1, 0, 0);", "gestione utenti");
                this.agg(360, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 3, 8, 1, 0, 0);", "gestione utenti");
                this.agg(361, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 3, 9, 1, 0, 0);", "gestione utenti");
                this.agg(362, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 3, 10, 1, 0, 0);", "gestione utenti");
                this.agg(363, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 3, 11, 1, 0, 0);", "gestione utenti");
                this.agg(364, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 3, 12, 1, 0, 0);", "gestione utenti");
                this.agg(365, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 3, 13, 1, 0, 0);", "gestione utenti");
                this.agg(366, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 3, 14, 1, 0, 0);", "gestione utenti");
                this.agg(367, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 3, 15, 1, 0, 0);", "gestione utenti");
                this.agg(368, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 3, 16, 1, 0, 0);", "gestione utenti");
                this.agg(369, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 3, 17, 1, 0, 0);", "gestione utenti");
                this.agg(370, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 3, 18, 1, 0, 0);", "gestione utenti");
                this.agg(371, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 4, 1, 0, 0, 0);", "gestione utenti");
                this.agg(372, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 4, 2, 0, 0, 0);", "gestione utenti");
                this.agg(373, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 4, 3, 0, 0, 0);", "gestione utenti");
                this.agg(374, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 4, 4, 0, 0, 0);", "gestione utenti");
                this.agg(375, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 4, 5, 0, 0, 0);", "gestione utenti");
                this.agg(376, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 4, 6, 0, 0, 0);", "gestione utenti");
                this.agg(377, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 4, 7, 0, 0, 0);", "gestione utenti");
                this.agg(378, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 4, 8, 1, 1, 1);", "gestione utenti");
                this.agg(379, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 4, 9, 0, 0, 0);", "gestione utenti");
                this.agg(380, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 4, 10, 0, 0, 0);", "gestione utenti");
                this.agg(381, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 4, 11, 0, 0, 0);", "gestione utenti");
                this.agg(382, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 4, 12, 1, 1, 1);", "gestione utenti");
                this.agg(383, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 4, 13, 0, 0, 0);", "gestione utenti");
                this.agg(384, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 4, 14, 0, 0, 0);", "gestione utenti");
                this.agg(385, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 4, 15, 1, 1, 1);", "gestione utenti");
                this.agg(386, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 4, 16, 0, 0, 0);", "gestione utenti");
                this.agg(387, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 4, 17, 0, 0, 0);", "gestione utenti");
                this.agg(388, "", "m.ceccarelli@tnx.it", "INSERT INTO `accessi_ruoli_permessi` (`id_role`, `id_privilegio`, `lettura`, `scrittura`, `cancella`) VALUES ( 4, 18, 0, 0, 0);", "gestione utenti");
                this.agg(389, "", "a.toce@tnx.it", "ALTER TABLE righ_ddt ADD COLUMN numero_casse INT NULL DEFAULT NULL", "Aggiunto numero casse su righe DDT");
                this.agg(390, "", "a.toce@tnx.it", "ALTER TABLE righ_fatt ADD COLUMN numero_casse INT NULL DEFAULT NULL", "Aggiunto numero casse su righe DDT");
                this.agg(391, "", "a.toce@tnx.it", "ALTER TABLE righ_ordi ADD COLUMN numero_casse INT NULL DEFAULT NULL", "Aggiunto numero casse su righe DDT");
                this.agg(392, "", "a.toce@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `label_cliente_eng` VARCHAR(100) DEFAULT 'Dear'", "Etichetta cliente");
                this.agg(393, "", "a.toce@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `label_destinazione_eng` VARCHAR(100) DEFAULT 'Destination'", "Etichetta destinazione");
                this.agg(389, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `stampare_timbro_firma` VARCHAR(100) DEFAULT 'Non stampare mai'", "timbro firma");
                this.agg(390, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `testo_timbro_firma` TEXT", "timbro firma");
                this.agg(391, "", "m.ceccarelli@tnx.it", "update `dati_azienda` set testo_timbro_firma = '<html>\\n<center>\\n<b>\\n      <br>\\n           Data                                         Timbro e Firma<br>\\n          _________                                ____________________<br>\\n<br>\\n</center>\\n</html>'", "timbro firma");
                this.agg(392, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt CHANGE COLUMN quantita_evasa quantita_evasa DECIMAL(15,5) NULL DEFAULT NULL;", "qta evasa decimali");
                this.agg(393, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt_acquisto CHANGE COLUMN quantita_evasa quantita_evasa DECIMAL(15,5) NULL DEFAULT NULL;", "qta evasa decimali");
                this.agg(394, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ordi CHANGE COLUMN quantita_evasa quantita_evasa DECIMAL(15,5) NULL DEFAULT NULL;", "qta evasa decimali");
                this.agg(395, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ordi_acquisto CHANGE COLUMN quantita_evasa quantita_evasa DECIMAL(15,5) NULL DEFAULT NULL;", "qta evasa decimali");
                this.agg(396, "", "m.ceccarelli@tnx.it", "create table tipi_aspetto_esteriore_beni (id int auto_increment not null primary key, nome varchar(100)) ENGINE=MyISAM", "tabella tipi_aspetto_esteriore_beni");
                this.agg(397, "", "m.ceccarelli@tnx.it", "insert into tipi_aspetto_esteriore_beni (nome) values ('SCATOLA')", "tabella tipi_aspetto_esteriore_beni");
                this.agg(398, "", "m.ceccarelli@tnx.it", "insert into tipi_aspetto_esteriore_beni (nome) values ('A VISTA')", "tabella tipi_aspetto_esteriore_beni");
                this.agg(399, "", "m.ceccarelli@tnx.it", "insert into tipi_aspetto_esteriore_beni (nome) values ('SCATOLA IN PANCALE')", "tabella tipi_aspetto_esteriore_beni");
                this.agg(400, "", "m.ceccarelli@tnx.it", "insert into tipi_aspetto_esteriore_beni (nome) values ('BUSTA')", "tabella tipi_aspetto_esteriore_beni");
                this.agg(401, "", "m.ceccarelli@tnx.it", "insert into tipi_aspetto_esteriore_beni (nome) values ('CARTONE')", "tabella tipi_aspetto_esteriore_beni");
                this.agg(402, "", "m.ceccarelli@tnx.it", "alter table dati_azienda add column tipo_numerazione int not null default 0", "dati azienda tipo numerazione");
                this.agg(403, "", "m.ceccarelli@tnx.it", "alter table dati_azienda add column tipo_numerazione_confermata int not null default 0", "dati azienda tipo numerazione");
                this.agg(404, "", "m.ceccarelli@tnx.it", "alter table dati_azienda add column tipo_numerazione_confermata2 int not null default 0", "dati azienda tipo numerazione");
                this.agg(406, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt_acquisto add index serie_numero_anno (serie, numero, anno)", "indici per scadenze");
                this.agg(407, "", "m.ceccarelli@tnx.it", "ALTER TABLE scadenze add index serie_numero_anno (documento_serie, documento_numero, documento_anno)", "indici per scadenze");
                this.agg(408, "", "m.ceccarelli@tnx.it", "alter table scadenze_parziali add index id_scadenza (id_scadenza)", "indici per scadenze");
                this.agg(409, "", "m.ceccarelli@tnx.it", "alter table scadenze add index documento_tipo (documento_tipo)", "indici per scadenze");
                this.agg(410, "", "m.ceccarelli@tnx.it", "alter table scadenze add index data_scadenza (data_scadenza)", "indici per scadenze");
                this.agg(411, "", "m.ceccarelli@tnx.it", "alter table clie_forn add index ragione_sociale (ragione_sociale)", "indici per scadenze");
                this.agg(412, "", "m.ceccarelli@tnx.it", "ALTER TABLE pagamenti ADD COLUMN id_pagamento_teamsystem INT NULL DEFAULT NULL", "Aggiunto campo di collegamento com teamsystem");
                this.agg(413, "", "m.ceccarelli@tnx.it", "ALTER TABLE pagamenti ADD COLUMN tipo_effetto_teamsystem INT NULL DEFAULT NULL", "Aggiunto campo di collegamento com teamsystem");
                this.agg(414, "", "m.ceccarelli@tnx.it", "alter table pacchetti_articoli CHANGE COLUMN quantita quantita DECIMAL(15,5) NOT NULL", "qta kit");
                this.agg(415, "", "m.ceccarelli@tnx.it", "ALTER TABLE clie_forn CHANGE COLUMN email email TEXT NULL DEFAULT NULL", "campo email pi\u00f9 lungo");
                this.agg(416, "", "m.ceccarelli@tnx.it", "ALTER TABLE clie_forn ADD COLUMN `provvigione_predefinita_cliente` DECIMAL(5,2) NULL DEFAULT NULL AFTER `agente`", "provvigioni agenti");
                this.agg(417, "", "m.ceccarelli@tnx.it", "ALTER TABLE clie_forn ADD COLUMN `provvigione_predefinita_fornitore` DECIMAL(5,2) NULL DEFAULT NULL AFTER `provvigione_predefinita_cliente`", "provvigioni agenti");
                this.agg(418, "", "m.ceccarelli@tnx.it", "ALTER TABLE `articoli` CHANGE COLUMN `fornitore` `fornitore_old` VARCHAR(10) NULL DEFAULT NULL", "provvigioni agenti per articolo fornitore");
                this.agg(419, "", "m.ceccarelli@tnx.it", "ALTER TABLE articoli ADD COLUMN `fornitore` INT UNSIGNED NULL DEFAULT NULL AFTER `fornitore_old`", "provvigioni agenti per articolo fornitore");
                this.agg(420, "", "m.ceccarelli@tnx.it", "ALTER TABLE articoli ADD COLUMN `disponibilita_reale` decimal(15,5) NULL DEFAULT NULL", "giacenza articolo");
                this.agg(421, "", "m.ceccarelli@tnx.it", "ALTER TABLE articoli ADD COLUMN `disponibilita_reale_ts` TIMESTAMP NULL DEFAULT NULL AFTER disponibilita_reale", "giacenza articolo");
                this.agg(422, "", "m.ceccarelli@tnx.it", "ALTER TABLE movimenti_magazzino ADD COLUMN `modificato_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP", "giacenza articolo");
                this.agg(423, "", "m.ceccarelli@tnx.it", "CREATE TABLE movimenti_magazzino_eliminati LIKE movimenti_magazzino ENGINE=MyISAM", "giacenza articolo");
                this.agg(424, "", "m.ceccarelli@tnx.it", "alter table righ_ordi add column prezzo_netto_unitario decimal(15,5)", "prezzo netto unitario");
                this.agg(425, "", "m.ceccarelli@tnx.it", "alter table righ_ordi_acquisto add column prezzo_netto_unitario decimal(15,5)", "prezzo netto unitario");
                this.agg(426, "", "m.ceccarelli@tnx.it", "alter table righ_ddt add column prezzo_netto_unitario decimal(15,5)", "prezzo netto unitario");
                this.agg(427, "", "m.ceccarelli@tnx.it", "alter table righ_ddt_acquisto add column prezzo_netto_unitario decimal(15,5)", "prezzo netto unitario");
                this.agg(428, "", "m.ceccarelli@tnx.it", "alter table righ_fatt add column prezzo_netto_unitario decimal(15,5)", "prezzo netto unitario");
                this.agg(429, "", "m.ceccarelli@tnx.it", "alter table righ_fatt_acquisto add column prezzo_netto_unitario decimal(15,5)", "prezzo netto unitario");
                this.agg(430, "", "m.ceccarelli@tnx.it", "alter table clie_forn add column produttore int null", "produttore");
                sql = "select export_fatture_estrai_scadenze from dati_azienda";
                try {
                    DbUtils.tryOpenResultSet((Connection)it.tnx.Db.getConn(), (String)sql);
                }
                catch (Exception e) {
                    try {
                        DbUtils.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)"ALTER TABLE `dati_azienda` ADD COLUMN `export_fatture_codice_iva` varchar(50) NULL");
                    }
                    catch (Exception temposecondi) {
                        // empty catch block
                    }
                    try {
                        DbUtils.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)"ALTER TABLE `dati_azienda` ADD COLUMN `export_fatture_conto_ricavi` varchar(50) NULL");
                    }
                    catch (Exception temposecondi) {
                        // empty catch block
                    }
                    try {
                        DbUtils.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)"ALTER TABLE `dati_azienda` ADD COLUMN `export_fatture_estrai_scadenze` char(1) NULL");
                    }
                    catch (Exception temposecondi) {
                        // empty catch block
                    }
                    try {
                        sql = "update dati_azienda set export_fatture_codice_iva = " + it.tnx.Db.pc((Object)main.fileIni.getValue("readytec", "codiceIvaDefault", ""), 12);
                        DbUtils.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)sql);
                    }
                    catch (Exception temposecondi) {
                        // empty catch block
                    }
                    try {
                        sql = "update dati_azienda set export_fatture_conto_ricavi = " + it.tnx.Db.pc((Object)main.fileIni.getValue("readytec", "codiceContoDefault", ""), 12);
                        DbUtils.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)sql);
                    }
                    catch (Exception temposecondi) {
                        // empty catch block
                    }
                    try {
                        sql = "update dati_azienda set export_fatture_estrai_scadenze = 'S'";
                        DbUtils.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)sql);
                    }
                    catch (Exception temposecondi) {
                        // empty catch block
                    }
                }
                this.agg(431, "", "m.ceccarelli@tnx.it", "update test_fatt set totale_da_pagare = totale where tipo_fattura = 7", "update per scontrini");
                String view1 = "create view v_righ_tutte as  SELECT 'v' as tabella, r.id, r.id_padre, t.data, t.anno, t.numero, t.serie, r.riga, r.codice_articolo, r.descrizione\n, r.quantita, r.prezzo, r.prezzo_netto_unitario, r.sconto1, r.sconto2, t.sconto1 as sconto1t, t.sconto2 as sconto2t, t.sconto3 as sconto3t\n, c.codice as clifor, c.ragione_sociale\nfrom righ_fatt r \njoin test_fatt t on r.id_padre = t.id\njoin clie_forn c on t.cliente = c.codice\nunion all \nSELECT 'a' as tabella, r.id, r.id_padre, t.data, t.anno, t.numero, t.serie, r.riga, r.codice_articolo, r.descrizione\n, r.quantita, r.prezzo, r.prezzo_netto_unitario, r.sconto1, r.sconto2, t.sconto1 as sconto1t, t.sconto2 as sconto2t, t.sconto3 as sconto3t\n, c.codice as clifor, c.ragione_sociale\nfrom righ_fatt_acquisto r \njoin test_fatt_acquisto t on r.id_padre = t.id\njoin clie_forn c on t.fornitore = c.codice";
                this.agg(432, "", "m.ceccarelli@tnx.it", view1, "vista per ultimi prezzi");
                this.agg(433, "", "m.ceccarelli@tnx.it", "alter table righ_ordi add column data_consegna_prevista date", "data consegna prevista");
                this.agg(434, "", "m.ceccarelli@tnx.it", "alter table righ_ddt add column data_consegna_prevista date", "data consegna prevista");
                this.agg(435, "", "m.ceccarelli@tnx.it", "alter table righ_fatt add column data_consegna_prevista date", "data consegna prevista");
                this.agg(436, "", "m.ceccarelli@tnx.it", "alter table righ_ordi_acquisto add column data_consegna_prevista date", "data consegna prevista");
                this.agg(437, "", "m.ceccarelli@tnx.it", "alter table righ_ddt_acquisto add column data_consegna_prevista date", "data consegna prevista");
                this.agg(438, "", "m.ceccarelli@tnx.it", "alter table righ_fatt_acquisto add column data_consegna_prevista date", "data consegna prevista");
                this.agg(439, "", "m.ceccarelli@tnx.it", "alter table test_ordi add column data_consegna_prevista date", "data consegna prevista");
                this.agg(440, "", "m.ceccarelli@tnx.it", "alter table test_ddt add column data_consegna_prevista date", "data consegna prevista");
                this.agg(441, "", "m.ceccarelli@tnx.it", "alter table test_fatt add column data_consegna_prevista date", "data consegna prevista");
                this.agg(442, "", "m.ceccarelli@tnx.it", "alter table test_ordi_acquisto add column data_consegna_prevista date", "data consegna prevista");
                this.agg(443, "", "m.ceccarelli@tnx.it", "alter table test_ddt_acquisto add column data_consegna_prevista date", "data consegna prevista");
                this.agg(444, "", "m.ceccarelli@tnx.it", "alter table test_fatt_acquisto add column data_consegna_prevista date", "data consegna prevista");
                this.agg(445, "", "m.ceccarelli@tnx.it", "create table tipi_consegna (id int auto_increment not null primary key, nome varchar(100)) ENGINE=MyISAM", "tabella tipi consegna");
                this.agg(446, "", "m.ceccarelli@tnx.it", "insert into tipi_consegna (nome) values ('MITTENTE')", "tabella tipi consegna");
                this.agg(447, "", "m.ceccarelli@tnx.it", "insert into tipi_consegna (nome) values ('VETTORE')", "tabella tipi consegna");
                this.agg(448, "", "m.ceccarelli@tnx.it", "insert into tipi_consegna (nome) values ('DESTINATARIO')", "tabella tipi consegna");
                this.agg(449, "", "m.ceccarelli@tnx.it", "create table tipi_scarico (id int auto_increment not null primary key, nome varchar(100)) ENGINE=MyISAM", "tabella tipi scarico");
                this.agg(450, "", "m.ceccarelli@tnx.it", "insert into tipi_scarico (nome) values ('CON MULETTO')", "tabella tipi scarico");
                this.agg(451, "", "m.ceccarelli@tnx.it", "insert into tipi_scarico (nome) values ('A MANO')", "tabella tipi scarico");
                this.agg(452, "", "m.ceccarelli@tnx.it", "ALTER TABLE stati ADD UNIQUE INDEX indice_codice1 (codice1)", "indice univoco per nazioni");
                this.agg(453, "", "m.ceccarelli@tnx.it", "ALTER TABLE clie_forn ADD modalita_consegna int", "consegna");
                this.agg(454, "", "m.ceccarelli@tnx.it", "ALTER TABLE clie_forn ADD modalita_scarico int", "scarico");
                this.agg(455, "", "m.ceccarelli@tnx.it", "alter table test_ordi add column modalita_consegna int", "consegna");
                this.agg(456, "", "m.ceccarelli@tnx.it", "alter table test_ddt add column modalita_consegna int", "consegna");
                this.agg(457, "", "m.ceccarelli@tnx.it", "alter table test_fatt add column modalita_consegna int", "consegna");
                this.agg(458, "", "m.ceccarelli@tnx.it", "alter table test_ordi_acquisto add column modalita_consegna int", "consegna");
                this.agg(459, "", "m.ceccarelli@tnx.it", "alter table test_ddt_acquisto add column modalita_consegna int", "consegna");
                this.agg(460, "", "m.ceccarelli@tnx.it", "alter table test_fatt_acquisto add column modalita_consegna int", "consegna");
                this.agg(461, "", "m.ceccarelli@tnx.it", "alter table test_ordi add column modalita_scarico int", "consegna");
                this.agg(462, "", "m.ceccarelli@tnx.it", "alter table test_ddt add column modalita_scarico int", "consegna");
                this.agg(463, "", "m.ceccarelli@tnx.it", "alter table test_fatt add column modalita_scarico int", "consegna");
                this.agg(464, "", "m.ceccarelli@tnx.it", "alter table test_ordi_acquisto add column modalita_scarico int", "consegna");
                this.agg(465, "", "m.ceccarelli@tnx.it", "alter table test_ddt_acquisto add column modalita_scarico int", "consegna");
                this.agg(466, "", "m.ceccarelli@tnx.it", "alter table test_fatt_acquisto add column modalita_scarico int", "consegna");
                if (!InvoicexUtil.isSceltaTipoNumerazioneEseguita()) {
                    this.agg(467, "", "m.ceccarelli@tnx.it", "update dati_azienda set tipo_numerazione = 2, tipo_numerazione_confermata = 1", "numerazione");
                }
                this.agg(468, "", "m.ceccarelli@tnx.it", "update test_ordi set anno = year(data) where anno is null or anno != year(data)", "anno in data");
                this.agg(469, "", "m.ceccarelli@tnx.it", "update righ_ordi r join test_ordi t on r.id_padre = t.id set r.anno = year(t.data) where r.anno is null or r.anno != year(t.data)", "anno in data");
                this.agg(470, "", "m.ceccarelli@tnx.it", "update test_ddt set anno = year(data) where anno is null or anno != year(data)", "anno in data");
                this.agg(471, "", "m.ceccarelli@tnx.it", "update righ_ddt r join test_ddt t on r.id_padre = t.id set r.anno = year(t.data) where r.anno is null or r.anno != year(t.data)", "anno in data");
                this.agg(472, "", "m.ceccarelli@tnx.it", "update test_fatt set anno = year(data) where anno is null or anno != year(data)", "anno in data");
                this.agg(473, "", "m.ceccarelli@tnx.it", "update righ_fatt r join test_fatt t on r.id_padre = t.id set r.anno = year(t.data) where r.anno is null or r.anno != year(t.data)", "anno in data");
                this.agg(474, "", "m.ceccarelli@tnx.it", "update test_ordi_acquisto set anno = year(data) where anno is null or anno != year(data)", "anno in data");
                this.agg(475, "", "m.ceccarelli@tnx.it", "update righ_ordi_acquisto r join test_ordi_acquisto t on r.id_padre = t.id set r.anno = year(t.data) where r.anno is null or r.anno != year(t.data)", "anno in data");
                this.agg(476, "", "m.ceccarelli@tnx.it", "update test_ddt_acquisto set anno = year(data) where anno is null or anno != year(data)", "anno in data");
                this.agg(477, "", "m.ceccarelli@tnx.it", "update righ_ddt_acquisto r join test_ddt_acquisto t on r.id_padre = t.id set r.anno = year(t.data) where r.anno is null or r.anno != year(t.data)", "anno in data");
                this.agg(478, "", "m.ceccarelli@tnx.it", "update test_fatt_acquisto set anno = year(data) where anno is null or anno != year(data)", "anno in data");
                this.agg(479, "", "m.ceccarelli@tnx.it", "update righ_fatt_acquisto r join test_fatt_acquisto t on r.id_padre = t.id set r.anno = year(t.data) where r.anno is null or r.anno != year(t.data)", "anno in data");
                this.agg(480, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_fatt_acquisto` ADD COLUMN `color` VARCHAR(20) DEFAULT ''", "Aggiunta colonna per segnalazione colore");
                this.agg(481, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ordi` ADD COLUMN `color` VARCHAR(20) DEFAULT ''", "Aggiunta colonna per segnalazione colore");
                this.agg(482, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ordi_acquisto` ADD COLUMN `color` VARCHAR(20) DEFAULT ''", "Aggiunta colonna per segnalazione colore");
                this.agg(483, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ddt` ADD COLUMN `color` VARCHAR(20) DEFAULT ''", "Aggiunta colonna per segnalazione colore");
                this.agg(484, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ddt_acquisto` ADD COLUMN `color` VARCHAR(20) DEFAULT ''", "Aggiunta colonna per segnalazione colore");
                if (!InvoicexUtil.isPassaggio21eseguito()) {
                    block132: {
                        try {
                            if (!DbUtils.containRows((Connection)Db.getConn(), (String)"select * from codici_iva where codice = '21'")) {
                                DbUtils.tryExecQuery((Connection)Db.getConn(), (String)"insert into codici_iva set codice = '21', percentuale = 21, descrizione = 'Iva 21%', descrizione_breve = 'Iva 21%'");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            if (!DbUtils.containRows((Connection)Db.getConn(), (String)"select * from codici_iva where codice = '21'")) break block132;
                            try {
                                DbUtils.tryExecQuery((Connection)Db.getConn(), (String)"update articoli set iva = 21 where iva = 20");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            try {
                                DbUtils.tryExecQuery((Connection)Db.getConn(), (String)"update clie_forn set iva_standard = 21 where iva_standard = 20");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            try {
                                if (CastUtils.toString((Object)InvoicexUtil.getIvaDefault()).equals("20")) {
                                    DbUtils.tryExecQuery((Connection)Db.getConn(), (String)"update dati_azienda set codiceIvaDefault = '21'");
                                    main.fileIni.setValue("iva", "codiceIvaDefault", "21");
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            try {
                                if (CastUtils.toString((Object)InvoicexUtil.getIvaSpese("codiceIvaSpese")).equals("20")) {
                                    DbUtils.tryExecQuery((Connection)Db.getConn(), (String)"update dati_azienda set codiceIvaSpese = '21'");
                                    main.fileIni.setValue("iva", "codiceIvaSpese", "21");
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    main.fileIni.setValue("iva21", "eseguito", true);
                    try {
                        DbUtils.tryExecQuery((Connection)Db.getConn(), (String)"update dati_azienda set iva21eseguito = 'S'");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this.agg(485, "", "m.ceccarelli@tnx.it", "alter table righ_ordi add column totale_imponibile_netto decimal(15,5)", "prezzo netto unitario");
                this.agg(486, "", "m.ceccarelli@tnx.it", "alter table righ_ordi_acquisto add column totale_imponibile_netto decimal(15,5)", "prezzo netto unitario");
                this.agg(487, "", "m.ceccarelli@tnx.it", "alter table righ_ddt add column totale_imponibile_netto decimal(15,5)", "prezzo netto unitario");
                this.agg(488, "", "m.ceccarelli@tnx.it", "alter table righ_ddt_acquisto add column totale_imponibile_netto decimal(15,5)", "prezzo netto unitario");
                this.agg(489, "", "m.ceccarelli@tnx.it", "alter table righ_fatt add column totale_imponibile_netto decimal(15,5)", "prezzo netto unitario");
                this.agg(490, "", "m.ceccarelli@tnx.it", "alter table righ_fatt_acquisto add column totale_imponibile_netto decimal(15,5)", "prezzo netto unitario");
                this.agg(491, "", "m.ceccarelli@tnx.it", "alter table righ_ordi add column totale_iva_netto decimal(15,5)", "prezzo netto unitario");
                this.agg(492, "", "m.ceccarelli@tnx.it", "alter table righ_ordi_acquisto add column totale_iva_netto decimal(15,5)", "prezzo netto unitario");
                this.agg(493, "", "m.ceccarelli@tnx.it", "alter table righ_ddt add column totale_iva_netto decimal(15,5)", "prezzo netto unitario");
                this.agg(494, "", "m.ceccarelli@tnx.it", "alter table righ_ddt_acquisto add column totale_iva_netto decimal(15,5)", "prezzo netto unitario");
                this.agg(495, "", "m.ceccarelli@tnx.it", "alter table righ_fatt add column totale_iva_netto decimal(15,5)", "prezzo netto unitario");
                this.agg(496, "", "m.ceccarelli@tnx.it", "alter table righ_fatt_acquisto add column totale_iva_netto decimal(15,5)", "prezzo netto unitario");
                this.agg(497, "", "m.ceccarelli@tnx.it", "alter table righ_ordi add column totale_ivato_netto decimal(15,5)", "prezzo netto unitario");
                this.agg(498, "", "m.ceccarelli@tnx.it", "alter table righ_ordi_acquisto add column totale_ivato_netto decimal(15,5)", "prezzo netto unitario");
                this.agg(499, "", "m.ceccarelli@tnx.it", "alter table righ_ddt add column totale_ivato_netto decimal(15,5)", "prezzo netto unitario");
                this.agg(500, "", "m.ceccarelli@tnx.it", "alter table righ_ddt_acquisto add column totale_ivato_netto decimal(15,5)", "prezzo netto unitario");
                this.agg(501, "", "m.ceccarelli@tnx.it", "alter table righ_fatt add column totale_ivato_netto decimal(15,5)", "prezzo netto unitario");
                this.agg(502, "", "m.ceccarelli@tnx.it", "alter table righ_fatt_acquisto add column totale_ivato_netto decimal(15,5)", "prezzo netto unitario");
                this.agg(503, "", "m.ceccarelli@tnx.it", "alter table righ_ordi add column prezzo_ivato_netto_unitario decimal(15,5)", "prezzo netto unitario");
                this.agg(504, "", "m.ceccarelli@tnx.it", "alter table righ_ordi_acquisto add column prezzo_ivato_netto_unitario decimal(15,5)", "prezzo netto unitario");
                this.agg(505, "", "m.ceccarelli@tnx.it", "alter table righ_ddt add column prezzo_ivato_netto_unitario decimal(15,5)", "prezzo netto unitario");
                this.agg(506, "", "m.ceccarelli@tnx.it", "alter table righ_ddt_acquisto add column prezzo_ivato_netto_unitario decimal(15,5)", "prezzo netto unitario");
                this.agg(507, "", "m.ceccarelli@tnx.it", "alter table righ_fatt add column prezzo_ivato_netto_unitario decimal(15,5)", "prezzo netto unitario");
                this.agg(508, "", "m.ceccarelli@tnx.it", "alter table righ_fatt_acquisto add column prezzo_ivato_netto_unitario decimal(15,5)", "prezzo netto unitario");
                this.agg(509, "", "m.ceccarelli@tnx.it", "alter table righ_ordi add column prezzo_netto_totale decimal(15,5)", "prezzo netto totale");
                this.agg(510, "", "m.ceccarelli@tnx.it", "alter table righ_ordi_acquisto add column prezzo_netto_totale decimal(15,5)", "prezzo netto totale");
                this.agg(511, "", "m.ceccarelli@tnx.it", "alter table righ_ddt add column prezzo_netto_totale decimal(15,5)", "prezzo netto totale");
                this.agg(512, "", "m.ceccarelli@tnx.it", "alter table righ_ddt_acquisto add column prezzo_netto_totale decimal(15,5)", "prezzo netto totale");
                this.agg(513, "", "m.ceccarelli@tnx.it", "alter table righ_fatt add column prezzo_netto_totale decimal(15,5)", "prezzo netto totale");
                this.agg(514, "", "m.ceccarelli@tnx.it", "alter table righ_fatt_acquisto add column prezzo_netto_totale decimal(15,5)", "prezzo netto totale");
                this.agg(515, "", "m.ceccarelli@tnx.it", "drop view if exists v_righ_tutte", "vista per ultimi prezzi");
                this.agg(516, "", "m.ceccarelli@tnx.it", view1, "vista per ultimi prezzi");
                this.agg(517, "", "m.ceccarelli@tnx.it", "update clie_forn set provvigione_predefinita_cliente = null where provvigione_predefinita_cliente = 0", "update prov a 0");
                this.agg(518, "", "m.ceccarelli@tnx.it", "update clie_forn set provvigione_predefinita_fornitore = null where provvigione_predefinita_fornitore = 0", "update prov a 0");
                this.agg(519, "", "m.ceccarelli@tnx.it", "CREATE TABLE `attivazione` (\n\t`codice` VARCHAR(50) NOT NULL,\n\t`versione` VARCHAR(50) NULL DEFAULT NULL,\n\t`esito_log` VARCHAR(250) NULL DEFAULT NULL,\n\t`ts` TIMESTAMP NULL DEFAULT NULL,\n\tPRIMARY KEY (`codice`)\n) ENGINE=MyISAM\n", "attivazione");
                this.agg(521, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `iva22eseguito` CHAR(1)", "iva22eseguito");
                this.agg(522, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `iva22a21eseguito` CHAR(1)", "iva22a21eseguito");
                this.agg(523, "", "m.ceccarelli@tnx.it", "update test_ordi set anno = year(data) where anno is null or anno != year(data)", "anno in data");
                this.agg(524, "", "m.ceccarelli@tnx.it", "update righ_ordi r join test_ordi t on r.id_padre = t.id set r.anno = year(t.data) where r.anno is null or r.anno != year(t.data)", "anno in data");
                this.agg(525, "", "m.ceccarelli@tnx.it", "update test_ddt set anno = year(data) where anno is null or anno != year(data)", "anno in data");
                this.agg(526, "", "m.ceccarelli@tnx.it", "update righ_ddt r join test_ddt t on r.id_padre = t.id set r.anno = year(t.data) where r.anno is null or r.anno != year(t.data)", "anno in data");
                this.agg(527, "", "m.ceccarelli@tnx.it", "update test_fatt set anno = year(data) where anno is null or anno != year(data)", "anno in data");
                this.agg(528, "", "m.ceccarelli@tnx.it", "update righ_fatt r join test_fatt t on r.id_padre = t.id set r.anno = year(t.data) where r.anno is null or r.anno != year(t.data)", "anno in data");
                this.agg(529, "", "m.ceccarelli@tnx.it", "update test_ordi_acquisto set anno = year(data) where anno is null or anno != year(data)", "anno in data");
                this.agg(530, "", "m.ceccarelli@tnx.it", "update righ_ordi_acquisto r join test_ordi_acquisto t on r.id_padre = t.id set r.anno = year(t.data) where r.anno is null or r.anno != year(t.data)", "anno in data");
                this.agg(531, "", "m.ceccarelli@tnx.it", "update test_ddt_acquisto set anno = year(data) where anno is null or anno != year(data)", "anno in data");
                this.agg(532, "", "m.ceccarelli@tnx.it", "update righ_ddt_acquisto r join test_ddt_acquisto t on r.id_padre = t.id set r.anno = year(t.data) where r.anno is null or r.anno != year(t.data)", "anno in data");
                this.agg(533, "", "m.ceccarelli@tnx.it", "update test_fatt_acquisto set anno = year(data) where anno is null or anno != year(data)", "anno in data");
                this.agg(534, "", "m.ceccarelli@tnx.it", "update righ_fatt_acquisto r join test_fatt_acquisto t on r.id_padre = t.id set r.anno = year(t.data) where r.anno is null or r.anno != year(t.data)", "anno in data");
                this.agg(535, "", "m.ceccarelli@tnx.it", "alter table righ_ordi add column prezzo_ivato_netto_totale decimal(15,5)", "prezzo netto totale");
                this.agg(536, "", "m.ceccarelli@tnx.it", "alter table righ_ordi_acquisto add column prezzo_ivato_netto_totale decimal(15,5)", "prezzo netto totale");
                this.agg(537, "", "m.ceccarelli@tnx.it", "alter table righ_ddt add column prezzo_ivato_netto_totale decimal(15,5)", "prezzo netto totale");
                this.agg(538, "", "m.ceccarelli@tnx.it", "alter table righ_ddt_acquisto add column prezzo_ivato_netto_totale decimal(15,5)", "prezzo netto totale");
                this.agg(539, "", "m.ceccarelli@tnx.it", "alter table righ_fatt add column prezzo_ivato_netto_totale decimal(15,5)", "prezzo netto totale");
                this.agg(540, "", "m.ceccarelli@tnx.it", "alter table righ_fatt_acquisto add column prezzo_ivato_netto_totale decimal(15,5)", "prezzo netto totale");
                this.agg(541, "", "m.ceccarelli@tnx.it", "CREATE TABLE `categorie_articoli` (\n\t`id` INT(11) NOT NULL AUTO_INCREMENT,\n\t`categoria` VARCHAR(250) NULL DEFAULT NULL,\n\tPRIMARY KEY (`id`), UNIQUE INDEX `categoria` (`categoria`)) ENGINE=MyISAM", "categorie articoli");
                this.agg(542, "", "m.ceccarelli@tnx.it", "CREATE TABLE `sottocategorie_articoli` (\n\t`id` INT(11) NOT NULL AUTO_INCREMENT,\n\t`id_padre` INT(11) NULL DEFAULT NULL,\n\t`sottocategoria` VARCHAR(250) NULL DEFAULT NULL,\n\tPRIMARY KEY (`id`), UNIQUE INDEX `id_padre_sottocategoria` (`id_padre`, `sottocategoria`)) ENGINE=MyISAM", "sottocategorie articoli");
                this.agg(543, "", "m.ceccarelli@tnx.it", "alter table articoli add column categoria int null", "categeroia");
                this.agg(544, "", "m.ceccarelli@tnx.it", "alter table articoli add column sottocategoria int null", "sottocategeroia");
                this.agg(545, "", "m.ceccarelli@tnx.it", "CREATE TABLE `clie_forn_agenti` (\n\t`id` INT(11) NOT NULL AUTO_INCREMENT,\n\t`id_clifor` INT(11) NULL DEFAULT NULL,\n\t`id_agente` INT(11) NULL DEFAULT NULL,\n\tprovvigione DECIMAL(5,2) NULL,\n\tPRIMARY KEY (`id`),\n\tUNIQUE INDEX `id_clifor_id_agente` (`id_clifor`, `id_agente`)) ENGINE=MyISAM", "clifor agenti");
                this.agg(546, "", "m.ceccarelli@tnx.it", "alter table stampa_iva_semplice add column id_fattura int NULL DEFAULT NULL", "id del documento");
                this.agg(547, "", "m.ceccarelli@tnx.it", "alter table stampa_iva_semplice add column id_clifor int NULL DEFAULT NULL", "id del clifor");
                this.agg(548, "", "m.ceccarelli@tnx.it", "alter table stampa_iva_semplice add column piva_cfiscale varchar(20) NULL DEFAULT NULL", "piva o cfiscale");
                this.agg(550, "", "m.ceccarelli@tnx.it", "alter table movimenti_magazzino add prezzo_medio decimal(15,5) null", "nuovi campi mov mag");
                this.agg(551, "", "m.ceccarelli@tnx.it", "alter table movimenti_magazzino add da_id_riga int null", "nuovi campi mov mag");
                this.agg(552, "", "m.ceccarelli@tnx.it", "alter table movimenti_magazzino_eliminati add prezzo_medio decimal(15,5) null", "nuovi campi mov mag");
                this.agg(553, "", "m.ceccarelli@tnx.it", "alter table movimenti_magazzino_eliminati add da_id_riga int null", "nuovi campi mov mag");
                this.agg(554, "", "m.ceccarelli@tnx.it", "alter table tipi_fatture add segno tinyint null", "segno per note di credito");
                this.agg(555, "", "m.ceccarelli@tnx.it", "update tipi_fatture set segno = 1", "segno per note di credito");
                this.agg(556, "", "m.ceccarelli@tnx.it", "update tipi_fatture set segno = -1 where tipo = 3", "segno per note di credito");
                this.agg(557, "", "m.ceccarelli@tnx.it", "update test_fatt_acquisto set tipo_fattura = 7", "segno per note di credito");
                this.agg(558, "", "m.ceccarelli@tnx.it", "CREATE TABLE `tipi_fatture_acquisto` (  `tipo` TINYINT(4) NOT NULL DEFAULT '0', `descrizione_breve` CHAR(3) NULL DEFAULT NULL,  `descrizione` VARCHAR(100) NULL DEFAULT NULL,  `segno` TINYINT(4) NULL DEFAULT NULL,  PRIMARY KEY (`tipo`)  ) ENGINE=MyISAM", "nuova tab tipi_fatture_acquisto");
                this.agg(559, "", "m.ceccarelli@tnx.it", "insert into tipi_fatture_acquisto set tipo = 7 , descrizione_breve = 'F', descrizione = 'FATTURA', segno = 1", "segno per note di credito");
                this.agg(560, "", "m.ceccarelli@tnx.it", "insert into tipi_fatture_acquisto set tipo = 9 , descrizione_breve = 'NC', descrizione = 'NOTA DI CREDITO', segno = -1", "segno per note di credito");
                this.agg(561, "", "m.ceccarelli@tnx.it", "CREATE TABLE `depositi` ( `id` SMALLINT(11) NOT NULL AUTO_INCREMENT, `nome` VARCHAR(255) NULL DEFAULT NULL, `indirizzo` VARCHAR(100) NULL DEFAULT NULL, `cap` VARCHAR(10) NULL DEFAULT NULL, `localita` VARCHAR(100) NULL DEFAULT NULL, `provincia` VARCHAR(5) NULL DEFAULT NULL, `paese` CHAR(2) NULL DEFAULT NULL, `intestazione_personalizzata` CHAR(1) NULL DEFAULT NULL, `logo` MEDIUMBLOB NULL, `logo_nome_file` VARCHAR(255) NULL DEFAULT NULL, `logo_data_modifica` BIGINT(20) NULL DEFAULT NULL, `logo_dimensione` BIGINT(20) NULL DEFAULT NULL, `intestazione_riga1` VARCHAR(255) NULL DEFAULT NULL, `intestazione_riga2` VARCHAR(255) NULL DEFAULT NULL, `intestazione_riga3` VARCHAR(255) NULL DEFAULT NULL, `intestazione_riga4` VARCHAR(255) NULL DEFAULT NULL, `intestazione_riga5` VARCHAR(255) NULL DEFAULT NULL, `intestazione_riga6` VARCHAR(255) NULL DEFAULT NULL, PRIMARY KEY (`id`) ) ENGINE=MyISAM", "multimagazzino");
                this.agg(562, "", "m.ceccarelli@tnx.it", "INSERT INTO `depositi` (`id`, `nome`) VALUES (1, 'Deposito predefinito');", "multimagazzino");
                this.agg(563, "", "m.ceccarelli@tnx.it", "update depositi set id = 0 where id = 1", "multimagazzino");
                this.agg(564, "", "m.ceccarelli@tnx.it", "alter table test_ddt add column deposito smallint not null default '0'", "multimagazzino");
                this.agg(565, "", "m.ceccarelli@tnx.it", "alter table test_ordi add column deposito smallint not null default '0'", "multimagazzino");
                this.agg(566, "", "m.ceccarelli@tnx.it", "alter table test_fatt add column deposito smallint not null default '0'", "multimagazzino");
                this.agg(567, "", "m.ceccarelli@tnx.it", "alter table test_ddt_acquisto add column deposito smallint not null default '0'", "multimagazzino");
                this.agg(568, "", "m.ceccarelli@tnx.it", "alter table test_ordi_acquisto add column deposito smallint not null default '0'", "multimagazzino");
                this.agg(569, "", "m.ceccarelli@tnx.it", "alter table test_fatt_acquisto add column deposito smallint not null default '0'", "multimagazzino");
                this.agg(570, "", "m.ceccarelli@tnx.it", "alter table test_ddt add column deposito_arrivo smallint null", "multimagazzino");
                this.agg(571, "", "m.ceccarelli@tnx.it", "alter table test_ordi add column deposito_arrivo smallint null", "multimagazzino");
                this.agg(572, "", "m.ceccarelli@tnx.it", "alter table test_fatt add column deposito_arrivo smallint null", "multimagazzino");
                this.agg(573, "", "m.ceccarelli@tnx.it", "alter table test_ddt_acquisto add column deposito_arrivo smallint null", "multimagazzino");
                this.agg(574, "", "m.ceccarelli@tnx.it", "alter table test_ordi_acquisto add column deposito_arrivo smallint null", "multimagazzino");
                this.agg(575, "", "m.ceccarelli@tnx.it", "alter table test_fatt_acquisto add column deposito_arrivo smallint null", "multimagazzino");
                this.agg(576, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_fatt\tADD INDEX `codice_articolo` (`codice_articolo`);", "miglioria giacenze");
                this.agg(577, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_fatt_acquisto\tADD INDEX `codice_articolo` (`codice_articolo`);", "miglioria giacenze");
                this.agg(578, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt\tADD INDEX `codice_articolo` (`codice_articolo`);", "miglioria giacenze");
                this.agg(579, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt_acquisto\tADD INDEX `codice_articolo` (`codice_articolo`);", "miglioria giacenze");
                this.agg(580, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ordi\tADD INDEX `codice_articolo` (`codice_articolo`);", "miglioria giacenze");
                this.agg(581, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ordi_acquisto\tADD INDEX `codice_articolo` (`codice_articolo`);", "miglioria giacenze");
                this.agg(582, "", "m.ceccarelli@tnx.it", "ALTER TABLE scadenze add column importo_pagato DECIMAL(15,5)", "migliorie scadenze");
                this.agg(583, "", "m.ceccarelli@tnx.it", "ALTER TABLE scadenze add column importo_da_pagare DECIMAL(15,5)", "migliorie scadenze");
                this.agg(584, "", "m.ceccarelli@tnx.it", "ALTER TABLE scadenze add column ultimo_pagamento DATE", "migliorie scadenze");
                this.agg(586, "", "m.ceccarelli@tnx.it", "ALTER TABLE scadenze add column numero_totale int", "migliorie scadenze");
                this.agg(588, "", "m.ceccarelli@tnx.it", "alter table articoli add prezzo_medio decimal(15,5) null", "nuovi campi mov mag");
                String view2 = "create view v_righ_tutte as  SELECT 'v' as tabella, r.id, r.id_padre, t.data, t.anno, t.numero, t.serie, r.riga, r.codice_articolo, r.descrizione\n, r.quantita, r.prezzo, r.prezzo_netto_unitario, r.sconto1, r.sconto2, t.sconto1 as sconto1t, t.sconto2 as sconto2t, t.sconto3 as sconto3t\n, c.codice as clifor, c.ragione_sociale, t.tipo_fattura, tf.segno, tf.descrizione as tf_descrizione, tf.descrizione_breve as tf_descrizione_breve \nfrom righ_fatt r \njoin test_fatt t on r.id_padre = t.id\njoin tipi_fatture tf on t.tipo_fattura = tf.tipo \njoin clie_forn c on t.cliente = c.codice\nunion all \nSELECT 'a' as tabella, r.id, r.id_padre, t.data, t.anno, t.numero, t.serie, r.riga, r.codice_articolo, r.descrizione\n, r.quantita, r.prezzo, r.prezzo_netto_unitario, r.sconto1, r.sconto2, t.sconto1 as sconto1t, t.sconto2 as sconto2t, t.sconto3 as sconto3t\n, c.codice as clifor, c.ragione_sociale, t.tipo_fattura, tf.segno, tf.descrizione as tf_descrizione, tf.descrizione_breve as tf_descrizione_breve \nfrom righ_fatt_acquisto r \njoin test_fatt_acquisto t on r.id_padre = t.id\njoin tipi_fatture_acquisto tf on t.tipo_fattura = tf.tipo \njoin clie_forn c on t.fornitore = c.codice";
                this.agg(589, "", "m.ceccarelli@tnx.it", "drop view if exists v_righ_tutte", "vista per ultimi prezzi");
                this.agg(590, "", "m.ceccarelli@tnx.it", view2, "vista per ultimi prezzi");
                this.agg(591, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_fatt_acquisto_matricole ADD COLUMN (`id` INTEGER NOT NULL AUTO_INCREMENT , `id_padre` INTEGER NOT NULL), DROP PRIMARY KEY, ADD PRIMARY KEY (`id`), ADD INDEX `INDEX` (`serie`, `numero`, `anno`, `riga`, `matricola`)", "Aggiungo campo id a righ_fatt_matricole per la generazione dei movimenti");
                this.agg(592, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt_matricole ADD COLUMN (`id` INTEGER NOT NULL AUTO_INCREMENT , `id_padre` INTEGER NOT NULL), DROP PRIMARY KEY, ADD PRIMARY KEY (`id`), ADD INDEX `INDEX` (`serie`, `numero`, `anno`, `riga`, `matricola`)", "Aggiungo campo id a righ_fatt_matricole per la generazione dei movimenti");
                this.agg(593, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt_acquisto_matricole ADD COLUMN (`id` INTEGER NOT NULL AUTO_INCREMENT , `id_padre` INTEGER NOT NULL), DROP PRIMARY KEY, ADD PRIMARY KEY (`id`), ADD INDEX `INDEX` (`serie`, `numero`, `anno`, `riga`, `matricola`)", "Aggiungo campo id a righ_fatt_matricole per la generazione dei movimenti");
                this.agg(594, "", "m.ceccarelli@tnx.it", "update righ_fatt_acquisto_matricole m, test_fatt_acquisto t set m.id_padre = t.id where m.serie = t.serie and m.numero = t.numero and m.anno = t.anno", "correggo mancanza id_padre per matricole");
                this.agg(595, "", "m.ceccarelli@tnx.it", "update righ_ddt_matricole m, test_ddt t set m.id_padre = t.id where m.serie = t.serie and m.numero = t.numero and m.anno = t.anno", "correggo mancanza id_padre per matricole");
                this.agg(596, "", "m.ceccarelli@tnx.it", "update righ_ddt_acquisto_matricole m, test_ddt_acquisto t set m.id_padre = t.id where m.serie = t.serie and m.numero = t.numero and m.anno = t.anno", "correggo mancanza id_padre per matricole");
                this.agg(598, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `label_fornitore` VARCHAR(100) DEFAULT 'Fornitore'", "Etichetta fornitore");
                this.agg(599, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `label_fornitore_eng` VARCHAR(100) DEFAULT 'Supplier'", "Etichetta fornitore");
                this.agg(600, "", "m.ceccarelli@tnx.it", "update dati_azienda set label_fornitore = 'Fornitore', label_fornitore_eng = 'Supplier'", "etichetta fornitore");
                this.agg(601, "", "m.ceccarelli@tnx.it", "CREATE TABLE movimenti_magazzino_storico LIKE movimenti_magazzino ENGINE=MyISAM", "storico movimenti");
                this.agg(603, "", "m.ceccarelli@tnx.it", "CREATE TABLE `storicizzazioni` (`id` INT NOT NULL AUTO_INCREMENT,`tabella` VARCHAR(50) NULL DEFAULT NULL,`inizio` TIMESTAMP NULL DEFAULT NULL,`fine` TIMESTAMP NULL DEFAULT NULL,PRIMARY KEY (`id`)) ENGINE=MyISAM", "tabella storicizzazioni");
                this.agg(604, "", "m.ceccarelli@tnx.it", "ALTER TABLE movimenti_magazzino add id_storicizzazione INT", "aggiungo id_storicizzazione");
                this.agg(605, "", "m.ceccarelli@tnx.it", "ALTER TABLE movimenti_magazzino_eliminati add id_storicizzazione INT", "aggiungo id_storicizzazione");
                this.agg(606, "", "m.ceccarelli@tnx.it", "ALTER TABLE movimenti_magazzino_storico add id_storicizzazione INT", "aggiungo id_storicizzazione");
                this.agg(607, "", "m.ceccarelli@tnx.it", "CREATE TABLE `test_fatt_iva` ( `id_padre` INT(10) UNSIGNED NOT NULL DEFAULT '0', `codice_iva` CHAR(3) NOT NULL DEFAULT '', `perc_iva` DECIMAL(5,2) NOT NULL DEFAULT '0.00', `imponibile` DECIMAL(15,5) NOT NULL DEFAULT '0.00000', `iva` DECIMAL(15,5) NOT NULL DEFAULT '0.00000', `totale` DECIMAL(15,5) NOT NULL DEFAULT '0.00000', PRIMARY KEY (`id_padre`, `codice_iva`) ) ENGINE=MyISAM", "tabelle per export fatseq");
                this.agg(608, "", "m.ceccarelli@tnx.it", "CREATE TABLE `test_fatt_acquisto_iva` ( `id_padre` INT(10) UNSIGNED NOT NULL DEFAULT '0', `codice_iva` CHAR(3) NOT NULL DEFAULT '', `perc_iva` DECIMAL(5,2) NOT NULL DEFAULT '0.00', `imponibile` DECIMAL(15,5) NOT NULL DEFAULT '0.00000', `iva` DECIMAL(15,5) NOT NULL DEFAULT '0.00000', `totale` DECIMAL(15,5) NOT NULL DEFAULT '0.00000', PRIMARY KEY (`id_padre`, `codice_iva`) ) ENGINE=MyISAM", "tabelle per export fatseq");
                this.agg(609, "", "m.ceccarelli@tnx.it", "alter table test_fatt add `ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP", "ts gen totali");
                this.agg(610, "", "m.ceccarelli@tnx.it", "alter table test_fatt add `ts_gen_totali` TIMESTAMP NULL DEFAULT NULL", "ts gen totali");
                this.agg(611, "", "m.ceccarelli@tnx.it", "alter table test_fatt_acquisto add `ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP", "ts gen totali");
                this.agg(612, "", "m.ceccarelli@tnx.it", "alter table test_fatt_acquisto add `ts_gen_totali` TIMESTAMP NULL DEFAULT NULL", "ts gen totali");
                this.agg(613, "", "m.ceccarelli@tnx.it", "alter table righ_fatt add `ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP", "ts gen totali");
                this.agg(614, "", "m.ceccarelli@tnx.it", "alter table righ_fatt add `ts_gen_totali` TIMESTAMP NULL DEFAULT NULL", "ts gen totali");
                this.agg(615, "", "m.ceccarelli@tnx.it", "alter table righ_fatt_acquisto add `ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP", "ts gen totali");
                this.agg(616, "", "m.ceccarelli@tnx.it", "alter table righ_fatt_acquisto add `ts_gen_totali` TIMESTAMP NULL DEFAULT NULL", "ts gen totali");
                this.agg(617, "", "m.ceccarelli@tnx.it", "alter table clie_forn add note_consegna TEXT NULL", "note consegna");
                this.agg(618, "", "m.ceccarelli@tnx.it", "alter table test_ordi add note_consegna TEXT NULL", "consegna");
                this.agg(619, "", "m.ceccarelli@tnx.it", "alter table test_ddt add note_consegna TEXT NULL", "consegna");
                this.agg(620, "", "m.ceccarelli@tnx.it", "alter table test_fatt add note_consegna TEXT NULL", "consegna");
                this.agg(621, "", "m.ceccarelli@tnx.it", "alter table test_ordi_acquisto add note_consegna TEXT NULL", "consegna");
                this.agg(622, "", "m.ceccarelli@tnx.it", "alter table test_ddt_acquisto add note_consegna TEXT NULL", "consegna");
                this.agg(623, "", "m.ceccarelli@tnx.it", "alter table test_fatt_acquisto add note_consegna TEXT NULL", "consegna");
                this.agg(624, "", "m.ceccarelli@tnx.it", "CREATE TABLE `files` (`id` INT(11) NOT NULL AUTO_INCREMENT,`bytes` LONGBLOB NULL,\tPRIMARY KEY (`id`)) ENGINE=MyISAM;", "tabella files");
                this.agg(625, "", "m.ceccarelli@tnx.it", "ALTER TABLE `files` ADD COLUMN `filename` VARCHAR(1000) NULL AFTER `bytes`, ADD COLUMN `lastmodified` TIMESTAMP NULL AFTER `filename`,\tADD COLUMN `type` CHAR(3) NULL AFTER `lastmodified`,\tADD COLUMN `size` INT NULL AFTER `type`", "aggiunte a files");
                this.agg(626, "", "m.ceccarelli@tnx.it", "ALTER TABLE `files` ADD COLUMN `md5` VARCHAR(32) NULL", "aggiunte a files");
                this.agg(627, "", "m.ceccarelli@tnx.it", "ALTER TABLE `files` ADD UNIQUE INDEX `md5` (`md5`);", "aggiunte a files");
                this.agg(628, "", "m.ceccarelli@tnx.it", "CREATE TABLE `files_documenti` (\n\t`id` INT(11) NOT NULL AUTO_INCREMENT,\n\t`tabella_doc` CHAR(20) NULL DEFAULT NULL,\n\t`id_doc` INT(11) NULL DEFAULT NULL,\n\t`id_file` INT(11) NULL DEFAULT NULL,\n\tPRIMARY KEY (`id`),\n\tUNIQUE INDEX `tabella_doc_id_doc_id_files` (`tabella_doc`, `id_doc`, `id_file`)\n) ENGINE=MyISAM", "files_documenti");
                this.agg(629, "", "m.ceccarelli@tnx.it", "ALTER TABLE `clie_forn_dest`\n\tADD COLUMN `id` INT NOT NULL AUTO_INCREMENT FIRST,\n\tDROP PRIMARY KEY,\n\tADD PRIMARY KEY (`id`);", "cambio chiave dest diverse clienti");
                this.agg(630, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ddt`\tADD COLUMN `id_cliente_destinazione` INT(10) UNSIGNED NULL DEFAULT NULL AFTER `cliente_destinazione`;", "id per dest div");
                this.agg(631, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_fatt`\tADD COLUMN `id_cliente_destinazione` INT(10) UNSIGNED NULL DEFAULT NULL AFTER `cliente_destinazione`;", "id per dest div");
                this.agg(632, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ordi`\tADD COLUMN `id_cliente_destinazione` INT(10) UNSIGNED NULL DEFAULT NULL AFTER `cliente_destinazione`;", "id per dest div");
                this.agg(633, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ddt_acquisto`\tADD COLUMN `id_fornitore_destinazione` INT(10) UNSIGNED NULL DEFAULT NULL AFTER `fornitore_destinazione`;", "id per dest div");
                this.agg(635, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ordi_acquisto`\tADD COLUMN `id_fornitore_destinazione` INT(10) UNSIGNED NULL DEFAULT NULL AFTER `fornitore_destinazione`;", "id per dest div");
                this.agg(636, "", "m.ceccarelli@tnx.it", "UPDATE test_ddt t INNER JOIN clie_forn_dest d on d.codice_cliente = t.cliente and d.codice = t.cliente_destinazione SET t.id_cliente_destinazione = d.id", "id per dest div");
                this.agg(637, "", "m.ceccarelli@tnx.it", "UPDATE test_ordi t INNER JOIN clie_forn_dest d on d.codice_cliente = t.cliente and d.codice = t.cliente_destinazione SET t.id_cliente_destinazione = d.id", "id per dest div");
                this.agg(638, "", "m.ceccarelli@tnx.it", "UPDATE test_fatt t INNER JOIN clie_forn_dest d on d.codice_cliente = t.cliente and d.codice = t.cliente_destinazione SET t.id_cliente_destinazione = d.id", "id per dest div");
                this.agg(639, "", "m.ceccarelli@tnx.it", "UPDATE test_ddt_acquisto t INNER JOIN clie_forn_dest d on d.codice_cliente = t.fornitore and d.codice = t.fornitore_destinazione SET t.id_fornitore_destinazione = d.id", "id per dest div");
                this.agg(640, "", "m.ceccarelli@tnx.it", "UPDATE test_ordi_acquisto t INNER JOIN clie_forn_dest d on d.codice_cliente = t.fornitore and d.codice = t.fornitore_destinazione SET t.id_fornitore_destinazione = d.id", "id per dest div");
                this.agg(642, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ddt` CHANGE COLUMN `cliente_destinazione` `old_cliente_destinazione` INT(10) UNSIGNED NULL DEFAULT NULL", "id dest div");
                this.agg(643, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ordi` CHANGE COLUMN `cliente_destinazione` `old_cliente_destinazione` INT(10) UNSIGNED NULL DEFAULT NULL", "id dest div");
                this.agg(644, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_fatt` CHANGE COLUMN `cliente_destinazione` `old_cliente_destinazione` INT(10) UNSIGNED NULL DEFAULT NULL", "id dest div");
                this.agg(645, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ddt_acquisto` CHANGE COLUMN `fornitore_destinazione` `old_fornitore_destinazione` INT(10) UNSIGNED NULL DEFAULT NULL", "id dest div");
                this.agg(646, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ordi_acquisto` CHANGE COLUMN `fornitore_destinazione` `old_fornitore_destinazione` INT(10) UNSIGNED NULL DEFAULT NULL", "id dest div");
                this.agg(647, "", "m.ceccarelli@tnx.it", "ALTER TABLE `clie_forn_dest` CHANGE COLUMN `codice` `old_codice` INT(10) UNSIGNED NULL DEFAULT NULL", "id dest div");
                this.agg(648, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ddt` add column `cliente_destinazione` INT(10) UNSIGNED NULL DEFAULT NULL AFTER `id_cliente_destinazione`", "id dest div");
                this.agg(649, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ordi` add column `cliente_destinazione` INT(10) UNSIGNED NULL DEFAULT NULL AFTER `id_cliente_destinazione`", "id dest div");
                this.agg(650, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_fatt` add column `cliente_destinazione` INT(10) UNSIGNED NULL DEFAULT NULL AFTER `id_cliente_destinazione`", "id dest div");
                this.agg(651, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ddt_acquisto` add column `fornitore_destinazione` INT(10) UNSIGNED NULL DEFAULT NULL AFTER `id_fornitore_destinazione`", "id dest div");
                this.agg(652, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ordi_acquisto` add column `fornitore_destinazione` INT(10) UNSIGNED NULL DEFAULT NULL AFTER `id_fornitore_destinazione`", "id dest div");
                this.agg(653, "", "m.ceccarelli@tnx.it", "update articoli set codice = rtrim(codice)", "rtrim");
                this.agg(654, "", "m.ceccarelli@tnx.it", "update articoli_prezzi set articolo = rtrim(articolo)", "rtrim");
                this.agg(655, "", "m.ceccarelli@tnx.it", "UPDATE righ_fatt set codice_articolo = rtrim(codice_articolo)", "rtrim");
                this.agg(656, "", "m.ceccarelli@tnx.it", "UPDATE righ_fatt_acquisto set codice_articolo = rtrim(codice_articolo)", "rtrim");
                this.agg(657, "", "m.ceccarelli@tnx.it", "UPDATE righ_ddt set codice_articolo = rtrim(codice_articolo)", "rtrim");
                this.agg(658, "", "m.ceccarelli@tnx.it", "UPDATE righ_ddt_acquisto set codice_articolo = rtrim(codice_articolo)", "rtrim");
                this.agg(659, "", "m.ceccarelli@tnx.it", "UPDATE righ_ordi set codice_articolo = rtrim(codice_articolo)", "rtrim");
                this.agg(660, "", "m.ceccarelli@tnx.it", "UPDATE righ_ordi_acquisto set codice_articolo = rtrim(codice_articolo)", "rtrim");
                this.agg(661, "", "m.ceccarelli@tnx.it", "UPDATE movimenti_magazzino set articolo = rtrim(articolo)", "rtrim");
                this.agg(662, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi_acquisto CHANGE COLUMN spese_varie spese_varie DECIMAL(15,5) NULL DEFAULT NULL", "decimal ordi acquisto");
                this.agg(663, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi_acquisto CHANGE COLUMN totale_imponibile totale_imponibile DECIMAL(15,5) NULL DEFAULT NULL", "decimal ordi acquisto");
                this.agg(664, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi_acquisto CHANGE COLUMN totale_iva totale_iva DECIMAL(15,5) NULL DEFAULT NULL", "decimal ordi acquisto");
                this.agg(665, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi_acquisto CHANGE COLUMN totale totale DECIMAL(15,5) NULL DEFAULT NULL", "decimal ordi acquisto");
                this.agg(666, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi_acquisto CHANGE COLUMN sconto1 sconto1 DECIMAL(5,2) NULL DEFAULT NULL", "decimal ordi acquisto");
                this.agg(667, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi_acquisto CHANGE COLUMN sconto2 sconto2 DECIMAL(5,2) NULL DEFAULT NULL", "decimal ordi acquisto");
                this.agg(668, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi_acquisto CHANGE COLUMN sconto3 sconto3 DECIMAL(5,2) NULL DEFAULT NULL", "decimal ordi acquisto");
                this.agg(669, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi_acquisto CHANGE COLUMN spese_trasporto spese_trasporto DECIMAL(15,5) NULL DEFAULT NULL", "decimal ordi acquisto");
                this.agg(670, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi_acquisto CHANGE COLUMN spese_incasso spese_incasso DECIMAL(15,5) NULL DEFAULT NULL", "decimal ordi acquisto");
                this.agg(671, "", "m.ceccarelli@tnx.it", "ALTER TABLE codici_iva add codice_natura_xmlpa VARCHAR(10) NULL", "export xml pa iva");
                this.agg(672, "", "m.ceccarelli@tnx.it", "update codici_iva set codice_natura_xmlpa = 'N4' where descrizione like '%esent%'", "preimposto codice xmlpa");
                this.agg(673, "", "m.ceccarelli@tnx.it", "update codici_iva set codice_natura_xmlpa = 'N1' where descrizione like '%art.15%'", "preimposto codice xmlpa");
                this.agg(674, "", "m.ceccarelli@tnx.it", "update codici_iva set codice_natura_xmlpa = 'N1' where descrizione like '%art. 15%'", "preimposto codice xmlpa");
                this.agg(675, "", "m.ceccarelli@tnx.it", "update codici_iva set codice_natura_xmlpa = 'N2' where descrizione like '%Non soggett%'", "preimposto codice xmlpa");
                this.agg(676, "", "m.ceccarelli@tnx.it", "update codici_iva set codice_natura_xmlpa = 'N3' where descrizione like '%Non imponibil%'", "preimposto codice xmlpa");
                this.agg(677, "", "m.ceccarelli@tnx.it", "ALTER TABLE pagamenti add codice_xmlpa VARCHAR(10) NULL", "export xml pa pagamento");
                this.agg(678, "", "m.ceccarelli@tnx.it", "update pagamenti set codice_xmlpa = 'MP12' where codice like 'RB %'", "preimposto codice xmlpa");
                this.agg(679, "", "m.ceccarelli@tnx.it", "update pagamenti set codice_xmlpa = 'MP12' where codice like 'R.B.%'", "preimposto codice xmlpa");
                this.agg(680, "", "m.ceccarelli@tnx.it", "update pagamenti set codice_xmlpa = 'MP12' where codice like 'RIBA %'", "preimposto codice xmlpa");
                this.agg(681, "", "m.ceccarelli@tnx.it", "update pagamenti set codice_xmlpa = 'MP01' where codice like 'R.D.'", "preimposto codice xmlpa");
                this.agg(682, "", "m.ceccarelli@tnx.it", "update pagamenti set codice_xmlpa = 'MP01' where descrizione like '%contant%'", "preimposto codice xmlpa");
                this.agg(683, "", "m.ceccarelli@tnx.it", "update pagamenti set codice_xmlpa = 'MP05' where codice like 'BONIFICO%'", "preimposto codice xmlpa");
                this.agg(684, "", "m.ceccarelli@tnx.it", "update pagamenti set codice_xmlpa = 'MP05' where descrizione like '%BONIFICO%'", "preimposto codice xmlpa");
                this.agg(685, "", "m.ceccarelli@tnx.it", "CREATE TABLE `valute` ( `codice` CHAR(3) NOT NULL, `simbolo` VARCHAR(5) NOT NULL,`descrizione` VARCHAR(100) NOT NULL,PRIMARY KEY (`codice`)) ENGINE=MyISAM", "valute");
                this.agg(686, "", "m.ceccarelli@tnx.it", "INSERT INTO `valute` (`codice`, `simbolo`, `descrizione`) VALUES ('EUR', '\u20ac', 'Euro')", "valute");
                this.agg(687, "", "m.ceccarelli@tnx.it", "INSERT INTO `valute` (`codice`, `simbolo`, `descrizione`) VALUES ('USD', '$', 'Dollaro USA')", "valute");
                this.agg(688, "", "m.ceccarelli@tnx.it", "INSERT INTO `valute` (`codice`, `simbolo`, `descrizione`) VALUES ('GBP', '\u00a3', 'Sterlina Inglese')", "valute");
                this.agg(689, "", "m.ceccarelli@tnx.it", "INSERT INTO `valute` (`codice`, `simbolo`, `descrizione`) VALUES ('CHF', 'CHF', 'Franco Svizzero')", "valute");
                this.agg(690, "", "m.ceccarelli@tnx.it", "INSERT INTO `valute` (`codice`, `simbolo`, `descrizione`) VALUES ('JPY', '\u00a5', 'Yen Giapponese')", "valute");
                this.agg(691, "", "m.ceccarelli@tnx.it", "INSERT INTO `valute` (`codice`, `simbolo`, `descrizione`) VALUES ('CNY', '\u00a5', 'Yuan Cinese')", "valute");
                this.agg(692, "", "m.ceccarelli@tnx.it", "INSERT INTO `valute` (`codice`, `simbolo`, `descrizione`) VALUES ('NZD', '$', 'Dollaro Neozelandese')", "valute");
                this.agg(693, "", "m.ceccarelli@tnx.it", "INSERT INTO `valute` (`codice`, `simbolo`, `descrizione`) VALUES ('INR', '\u20a8', 'Rupia Indiana')", "valute");
                this.agg(694, "", "m.ceccarelli@tnx.it", "INSERT INTO `valute` (`codice`, `simbolo`, `descrizione`) VALUES ('RUB', '\u0440\u0443\u0431', 'Rublo Russo')", "valute");
                this.agg(695, "", "m.ceccarelli@tnx.it", "INSERT INTO `valute` (`codice`, `simbolo`, `descrizione`) VALUES ('AUD', '$', 'Dollaro Australiano')", "valute");
                this.agg(696, "", "m.ceccarelli@tnx.it", "INSERT INTO `valute` (`codice`, `simbolo`, `descrizione`) VALUES ('ALL', 'Lek', 'Lek Albanese')", "valute");
                this.agg(697, "", "m.ceccarelli@tnx.it", "INSERT INTO `valute` (`codice`, `simbolo`, `descrizione`) VALUES ('BRL', 'R$', 'Real Brasiliano')", "valute");
                this.agg(698, "", "m.ceccarelli@tnx.it", "alter table test_ddt add column valuta char(3) null", "valuta");
                this.agg(699, "", "m.ceccarelli@tnx.it", "alter table test_ordi add column valuta char(3) null", "valuta");
                this.agg(700, "", "m.ceccarelli@tnx.it", "alter table test_fatt add column valuta char(3) null", "valuta");
                this.agg(701, "", "m.ceccarelli@tnx.it", "alter table test_ddt_acquisto add column valuta char(3) null", "valuta");
                this.agg(702, "", "m.ceccarelli@tnx.it", "alter table test_ordi_acquisto add column valuta char(3) null", "valuta");
                this.agg(703, "", "m.ceccarelli@tnx.it", "alter table test_fatt_acquisto add column valuta char(3) null", "valuta");
                this.agg(704, "", "m.ceccarelli@tnx.it", "alter table test_fatt add column valuta char(3) null", "valuta");
                this.agg(705, "", "m.ceccarelli@tnx.it", "CREATE TABLE `test_fatt_xmlpa` (\n\t`id_fattura` INT(11) NOT NULL,\n\t`dg_doa_riferimentonumerolinea` VARCHAR(4) NULL DEFAULT NULL,\n\t`dg_doa_iddocumento` VARCHAR(20) NULL DEFAULT NULL,\n\t`dg_doa_data` DATE NULL DEFAULT NULL,\n\t`dg_doa_numitem` VARCHAR(20) NULL DEFAULT NULL,\n\t`dg_doa_codicecommessaconvenzione` VARCHAR(100) NULL DEFAULT NULL,\n\t`dg_doa_codicecup` VARCHAR(15) NULL DEFAULT NULL,\n\t`dg_doa_codicecig` VARCHAR(15) NULL DEFAULT NULL,\n\t`dg_dc_riferimentonumerolinea` VARCHAR(4) NULL DEFAULT NULL,\n\t`dg_dc_iddocumento` VARCHAR(20) NULL DEFAULT NULL,\n\t`dg_dc_data` DATE NULL DEFAULT NULL,\n\t`dg_dc_numitem` VARCHAR(20) NULL DEFAULT NULL,\n\t`dg_dc_codicecommessaconvenzione` VARCHAR(100) NULL DEFAULT NULL,\n\t`dg_dc_codicecup` VARCHAR(15) NULL DEFAULT NULL,\n\t`dg_dc_codicecig` VARCHAR(15) NULL DEFAULT NULL,\n\tPRIMARY KEY (`id_fattura`)\n) ENGINE=MyISAM", "xmlpa");
                this.agg(706, "", "m.ceccarelli@tnx.it", "alter table test_fatt_xmlpa add column dp_iban varchar(34) null", "xmlpa");
                this.agg(707, "", "m.ceccarelli@tnx.it", "alter table test_fatt_xmlpa add column dp_istituto_finanziario varchar(80) null", "xmlpa");
                this.agg(708, "", "m.ceccarelli@tnx.it", "alter table test_fatt add column ts_export timestamp null", "ts export");
                this.agg(709, "", "m.ceccarelli@tnx.it", "alter table test_ddt add column ts_export timestamp null", "ts export");
                this.agg(710, "", "m.ceccarelli@tnx.it", "alter table test_ordi add column ts_export timestamp null", "ts export");
                this.agg(711, "", "m.ceccarelli@tnx.it", "alter table test_fatt_acquisto add column ts_export timestamp null", "ts export");
                this.agg(712, "", "m.ceccarelli@tnx.it", "alter table test_ddt_acquisto add column ts_export timestamp null", "ts export");
                this.agg(713, "", "m.ceccarelli@tnx.it", "alter table test_ordi_acquisto add column ts_export timestamp null", "ts export");
                this.agg(714, "", "m.ceccarelli@tnx.it", "alter table clie_forn add column ts_export timestamp null", "ts export");
                this.agg(715, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt_acquisto_lotti CHANGE COLUMN qta qta DECIMAL(15,5) NULL DEFAULT NULL", "qta lotti");
                this.agg(716, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt_lotti CHANGE COLUMN qta qta DECIMAL(15,5) NULL DEFAULT NULL", "qta lotti");
                this.agg(717, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_fatt_acquisto_lotti CHANGE COLUMN qta qta DECIMAL(15,5) NULL DEFAULT NULL", "qta lotti");
                this.agg(718, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_fatt_lotti CHANGE COLUMN qta qta DECIMAL(15,5) NULL DEFAULT NULL", "qta lotti");
                this.agg(719, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ordi_acquisto_lotti CHANGE COLUMN qta qta DECIMAL(15,5) NULL DEFAULT NULL", "qta lotti");
                this.agg(720, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ordi_lotti CHANGE COLUMN qta qta DECIMAL(15,5) NULL DEFAULT NULL", "qta lotti");
                this.agg(721, "", "m.ceccarelli@tnx.it", "ALTER TABLE dati_azienda ADD COLUMN flag_bug_massimale_rivalsa char(1) NULL DEFAULT NULL", "bug massimale rivalsa");
                this.agg(722, "", "m.ceccarelli@tnx.it", "alter table test_fatt_xmlpa add column dg_dr_tipo_ritenuta varchar(4) null", "xmlpa");
                this.agg(723, "", "m.ceccarelli@tnx.it", "alter table test_fatt_xmlpa add column dg_dr_causale_pagamento char(1) null", "xmlpa");
                this.agg(724, "", "m.ceccarelli@tnx.it", "alter table test_fatt_xmlpa add column dg_dcp_tipo_cassa varchar(4) null", "xmlpa");
                this.agg(725, "", "m.ceccarelli@tnx.it", "alter table righ_ddt add column flag_consegnato char(1) null", "flag consegna");
                this.agg(726, "", "m.ceccarelli@tnx.it", "alter table righ_ordi add column flag_consegnato char(1) null", "flag consegnato");
                this.agg(727, "", "m.ceccarelli@tnx.it", "alter table righ_fatt add column flag_consegnato char(1) null", "flag_consegnato");
                this.agg(728, "", "m.ceccarelli@tnx.it", "alter table righ_ddt_acquisto add column flag_consegnato char(1) null", "flag consegnato");
                this.agg(729, "", "m.ceccarelli@tnx.it", "alter table righ_ordi_acquisto add column flag_consegnato char(1) null", "flag consegnato");
                this.agg(730, "", "m.ceccarelli@tnx.it", "alter table righ_fatt_acquisto add column flag_consegnato char(1) null", "flag consegnato");
                this.agg(731, "", "m.ceccarelli@tnx.it", "alter table storico add column hostname varchar(255) null", "dati per storico");
                this.agg(732, "", "m.ceccarelli@tnx.it", "alter table storico add column login_so varchar(255) null", "dati per storico");
                this.agg(733, "", "m.ceccarelli@tnx.it", "alter table storico add column username_id int null", "dati per storico");
                this.agg(734, "", "m.ceccarelli@tnx.it", "alter table storico add column username varchar(255) null", "dati per storico");
                this.agg(735, "", "m.ceccarelli@tnx.it", "CREATE TABLE `accessi_utenti_online` (\n\t`utente_key` VARCHAR(255) NOT NULL COMMENT '|hostname|login_so|idutente|username|',\n\t`ts` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,\n\tPRIMARY KEY (`utente_key`)\n) ENGINE=MyISAM", "utenti online");
                this.agg(736, "", "m.ceccarelli@tnx.it", "CREATE TABLE `locks` (\n\t`id` INT(11) NOT NULL AUTO_INCREMENT,\n\t`username_id` INT(11) NOT NULL DEFAULT '0',\n\t`username` VARCHAR(250) NOT NULL DEFAULT '0',\n\t`hostname` VARCHAR(250) NOT NULL DEFAULT '0',\n\t`login_so` VARCHAR(250) NOT NULL DEFAULT '0',\n\t`ts` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,\n\t`ts_timer` TIMESTAMP NULL DEFAULT NULL,\n\t`lock_tabella` VARCHAR(50) NOT NULL DEFAULT '0',\n\t`lock_id` INT(11) NOT NULL DEFAULT '0',\n\tPRIMARY KEY (`id`),\n\tUNIQUE INDEX `univoco1` (`lock_tabella`, `lock_id`)\n) ENGINE=MyISAM", "locks documenti");
                this.agg(737, "", "m.ceccarelli@tnx.it", "alter table test_fatt add column acconto decimal(15,5) null", "acconto");
                this.agg(738, "", "m.ceccarelli@tnx.it", "alter table test_ddt add column acconto decimal(15,5) null", "acconto");
                this.agg(739, "", "m.ceccarelli@tnx.it", "alter table test_ordi add column acconto decimal(15,5) null", "acconto");
                this.agg(740, "", "m.ceccarelli@tnx.it", "alter table test_fatt_acquisto add column acconto decimal(15,5) null", "acconto");
                this.agg(741, "", "m.ceccarelli@tnx.it", "alter table test_ddt_acquisto add column acconto decimal(15,5) null", "acconto");
                this.agg(742, "", "m.ceccarelli@tnx.it", "alter table test_ordi_acquisto add column acconto decimal(15,5) null", "acconto");
                this.agg(743, "", "m.ceccarelli@tnx.it", "alter table test_fatt add column totale_da_pagare_finale decimal(15,5) null", "totale_da_pagare_finale");
                this.agg(744, "", "m.ceccarelli@tnx.it", "alter table test_ddt add column totale_da_pagare_finale decimal(15,5) null", "totale_da_pagare_finale");
                this.agg(745, "", "m.ceccarelli@tnx.it", "alter table test_ordi add column totale_da_pagare_finale decimal(15,5) null", "totale_da_pagare_finale");
                this.agg(746, "", "m.ceccarelli@tnx.it", "alter table test_fatt_acquisto add column totale_da_pagare_finale decimal(15,5) null", "totale_da_pagare_finale");
                this.agg(747, "", "m.ceccarelli@tnx.it", "alter table test_ddt_acquisto add column totale_da_pagare_finale decimal(15,5) null", "totale_da_pagare_finale");
                this.agg(748, "", "m.ceccarelli@tnx.it", "alter table test_ordi_acquisto add column totale_da_pagare_finale decimal(15,5) null", "totale_da_pagare_finale");
                this.agg(749, "", "m.ceccarelli@tnx.it", "ALTER TABLE scadenze ALTER numero DROP DEFAULT;", "scadenze per acconti");
                this.agg(750, "", "m.ceccarelli@tnx.it", "ALTER TABLE scadenze ALTER numero_totale DROP DEFAULT;", "scadenze per acconti");
                this.agg(751, "", "m.ceccarelli@tnx.it", "ALTER TABLE scadenze CHANGE COLUMN numero numero TINYINT(4) NULL;", "scadenze per acconti");
                this.agg(752, "", "m.ceccarelli@tnx.it", "ALTER TABLE scadenze CHANGE COLUMN numero_totale numero_totale TINYINT(4) NULL;", "scadenze per acconti");
                this.agg(753, "", "m.ceccarelli@tnx.it", "ALTER TABLE scadenze ADD COLUMN flag_acconto CHAR(1) DEFAULT 'N';", "scadenze per acconti");
                this.agg(754, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt add index id_padre (id_padre)", "problema raggruppamento ddt");
                this.agg(755, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt add index per_raggr (codice_articolo, um, prezzo, iva, sconto1, sconto2)", "problema raggruppamento ddt");
                this.agg(756, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt add index um (um)", "problema raggruppamento ddt");
                this.agg(757, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt add index prezzo (prezzo)", "problema raggruppamento ddt");
                this.agg(758, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt add index iva (iva)", "problema raggruppamento ddt");
                this.agg(759, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt add index sconto1 (sconto1)", "problema raggruppamento ddt");
                this.agg(760, "", "m.ceccarelli@tnx.it", "ALTER TABLE righ_ddt add index sconto2 (sconto2)", "problema raggruppamento ddt");
                this.agg(761, "", "m.ceccarelli@tnx.it", "alter table test_fatt_xmlpa add column dg_dr_totale_da_esportare varchar(30) null", "xmlpa");
                this.agg(762, "", "m.ceccarelli@tnx.it", "alter table test_fatt_xmlpa add column dg_causale varchar(200) null", "xmlpa");
                this.agg(763, "", "m.ceccarelli@tnx.it", "alter table clie_forn add column xmlpa_codice_ufficio varchar(6) null", "xmlpa");
                this.agg(764, "", "m.ceccarelli@tnx.it", "alter table clie_forn add column xmlpa_riferimento varchar(20) null", "xmlpa");
                this.agg(765, "", "m.ceccarelli@tnx.it", "ALTER TABLE `files_documenti` ADD COLUMN `allega_email` char(1) NULL", "aggiunte a files");
                this.agg(766, "", "m.ceccarelli@tnx.it", "ALTER TABLE `files_documenti` ADD COLUMN `allega_fatturapa` char(1) NULL", "aggiunte a files");
                this.agg(767, "", "m.ceccarelli@tnx.it", "ALTER TABLE dati_azienda ADD COLUMN provvigioni_tipo_calcolo tinyint NULL", "tipo calcolo base per provvigioni");
                this.agg(768, "", "m.ceccarelli@tnx.it", "CREATE TABLE `provvigioni_dettagli` ( `id` BIGINT NOT NULL AUTO_INCREMENT, `id_test_fatt` INT NOT NULL, `tipo_calcolo` TINYINT NOT NULL, `id_riga` INT NOT NULL, `base_provvigione` DECIMAL(15,5) NOT NULL, `perc_provvigione` DECIMAL(5,2) NOT NULL, `importo_provvigione` DECIMAL(15,5) NOT NULL,  PRIMARY KEY (`id`) ) ENGINE=MyISAM", "provvigioni_dettagli");
                this.agg(769, "", "m.ceccarelli@tnx.it", "ALTER TABLE dati_azienda ADD COLUMN flag_bug_provvigioni char(1) NULL DEFAULT NULL", "bug provvigioni");
                this.agg(770, "", "m.ceccarelli@tnx.it", "alter table test_fatt_xmlpa add column split_payment char(1) null", "xmlpa split payment");
                this.agg(771, "", "m.ceccarelli@tnx.it", "alter table clie_forn add column split_payment char(1) null", "clie_forn split payment");
                this.agg(772, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt_xmlpa CHANGE COLUMN dg_dr_causale_pagamento dg_dr_causale_pagamento CHAR(2) NULL DEFAULT NULL", "xmlpa");
                this.agg(773, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_fatt` CHANGE COLUMN `totaleRivalsa` `totaleRivalsa` DECIMAL(15,5) NULL DEFAULT '0.00'", "totale rivalsa troppo piccolo");
                this.agg(774, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_fatt_acquisto` CHANGE COLUMN `totaleRivalsa` `totaleRivalsa` DECIMAL(15,5) NULL DEFAULT '0.00'", "totale rivalsa troppo piccolo");
                this.agg(775, "", "m.ceccarelli@tnx.it", "ALTER TABLE `provvigioni` ADD COLUMN `id_doc` INT NULL, ADD COLUMN `id_scadenza`  BIGINT(20) NULL", "aggancio migliore fra provvigioni e scadenze");
                this.agg(790, "", "m.ceccarelli@tnx.it", "ALTER TABLE clie_forn CHANGE COLUMN `email` `email` VARCHAR(1000) NULL", "email da longtext a varchar(1000) base ecommerce");
                this.agg(791, "", "m.ceccarelli@tnx.it", "ALTER TABLE `clie_forn`\n\tALTER `banca_abi` DROP DEFAULT,\n\tALTER `banca_cab` DROP DEFAULT,\n\tALTER `banca_cc` DROP DEFAULT;", "campi null base ecommerce");
                this.agg(792, "", "m.ceccarelli@tnx.it", "ALTER TABLE `clie_forn`\n\tCHANGE COLUMN `banca_abi` `banca_abi` VARCHAR(5) NULL AFTER `codice_listino`,\n\tCHANGE COLUMN `banca_cab` `banca_cab` VARCHAR(5) NULL AFTER `banca_abi`,\n\tCHANGE COLUMN `banca_cc` `banca_cc` VARCHAR(35) NULL AFTER `banca_cab`,\n\tCHANGE COLUMN `tipo2` `tipo2` VARCHAR(10) NULL DEFAULT '';", "campi null base ecommerce");
                this.agg(793, "", "m.ceccarelli@tnx.it", "ALTER TABLE `articoli`\n\tADD COLUMN `prezzo_medio_data` DATE NULL DEFAULT NULL AFTER `prezzo_medio`,\n\tADD COLUMN `prezzo_medio_ts` TIMESTAMP NULL DEFAULT NULL AFTER `prezzo_medio_data`,\n\tADD COLUMN `costo_medio_ponderato` DECIMAL(15,5) NULL DEFAULT NULL,\n\tADD COLUMN `costo_medio_ponderato_data` DATE NULL DEFAULT NULL,\n\tADD COLUMN `costo_medio_ponderato_ts` TIMESTAMP NULL DEFAULT NULL;", "cmp");
                this.agg(794, "", "m.ceccarelli@tnx.it", "alter table articoli modify column descrizione_en text", "articoli descrizione_en text");
                this.agg(795, "", "a.toce@tnx.it", "ALTER TABLE test_fatt ADD COLUMN bloccata TIMESTAMP NULL DEFAULT NULL", "aggiunta colonna bloccaggio su fatture di vendita");
                this.agg(796, "", "a.toce@tnx.it", "ALTER TABLE test_fatt_acquisto ADD COLUMN bloccata TIMESTAMP NULL DEFAULT NULL", "aggiunta colonna bloccaggio su fatture di vendita");
                this.agg(795, "", "m.ceccarelli@tnx.it", "ALTER TABLE dati_azienda ADD COLUMN nomi_pdf text NULL", "nomi file pdf");
                this.agg(796, "", "m.ceccarelli@tnx.it", "ALTER TABLE `movimenti_magazzino` CHANGE COLUMN `modificato_ts` `modificato_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP", "giacenza articolo on update");
                this.agg(797, "", "a.toce@tnx.it", "ALTER TABLE test_fatt ADD COLUMN anticipata CHAR(1) NOT NULL DEFAULT 'N'", "Aggiunta colonna per fattura anticipata si o no (default no)");
                this.agg(798, "", "a.toce@tnx.it", "ALTER TABLE test_fatt ADD COLUMN banca_di_anticipazione INT NULL DEFAULT NULL", "Aggiunta colonna per segnalare conto corrente su cui viene anticipata la fattura");
                this.agg(799, "", "a.toce@tnx.it", "ALTER TABLE clie_forn ADD COLUMN note_docu TEXT NULL", "Aggiunta colonna note per ddt di vendita");
                this.agg(800, "", "a.toce@tnx.it", "ALTER TABLE clie_forn ADD COLUMN note_prev TEXT NULL", "Aggiunta colonna note per preventivi di vendita");
                this.agg(801, "", "a.toce@tnx.it", "ALTER TABLE clie_forn ADD COLUMN note_ordi TEXT NULL", "Aggiunta colonna note per ordini di vendita");
                this.agg(802, "", "a.toce@tnx.it", "ALTER TABLE clie_forn ADD COLUMN note_fatt_acq TEXT NULL", "Aggiunta colonna note per fattue di acquisto");
                this.agg(803, "", "a.toce@tnx.it", "ALTER TABLE clie_forn ADD COLUMN note_docu_acq TEXT NULL", "Aggiunta colonna note per ddt di acquisto");
                this.agg(804, "", "a.toce@tnx.it", "ALTER TABLE clie_forn ADD COLUMN note_prev_acq TEXT NULL", "Aggiunta colonna note per preventivi di acquisto");
                this.agg(805, "", "a.toce@tnx.it", "ALTER TABLE clie_forn ADD COLUMN note_ordi_acq TEXT NULL", "Aggiunta colonna note per ordini di acquisto");
                this.agg(797, "", "m.ceccarelli@tnx.it", "ALTER TABLE `clie_forn` CHANGE COLUMN `codice` `codice` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT FIRST;", "sync");
                this.agg(798, "", "m.ceccarelli@tnx.it", "ALTER TABLE `clie_forn` CHANGE COLUMN `tipo2` `tipo2` VARCHAR(10) NULL DEFAULT NULL;", "sync");
                this.agg(799, "", "m.ceccarelli@tnx.it", "ALTER TABLE `articoli_prezzi` ADD COLUMN `id` INT NOT NULL AUTO_INCREMENT FIRST,  DROP PRIMARY KEY,  ADD PRIMARY KEY (`id`),  ADD UNIQUE INDEX `articolo_listino` (`articolo`, `listino`),  ADD INDEX `articolo` (`articolo`),  ADD INDEX `listino` (`listino`);", "sync");
                this.agg(800, "", "m.ceccarelli@tnx.it", "ALTER TABLE codici_iva ADD COLUMN conto_readytec VARCHAR(10) NULL DEFAULT NULL", "Aggiunto campo di collegamento codice iva readytec");
                this.agg(801, "", "m.ceccarelli@tnx.it", "update test_fatt set marca_da_bollo = null where IFNULL(marca_da_bollo,0) = 0", "bollo");
                this.agg(802, "", "m.ceccarelli@tnx.it", "alter table test_fatt add column bollo_presente char(1) not null default 'N'", "bollo");
                this.agg(803, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda` ADD COLUMN `codiceIvaBollo` VARCHAR(10)", "bollo");
                this.agg(804, "", "m.ceccarelli@tnx.it", "update dati_azienda set codiceIvaBollo = '15'", "bollo");
                this.agg(805, "", "m.ceccarelli@tnx.it", "ALTER TABLE `temp_stampa_stat_ord_bol_fat` ADD COLUMN `agente_codice` INT NULL AFTER `qta`, ADD COLUMN `agente_nome` VARCHAR(255) NULL AFTER `agente_codice`;", "stats agente");
                this.agg(806, "", "m.ceccarelli@tnx.it", "ALTER TABLE clie_forn ADD COLUMN note_fatt TEXT NULL", "Aggiunta colonna note per fattue di vendita");
                this.agg(807, "", "m.ceccarelli@tnx.it", "update clie_forn set note_fatt = note, note_docu = note, note_ordi = note, note_prev = note where ifnull(note_automatiche,'N') = 'S'", "Aggiunta colonna note per fattue di vendita");
                this.agg(808, "", "m.ceccarelli@tnx.it", "CREATE TABLE `clie_forn_contatti` (\n\t`id` INT(11) NOT NULL AUTO_INCREMENT,\n\t`id_clifor` INT(11) NOT NULL,\n\t`tipo` VARCHAR(50) NULL DEFAULT NULL,\n\t`nome` VARCHAR(255) NULL DEFAULT NULL,\n\t`telefono` VARCHAR(255) NULL DEFAULT NULL,\n\t`email` VARCHAR(255) NULL DEFAULT NULL,\n\t`note` TEXT NULL,\n\t`invia_email_prev_ven` CHAR(1) NULL DEFAULT NULL,\n\t`invia_email_ordi_ven` CHAR(1) NULL DEFAULT NULL,\n\t`invia_email_ddt_ven` CHAR(1) NULL DEFAULT NULL,\n\t`invia_email_fatt_ven` CHAR(1) NULL DEFAULT NULL,\n\t`invia_email_prev_acq` CHAR(1) NULL DEFAULT NULL,\n\t`invia_email_ordi_acq` CHAR(1) NULL DEFAULT NULL,\n\t`invia_email_ddt_acq` CHAR(1) NULL DEFAULT NULL,\n\t`invia_email_fatt_acq` CHAR(1) NULL DEFAULT NULL,\n\t`invia_email_sollecito` CHAR(1) NULL DEFAULT NULL,\n\tPRIMARY KEY (`id`)\n)\nENGINE=MyISAM", "nuova tabella contatti");
                this.agg(810, "", "m.ceccarelli@tnx.it", "alter table clie_forn add includi_invio_email char(1) default 'S'", "Aggiunta colonna note per fattue di vendita");
                this.agg(811, "", "m.ceccarelli@tnx.it", "alter table clie_forn_dest add includi_invio_email char(1) default 'S'", "Aggiunta colonna note per fattue di vendita");
                this.agg(812, "", "m.ceccarelli@tnx.it", "update stati set nome = 'TAIWAN' where codice1 = 'TW'", "cambiato nome a taiwan");
                this.agg(813, "", "m.ceccarelli@tnx.it", "ALTER TABLE `clie_forn`\n\tADD COLUMN `fido_importo` DECIMAL(15,5) NULL AFTER `includi_invio_email`,\n\tADD COLUMN `fido_importo_assic` DECIMAL(15,5) NULL AFTER `fido_importo`,\n\tADD COLUMN `fido_grado` DOUBLE NULL AFTER `fido_importo_assic`,\n\tADD COLUMN `fido_grado_data` DATE NULL AFTER `fido_grado`,\n\tADD COLUMN `fido_obbligatorio` CHAR(1) NULL AFTER `fido_grado_data`;", "campi per gestione fido");
                this.agg(814, "", "m.ceccarelli@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 20, descrizione = 'Gestione Fido', lettura = 0, scrittura = 1, cancella = 0", "permessi fido");
                this.agg(815, "", "m.ceccarelli@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 20, descrizione = 'Gestione Fido', lettura = 0, scrittura = 1, cancella = 0", "permessi fido");
                this.agg(816, "", "m.ceccarelli@tnx.it", "INSERT INTO accessi_ruoli_permessi set id_role = 1, id_privilegio = 20, scrittura = 1;", "nuovo ruolo fido per admin");
                this.agg(817, "", "m.ceccarelli@tnx.it", "INSERT INTO accessi_ruoli_permessi set id_role = 2, id_privilegio = 20, scrittura = 1;", "nuovo ruolo fido per utente standard");
                this.agg(818, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi ADD COLUMN nome_contatto_riferimento VARCHAR(50) NULL DEFAULT NULL;", "contatto riferimento");
                this.agg(819, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ddt ADD COLUMN nome_contatto_riferimento VARCHAR(50) NULL DEFAULT NULL;", "contatto riferimento");
                this.agg(820, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt ADD COLUMN nome_contatto_riferimento VARCHAR(50) NULL DEFAULT NULL;", "contatto riferimento");
                this.agg(821, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi_acquisto ADD COLUMN nome_contatto_riferimento VARCHAR(50) NULL DEFAULT NULL;", "contatto riferimento");
                this.agg(822, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ddt_acquisto ADD COLUMN nome_contatto_riferimento VARCHAR(50) NULL DEFAULT NULL;", "contatto riferimento");
                this.agg(823, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt_acquisto ADD COLUMN nome_contatto_riferimento VARCHAR(50) NULL DEFAULT NULL;", "contatto riferimento");
                this.agg(824, "", "m.ceccarelli@tnx.it", "ALTER TABLE movimenti_magazzino add index articolo (articolo);", "movimenti magazzino indici");
                this.agg(825, "", "m.ceccarelli@tnx.it", "ALTER TABLE movimenti_magazzino add index causale (causale);", "movimenti magazzino indici");
                this.agg(826, "", "m.ceccarelli@tnx.it", "ALTER TABLE movimenti_magazzino add index deposito (deposito);", "movimenti magazzino indici");
                this.agg(827, "", "m.ceccarelli@tnx.it", "INSERT INTO accessi_tipi_permessi SET id = 21, descrizione = 'Gestione Ritenute e Rivalse', lettura = 1, scrittura = 1, cancella = 1", "permessi ritenute");
                this.agg(829, "", "m.ceccarelli@tnx.it", "INSERT INTO accessi_ruoli_permessi set id_role = 1, id_privilegio = 21, scrittura = 1, lettura = 1, cancella = 1;", "nuovo ruolo fido per admin");
                this.agg(830, "", "m.ceccarelli@tnx.it", "INSERT INTO accessi_ruoli_permessi set id_role = 2, id_privilegio = 21, scrittura = 1, lettura = 1, cancella = 1;", "nuovo ruolo fido per utente standard");
                this.agg(831, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt ADD COLUMN da_ddt_raggr VARCHAR(150) NULL DEFAULT NULL;", "memorizzo gli id dei ddt dal quale \u00e8 stata fatta la conversione ragguppando");
                this.agg(832, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt ADD COLUMN da_ordi_raggr VARCHAR(150) NULL DEFAULT NULL;", "memorizzo gli id dei ddt dal quale \u00e8 stata fatta la conversione ragguppando");
                this.agg(833, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ddt ADD COLUMN da_ordi_raggr VARCHAR(150) NULL DEFAULT NULL;", "memorizzo gli id dei ddt dal quale \u00e8 stata fatta la conversione ragguppando");
                this.agg(834, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt_acquisto ADD COLUMN da_ddt_raggr VARCHAR(150) NULL DEFAULT NULL;", "memorizzo gli id dei ddt dal quale \u00e8 stata fatta la conversione ragguppando");
                this.agg(835, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt_acquisto ADD COLUMN da_ordi_raggr VARCHAR(150) NULL DEFAULT NULL;", "memorizzo gli id dei ddt dal quale \u00e8 stata fatta la conversione ragguppando");
                this.agg(836, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ddt_acquisto ADD COLUMN da_ordi_raggr VARCHAR(150) NULL DEFAULT NULL;", "memorizzo gli id dei ddt dal quale \u00e8 stata fatta la conversione ragguppando");
                this.agg(837, "", "m.ceccarelli@tnx.it", "ALTER TABLE dati_azienda  ADD COLUMN stato_def_pre_acq VARCHAR(255) NULL, ADD COLUMN stato_def_ord_acq VARCHAR(255) NULL, ADD COLUMN stato_def_pre_ven VARCHAR(255) NULL, ADD COLUMN stato_def_ord_ven VARCHAR(255) NULL", "stato def");
                this.agg(838, "", "m.ceccarelli@tnx.it", "update dati_azienda set stato_def_pre_acq = 'Preventivo', stato_def_ord_acq = 'Ordine', stato_def_pre_ven = 'Preventivo', stato_def_ord_ven = 'Ordine'", "stato def");
                this.agg(837, "", "a.toce@tnx.it", "ALTER TABLE clie_forn_dest ADD COLUMN cod_filconad VARCHAR(150) NULL DEFAULT NULL;", "inserisco il codice filconad nelle destinazioni del cliente");
                this.agg(839, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi ADD COLUMN campo_libero_1 VARCHAR(100) NULL DEFAULT NULL;", "aggiungo area manager");
                this.agg(840, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ddt ADD COLUMN campo_libero_1 VARCHAR(100) NULL DEFAULT NULL;", "aggiungo area manager");
                this.agg(841, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt ADD COLUMN campo_libero_1 VARCHAR(100) NULL DEFAULT NULL;", "aggiungo area manager");
                this.agg(842, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ordi_acquisto ADD COLUMN campo_libero_1 VARCHAR(100) NULL DEFAULT NULL;", "aggiungo area manager");
                this.agg(843, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_ddt_acquisto ADD COLUMN campo_libero_1 VARCHAR(100) NULL DEFAULT NULL;", "aggiungo area manager");
                this.agg(844, "", "m.ceccarelli@tnx.it", "ALTER TABLE test_fatt_acquisto ADD COLUMN campo_libero_1 VARCHAR(100) NULL DEFAULT NULL;", "aggiungo area manager");
                this.agg(845, "", "m.ceccarelli@tnx.it", "CREATE TABLE `campi_liberi` (\n\t`id` VARCHAR(50) NOT NULL,\n\t`nome` VARCHAR(50) NULL,\n\tPRIMARY KEY (`id`)\n)\nENGINE=MyISAM;", "tabella campi liberi");
                this.agg(795, "", "emanuele.fia@gmail.com", "ALTER TABLE clie_forn ADD COLUMN tipo_causale_trasporto INT(11) UNSIGNED DEFAULT NULL", "Aggiunto campo causale_trasporto per cliente");
                this.agg(796, "", "emanuele.fia@gmail.com", "ALTER TABLE clie_forn ADD COLUMN tipo_consegna INT(11) UNSIGNED DEFAULT NULL", "Aggiunto campo causale_trasporto per cliente");
                this.agg(846, "", "m.ceccarelli@tnx.it", "ALTER TABLE `movimenti_magazzino`\n\tADD INDEX `matricola` (`matricola`),\n\tADD INDEX `lotto` (`lotto`);", "indice matricole e lotto su movimenti di magazzino");
                this.agg(847, "", "m.ceccarelli@tnx.it", "ALTER TABLE `articoli`\n\tADD COLUMN `xmlpa_disp_med_tipo` VARCHAR(35) NULL,\n\tADD COLUMN `xmlpa_disp_med_valore` VARCHAR(35) NULL", "tipo e valore disp medico xmlpa");
                this.agg(848, "", "m.ceccarelli@tnx.it", "ALTER TABLE `articoli` \n\tADD INDEX `categoria` (`categoria`),\n\tADD INDEX `sottocategoria` (`sottocategoria`);", "indici articoli");
                this.agg(849, "", "m.ceccarelli@tnx.it", "ALTER TABLE `righ_ordi`  CHANGE COLUMN `id` `id` INT(11) NOT NULL AUTO_INCREMENT FIRST,  CHANGE COLUMN `id_padre` `id_padre` INT(11) NOT NULL AFTER `id`;", "id primo campo righ");
                this.agg(850, "", "m.ceccarelli@tnx.it", "ALTER TABLE `righ_ordi_acquisto`  CHANGE COLUMN `id` `id` INT(11) NOT NULL AUTO_INCREMENT FIRST,  CHANGE COLUMN `id_padre` `id_padre` INT(11) NOT NULL AFTER `id`;", "id primo campo righ");
                this.agg(851, "", "m.ceccarelli@tnx.it", "ALTER TABLE `righ_ddt`  CHANGE COLUMN `id` `id` INT(11) NOT NULL AUTO_INCREMENT FIRST,  CHANGE COLUMN `id_padre` `id_padre` INT(11) NOT NULL AFTER `id`;", "id primo campo righ");
                this.agg(852, "", "m.ceccarelli@tnx.it", "ALTER TABLE `righ_ddt_acquisto`  CHANGE COLUMN `id` `id` INT(11) NOT NULL AUTO_INCREMENT FIRST,  CHANGE COLUMN `id_padre` `id_padre` INT(11) NOT NULL AFTER `id`;", "id primo campo righ");
                this.agg(853, "", "m.ceccarelli@tnx.it", "ALTER TABLE `righ_fatt`  CHANGE COLUMN `id` `id` INT(11) NOT NULL AUTO_INCREMENT FIRST,  CHANGE COLUMN `id_padre` `id_padre` INT(11) NOT NULL AFTER `id`;", "id primo campo righ");
                this.agg(854, "", "m.ceccarelli@tnx.it", "ALTER TABLE `righ_fatt_acquisto`  CHANGE COLUMN `id` `id` INT(11) NOT NULL AUTO_INCREMENT FIRST,  CHANGE COLUMN `id_padre` `id_padre` INT(11) NOT NULL AFTER `id`;", "id primo campo righ");
                this.agg(855, "", "m.ceccarelli@tnx.it", "ALTER TABLE `articoli_confezione` \nADD COLUMN `id` INT NOT NULL AUTO_INCREMENT FIRST, \n DROP PRIMARY KEY,\n ADD PRIMARY KEY (`id`),\n ADD UNIQUE INDEX `articolo_padre_articolo_figlio` (`articolo_padre`, `articolo_figlio`);\n", "premobile");
                this.agg(856, "", "m.ceccarelli@tnx.it", "ALTER TABLE `banche_cab`\n ADD COLUMN `id` INT NOT NULL AUTO_INCREMENT FIRST,\n DROP PRIMARY KEY,\n ADD PRIMARY KEY (`id`),\n ADD UNIQUE INDEX `abi_cab` (`abi`, `cab`);\n", "premobile");
                this.agg(859, "", "m.ceccarelli@tnx.it", "ALTER TABLE `dati_azienda`\n CHANGE COLUMN `id` `id` INT(11) NOT NULL AUTO_INCREMENT FIRST;\n", "premobile");
                this.agg(860, "", "m.ceccarelli@tnx.it", "ALTER TABLE `stati`\n DROP INDEX `indice_codice1`,\n ADD PRIMARY KEY (`codice1`);\n", "premobile");
                this.agg(861, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_fatt_acquisto_iva`\n ADD COLUMN `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT FIRST,\n DROP PRIMARY KEY,\n ADD PRIMARY KEY (`id`),\n ADD UNIQUE INDEX `id_padre_codice_iva` (`id_padre`, `codice_iva`);\n", "premobile");
                this.agg(862, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_fatt_iva`\n ADD COLUMN `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT FIRST,\n DROP PRIMARY KEY,\n ADD PRIMARY KEY (`id`),\n ADD UNIQUE INDEX `id_padre_codice_iva` (`id_padre`, `codice_iva`);\n", "premobile");
                this.agg(863, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ddt` CHANGE COLUMN `stato` `stato` CHAR(1) NULL;", "premobile");
                this.agg(864, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ddt_acquisto` CHANGE COLUMN `stato` `stato` CHAR(1) NULL;", "premobile");
                this.agg(865, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_fatt` CHANGE COLUMN `stato` `stato` CHAR(1) NULL;", "premobile");
                this.agg(866, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ordi` CHANGE COLUMN `stato` `stato` CHAR(1) NULL;", "premobile");
                this.agg(867, "", "m.ceccarelli@tnx.it", "ALTER TABLE `test_ordi_acquisto` CHANGE COLUMN `stato` `stato` CHAR(1) NULL;", "premobile");
                mb.out("fine inserimento log");
                this.esegui_aggs();
                mb.out("fine esecuzione log");
                if (!this.checkLog(520, "", "m.ceccarelli@tnx.it")) {
                    ArrayList list = DbUtils.getListMap((Connection)it.tnx.Db.getConn(), (String)"select * from attivazioni where msg like '%ESITO:Attivato%'  and (msg like '%Professional%'  or msg like '%Enterprise%' ) order by data desc limit 1");
                    if (list.size() > 0) {
                        try {
                            String log = cu.toString(((Map)list.get(0)).get("msg"));
                            Date ts = cu.toDate(((Map)list.get(0)).get("data"));
                            String codice = "";
                            Object versione = "";
                            codice = StringUtils.substringBefore((String)StringUtils.substringAfter((String)log, (String)"ORDINE:"), (String)" ESITO:");
                            versione = StringUtils.substringAfter((String)log, (String)"Attivato: ");
                            sql = "delete from attivazione";
                            DbUtils.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)sql);
                            sql = "insert into attivazione (codice, versione, esito_log, ts) values (" + it.tnx.Db.pc((Object)codice, 12) + ", " + it.tnx.Db.pc(versione, 12) + ", " + it.tnx.Db.pc((Object)log, 12) + ", " + it.tnx.Db.pc(ts, 93) + ")";
                            DbUtils.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)sql);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.writeLog(520, "", "m.ceccarelli@tnx.it", "");
                }
                if (!this.checkLog(id = 585, "", "m.ceccarelli@tnx.it")) {
                    try {
                        InvoicexUtil.ricalcolaPagatoDaPagare();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.writeLog(id, "", "m.ceccarelli@tnx.it", "aggiornamento campi pagato da pagare in scadenze");
                }
                if (!this.checkLog(id = 587, "", "m.ceccarelli@tnx.it")) {
                    try {
                        InvoicexUtil.ricalcolaTotaleScadenze();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.writeLog(id, "", "m.ceccarelli@tnx.it", "aggiornamento campo numero_totale scadenze");
                }
                if (!this.checkLog(id = 597, "", "m.ceccarelli@tnx.it")) {
                    sql = "select export_fatture_estrai_acconti from dati_azienda";
                    try {
                        DbUtils.tryOpenResultSet((Connection)it.tnx.Db.getConn(), (String)sql);
                    }
                    catch (Exception e) {
                        DbUtils.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)"ALTER TABLE `dati_azienda` ADD COLUMN `export_fatture_estrai_acconti` char(1) NULL");
                        sql = "update dati_azienda set export_fatture_estrai_acconti = 'N'";
                        DbUtils.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)sql);
                    }
                    this.writeLog(id, "", "m.ceccarelli@tnx.it", "flag estrazione acconti ready tec");
                }
                if (!this.checkLog(id = 776, "", "m.ceccarelli@tnx.it")) {
                    try {
                        this.writeLog(id, "", "m.ceccarelli@tnx.it", "aggiornamento id_doc e id_scadenza delle provvigioni");
                        main.splash("aggiornamenti struttura database: struttura scadenze e provvigioni", true);
                        if (main.db_in_rete) {
                            SwingUtils.showInfoMessage((Component)main.padre, (String)"Attenzione, \u00e8 necessario aggiornare la struttura del database.\nSe altri utenti stanno utilizzando Invoicex\ndovrebbero uscire prima di chiudere questo avviso !");
                        }
                        InvoicexUtil.aggiornaStrutturaScadenzeProvvigioniPerId();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!this.checkLog(id = 777, "", "m.ceccarelli@tnx.it")) {
                    try {
                        if (dbu.existTable((Connection)it.tnx.Db.getConn(), (String)"provvigioni_copia_pre_id") && this.checkLog(776, "", "m.ceccarelli@tnx.it") && !dbu.existTable((Connection)it.tnx.Db.getConn(), (String)"scadenze_copia_pre_id")) {
                            main.splash("aggiornamenti struttura database: struttura scadenze e provvigioni", true);
                            if (main.db_in_rete) {
                                SwingUtils.showInfoMessage((Component)main.padre, (String)"Attenzione, \u00e8 necessario aggiornare la struttura del database.\nSe altri utenti stanno utilizzando Invoicex\ndovrebbero uscire prima di chiudere questo avviso !");
                            }
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (dbu.existTable((Connection)it.tnx.Db.getConn(), (String)"provvigioni_copia_pre_id") && this.checkLog(776, "", "m.ceccarelli@tnx.it") && !dbu.existTable((Connection)it.tnx.Db.getConn(), (String)"scadenze_copia_pre_id")) {
                                this.writeLog(id, "", "m.ceccarelli@tnx.it", "aggiornamento id_doc e id_scadenza delle provvigioni");
                                dbu.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)"RENAME TABLE `provvigioni_copia_pre_id` TO `provvigioni_copia_pre_id_crash`");
                                InvoicexUtil.aggiornaStrutturaScadenzeProvvigioniPerId();
                            }
                            break block133;
                        }
                        if (dbu.existTable((Connection)it.tnx.Db.getConn(), (String)"provvigioni_copia_pre_id") && this.checkLog(776, "", "m.ceccarelli@tnx.it") && dbu.existTable((Connection)it.tnx.Db.getConn(), (String)"scadenze_copia_pre_id")) {
                            this.writeLog(id, "", "m.ceccarelli@tnx.it", "aggiornamento id_doc e id_scadenza delle provvigioni");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!this.checkLog(id = 809, "", "m.ceccarelli@tnx.it")) {
                try {
                    ArrayList list = dbu.getListMap((Connection)it.tnx.Db.getConn(), (String)"select codice, persona_riferimento, telefono_riferimento from clie_forn where ifnull(persona_riferimento,'') != '' or ifnull(telefono_riferimento,'') != ''");
                    int i = 0;
                    String sqltoexec = "";
                    for (Map cf : list) {
                        try {
                            HashMap contatto = new HashMap();
                            contatto.put("id_clifor", cf.get("codice"));
                            contatto.put("tipo", "Principale");
                            contatto.put("nome", cf.get("persona_riferimento"));
                            contatto.put("telefono", cf.get("telefono_riferimento"));
                            sql = "insert into clie_forn_contatti set " + dbu.prepareSqlFromMap(contatto);
                            System.out.println("sql = " + sql);
                            sqltoexec = sqltoexec + sql + ";\n";
                            if (i % 100 == 0) {
                                main.splash("aggiornamenti struttura database: conversione contatti " + (int)((double)i * 100.0 / (double)list.size()) + "%", true);
                                dbu.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)sqltoexec);
                                sqltoexec = "";
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                    if (i % 100 != 0) {
                        dbu.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)sqltoexec);
                    }
                    this.writeLog(id, "", "m.ceccarelli@tnx.it", "portato contatto principale");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!this.checkLog(id = 1000, "", "m.ceccarelli@tnx.it") || !dbu.existTable((Connection)it.tnx.Db.getConn(), (String)"db_version")) {
                block134: {
                    sql = "CREATE TABLE `db_version` (\n\t`modulo` VARCHAR(150) NOT NULL,\n\t`versione` INT NULL,\n\t`ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n     `running_chi` VARCHAR(100) NULL,\n     `running_quando` TIMESTAMP NULL\n, PRIMARY KEY (`modulo`))\nCOLLATE='utf8_general_ci'\nENGINE=InnoDB;";
                    try {
                        if (!dbu.existTable((Connection)it.tnx.Db.getConn(), (String)"db_version")) {
                            dbu.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)sql, (boolean)false, (boolean)true);
                        }
                        if (!dbu.containRows((Connection)it.tnx.Db.getConn(), (String)"select * from db_version where modulo = 'invoicex'")) {
                            sql = "insert into db_version set modulo = 'invoicex', versione = 1";
                            dbu.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)sql, (boolean)false, (boolean)true);
                        }
                        this.writeLog(id, "", "m.ceccarelli@tnx.it", "passati a db_version");
                    }
                    catch (SQLException sqle) {
                        System.out.println("sqle = " + sqle);
                        System.out.println("sqle.errcode = " + sqle.getErrorCode());
                        if (sqle.getErrorCode() != 1005 || !sqle.getMessage().endsWith("(errno: -1)") && !sqle.getMessage().endsWith("(errno: 121)")) break block134;
                        System.out.println("problema tabella db_version orphan dentro innodb");
                        main.splash("problema tabella db_version orphan dentro innodb", true);
                        boolean prova_correzione_orphan = false;
                        if (main.startDbCheck) {
                            prova_correzione_orphan = true;
                        } else {
                            String server_mysql = it.tnx.Db.dbServ;
                            server_mysql = StringUtils.substringBefore((String)server_mysql, (String)":");
                            String ip_server_mysql = InetAddress.getByName(server_mysql).getHostAddress();
                            System.out.println("ip mysql server a cui collegarsi : " + ip_server_mysql);
                            String ip_localhost = SystemUtils.getHostaddress();
                            System.out.println("ip localhost : " + ip_localhost);
                            if (ip_server_mysql.equals(ip_localhost)) {
                                prova_correzione_orphan = true;
                            }
                        }
                        if (prova_correzione_orphan) {
                            try {
                                String nomedbtemp;
                                Connection conn;
                                block135: {
                                    conn = it.tnx.Db.getConn();
                                    nomedbtemp = it.tnx.Db.dbNameDB + "_temp_ibd";
                                    dbu.tryExecQuery((Connection)conn, (String)("create database if not exists " + nomedbtemp));
                                    dbu.tryExecQuery((Connection)conn, (String)("use " + nomedbtemp));
                                    try {
                                        dbu.tryExecQuery((Connection)conn, (String)sql);
                                    }
                                    catch (SQLException sqle2) {
                                        sqle2.printStackTrace();
                                        if (sqle2.getErrorCode() == 1050) break block135;
                                        SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)sqle2, (String)"Provando auto correzione per db_version orfana (1)");
                                    }
                                }
                                String datadir = cu.s(((Map)dbu.getListMap((Connection)conn, (String)"SHOW VARIABLES WHERE Variable_Name LIKE 'datadir'").get(0)).get("Value"));
                                String nomedb = it.tnx.Db.dbNameDB;
                                if (StringUtils.isNotBlank((String)datadir)) {
                                    if (main.startDbCheck) {
                                        main.stopdb(false);
                                        for (int i = 0; i < 60 && main.mysql_is_running; ++i) {
                                            System.out.println("attendo chiusura mysql");
                                            Thread.sleep(1000L);
                                        }
                                        Thread.sleep(1000L);
                                        if (main.mysql_is_running) {
                                            SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)"Provando auto correzione per db_version orfana, timeout in attesa stop mysql", (boolean)true);
                                            main.exitMain();
                                        }
                                        System.out.println("copio file db_version.frm da " + datadir + File.separatorChar + "mysql a " + datadir + File.separatorChar + nomedb);
                                        FileUtils.copyFile((File)new File(datadir + nomedbtemp + File.separatorChar + "db_version.frm"), (File)new File(datadir + nomedb + File.separatorChar + "db_version.frm"));
                                        System.out.println("elimino .ibd da " + datadir + File.separatorChar + nomedb);
                                        File fibd = new File(datadir + nomedb + File.separatorChar + "db_version.ibd");
                                        fibd.delete();
                                        main.startdb();
                                        for (int i = 0; i < 60 && !main.mysql_is_running; ++i) {
                                            System.out.println("attendo avvio mysql");
                                            Thread.sleep(1000L);
                                        }
                                        Thread.sleep(1000L);
                                        if (!main.mysql_is_running) {
                                            SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)"Provando auto correzione per db_version orfana, timeout in attesa avvio mysql", (boolean)true);
                                            main.exitMain();
                                        }
                                    }
                                    conn = it.tnx.Db.getConnection();
                                    dbu.tryExecQuery((Connection)conn, (String)("use " + nomedbtemp));
                                    dbu.tryExecQuery((Connection)conn, (String)"drop table db_version");
                                    dbu.tryExecQuery((Connection)conn, (String)("use " + it.tnx.Db.dbNameDB));
                                    try {
                                        dbu.tryExecQuery((Connection)conn, (String)"drop table db_version");
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    dbu.tryExecQuery((Connection)conn, (String)sql);
                                    sql = "insert into db_version set modulo = 'invoicex', versione = 1";
                                    dbu.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)sql, (boolean)false, (boolean)true);
                                }
                                SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)("Problema nella creazione della tabella db_version\nTentando il recupero da db_version orfana, datadir = [" + datadir + "]"));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)e, (String)"Provando auto correzione per db_version orfana (2)");
                                dbu.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)("use " + it.tnx.Db.dbNameDB));
                            }
                        }
                        SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)"Problema nella creazione della tabella db_version\nNon sei sul computer che esegue mysql, prova a lanciare Invoicex\nsul computer che esegue mysql per tentare il ripristino");
                        dbu.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)("use " + it.tnx.Db.dbNameDB));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)("Errore nell'aggiornamento della struttura del database (db_version):\n" + e.getMessage()), (boolean)true);
                    }
                }
                try {
                    DbVersionChanges dbvc = new DbVersionChanges("invoicex", new RunnableWithArgs(){

                        public void run() {
                            main.splash(cu.s((Object)this.getArgs()[0]));
                        }
                    });
                    dbvc.esegui();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)e, (String)"Errore in aggiornamento struttura database\nContattare l'assistenza");
                }
            }
            mb.out("fine check table attivazione log");
            try {
                String sqlrun = "delete from log2_running";
                dbu.tryExecQuery((Connection)it.tnx.Db.getConn(), (String)sqlrun);
            }
            catch (Exception e) {
                e.printStackTrace();
                SwingUtils.showExceptionMessage((Component)main.splash, (Exception)e);
            }
            mb.out("fine check engine log");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                this.statLog.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        System.out.println(mb.getDiff("fine agg db log2 " + this.getClass().toString()));
    }

    private void agg18() {
        int id_log = 18;
        String id_plugin = "";
        String id_email = "m.ceccarelli@tnx.it";
        String note = "sistemazione movimenti ddt di acquisto per bug ver 2010-10";
        if (!this.checkLog(id_log, id_plugin, id_email)) {
            try {
                ArrayList list = DbUtils.getListMap((Connection)it.tnx.Db.getConn(), (String)"select serie, numero, anno, id from test_ddt_acquisto order by id");
                for (Map m : list) {
                    try {
                        dbDocumento prev = new dbDocumento();
                        prev.serie = (String)m.get("serie");
                        prev.numero = CastUtils.toInteger(m.get("numero"));
                        prev.anno = CastUtils.toInteger(m.get("anno"));
                        prev.setId(CastUtils.toInteger(m.get("id")));
                        prev.tipoDocumento = it.tnx.Db.TIPO_DOCUMENTO_DDT_ACQUISTO;
                        prev.acquisto = true;
                        if (!prev.generaMovimentiMagazzino()) {
                            System.out.println("agg18: !!! problema: " + prev.serie + " " + prev.numero + " " + prev.anno + " " + prev.getId());
                            continue;
                        }
                        System.out.println("agg18: ok: " + prev.serie + " " + prev.numero + " " + prev.anno + " " + prev.getId());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception err) {
                err.printStackTrace();
            }
            this.writeLog(id_log, id_plugin, id_email, note);
        }
    }

    public void pre_check(int id_log, String id_plugin, String id_email) {
    }

    public void post_check(int id_log, String id_plugin, String id_email) {
    }

    public void post_execute_ok(int id_log, String id_plugin, String id_email, String sql) {
    }

    public void post_execute_ko(int id_log, String id_plugin, String id_email, String sql) {
    }

    public void post_execute_ko(int id_log, String id_plugin, String id_email, String sql, Exception err) {
    }

    public void post_check_ok(int id_log, String id_plugin, String id_email) {
    }

    private void checkTableEngineInno() {
        try {
            if (Sync.isActive() || dbu.existTable((Connection)it.tnx.Db.getConn(), (String)"sync_config")) {
                return;
            }
            main.splash("aggiornamenti struttura database: controllo engine tabelle", 50);
            ArrayList status = DbUtils.getListMap((Connection)it.tnx.Db.getConn(true), (String)"SHOW TABLE STATUS");
            for (Map rec : status) {
                if (cu.toString(rec.get("Name")).startsWith("pn_")) {
                    System.out.println("ignoro tabelle prima nota:" + rec.get("Name"));
                    continue;
                }
                System.out.println("tab = " + rec.get("Name") + " engine: " + rec.get("Engine"));
                if (rec == null || rec.get("Name") == null || rec.get("Engine") == null || rec.get("Engine").toString().equalsIgnoreCase("MyISAM")) continue;
                try {
                    String name = (String)rec.get("Name");
                    System.out.println("la tabella " + rec.get("Name") + " \u00e8 con engine " + rec.get("Engine") + ", cambio in MyISAM");
                    String nomeFileDump = CurrentDir.getCurrentDir() + "/backup/dump_per_engine_";
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmm");
                    Date d = new Date();
                    nomeFileDump = nomeFileDump + name + "_" + sdf.format(d) + ".txt";
                    FileOutputStream fos = new FileOutputStream(nomeFileDump, false);
                    Util.dumpTable(name, it.tnx.Db.getConn(), fos);
                    System.out.println(name + " : dumped");
                    fos.close();
                    DbUtils.tryExecQuery((Connection)it.tnx.Db.getConn(true), (String)("alter table `" + name + "` ENGINE=MyISAM"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        main.splash("aggiornamenti struttura database: controllo engine tabelle completato", 100);
    }
}

