/*
 * Decompiled with CFR 0.152.
 */
package gestioneFatture.logic.documenti;

import gestioneFatture.Db;
import gestioneFatture.logic.Iva;
import gestioneFatture.logic.clienti.Cliente;
import gestioneFatture.logic.documenti.DettaglioIva;
import gestioneFatture.logic.documenti.IvaDed;
import gestioneFatture.main;
import it.tnx.Util;
import it.tnx.commons.CastUtils;
import it.tnx.commons.DateUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.DebugFastUtils;
import it.tnx.commons.DebugUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.invoicex.InvoicexUtil;
import java.awt.Component;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;

public class Documento {
    private String sqlPerSconti = null;
    private String sqlPerDettagli = null;
    private String sqlPerDettagliIva = null;
    public Vector dettagliIva = new Vector();
    public List<Map> dettagliIvaSpeseTrasporto = new ArrayList<Map>();
    public List dettagliIvaSpeseTrasportoDebug = new ArrayList();
    public List<Map> dettagliIvaSpeseIncasso = new ArrayList<Map>();
    public List dettagliIvaSpeseIncassoDebug = new ArrayList();
    public Map<IvaDed, DettaglioIva> dettagliIvaDedMap = new LinkedHashMap<IvaDed, DettaglioIva>();
    private Vector dettagliDocumento = new Vector();
    private Map<IvaDed, Double> proporzioniIva = new HashMap<IvaDed, Double>();
    private Map<IvaDed, Double> proporzioniIvaSconto = new HashMap<IvaDed, Double>();
    private double totaImpo = 0.0;
    private double totaIva = 0.0;
    private double tota = 0.0;
    private double totaleQuantita = 0.0;
    public double totalePeso = 0.0;
    private double tempSconto1 = 0.0;
    private double tempSconto2 = 0.0;
    private double tempSconto3 = 0.0;
    private double tempSpeseVarie = 0.0;
    private double tempSpeseTrasportoIva = 0.0;
    private double tempSpeseIncassoIva = 0.0;
    private String rivalsa_inps_descrizione;
    private Double rivalsa_inps_perc;
    private Cliente cliente;
    private double scontoTestata1;
    private double scontoTestata2;
    private double scontoTestata3;
    private double totale;
    private double totaleIva;
    private double totaleImponibileParziale;
    private double totaleImponibilePerRivalsa;
    private double totaleImponibile;
    private double totaleImponibileSoloRighe;
    private double totaleImponibilePerRitenuta;
    private double totaleIvatoParziale;
    private double totaleIvato;
    private double totaleIvatoPerRitenuta;
    private double speseTrasporto;
    private double speseVarieImponibili;
    private double speseIncasso;
    public Double speseBollo = null;
    public boolean speseBolloSiNo = false;
    private long codiceCliente;
    private long codiceFornitore;
    private int ritenuta;
    private String ritenuta_descrizione;
    private Integer rivalsa_codice;
    private double ritenuta_perc;
    private double totale_ritenuta;
    private double acconto;
    private double totale_da_pagare;
    private double totale_da_pagare_finale;
    private boolean rivalsa_inps;
    private double totale_rivalsa;
    private double totale_imponibile2;
    private double totaleSconti;
    private Date data;
    private double parametroArrotondamento = 0.0;
    private boolean perDifetto = true;
    private boolean prezziIvati = false;
    public String tipoDocumento = "";
    private Integer tipoFattura = null;
    private double sconto;
    public double totaleImponibilePreSconto = 0.0;
    public double totaleIvatoPreSconto = 0.0;
    double imponibile = 0.0;
    double imposta = 0.0;
    double imposta_noarr = 0.0;
    double ivato = 0.0;
    double totaleImponibilePositivo = 0.0;
    double totaleIvatoPositivo = 0.0;
    double totaleImposta = 0.0;
    double speseImponibili = 0.0;
    double speseIvate = 0.0;
    public List<DettaglioIva> speseTrasportoDettagli = null;
    public List<DettaglioIva> speseIncassoDettagli = null;
    public Integer id_documento = null;
    public String table_righe_temp;
    Integer numero = null;
    String serie = null;
    Integer anno = null;
    Integer id = null;
    private boolean includi_rivalsa_in_imp_ritenuta = true;
    private boolean includi_rivalsa_in_iva = true;
    private boolean sottrai_rivalsa = false;
    private String codiceIvaSpeseRivalsa = null;

    public boolean isIncludi_rivalsa_in_imp_ritenuta() {
        return this.includi_rivalsa_in_imp_ritenuta;
    }

    public void setIncludi_rivalsa_in_imp_ritenuta(boolean includi_rivalsa_in_imp_ritenuta) {
        this.includi_rivalsa_in_imp_ritenuta = includi_rivalsa_in_imp_ritenuta;
    }

    public boolean isIncludi_rivalsa_in_iva() {
        return this.includi_rivalsa_in_iva;
    }

    public void setIncludi_rivalsa_in_iva(boolean includi_rivalsa_in_iva) {
        this.includi_rivalsa_in_iva = includi_rivalsa_in_iva;
    }

    public boolean isSottrai_rivalsa() {
        return this.sottrai_rivalsa;
    }

    public void setSottrai_rivalsa(boolean sottrai_rivalsa) {
        this.sottrai_rivalsa = sottrai_rivalsa;
    }

    public String getCodiceIvaSpeseRivalsa() {
        return this.codiceIvaSpeseRivalsa;
    }

    public void setCodiceIvaSpeseRivalsa(String codiceIvaSpeseRivalsa) {
        this.codiceIvaSpeseRivalsa = codiceIvaSpeseRivalsa;
    }

    public Documento() {
        System.out.println("new Documento " + this);
    }

    public boolean load(Db db, int numero, String serie, int anno, String tipoDocumento) {
        return this.load(db, numero, serie, anno, tipoDocumento, null);
    }

    public boolean load(Db db, String tipoDocumento, Integer id) {
        return this.load(db, -1, null, -1, tipoDocumento, id);
    }

    public boolean load(Db db, String tipoDocumento, Integer id, Connection conn) {
        return this.load(db, -1, null, -1, tipoDocumento, id, null, conn);
    }

    public boolean load(Db db, int numero, String serie, int anno, String tipoDocumento, Integer id) {
        return this.load(db, numero, serie, anno, tipoDocumento, id, null);
    }

    public boolean load(Db db, int numero, String serie, int anno, String tipoDocumento, Integer id, Integer tipoFattura) {
        return this.load(db, numero, serie, anno, tipoDocumento, id, tipoFattura, Db.getConn());
    }

    public boolean load(Db db, int numero, String serie, int anno, String tipoDocumento, Integer id, Integer tipoFattura, Connection conn) {
        this.numero = numero;
        this.serie = serie;
        this.anno = anno;
        this.id = id;
        this.tipoDocumento = tipoDocumento;
        if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_FATTURA) && tipoFattura == null) {
            try {
                tipoFattura = cu.i((Object)dbu.getObject((Connection)conn, (String)("select tipo_fattura from test_fatt where id = " + dbu.sql((Object)id))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA) && tipoFattura == null) {
            try {
                tipoFattura = cu.i((Object)dbu.getObject((Connection)conn, (String)("select tipo_fattura from test_fatt_acquisto where id = " + dbu.sql((Object)id))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tipoFattura = tipoFattura;
        String sql = "select sconto1,sconto2,sconto3, spese_varie, spese_trasporto, spese_incasso, prezzi_ivati, sconto, acconto";
        if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA)) {
            sql = sql + ", marca_da_bollo, bollo_presente, bollo_non_addebitare ";
        }
        if ((tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA) || tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) && main.pluginRitenute) {
            sql = sql + ", ritenuta";
            sql = sql + ", rivalsaInpsPerc, rivalsaInpsTesto, rivalsa ";
            sql = sql + ", includi_rivalsa_in_imp_ritenuta, includi_rivalsa_in_iva, sottrai_rivalsa, codiceIvaSpeseRivalsa ";
        }
        if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_DDT)) {
            sql = sql + ", data, cliente from test_ddt";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_DDT_ACQUISTO)) {
            sql = sql + ", data, fornitore from test_ddt_acquisto";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA)) {
            sql = sql + ", data, cliente from test_fatt";
            if (id == null) {
                System.err.println("id null");
                String sqlid = "select id from test_fatt";
                sqlid = sqlid + " where serie = " + Db.pc(serie, "VARHCAR");
                sqlid = sqlid + " and numero = " + Db.pc(numero, "LONG");
                sqlid = sqlid + " and anno = " + Db.pc(anno, "INTEGER");
                sqlid = sqlid + " and tipo_fattura != 7";
                try {
                    ResultSet rid = DbUtils.tryOpenResultSet((Connection)conn, (String)sqlid);
                    if (rid.next()) {
                        id = rid.getInt("id");
                    }
                    rid.close();
                }
                catch (Exception ex) {
                    Logger.getLogger(Documento.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_SCONTRINO)) {
            sql = sql + ", data, cliente from test_fatt";
            if (id == null) {
                System.err.println("Documento load Scontrino senza id");
            }
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_ORDINE) || tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_PREVENTIVO) || tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_SCHEDELAV)) {
            sql = sql + ", data, cliente from test_ordi";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO)) {
            sql = sql + ", data, fornitore from test_ordi_acquisto";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
            sql = sql + ", data_doc as data, fornitore as cliente from test_fatt_acquisto";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_PAGAMENTO_RICORRENTE)) {
            sql = sql + ", data, cliente as cliente from test_pagamenti_ricorrenti";
        } else {
            JOptionPane.showMessageDialog(null, "errore in calcolo totale, tipo documento errato", "Errore", 0);
        }
        if (id == null && !tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_SCONTRINO)) {
            System.err.println("id null");
            id = InvoicexUtil.getIdDaNumero(tipoDocumento, serie, numero, anno);
            if (id == null) {
                return false;
            }
        }
        sql = sql + " where id = " + id;
        this.id_documento = id;
        this.sqlPerSconti = sql;
        ArrayList listSconti = null;
        java.util.Date data = null;
        try {
            listSconti = dbu.getListMap((Connection)conn, (String)this.sqlPerSconti);
            Map dati = (Map)listSconti.get(0);
            data = cu.toDate(dati.get("data"));
            if (cu.b(dati.get("bollo_non_addebitare")).booleanValue()) {
                this.speseBolloSiNo = false;
                this.speseBollo = null;
            } else {
                this.speseBolloSiNo = cu.toBoolean(dati.get("bollo_presente"));
                if (this.speseBolloSiNo) {
                    this.speseBollo = cu.toDouble0(dati.get("marca_da_bollo"));
                }
            }
            this.ritenuta = dati.get("ritenuta") == null || cu.i0(dati.get("ritenuta")) <= 0 ? 0 : cu.i0(dati.get("ritenuta"));
            this.setRivalsa_inps_perc(null);
            this.setRivalsa_inps_descrizione(null);
            if (dati.get("rivalsaInpsPerc") != null && !(cu.d0(dati.get("rivalsaInpsPerc")) <= 0.0)) {
                this.setRivalsaCodice(cu.i(dati.get("rivalsa")));
                this.setRivalsa_inps_perc(cu.d0(dati.get("rivalsaInpsPerc")));
                this.setRivalsa_inps_descrizione(cu.s(dati.get("rivalsaInpsTesto")));
            }
            Map m = (Map)main.GLOB.get("dati_azienda");
            if (!cu.sIsBlank(dati.get("includi_rivalsa_in_imp_ritenuta"))) {
                this.setIncludi_rivalsa_in_imp_ritenuta(cu.toBoolean(dati.get("includi_rivalsa_in_imp_ritenuta")));
                this.setIncludi_rivalsa_in_iva(cu.toBoolean(dati.get("includi_rivalsa_in_iva")));
                this.setSottrai_rivalsa(cu.toBoolean(dati.get("sottrai_rivalsa")));
                this.setCodiceIvaSpeseRivalsa(cu.s(dati.get("codiceIvaSpeseRivalsa")));
            } else {
                this.setIncludi_rivalsa_in_imp_ritenuta(cu.toBoolean(m.get("includi_rivalsa_in_imp_ritenuta"), (Boolean)true));
                this.setIncludi_rivalsa_in_iva(cu.toBoolean(m.get("includi_rivalsa_in_iva"), (Boolean)true));
                this.setSottrai_rivalsa(cu.toBoolean(m.get("sottrai_rivalsa"), (Boolean)true));
                this.setCodiceIvaSpeseRivalsa(cu.s(m.get("codiceIvaSpeseRivalsa")));
            }
        }
        catch (Exception dati) {
            // empty catch block
        }
        sql = "select sum(totale_imponibile) as totaImpo, sum(totale_ivato) as totaIvato, prezzo, sconto1, sconto2, iva, codici_iva.percentuale, codici_iva.descrizione,codici_iva.descrizione_breve";
        sql = InvoicexUtil.isZeroComeUno(data) ? sql + ", sum(if(ifnull(quantita,0)=0 and ifnull(prezzo,0)!=0,1,ifnull(quantita,0))) as quantita" : sql + ", sum(ifnull(quantita,0)) as quantita";
        sql = sql + ", sum(ifnull(quantita,0)) as quantita_orig";
        if (InvoicexUtil.isZeroComeUno(data)) {
            sql = sql + ", sum( ifnull(prezzo,0) * if(ifnull(quantita,0)=0 and ifnull(prezzo,0)!=0,1,ifnull(quantita,0) ) ) as lordo";
            sql = sql + ", sum( ifnull(prezzo,0) * if(ifnull(quantita,0)=0 and ifnull(prezzo,0)!=0,1,ifnull(quantita,0) * (1 + (codici_iva.percentuale / 100))) ) as lordoIvato";
        } else {
            sql = sql + ", sum(ifnull(prezzo,0) * ifnull(quantita,0)) as lordo";
            sql = sql + ", sum(ifnull(prezzo,0) * ifnull(quantita,0) * (1 + (codici_iva.percentuale / 100))) as lordoIvato";
        }
        if (main.fileIni.getValueBoolean("pref", "attivaArrotondamento", false).booleanValue()) {
            sql = sql + ", arrotondamento_parametro, arrotondamento_tipo";
        }
        sql = sql + ", iva_deducibile";
        sql = sql + " from ";
        if (this.table_righe_temp != null) {
            sql = sql + this.table_righe_temp;
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_DDT)) {
            sql = sql + "righ_ddt";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_DDT_ACQUISTO)) {
            sql = sql + "righ_ddt_acquisto";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA) || tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_SCONTRINO)) {
            sql = sql + "righ_fatt";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_ORDINE)) {
            sql = sql + "righ_ordi";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_SCHEDELAV)) {
            sql = sql + "righ_schedelav";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO)) {
            sql = sql + "righ_ordi_acquisto";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
            sql = sql + "righ_fatt_acquisto";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_PAGAMENTO_RICORRENTE)) {
            sql = sql + "righ_pagamenti_ricorrenti";
        }
        sql = sql + " left join codici_iva on iva = codice";
        if (id != null) {
            sql = sql + " where id_padre = " + id;
        }
        this.sqlPerDettagliIva = sql = sql + " group by id";
        sql = InvoicexUtil.isZeroComeUno(data) ? "select if(ifnull(quantita,0)=0 and ifnull(prezzo,0)!=0,1,ifnull(quantita,0)) as quantita" : "select ifnull(quantita,0) as quantita";
        sql = sql + ", ifnull(quantita,0) as quantita_orig";
        sql = sql + ", a.peso_kg as peso";
        sql = sql + ", totale_imponibile as impo";
        sql = sql + ", totale_ivato as ivato";
        sql = sql + ", flag_ritenuta";
        sql = sql + ", flag_rivalsa";
        if (InvoicexUtil.isZeroComeUno(data)) {
            sql = sql + ", round((ifnull(prezzo,0) * if(ifnull(quantita,0)=0 and ifnull(prezzo,0)!=0,1,ifnull(quantita,0) ) ),2) as lordo";
            sql = sql + ", round((ifnull(prezzo,0) * if(ifnull(quantita,0)=0 and ifnull(prezzo,0)!=0,1,ifnull(quantita,0) * (1 + codici_iva.percentuale / 100)) ), 2) as lordoIvato";
        } else {
            sql = sql + ", round((ifnull(prezzo,0) * ifnull(quantita,0)),2) as lordo";
            sql = sql + ", round((ifnull(prezzo,0) * ifnull(quantita,0) * (1 + codici_iva.percentuale / 100)), 2) as lordoIvato";
        }
        if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_ORDINE)) {
            sql = sql + ", codice_articolo";
        }
        if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
            sql = sql + ", iva_deducibile, r.iva";
        }
        sql = sql + " from ";
        if (this.table_righe_temp != null) {
            sql = sql + this.table_righe_temp;
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_DDT)) {
            sql = sql + "righ_ddt";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_DDT_ACQUISTO)) {
            sql = sql + "righ_ddt_acquisto";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA) || tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_SCONTRINO)) {
            sql = sql + "righ_fatt";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_ORDINE)) {
            sql = sql + "righ_ordi";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_SCHEDELAV)) {
            sql = sql + "righ_schedelav";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO)) {
            sql = sql + "righ_ordi_acquisto";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
            sql = sql + "righ_fatt_acquisto";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_PAGAMENTO_RICORRENTE)) {
            sql = sql + "righ_pagamenti_ricorrenti";
        }
        sql = sql + " r left join articoli a on r.codice_articolo = a.codice";
        sql = sql + " left join codici_iva on r.iva = codici_iva.codice";
        if (id == null) {
            SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)"Problema nel calcolo del totale documento (id = null)", (String)"Errore");
        } else {
            if (cu.i0((Object)id) == 0) {
                SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)"Errore in Documento.load id = 0");
            }
            sql = sql + " where id_padre = " + id;
        }
        this.sqlPerDettagli = sql;
        System.err.println("sql calcolo documento = " + sql);
        try {
            Map mapSconti = (Map)listSconti.get(0);
            this.setScontoTestata1(cu.d0(mapSconti.get("sconto1")));
            this.setScontoTestata2(cu.d0(mapSconti.get("sconto2")));
            this.setScontoTestata3(cu.d0(mapSconti.get("sconto3")));
            this.setSpeseTrasporto(cu.d0(mapSconti.get("spese_trasporto")));
            this.setSpeseVarieImponibili(cu.d0(mapSconti.get("spese_varie")));
            this.setSpeseIncasso(cu.d0(mapSconti.get("spese_incasso")));
            this.setData((Date)cu.toDate(mapSconti.get("data")));
            if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO) || tipoDocumento.equals(Db.TIPO_DOCUMENTO_DDT_ACQUISTO)) {
                this.setCodiceCliente(cu.toLong0(mapSconti.get("fornitore")));
            } else {
                this.setCodiceCliente(cu.toLong0(mapSconti.get("cliente")));
            }
            if (!cu.s(mapSconti.get("prezzi_ivati")).equalsIgnoreCase("N")) {
                this.setPrezziIvati(true);
            }
            this.setSconto(cu.d0(mapSconti.get("sconto")));
            this.setAcconto(cu.d0(mapSconti.get("acconto")));
        }
        catch (Exception err) {
            return false;
        }
        return true;
    }

    public boolean loadScontrini(Db db, String tipoDocumento, Integer id) {
        String sql = "select sconto1,sconto2,sconto3, spese_varie, spese_trasporto, spese_incasso";
        sql = sql + ", cliente from test_fatt";
        this.sqlPerSconti = sql = sql + " where id = " + id;
        sql = "select sum(round((ifnull(prezzo,0) * ifnull(quantita,0)) * (1-ifnull(sconto1,0)/100) * (1-ifnull(sconto2,0)/100),2)) as totaImpo, prezzo, quantita, sconto1, sconto2, iva, percentuale, codici_iva.descrizione,codici_iva.descrizione_breve";
        sql = sql + ", sum(ifnull(quantita,0)) as quantita";
        sql = sql + ", sum(round((ifnull(prezzo,0) * ifnull(quantita,0)),2)) as lordo";
        sql = sql + ", iva_deducibile";
        sql = sql + " from ";
        sql = sql + "righ_fatt";
        sql = sql + " left join codici_iva on iva = codice";
        sql = sql + " where id_padre = " + id;
        this.sqlPerDettagliIva = sql = sql + " group by id";
        sql = "select ifnull(quantita,0) as quantita, a.peso_kg as peso ";
        sql = sql + ", round((ifnull(prezzo,0) * ifnull(quantita,0)) * (1-ifnull(sconto1,0)/100) * (1-ifnull(sconto2,0)/100),2) as impo";
        sql = sql + ", flag_ritenuta";
        sql = sql + ", flag_rivalsa";
        sql = sql + ", round((ifnull(prezzo,0) * ifnull(quantita,0)),2) as lordo";
        sql = sql + " from ";
        sql = sql + "righ_fatt";
        sql = sql + " r left join articoli a on r.codice_articolo = a.codice";
        this.sqlPerDettagli = sql = sql + " where id_padre = " + id;
        try {
            ResultSet resuSconti = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)this.sqlPerSconti);
            if (!resuSconti.next()) {
                DbUtils.close((ResultSet)resuSconti);
                return false;
            }
            this.setScontoTestata1(resuSconti.getObject("sconto1") == null ? 0.0 : resuSconti.getDouble("sconto1"));
            this.setScontoTestata2(resuSconti.getObject("sconto2") == null ? 0.0 : resuSconti.getDouble("sconto2"));
            this.setScontoTestata3(resuSconti.getObject("sconto3") == null ? 0.0 : resuSconti.getDouble("sconto3"));
            this.setSpeseTrasporto(resuSconti.getObject("spese_trasporto") == null ? 0.0 : resuSconti.getDouble("spese_trasporto"));
            this.setSpeseVarieImponibili(resuSconti.getObject("spese_varie") == null ? 0.0 : resuSconti.getDouble("spese_varie"));
            this.setSpeseIncasso(resuSconti.getObject("spese_incasso") == null ? 0.0 : resuSconti.getDouble("spese_incasso"));
            this.setCodiceCliente(resuSconti.getObject("cliente") == null ? 0L : resuSconti.getLong("cliente"));
            DbUtils.close((ResultSet)resuSconti);
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
        return true;
    }

    public void caricaCliente(long codice) {
        this.cliente = new Cliente(codice);
    }

    public synchronized void calcolaTotali() {
        System.out.println("   --- calcolo totali : inizio");
        this.calcolaTotali(null, null, this.getCodiceIvaSpeseRivalsa(), null);
        this.visualizzaCastellettoIva();
        System.out.println("   --- calcolo totali : fine");
    }

    public synchronized void calcolaTotali(String iva_spese_trasporto, String iva_spese_incasso, String iva_spese_rivalsa, String iva_spese_bollo) {
        if (StringUtils.isBlank((String)this.sqlPerDettagli)) {
            return;
        }
        this.setTotale_rivalsa(0.0);
        System.out.println("   --- calcolo totali : passaggio 1");
        this.calcolaTotaliSub(iva_spese_trasporto, iva_spese_incasso, iva_spese_rivalsa, iva_spese_bollo, 1);
        if (this.getRivalsa_inps_perc() != null || this.ritenuta > 0) {
            this.totaleImponibile = 0.0;
            this.totaleImponibilePositivo = 0.0;
            this.totaleImponibilePerRitenuta = 0.0;
            this.totaleIvato = 0.0;
            this.totaleIvatoPositivo = 0.0;
            this.totaleIvatoPerRitenuta = 0.0;
            this.totaleImposta = 0.0;
            for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
                this.totaleImponibile += d.getImponibile();
                this.totaleImponibilePositivo += d.getImponibile();
                this.totaleImponibilePerRitenuta += d.getImponibile();
                this.totaleIvato += d.getIvato();
                this.totaleIvatoPositivo += d.getIvato();
                this.totaleIvatoPerRitenuta += d.getIvato();
                this.totaleImposta += d.getImposta();
            }
            if (this.getRivalsa_inps_perc() != null) {
                double sommeNonSoggetteRivalsa = 0.0;
                try {
                    ResultSet resuDett = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)this.sqlPerDettagli);
                    if (resuDett != null) {
                        while (resuDett.next()) {
                            if (!StringUtils.equalsIgnoreCase((String)resuDett.getString("flag_rivalsa"), (String)"N")) continue;
                            sommeNonSoggetteRivalsa += resuDett.getDouble("impo");
                        }
                        DbUtils.close((ResultSet)resuDett);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.setTotaleImponibilePerRivalsa(this.totaleImponibile - sommeNonSoggetteRivalsa);
                this.setTotale_rivalsa(Util.round(this.getTotaleImponibilePerRivalsa() / 100.0 * this.getRivalsa_inps_perc(), 2));
                if (this.isIncludi_rivalsa_in_imp_ritenuta()) {
                    this.totaleImponibilePerRitenuta += this.getTotale_rivalsa();
                }
            }
            try {
                ResultSet resuDett = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)this.sqlPerDettagli);
                while (resuDett.next()) {
                    if (!StringUtils.equalsIgnoreCase((String)resuDett.getString("flag_ritenuta"), (String)"N")) continue;
                    this.imponibile = resuDett.getDouble("impo") - resuDett.getDouble("impo") / 100.0 * this.scontoTestata1;
                    this.imponibile -= this.imponibile / 100.0 * this.scontoTestata2;
                    this.imponibile -= this.imponibile / 100.0 * this.scontoTestata3;
                    this.imponibile = Util.round(this.imponibile, 2);
                    this.totaleImponibilePerRitenuta -= this.imponibile;
                    this.ivato = resuDett.getDouble("ivato") - resuDett.getDouble("ivato") / 100.0 * this.scontoTestata1;
                    this.ivato -= this.ivato / 100.0 * this.scontoTestata2;
                    this.ivato -= this.ivato / 100.0 * this.scontoTestata3;
                    this.ivato = Util.round(this.ivato, 2);
                    this.totaleIvatoPerRitenuta -= this.ivato;
                }
                DbUtils.close((ResultSet)resuDett);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.totaleImponibileParziale = this.totaleImponibile;
            this.totaleIvatoParziale = this.totaleIvato;
        }
        System.out.println("   --- calcolo totali : passaggio 2");
        this.calcolaTotaliSub(iva_spese_trasporto, iva_spese_incasso, iva_spese_rivalsa, iva_spese_bollo, 2);
        this.dettagliIva = InvoicexUtil.getIveVector(this.getDettagliIvaMap(this.dettagliIvaDedMap));
        if (main.debug) {
            System.out.println("--- Totali calcolo documento INIZIO ---");
            System.out.println("dettagliIva:");
            DebugFastUtils.dump((Object)this.dettagliIva);
            System.out.println("dettagliIvaSpeseTrasporto:");
            DebugFastUtils.dump((Object)this.dettagliIvaSpeseTrasportoDebug);
            System.out.println("dettagliIvaSpeseIncasso:");
            DebugFastUtils.dump((Object)this.dettagliIvaSpeseIncassoDebug);
            System.out.println("--- Totali calcolo documento FINE ---");
        }
    }

    public synchronized void calcolaTotaliSub(String iva_spese_trasporto, String iva_spese_incasso, String iva_spese_rivalsa, String iva_spese_bollo, int passaggio) {
        try {
            this.caricaCliente(this.getCodiceCliente());
            this.totaleQuantita = 0.0;
            this.totalePeso = 0.0;
            this.totaleSconti = 0.0;
            if (this.sqlPerDettagli == null) {
                return;
            }
            System.out.println("sqlPerDettagli = " + this.sqlPerDettagli);
            ResultSet resuDett = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)this.sqlPerDettagli);
            if (resuDett == null) {
                return;
            }
            while (resuDett.next()) {
                this.totaleQuantita += resuDett.getDouble("quantita");
                if (!StringUtils.equalsIgnoreCase((String)resuDett.getString("flag_ritenuta"), (String)"N")) {
                    this.totaleSconti += resuDett.getDouble("lordo") - this.imponibile;
                    this.totaleSconti += resuDett.getDouble("lordoIvato") - this.ivato;
                }
                try {
                    double pesoriga = resuDett.getDouble("quantita") * resuDett.getDouble("peso");
                    this.totalePeso += pesoriga;
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                }
            }
            DbUtils.close((ResultSet)resuDett);
        }
        catch (Exception err) {
            err.printStackTrace();
            this.totaleQuantita = 0.0;
        }
        this.totaleImponibile = 0.0;
        this.totaleImponibileSoloRighe = 0.0;
        this.totaleImponibilePositivo = 0.0;
        this.totaleIvato = 0.0;
        this.totaleIvatoPositivo = 0.0;
        double totaleImponibile_deducibile = 0.0;
        double totaleImponibile_indeducibile = 0.0;
        double totaleIvato_deducibile = 0.0;
        double totaleIvato_indeducibile = 0.0;
        boolean split_payment = false;
        if (this.tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA)) {
            try {
                split_payment = cu.toBoolean((Object)dbu.getObject((Connection)Db.getConn(), (String)("select split_payment from test_fatt_xmlpa where id_fattura = " + this.id_documento)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            DettaglioIva d;
            System.out.println("sqlPerDettagliIva = " + this.sqlPerDettagliIva);
            ResultSet resuTota = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)this.sqlPerDettagliIva);
            this.dettagliIvaDedMap.clear();
            this.dettagliIvaSpeseIncasso.clear();
            this.dettagliIvaSpeseIncassoDebug.clear();
            this.dettagliIvaSpeseTrasporto.clear();
            this.dettagliIvaSpeseTrasportoDebug.clear();
            while (resuTota.next()) {
                if (main.fileIni.getValueBoolean("pref", "attivaArrotondamento", false).booleanValue()) {
                    this.setParametriArrotondamento(resuTota.getString("arrotondamento_parametro"), resuTota.getString("arrotondamento_tipo"));
                }
                String kiva = resuTota.getString("iva");
                Double ded = cu.d((Object)resuTota.getObject("iva_deducibile"));
                if (ded == null) {
                    ded = 100.0;
                }
                IvaDed kivaded = new IvaDed(kiva, ded);
                if (!StringUtils.isNotEmpty((String)kiva)) continue;
                if (resuTota.getDouble("quantita") == 15.0) {
                    System.out.println("stop");
                }
                this.imponibile = resuTota.getDouble("totaImpo");
                this.imponibile = InvoicexUtil.calcolaPrezzoArrotondato(this.imponibile, this.parametroArrotondamento, this.perDifetto);
                this.imponibile -= this.imponibile / 100.0 * this.scontoTestata1;
                this.imponibile -= this.imponibile / 100.0 * this.scontoTestata2;
                this.imponibile -= this.imponibile / 100.0 * this.scontoTestata3;
                double perc_deducibilita = resuTota.getObject("iva_deducibile") == null ? 100.0 : cu.d0((Object)resuTota.getObject("iva_deducibile"));
                double imponibile_deducibile = this.imponibile / 100.0 * perc_deducibilita;
                double imponibile_indeducibile = this.imponibile - imponibile_deducibile;
                this.totaleImponibile += this.imponibile;
                this.totaleImponibileSoloRighe += this.imponibile;
                this.totaleImponibilePositivo += this.imponibile;
                totaleImponibile_deducibile += imponibile_deducibile;
                totaleImponibile_indeducibile += imponibile_indeducibile;
                this.ivato = resuTota.getDouble("totaIvato");
                this.ivato = InvoicexUtil.calcolaPrezzoArrotondato(this.ivato, this.parametroArrotondamento, this.perDifetto);
                this.ivato -= this.ivato / 100.0 * this.scontoTestata1;
                this.ivato -= this.ivato / 100.0 * this.scontoTestata2;
                this.ivato -= this.ivato / 100.0 * this.scontoTestata3;
                double ivato_deducibile = this.ivato / 100.0 * perc_deducibilita;
                double ivato_indeducibile = this.ivato - ivato_deducibile;
                this.totaleIvato += this.ivato;
                this.totaleIvatoPositivo += this.ivato;
                totaleIvato_deducibile += ivato_deducibile;
                totaleIvato_indeducibile += ivato_indeducibile;
                DettaglioIva diva = this.dettagliIvaDedMap.get(kivaded);
                if (diva == null) {
                    diva = new DettaglioIva();
                    diva.setCodice(kiva);
                    diva.setPerc_deducibilita(ded);
                    diva.setDescrizione(resuTota.getString("descrizione"));
                    diva.setDescrizioneBreve(resuTota.getString("descrizione_breve"));
                    diva.setPercentuale(resuTota.getDouble("percentuale"));
                }
                diva.setImponibile(cu.d0((Object)diva.getImponibile()) + this.imponibile);
                diva.setImponibile_deducibile(cu.d0((Object)diva.getImponibile_deducibile()) + imponibile_deducibile);
                diva.setImponibile_indeducibile(cu.d0((Object)diva.getImponibile_indeducibile()) + imponibile_indeducibile);
                diva.imponibile_noarr = cu.d0((Object)diva.getImponibile());
                diva.setIvato(cu.d0((Object)diva.getIvato()) + this.ivato);
                diva.setIvato_deducibile(cu.d0((Object)diva.getIvato_deducibile()) + ivato_deducibile);
                diva.setIvato_indeducibile(cu.d0((Object)diva.getIvato_indeducibile()) + ivato_indeducibile);
                diva.ivato_noarr = cu.d0((Object)diva.getIvato());
                this.dettagliIvaDedMap.put(kivaded, diva);
            }
            DbUtils.close((ResultSet)resuTota);
            if (main.debug) {
                DebugUtils.dump(this.dettagliIvaDedMap);
            }
            for (IvaDed ivadedkey : this.dettagliIvaDedMap.keySet()) {
                DettaglioIva d2 = this.dettagliIvaDedMap.get(ivadedkey);
                d2.setImponibile(Util.round(d2.getImponibile(), 2));
                d2.setIvato(Util.round(d2.getIvato(), 2));
                d2.setImponibile_deducibile(Util.round(d2.getImponibile_deducibile(), 2));
                d2.setImponibile_indeducibile(Util.round(d2.getImponibile_indeducibile(), 2));
                d2.setIvato_deducibile(Util.round(d2.getIvato_deducibile(), 2));
                d2.setIvato_indeducibile(Util.round(d2.getIvato_indeducibile(), 2));
            }
            String codiceIvaSpeseTrasporto = "";
            codiceIvaSpeseTrasporto = iva_spese_trasporto == null ? InvoicexUtil.getIvaSpesePerData(this.data, "codiceIvaSpese") : iva_spese_trasporto;
            String codiceIvaSpeseIncasso = "";
            codiceIvaSpeseIncasso = iva_spese_incasso == null ? InvoicexUtil.getIvaSpesePerData(this.data, "codiceIvaSpeseIncasso") : iva_spese_incasso;
            String codiceIvaSpeseRivalsa = "";
            codiceIvaSpeseRivalsa = iva_spese_rivalsa == null ? InvoicexUtil.getIvaSpesePerData(this.data, "codiceIvaSpeseRivalsa") : iva_spese_rivalsa;
            String codiceIvaSpeseBollo = "";
            String string = codiceIvaSpeseBollo = iva_spese_bollo == null ? InvoicexUtil.getIvaSpesePerData(this.data, "codiceIvaBollo") : iva_spese_bollo;
            if (cu.s((Object)codiceIvaSpeseTrasporto).equals("") && !cu.s((Object)codiceIvaSpeseIncasso).equals("")) {
                this.calcolaTotaliSubSpese("codiceIvaSpeseIncasso", codiceIvaSpeseIncasso);
                this.calcolaTotaliSubSpese("codiceIvaSpese", codiceIvaSpeseTrasporto);
            } else {
                this.calcolaTotaliSubSpese("codiceIvaSpese", codiceIvaSpeseTrasporto);
                this.calcolaTotaliSubSpese("codiceIvaSpeseIncasso", codiceIvaSpeseIncasso);
            }
            this.calcolaTotaliSubSpese("codiceIvaSpeseRivalsa", codiceIvaSpeseRivalsa);
            this.totaleImponibilePreSconto = this.totaleImponibile;
            this.totaleIvatoPreSconto = this.totaleIvato;
            for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                double imposta_indeducibile;
                double imposta_deducibile;
                double perc_sconto;
                d = this.dettagliIvaDedMap.get(ivakey);
                double scontoRipartito = 0.0;
                double nuovoImponibile = 0.0;
                double nuovoIvato = 0.0;
                if (!this.isPrezziIvati()) {
                    if (passaggio == 1) {
                        scontoRipartito = this.sconto * d.getImponibile() / this.totaleImponibilePositivo;
                        this.proporzioniIvaSconto.put(ivakey, scontoRipartito);
                        if (this.totaleImponibilePositivo != 0.0) {
                            this.proporzioniIva.put(ivakey, 100.0 * d.getImponibile() / this.totaleImponibilePositivo);
                        } else {
                            this.proporzioniIva.put(ivakey, 0.0);
                        }
                    } else {
                        scontoRipartito = this.proporzioniIvaSconto != null && d != null ? CastUtils.toDouble0((Object)this.proporzioniIvaSconto.get(ivakey)) : 0.0;
                    }
                    nuovoImponibile = !Double.isNaN(scontoRipartito) ? d.getImponibile() - scontoRipartito : d.getImponibile();
                    perc_sconto = nuovoImponibile * 100.0 / d.getImponibile();
                    if (perc_sconto == Double.NaN) {
                        perc_sconto = 0.0;
                    }
                    this.imposta_noarr = this.imposta = nuovoImponibile / 100.0 * d.getPercentuale();
                    this.imposta = Util.round(this.imposta, 2);
                    d.imponibile_noarr = nuovoImponibile;
                    nuovoImponibile = Util.round(nuovoImponibile, 2);
                    imposta_deducibile = Util.round(this.imposta / 100.0 * d.getPerc_deducibilita(), 2);
                    imposta_indeducibile = Util.round(this.imposta - imposta_deducibile, 2);
                    double nuovoImponibile_deducibile = Util.round(nuovoImponibile / 100.0 * d.getPerc_deducibilita(), 2);
                    double nuovoImponibile_indeducibile = Util.round(nuovoImponibile + this.imposta - nuovoImponibile_deducibile - imposta_deducibile - imposta_indeducibile, 2);
                    d.setImponibile(nuovoImponibile);
                    d.setImponibile_deducibile(Util.round(nuovoImponibile_deducibile, 2));
                    d.setImponibile_indeducibile(Util.round(nuovoImponibile_indeducibile, 2));
                    d.setImposta(this.imposta);
                    d.setImposta_deducibile(Util.round(imposta_deducibile, 2));
                    d.setImposta_indeducibile(Util.round(imposta_indeducibile, 2));
                    d.imposta_noarr = this.imposta_noarr;
                    continue;
                }
                if (passaggio == 1) {
                    scontoRipartito = this.sconto * d.getIvato() / this.totaleIvatoPositivo;
                    this.proporzioniIvaSconto.put(ivakey, scontoRipartito);
                    if (this.totaleIvatoPositivo != 0.0) {
                        this.proporzioniIva.put(ivakey, 100.0 * d.getIvato() / this.totaleIvatoPositivo);
                    } else {
                        this.proporzioniIva.put(ivakey, 0.0);
                    }
                } else {
                    scontoRipartito = this.proporzioniIvaSconto != null && d != null ? CastUtils.toDouble0((Object)this.proporzioniIvaSconto.get(ivakey)) : 0.0;
                }
                nuovoIvato = !Double.isNaN(scontoRipartito) ? d.getIvato() - scontoRipartito : d.getIvato();
                perc_sconto = nuovoIvato * 100.0 / d.getIvato();
                this.imposta_noarr = this.imposta = nuovoIvato * d.getPercentuale() / (100.0 + d.getPercentuale());
                this.imposta = Util.round(this.imposta, 2);
                d.ivato_noarr = nuovoIvato;
                nuovoIvato = Util.round(nuovoIvato, 2);
                d.setImponibile(nuovoIvato - this.imposta);
                nuovoImponibile = nuovoIvato - this.imposta;
                imposta_deducibile = Util.round(this.imposta / 100.0 * d.getPerc_deducibilita(), 2);
                imposta_indeducibile = Util.round(this.imposta - imposta_deducibile, 2);
                double nuovoIvato_deducibile = Util.round(nuovoIvato / 100.0 * d.getPerc_deducibilita(), 2);
                double nuovoIvato_indeducibile = Util.round(nuovoIvato - nuovoIvato_deducibile, 2);
                double nuovoImponibile_deducibile = Util.round(nuovoImponibile / 100.0 * d.getPerc_deducibilita(), 2);
                double nuovoImponibile_indeducibile = Util.round(nuovoImponibile + this.imposta - nuovoImponibile_deducibile - imposta_deducibile - imposta_indeducibile, 2);
                d.setIvato(nuovoIvato);
                d.setImposta(this.imposta);
                d.setImposta_deducibile(Util.round(imposta_deducibile, 2));
                d.setImposta_indeducibile(Util.round(imposta_indeducibile, 2));
                d.setImponibile_deducibile(nuovoImponibile_deducibile);
                d.setImponibile_indeducibile(nuovoImponibile_indeducibile);
                d.setIvato_deducibile(nuovoIvato_deducibile);
                d.setIvato_indeducibile(nuovoIvato_indeducibile);
                d.imposta_noarr = this.imposta_noarr;
            }
            this.totaleImponibile = 0.0;
            this.totaleImponibilePositivo = 0.0;
            this.totaleIvato = 0.0;
            this.totaleIvatoPositivo = 0.0;
            this.totaleImposta = 0.0;
            for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                d = this.dettagliIvaDedMap.get(ivakey);
                this.totaleImponibile += d.getImponibile();
                this.totaleImponibilePositivo += d.getImponibile();
                this.totaleIvato += d.getIvato();
                this.totaleIvatoPositivo += d.getIvato();
                this.totaleImposta += d.getImposta();
            }
            this.totaleImponibile = Util.round(this.totaleImponibile, 2);
            this.totaleImponibilePositivo = Util.round(this.totaleImponibilePositivo, 2);
            this.totaleIvato = Util.round(this.totaleIvato, 2);
            this.totaleIvatoPositivo = Util.round(this.totaleIvatoPositivo, 2);
            this.totaleIva = this.totaleImposta = Util.round(this.totaleImposta, 2);
            this.totale = !this.isPrezziIvati() ? this.totaleImponibile + this.totaleImposta : this.totaleIvato;
            this.totaleSconti = this.totaleSconti;
            this.ritenuta_perc = 0.0;
            this.ritenuta_descrizione = "";
            this.totale_ritenuta = 0.0;
            this.totale_da_pagare = 0.0;
            this.totale_da_pagare_finale = 0.0;
            if (this.ritenuta > 0) {
                try {
                    ResultSet r = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)("select * from tipi_ritenuta where id = " + this.ritenuta));
                    if (r.next()) {
                        this.ritenuta_perc = r.getDouble("percentuale");
                        this.ritenuta_descrizione = r.getString("descrizione");
                        this.totale_ritenuta = Util.round(this.totaleImponibilePerRitenuta / 100.0 * this.ritenuta_perc, 2);
                        this.totale_da_pagare = this.totale - this.totale_ritenuta;
                        if (this.isSottrai_rivalsa()) {
                            this.totale_da_pagare -= this.totale_rivalsa;
                        }
                    } else {
                        System.err.println("problema nel calcolo totale, manca ritenuta (" + this.ritenuta + ") in tabella");
                        this.totale_da_pagare = this.totale - this.totale_ritenuta;
                        if (this.isSottrai_rivalsa()) {
                            this.totale_da_pagare -= this.totale_rivalsa;
                        }
                    }
                    DbUtils.close((ResultSet)r);
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                }
            } else {
                this.totale_da_pagare = this.totale;
                if (this.isSottrai_rivalsa()) {
                    this.totale_da_pagare -= this.totale_rivalsa;
                }
            }
            if (passaggio > 1 && this.speseBolloSiNo) {
                this.speseBollo = cu.d0((Object)this.speseBollo);
                if (StringUtils.isBlank((String)cu.s((Object)codiceIvaSpeseBollo))) {
                    codiceIvaSpeseBollo = "15";
                }
                IvaDed codiceIvaBollo = new IvaDed(codiceIvaSpeseBollo, 100.0);
                Iva ivaBollo = new Iva();
                if (!ivaBollo.load(Db.INSTANCE, codiceIvaBollo.codice_iva)) {
                    ivaBollo.setCodice(codiceIvaBollo.codice_iva);
                    ivaBollo.setPercentuale(0.0);
                    ivaBollo.setDescrizione("Escluso art. 15");
                    ivaBollo.setDescrizioneBreve("Escluso art. 15");
                }
                DettaglioIva divabollo = null;
                if (this.dettagliIvaDedMap.containsKey(codiceIvaBollo)) {
                    divabollo = this.dettagliIvaDedMap.get(codiceIvaBollo);
                } else {
                    divabollo = new DettaglioIva();
                    divabollo.setCodice(codiceIvaBollo.codice_iva);
                    divabollo.setPerc_deducibilita(100.0);
                    divabollo.setDescrizione(ivaBollo.getDescrizione());
                    divabollo.setDescrizioneBreve(ivaBollo.getDescrizioneBreve());
                    divabollo.setPercentuale(ivaBollo.getPercentuale());
                }
                int segnoBollo = 1;
                if (this.tipoFattura != null && (this.tipoFattura == 3 || this.tipoFattura == 9)) {
                    segnoBollo = -1;
                }
                double imposta = this.speseBollo * (double)segnoBollo / 100.0 * ivaBollo.getPercentuale();
                imposta = Util.round(imposta, 2);
                divabollo.setImponibile(cu.d0((Object)divabollo.getImponibile()) + this.speseBollo * (double)segnoBollo);
                divabollo.setImponibile_deducibile(cu.d0((Object)divabollo.getImponibile_deducibile()) + this.speseBollo * (double)segnoBollo);
                divabollo.setImposta(imposta);
                divabollo.setImposta_deducibile(cu.d0((Object)divabollo.getImposta_deducibile()) + imposta);
                divabollo.setIvato(divabollo.getIvato() + this.speseBollo * (double)segnoBollo + imposta);
                this.dettagliIvaDedMap.put(codiceIvaBollo, divabollo);
                this.totaleImponibile += this.speseBollo * (double)segnoBollo;
                this.totale += this.speseBollo * (double)segnoBollo + imposta;
                this.totaleIvato += this.speseBollo * (double)segnoBollo + imposta;
                this.totaleIva += imposta;
                this.totaleImposta += imposta;
                this.totale_da_pagare += this.speseBollo * (double)segnoBollo + imposta;
                this.totale_da_pagare_finale += this.speseBollo * (double)segnoBollo + imposta;
            }
            System.out.println("calcolo deds");
            for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                d = this.dettagliIvaDedMap.get(ivakey);
                d.setImponibile_deducibile(Util.round(d.getImponibile() - d.getImponibile_indeducibile(), 2));
                d.setImposta_deducibile(Util.round(d.getImposta() - d.getImposta_indeducibile(), 2));
            }
            this.totale_da_pagare_finale = this.totale_da_pagare - this.acconto;
            if (split_payment) {
                this.totale_da_pagare_finale -= this.totaleImposta;
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public double getImpIvaNonDeducibile() {
        double ret = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            ret += d.getImposta_indeducibile();
        }
        return ret;
    }

    public double getImpIvaNonDeducibileOld() throws SQLException, Exception {
        ResultSet dettagli = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)this.sqlPerDettagli);
        double impDeducibile = 0.0;
        while (dettagli.next()) {
            String iva = CastUtils.toString((Object)dettagli.getString("iva"));
            Double ivaPerc = 0.0;
            ResultSet dettaglioIva = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)("SELECT percentuale FROM codici_iva WHERE codice = '" + iva + "'"));
            if (dettaglioIva.next()) {
                ivaPerc = dettaglioIva.getDouble("percentuale");
            }
            DbUtils.close((ResultSet)dettaglioIva);
            double imponibile = CastUtils.toDouble0((Object)dettagli.getDouble("impo"));
            if (this.scontoTestata1 != 0.0) {
                imponibile -= imponibile / 100.0 * this.scontoTestata1;
            }
            if (this.scontoTestata2 != 0.0) {
                imponibile -= imponibile / 100.0 * this.scontoTestata2;
            }
            if (this.scontoTestata3 != 0.0) {
                imponibile -= imponibile / 100.0 * this.scontoTestata3;
            }
            if (this.sconto > 0.0) {
                double sconto_proporzionato = 0.0;
                sconto_proporzionato = !this.prezziIvati ? imponibile * this.sconto / this.totaleImponibilePreSconto : imponibile * this.sconto / this.totaleIvatoPreSconto;
                imponibile -= sconto_proporzionato;
            }
            Double imposta = CastUtils.toDouble0((Object)imponibile) * ivaPerc / 100.0;
            Double percDedu = 100.0;
            if (dettagli.getObject("iva_deducibile") != null) {
                percDedu = CastUtils.toDouble0((Object)dettagli.getDouble("iva_deducibile"));
            }
            Double deducibile = imposta - imposta * (percDedu / 100.0);
            impDeducibile += deducibile.doubleValue();
            System.out.println("dettagli: " + dettagli.getDouble("iva_deducibile"));
        }
        DbUtils.close((ResultSet)dettagli);
        return impDeducibile;
    }

    public double getImpNonDeducibile() throws SQLException, Exception {
        double ret = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            ret += d.getImponibile_indeducibile();
        }
        return ret;
    }

    public double getImpNonDeducibileOld() throws SQLException, Exception {
        ResultSet dettagli = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)this.sqlPerDettagli);
        double impDeducibile = 0.0;
        while (dettagli.next()) {
            Double imponibile = CastUtils.toDouble0((Object)dettagli.getDouble("impo"));
            if (this.scontoTestata1 != 0.0) {
                imponibile = imponibile - imponibile / 100.0 * this.scontoTestata1;
            }
            if (this.scontoTestata2 != 0.0) {
                imponibile = imponibile - imponibile / 100.0 * this.scontoTestata2;
            }
            if (this.scontoTestata3 != 0.0) {
                imponibile = imponibile - imponibile / 100.0 * this.scontoTestata3;
            }
            if (this.sconto > 0.0) {
                double sconto_proporzionato = 0.0;
                sconto_proporzionato = !this.prezziIvati ? imponibile * this.sconto / this.totaleImponibilePreSconto : imponibile * this.sconto / this.totaleIvatoPreSconto;
                imponibile = imponibile - sconto_proporzionato;
            }
            Double percDedu = 100.0;
            if (dettagli.getObject("iva_deducibile") != null) {
                percDedu = CastUtils.toDouble0((Object)dettagli.getDouble("iva_deducibile"));
            }
            Double deducibile = imponibile - imponibile * (percDedu / 100.0);
            impDeducibile += deducibile.doubleValue();
            System.out.println("dettagli: " + dettagli.getDouble("iva_deducibile"));
        }
        DbUtils.close((ResultSet)dettagli);
        return impDeducibile;
    }

    public double getImpIvaDeducibile(String codiceIva) {
        double ret = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            if (!d.getCodice().equalsIgnoreCase(codiceIva)) continue;
            ret += d.getImponibile_deducibile();
        }
        return ret;
    }

    public double getIvaDeducibile(String codiceIva) {
        double ret = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            if (!d.getCodice().equalsIgnoreCase(codiceIva)) continue;
            ret += d.getImposta_deducibile();
        }
        return ret;
    }

    public double getImpIva(String codiceIva) {
        double ret = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            if (!d.getCodice().equalsIgnoreCase(codiceIva)) continue;
            ret += d.getImponibile();
        }
        return ret;
    }

    public double getIva(String codiceIva) {
        double ret = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            if (!d.getCodice().equalsIgnoreCase(codiceIva)) continue;
            ret += d.getImposta();
        }
        return ret;
    }

    public void visualizzaCastellettoIva() {
        String temp = "Castelletto Iva\n";
        temp = temp + "codice\t percentuale\t imponibile\t imposta\t\t\t imponibile_noarr\t imposta_noarr\n";
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            temp = temp + d.getCodice();
            temp = temp + "\t" + d.getPercentuale() + " (ded.:" + d.getPerc_deducibilita() + ")";
            temp = temp + "\t" + d.getImponibile();
            temp = temp + "\t" + d.getImposta();
            temp = temp + "\t\t\t" + d.imponibile_noarr;
            temp = temp + "\t" + d.imposta_noarr;
            temp = temp + "\n";
        }
        temp = temp + "totaleiva " + this.totaleIva;
        temp = temp + "\t totaleimp " + this.totaleImponibile;
        temp = temp + "\t totale    " + this.totale;
        temp = temp + "\n";
        System.out.println(temp);
    }

    public String dumpCastellettoIva() {
        String temp = "Castelletto Iva\n";
        temp = temp + "codice\tdescrizione\tpercentuale\timponibile\timposta\t\t\timponibile_noarr\timposta_noarr\n";
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            temp = temp + d.getCodice();
            temp = temp + "\t" + d.getDescrizione();
            temp = temp + "\t" + d.getPercentuale() + " (ded.:" + d.getPerc_deducibilita() + ")";
            temp = temp + "\t" + d.getImponibile();
            temp = temp + "\t" + d.getImposta();
            temp = temp + "\t\t\t" + d.imponibile_noarr;
            temp = temp + "\t" + d.imposta_noarr;
            temp = temp + "\n";
        }
        temp = temp + "totaleiva " + this.totaleIva;
        temp = temp + "\t totaleimp " + this.totaleImponibile;
        temp = temp + "\t totale    " + this.totale;
        temp = temp + "\n";
        return temp;
    }

    public Cliente getCliente() {
        return this.cliente;
    }

    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    public double getScontoTestata1() {
        return this.scontoTestata1;
    }

    public void setScontoTestata1(double scontoTestata1) {
        this.scontoTestata1 = scontoTestata1;
    }

    public double getScontoTestata2() {
        return this.scontoTestata2;
    }

    public void setParametriArrotondamento(String arrotondamentoParametro, String arrotondamentoTipo) {
        this.parametroArrotondamento = Double.parseDouble(arrotondamentoParametro);
        this.perDifetto = arrotondamentoTipo.equals("Inf.");
    }

    public void setScontoTestata2(double scontoTestata2) {
        this.scontoTestata2 = scontoTestata2;
    }

    public double getScontoTestata3() {
        return this.scontoTestata3;
    }

    public void setScontoTestata3(double scontoTestata3) {
        this.scontoTestata3 = scontoTestata3;
    }

    public double getTotaleSconti() {
        return this.totaleSconti;
    }

    public void setTotaleSconti(double totaleSconti) {
        this.totaleSconti = totaleSconti;
    }

    public double getTotale() {
        return this.totale;
    }

    public void setTotale(double totale) {
        this.totale = totale;
    }

    public double getTotaleQuantita() {
        return this.totaleQuantita;
    }

    public double getTotaleIva() {
        return this.totaleIva;
    }

    public void setTotaleIva(double totaleIva) {
        this.totaleIva = totaleIva;
    }

    public double getTotaleImponibile() {
        return this.totaleImponibile;
    }

    public void setTotaleImponibile(double totaleImponibile) {
        this.totaleImponibile = totaleImponibile;
    }

    public double getSpeseTrasporto() {
        return this.speseTrasporto;
    }

    public void setSpeseTrasporto(double speseTrasporto) {
        this.speseTrasporto = speseTrasporto;
    }

    public double getSpeseVarieImponibili() {
        return this.speseVarieImponibili;
    }

    public void setSpeseVarieImponibili(double speseVarieImponibili) {
        this.speseVarieImponibili = speseVarieImponibili;
    }

    public double getSpeseIncasso() {
        return this.speseIncasso;
    }

    public void setSpeseIncasso(double speseIncasso) {
        this.speseIncasso = speseIncasso;
    }

    public long getCodiceCliente() {
        return this.codiceCliente;
    }

    public void setCodiceCliente(long codiceCliente) {
        this.codiceCliente = codiceCliente;
    }

    public void setCodiceFornitore(long codiceFornitore) {
        this.codiceFornitore = codiceFornitore;
    }

    public int getRitenuta() {
        return this.ritenuta;
    }

    public void setRitenuta(int ritenuta) {
        this.ritenuta = ritenuta;
    }

    public double getTotale_ritenuta() {
        return this.totale_ritenuta;
    }

    public void setTotale_ritenuta(double totale_ritenuta) {
        this.totale_ritenuta = totale_ritenuta;
    }

    public double getTotale_da_pagare() {
        return this.totale_da_pagare;
    }

    public void setTotale_da_pagare(double totale_da_pagare) {
        this.totale_da_pagare = totale_da_pagare;
    }

    public double getTotale_da_pagare_finale() {
        return this.totale_da_pagare_finale;
    }

    public void setTotale_da_pagare_finale(double totale_da_pagare_finale) {
        this.totale_da_pagare_finale = totale_da_pagare_finale;
    }

    public double getAcconto() {
        return this.acconto;
    }

    public void setAcconto(double acconto) {
        this.acconto = acconto;
    }

    public double getRitenuta_perc() {
        return this.ritenuta_perc;
    }

    public void setRitenuta_perc(double ritenuta_perc) {
        this.ritenuta_perc = ritenuta_perc;
    }

    public String getRitenuta_descrizione() {
        return this.ritenuta_descrizione;
    }

    public void setRitenuta_descrizione(String ritenuta_descrizione) {
        this.ritenuta_descrizione = ritenuta_descrizione;
    }

    public boolean isRivalsa_inps() {
        return this.rivalsa_inps;
    }

    public void setRivalsa_inps(boolean rivalsa_inps) {
        this.rivalsa_inps = rivalsa_inps;
    }

    public void setRivalsaCodice(Integer codRivalsa) {
        if (!codRivalsa.equals("")) {
            this.rivalsa_codice = codRivalsa;
        }
    }

    public double getTotale_rivalsa() {
        double massimale = 0.0;
        if (this.rivalsa_codice != null && this.rivalsa_codice != -1) {
            try {
                massimale = CastUtils.toDouble0((Object)DbUtils.getObject((Connection)Db.getConn(), (String)("SELECT massimale FROM tipi_rivalsa WHERE id = " + Db.pc(this.rivalsa_codice, 4))));
            }
            catch (Exception ex) {
                massimale = 0.0;
            }
            if (massimale != 0.0 && massimale < this.totale_rivalsa) {
                return massimale;
            }
        }
        return this.totale_rivalsa;
    }

    public void setTotale_rivalsa(double totale_rivalsa) {
        this.totale_rivalsa = totale_rivalsa;
        double massimale = 0.0;
        if (this.rivalsa_codice != null && this.rivalsa_codice != -1) {
            try {
                massimale = CastUtils.toDouble0((Object)DbUtils.getObject((Connection)Db.getConn(), (String)("SELECT massimale FROM tipi_rivalsa WHERE id = " + Db.pc(this.rivalsa_codice, 4))));
            }
            catch (Exception ex) {
                massimale = 0.0;
            }
            if (massimale != 0.0 && massimale < totale_rivalsa) {
                this.totale_rivalsa = massimale;
            }
        }
    }

    public double getTotale_imponibile2() {
        return this.totale_imponibile2;
    }

    public void setTotale_imponibile2(double totale_imponibile2) {
        this.totale_imponibile2 = totale_imponibile2;
    }

    public double getTotaleImponibileParziale() {
        return this.totaleImponibileParziale;
    }

    public void setTotaleImponibileParziale(double totaleImponibileParziale) {
        this.totaleImponibileParziale = totaleImponibileParziale;
    }

    public Double getRivalsa_inps_perc() {
        return this.rivalsa_inps_perc;
    }

    public void setRivalsa_inps_perc(Double rivalsa_inps_perc) {
        this.rivalsa_inps_perc = rivalsa_inps_perc;
    }

    public String getRivalsa_inps_descrizione() {
        return this.rivalsa_inps_descrizione;
    }

    public void setRivalsa_inps_descrizione(String rivalsa_inps_descrizione) {
        this.rivalsa_inps_descrizione = rivalsa_inps_descrizione;
    }

    public void setData(Date date) {
        this.data = date;
    }

    public boolean isPrezziIvati() {
        return this.prezziIvati;
    }

    public void setPrezziIvati(boolean prezziIvati) {
        this.prezziIvati = prezziIvati;
    }

    public double getTotaleIvatoParziale() {
        return this.totaleIvatoParziale;
    }

    public void setTotaleIvatoParziale(double totaleIvatoParziale) {
        this.totaleIvatoParziale = totaleIvatoParziale;
    }

    public double getTotaleIvato() {
        return this.totaleIvato;
    }

    public void setTotaleIvato(double totaleIvato) {
        this.totaleIvato = totaleIvato;
    }

    public double getSconto() {
        return this.sconto;
    }

    public void setSconto(double sconto) {
        this.sconto = sconto;
    }

    public double getTotaleImponibilePerRivalsa() {
        return this.totaleImponibilePerRivalsa;
    }

    public void setTotaleImponibilePerRivalsa(double totaleImponibilePerRivalsa) {
        this.totaleImponibilePerRivalsa = totaleImponibilePerRivalsa;
    }

    public double getTotaleImponibilePerRitenuta() {
        return this.totaleImponibilePerRitenuta;
    }

    private Map<String, DettaglioIva> getDettagliIvaMap(Map<IvaDed, DettaglioIva> dettagliIvaDedMap) {
        LinkedHashMap<String, DettaglioIva> dettagliIvaMap = new LinkedHashMap<String, DettaglioIva>();
        for (IvaDed key : dettagliIvaDedMap.keySet()) {
            DettaglioIva dsorg = dettagliIvaDedMap.get(key);
            if (!dettagliIvaMap.containsKey(key.codice_iva.toUpperCase())) {
                dettagliIvaMap.put(key.codice_iva.toUpperCase(), new DettaglioIva());
            }
            DettaglioIva ddest = (DettaglioIva)dettagliIvaMap.get(key.codice_iva.toUpperCase());
            ddest.setImponibile(cu.d0((Object)ddest.getImponibile()) + cu.d0((Object)dsorg.getImponibile()));
            ddest.setIvato(cu.d0((Object)ddest.getIvato()) + cu.d0((Object)dsorg.getIvato()));
            ddest.setImposta(cu.d0((Object)ddest.getImposta()) + cu.d0((Object)dsorg.getImposta()));
            ddest.setCodice(dsorg.getCodice());
            ddest.setDescrizione(dsorg.getDescrizione());
            ddest.setDescrizioneBreve(dsorg.getDescrizioneBreve());
            ddest.setPercentuale(dsorg.getPercentuale());
        }
        return dettagliIvaMap;
    }

    private DettaglioIva getDetIva(String codice_iva, double perc_ded) {
        for (IvaDed key : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva dsorg = this.dettagliIvaDedMap.get(key);
            if (!dsorg.getCodice().equalsIgnoreCase(codice_iva) || dsorg.getPerc_deducibilita() != perc_ded) continue;
            return dsorg;
        }
        return null;
    }

    private double getIvaMedia(Map<IvaDed, DettaglioIva> dettagliIvaDedMap) {
        Iterator<IvaDed> ivaiter = dettagliIvaDedMap.keySet().iterator();
        double totaleImponibile = 0.0;
        double totaleIvato = 0.0;
        while (ivaiter.hasNext()) {
            IvaDed ivakey = ivaiter.next();
            DettaglioIva d = dettagliIvaDedMap.get(ivakey);
            totaleImponibile += d.getImponibile();
            totaleIvato += d.getIvato();
        }
        double percmedia = totaleIvato / totaleImponibile;
        return percmedia;
    }

    private void calcolaTotaliSubSpese(String tipo, String iva_spese) {
        String codiceIvaSpese = "";
        codiceIvaSpese = iva_spese == null ? InvoicexUtil.getIvaSpesePerData(this.data, tipo) : iva_spese;
        Iva ivaSpese = new Iva();
        double spese = 0.0;
        if (tipo.equals("codiceIvaSpese")) {
            spese = this.speseTrasporto;
        } else if (tipo.equals("codiceIvaSpeseIncasso")) {
            spese = this.speseIncasso;
        }
        if (ivaSpese.load(Db.INSTANCE, codiceIvaSpese)) {
            boolean codiceIvaSpeseTrovato = false;
            this.speseImponibili = spese;
            this.speseIvate = spese;
            this.proporzioniIva.put(new IvaDed(ivaSpese.getCodice(), 100.0), 100.0);
            if (this.getRivalsa_inps_perc() != null && this.getRivalsa_inps_perc() != 0.0 && tipo.equals("codiceIvaSpeseRivalsa") && this.isIncludi_rivalsa_in_iva()) {
                this.speseImponibili += this.getTotale_rivalsa();
                this.speseIvate += this.getTotale_rivalsa() * ((ivaSpese.getPercentuale() + 100.0) / 100.0);
            }
            for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
                if (d.getCodice().equalsIgnoreCase(codiceIvaSpese) && d.getPerc_deducibilita() == 100.0) {
                    codiceIvaSpeseTrovato = true;
                    this.addDettaglioIvaSpese(tipo, ivakey.codice_iva, d.getPercentuale(), spese);
                    d.setImponibile(d.getImponibile() + spese);
                    d.setImponibile(Util.round(d.getImponibile(), 2));
                    d.setImponibile_deducibile(d.getImponibile_deducibile() + spese);
                    d.setIvato(d.getIvato() + spese);
                    d.setIvato(Util.round(d.getIvato(), 2));
                    d.setIvato_deducibile(d.getIvato_deducibile() + spese);
                    if (this.getRivalsa_inps_perc() != null && this.getRivalsa_inps_perc() != 0.0 && tipo.equals("codiceIvaSpeseRivalsa") && this.isIncludi_rivalsa_in_iva()) {
                        d.setImponibile(d.getImponibile() + this.getTotale_rivalsa());
                        d.setImponibile(Util.round(d.getImponibile(), 2));
                        d.setImponibile_deducibile(d.getImponibile_deducibile() + this.getTotale_rivalsa());
                        d.setIvato(d.getIvato() + (this.getTotale_rivalsa() + Util.round(this.getTotale_rivalsa() / 100.0 * d.getPercentuale(), 2)));
                        d.setIvato(Util.round(d.getIvato(), 2));
                        d.setIvato_deducibile(d.getIvato_deducibile() + (this.getTotale_rivalsa() + Util.round(this.getTotale_rivalsa() / 100.0 * d.getPercentuale(), 2)));
                    }
                }
                double imposta_deducibile = 0.0;
                double imposta_indeducibile = 0.0;
                if (!this.isPrezziIvati()) {
                    this.imposta_noarr = this.imposta = d.getImponibile() / 100.0 * d.getPercentuale();
                    this.imposta = Util.round(this.imposta, 2);
                } else {
                    this.imposta_noarr = this.imposta = d.getIvato() * d.getPercentuale() / (100.0 + d.getPercentuale());
                    this.imposta = Util.round(this.imposta, 2);
                }
                imposta_deducibile = Util.round(this.imposta / 100.0 * d.getPerc_deducibilita(), 2);
                imposta_indeducibile = Util.round(this.imposta - imposta_deducibile, 2);
                d.setImposta(this.imposta);
                d.imposta_noarr = this.imposta_noarr;
                d.setImposta_deducibile(imposta_deducibile);
                d.setImposta_indeducibile(imposta_indeducibile);
                if (!this.isPrezziIvati()) continue;
                d.setImponibile(d.getIvato() - d.getImposta());
                d.setImponibile_deducibile(d.getIvato_deducibile() - d.getImposta_deducibile());
                d.setImponibile_indeducibile(d.getIvato_indeducibile() - d.getImposta_indeducibile());
            }
            if (!codiceIvaSpeseTrovato) {
                DettaglioIva ds = new DettaglioIva();
                ds.setCodice(codiceIvaSpese);
                ds.setPercentuale(ivaSpese.getPercentuale());
                ds.setDescrizione(ivaSpese.getDescrizione());
                ds.setDescrizioneBreve(ivaSpese.getDescrizioneBreve());
                this.addDettaglioIvaSpese(tipo, codiceIvaSpese, ivaSpese.getPercentuale(), spese);
                ds.setImponibile(spese);
                ds.setImponibile_deducibile(spese);
                ds.setIvato(spese);
                ds.setIvato_deducibile(spese);
                if (this.getRivalsa_inps_perc() != null && this.getRivalsa_inps_perc() != 0.0 && tipo.equals("codiceIvaSpeseRivalsa") && this.isIncludi_rivalsa_in_iva()) {
                    ds.setImponibile(ds.getImponibile() + this.getTotale_rivalsa());
                    ds.setImponibile(Util.round(ds.getImponibile(), 2));
                    ds.setImponibile_deducibile(ds.getImponibile_deducibile() + this.getTotale_rivalsa());
                    ds.setIvato(ds.getIvato() + (this.getTotale_rivalsa() + Util.round(this.getTotale_rivalsa() / 100.0 * ds.getPercentuale(), 2)));
                    ds.setIvato(Util.round(ds.getIvato(), 2));
                    ds.setIvato_deducibile(ds.getIvato_deducibile() + (this.getTotale_rivalsa() + Util.round(this.getTotale_rivalsa() / 100.0 * ds.getPercentuale(), 2)));
                }
                double imposta_deducibile = 0.0;
                double imposta_indeducibile = 0.0;
                if (!this.isPrezziIvati()) {
                    this.imposta_noarr = this.imposta = ds.getImponibile() / 100.0 * ivaSpese.getPercentuale();
                    this.imposta = Util.round(this.imposta, 2);
                    imposta_deducibile = Util.round(ds.getImponibile_deducibile() / 100.0 * ivaSpese.getPercentuale(), 2);
                } else {
                    this.imposta_noarr = this.imposta = ds.getIvato() * ivaSpese.getPercentuale() / (100.0 + ivaSpese.getPercentuale());
                    this.imposta = Util.round(this.imposta, 2);
                    imposta_deducibile = Util.round(ds.getIvato_deducibile() * ivaSpese.getPercentuale() / (100.0 + ivaSpese.getPercentuale()), 2);
                }
                ds.setImposta(this.imposta);
                ds.setImposta_deducibile(imposta_deducibile);
                ds.imposta_noarr = this.imposta_noarr;
                ds.setPercentuale(ivaSpese.getPercentuale());
                if (this.isPrezziIvati()) {
                    ds.setImponibile(ds.getIvato() - ds.getImposta());
                    ds.setImponibile_deducibile(ds.getIvato_deducibile() - ds.getImposta_deducibile());
                }
                if (ds.getImponibile() != 0.0) {
                    ds.setPerc_deducibilita(100.0);
                    this.dettagliIvaDedMap.put(new IvaDed(codiceIvaSpese, 100.0), ds);
                }
            }
            this.totaleImponibile = 0.0;
            this.totaleImponibilePositivo = 0.0;
            this.totaleIvato = 0.0;
            this.totaleIvatoPositivo = 0.0;
            this.totaleImposta = 0.0;
            for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
                this.totaleImponibile += d.getImponibile();
                this.totaleImponibilePositivo += d.getImponibile();
                this.totaleIvato += d.getIvato();
                this.totaleIvatoPositivo += d.getIvato();
                this.totaleImposta += d.getImposta();
            }
        } else {
            DettaglioIva d;
            this.speseImponibili = spese;
            this.speseIvate = spese;
            if (this.getRivalsa_inps_perc() != null && this.getRivalsa_inps_perc() != 0.0 && tipo.equals("codiceIvaSpeseRivalsa") && this.isIncludi_rivalsa_in_iva()) {
                DettaglioIva d2;
                boolean trovata_iva_std = false;
                double iva_std = 22.0;
                if (this.data != null && this.data.before(DateUtils.getOnlyDate((int)2011, (int)9, (int)17))) {
                    iva_std = 20.0;
                } else if (this.data != null && this.data.before(DateUtils.getOnlyDate((int)2013, (int)10, (int)1))) {
                    iva_std = 21.0;
                }
                for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                    d2 = this.dettagliIvaDedMap.get(ivakey);
                    if (d2.getPercentuale() != iva_std) continue;
                    trovata_iva_std = true;
                    break;
                }
                if (trovata_iva_std) {
                    for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                        d2 = this.dettagliIvaDedMap.get(ivakey);
                        if (d2.getPercentuale() != iva_std) continue;
                        d2.setImponibile(d2.getImponibile() + this.getTotale_rivalsa());
                        this.imposta_noarr = this.imposta = d2.getImponibile() / 100.0 * d2.getPercentuale();
                        this.imposta = Util.round(this.imposta, 2);
                        double imposta_deducibile = Util.round(d2.getImponibile_deducibile() / 100.0 * d2.getPercentuale(), 2);
                        d2.setImposta(this.imposta);
                        d2.setImponibile_deducibile(imposta_deducibile);
                        d2.setIvato(d2.getImponibile() + this.imposta);
                        d2.setIvato_deducibile(d2.getImponibile_deducibile() + imposta_deducibile);
                        break;
                    }
                } else if (!this.isPrezziIvati()) {
                    this.speseImponibili += this.getTotale_rivalsa();
                } else {
                    this.speseIvate += this.getTotale_rivalsa() * this.getIvaMedia(this.dettagliIvaDedMap);
                }
            }
            this.totaleImponibile = 0.0;
            this.totaleImponibilePositivo = 0.0;
            this.totaleIvato = 0.0;
            this.totaleIvatoPositivo = 0.0;
            this.totaleImposta = 0.0;
            for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                DettaglioIva d3 = this.dettagliIvaDedMap.get(ivakey);
                this.totaleImponibile += d3.getImponibile();
                this.totaleImponibilePositivo += d3.getImponibile();
                this.totaleIvato += d3.getIvato();
                this.totaleIvatoPositivo += d3.getIvato();
                this.totaleImposta += d3.getImposta();
            }
            Map<String, DettaglioIva> dettagliIvaMap = this.getDettagliIvaMap(this.dettagliIvaDedMap);
            for (String ivakeycodice : this.getDettagliIvaMap(this.dettagliIvaDedMap).keySet()) {
                DettaglioIva d2;
                d = dettagliIvaMap.get(ivakeycodice);
                double importoSpeseRipartito = 0.0;
                double nuovoImponibile = 0.0;
                double nuovoIvato = 0.0;
                if (!this.isPrezziIvati()) {
                    importoSpeseRipartito = this.speseImponibili * d.getImponibile() / this.totaleImponibilePositivo;
                    d2 = this.getDetIva(ivakeycodice, 100.0);
                    if (d2 == null) {
                        d2 = new DettaglioIva();
                        d2.setCodice(ivakeycodice);
                        d2.setDescrizione(d.getDescrizione());
                        d2.setDescrizioneBreve(d.getDescrizioneBreve());
                        d2.setPercentuale(d.getPercentuale());
                        d2.setPerc_deducibilita(100.0);
                    }
                    if (!Double.isNaN(importoSpeseRipartito)) {
                        nuovoImponibile = cu.d0((Object)d2.getImponibile()) + importoSpeseRipartito;
                        this.addDettaglioIvaSpese(tipo, ivakeycodice, d.getPercentuale(), importoSpeseRipartito);
                    } else {
                        nuovoImponibile = cu.d0((Object)d2.getImponibile());
                    }
                    this.imposta_noarr = this.imposta = nuovoImponibile / 100.0 * d.getPercentuale();
                    this.imposta = Util.round(this.imposta, 2);
                    d2.imponibile_noarr = nuovoImponibile;
                    nuovoImponibile = Util.round(nuovoImponibile, 2);
                    d2.setImponibile(nuovoImponibile);
                    d2.setImposta(this.imposta);
                    d2.imposta_noarr = this.imposta_noarr;
                    this.dettagliIvaDedMap.put(new IvaDed(ivakeycodice, 100.0), d2);
                    continue;
                }
                importoSpeseRipartito = this.speseIvate * d.getIvato() / this.totaleIvatoPositivo;
                d2 = this.getDetIva(ivakeycodice, 100.0);
                if (d2 == null) {
                    d2 = new DettaglioIva();
                    d2.setCodice(ivakeycodice);
                    d2.setDescrizione(d.getDescrizione());
                    d2.setDescrizioneBreve(d.getDescrizioneBreve());
                    d2.setPercentuale(d.getPercentuale());
                    d2.setPerc_deducibilita(100.0);
                }
                if (!Double.isNaN(importoSpeseRipartito)) {
                    nuovoIvato = d2.getIvato() + importoSpeseRipartito;
                    this.addDettaglioIvaSpese(tipo, ivakeycodice, d.getPercentuale(), importoSpeseRipartito);
                } else {
                    nuovoIvato = d2.getIvato();
                }
                this.imposta_noarr = this.imposta = nuovoIvato * d.getPercentuale() / (100.0 + d.getPercentuale());
                this.imposta = Util.round(this.imposta, 2);
                d2.ivato_noarr = nuovoIvato;
                nuovoIvato = Util.round(nuovoIvato, 2);
                d2.setIvato(nuovoIvato);
                d2.setImposta(this.imposta);
                d2.setImponibile(nuovoIvato - this.imposta);
                d2.imposta_noarr = this.imposta_noarr;
                this.dettagliIvaDedMap.put(new IvaDed(ivakeycodice, 100.0), d2);
            }
            this.totaleImponibile = 0.0;
            this.totaleImponibilePositivo = 0.0;
            this.totaleIvato = 0.0;
            this.totaleIvatoPositivo = 0.0;
            this.totaleImposta = 0.0;
            for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                d = this.dettagliIvaDedMap.get(ivakey);
                this.totaleImponibile += d.getImponibile();
                this.totaleImponibilePositivo += d.getImponibile();
                this.totaleIvato += d.getIvato();
                this.totaleIvatoPositivo += d.getIvato();
                this.totaleImposta += d.getImposta();
            }
        }
    }

    private void addDettaglioIvaSpese(String tipo, String codice_iva, double percentuale, double imponibile) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("codice_iva", codice_iva);
        m.put("perc_iva", percentuale);
        if (this.isPrezziIvati()) {
            imponibile /= 1.0 + percentuale / 100.0;
        }
        m.put("imponibile", Util.round(imponibile, 2));
        if (tipo.equals("codiceIvaSpese")) {
            m.put("tipo_riga", "ST");
            this.dettagliIvaSpeseTrasporto.add(m);
            this.dettagliIvaSpeseTrasportoDebug.add("iva " + codice_iva + ":" + percentuale + " \u20ac " + Util.round(imponibile, 2));
        } else if (tipo.equals("codiceIvaSpeseIncasso")) {
            m.put("tipo_riga", "SI");
            this.dettagliIvaSpeseIncasso.add(m);
            this.dettagliIvaSpeseIncassoDebug.add("iva " + codice_iva + ":" + percentuale + " \u20ac " + Util.round(imponibile, 2));
        }
    }

    public void salvaDettagliCalcolo(Integer id, boolean delete) throws Exception {
        if (this.tipoDocumento != null && (this.tipoDocumento.equals(Db.TIPO_DOCUMENTO_FATTURA) || this.tipoDocumento.equals(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA))) {
            String sql = null;
            if (delete) {
                sql = "delete from " + Db.getNomeTabT(this.tipoDocumento) + "_iva_dettagli where id_padre = " + dbu.sql((Object)id);
                dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
            }
            this.salvaDettagliSub(id, this.dettagliIvaSpeseTrasporto);
            this.salvaDettagliSub(id, this.dettagliIvaSpeseIncasso);
        }
    }

    private void salvaDettagliSub(Integer id, List<Map> dettagliIvaSpese) throws Exception {
        for (Map m : dettagliIvaSpese) {
            m.put("id_padre", id);
            String sql = "insert into " + Db.getNomeTabT(this.tipoDocumento) + "_iva_dettagli set " + dbu.prepareSqlFromMap((Map)m);
            dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
        }
    }
}

