/*
 * Decompiled with CFR 0.152.
 */
package gestioneFatture.logic.documenti;

import gestioneFatture.Db;
import gestioneFatture.logic.Iva;
import gestioneFatture.logic.documenti.DettaglioIva;
import gestioneFatture.logic.documenti.IvaDed;
import gestioneFatture.main;
import it.tnx.Util;
import it.tnx.commons.CastUtils;
import it.tnx.commons.DateUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.DebugFastUtils;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.MicroBench;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.invoicex.InvoicexUtil;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class Documento2 {
    public Vector dettagliIva = new Vector();
    public Map<IvaDed, DettaglioIva> dettagliIvaDedMap = new LinkedHashMap<IvaDed, DettaglioIva>();
    private Vector dettagliDocumento = new Vector();
    private Map<IvaDed, Double> proporzioniIva = new HashMap<IvaDed, Double>();
    private Map<IvaDed, Double> proporzioniIvaSconto = new HashMap<IvaDed, Double>();
    private Db db = null;
    private double totaImpo = 0.0;
    private double totaIva = 0.0;
    private double tota = 0.0;
    private double totaleQuantita = 0.0;
    public double totalePeso = 0.0;
    private double tempSconto1 = 0.0;
    private double tempSconto2 = 0.0;
    private double tempSconto3 = 0.0;
    private double tempSpeseVarie = 0.0;
    private double tempSpeseTrasportoIva = 0.0;
    private double tempSpeseIncassoIva = 0.0;
    private String rivalsa_inps_descrizione;
    private Double rivalsa_inps_perc;
    private double totale;
    private double totaleIva;
    private double totaleImponibileParziale;
    private double totaleImponibilePerRivalsa;
    private double totaleImponibile;
    private double totaleImponibilePerRitenuta;
    private double totaleIvatoParziale;
    private double totaleIvato;
    private double totaleIvatoPerRitenuta;
    public boolean speseBolloSiNo = false;
    private long codiceCliente;
    private long codiceFornitore;
    private int ritenuta;
    private String ritenuta_descrizione;
    private Integer rivalsa_codice;
    private double ritenuta_perc;
    private double totale_ritenuta;
    private double acconto;
    private double totale_da_pagare;
    private double totale_da_pagare_finale;
    private boolean rivalsa_inps;
    private double totale_rivalsa;
    private double totale_imponibile2;
    private double totaleSconti;
    private Date data;
    private double parametroArrotondamento = 0.0;
    private boolean perDifetto = true;
    private boolean prezziIvati = false;
    private String tipoDocumento = "";
    private double sconto;
    public double totaleImponibilePreSconto = 0.0;
    public double totaleIvatoPreSconto = 0.0;
    double imponibile = 0.0;
    double imposta = 0.0;
    double imposta_noarr = 0.0;
    double ivato = 0.0;
    double totaleImponibilePositivo = 0.0;
    double totaleIvatoPositivo = 0.0;
    double totaleImposta = 0.0;
    double speseImponibili = 0.0;
    double speseIvate = 0.0;
    public List<DettaglioIva> speseTrasportoDettagli = null;
    public List<DettaglioIva> speseIncassoDettagli = null;
    public Integer id_documento = null;
    public String table_righe_temp;
    Integer numero = null;
    String serie = null;
    Integer anno = null;
    Integer id = null;
    Map testa = null;
    List<Map> righe = null;
    public Map cliente = null;
    public Map<Object, Map> iva = null;
    private boolean includi_rivalsa_in_imp_ritenuta = true;
    private boolean includi_rivalsa_in_iva = true;
    private boolean sottrai_rivalsa = false;
    private String codiceIvaSpeseRivalsa = null;

    public Documento2(Map testa, List<Map> righe) {
        this.testa = testa;
        this.righe = righe;
        this.setPrezziIvati(cu.toBoolean(testa.get("prezzi_ivati"), (Boolean)false));
        this.setCodiceIvaSpeseRivalsa(cu.s(testa.get("codiceIvaSpeseRivalsa")));
        if (testa.get("ritenuta") != null) {
            this.setRitenuta(cu.i0(testa.get("ritenuta")));
            this.setRitenuta_perc(cu.d0(testa.get("percentuale_ritenuta")));
        }
        if (testa.get("rivalsa") != null) {
            this.setRivalsaCodice(cu.i(testa.get("rivalsa")));
            this.setRivalsa_inps_perc(cu.d(testa.get("rivalsaInpsPerc")));
            this.setRivalsa_inps_descrizione(cu.s(testa.get("rivalsaInpsTesto")));
        }
        this.setSottrai_rivalsa(cu.toBoolean(testa.get("sottrai_rivalsa")));
        this.setIncludi_rivalsa_in_imp_ritenuta(cu.toBoolean(testa.get("includi_rivalsa_in_imp_ritenuta")));
        this.setIncludi_rivalsa_in_iva(cu.toBoolean(testa.get("includi_rivalsa_in_iva")));
    }

    public boolean isIncludi_rivalsa_in_imp_ritenuta() {
        return this.includi_rivalsa_in_imp_ritenuta;
    }

    public void setIncludi_rivalsa_in_imp_ritenuta(boolean includi_rivalsa_in_imp_ritenuta) {
        this.includi_rivalsa_in_imp_ritenuta = includi_rivalsa_in_imp_ritenuta;
    }

    public boolean isIncludi_rivalsa_in_iva() {
        return this.includi_rivalsa_in_iva;
    }

    public void setIncludi_rivalsa_in_iva(boolean includi_rivalsa_in_iva) {
        this.includi_rivalsa_in_iva = includi_rivalsa_in_iva;
    }

    public boolean isSottrai_rivalsa() {
        return this.sottrai_rivalsa;
    }

    public void setSottrai_rivalsa(boolean sottrai_rivalsa) {
        this.sottrai_rivalsa = sottrai_rivalsa;
    }

    public String getCodiceIvaSpeseRivalsa() {
        return this.codiceIvaSpeseRivalsa;
    }

    public void setCodiceIvaSpeseRivalsa(String codiceIvaSpeseRivalsa) {
        this.codiceIvaSpeseRivalsa = codiceIvaSpeseRivalsa;
    }

    public synchronized void calcolaTotali() throws Exception {
        this.calcolaTotali(null, null, this.getCodiceIvaSpeseRivalsa(), null);
        this.visualizzaCastellettoIva();
    }

    public synchronized void calcolaTotali(String iva_spese_trasporto, String iva_spese_incasso, String iva_spese_rivalsa, String iva_spese_bollo) throws Exception {
        Double scontoTestata1 = cu.d(this.testa.get("sconto1"));
        Double scontoTestata2 = cu.d(this.testa.get("sconto2"));
        Double scontoTestata3 = cu.d(this.testa.get("sconto3"));
        this.setAcconto(cu.d0(this.testa.get("acconto")));
        this.setTotale_rivalsa(0.0);
        this.calcolaTotaliSub(iva_spese_trasporto, iva_spese_incasso, iva_spese_rivalsa, iva_spese_bollo, 1);
        if (this.getRivalsa_inps_perc() != null || this.ritenuta > 0) {
            this.totaleImponibile = 0.0;
            this.totaleImponibilePositivo = 0.0;
            this.totaleImponibilePerRitenuta = 0.0;
            this.totaleIvato = 0.0;
            this.totaleIvatoPositivo = 0.0;
            this.totaleIvatoPerRitenuta = 0.0;
            this.totaleImposta = 0.0;
            for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
                this.totaleImponibile += d.getImponibile();
                this.totaleImponibilePositivo += d.getImponibile();
                this.totaleImponibilePerRitenuta += d.getImponibile();
                this.totaleIvato += d.getIvato();
                this.totaleIvatoPositivo += d.getIvato();
                this.totaleIvatoPerRitenuta += d.getIvato();
                this.totaleImposta += d.getImposta();
            }
            if (this.getRivalsa_inps_perc() != null) {
                double sommeNonSoggetteRivalsa = 0.0;
                try {
                    for (Map r : this.righe) {
                        if (!StringUtils.equalsIgnoreCase((String)cu.s(r.get("flag_rivalsa")), (String)"N")) continue;
                        sommeNonSoggetteRivalsa += cu.d0(r.get("totale_imponibile")).doubleValue();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.setTotaleImponibilePerRivalsa(this.totaleImponibile - sommeNonSoggetteRivalsa);
                this.setTotale_rivalsa(Util.round(this.getTotaleImponibilePerRivalsa() / 100.0 * this.getRivalsa_inps_perc(), 2));
                if (this.isIncludi_rivalsa_in_imp_ritenuta()) {
                    this.totaleImponibilePerRitenuta += this.getTotale_rivalsa();
                }
            }
            try {
                for (Map r : this.righe) {
                    if (!StringUtils.equalsIgnoreCase((String)cu.s(r.get("flag_ritenuta")), (String)"N")) continue;
                    this.imponibile = cu.d0(r.get("impo")) - cu.d0(r.get("impo")) / 100.0 * scontoTestata1;
                    this.imponibile -= this.imponibile / 100.0 * scontoTestata2;
                    this.imponibile -= this.imponibile / 100.0 * scontoTestata3;
                    this.imponibile = Util.round(this.imponibile, 2);
                    this.totaleImponibilePerRitenuta -= this.imponibile;
                    this.ivato = cu.d0(r.get("ivato")) - cu.d0(r.get("ivato")) / 100.0 * scontoTestata1;
                    this.ivato -= this.ivato / 100.0 * scontoTestata2;
                    this.ivato -= this.ivato / 100.0 * scontoTestata3;
                    this.ivato = Util.round(this.ivato, 2);
                    this.totaleIvatoPerRitenuta -= this.ivato;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.totaleImponibileParziale = this.totaleImponibile;
            this.totaleIvatoParziale = this.totaleIvato;
        }
        this.calcolaTotaliSub(iva_spese_trasporto, iva_spese_incasso, iva_spese_rivalsa, iva_spese_bollo, 2);
        this.dettagliIva = InvoicexUtil.getIveVector(this.getDettagliIvaMap(this.dettagliIvaDedMap));
    }

    public synchronized void calcolaTotaliSub(String iva_spese_trasporto, String iva_spese_incasso, String iva_spese_rivalsa, String iva_spese_bollo, int passaggio) throws Exception {
        DettaglioIva d;
        MicroBench mb = new MicroBench(true);
        Double scontoTestata1 = cu.d0(this.testa.get("sconto1"));
        Double scontoTestata2 = cu.d0(this.testa.get("sconto2"));
        Double scontoTestata3 = cu.d0(this.testa.get("sconto3"));
        Double speseTrasporto = cu.d0(this.testa.get("spese_trasporto"));
        Double speseIncasso = cu.d0(this.testa.get("spese_incasso"));
        Double speseVarieImponibili = 0.0;
        this.setAcconto(cu.d0(this.testa.get("acconto")));
        this.totaleQuantita = 0.0;
        this.totalePeso = 0.0;
        this.totaleSconti = 0.0;
        for (Map r : this.righe) {
            this.totaleQuantita += cu.d0((Object)this.getQta(r.get("quantita"))).doubleValue();
            if (!StringUtils.equalsIgnoreCase((String)cu.s(r.get("flag_ritenuta")), (String)"N")) {
                this.totaleSconti += cu.d0(r.get("lordo")) - this.imponibile;
                this.totaleSconti += cu.d0(r.get("lordoIvato")) - this.ivato;
            }
            try {
                double pesoriga = cu.d0((Object)this.getQta(r.get("quantita"))) * cu.d0(r.get("peso"));
                this.totalePeso += pesoriga;
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
        this.totaleImponibile = 0.0;
        this.totaleImponibilePositivo = 0.0;
        this.totaleIvato = 0.0;
        this.totaleIvatoPositivo = 0.0;
        double totaleImponibile_deducibile = 0.0;
        double totaleImponibile_indeducibile = 0.0;
        double totaleIvato_deducibile = 0.0;
        double totaleIvato_indeducibile = 0.0;
        boolean split_payment = false;
        if (this.testa.containsKey("split_payment")) {
            try {
                split_payment = cu.toBoolean(this.testa.get("split_payment"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        mb.out("calcolaTotaliSub 1");
        if (this.iva == null) {
            this.iva = dbu.getListMapMap((Connection)it.tnx.Db.getConn(), (String)"select * from codici_iva order by codice", (String)"codice");
        }
        int i = 0;
        for (Map map : this.righe) {
            ++i;
            if (this.iva.get(map.get("iva")) == null && (cu.d0(map.get("prezzo")) != 0.0 || cu.d0(map.get("prezzo_ivato")) != 0.0)) {
                DebugFastUtils.dump(this.iva);
                throw new Exception("Iva non trovata, codice '" + map.get("iva") + "' alla riga " + i);
            }
            if (this.iva.get(map.get("iva")) == null) continue;
            double d2 = cu.d0((Object)this.getQta(map.get("quantita")));
            double importo_senza_iva = cu.d0(map.get("prezzo"));
            double importo_con_iva = cu.d0(map.get("prezzo_ivato"));
            double sconto1 = cu.d0(map.get("sconto1"));
            double sconto2 = cu.d0(map.get("sconto2"));
            double tot_senza_iva = 0.0;
            double tot_con_iva = 0.0;
            double totale_imponibile = 0.0;
            double totale_ivato = 0.0;
            double iva_prezz = 100.0;
            iva_prezz = 100.0 + cu.d0(this.iva.get(map.get("iva")).get("percentuale"));
            if (!this.isPrezziIvati()) {
                totale_imponibile = tot_senza_iva = InvoicexUtil.getTotaleRigaSenzaIva(d2, importo_senza_iva, sconto1, sconto2);
                totale_ivato = tot_con_iva = FormatUtils.round((double)(tot_senza_iva / 100.0 * iva_prezz), (int)2);
            } else {
                totale_ivato = tot_con_iva = InvoicexUtil.getTotaleRigaConIva(d2, importo_con_iva, sconto1, sconto2);
                totale_imponibile = tot_senza_iva = FormatUtils.round((double)(tot_con_iva / iva_prezz * 100.0), (int)2);
            }
            map.put("totale_imponibile", totale_imponibile);
            map.put("totale_ivato", totale_ivato);
        }
        mb.out("calcolaTotaliSub 2");
        ArrayList righe_iva = new ArrayList();
        i = 0;
        for (Map map : this.righe) {
            ++i;
            HashMap riva = new HashMap();
            for (Object key : map.keySet()) {
                riva.put(key, map.get(key));
            }
            riva.put("totaImpo", map.get("totale_imponibile"));
            riva.put("totaIvato", map.get("totale_ivato"));
            if (this.iva.get(map.get("iva")) == null && (cu.d0(map.get("prezzo")) != 0.0 || cu.d0(map.get("prezzo_ivato")) != 0.0)) {
                DebugFastUtils.dump(this.iva);
                throw new Exception("Iva non trovata, codice '" + map.get("iva") + "' alla riga " + i);
            }
            if (this.iva.get(map.get("iva")) == null) continue;
            riva.put("percentuale", this.iva.get(map.get("iva")).get("percentuale"));
            riva.put("descrizione", this.iva.get(map.get("iva")).get("descrizione"));
            riva.put("descrizione_breve", this.iva.get(map.get("iva")).get("descrizione_breve"));
            riva.put("quantita", cu.d0((Object)this.getQta(map.get("quantita"))));
            riva.put("lordo", cu.d0(map.get("prezzo")) * cu.d0((Object)this.getQta(map.get("quantita"))));
            riva.put("lordoIvato", cu.d0(map.get("prezzo")) * cu.d0((Object)this.getQta(map.get("quantita"))) * (1.0 + cu.d0(riva.get("percentuale")) / 100.0));
            righe_iva.add(riva);
        }
        this.dettagliIvaDedMap.clear();
        mb.out("calcolaTotaliSub 3");
        for (Map map : righe_iva) {
            if (main.fileIni.getValueBoolean("pref", "attivaArrotondamento", false).booleanValue()) {
                this.setParametriArrotondamento(cu.s(map.get("arrotondamento_parametro")), cu.s(map.get("arrotondamento_tipo")));
            }
            String kiva = cu.s(map.get("iva"));
            Double ded = cu.d(map.get("iva_deducibile"));
            if (ded == null) {
                ded = 100.0;
            }
            IvaDed kivaded = new IvaDed(kiva, ded);
            if (!StringUtils.isNotEmpty((String)kiva)) continue;
            this.imponibile = cu.d0(map.get("totaImpo"));
            this.imponibile = InvoicexUtil.calcolaPrezzoArrotondato(this.imponibile, this.parametroArrotondamento, this.perDifetto);
            this.imponibile -= this.imponibile / 100.0 * scontoTestata1;
            this.imponibile -= this.imponibile / 100.0 * scontoTestata2;
            this.imponibile -= this.imponibile / 100.0 * scontoTestata3;
            double perc_deducibilita = map.get("iva_deducibile") == null ? 100.0 : cu.d0(map.get("iva_deducibile"));
            double imponibile_deducibile = this.imponibile / 100.0 * perc_deducibilita;
            double imponibile_indeducibile = this.imponibile - imponibile_deducibile;
            this.totaleImponibile += this.imponibile;
            this.totaleImponibilePositivo += this.imponibile;
            totaleImponibile_deducibile += imponibile_deducibile;
            totaleImponibile_indeducibile += imponibile_indeducibile;
            this.ivato = cu.d0(map.get("totaIvato"));
            this.ivato = InvoicexUtil.calcolaPrezzoArrotondato(this.ivato, this.parametroArrotondamento, this.perDifetto);
            this.ivato -= this.ivato / 100.0 * scontoTestata1;
            this.ivato -= this.ivato / 100.0 * scontoTestata2;
            this.ivato -= this.ivato / 100.0 * scontoTestata3;
            double ivato_deducibile = this.ivato / 100.0 * perc_deducibilita;
            double ivato_indeducibile = this.ivato - ivato_deducibile;
            this.totaleIvato += this.ivato;
            this.totaleIvatoPositivo += this.ivato;
            totaleIvato_deducibile += ivato_deducibile;
            totaleIvato_indeducibile += ivato_indeducibile;
            DettaglioIva diva = this.dettagliIvaDedMap.get(kivaded);
            if (diva == null) {
                diva = new DettaglioIva();
                diva.setCodice(kiva);
                diva.setPerc_deducibilita(ded);
                diva.setDescrizione(cu.s(map.get("descrizione")));
                diva.setDescrizioneBreve(cu.s(map.get("descrizione_breve")));
                diva.setPercentuale(cu.d0(map.get("percentuale")));
            }
            diva.setImponibile(cu.d0((Object)diva.getImponibile()) + this.imponibile);
            diva.setImponibile_deducibile(cu.d0((Object)diva.getImponibile_deducibile()) + imponibile_deducibile);
            diva.setImponibile_indeducibile(cu.d0((Object)diva.getImponibile_indeducibile()) + imponibile_indeducibile);
            diva.imponibile_noarr = cu.d0((Object)diva.getImponibile());
            diva.setIvato(cu.d0((Object)diva.getIvato()) + this.ivato);
            diva.setIvato_deducibile(cu.d0((Object)diva.getIvato_deducibile()) + ivato_deducibile);
            diva.setIvato_indeducibile(cu.d0((Object)diva.getIvato_indeducibile()) + ivato_indeducibile);
            diva.ivato_noarr = cu.d0((Object)diva.getIvato());
            this.dettagliIvaDedMap.put(kivaded, diva);
        }
        mb.out("calcolaTotaliSub 4");
        for (IvaDed ivaDed : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d2 = this.dettagliIvaDedMap.get(ivaDed);
            d2.setImponibile(Util.round(d2.getImponibile(), 2));
            d2.setIvato(Util.round(d2.getIvato(), 2));
            d2.setImponibile_deducibile(Util.round(d2.getImponibile_deducibile(), 2));
            d2.setImponibile_indeducibile(Util.round(d2.getImponibile_indeducibile(), 2));
            d2.setIvato_deducibile(Util.round(d2.getIvato_deducibile(), 2));
            d2.setIvato_indeducibile(Util.round(d2.getIvato_indeducibile(), 2));
        }
        String string2 = "";
        string2 = iva_spese_trasporto == null ? InvoicexUtil.getIvaSpesePerData(this.data, "codiceIvaSpese") : iva_spese_trasporto;
        String codiceIvaSpeseIncasso = "";
        codiceIvaSpeseIncasso = iva_spese_incasso == null ? InvoicexUtil.getIvaSpesePerData(this.data, "codiceIvaSpeseIncasso") : iva_spese_incasso;
        String codiceIvaSpeseRivalsa = "";
        codiceIvaSpeseRivalsa = iva_spese_rivalsa == null ? InvoicexUtil.getIvaSpesePerData(this.data, "codiceIvaSpeseRivalsa") : iva_spese_rivalsa;
        String codiceIvaSpeseBollo = "";
        String string3 = codiceIvaSpeseBollo = iva_spese_bollo == null ? InvoicexUtil.getIvaSpesePerData(this.data, "codiceIvaBollo") : iva_spese_bollo;
        if (cu.s((Object)string2).equals("") && !cu.s((Object)codiceIvaSpeseIncasso).equals("")) {
            this.calcolaTotaliSubSpese("codiceIvaSpeseIncasso", codiceIvaSpeseIncasso);
            this.calcolaTotaliSubSpese("codiceIvaSpese", string2);
        } else {
            this.calcolaTotaliSubSpese("codiceIvaSpese", string2);
            this.calcolaTotaliSubSpese("codiceIvaSpeseIncasso", codiceIvaSpeseIncasso);
        }
        this.calcolaTotaliSubSpese("codiceIvaSpeseRivalsa", codiceIvaSpeseRivalsa);
        mb.out("calcolaTotaliSub 5");
        this.totaleImponibilePreSconto = this.totaleImponibile;
        this.totaleIvatoPreSconto = this.totaleIvato;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            double imposta_indeducibile;
            double imposta_deducibile;
            double perc_sconto;
            d = this.dettagliIvaDedMap.get(ivakey);
            double scontoRipartito = 0.0;
            double nuovoImponibile = 0.0;
            double nuovoIvato = 0.0;
            if (!this.isPrezziIvati()) {
                if (passaggio == 1) {
                    scontoRipartito = this.sconto * d.getImponibile() / this.totaleImponibilePositivo;
                    this.proporzioniIvaSconto.put(ivakey, scontoRipartito);
                    if (this.totaleImponibilePositivo != 0.0) {
                        this.proporzioniIva.put(ivakey, 100.0 * d.getImponibile() / this.totaleImponibilePositivo);
                    } else {
                        this.proporzioniIva.put(ivakey, 0.0);
                    }
                } else {
                    scontoRipartito = this.proporzioniIvaSconto != null && d != null ? CastUtils.toDouble0((Object)this.proporzioniIvaSconto.get(ivakey)) : 0.0;
                }
                nuovoImponibile = !Double.isNaN(scontoRipartito) ? d.getImponibile() - scontoRipartito : d.getImponibile();
                perc_sconto = nuovoImponibile * 100.0 / d.getImponibile();
                if (perc_sconto == Double.NaN) {
                    perc_sconto = 0.0;
                }
                this.imposta_noarr = this.imposta = nuovoImponibile / 100.0 * d.getPercentuale();
                this.imposta = Util.round(this.imposta, 2);
                d.imponibile_noarr = nuovoImponibile;
                nuovoImponibile = Util.round(nuovoImponibile, 2);
                imposta_deducibile = Util.round(this.imposta / 100.0 * d.getPerc_deducibilita(), 2);
                imposta_indeducibile = Util.round(this.imposta - imposta_deducibile, 2);
                double nuovoImponibile_deducibile = Util.round(nuovoImponibile / 100.0 * d.getPerc_deducibilita(), 2);
                double nuovoImponibile_indeducibile = Util.round(nuovoImponibile + this.imposta - nuovoImponibile_deducibile - imposta_deducibile - imposta_indeducibile, 2);
                d.setImponibile(nuovoImponibile);
                d.setImponibile_deducibile(Util.round(nuovoImponibile_deducibile, 2));
                d.setImponibile_indeducibile(Util.round(nuovoImponibile_indeducibile, 2));
                d.setImposta(this.imposta);
                d.setImposta_deducibile(Util.round(imposta_deducibile, 2));
                d.setImposta_indeducibile(Util.round(imposta_indeducibile, 2));
                d.imposta_noarr = this.imposta_noarr;
                continue;
            }
            if (passaggio == 1) {
                scontoRipartito = this.sconto * d.getIvato() / this.totaleIvatoPositivo;
                this.proporzioniIvaSconto.put(ivakey, scontoRipartito);
                if (this.totaleIvatoPositivo != 0.0) {
                    this.proporzioniIva.put(ivakey, 100.0 * d.getIvato() / this.totaleIvatoPositivo);
                } else {
                    this.proporzioniIva.put(ivakey, 0.0);
                }
            } else {
                scontoRipartito = this.proporzioniIvaSconto != null && d != null ? CastUtils.toDouble0((Object)this.proporzioniIvaSconto.get(ivakey)) : 0.0;
            }
            nuovoIvato = !Double.isNaN(scontoRipartito) ? d.getIvato() - scontoRipartito : d.getIvato();
            perc_sconto = nuovoIvato * 100.0 / d.getIvato();
            this.imposta_noarr = this.imposta = nuovoIvato * d.getPercentuale() / (100.0 + d.getPercentuale());
            this.imposta = Util.round(this.imposta, 2);
            d.ivato_noarr = nuovoIvato;
            nuovoIvato = Util.round(nuovoIvato, 2);
            d.setImponibile(nuovoIvato - this.imposta);
            nuovoImponibile = nuovoIvato - this.imposta;
            imposta_deducibile = Util.round(this.imposta / 100.0 * d.getPerc_deducibilita(), 2);
            imposta_indeducibile = Util.round(this.imposta - imposta_deducibile, 2);
            double nuovoIvato_deducibile = Util.round(nuovoIvato / 100.0 * d.getPerc_deducibilita(), 2);
            double nuovoIvato_indeducibile = Util.round(nuovoIvato - nuovoIvato_deducibile, 2);
            double nuovoImponibile_deducibile = Util.round(nuovoImponibile / 100.0 * d.getPerc_deducibilita(), 2);
            double nuovoImponibile_indeducibile = Util.round(nuovoImponibile + this.imposta - nuovoImponibile_deducibile - imposta_deducibile - imposta_indeducibile, 2);
            d.setIvato(nuovoIvato);
            d.setImposta(this.imposta);
            d.setImposta_deducibile(Util.round(imposta_deducibile, 2));
            d.setImposta_indeducibile(Util.round(imposta_indeducibile, 2));
            d.setImponibile_deducibile(nuovoImponibile_deducibile);
            d.setImponibile_indeducibile(nuovoImponibile_indeducibile);
            d.setIvato_deducibile(nuovoIvato_deducibile);
            d.setIvato_indeducibile(nuovoIvato_indeducibile);
            d.imposta_noarr = this.imposta_noarr;
        }
        mb.out("calcolaTotaliSub 6");
        this.totaleImponibile = 0.0;
        this.totaleImponibilePositivo = 0.0;
        this.totaleIvato = 0.0;
        this.totaleIvatoPositivo = 0.0;
        this.totaleImposta = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            d = this.dettagliIvaDedMap.get(ivakey);
            this.totaleImponibile += d.getImponibile();
            this.totaleImponibilePositivo += d.getImponibile();
            this.totaleIvato += d.getIvato();
            this.totaleIvatoPositivo += d.getIvato();
            this.totaleImposta += d.getImposta();
        }
        this.totaleImponibile = Util.round(this.totaleImponibile, 2);
        this.totaleImponibilePositivo = Util.round(this.totaleImponibilePositivo, 2);
        this.totaleIvato = Util.round(this.totaleIvato, 2);
        this.totaleIvatoPositivo = Util.round(this.totaleIvatoPositivo, 2);
        this.totaleIva = this.totaleImposta = Util.round(this.totaleImposta, 2);
        this.totale = !this.isPrezziIvati() ? this.totaleImponibile + this.totaleImposta : this.totaleIvato;
        this.totaleSconti = this.totaleSconti;
        this.ritenuta_perc = 0.0;
        this.ritenuta_descrizione = "";
        this.totale_ritenuta = 0.0;
        this.totale_da_pagare = 0.0;
        this.totale_da_pagare_finale = 0.0;
        if (this.ritenuta > 0) {
            try {
                ResultSet r = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)("select * from tipi_ritenuta where id = " + this.ritenuta));
                if (r.next()) {
                    this.ritenuta_perc = r.getDouble("percentuale");
                    this.ritenuta_descrizione = r.getString("descrizione");
                    this.totale_ritenuta = Util.round(this.totaleImponibilePerRitenuta / 100.0 * this.ritenuta_perc, 2);
                    this.totale_da_pagare = this.totale - this.totale_ritenuta;
                    if (this.isSottrai_rivalsa()) {
                        this.totale_da_pagare -= this.totale_rivalsa;
                    }
                } else {
                    System.err.println("problema nel calcolo totale, manca ritenuta (" + this.ritenuta + ") in tabella");
                    this.totale_da_pagare = this.totale - this.totale_ritenuta;
                    if (this.isSottrai_rivalsa()) {
                        this.totale_da_pagare -= this.totale_rivalsa;
                    }
                }
                DbUtils.close((ResultSet)r);
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        } else {
            this.totale_da_pagare = this.totale;
            if (this.isSottrai_rivalsa()) {
                this.totale_da_pagare -= this.totale_rivalsa;
            }
        }
        mb.out("calcolaTotaliSub 7");
        Double speseBollo = cu.d(this.testa.get("marca_da_bollo"));
        if (passaggio > 1 && this.speseBolloSiNo) {
            speseBollo = cu.d0((Object)speseBollo);
            IvaDed codiceIvaBollo = new IvaDed("15", 100.0);
            Iva ivaBollo = new Iva();
            if (!ivaBollo.load(Db.INSTANCE, codiceIvaBollo.codice_iva)) {
                ivaBollo.setCodice(codiceIvaBollo.codice_iva);
                ivaBollo.setPercentuale(0.0);
                ivaBollo.setDescrizione("Escluso art. 15");
                ivaBollo.setDescrizioneBreve("Escluso art. 15");
            }
            DettaglioIva divabollo = null;
            if (this.dettagliIvaDedMap.containsKey(codiceIvaBollo)) {
                divabollo = this.dettagliIvaDedMap.get(codiceIvaBollo);
            } else {
                divabollo = new DettaglioIva();
                divabollo.setCodice(codiceIvaBollo.codice_iva);
                divabollo.setPerc_deducibilita(100.0);
                divabollo.setDescrizione(ivaBollo.getDescrizione());
                divabollo.setDescrizioneBreve(ivaBollo.getDescrizioneBreve());
                divabollo.setPercentuale(ivaBollo.getPercentuale());
            }
            double imposta = speseBollo / 100.0 * ivaBollo.getPercentuale();
            imposta = Util.round(imposta, 2);
            divabollo.setImponibile(cu.d0((Object)divabollo.getImponibile()) + speseBollo);
            divabollo.setImponibile_deducibile(cu.d0((Object)divabollo.getImponibile_deducibile()) + speseBollo);
            divabollo.setImposta(imposta);
            divabollo.setImposta_deducibile(cu.d0((Object)divabollo.getImposta_deducibile()) + imposta);
            divabollo.setIvato(divabollo.getIvato() + speseBollo + imposta);
            this.dettagliIvaDedMap.put(codiceIvaBollo, divabollo);
            this.totaleImponibile += speseBollo.doubleValue();
            this.totale += speseBollo + imposta;
            this.totaleIvato += speseBollo + imposta;
            this.totaleIva += imposta;
            this.totaleImposta += imposta;
            this.totale_da_pagare += speseBollo + imposta;
            this.totale_da_pagare_finale += speseBollo + imposta;
        }
        mb.out("calcolaTotaliSub 8");
        System.out.println("calcolo deds");
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d3 = this.dettagliIvaDedMap.get(ivakey);
            d3.setImponibile_deducibile(Util.round(d3.getImponibile() - d3.getImponibile_indeducibile(), 2));
            d3.setImposta_deducibile(Util.round(d3.getImposta() - d3.getImposta_indeducibile(), 2));
        }
        mb.out("calcolaTotaliSub 9");
        this.totale_da_pagare_finale = this.totale_da_pagare - this.acconto;
        if (split_payment) {
            this.totale_da_pagare_finale -= this.totaleImposta;
        }
    }

    private void calcolaTotaliSubSpese(String tipo, String iva_spese) {
        String codiceIvaSpese = "";
        codiceIvaSpese = iva_spese == null ? InvoicexUtil.getIvaSpesePerData(this.data, tipo) : iva_spese;
        Iva ivaSpese = new Iva();
        double spese = 0.0;
        if (tipo.equals("codiceIvaSpese")) {
            spese = cu.d0(this.testa.get("spese_trasporto"));
        } else if (tipo.equals("codiceIvaSpeseIncasso")) {
            spese = cu.d0(this.testa.get("spese_incasso"));
        }
        if (ivaSpese.load(Db.INSTANCE, codiceIvaSpese)) {
            boolean codiceIvaSpeseTrovato = false;
            this.speseImponibili = spese;
            this.speseIvate = spese;
            this.proporzioniIva.put(new IvaDed(ivaSpese.getCodice(), 100.0), 100.0);
            if (this.getRivalsa_inps_perc() != null && this.getRivalsa_inps_perc() != 0.0 && tipo.equals("codiceIvaSpeseRivalsa") && this.isIncludi_rivalsa_in_iva()) {
                this.speseImponibili += this.getTotale_rivalsa();
                this.speseIvate += this.getTotale_rivalsa() * ((ivaSpese.getPercentuale() + 100.0) / 100.0);
            }
            for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
                if (d.getCodice().equalsIgnoreCase(codiceIvaSpese) && d.getPerc_deducibilita() == 100.0) {
                    codiceIvaSpeseTrovato = true;
                    d.setImponibile(d.getImponibile() + spese);
                    d.setImponibile(Util.round(d.getImponibile(), 2));
                    d.setImponibile_deducibile(d.getImponibile_deducibile() + spese);
                    d.setIvato(d.getIvato() + spese);
                    d.setIvato(Util.round(d.getIvato(), 2));
                    d.setIvato_deducibile(d.getIvato_deducibile() + spese);
                    if (this.getRivalsa_inps_perc() != null && this.getRivalsa_inps_perc() != 0.0 && tipo.equals("codiceIvaSpeseRivalsa") && this.isIncludi_rivalsa_in_iva()) {
                        d.setImponibile(d.getImponibile() + this.getTotale_rivalsa());
                        d.setImponibile(Util.round(d.getImponibile(), 2));
                        d.setImponibile_deducibile(d.getImponibile_deducibile() + this.getTotale_rivalsa());
                        d.setIvato(d.getIvato() + (this.getTotale_rivalsa() + Util.round(this.getTotale_rivalsa() / 100.0 * d.getPercentuale(), 2)));
                        d.setIvato(Util.round(d.getIvato(), 2));
                        d.setIvato_deducibile(d.getIvato_deducibile() + (this.getTotale_rivalsa() + Util.round(this.getTotale_rivalsa() / 100.0 * d.getPercentuale(), 2)));
                    }
                }
                double imposta_deducibile = 0.0;
                double imposta_indeducibile = 0.0;
                if (!this.isPrezziIvati()) {
                    this.imposta_noarr = this.imposta = d.getImponibile() / 100.0 * d.getPercentuale();
                    this.imposta = Util.round(this.imposta, 2);
                } else {
                    this.imposta_noarr = this.imposta = d.getIvato() * d.getPercentuale() / (100.0 + d.getPercentuale());
                    this.imposta = Util.round(this.imposta, 2);
                }
                imposta_deducibile = Util.round(this.imposta / 100.0 * d.getPerc_deducibilita(), 2);
                imposta_indeducibile = Util.round(this.imposta - imposta_deducibile, 2);
                d.setImposta(this.imposta);
                d.imposta_noarr = this.imposta_noarr;
                d.setImposta_deducibile(imposta_deducibile);
                d.setImposta_indeducibile(imposta_indeducibile);
                if (!this.isPrezziIvati()) continue;
                d.setImponibile(d.getIvato() - d.getImposta());
                d.setImponibile_deducibile(d.getIvato_deducibile() - d.getImposta_deducibile());
                d.setImponibile_indeducibile(d.getIvato_indeducibile() - d.getImposta_indeducibile());
            }
            if (!codiceIvaSpeseTrovato) {
                DettaglioIva ds = new DettaglioIva();
                ds.setCodice(codiceIvaSpese);
                ds.setPercentuale(ivaSpese.getPercentuale());
                ds.setDescrizione(ivaSpese.getDescrizione());
                ds.setDescrizioneBreve(ivaSpese.getDescrizioneBreve());
                ds.setImponibile(spese);
                ds.setImponibile_deducibile(spese);
                ds.setIvato(spese);
                ds.setIvato_deducibile(spese);
                if (this.getRivalsa_inps_perc() != null && this.getRivalsa_inps_perc() != 0.0 && tipo.equals("codiceIvaSpeseRivalsa") && this.isIncludi_rivalsa_in_iva()) {
                    ds.setImponibile(ds.getImponibile() + this.getTotale_rivalsa());
                    ds.setImponibile(Util.round(ds.getImponibile(), 2));
                    ds.setImponibile_deducibile(ds.getImponibile_deducibile() + this.getTotale_rivalsa());
                    ds.setIvato(ds.getIvato() + (this.getTotale_rivalsa() + Util.round(this.getTotale_rivalsa() / 100.0 * ds.getPercentuale(), 2)));
                    ds.setIvato(Util.round(ds.getIvato(), 2));
                    ds.setIvato_deducibile(ds.getIvato_deducibile() + (this.getTotale_rivalsa() + Util.round(this.getTotale_rivalsa() / 100.0 * ds.getPercentuale(), 2)));
                }
                double imposta_deducibile = 0.0;
                double imposta_indeducibile = 0.0;
                if (!this.isPrezziIvati()) {
                    this.imposta_noarr = this.imposta = ds.getImponibile() / 100.0 * ivaSpese.getPercentuale();
                    this.imposta = Util.round(this.imposta, 2);
                    imposta_deducibile = Util.round(ds.getImponibile_deducibile() / 100.0 * ivaSpese.getPercentuale(), 2);
                } else {
                    this.imposta_noarr = this.imposta = ds.getIvato() * ivaSpese.getPercentuale() / (100.0 + ivaSpese.getPercentuale());
                    this.imposta = Util.round(this.imposta, 2);
                    imposta_deducibile = Util.round(ds.getIvato_deducibile() * ivaSpese.getPercentuale() / (100.0 + ivaSpese.getPercentuale()), 2);
                }
                ds.setImposta(this.imposta);
                ds.setImposta_deducibile(imposta_deducibile);
                ds.imposta_noarr = this.imposta_noarr;
                ds.setPercentuale(ivaSpese.getPercentuale());
                if (this.isPrezziIvati()) {
                    ds.setImponibile(ds.getIvato() - ds.getImposta());
                    ds.setImponibile_deducibile(ds.getIvato_deducibile() - ds.getImposta_deducibile());
                }
                if (ds.getImponibile() != 0.0) {
                    ds.setPerc_deducibilita(100.0);
                    this.dettagliIvaDedMap.put(new IvaDed(codiceIvaSpese, 100.0), ds);
                }
            }
            this.totaleImponibile = 0.0;
            this.totaleImponibilePositivo = 0.0;
            this.totaleIvato = 0.0;
            this.totaleIvatoPositivo = 0.0;
            this.totaleImposta = 0.0;
            for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
                this.totaleImponibile += d.getImponibile();
                this.totaleImponibilePositivo += d.getImponibile();
                this.totaleIvato += d.getIvato();
                this.totaleIvatoPositivo += d.getIvato();
                this.totaleImposta += d.getImposta();
            }
        } else {
            DettaglioIva d;
            this.speseImponibili = spese;
            this.speseIvate = spese;
            if (this.getRivalsa_inps_perc() != null && this.getRivalsa_inps_perc() != 0.0 && tipo.equals("codiceIvaSpeseRivalsa") && this.isIncludi_rivalsa_in_iva()) {
                DettaglioIva d2;
                boolean trovata_iva_std = false;
                double iva_std = 22.0;
                if (this.data != null && this.data.before(DateUtils.getOnlyDate((int)2011, (int)9, (int)17))) {
                    iva_std = 20.0;
                } else if (this.data != null && this.data.before(DateUtils.getOnlyDate((int)2013, (int)10, (int)1))) {
                    iva_std = 21.0;
                }
                for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                    d2 = this.dettagliIvaDedMap.get(ivakey);
                    if (d2.getPercentuale() != iva_std) continue;
                    trovata_iva_std = true;
                    break;
                }
                if (trovata_iva_std) {
                    for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                        d2 = this.dettagliIvaDedMap.get(ivakey);
                        if (d2.getPercentuale() != iva_std) continue;
                        d2.setImponibile(d2.getImponibile() + this.getTotale_rivalsa());
                        this.imposta_noarr = this.imposta = d2.getImponibile() / 100.0 * d2.getPercentuale();
                        this.imposta = Util.round(this.imposta, 2);
                        double imposta_deducibile = Util.round(d2.getImponibile_deducibile() / 100.0 * d2.getPercentuale(), 2);
                        d2.setImposta(this.imposta);
                        d2.setImponibile_deducibile(imposta_deducibile);
                        d2.setIvato(d2.getImponibile() + this.imposta);
                        d2.setIvato_deducibile(d2.getImponibile_deducibile() + imposta_deducibile);
                        break;
                    }
                } else if (!this.isPrezziIvati()) {
                    this.speseImponibili += this.getTotale_rivalsa();
                } else {
                    this.speseIvate += this.getTotale_rivalsa() * this.getIvaMedia(this.dettagliIvaDedMap);
                }
            }
            this.totaleImponibile = 0.0;
            this.totaleImponibilePositivo = 0.0;
            this.totaleIvato = 0.0;
            this.totaleIvatoPositivo = 0.0;
            this.totaleImposta = 0.0;
            for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                DettaglioIva d3 = this.dettagliIvaDedMap.get(ivakey);
                this.totaleImponibile += d3.getImponibile();
                this.totaleImponibilePositivo += d3.getImponibile();
                this.totaleIvato += d3.getIvato();
                this.totaleIvatoPositivo += d3.getIvato();
                this.totaleImposta += d3.getImposta();
            }
            Map<String, DettaglioIva> dettagliIvaMap = this.getDettagliIvaMap(this.dettagliIvaDedMap);
            for (String ivakeycodice : this.getDettagliIvaMap(this.dettagliIvaDedMap).keySet()) {
                DettaglioIva d2;
                d = dettagliIvaMap.get(ivakeycodice);
                double importoSpeseRipartito = 0.0;
                double nuovoImponibile = 0.0;
                double nuovoIvato = 0.0;
                if (!this.isPrezziIvati()) {
                    importoSpeseRipartito = this.speseImponibili * d.getImponibile() / this.totaleImponibilePositivo;
                    d2 = this.getDetIva(ivakeycodice, 100.0);
                    if (d2 == null) {
                        d2 = new DettaglioIva();
                        d2.setCodice(ivakeycodice);
                        d2.setDescrizione(d.getDescrizione());
                        d2.setDescrizioneBreve(d.getDescrizioneBreve());
                        d2.setPercentuale(d.getPercentuale());
                        d2.setPerc_deducibilita(100.0);
                    }
                    nuovoImponibile = !Double.isNaN(importoSpeseRipartito) ? cu.d0((Object)d2.getImponibile()) + importoSpeseRipartito : cu.d0((Object)d2.getImponibile());
                    this.imposta_noarr = this.imposta = nuovoImponibile / 100.0 * d.getPercentuale();
                    this.imposta = Util.round(this.imposta, 2);
                    d2.imponibile_noarr = nuovoImponibile;
                    nuovoImponibile = Util.round(nuovoImponibile, 2);
                    d2.setImponibile(nuovoImponibile);
                    d2.setImposta(this.imposta);
                    d2.imposta_noarr = this.imposta_noarr;
                    this.dettagliIvaDedMap.put(new IvaDed(ivakeycodice, 100.0), d2);
                    continue;
                }
                importoSpeseRipartito = this.speseIvate * d.getIvato() / this.totaleIvatoPositivo;
                d2 = this.getDetIva(ivakeycodice, 100.0);
                if (d2 == null) {
                    d2 = new DettaglioIva();
                    d2.setCodice(ivakeycodice);
                    d2.setDescrizione(d.getDescrizione());
                    d2.setDescrizioneBreve(d.getDescrizioneBreve());
                    d2.setPercentuale(d.getPercentuale());
                    d2.setPerc_deducibilita(100.0);
                }
                nuovoIvato = !Double.isNaN(importoSpeseRipartito) ? d2.getIvato() + importoSpeseRipartito : d2.getIvato();
                this.imposta_noarr = this.imposta = nuovoIvato * d.getPercentuale() / (100.0 + d.getPercentuale());
                this.imposta = Util.round(this.imposta, 2);
                d2.ivato_noarr = nuovoIvato;
                nuovoIvato = Util.round(nuovoIvato, 2);
                d2.setIvato(nuovoIvato);
                d2.setImposta(this.imposta);
                d2.setImponibile(nuovoIvato - this.imposta);
                d2.imposta_noarr = this.imposta_noarr;
                this.dettagliIvaDedMap.put(new IvaDed(ivakeycodice, 100.0), d2);
            }
            this.totaleImponibile = 0.0;
            this.totaleImponibilePositivo = 0.0;
            this.totaleIvato = 0.0;
            this.totaleIvatoPositivo = 0.0;
            this.totaleImposta = 0.0;
            for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                d = this.dettagliIvaDedMap.get(ivakey);
                this.totaleImponibile += d.getImponibile();
                this.totaleImponibilePositivo += d.getImponibile();
                this.totaleIvato += d.getIvato();
                this.totaleIvatoPositivo += d.getIvato();
                this.totaleImposta += d.getImposta();
            }
        }
    }

    public double getImpIvaNonDeducibile() {
        double ret = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            ret += d.getImposta_indeducibile();
        }
        return ret;
    }

    public double getImpNonDeducibile() throws SQLException, Exception {
        double ret = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            ret += d.getImponibile_indeducibile();
        }
        return ret;
    }

    public double getImpIvaDeducibile(String codiceIva) {
        double ret = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            if (!d.getCodice().equalsIgnoreCase(codiceIva)) continue;
            ret += d.getImponibile_deducibile();
        }
        return ret;
    }

    public double getIvaDeducibile(String codiceIva) {
        double ret = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            if (!d.getCodice().equalsIgnoreCase(codiceIva)) continue;
            ret += d.getImposta_deducibile();
        }
        return ret;
    }

    public double getImpIva(String codiceIva) {
        double ret = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            if (!d.getCodice().equalsIgnoreCase(codiceIva)) continue;
            ret += d.getImponibile();
        }
        return ret;
    }

    public double getIva(String codiceIva) {
        double ret = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            if (!d.getCodice().equalsIgnoreCase(codiceIva)) continue;
            ret += d.getImposta();
        }
        return ret;
    }

    public void visualizzaCastellettoIva() {
        String temp = "Castelletto Iva\n";
        temp = temp + "codice\t percentuale\t imponibile\t imposta\t\t\t imponibile_noarr\t imposta_noarr\n";
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            temp = temp + d.getCodice();
            temp = temp + "\t" + d.getPercentuale() + " (ded.:" + d.getPerc_deducibilita() + ")";
            temp = temp + "\t" + d.getImponibile();
            temp = temp + "\t" + d.getImposta();
            temp = temp + "\t\t\t" + d.imponibile_noarr;
            temp = temp + "\t" + d.imposta_noarr;
            temp = temp + "\n";
        }
        temp = temp + "totaleiva " + this.totaleIva;
        temp = temp + "\t totaleimp " + this.totaleImponibile;
        temp = temp + "\t totale    " + this.totale;
        temp = temp + "\n";
        System.out.println(temp);
    }

    public String dumpCastellettoIva() {
        String temp = "Castelletto Iva\n";
        temp = temp + "codice\tdescrizione\tpercentuale\timponibile\timposta\t\t\timponibile_noarr\timposta_noarr\n";
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            temp = temp + d.getCodice();
            temp = temp + "\t" + d.getDescrizione();
            temp = temp + "\t" + d.getPercentuale() + " (ded.:" + d.getPerc_deducibilita() + ")";
            temp = temp + "\t" + d.getImponibile();
            temp = temp + "\t" + d.getImposta();
            temp = temp + "\t\t\t" + d.imponibile_noarr;
            temp = temp + "\t" + d.imposta_noarr;
            temp = temp + "\n";
        }
        temp = temp + "totaleiva " + this.totaleIva;
        temp = temp + "\t totaleimp " + this.totaleImponibile;
        temp = temp + "\t totale    " + this.totale;
        temp = temp + "\n";
        return temp;
    }

    public double getTotaleSconti() {
        return this.totaleSconti;
    }

    public void setTotaleSconti(double totaleSconti) {
        this.totaleSconti = totaleSconti;
    }

    public double getTotale() {
        return this.totale;
    }

    public void setTotale(double totale) {
        this.totale = totale;
    }

    public double getTotaleQuantita() {
        return this.totaleQuantita;
    }

    public double getTotaleIva() {
        return this.totaleIva;
    }

    public void setTotaleIva(double totaleIva) {
        this.totaleIva = totaleIva;
    }

    public double getTotaleImponibile() {
        return this.totaleImponibile;
    }

    public void setTotaleImponibile(double totaleImponibile) {
        this.totaleImponibile = totaleImponibile;
    }

    public long getCodiceCliente() {
        return this.codiceCliente;
    }

    public void setCodiceCliente(long codiceCliente) {
        this.codiceCliente = codiceCliente;
    }

    public void setCodiceFornitore(long codiceFornitore) {
        this.codiceFornitore = codiceFornitore;
    }

    public int getRitenuta() {
        return this.ritenuta;
    }

    public void setRitenuta(int ritenuta) {
        this.ritenuta = ritenuta;
    }

    public double getTotale_ritenuta() {
        return this.totale_ritenuta;
    }

    public void setTotale_ritenuta(double totale_ritenuta) {
        this.totale_ritenuta = totale_ritenuta;
    }

    public double getTotale_da_pagare() {
        return this.totale_da_pagare;
    }

    public void setTotale_da_pagare(double totale_da_pagare) {
        this.totale_da_pagare = totale_da_pagare;
    }

    public double getTotale_da_pagare_finale() {
        return this.totale_da_pagare_finale;
    }

    public void setTotale_da_pagare_finale(double totale_da_pagare_finale) {
        this.totale_da_pagare_finale = totale_da_pagare_finale;
    }

    public double getAcconto() {
        return this.acconto;
    }

    public void setAcconto(double acconto) {
        this.acconto = acconto;
    }

    public double getRitenuta_perc() {
        return this.ritenuta_perc;
    }

    public void setRitenuta_perc(double ritenuta_perc) {
        this.ritenuta_perc = ritenuta_perc;
    }

    public String getRitenuta_descrizione() {
        return this.ritenuta_descrizione;
    }

    public void setRitenuta_descrizione(String ritenuta_descrizione) {
        this.ritenuta_descrizione = ritenuta_descrizione;
    }

    public boolean isRivalsa_inps() {
        return this.rivalsa_inps;
    }

    public void setRivalsa_inps(boolean rivalsa_inps) {
        this.rivalsa_inps = rivalsa_inps;
    }

    public void setRivalsaCodice(Integer codRivalsa) {
        if (!codRivalsa.equals("")) {
            this.rivalsa_codice = codRivalsa;
        }
    }

    public double getTotale_rivalsa() {
        double massimale = 0.0;
        if (this.rivalsa_codice != null && this.rivalsa_codice != -1) {
            try {
                massimale = CastUtils.toDouble0((Object)DbUtils.getObject((Connection)Db.getConn(), (String)("SELECT massimale FROM tipi_rivalsa WHERE id = " + Db.pc(this.rivalsa_codice, 4))));
            }
            catch (Exception ex) {
                massimale = 0.0;
            }
            if (massimale != 0.0 && massimale < this.totale_rivalsa) {
                return massimale;
            }
        }
        return this.totale_rivalsa;
    }

    public void setTotale_rivalsa(double totale_rivalsa) {
        this.totale_rivalsa = totale_rivalsa;
        double massimale = 0.0;
        if (this.rivalsa_codice != null && this.rivalsa_codice != -1) {
            try {
                massimale = CastUtils.toDouble0((Object)DbUtils.getObject((Connection)Db.getConn(), (String)("SELECT massimale FROM tipi_rivalsa WHERE id = " + Db.pc(this.rivalsa_codice, 4))));
            }
            catch (Exception ex) {
                massimale = 0.0;
            }
            if (massimale != 0.0 && massimale < totale_rivalsa) {
                this.totale_rivalsa = massimale;
            }
        }
    }

    public double getTotale_imponibile2() {
        return this.totale_imponibile2;
    }

    public void setTotale_imponibile2(double totale_imponibile2) {
        this.totale_imponibile2 = totale_imponibile2;
    }

    public double getTotaleImponibileParziale() {
        return this.totaleImponibileParziale;
    }

    public void setTotaleImponibileParziale(double totaleImponibileParziale) {
        this.totaleImponibileParziale = totaleImponibileParziale;
    }

    public Double getRivalsa_inps_perc() {
        return this.rivalsa_inps_perc;
    }

    public void setRivalsa_inps_perc(Double rivalsa_inps_perc) {
        this.rivalsa_inps_perc = rivalsa_inps_perc;
    }

    public String getRivalsa_inps_descrizione() {
        return this.rivalsa_inps_descrizione;
    }

    public void setRivalsa_inps_descrizione(String rivalsa_inps_descrizione) {
        this.rivalsa_inps_descrizione = rivalsa_inps_descrizione;
    }

    public void setData(Date date) {
        this.data = date;
    }

    public boolean isPrezziIvati() {
        return this.prezziIvati;
    }

    public void setPrezziIvati(boolean prezziIvati) {
        this.prezziIvati = prezziIvati;
    }

    public double getTotaleIvatoParziale() {
        return this.totaleIvatoParziale;
    }

    public void setTotaleIvatoParziale(double totaleIvatoParziale) {
        this.totaleIvatoParziale = totaleIvatoParziale;
    }

    public double getTotaleIvato() {
        return this.totaleIvato;
    }

    public void setTotaleIvato(double totaleIvato) {
        this.totaleIvato = totaleIvato;
    }

    public double getSconto() {
        return this.sconto;
    }

    public void setSconto(double sconto) {
        this.sconto = sconto;
    }

    public double getTotaleImponibilePerRivalsa() {
        return this.totaleImponibilePerRivalsa;
    }

    public void setTotaleImponibilePerRivalsa(double totaleImponibilePerRivalsa) {
        this.totaleImponibilePerRivalsa = totaleImponibilePerRivalsa;
    }

    public double getTotaleImponibilePerRitenuta() {
        return this.totaleImponibilePerRitenuta;
    }

    private Map<String, DettaglioIva> getDettagliIvaMap(Map<IvaDed, DettaglioIva> dettagliIvaDedMap) {
        LinkedHashMap<String, DettaglioIva> dettagliIvaMap = new LinkedHashMap<String, DettaglioIva>();
        for (IvaDed key : dettagliIvaDedMap.keySet()) {
            DettaglioIva dsorg = dettagliIvaDedMap.get(key);
            if (!dettagliIvaMap.containsKey(key.codice_iva.toUpperCase())) {
                dettagliIvaMap.put(key.codice_iva.toUpperCase(), new DettaglioIva());
            }
            DettaglioIva ddest = (DettaglioIva)dettagliIvaMap.get(key.codice_iva.toUpperCase());
            ddest.setImponibile(cu.d0((Object)ddest.getImponibile()) + cu.d0((Object)dsorg.getImponibile()));
            ddest.setIvato(cu.d0((Object)ddest.getIvato()) + cu.d0((Object)dsorg.getIvato()));
            ddest.setImposta(cu.d0((Object)ddest.getImposta()) + cu.d0((Object)dsorg.getImposta()));
            ddest.setCodice(dsorg.getCodice());
            ddest.setDescrizione(dsorg.getDescrizione());
            ddest.setDescrizioneBreve(dsorg.getDescrizioneBreve());
            ddest.setPercentuale(dsorg.getPercentuale());
        }
        return dettagliIvaMap;
    }

    private DettaglioIva getDetIva(String codice_iva, double perc_ded) {
        for (IvaDed key : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva dsorg = this.dettagliIvaDedMap.get(key);
            if (!dsorg.getCodice().equalsIgnoreCase(codice_iva) || dsorg.getPerc_deducibilita() != perc_ded) continue;
            return dsorg;
        }
        return null;
    }

    public void setParametriArrotondamento(String arrotondamentoParametro, String arrotondamentoTipo) {
        this.parametroArrotondamento = cu.d0((Object)arrotondamentoParametro);
        this.perDifetto = arrotondamentoTipo.equals("Inf.");
    }

    private double getIvaMedia(Map<IvaDed, DettaglioIva> dettagliIvaDedMap) {
        Iterator<IvaDed> ivaiter = dettagliIvaDedMap.keySet().iterator();
        double totaleImponibile = 0.0;
        double totaleIvato = 0.0;
        while (ivaiter.hasNext()) {
            IvaDed ivakey = ivaiter.next();
            DettaglioIva d = dettagliIvaDedMap.get(ivakey);
            totaleImponibile += d.getImponibile();
            totaleIvato += d.getIvato();
        }
        double percmedia = totaleIvato / totaleImponibile;
        return percmedia;
    }

    private double getQta(Object qta) {
        java.util.Date data = cu.toDate(this.testa.get("data"));
        if (InvoicexUtil.isZeroComeUno(data)) {
            if (cu.d0((Object)qta) == 0.0) {
                return 1.0;
            }
            return cu.d0((Object)qta);
        }
        return cu.d0((Object)qta);
    }
}

