/*
 * Decompiled with CFR 0.152.
 */
package gestioneFatture.magazzino;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.FastReportBuilder;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.builders.StyleBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import gestioneFatture.ArticoloHint;
import gestioneFatture.ClienteHint;
import gestioneFatture.Util;
import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.commons.CastUtils;
import it.tnx.commons.DateUtils;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.KeyValuePair;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.commons.swing.DelayedExecutor;
import it.tnx.commons.table.RendererUtils;
import it.tnx.dbeans.pdfPrint.PrintSimpleTable;
import it.tnx.invoicex.InvoicexUtil;
import it.tnx.invoicex.Magazzino;
import it.tnx.invoicex.data.Giacenza;
import it.tnx.invoicex.iu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingworker.SwingWorker;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.PatternFilter;
import tnxbeans.tnxComboField;
import util.BeanAdapterTableModel;

public class JInternalFrameGiacenze
extends JInternalFrame {
    private boolean matricola;
    private boolean lotti;
    public Integer fornitore = null;
    boolean flagPrimo = true;
    private Object listino;
    AtomicReference<ArticoloHint> articolo_selezionato_filtro_ref = new AtomicReference<Object>(null);
    AtomicReference<ClienteHint> fornitore_selezionato_filtro_ref = new AtomicReference<Object>(null);
    DelayedExecutor delay_filtro = new DelayedExecutor(new Runnable(){

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JInternalFrameGiacenze.this.aggiorna();
                }
            });
        }
    }, 250L);
    private boolean loading = true;
    private JButton butRefresh;
    public tnxComboField categoria;
    private JComboBox comPrezzi;
    private JComboBox deposito;
    private JButton esporta;
    private JCheckBox giacenza_zero;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;
    private JXDatePicker jXDatePicker1;
    private JLabel labTotali;
    public JLabel lab_categoria;
    public JLabel lab_sottocategoria;
    private JComboBox ordine;
    public JLabel segna_posto_fornitore;
    public tnxComboField sottocategoria;
    private JButton stampa;
    public JTable tabGiacenze;
    private JTextField texArticolo;
    private JTextField texFornitore;

    public JInternalFrameGiacenze(boolean matricola) {
        this(matricola, false);
    }

    public JInternalFrameGiacenze(boolean matricola, boolean lotti) {
        this.initComponents();
        this.tabGiacenze.setShowGrid(false);
        this.tabGiacenze.setShowHorizontalLines(true);
        this.texArticolo.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                JInternalFrameGiacenze.this.filtra();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JInternalFrameGiacenze.this.filtra();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                JInternalFrameGiacenze.this.filtra();
            }
        });
        InvoicexUtil.getArticoloIntelliHints(this.texArticolo, this, this.articolo_selezionato_filtro_ref, this.delay_filtro, null);
        InvoicexUtil.getFornitoriIntelliHints(this.texFornitore, this, this.fornitore_selezionato_filtro_ref, this.delay_filtro, null);
        this.jXDatePicker1.setFormats(new DateFormat[]{new SimpleDateFormat("dd/MM/yyyy")});
        this.matricola = matricola;
        this.lotti = lotti;
        this.categoria.dbAddElement("", null);
        this.categoria.dbOpenList(Db.getConn(), "select categoria, id from categorie_articoli order by categoria", null, false);
        this.sottocategoria.dbClearList();
        this.ordine.setSelectedItem(main.fileIni.getValue("pref", "stampa_giacenze_ordine"));
        this.categoria.setSelectedItem(main.fileIni.getValue("pref", "stampa_giacenze_filtro_cat"));
        this.sottocategoria.setSelectedItem(main.fileIni.getValue("pref", "stampa_giacenze_filtro_sottocat"));
        this.loading = false;
        InvoicexUtil.fireEvent(this, 59, new Object[0]);
    }

    public void initFilters() {
        KeyValuePair kv = new KeyValuePair((Object)"null", (Object)"<non stampare prezzi>");
        KeyValuePair kv1 = new KeyValuePair((Object)"***EL1***", (Object)"<ultimo prezzo lordo vendita>");
        KeyValuePair kv2 = new KeyValuePair((Object)"***EL2***", (Object)"<ultimo prezzo lordo acquisto>");
        KeyValuePair kv3 = new KeyValuePair((Object)"***EL3***", (Object)"<ultimo prezzo netto vendita>");
        KeyValuePair kv4 = new KeyValuePair((Object)"***EL4***", (Object)"<ultimo prezzo netto acquisto>");
        KeyValuePair kv5 = new KeyValuePair((Object)"***EL5***", (Object)"<costo netto medio>");
        SwingUtils.initJComboFromDb((JComboBox)this.comPrezzi, (Connection)Db.getConn(), (String)"select codice, descrizione from tipi_listino order by codice", (String)"codice", (String)"descrizione", (KeyValuePair[])new KeyValuePair[]{kv, kv1, kv3, kv2, kv4, kv5});
        KeyValuePair kvd1 = new KeyValuePair((Object)Magazzino.Depositi.TUTTI_RIEPILOGATIVO, (Object)"<tutti i depositi riepilogativo>");
        KeyValuePair kvd2 = new KeyValuePair((Object)Magazzino.Depositi.TUTTI_DETTAGLIO, (Object)"<tutti i depositi con dettaglio>");
        SwingUtils.initJComboFromDb((JComboBox)this.deposito, (Connection)Db.getConn(), (String)"select id, nome from depositi order by nome", (String)"id", (String)"nome", (KeyValuePair[])new KeyValuePair[]{kvd1, kvd2});
        try {
            this.deposito.setSelectedIndex(cu.i((Object)main.fileIni.getValue("pref", "stampa_giacenze_deposito")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.comPrezzi.setSelectedIndex(cu.i((Object)main.fileIni.getValue("pref", "stampa_giacenze_prezzi")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.giacenza_zero.setSelected(main.fileIni.getValueBoolean("pref", "stampa_giacenze_zero", true));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tabGiacenze = new JXTable();
        this.stampa = new JButton();
        this.lab_sottocategoria = new JLabel();
        this.sottocategoria = new tnxComboField();
        this.esporta = new JButton();
        this.labTotali = new JLabel();
        this.segna_posto_fornitore = new JLabel();
        this.jLabel3 = new JLabel();
        this.jXDatePicker1 = new JXDatePicker();
        this.jLabel4 = new JLabel();
        this.butRefresh = new JButton();
        this.jLabel5 = new JLabel();
        this.deposito = new JComboBox();
        this.jLabel2 = new JLabel();
        this.comPrezzi = new JComboBox();
        this.giacenza_zero = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.texArticolo = new JTextField();
        this.jLabel6 = new JLabel();
        this.texFornitore = new JTextField();
        this.jLabel7 = new JLabel();
        this.ordine = new JComboBox();
        this.lab_categoria = new JLabel();
        this.categoria = new tnxComboField();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Giacenze");
        this.tabGiacenze.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.tabGiacenze);
        this.stampa.setIcon(iu.getIcon("stampa"));
        this.stampa.setText("Stampa");
        this.stampa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JInternalFrameGiacenze.this.stampaActionPerformed(evt);
            }
        });
        this.lab_sottocategoria.setText("Sotto categoria");
        this.sottocategoria.setEditable(false);
        this.sottocategoria.setDbDescCampo("");
        this.sottocategoria.setDbNomeCampo("sottocategoria");
        this.sottocategoria.setDbNullSeVuoto(true);
        this.sottocategoria.setDbRiempire(false);
        this.sottocategoria.setDbTipoCampo("");
        this.sottocategoria.setDbTrovaMentreScrive(true);
        this.sottocategoria.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JInternalFrameGiacenze.this.sottocategoriaItemStateChanged(evt);
            }
        });
        this.sottocategoria.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                JInternalFrameGiacenze.this.sottocategoriaPopupMenuWillBecomeVisible(evt);
            }
        });
        this.esporta.setIcon(iu.getIcon("XLS"));
        this.esporta.setText("Esporta in Excel");
        this.esporta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JInternalFrameGiacenze.this.esportaActionPerformed(evt);
            }
        });
        this.labTotali.setHorizontalAlignment(4);
        this.labTotali.setText("...");
        this.labTotali.setHorizontalTextPosition(4);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Data");
        this.jXDatePicker1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JInternalFrameGiacenze.this.jXDatePicker1ActionPerformed(evt);
            }
        });
        this.jLabel4.setFont(this.jLabel4.getFont().deriveFont((float)this.jLabel4.getFont().getSize() - 1.0f));
        this.jLabel4.setText("la giacenza verr\u00e0 calcolata alla data specificata");
        this.butRefresh.setFont(new java.awt.Font("Dialog", 0, 10));
        this.butRefresh.setIcon(iu.getIcon("refresh"));
        this.butRefresh.setToolTipText("Aggiorna l'elenco");
        this.butRefresh.setIconTextGap(2);
        this.butRefresh.setMargin(new Insets(2, 2, 2, 2));
        this.butRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JInternalFrameGiacenze.this.butRefreshActionPerformed(evt);
            }
        });
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Deposito");
        this.deposito.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JInternalFrameGiacenze.this.depositoActionPerformed(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Prezzo");
        this.comPrezzi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JInternalFrameGiacenze.this.comPrezziActionPerformed(evt);
            }
        });
        this.giacenza_zero.setSelected(true);
        this.giacenza_zero.setText("Comprendi giacenza a zero");
        this.giacenza_zero.setToolTipText("Selezionandolo verranno visualizzati anche gli articoli con giacenza uguale a zero");
        this.giacenza_zero.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JInternalFrameGiacenze.this.giacenza_zeroActionPerformed(evt);
            }
        });
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Filtra per articolo");
        this.texArticolo.setColumns(30);
        this.texArticolo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JInternalFrameGiacenze.this.texArticoloActionPerformed(evt);
            }
        });
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText("Fornitore abituale");
        this.texFornitore.setColumns(30);
        this.texFornitore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JInternalFrameGiacenze.this.texFornitoreActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Ordina per");
        this.ordine.setModel(new DefaultComboBoxModel<String>(new String[]{"Codice articolo", "Descrizione articolo", "Categoria, Sottocategoria Articolo, Codice articolo", "Categoria, Sottocategoria Articolo, Descrizione", "Giacenza crescente", "Giacenza decrescente"}));
        this.ordine.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JInternalFrameGiacenze.this.ordineItemStateChanged(evt);
            }
        });
        this.lab_categoria.setHorizontalAlignment(4);
        this.lab_categoria.setText("Categoria articoli");
        this.categoria.setEditable(false);
        this.categoria.setDbDescCampo("");
        this.categoria.setDbNomeCampo("categoria");
        this.categoria.setDbNullSeVuoto(true);
        this.categoria.setDbTipoCampo("");
        this.categoria.setDbTrovaMentreScrive(true);
        this.categoria.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JInternalFrameGiacenze.this.categoriaItemStateChanged(evt);
            }
        });
        this.categoria.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                JInternalFrameGiacenze.this.categoriaPopupMenuWillBecomeVisible(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((java.awt.LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).add(14, 14, 14).add((Component)this.jXDatePicker1, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel4).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.butRefresh)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.esporta).addPreferredGap(0).add((Component)this.stampa)).add((Component)this.labTotali, -1, -1, Short.MAX_VALUE).add((Component)this.segna_posto_fornitore, -1, -1, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 527, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.comPrezzi, -2, -1, -2).add(18, 18, 18).add((Component)this.jLabel1, -2, 83, -2).addPreferredGap(0).add((Component)this.texArticolo)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.deposito, -2, -1, -2).add(18, 18, 18).add((Component)this.jLabel6).addPreferredGap(0).add((Component)this.texFornitore)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.giacenza_zero).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel7).addPreferredGap(0).add((Component)this.ordine, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lab_categoria).add((Component)this.lab_sottocategoria)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.sottocategoria, -2, -1, -2).add((Component)this.categoria, -2, 150, -2)))).add(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        layout.linkSize(new Component[]{this.jLabel2, this.jLabel3, this.jLabel5}, 1);
        layout.linkSize(new Component[]{this.jLabel1, this.jLabel6}, 1);
        layout.linkSize(new Component[]{this.comPrezzi, this.deposito}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(14, 14, 14).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jXDatePicker1, -2, -1, -2).add((Component)this.jLabel3).add((Component)this.jLabel4)).add((Component)this.butRefresh)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.deposito, -2, -1, -2).add((Component)this.texFornitore, -2, -1, -2).add((Component)this.jLabel6)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.comPrezzi, -2, -1, -2).add((Component)this.texArticolo, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lab_categoria).add((Component)this.categoria, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.sottocategoria, -2, -1, -2).add((Component)this.lab_sottocategoria)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.ordine, -2, -1, -2)).addPreferredGap(0).add((Component)this.giacenza_zero).addPreferredGap(0).add((Component)this.segna_posto_fornitore).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 249, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.labTotali).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.esporta).add((Component)this.stampa)).addContainerGap()));
        this.pack();
    }

    public void filtra() {
        System.out.println("articolo_selezionato_filtro_ref.get(): " + this.articolo_selezionato_filtro_ref.get());
        if (this.texArticolo.getText().length() > 0 && this.articolo_selezionato_filtro_ref.get() == null) {
            System.out.println("Pattern.quote(texArticolo.getText()): " + Pattern.quote(this.texArticolo.getText()));
            Filter[] filterArray = new Filter[]{new PatternFilter("(.*" + Pattern.quote(this.texArticolo.getText()) + ".*)", 2, 0)};
            FilterPipeline filters = new FilterPipeline(filterArray);
            ((JXTable)this.tabGiacenze).setFilters(filters);
        } else {
            ((JXTable)this.tabGiacenze).setFilters(null);
        }
        this.aggiornaTotali();
    }

    private void stampaActionPerformed(ActionEvent evt) {
        SwingUtils.mouse_wait((Component)this);
        this.salva();
        boolean group = true;
        if (!cu.s((Object)this.ordine.getSelectedItem()).startsWith("Categoria")) {
            group = false;
        }
        try {
            BeanAdapterTableModel model = (BeanAdapterTableModel)this.tabGiacenze.getModel();
            ArrayList newbeans = new ArrayList();
            for (int i = 0; i < this.tabGiacenze.getRowCount(); ++i) {
                int mi = ((JXTable)this.tabGiacenze).convertRowIndexToModel(i);
                Object o = model.getBeans().get(mi);
                if (!o.getClass().getName().equalsIgnoreCase("it.tnx.invoicex.data.Giacenza")) continue;
                newbeans.add(o);
            }
            FastReportBuilder drb = new FastReportBuilder();
            Style giacStyle = new Style();
            giacStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
            Style groupVariables = new Style("groupVariables");
            groupVariables.setFont(Font.ARIAL_BIG_BOLD);
            groupVariables.setBorderTop(Border.THIN);
            groupVariables.setHorizontalAlign(HorizontalAlign.LEFT);
            groupVariables.setBackgroundColor(Color.LIGHT_GRAY);
            Style groupVariablesSottocat = new Style("groupVariablesSottocat");
            groupVariablesSottocat.setFont(Font.ARIAL_MEDIUM_BOLD);
            groupVariablesSottocat.setPaddingLeft(10);
            groupVariablesSottocat.setHorizontalAlign(HorizontalAlign.LEFT);
            groupVariablesSottocat.setBackgroundColor(Color.LIGHT_GRAY);
            AbstractColumn colCategoria = ColumnBuilder.getNew().setColumnProperty("categoria", String.class.getName()).setTitle("Categoria").setStyle(groupVariables).build();
            AbstractColumn colSottocategoria = ColumnBuilder.getNew().setColumnProperty("sottocategoria", String.class.getName()).setTitle("Sottocategoria").setStyle(groupVariablesSottocat).build();
            AbstractColumn colArticolo = ColumnBuilder.getNew().setColumnProperty("codice_articolo", String.class.getName()).setTitle("Articolo").setWidth(18).build();
            AbstractColumn colUm = ColumnBuilder.getNew().setColumnProperty("um", String.class.getName()).setTitle("u.m.").setWidth(6).build();
            AbstractColumn colGiacenza = ColumnBuilder.getNew().setColumnProperty("giacenza", Double.class.getName()).setTitle("Giacenza").setWidth(18).setPattern("0.###").setStyle(giacStyle).build();
            AbstractColumn colValore = ColumnBuilder.getNew().setColumnProperty("prezzo", Double.class.getName()).setTitle("Valore").setWidth(20).setPattern("\u20ac #,##0.00###").setStyle(giacStyle).build();
            AbstractColumn colValoreTot = ColumnBuilder.getNew().setTitle("Valore totale").setWidth(20).setPattern("\u20ac #,##0.00").setStyle(giacStyle).setCustomExpression(new CustomExpression(){

                @Override
                public Object evaluate(Map fields, Map variables, Map parameters) {
                    double prezzo = cu.d0(fields.get("prezzo"));
                    double giac = cu.d0(fields.get("giacenza"));
                    return prezzo * giac;
                }

                @Override
                public String getClassName() {
                    return Double.class.getName();
                }
            }).build();
            DJGroup g1 = null;
            DJGroup g2 = null;
            if (group) {
                GroupBuilder gb1 = new GroupBuilder();
                g1 = gb1.setCriteriaColumn((PropertyColumn)colCategoria).setGroupLayout(ar.com.fdvs.dj.domain.constants.GroupLayout.VALUE_IN_HEADER).setDefaultHeaderVariableStyle(groupVariables).build();
                GroupBuilder gb2 = new GroupBuilder();
                g2 = gb2.setCriteriaColumn((PropertyColumn)colSottocategoria).setGroupLayout(ar.com.fdvs.dj.domain.constants.GroupLayout.VALUE_IN_HEADER).setDefaultHeaderVariableStyle(groupVariablesSottocat).build();
            }
            Style totalStyle = new Style();
            totalStyle.setBorderTop(Border.PEN_1_POINT);
            totalStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
            totalStyle.setBackgroundColor(new Color(230, 230, 230));
            totalStyle.setTransparency(Transparency.OPAQUE);
            Style atStyle2 = new StyleBuilder(true).setFont(Font.ARIAL_SMALL).build();
            if (group) {
                drb.addGroup(g1);
                drb.addGroup(g2);
                drb.addColumn(colCategoria);
                drb.addColumn(colSottocategoria);
            }
            drb.addColumn(colArticolo);
            drb.addColumn("Descrizione", "descrizione_articolo", String.class.getName(), 50);
            drb.addColumn(colUm);
            drb.addColumn(colGiacenza);
            Object deposito_key = null;
            try {
                deposito_key = ((KeyValuePair)this.deposito.getSelectedItem()).key;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (deposito_key == Magazzino.Depositi.TUTTI_DETTAGLIO) {
                drb.addColumn("Deposito", "deposito", String.class.getName(), 40);
            }
            if (this.matricola) {
                drb.addColumn("Matricola", "matricola", String.class.getName(), 20);
            }
            if (this.lotti) {
                drb.addColumn("Lotto", "lotto", String.class.getName(), 20);
            }
            if (this.comPrezzi.getSelectedIndex() >= 1) {
                drb.addColumn(colValore);
                drb.addColumn(colValoreTot);
            }
            drb.addGlobalFooterVariable(colGiacenza, DJCalculation.SUM, totalStyle);
            if (this.comPrezzi.getSelectedIndex() >= 1) {
                drb.addGlobalFooterVariable(colValoreTot, DJCalculation.SUM, totalStyle);
            }
            String sottotitolo = "Giacenza al " + DateUtils.formatDate((Date)(this.jXDatePicker1.getDate() == null ? new Date() : this.jXDatePicker1.getDate()));
            sottotitolo = deposito_key == Magazzino.Depositi.TUTTI_RIEPILOGATIVO ? sottotitolo + ", Deposito: Tutti riepilogativo" : (deposito_key == Magazzino.Depositi.TUTTI_DETTAGLIO ? sottotitolo + ", Deposito: Tutti con dettaglio" : sottotitolo + ", Deposito: " + this.deposito.getSelectedItem());
            if (this.comPrezzi.getSelectedIndex() >= 1) {
                sottotitolo = sottotitolo + ", Valori: " + this.comPrezzi.getSelectedItem();
            }
            if (this.fornitore_selezionato_filtro_ref.get() != null) {
                sottotitolo = sottotitolo + "\\nFornitore abituale: " + this.fornitore_selezionato_filtro_ref.get().ragione_sociale + " [" + this.fornitore_selezionato_filtro_ref.get().codice + "]";
            }
            DynamicReport dr = drb.setTitle("Giacenze").setColumnSpace(20).setSubtitle(sottotitolo).setPrintBackgroundOnOddRows(true).setUseFullPageWidth(true).addAutoText((byte)1, (byte)0, (byte)3, 30, 30, atStyle2).addAutoText((byte)3, (byte)0, (byte)1, (byte)3, 200, 200, atStyle2).setReportLocale(new Locale("it", "IT")).build();
            JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(newbeans);
            JasperPrint jp = DynamicJasperHelper.generateJasperPrint(dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds);
            SwingUtils.mouse_def((Component)this);
            InvoicexUtil.apriStampa(jp);
        }
        catch (Exception e) {
            SwingUtils.mouse_def((Component)this);
            e.printStackTrace();
            SwingUtils.showExceptionMessage((Component)this, (Exception)e);
        }
    }

    private void esportaActionPerformed(ActionEvent evt) {
        SwingUtils.mouse_wait((Component)main.getPadre());
        this.salva();
        PrintSimpleTable print = new PrintSimpleTable(this.tabGiacenze);
        int[] hw = null;
        hw = this.matricola || this.lotti ? (String.valueOf(this.comPrezzi.getSelectedItem()).equals("<non stampare prezzi>") ? new int[]{10, 50, 6, 10, 10} : new int[]{10, 50, 6, 10, 10, 10}) : (String.valueOf(this.comPrezzi.getSelectedItem()).equals("<non stampare prezzi>") ? new int[]{10, 50, 6, 10} : new int[]{10, 50, 6, 10, 10});
        Object deposito_key = null;
        try {
            deposito_key = ((KeyValuePair)this.deposito.getSelectedItem()).key;
        }
        catch (Exception exception) {
            // empty catch block
        }
        int[] hw2 = hw;
        if (deposito_key == Magazzino.Depositi.TUTTI_DETTAGLIO) {
            hw2 = new int[hw.length + 1];
            for (int i = 0; i < hw.length; ++i) {
                hw2[i] = hw[i];
            }
            hw2[hw.length] = 20;
        }
        String nomeFile = print.printExcel("Giacenze al " + DateUtils.formatDate((Date)this.jXDatePicker1.getDate()), hw2, "", "");
        Util.start2(nomeFile);
        SwingUtils.mouse_def((Component)main.getPadre());
    }

    private void texArticoloActionPerformed(ActionEvent evt) {
        this.aggiorna();
    }

    private void giacenza_zeroActionPerformed(ActionEvent evt) {
        this.aggiorna();
    }

    private void comPrezziActionPerformed(ActionEvent evt) {
        this.aggiorna();
    }

    private void depositoActionPerformed(ActionEvent evt) {
        this.aggiorna();
    }

    private void butRefreshActionPerformed(ActionEvent evt) {
        this.aggiorna();
    }

    private void jXDatePicker1ActionPerformed(ActionEvent evt) {
        this.comPrezziActionPerformed(null);
    }

    private void texFornitoreActionPerformed(ActionEvent evt) {
        this.aggiorna();
    }

    private void categoriaItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            System.out.println("SOTTOCATEGORIA  clear list");
            this.sottocategoria.dbClearList();
        } else if (evt.getStateChange() == 1) {
            System.out.println("SOTTOCATEGORIA  carico ");
            this.sottocategoria.dbClearList();
            this.sottocategoria.dbAddElement("", null);
            this.sottocategoria.dbOpenList(Db.getConn(), "select sottocategoria, id from sottocategorie_articoli where id_padre = " + Db.pc(this.categoria.getSelectedKey(), 4) + " order by sottocategoria", null, false);
            if (!this.loading) {
                this.aggiorna();
            }
        }
    }

    private void categoriaPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
    }

    private void sottocategoriaPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
    }

    private void sottocategoriaItemStateChanged(ItemEvent evt) {
        if (!this.loading) {
            this.aggiorna();
        }
    }

    private void ordineItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && !this.loading) {
            this.aggiorna();
        }
    }

    public void aggiornaTotali() {
        double tot_qta = 0.0;
        double tot_valore = 0.0;
        this.labTotali.setText("");
        try {
            int col_giac = this.tabGiacenze.getColumnModel().getColumnIndex("giacenza");
            int col_valore = -1;
            try {
                col_valore = this.tabGiacenze.getColumnModel().getColumnIndex("prezzo");
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int row = 0; row < this.tabGiacenze.getRowCount(); ++row) {
                double qta = CastUtils.toDouble0((Object)this.tabGiacenze.getValueAt(row, col_giac));
                double valore = 0.0;
                if (col_valore >= 0) {
                    valore = CastUtils.toDouble0((Object)this.tabGiacenze.getValueAt(row, col_valore));
                }
                tot_qta += qta;
                tot_valore += qta * valore;
            }
            this.labTotali.setText("<html>Totale Quantita' <b>" + FormatUtils.formatPerc((double)tot_qta) + "</b> / Totale Valore <b>" + FormatUtils.formatEuroIta((double)tot_valore) + "</b></html>");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void aggiorna() {
        if (this.loading) {
            return;
        }
        SwingUtils.mouse_wait((Component)this);
        KeyValuePair item = (KeyValuePair)this.comPrezzi.getSelectedItem();
        if (item == null) {
            this.listino = new Integer(0);
        } else {
            this.listino = item.key;
            if (this.listino.equals("null")) {
                this.listino = new Integer(0);
            } else if (this.listino.equals("***EL1***")) {
                this.listino = new Integer(1);
            } else if (this.listino.equals("***EL2***")) {
                this.listino = new Integer(2);
            } else if (this.listino.equals("***EL3***")) {
                this.listino = new Integer(3);
            } else if (this.listino.equals("***EL4***")) {
                this.listino = new Integer(4);
            } else if (this.listino.equals("***EL5***")) {
                this.listino = new Integer(5);
            }
        }
        SwingWorker w = new SwingWorker(){
            BeanAdapterTableModel tableModel;

            protected Object doInBackground() throws Exception {
                ArrayList<Giacenza> beans;
                Magazzino m = new Magazzino();
                ArrayList<String> colonne_int = new ArrayList<String>();
                ArrayList<String> colonne_campi = new ArrayList<String>();
                colonne_int.add("codice_articolo");
                colonne_campi.add("articolo");
                colonne_int.add("descrizione_articolo");
                colonne_campi.add("descrizione");
                colonne_int.add("um");
                colonne_campi.add("um");
                colonne_int.add("giacenza");
                colonne_campi.add("giacenza");
                Object deposito_key = null;
                try {
                    deposito_key = ((KeyValuePair)((JInternalFrameGiacenze)JInternalFrameGiacenze.this).deposito.getSelectedItem()).key;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (deposito_key == Magazzino.Depositi.TUTTI_DETTAGLIO) {
                    colonne_int.add("deposito");
                    colonne_campi.add("deposito");
                }
                Magazzino magazzino = new Magazzino();
                String articolo = null;
                if (JInternalFrameGiacenze.this.articolo_selezionato_filtro_ref != null && JInternalFrameGiacenze.this.articolo_selezionato_filtro_ref.get() != null) {
                    articolo = JInternalFrameGiacenze.this.articolo_selezionato_filtro_ref.get().codice;
                }
                if (JInternalFrameGiacenze.this.fornitore_selezionato_filtro_ref != null && JInternalFrameGiacenze.this.fornitore_selezionato_filtro_ref.get() != null) {
                    magazzino.filtro_fornitore_abituale = cu.i((Object)JInternalFrameGiacenze.this.fornitore_selezionato_filtro_ref.get().codice);
                }
                if (JInternalFrameGiacenze.this.categoria.getSelectedIndex() != -1) {
                    magazzino.filtro_categoria = cu.i((Object)JInternalFrameGiacenze.this.categoria.getSelectedKey());
                }
                if (JInternalFrameGiacenze.this.sottocategoria.getSelectedIndex() != -1) {
                    magazzino.filtro_sottocategoria = cu.i((Object)JInternalFrameGiacenze.this.sottocategoria.getSelectedKey());
                }
                if (JInternalFrameGiacenze.this.matricola) {
                    beans = magazzino.getGiacenza(true, articolo, JInternalFrameGiacenze.this.listino, JInternalFrameGiacenze.this.jXDatePicker1.getDate(), false, JInternalFrameGiacenze.this.giacenza_zero.isSelected(), false, deposito_key, JInternalFrameGiacenze.this.fornitore);
                    colonne_int.add("matricola");
                    colonne_campi.add("matricola");
                } else if (JInternalFrameGiacenze.this.lotti) {
                    beans = magazzino.getGiacenzaPerLotti(articolo, JInternalFrameGiacenze.this.listino, JInternalFrameGiacenze.this.jXDatePicker1.getDate(), JInternalFrameGiacenze.this.giacenza_zero.isSelected(), deposito_key);
                    colonne_int.add("lotto");
                    colonne_campi.add("lotto");
                } else {
                    beans = magazzino.getGiacenza(false, articolo, JInternalFrameGiacenze.this.listino, JInternalFrameGiacenze.this.jXDatePicker1.getDate(), false, JInternalFrameGiacenze.this.giacenza_zero.isSelected(), true, deposito_key, JInternalFrameGiacenze.this.fornitore, true);
                }
                if (!JInternalFrameGiacenze.this.listino.equals(new Integer(0))) {
                    colonne_int.add("prezzo");
                    colonne_campi.add("prezzo");
                }
                String[][] cols = new String[colonne_int.size()][2];
                for (int i = 0; i < colonne_int.size(); ++i) {
                    cols[i][0] = (String)colonne_int.get(i);
                    cols[i][1] = (String)colonne_campi.get(i);
                }
                JInternalFrameGiacenze.this.ordina(beans);
                if (cu.s((Object)JInternalFrameGiacenze.this.ordine.getSelectedItem()).startsWith("Categoria")) {
                    this.aggiungiCategorie(beans);
                }
                this.tableModel = new BeanAdapterTableModel(beans, cols);
                return null;
            }

            protected void done() {
                super.done();
                try {
                    JInternalFrameGiacenze.this.tabGiacenze.setModel(this.tableModel);
                    JInternalFrameGiacenze.this.tabGiacenze.getColumn("articolo").setCellRenderer(new DefaultTableCellRenderer(){

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            JLabel lab = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                            if (!cu.s((Object)JInternalFrameGiacenze.this.ordine.getSelectedItem()).startsWith("Categoria")) {
                                lab.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(0, 4, 0, 0), BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY)));
                                return lab;
                            }
                            Object b = ((BeanAdapterTableModel)table.getModel()).getBeans().get(row);
                            if (b.getClass().getName().equalsIgnoreCase("it.tnx.invoicex.data.Giacenza")) {
                                lab.setText("      " + lab.getText());
                                lab.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY));
                            } else {
                                lab.setFont(lab.getFont().deriveFont(1));
                                lab.setBorder(BorderFactory.createEmptyBorder());
                            }
                            return lab;
                        }
                    });
                    JInternalFrameGiacenze.this.tabGiacenze.getColumn("descrizione").setCellRenderer(new DefaultTableCellRenderer(){

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            JLabel lab = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                            Object b = ((BeanAdapterTableModel)table.getModel()).getBeans().get(row);
                            if (b.getClass().getName().equalsIgnoreCase("it.tnx.invoicex.data.Giacenza")) {
                                lab.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(0, 4, 0, 0), BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY)));
                            } else {
                                lab.setBorder(BorderFactory.createEmptyBorder());
                            }
                            return lab;
                        }
                    });
                    JInternalFrameGiacenze.this.tabGiacenze.getColumn("um").setCellRenderer(new DefaultTableCellRenderer(){

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            JLabel lab = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                            Object b = ((BeanAdapterTableModel)table.getModel()).getBeans().get(row);
                            if (b.getClass().getName().equalsIgnoreCase("it.tnx.invoicex.data.Giacenza")) {
                                lab.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(0, 4, 0, 0), BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY)));
                            } else {
                                lab.setBorder(BorderFactory.createEmptyBorder());
                            }
                            return lab;
                        }
                    });
                    JInternalFrameGiacenze.this.tabGiacenze.getColumn("giacenza").setCellRenderer((TableCellRenderer)new RendererUtils.NumberRenderer(){

                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            JLabel lab = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                            Object b = ((BeanAdapterTableModel)table.getModel()).getBeans().get(row);
                            if (b.getClass().getName().equalsIgnoreCase("it.tnx.invoicex.data.Giacenza")) {
                                lab.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(0, 4, 0, 0), BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY)));
                            } else {
                                lab.setBorder(BorderFactory.createEmptyBorder());
                            }
                            if (b.getClass().getName().equalsIgnoreCase("it.tnx.invoicex.data.Giacenza")) {
                                lab.setText(lab.getText() + " ");
                            } else {
                                lab.setText("");
                            }
                            return lab;
                        }
                    });
                    try {
                        JInternalFrameGiacenze.this.tabGiacenze.getColumn("matricola").setCellRenderer(new DefaultTableCellRenderer(){

                            @Override
                            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                                JLabel lab = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                                Object b = ((BeanAdapterTableModel)table.getModel()).getBeans().get(row);
                                if (b.getClass().getName().equalsIgnoreCase("it.tnx.invoicex.data.Giacenza")) {
                                    lab.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(0, 4, 0, 0), BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY)));
                                } else {
                                    lab.setBorder(BorderFactory.createEmptyBorder());
                                }
                                return lab;
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        JInternalFrameGiacenze.this.tabGiacenze.getColumn("lotto").setCellRenderer(new DefaultTableCellRenderer(){

                            @Override
                            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                                JLabel lab = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                                Object b = ((BeanAdapterTableModel)table.getModel()).getBeans().get(row);
                                if (b.getClass().getName().equalsIgnoreCase("it.tnx.invoicex.data.Giacenza")) {
                                    lab.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(0, 4, 0, 0), BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY)));
                                } else {
                                    lab.setBorder(BorderFactory.createEmptyBorder());
                                }
                                return lab;
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        JInternalFrameGiacenze.this.tabGiacenze.getColumn("deposito").setCellRenderer(new DefaultTableCellRenderer(){

                            @Override
                            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                                JLabel lab = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                                Object b = ((BeanAdapterTableModel)table.getModel()).getBeans().get(row);
                                if (b.getClass().getName().equalsIgnoreCase("it.tnx.invoicex.data.Giacenza")) {
                                    lab.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(0, 4, 0, 0), BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY)));
                                } else {
                                    lab.setBorder(BorderFactory.createEmptyBorder());
                                }
                                return lab;
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        JInternalFrameGiacenze.this.tabGiacenze.getColumn("prezzo").setCellRenderer((TableCellRenderer)new RendererUtils.CurrencyRenderer(){

                            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                                JLabel lab = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                                Object b = ((BeanAdapterTableModel)table.getModel()).getBeans().get(row);
                                if (!b.getClass().getName().equalsIgnoreCase("it.tnx.invoicex.data.Giacenza")) {
                                    lab.setText("");
                                }
                                return lab;
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    JInternalFrameGiacenze.this.tabGiacenze.getColumn("articolo").setPreferredWidth(50);
                    JInternalFrameGiacenze.this.tabGiacenze.getColumn("descrizione").setPreferredWidth(300);
                    JInternalFrameGiacenze.this.tabGiacenze.getColumn("um").setPreferredWidth(10);
                    JInternalFrameGiacenze.this.tabGiacenze.getColumn("giacenza").setPreferredWidth(20);
                    if (JInternalFrameGiacenze.this.articolo_selezionato_filtro_ref != null && JInternalFrameGiacenze.this.articolo_selezionato_filtro_ref.get() != null) {
                        ((JXTable)JInternalFrameGiacenze.this.tabGiacenze).setFilters(null);
                    }
                    JInternalFrameGiacenze.this.aggiornaTotali();
                }
                catch (Exception e) {
                    SwingUtils.showExceptionMessage((Component)JInternalFrameGiacenze.this, (Exception)e);
                }
                SwingUtils.mouse_def((Component)JInternalFrameGiacenze.this);
            }

            private void aggiungiCategorie(ArrayList beans) {
                Integer old_cat_id = null;
                Integer old_scat_id = null;
                Iterator iter = beans.iterator();
                for (int i = 0; i < beans.size(); ++i) {
                    Giacenza g = (Giacenza)beans.get(i);
                    if (g.getCategoria_id() != old_cat_id) {
                        GiacenzaCategoria gcat = new GiacenzaCategoria();
                        gcat.setCodice_articolo(cu.s((Object)g.getCategoria()) + " [" + g.getCategoria_id() + "]");
                        beans.add(i, gcat);
                        ++i;
                    }
                    if (g.getSottocategoria_id() != old_scat_id) {
                        GiacenzaSottocategoria gscat = new GiacenzaSottocategoria();
                        gscat.setCodice_articolo("   " + cu.s((Object)g.getSottocategoria()) + " [" + g.getSottocategoria_id() + "]");
                        beans.add(i, gscat);
                        ++i;
                    }
                    old_scat_id = g.getCategoria_id() != old_cat_id ? null : g.getSottocategoria_id();
                    old_cat_id = g.getCategoria_id();
                }
            }
        };
        w.execute();
    }

    private void ordina(ArrayList beans) {
        if (cu.s((Object)this.ordine.getSelectedItem()).equals("Codice articolo")) {
            return;
        }
        Collections.sort(beans, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = null;
                String s2 = null;
                if (cu.s((Object)JInternalFrameGiacenze.this.ordine.getSelectedItem()).equals("Descrizione articolo")) {
                    s1 = ((Giacenza)o1).getDescrizione_articolo();
                    s2 = ((Giacenza)o2).getDescrizione_articolo();
                } else if (cu.s((Object)JInternalFrameGiacenze.this.ordine.getSelectedItem()).equals("Categoria, Sottocategoria Articolo, Codice articolo")) {
                    s1 = StringUtils.rightPad((String)cu.s((Object)((Giacenza)o1).getCategoria()), (int)50, (String)" ") + StringUtils.rightPad((String)cu.s((Object)((Giacenza)o1).getSottocategoria()), (int)50, (String)" ") + ((Giacenza)o1).getCodice_articolo();
                    s2 = StringUtils.rightPad((String)cu.s((Object)((Giacenza)o2).getCategoria()), (int)50, (String)" ") + StringUtils.rightPad((String)cu.s((Object)((Giacenza)o2).getSottocategoria()), (int)50, (String)" ") + ((Giacenza)o2).getCodice_articolo();
                } else if (cu.s((Object)JInternalFrameGiacenze.this.ordine.getSelectedItem()).equals("Categoria, Sottocategoria Articolo, Descrizione")) {
                    s1 = StringUtils.rightPad((String)cu.s((Object)((Giacenza)o1).getCategoria()), (int)50, (String)" ") + StringUtils.rightPad((String)cu.s((Object)((Giacenza)o1).getSottocategoria()), (int)50, (String)" ") + ((Giacenza)o1).getDescrizione_articolo();
                    s2 = StringUtils.rightPad((String)cu.s((Object)((Giacenza)o2).getCategoria()), (int)50, (String)" ") + StringUtils.rightPad((String)cu.s((Object)((Giacenza)o2).getSottocategoria()), (int)50, (String)" ") + ((Giacenza)o2).getDescrizione_articolo();
                } else {
                    if (cu.s((Object)JInternalFrameGiacenze.this.ordine.getSelectedItem()).equals("Giacenza crescente")) {
                        return cu.d0((Object)((Giacenza)o1).getGiacenza()).compareTo(cu.d0((Object)((Giacenza)o2).getGiacenza()));
                    }
                    if (cu.s((Object)JInternalFrameGiacenze.this.ordine.getSelectedItem()).equals("Giacenza decrescente")) {
                        return cu.d0((Object)((Giacenza)o2).getGiacenza()).compareTo(cu.d0((Object)((Giacenza)o1).getGiacenza()));
                    }
                }
                return s1.compareTo(s2);
            }
        });
    }

    private void salva() {
        main.fileIni.setValue("pref", "stampa_giacenze_ordine", this.ordine.getSelectedItem());
        main.fileIni.setValue("pref", "stampa_giacenze_filtro_cat", this.categoria.getSelectedItem());
        main.fileIni.setValue("pref", "stampa_giacenze_filtro_sottocat", this.sottocategoria.getSelectedItem());
        main.fileIni.setValue("pref", "stampa_giacenze_deposito", this.deposito.getSelectedIndex());
        main.fileIni.setValue("pref", "stampa_giacenze_prezzi", this.comPrezzi.getSelectedIndex());
        main.fileIni.setValue("pref", "stampa_giacenze_zero", this.giacenza_zero.isSelected());
    }

    public static class GiacenzaSottocategoria
    extends Giacenza {
    }

    public static class GiacenzaCategoria
    extends Giacenza {
    }
}

