/*
 * Decompiled with CFR 0.152.
 */
package gestioneFatture.magazzino.print;

import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import gestioneFatture.Util;
import it.tnx.Db;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import javax.swing.JOptionPane;

public class PrintGiacenze {
    private Connection connection;
    private Statement stat;
    private ResultSet resu = null;
    private ResultSetMetaData meta;
    private String nomeFilePdf = "tempPrnGiacenze.pdf";
    private String nomeFileHtml = "tempPrnGiacenze.html";
    public String serie;
    public int numero;
    public int anno;
    private int numeroPagine;
    private int riga;
    private BaseFont bf;
    private BaseFont bfCour;
    private BaseFont bf_italic;
    private BaseFont bf_bold;
    private BaseFont bf_times;
    private PdfContentByte cb;
    private Document document;
    private PdfWriter writer;
    private Table datatable = null;
    int y;
    int iy = 1;
    Db dbUtil = Db.INSTANCE;

    public PrintGiacenze(ResultSet resu, String titolo) {
        System.out.println("print:giacenze");
        this.resu = resu;
        try {
            this.meta = resu.getMetaData();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        int[] hw = new int[]{10, 10, 30, 10, 30, 10};
        String ret = this.stampaTabella(titolo, null);
        Util.start(ret);
    }

    public String stampaTabella(String titolo, int[] headerWidth) {
        String nomeFilePdf = "tempStampaGiacenzeMagazzino.pdf";
        String nomeFileHtml = "tempStampaGiacenzeMagazzino.html";
        try {
            Cell tempPdfCell;
            int i;
            Document document = new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(nomeFilePdf));
            document.addTitle("stampa tabella");
            document.addSubject("stampa tabella");
            document.addKeywords("stampa tabella");
            document.addAuthor("TNX s.a.s");
            document.addHeader("Expires", "0");
            document.open();
            Font bf = new Font(1, 8.0f, 0);
            BaseFont bfCour = BaseFont.createFont((String)"Courier", (String)"winansi", (boolean)false);
            BaseFont bf_italic = BaseFont.createFont((String)"Helvetica-Oblique", (String)"winansi", (boolean)false);
            BaseFont bf_bold = BaseFont.createFont((String)"Helvetica-Bold", (String)"winansi", (boolean)false);
            BaseFont bf_times = BaseFont.createFont((String)"Times-Roman", (String)"winansi", (boolean)false);
            PdfContentByte cb = writer.getDirectContent();
            boolean riga = false;
            double iy = 1.25;
            double y = 4.0;
            Table datatable = new Table(this.meta.getColumnCount());
            datatable.setBorder(0);
            datatable.setPadding(2.0f);
            if (headerWidth != null) {
                datatable.setWidths(headerWidth);
            }
            datatable.setWidth(100.0f);
            datatable.setCellsFitPage(true);
            Phrase intestazione = new Phrase();
            intestazione.add((Object)new Chunk(titolo, new Font(2, 10.0f, 1)));
            document.add((Element)intestazione);
            for (i = 1; i <= this.meta.getColumnCount(); ++i) {
                tempPdfCell = null;
                if (i == 1) {
                    tempPdfCell = new Cell((Element)new Phrase("Articolo", bf));
                } else if (i == 2) {
                    tempPdfCell = new Cell((Element)new Phrase("", bf));
                } else if (i == 3) {
                    tempPdfCell = new Cell((Element)new Phrase("Giacenza", bf));
                }
                this.set1(tempPdfCell);
                datatable.addCell(tempPdfCell);
            }
            while (this.resu.next()) {
                for (i = 1; i <= this.meta.getColumnCount(); ++i) {
                    tempPdfCell = new Cell((Element)new Phrase(Db.nz(String.valueOf(this.resu.getString(i)), ""), bf));
                    this.set2(tempPdfCell);
                    datatable.addCell(tempPdfCell);
                }
            }
            document.add((Element)datatable);
            document.close();
            return nomeFilePdf;
        }
        catch (Exception err) {
            JOptionPane.showMessageDialog(null, err.toString());
            err.printStackTrace();
            return null;
        }
    }

    void set1(Cell tempPdfCell) {
        tempPdfCell.setBackgroundColor(new Color(255, 255, 240));
        tempPdfCell.setBorderColor(new Color(200, 200, 200));
        tempPdfCell.setHorizontalAlignment(1);
    }

    void set2(Cell tempPdfCell) {
        tempPdfCell.setBackgroundColor(new Color(255, 255, 255));
        tempPdfCell.setBorderColor(new Color(200, 200, 200));
        tempPdfCell.setHorizontalAlignment(0);
    }
}

