/*
 * Decompiled with CFR 0.152.
 */
package gestioneFatture.primaNota;

import com.caucho.quercus.QuercusEngine;
import com.caucho.quercus.QuercusErrorException;
import com.caucho.quercus.env.QuercusLanguageException;
import gestioneFatture.JDialogCompilazioneReport;
import gestioneFatture.Reports;
import gestioneFatture.UnZip;
import gestioneFatture.Util;
import gestioneFatture.dbFattura;
import gestioneFatture.main;
import gestioneFatture.primaNota.JDialogAnomalie;
import gestioneFatture.primaNota.PrimaNotaUtils;
import it.tnx.Db;
import it.tnx.MyStreamGobblerMain;
import it.tnx.SwingWorker;
import it.tnx.commons.BareBonesBrowserLaunch;
import it.tnx.commons.CastUtils;
import it.tnx.commons.DateUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.DebugUtils;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.HttpUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.SystemUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.invoicex.InvoicexUtil;
import it.tnx.invoicex.PlatformUtils;
import it.tnx.invoicex.iu;
import it.tnx.invoicex2.InvoicexUtil2;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.html.HTMLDocument;
import net.sf.jasperreports.engine.JasperManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXDatePicker;

public class frmStampaRegistroIva
extends JInternalFrame {
    int tipoLiquidazione = 0;
    public JXDatePicker al;
    public JButton butConferma;
    public JButton butNuovaStampa;
    public ButtonGroup buttonGroup1;
    public JComboBox comData;
    public JComboBox comPeriodo;
    public JXDatePicker dal;
    public JComboBox formato;
    public JLabel jLabel1;
    public JLabel jLabel10;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JLabel jLabel5;
    public JLabel jLabel6;
    public JLabel jLabel7;
    public JLabel jLabel8;
    public JLabel jLabel9;
    public JPanel jPanel1;
    public JSeparator jSeparator1;
    public JLabel labprogressivo;
    public JTextField progressivo;
    public JRadioButton radAnnuale;
    public JRadioButton radData;
    public JRadioButton radMensile;
    public JRadioButton radTrimestrale;
    public JCheckBox scontrini;
    public JCheckBox stampa_definitiva;
    public JTextField texAnno;
    public JTextField texIvaPrecedente;
    public JComboBox tipo_numero_pagina;

    public frmStampaRegistroIva() {
        this.initComponents();
        if (!main.debug) {
            this.butNuovaStampa.setVisible(false);
        }
        this.tipo_numero_paginaActionPerformed(null);
        this.cambiaTipoIva(true);
        this.texAnno.setText(String.valueOf(it.tnx.Util.getCurrenteYear()));
        this.texIvaPrecedente.setText("0");
        try {
            this.comData.setSelectedItem(main.fileIni.getValue("frm_stampa_registro_iva", "data"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.formato.setSelectedItem(main.fileIni.getValue("frm_stampa_registro_iva", "formato"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (main.pluginScontrini) {
            this.scontrini.setSelected(true);
            this.scontrini.setVisible(true);
        } else {
            this.scontrini.setSelected(false);
            this.scontrini.setVisible(false);
        }
        this.aggiornaDalAl();
        this.texAnno.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                frmStampaRegistroIva.this.aggiornaDalAl();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                frmStampaRegistroIva.this.aggiornaDalAl();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                frmStampaRegistroIva.this.aggiornaDalAl();
            }
        });
    }

    public void cambiaTipoIva(boolean start) {
        try {
            if (start) {
                ResultSet temp = Db.openResultSet("select tipo_liquidazione_iva from dati_azienda");
                temp.next();
                if (temp.getString("tipo_liquidazione_iva").equalsIgnoreCase("mensile")) {
                    this.radMensile.setSelected(true);
                    this.tipoLiquidazione = 2;
                } else if (temp.getString("tipo_liquidazione_iva").equalsIgnoreCase("trimestrale")) {
                    this.radTrimestrale.setSelected(true);
                    this.tipoLiquidazione = 1;
                } else if (temp.getString("tipo_liquidazione_iva").equalsIgnoreCase("annuale")) {
                    this.radAnnuale.setSelected(true);
                    this.tipoLiquidazione = 3;
                } else {
                    this.radData.setSelected(true);
                    this.tipoLiquidazione = 4;
                }
            } else {
                this.tipoLiquidazione = this.radMensile.isSelected() ? 2 : (this.radTrimestrale.isSelected() ? 1 : (this.radAnnuale.isSelected() ? 3 : 4));
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        this.comPeriodo.removeAllItems();
        this.comPeriodo.setEnabled(true);
        this.dal.setEnabled(false);
        this.al.setEnabled(false);
        int month = Calendar.getInstance().get(2);
        if (this.tipoLiquidazione == 2) {
            this.comPeriodo.addItem("Gennaio");
            this.comPeriodo.addItem("Febbraio");
            this.comPeriodo.addItem("Marzo");
            this.comPeriodo.addItem("Aprile");
            this.comPeriodo.addItem("Maggio");
            this.comPeriodo.addItem("Giugno");
            this.comPeriodo.addItem("Luglio");
            this.comPeriodo.addItem("Agosto");
            this.comPeriodo.addItem("Settembre");
            this.comPeriodo.addItem("Ottobre");
            this.comPeriodo.addItem("Novembre");
            this.comPeriodo.addItem("Dicembre");
            try {
                this.comPeriodo.setSelectedIndex(month);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.tipoLiquidazione == 1) {
            this.comPeriodo.addItem("Gennaio/Febbraio/Marzo");
            this.comPeriodo.addItem("Aprile/Maggio/Giugno");
            this.comPeriodo.addItem("Luglio/Agosto/Settembre");
            this.comPeriodo.addItem("Ottobre/Novembre/Dicembre");
            try {
                this.comPeriodo.setSelectedIndex(month / 3);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.tipoLiquidazione == 3) {
            this.comPeriodo.setEnabled(false);
        } else {
            this.comPeriodo.setEnabled(false);
            this.dal.setEnabled(true);
            this.al.setEnabled(true);
        }
    }

    public static String getDescrizioneRegistro(String tipo) {
        if (tipo.equalsIgnoreCase("A")) {
            return "Registro IVA Fatture di Acquisto";
        }
        return "Registro IVA Fatture di Vendita";
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.butConferma = new JButton();
        this.jLabel5 = new JLabel();
        this.comPeriodo = new JComboBox();
        this.texAnno = new JTextField();
        this.jLabel1 = new JLabel();
        this.texIvaPrecedente = new JTextField();
        this.jLabel2 = new JLabel();
        this.comData = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.radTrimestrale = new JRadioButton();
        this.radMensile = new JRadioButton();
        this.radAnnuale = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.tipo_numero_pagina = new JComboBox();
        this.progressivo = new JTextField();
        this.labprogressivo = new JLabel();
        this.scontrini = new JCheckBox();
        this.formato = new JComboBox();
        this.jLabel8 = new JLabel();
        this.radData = new JRadioButton();
        this.dal = new JXDatePicker();
        this.al = new JXDatePicker();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.stampa_definitiva = new JCheckBox();
        this.butNuovaStampa = new JButton();
        FormListener formListener = new FormListener();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Stampa Registro Iva");
        this.butConferma.setIcon(iu.getIcon("stampa"));
        this.butConferma.setText("Anteprima");
        this.butConferma.addActionListener(formListener);
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Seleziona il periodo");
        this.comPeriodo.addActionListener(formListener);
        this.texAnno.setColumns(6);
        this.texAnno.addKeyListener(formListener);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Anno");
        this.texIvaPrecedente.setColumns(10);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Data da usare per ordinare Fatt. Acquisto");
        this.comData.setModel(new DefaultComboBoxModel<String>(new String[]{"Data di registrazione", "Data del doc. esterno"}));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText("Iva a Credito dal periodo prec.");
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("Tipo Liquidazione");
        this.buttonGroup1.add(this.radTrimestrale);
        this.radTrimestrale.setText("Trimestrale");
        this.radTrimestrale.addActionListener(formListener);
        this.buttonGroup1.add(this.radMensile);
        this.radMensile.setText("Mensile");
        this.radMensile.addActionListener(formListener);
        this.buttonGroup1.add(this.radAnnuale);
        this.radAnnuale.setText("Annuale");
        this.radAnnuale.addActionListener(formListener);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Come stampare i numeri di pagina");
        this.tipo_numero_pagina.setModel(new DefaultComboBoxModel<String>(new String[]{"Stampa numeratore pagine semplice (Pagina # di #)", "Stampa progressivo con anno"}));
        this.tipo_numero_pagina.addActionListener(formListener);
        this.progressivo.setColumns(6);
        this.progressivo.setText("1");
        this.labprogressivo.setHorizontalAlignment(4);
        this.labprogressivo.setText("progressivo di partenza");
        this.scontrini.setText("Includi scontrini");
        this.formato.setModel(new DefaultComboBoxModel<String>(new String[]{"Anteprima a video - Verticale", "Anteprima a video - Orizzontale", "Esportazione in Excel - Verticale", "Esportazione in Excel - Orizzontale"}));
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText("Formato");
        this.buttonGroup1.add(this.radData);
        this.radData.setText("Da data a data");
        this.radData.addActionListener(formListener);
        this.dal.setName("dal");
        this.dal.addFocusListener((FocusListener)formListener);
        this.dal.addActionListener((ActionListener)formListener);
        this.dal.addPropertyChangeListener((PropertyChangeListener)formListener);
        this.al.setName("data");
        this.al.addFocusListener((FocusListener)formListener);
        this.al.addActionListener((ActionListener)formListener);
        this.al.addPropertyChangeListener((PropertyChangeListener)formListener);
        this.jLabel9.setText("Al");
        this.jLabel10.setText("Dal");
        this.stampa_definitiva.setText("Stampa definitva (verranno bloccati i documenti)");
        this.butNuovaStampa.setText("Nuova Stampa");
        this.butNuovaStampa.addActionListener(formListener);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.butNuovaStampa).addPreferredGap(0).add((Component)this.butConferma)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel7).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.radAnnuale).add((Component)this.radMensile).add((Component)this.radTrimestrale).add((Component)this.radData))).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(10, 10, 10).add((Component)this.jLabel6).addPreferredGap(0).add((Component)this.texIvaPrecedente, -2, -1, -2)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(10, 10, 10).add((Component)this.jLabel2)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel3)).add(2, (Component)this.jLabel8)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.tipo_numero_pagina, -2, -1, -2).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.labprogressivo).addPreferredGap(0).add((Component)this.progressivo, -2, -1, -2)).add((Component)this.scontrini).add((Component)this.formato, -2, -1, -2).add((Component)this.comData, -2, -1, -2).add((Component)this.stampa_definitiva))).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel5).add((Component)this.jLabel10)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.comPeriodo, -2, -1, -2).add(18, 18, 18).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.texAnno, -2, -1, -2)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.dal, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel9).addPreferredGap(0).add((Component)this.al, -2, -1, -2))))).add(0, 45, Short.MAX_VALUE)).add(2, (Component)this.jSeparator1)).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.jLabel2, this.jLabel3, this.jLabel5, this.jLabel6, this.jLabel7}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(11, 11, 11).add((Component)this.radMensile).add(2, 2, 2).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.radTrimestrale).add((Component)this.jLabel7)).add(2, 2, 2).add((Component)this.radAnnuale).add(2, 2, 2).add((Component)this.radData).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.comPeriodo, -2, -1, -2).add((Component)this.jLabel5).add((Component)this.texAnno, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.dal, -2, -1, -2).add((Component)this.al, -2, -1, -2).add((Component)this.jLabel9).add((Component)this.jLabel10)).add(9, 9, 9).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.texIvaPrecedente, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.comData, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.tipo_numero_pagina, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.progressivo, -2, -1, -2).add((Component)this.labprogressivo)).addPreferredGap(0).add((Component)this.scontrini).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.formato, -2, -1, -2).add((Component)this.jLabel8)).addPreferredGap(1).add((Component)this.stampa_definitiva).addPreferredGap(0, 23, Short.MAX_VALUE).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.butConferma).add((Component)this.butNuovaStampa)).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void butConfermaActionPerformed(ActionEvent evt) {
        InvoicexUtil2.checkPhpMustache();
        if (this.dal.getDate() == null) {
            SwingUtils.showInfoMessage((Component)this, (String)"Manca l'inizio del periodo");
            return;
        }
        if (this.al.getDate() == null) {
            SwingUtils.showInfoMessage((Component)this, (String)"Manca la fine del periodo");
            return;
        }
        this.setCursor(new Cursor(3));
        ElaboraIva work = new ElaboraIva();
        work.padre = this;
        work.xls = cu.toString((Object)this.formato.getSelectedItem()).toLowerCase().indexOf("excel") >= 0;
        if (cu.s((Object)this.formato.getSelectedItem()).toLowerCase().indexOf("orizzon") >= 0) {
            work.oriz = true;
        }
        work.start();
        this.setCursor(new Cursor(0));
    }

    private void radMensileActionPerformed(ActionEvent evt) {
        this.cambiaTipoIva(false);
    }

    private void radTrimestraleActionPerformed(ActionEvent evt) {
        this.cambiaTipoIva(false);
    }

    private void radAnnualeActionPerformed(ActionEvent evt) {
        this.cambiaTipoIva(false);
    }

    private void tipo_numero_paginaActionPerformed(ActionEvent evt) {
        if (this.tipo_numero_pagina.getSelectedIndex() == 0) {
            this.labprogressivo.setEnabled(false);
            this.progressivo.setText("---");
            this.progressivo.setEnabled(false);
        } else {
            this.labprogressivo.setEnabled(true);
            this.progressivo.setText("1");
            this.progressivo.setEnabled(true);
        }
    }

    private void radDataActionPerformed(ActionEvent evt) {
        this.cambiaTipoIva(false);
    }

    private void dalActionPerformed(ActionEvent evt) {
    }

    private void dalFocusLost(FocusEvent evt) {
    }

    private void dalPropertyChange(PropertyChangeEvent evt) {
        System.out.println("evt = " + evt);
    }

    private void alActionPerformed(ActionEvent evt) {
    }

    private void alFocusLost(FocusEvent evt) {
    }

    private void alPropertyChange(PropertyChangeEvent evt) {
    }

    private void comPeriodoActionPerformed(ActionEvent evt) {
        this.aggiornaDalAl();
    }

    private void texAnnoKeyTyped(KeyEvent evt) {
    }

    private void butNuovaStampaActionPerformed(ActionEvent evt) {
        try {
            InvoicexUtil.generaTotaliDocumentoDate(DateUtils.getDate((int)2019, (int)5, (int)1), DateUtils.getDate((int)2019, (int)5, (int)21), null);
            QuercusEngine engine = new QuercusEngine();
            engine.setIni("display_errors", "On");
            engine.setIni("log_errors", "On");
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            engine.setOutputStream((OutputStream)ba);
            String int1 = "";
            try {
                String sql = "select ragione_sociale, indirizzo, localita, cap, provincia, cfiscale, piva from dati_azienda";
                Map m = (Map)DbUtils.getListMap((Connection)Db.getConn(), (String)sql).get(0);
                int1 = int1 + m.get("ragione_sociale") + ", " + m.get("indirizzo") + "\n" + m.get("cap") + " " + m.get("localita") + " (" + m.get("provincia") + ")\nPartita IVA " + m.get("piva") + " Codice Fiscale " + m.get("cfiscale");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            engine.getQuercus().setServerEnv("azienda", int1);
            engine.getQuercus().setServerEnv("dal", FormatUtils.formatMysqlDate((Object)this.dal.getDate()));
            engine.getQuercus().setServerEnv("al", FormatUtils.formatMysqlDate((Object)this.al.getDate()));
            engine.getQuercus().setServerEnv("dal-ita", DateUtils.formatDateIta((Date)this.dal.getDate()));
            engine.getQuercus().setServerEnv("al-ita", DateUtils.formatDateIta((Date)this.al.getDate()));
            String tipo = "";
            tipo = this.radMensile.isSelected() ? " - Mensile" : (this.radTrimestrale.isSelected() ? " - Trimestrale" : (this.radAnnuale.isSelected() ? " - Annuale" : ""));
            engine.getQuercus().setServerEnv("tipo", tipo);
            engine.getQuercus().setServerEnv("data", cu.s((Object)this.comData.getSelectedIndex()));
            engine.getQuercus().setServerEnv("ivaACreditoPeriodoPrec", String.valueOf(it.tnx.Util.getDouble(this.texIvaPrecedente.getText())));
            engine.getQuercus().setServerEnv("tipo_numero_pagina", String.valueOf(this.tipo_numero_pagina.getSelectedIndex()));
            engine.getQuercus().setServerEnv("pagina_start", this.progressivo.getText());
            engine.getQuercus().setServerEnv("anno", this.texAnno.getText() + "/");
            try {
                File tmp = new File(System.getProperty("user.home") + File.separator + ".invoicex" + File.separator + "tmp");
                tmp.mkdir();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File fout = new File(System.getProperty("user.home") + File.separator + ".invoicex" + File.separator + "tmp" + File.separator + "regiva.html");
            File fout_h = new File(System.getProperty("user.home") + File.separator + ".invoicex" + File.separator + "tmp" + File.separator + "regiva_header.html");
            File fout_f = new File(System.getProperty("user.home") + File.separator + ".invoicex" + File.separator + "tmp" + File.separator + "regiva_footer.html");
            if (main.debug) {
                // empty if block
            }
            String script = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/gestioneFatture/primaNota/php/regiva.php"));
            engine.execute(script);
            this.copyOut(ba, fout);
            script = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/gestioneFatture/primaNota/php/regiva_header.php"));
            engine.execute(script);
            this.copyOut(ba, fout_h);
            script = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/gestioneFatture/primaNota/php/regiva_footer.php"));
            engine.execute(script);
            this.copyOut(ba, fout_f);
            this.creaPdf(fout_h, fout_f, fout);
            BareBonesBrowserLaunch.openURL((String)fout.toURI().toURL().toString());
            SwingUtils.open((File)new File("spool" + File.separatorChar + "regiva.pdf"));
        }
        catch (QuercusLanguageException qe) {
            qe.printStackTrace();
            SwingUtils.showExceptionMessage((Component)this, (Exception)((Object)qe));
        }
        catch (QuercusErrorException qe) {
            qe.printStackTrace();
            SwingUtils.showExceptionMessage((Component)this, (Exception)((Object)qe));
        }
        catch (Exception e) {
            e.printStackTrace();
            SwingUtils.showExceptionMessage((Component)this, (Exception)e);
        }
    }

    private void aggiornaDalAl() {
        if (!this.radData.isSelected()) {
            this.dal.setDate(null);
            this.al.setDate(null);
        }
        if (this.radMensile.isSelected()) {
            if (this.comPeriodo.getSelectedIndex() >= 0 && cu.i0((Object)this.texAnno.getText()) > 2000) {
                Date iniziomese = DateUtils.getDate((int)cu.i((Object)this.texAnno.getText()), (int)(this.comPeriodo.getSelectedIndex() + 1), (int)1);
                Calendar cal = Calendar.getInstance();
                cal.setTime(iniziomese);
                cal.add(2, 1);
                cal.add(6, -1);
                Date finemese = cal.getTime();
                this.dal.setDate(iniziomese);
                this.al.setDate(finemese);
            }
        } else if (this.radTrimestrale.isSelected()) {
            if (this.comPeriodo.getSelectedIndex() >= 0 && cu.i0((Object)this.texAnno.getText()) > 2000) {
                Date iniziomese = DateUtils.getDate((int)cu.i((Object)this.texAnno.getText()), (int)(this.comPeriodo.getSelectedIndex() * 3 + 1), (int)1);
                Calendar cal = Calendar.getInstance();
                cal.setTime(iniziomese);
                cal.add(2, 3);
                cal.add(6, -1);
                Date finemese = cal.getTime();
                this.dal.setDate(iniziomese);
                this.al.setDate(finemese);
            }
        } else if (this.radAnnuale.isSelected() && cu.i0((Object)this.texAnno.getText()) > 2000) {
            Date iniziomese = DateUtils.getDate((int)cu.i0((Object)this.texAnno.getText()), (int)1, (int)1);
            Calendar cal = Calendar.getInstance();
            cal.setTime(iniziomese);
            cal.add(1, 1);
            cal.add(6, -1);
            Date finemese = cal.getTime();
            this.dal.setDate(iniziomese);
            this.al.setDate(finemese);
        }
    }

    private void checkWkhtml2pdf() throws Exception {
        File exe;
        String osarch = System.getProperty("os.arch");
        boolean is64bit = false;
        if (osarch.indexOf("64") >= 0) {
            is64bit = true;
        }
        String urldownload = "http://server.invoicex.it/download/wkhtml2pdf";
        if (PlatformUtils.isWindows()) {
            exe = new File("wkhtmltopdf\\wkhtmltopdf.exe");
            if (exe.exists()) {
                return;
            }
            urldownload = urldownload + "/win" + (is64bit ? "64" : "32") + "/wkhtmltopdf.zip";
        } else if (PlatformUtils.isMac()) {
            exe = new File("wkhtmltopdf/wkhtmltopdf");
            if (exe.exists()) {
                return;
            }
            urldownload = urldownload + "/mac" + (is64bit ? "64" : "32") + "/wkhtmltopdf.zip";
        } else if (PlatformUtils.isLinux()) {
            exe = new File("wkhtmltopdf/wkhtmltopdf");
            if (exe.exists()) {
                return;
            }
            urldownload = urldownload + "/lin" + (is64bit ? "64" : "32") + "/wkhtmltopdf.zip";
        }
        System.out.println("urldownload = " + urldownload);
        File dir = new File("wkhtmltopdf");
        dir.mkdir();
        HttpUtils.saveBigFile((String)urldownload, (String)"wkhtmltopdf/wkhtmltopdf.zip", (HttpUtils.SaveFileEventListener)new HttpUtils.SaveFileEventListener(){

            public void event(float progression) {
                System.out.println(progression);
            }
        });
        UnZip unzip = new UnZip();
        UnZip.unzip(new File("wkhtmltopdf/wkhtmltopdf.zip"), new File("wkhtmltopdf/"));
        if (PlatformUtils.isMac() || PlatformUtils.isLinux()) {
            String cmd = "wkhtmltopdf/wkhtmltopdf";
            System.out.println("cambio permessi per esecuzione " + cmd);
            Process p = Runtime.getRuntime().exec("chmod +x " + cmd);
            int ret = p.waitFor();
            System.out.println("ret chmod:" + ret);
        }
    }

    private void copyOut(ByteArrayOutputStream ba, File fout) throws FileNotFoundException, IOException {
        FileOutputStream fouts = new FileOutputStream(fout);
        IOUtils.copy((InputStream)new ByteArrayInputStream(ba.toByteArray()), (OutputStream)fouts);
        fouts.close();
        ba.reset();
    }

    private void creaPdf(File fout_h, File fout_f, File fout) throws IOException, InterruptedException, Exception {
        this.checkWkhtml2pdf();
        String cmd = "";
        String x = "";
        if (PlatformUtils.isWindows()) {
            cmd = "wkhtmltopdf\\wkhtmltopdf.exe";
        } else if (PlatformUtils.isMac()) {
            cmd = "wkhtmltopdf/wkhtmltopdf";
        } else if (PlatformUtils.isLinux()) {
            cmd = "wkhtmltopdf/wkhtmltopdf";
        }
        x = x + cmd + " --print-media-type --header-html " + fout_h.getAbsolutePath() + " --footer-html " + fout_f.getAbsolutePath() + " " + fout.getAbsolutePath() + " spool" + File.separatorChar + "regiva.pdf";
        Object[] xa = new String[]{cmd, "--print-media-type", "--header-html", fout_h.getAbsolutePath(), "--footer-html", fout_f.getAbsolutePath(), fout.getAbsolutePath(), "spool" + File.separatorChar + "regiva.pdf"};
        System.out.println(StringUtils.join((Object[])xa, (String)" "));
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec((String[])xa);
        MyStreamGobblerMain errorGobbler = new MyStreamGobblerMain(proc.getErrorStream(), "ERROR");
        MyStreamGobblerMain outputGobbler = new MyStreamGobblerMain(proc.getInputStream(), "OUTPUT");
        errorGobbler.start();
        outputGobbler.start();
        int exitVal = proc.waitFor();
        System.out.println("html2pdf exit value: " + exitVal);
    }

    public final class ElaboraIva
    extends SwingWorker {
        public frmStampaRegistroIva padre = null;
        public boolean xls = false;
        private boolean oriz;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object construct() {
            final JDialogCompilazioneReport dialog = new JDialogCompilazioneReport();
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            main.fileIni.setValue("frm_stampa_registro_iva", "data", frmStampaRegistroIva.this.comData.getSelectedItem());
            main.fileIni.setValue("frm_stampa_registro_iva", "formato", frmStampaRegistroIva.this.formato.getSelectedItem());
            String sql = "";
            int anno = 0;
            try {
                anno = Integer.parseInt(frmStampaRegistroIva.this.texAnno.getText());
            }
            catch (Exception err) {
                err.printStackTrace();
            }
            if (this.oriz) {
                PrimaNotaUtils pn = new PrimaNotaUtils(dialog);
                pn.oriz = this.oriz;
                try {
                    pn.generaPrimaNota(frmStampaRegistroIva.this.tipoLiquidazione, frmStampaRegistroIva.this.comPeriodo.getSelectedIndex() + 1, anno, frmStampaRegistroIva.this.comData.getSelectedIndex() != 0, frmStampaRegistroIva.this.scontrini.isSelected(), frmStampaRegistroIva.this.dal.getDate(), frmStampaRegistroIva.this.al.getDate(), frmStampaRegistroIva.this.stampa_definitiva.isSelected());
                }
                catch (Exception e) {
                    SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)e);
                    return null;
                }
                try {
                    File frep = new File("reports/iva.jrxml");
                    JasperReport jasperReport = Reports.getReport(frep);
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    if (frmStampaRegistroIva.this.radAnnuale.isSelected()) {
                        parameters.put("periodo", "Anno " + frmStampaRegistroIva.this.texAnno.getText());
                    } else if (frmStampaRegistroIva.this.radData.isSelected()) {
                        parameters.put("periodo", "Dal " + DateUtils.formatDateIta((Date)frmStampaRegistroIva.this.dal.getDate()) + " al " + DateUtils.formatDateIta((Date)frmStampaRegistroIva.this.al.getDate()));
                    } else {
                        parameters.put("periodo", this.padre.comPeriodo.getSelectedItem() + " " + frmStampaRegistroIva.this.texAnno.getText());
                    }
                    parameters.put("anno", frmStampaRegistroIva.this.texAnno.getText());
                    parameters.put("tipo_numerazione_pagine", frmStampaRegistroIva.this.tipo_numero_pagina.getSelectedIndex());
                    int pro = CastUtils.toInteger0((Object)frmStampaRegistroIva.this.progressivo.getText());
                    if (pro > 0) {
                        --pro;
                    }
                    parameters.put("progressivo_partenza", pro);
                    String int1 = "";
                    try {
                        sql = "select ragione_sociale, indirizzo, localita, cap, provincia, cfiscale, piva from dati_azienda";
                        Map m = (Map)DbUtils.getListMap((Connection)Db.getConn(), (String)sql).get(0);
                        int1 = int1 + m.get("ragione_sociale") + ", " + m.get("indirizzo") + ", " + m.get("cap") + " " + m.get("localita") + " (" + m.get("provincia") + "), Partita IVA " + m.get("piva") + ", Codice Fiscale " + m.get("cfiscale");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    parameters.put("intestazione1", int1);
                    int codiceIva = 0;
                    parameters.put("iva1", "");
                    parameters.put("iva2", "");
                    parameters.put("iva3", "");
                    parameters.put("iva4", "");
                    parameters.put("iva5", "");
                    for (Map miva : pn.riva) {
                        if (++codiceIva > 5) break;
                        try {
                            parameters.put("iva" + codiceIva, "Aliquota " + it.tnx.Util.formatNumero0Decimali(cu.d(miva.get("percentuale"))) + " %");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    double saldo1 = 0.0;
                    double saldo2 = 0.0;
                    double creditoPeriodoPrec = 0.0;
                    parameters.put("totaleIvaAcquisti", new Double(pn.totali.totaleAcquisti));
                    parameters.put("totaleIvaVendite", new Double(pn.totali.totaleVendite));
                    DebugUtils.dump(parameters);
                    saldo1 = pn.totali.totaleAcquisti - pn.totali.totaleVendite;
                    System.out.println("saldo1: " + saldo1);
                    parameters.put("ivaSaldo1", new Double(Math.abs(saldo1)));
                    creditoPeriodoPrec = it.tnx.Util.getDouble(this.padre.texIvaPrecedente.getText());
                    parameters.put("ivaACreditoPeriodoPrec", new Double(creditoPeriodoPrec));
                    saldo2 = saldo1 + creditoPeriodoPrec;
                    parameters.put("ivaSaldo2", new Double(Math.abs(saldo2)));
                    if (saldo1 < 0.0) {
                        parameters.put("scrittaDebitoCredito1", "Debito");
                    } else {
                        parameters.put("scrittaDebitoCredito1", "Credito");
                    }
                    if (saldo2 < 0.0) {
                        parameters.put("scrittaDebitoCredito2", "Debito");
                    } else {
                        parameters.put("scrittaDebitoCredito2", "Credito");
                    }
                    if (!this.xls) {
                        Connection conn = Db.getConn();
                        JasperPrint jasperPrint = JasperManager.fillReport((JasperReport)jasperReport, parameters, (Connection)conn);
                        InvoicexUtil.apriStampa(jasperPrint);
                    }
                    Map<String, String> colonne = Collections.synchronizedMap(new LinkedHashMap());
                    colonne.put("id", "");
                    colonne.put("tipo", "");
                    colonne.put("data", "data doc. interno");
                    colonne.put("numero_prog", "num. doc. interno");
                    colonne.put("numero_doc", "num. doc. esterno");
                    colonne.put("data_doc", "data doc. esterno");
                    colonne.put("ragione_sociale", "");
                    colonne.put("piva_cfiscale", "partita iva");
                    colonne.put("totale", "");
                    colonne.put("imp1", "Imponibile " + parameters.get("iva1"));
                    colonne.put("iva1", "Iva " + parameters.get("iva1"));
                    colonne.put("imp2", "Imponibile " + parameters.get("iva2"));
                    colonne.put("iva2", "Iva " + parameters.get("iva2"));
                    colonne.put("imp3", "Imponibile " + parameters.get("iva3"));
                    colonne.put("iva3", "Iva " + parameters.get("iva3"));
                    colonne.put("imp4", "Imponibile " + parameters.get("iva4"));
                    colonne.put("iva4", "Iva " + parameters.get("iva4"));
                    colonne.put("imp5", "Imponibile " + parameters.get("iva5"));
                    colonne.put("iva5", "Iva " + parameters.get("iva5"));
                    colonne.put("altre_imp", "Esenti/Non Imponibili/Fuori campo");
                    colonne.put("imp_deducibile", "imponibile indeducibile");
                    colonne.put("iva_deducibile", "iva indeducibile");
                    File exportDir = new File(SystemUtils.getUserDocumentsFolder() + File.separator + "Invoicex" + File.separator + "export");
                    exportDir.mkdirs();
                    File nomeFile = new File(SystemUtils.getUserDocumentsFolder() + File.separator + "Invoicex" + File.separator + "export" + File.separator + "iva.xls");
                    try {
                        HSSFWorkbook wb = new HSSFWorkbook();
                        HSSFSheet sheet = wb.createSheet("Fatture di acquisto");
                        sheet.getPrintSetup().setPaperSize((short)9);
                        ResultSet racq = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)"select * from stampa_iva_semplice where tipo = 'A'");
                        short row_tot_acq = this.accodaXls(racq, sheet, colonne, wb);
                        sheet = wb.createSheet("Fatture di vendita");
                        sheet.getPrintSetup().setPaperSize((short)9);
                        ResultSet rven = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)"select * from stampa_iva_semplice where tipo = 'V'");
                        short row_tot_ven = this.accodaXls(rven, sheet, colonne, wb);
                        sheet = wb.createSheet("Totali");
                        sheet.getPrintSetup().setPaperSize((short)9);
                        this.accodaXlsTotali(creditoPeriodoPrec, sheet, wb, row_tot_acq, row_tot_ven, parameters);
                        FileOutputStream fileOut = new FileOutputStream(nomeFile);
                        wb.write((OutputStream)fileOut);
                        fileOut.close();
                        Util.start2(nomeFile.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        SwingUtils.showExceptionMessage((Component)this.padre, (Exception)ex);
                    }
                }
                catch (Exception err) {
                    SwingUtils.showExceptionMessage((Component)this.padre, (Exception)err);
                }
                finally {
                    dialog.setVisible(false);
                    return null;
                }
            }
            try {
                File filePdf = new File("spool" + File.separatorChar + "regiva.pdf");
                File fileXls = new File("spool" + File.separatorChar + "regiva.html.xls");
                if (!this.xls) {
                    if (filePdf.exists() && !filePdf.delete()) {
                        throw new Exception("Non riesco a creare il file PDF, forse \u00e8 aperta la precedente stampa?");
                    }
                } else if (fileXls.exists() && !fileXls.delete()) {
                    throw new Exception("Non riesco a creare il file XLS, forse \u00e8 aperto Excel sulla precedente esportazione?");
                }
                InvoicexUtil.EsitoGeneraTotaliLista esito = InvoicexUtil.generaTotaliDocumentoDateConEsito(frmStampaRegistroIva.this.dal.getDate(), frmStampaRegistroIva.this.al.getDate(), new org.jdesktop.swingworker.SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        return null;
                    }

                    protected void process(List chunks) {
                        try {
                            String c = cu.s(chunks.get(0));
                            try {
                                String msg = StringUtils.substringAfter((String)c, (String)"status|");
                                Integer n = cu.i((Object)StringUtils.substringBefore((String)StringUtils.substringAfter((String)msg, (String)"... "), (String)"/"));
                                Integer t = cu.i((Object)StringUtils.substringAfter((String)msg, (String)"/"));
                                dialog.jProgressBar1.setIndeterminate(false);
                                dialog.jProgressBar1.setValue(n);
                                dialog.jProgressBar1.setMaximum(t);
                                dialog.jLabel1.setText(msg);
                            }
                            catch (Exception e) {
                                dialog.jLabel1.setText(c);
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                if (frmStampaRegistroIva.this.stampa_definitiva.isSelected()) {
                    String campodata = null;
                    campodata = frmStampaRegistroIva.this.comData.getSelectedIndex() == 1 ? "data_doc" : "data";
                    sql = "select  tf.id, tf.serie, tf.numero, tf.anno, tf.data, tf.numero_doc, tf.serie_doc, tf.data_doc, tf.fornitore, tf.tipo_fattura, tf.importo, cf.ragione_sociale, iva.codice_iva, iva.perc_deducibile, iva.imponibile, iva.iva, civa.descrizione as descrizione_iva from test_fatt_acquisto tf left join test_fatt_acquisto_iva_ded iva on tf.id = iva.id_padre left join clie_forn cf on tf.fornitore = cf.codice left join codici_iva civa on iva.codice_iva = civa.codice where " + campodata + " >= '" + FormatUtils.formatMysqlDate((Object)frmStampaRegistroIva.this.dal.getDate()) + "' and " + campodata + " <= '" + FormatUtils.formatMysqlDate((Object)frmStampaRegistroIva.this.al.getDate()) + "'";
                    ArrayList list = dbu.getListMap((Connection)Db.getConn(), (String)sql);
                    for (Map m : list) {
                        if (dbFattura.bloccaFattura(cu.i(m.get("id")), 7)) {
                            System.out.println("Fattura di acquisto id " + cu.i(m.get("id")) + " bloccata");
                            continue;
                        }
                        System.err.println("!!! !!! !!! Errore durante il blocco della fattura di acquisto " + cu.i(m.get("id")) + " !!! !!! !!!");
                    }
                    sql = "select  t.id , t.serie, t.numero, t.anno, t.data, t.cliente, t.tipo_fattura, tfx.split_payment , t.totale, cf.ragione_sociale, iva.codice_iva, iva.imponibile, iva.iva , civa.descrizione as descrizione_iva from test_fatt t left join tipi_fatture tf on t.tipo_fattura = tf.tipo left join test_fatt_xmlpa tfx on t.id = tfx.id_fattura left join test_fatt_iva iva on t.id = iva.id_padre left join clie_forn cf on t.cliente = cf.codice left join codici_iva civa on iva.codice_iva = civa.codice where data >= '" + FormatUtils.formatMysqlDate((Object)frmStampaRegistroIva.this.dal.getDate()) + "' and data <= '" + FormatUtils.formatMysqlDate((Object)frmStampaRegistroIva.this.al.getDate()) + "' and tf.descrizione_breve != 'FP' and t.tipo_fattura != 7 order by data, serie, numero";
                    list = dbu.getListMap((Connection)Db.getConn(), (String)sql);
                    for (Map m : list) {
                        if (dbFattura.bloccaFattura(cu.i(m.get("id")), 1)) {
                            System.out.println("Fattura di vendita id " + cu.i(m.get("id")) + " bloccata");
                            continue;
                        }
                        System.err.println("!!! !!! !!! Errore durante il blocco della fattura di VENDITA " + cu.i(m.get("id")) + " !!! !!! !!!");
                    }
                }
                System.out.println("esito = " + esito);
                if (esito.anomalie_presenti) {
                    JDialogAnomalie da = new JDialogAnomalie((Frame)main.getPadreFrame(), true);
                    da.anomalie = esito.anomalie;
                    da.text.setContentType("text/html");
                    String bodyRule = "body { font-family: Monospaced; font-size: 14pt; }";
                    ((HTMLDocument)da.text.getDocument()).getStyleSheet().addRule(bodyRule);
                    String testo = "<html><pre><table>";
                    testo = testo + "<tr>";
                    testo = testo + "<td>Tipo</td>";
                    testo = testo + "<td>ID</td>";
                    testo = testo + "<td>Serie</td>";
                    testo = testo + "<td>Numero</td>";
                    testo = testo + "<td>Anno</td>";
                    testo = testo + "<td>Totale registrato</td>";
                    testo = testo + "<td>Totale ricalcolato</td>";
                    testo = testo + "</tr>";
                    for (int i = 0; i < esito.anomalie.size(); ++i) {
                        Object[] row = esito.anomalie.get(i);
                        testo = testo + "<tr>";
                        testo = testo + "<td>" + row[0] + "</td>";
                        testo = testo + "<td>" + row[1] + "</td>";
                        testo = testo + "<td>" + row[2] + "</td>";
                        testo = testo + "<td>" + row[3] + "</td>";
                        testo = testo + "<td>" + row[4] + "</td>";
                        testo = testo + "<td>" + row[5] + "</td>";
                        testo = testo + "<td>" + row[6] + "</td>";
                        testo = testo + "</tr>";
                    }
                    testo = testo + "</table></pre></html>";
                    da.text.setText(testo);
                    da.text.setEditable(false);
                    da.setLocationRelativeTo(null);
                    System.out.println("anomalie primanotautls " + testo);
                    SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)"Riscontrate anomalie su una o pi\u00f9 fatture, visualizza il dettaglio dalla prossima videata", (String)"Attenzione", (boolean)true);
                    da.setVisible(true);
                }
                QuercusEngine engine = new QuercusEngine();
                engine.setIni("display_errors", "On");
                engine.setIni("log_errors", "On");
                ByteArrayOutputStream ba = new ByteArrayOutputStream();
                engine.setOutputStream((OutputStream)ba);
                Object int1 = "";
                try {
                    sql = "select ragione_sociale, indirizzo, localita, cap, provincia, cfiscale, piva from dati_azienda";
                    Map m = (Map)DbUtils.getListMap((Connection)Db.getConn(), (String)sql).get(0);
                    int1 = (String)int1 + m.get("ragione_sociale") + ", " + m.get("indirizzo") + "\n" + m.get("cap") + " " + m.get("localita") + " (" + m.get("provincia") + ")\nPartita IVA " + m.get("piva") + " Codice Fiscale " + m.get("cfiscale");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                engine.getQuercus().setServerEnv("azienda", (String)int1);
                engine.getQuercus().setServerEnv("dal", FormatUtils.formatMysqlDate((Object)frmStampaRegistroIva.this.dal.getDate()));
                engine.getQuercus().setServerEnv("al", FormatUtils.formatMysqlDate((Object)frmStampaRegistroIva.this.al.getDate()));
                engine.getQuercus().setServerEnv("dal-ita", DateUtils.formatDateIta((Date)frmStampaRegistroIva.this.dal.getDate()));
                engine.getQuercus().setServerEnv("al-ita", DateUtils.formatDateIta((Date)frmStampaRegistroIva.this.al.getDate()));
                String tipo = "";
                tipo = this.padre.radMensile.isSelected() ? " - Mensile" : (this.padre.radTrimestrale.isSelected() ? " - Trimestrale" : (this.padre.radAnnuale.isSelected() ? " - Annuale" : ""));
                engine.getQuercus().setServerEnv("tipo", tipo);
                engine.getQuercus().setServerEnv("data", cu.s((Object)frmStampaRegistroIva.this.comData.getSelectedIndex()));
                engine.getQuercus().setServerEnv("ivaACreditoPeriodoPrec", String.valueOf(it.tnx.Util.getDouble(frmStampaRegistroIva.this.texIvaPrecedente.getText())));
                engine.getQuercus().setServerEnv("tipo_numero_pagina", String.valueOf(frmStampaRegistroIva.this.tipo_numero_pagina.getSelectedIndex()));
                engine.getQuercus().setServerEnv("pagina_start", frmStampaRegistroIva.this.progressivo.getText());
                engine.getQuercus().setServerEnv("anno", frmStampaRegistroIva.this.texAnno.getText() + "/");
                File tmp = new File(System.getProperty("user.home") + File.separator + ".invoicex" + File.separator + "tmp");
                tmp.mkdir();
                File fout = new File(System.getProperty("user.home") + File.separator + ".invoicex" + File.separator + "tmp" + File.separator + "regiva.html");
                File fout_h = new File(System.getProperty("user.home") + File.separator + ".invoicex" + File.separator + "tmp" + File.separator + "regiva_header.html");
                File fout_f = new File(System.getProperty("user.home") + File.separator + ".invoicex" + File.separator + "tmp" + File.separator + "regiva_footer.html");
                if (main.debug) {
                    // empty if block
                }
                String script = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/gestioneFatture/primaNota/php/regiva.php"));
                engine.execute(script);
                frmStampaRegistroIva.this.copyOut(ba, fout);
                FileUtils.copyFile((File)fout, (File)fileXls);
                script = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/gestioneFatture/primaNota/php/regiva_header.php"));
                engine.execute(script);
                frmStampaRegistroIva.this.copyOut(ba, fout_h);
                script = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/gestioneFatture/primaNota/php/regiva_footer.php"));
                engine.execute(script);
                frmStampaRegistroIva.this.copyOut(ba, fout_f);
                frmStampaRegistroIva.this.creaPdf(fout_h, fout_f, fout);
                if (this.xls) {
                    SwingUtils.open((File)fileXls);
                }
                SwingUtils.open((File)filePdf);
            }
            catch (QuercusLanguageException qe) {
                qe.printStackTrace();
                SwingUtils.showExceptionMessage((Component)this.padre, (Exception)((Object)qe));
            }
            catch (QuercusErrorException qe) {
                qe.printStackTrace();
                SwingUtils.showExceptionMessage((Component)this.padre, (Exception)((Object)qe));
            }
            catch (Exception e) {
                e.printStackTrace();
                SwingUtils.showExceptionMessage((Component)this.padre, (Exception)e);
            }
            finally {
                dialog.setVisible(false);
                return null;
            }
        }

        @Override
        public void finished() {
            try {
                Object ret = this.get();
                System.out.println("ret = " + ret);
            }
            catch (Exception e) {
                SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)e);
            }
            this.padre.setCursor(new Cursor(0));
        }

        private Short accodaXls(ResultSet rs, HSSFSheet sheet, Map colonne, HSSFWorkbook wb) {
            try {
                short contarows = 0;
                HSSFDataFormat format = wb.createDataFormat();
                HSSFRow row = sheet.createRow((int)contarows);
                contarows = (short)(contarows + 1);
                row.createCell(0).setCellValue(frmStampaRegistroIva.this.title);
                row = sheet.createRow((int)contarows);
                contarows = (short)(contarows + 1);
                row = sheet.createRow((int)contarows);
                contarows = (short)(contarows + 1);
                row.createCell(0).setCellValue(sheet.getSheetName());
                row = sheet.createRow((int)contarows);
                contarows = (short)(contarows + 1);
                row = sheet.createRow((int)contarows);
                contarows = (short)(contarows + 1);
                int columns = 0;
                columns = rs.getMetaData().getColumnCount();
                Iterator iter = colonne.keySet().iterator();
                short i = 0;
                while (iter.hasNext()) {
                    Object key = iter.next();
                    Object value = colonne.get(key);
                    String col = "";
                    col = (String)value;
                    if (col == null || col.length() == 0) {
                        col = (String)key;
                    }
                    row.createCell(i).setCellValue(col);
                    i = (short)(i + 1);
                }
                HSSFCellStyle styledouble = wb.createCellStyle();
                styledouble.setDataFormat(format.getFormat("#,##0.00###"));
                HSSFCellStyle styleint = wb.createCellStyle();
                styleint.setDataFormat(format.getFormat("#,##0"));
                HSSFCellStyle styledata = wb.createCellStyle();
                styledata.setDataFormat(format.getFormat("dd/MM/yy"));
                int rowcount = 0;
                rs.last();
                rowcount = rs.getRow();
                rs.beforeFirst();
                for (int j = 0; j < rowcount; ++j) {
                    row = sheet.createRow((int)contarows);
                    contarows = (short)(contarows + 1);
                    iter = colonne.keySet().iterator();
                    i = 0;
                    while (iter.hasNext()) {
                        HSSFCell cell;
                        String key = (String)iter.next();
                        String value = (String)colonne.get(key);
                        Object o = null;
                        rs.absolute(j + 1);
                        o = rs.getObject(key);
                        if (o instanceof Double) {
                            cell = row.createCell(i);
                            cell.setCellValue(((Double)o).doubleValue());
                            cell.setCellStyle(styledouble);
                        } else if (o instanceof BigDecimal) {
                            cell = row.createCell(i);
                            cell.setCellValue(((BigDecimal)o).doubleValue());
                            cell.setCellStyle(styledouble);
                        } else if (o instanceof Integer) {
                            cell = row.createCell(i);
                            cell.setCellValue((double)((Integer)o).intValue());
                            cell.setCellStyle(styleint);
                        } else if (o instanceof java.sql.Date) {
                            cell = row.createCell(i);
                            cell.setCellValue((Date)((java.sql.Date)o));
                            cell.setCellStyle(styledata);
                        } else if (o instanceof byte[]) {
                            cell = row.createCell(i);
                            cell.setCellValue(new String((byte[])o));
                            cell.setCellStyle(styleint);
                            row.createCell(i).setCellValue(new String((byte[])o));
                        } else if (o instanceof Long) {
                            cell = row.createCell(i);
                            cell.setCellValue((double)((Long)o).longValue());
                            cell.setCellStyle(styleint);
                        } else {
                            if (!(o instanceof String) && o != null) {
                                System.out.println(o.getClass());
                            }
                            row.createCell(i).setCellValue(CastUtils.toString((Object)o));
                        }
                        i = (short)(i + 1);
                    }
                }
                row = sheet.createRow((int)contarows);
                contarows = (short)(contarows + 1);
                row = sheet.createRow((int)contarows);
                row.createCell(7).setCellValue("Totali");
                row.createCell(8).setCellFormula("SUM(I1:I" + contarows + ")");
                row.getCell(8).setCellStyle(styledouble);
                row.createCell(9).setCellFormula("SUM(J1:J" + contarows + ")");
                row.getCell(9).setCellStyle(styledouble);
                row.createCell(10).setCellFormula("SUM(K1:K" + contarows + ")");
                row.getCell(10).setCellStyle(styledouble);
                row.createCell(11).setCellFormula("SUM(L1:L" + contarows + ")");
                row.getCell(11).setCellStyle(styledouble);
                row.createCell(12).setCellFormula("SUM(M1:M" + contarows + ")");
                row.getCell(12).setCellStyle(styledouble);
                row.createCell(13).setCellFormula("SUM(N1:N" + contarows + ")");
                row.getCell(13).setCellStyle(styledouble);
                row.createCell(14).setCellFormula("SUM(O1:O" + contarows + ")");
                row.getCell(14).setCellStyle(styledouble);
                row.createCell(15).setCellFormula("SUM(P1:P" + contarows + ")");
                row.getCell(15).setCellStyle(styledouble);
                row.createCell(16).setCellFormula("SUM(Q1:Q" + contarows + ")");
                row.getCell(16).setCellStyle(styledouble);
                row.createCell(17).setCellFormula("SUM(R1:R" + contarows + ")");
                row.getCell(17).setCellStyle(styledouble);
                row.createCell(18).setCellFormula("SUM(S1:S" + contarows + ")");
                row.getCell(18).setCellStyle(styledouble);
                row.createCell(19).setCellFormula("SUM(T1:T" + contarows + ")");
                row.getCell(19).setCellStyle(styledouble);
                row.createCell(20).setCellFormula("SUM(U1:U" + contarows + ")");
                row.getCell(20).setCellStyle(styledouble);
                row.createCell(21).setCellFormula("SUM(V1:V" + contarows + ")");
                row.getCell(21).setCellStyle(styledouble);
                contarows = (short)(contarows + 1);
                return contarows;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        private boolean accodaXlsTotali(double creditoPeriodoPrec, HSSFSheet sheet, HSSFWorkbook wb, short row_tot_acq, short row_tot_ven, Map params) {
            try {
                int contarows = 0;
                HSSFDataFormat format = wb.createDataFormat();
                HSSFCellStyle styledouble = wb.createCellStyle();
                styledouble.setDataFormat(format.getFormat("#,##0.00###"));
                FormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
                HSSFRow row = sheet.createRow(contarows);
                contarows = (short)(contarows + 1);
                row = sheet.createRow(contarows);
                contarows = (short)(contarows + 1);
                row = sheet.createRow(contarows);
                contarows = (short)(contarows + 1);
                row.createCell(1).setCellValue("Iva per Fatture di vendita");
                row.createCell(2).setCellFormula("'Fatture di vendita'!K" + row_tot_ven + " + 'Fatture di vendita'!M" + row_tot_ven + " + 'Fatture di vendita'!O" + row_tot_ven + " + 'Fatture di vendita'!Q" + row_tot_ven + " + 'Fatture di vendita'!S" + row_tot_ven);
                evaluator.evaluateFormulaCell((Cell)row.getCell(2));
                row.getCell(2).setCellStyle(styledouble);
                row = sheet.createRow(contarows);
                contarows = (short)(contarows + 1);
                row.createCell(1).setCellValue("Iva per Fatture di acquisto");
                row.createCell(2).setCellFormula("'Fatture di acquisto'!K" + row_tot_acq + " + 'Fatture di acquisto'!M" + row_tot_acq + " + 'Fatture di acquisto'!O" + row_tot_acq + " + 'Fatture di acquisto'!Q" + row_tot_acq + " + 'Fatture di acquisto'!S" + row_tot_acq);
                evaluator.evaluateFormulaCell((Cell)row.getCell(2));
                row.getCell(2).setCellStyle(styledouble);
                row = sheet.createRow(contarows);
                contarows = (short)(contarows + 1);
                row.createCell(1).setCellFormula("CONCATENATE(\"Iva a \",IF((C3-C4) >= 0, \"debito\", \"credito\"))");
                row.createCell(2).setCellFormula("ABS(C3-C4)");
                evaluator.evaluateFormulaCell((Cell)row.getCell(2));
                row.getCell(2).setCellStyle(styledouble);
                row = sheet.createRow(contarows);
                contarows = (short)(contarows + 1);
                row.createCell(1).setCellValue("Iva a credito da periodo precedente");
                row.createCell(2).setCellValue(((Double)params.get("ivaACreditoPeriodoPrec")).doubleValue());
                row.getCell(2).setCellStyle(styledouble);
                row = sheet.createRow(contarows);
                contarows = (short)(contarows + 1);
                row.createCell(1).setCellFormula("CONCATENATE(\"Iva a \",IF((C5-C6) >= 0, \"debito\", \"credito\"))");
                row.createCell(2).setCellFormula("ABS(C5-C6)");
                evaluator.evaluateFormulaCell((Cell)row.getCell(2));
                row.getCell(2).setCellStyle(styledouble);
                sheet.autoSizeColumn(1);
                sheet.autoSizeColumn(2);
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
    }

    private class FormListener
    implements ActionListener,
    FocusListener,
    KeyListener,
    PropertyChangeListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == frmStampaRegistroIva.this.butConferma) {
                frmStampaRegistroIva.this.butConfermaActionPerformed(evt);
            } else if (evt.getSource() == frmStampaRegistroIva.this.comPeriodo) {
                frmStampaRegistroIva.this.comPeriodoActionPerformed(evt);
            } else if (evt.getSource() == frmStampaRegistroIva.this.radTrimestrale) {
                frmStampaRegistroIva.this.radTrimestraleActionPerformed(evt);
            } else if (evt.getSource() == frmStampaRegistroIva.this.radMensile) {
                frmStampaRegistroIva.this.radMensileActionPerformed(evt);
            } else if (evt.getSource() == frmStampaRegistroIva.this.radAnnuale) {
                frmStampaRegistroIva.this.radAnnualeActionPerformed(evt);
            } else if (evt.getSource() == frmStampaRegistroIva.this.tipo_numero_pagina) {
                frmStampaRegistroIva.this.tipo_numero_paginaActionPerformed(evt);
            } else if (evt.getSource() == frmStampaRegistroIva.this.radData) {
                frmStampaRegistroIva.this.radDataActionPerformed(evt);
            } else if (evt.getSource() == frmStampaRegistroIva.this.dal) {
                frmStampaRegistroIva.this.dalActionPerformed(evt);
            } else if (evt.getSource() == frmStampaRegistroIva.this.al) {
                frmStampaRegistroIva.this.alActionPerformed(evt);
            } else if (evt.getSource() == frmStampaRegistroIva.this.butNuovaStampa) {
                frmStampaRegistroIva.this.butNuovaStampaActionPerformed(evt);
            }
        }

        @Override
        public void focusGained(FocusEvent evt) {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (evt.getSource() == frmStampaRegistroIva.this.dal) {
                frmStampaRegistroIva.this.dalFocusLost(evt);
            } else if (evt.getSource() == frmStampaRegistroIva.this.al) {
                frmStampaRegistroIva.this.alFocusLost(evt);
            }
        }

        @Override
        public void keyPressed(KeyEvent evt) {
        }

        @Override
        public void keyReleased(KeyEvent evt) {
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            if (evt.getSource() == frmStampaRegistroIva.this.texAnno) {
                frmStampaRegistroIva.this.texAnnoKeyTyped(evt);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == frmStampaRegistroIva.this.dal) {
                frmStampaRegistroIva.this.dalPropertyChange(evt);
            } else if (evt.getSource() == frmStampaRegistroIva.this.al) {
                frmStampaRegistroIva.this.alPropertyChange(evt);
            }
        }
    }
}

