/*
 * Decompiled with CFR 0.152.
 */
package it.tnx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Key;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class DESwPbE {
    private String algorithm = "PBEWithMD5AndDES";
    private byte[] salt = new byte[8];
    private int iterations = 20;
    private SecretKey key;
    private long fileLength;
    private File dataFile;
    private AlgorithmParameterSpec aps;
    private Cipher cipher;
    private Provider sunJce;
    private String passPhrase;

    public void setPassPhrase(String Password) {
        this.passPhrase = Password;
    }

    public String getStringCrypt() {
        try {
            PBEKeySpec ks = new PBEKeySpec(this.passPhrase.toCharArray());
            SecretKeyFactory skf = SecretKeyFactory.getInstance(this.algorithm);
            this.key = skf.generateSecret(ks);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(this.passPhrase.getBytes());
            byte[] digest = md.digest();
            System.arraycopy(digest, 0, this.salt, 0, 8);
            this.aps = new PBEParameterSpec(this.salt, this.iterations);
        }
        catch (Exception e) {
            System.err.println("Security_exception");
            return null;
        }
        try {
            this.cipher = Cipher.getInstance(this.algorithm);
            this.cipher.init(1, (Key)this.key, this.aps);
        }
        catch (Exception e) {
            return null;
        }
        return "";
    }

    public boolean WriteFile(Serializable inObj, String fileName) {
        FileOutputStream out;
        try {
            out = new FileOutputStream(fileName);
            PBEKeySpec ks = new PBEKeySpec(this.passPhrase.toCharArray());
            SecretKeyFactory skf = SecretKeyFactory.getInstance(this.algorithm);
            this.key = skf.generateSecret(ks);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(this.passPhrase.getBytes());
            byte[] digest = md.digest();
            System.arraycopy(digest, 0, this.salt, 0, 8);
            this.aps = new PBEParameterSpec(this.salt, this.iterations);
        }
        catch (Exception e) {
            System.err.println("Security_exception");
            return false;
        }
        try {
            out.write(this.salt);
            ObjectOutputStream s = new ObjectOutputStream(out);
            this.cipher = Cipher.getInstance(this.algorithm);
            this.cipher.init(1, (Key)this.key, this.aps);
            SealedObject so = new SealedObject(inObj, this.cipher);
            s.writeObject(so);
            s.flush();
            out.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Serializable ReadFile(String fileName) throws Exception {
        FileInputStream in = new FileInputStream(fileName);
        in.read(this.salt);
        PBEKeySpec ks = new PBEKeySpec(this.passPhrase.toCharArray());
        SecretKeyFactory skf = SecretKeyFactory.getInstance(this.algorithm);
        this.key = skf.generateSecret(ks);
        this.aps = new PBEParameterSpec(this.salt, this.iterations);
        this.cipher = Cipher.getInstance(this.algorithm);
        this.cipher.init(2, (Key)this.key, this.aps);
        ObjectInputStream s = new ObjectInputStream(in);
        SealedObject so = (SealedObject)s.readObject();
        Serializable retObj = (Serializable)so.getObject(this.cipher);
        in.close();
        return retObj;
    }
}

