/*
 * Decompiled with CFR 0.152.
 */
package it.tnx;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;

public class PrintUtilities
implements Printable {
    private Component componentToBePrinted;
    public Double scala = null;

    public static void printComponent(Component c) {
        new PrintUtilities(c).print();
    }

    public PrintUtilities(Component componentToBePrinted) {
        this.componentToBePrinted = componentToBePrinted;
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        Paper paper = new Paper();
        paper.setSize(595.0, 842.0);
        double margin = 30.0;
        paper.setImageableArea(margin, margin, paper.getWidth() - margin * 2.0, paper.getHeight() - margin * 2.0);
        pageFormat.setPaper(paper);
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        double scala_calc = 0.6;
        if (this.scala != null) {
            scala_calc = this.scala;
        } else {
            double scala_calc_h;
            double scala_calc_w = paper.getImageableWidth() / (double)this.componentToBePrinted.getWidth();
            scala_calc = Math.min(scala_calc_w, scala_calc_h = paper.getImageableHeight() / (double)this.componentToBePrinted.getHeight());
            if (scala_calc > 0.6) {
                scala_calc = 0.6;
            }
        }
        g2d.scale(scala_calc, scala_calc);
        PrintUtilities.disableDoubleBuffering(this.componentToBePrinted);
        this.componentToBePrinted.paint(g2d);
        PrintUtilities.enableDoubleBuffering(this.componentToBePrinted);
        return 0;
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }
}

