/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.dbeans.ResultSet;

import it.tnx.commons.DbUtils;
import it.tnx.dbeans.ResultSet.ResultSetTableModel;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CachingResultSetTableModel
extends ResultSetTableModel {
    public Map<String, Integer> colonne = new HashMap<String, Integer>();
    public ArrayList cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachingResultSetTableModel(ResultSet aResultSet) {
        super(aResultSet);
        try {
            this.cache = new ArrayList();
            int cols = aResultSet.getMetaData().getColumnCount();
            for (int i = 0; i < cols; ++i) {
                this.colonne.put(aResultSet.getMetaData().getColumnName(i + 1), i);
            }
            ResultSet rs = this.getResultSet();
            while (rs.next()) {
                Object[] row = new Object[cols];
                for (int j = 0; j < row.length; ++j) {
                    row[j] = rs.getObject(j + 1);
                }
                this.cache.add(row);
            }
        }
        catch (SQLException e) {
            System.out.println("Error " + e);
        }
        finally {
            try {
                DbUtils.close((ResultSet)aResultSet);
            }
            catch (Exception exception) {}
        }
    }

    public CachingResultSetTableModel(ArrayList rows) {
        super(null);
        this.cache = rows;
    }

    @Override
    public Object getValueAt(int r, int c) {
        if (r < this.cache.size()) {
            return ((Object[])this.cache.get(r))[c];
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int r, int c) {
        try {
            Object[] row = (Object[])this.cache.get(r);
            row[c] = value;
            this.cache.set(r, row);
            super.setValueAt(value, r, c);
        }
        catch (Exception e) {
            e.printStackTrace();
            super.setValueAt(null, r, c);
        }
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    public void addRow() {
        Object[] row = new Object[this.colonne.size()];
        this.cache.add(row);
        this.fireTableRowsInserted(this.cache.size(), this.cache.size());
    }

    public void deleteRow(int id_row) {
        this.cache.remove(id_row);
        this.fireTableRowsDeleted(id_row, id_row);
    }
}

