/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.dbeans.ResultSet;

import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.Overlayable;
import com.jidesoft.swing.OverlayableUtils;
import it.tnx.Db;
import it.tnx.DbI;
import it.tnx.commons.MicroBench;
import it.tnx.commons.dbu;
import it.tnx.commons.swing.DelayedExecutor;
import java.awt.Component;
import java.awt.Window;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.swingworker.SwingWorker;
import org.jdesktop.swingx.JXBusyLabel;

public class LazyResultSetModel
extends DefaultTableModel {
    public String sql;
    DbI db;
    final TreeMap<Integer, Object[]> cache = new TreeMap();
    String[] col_names;
    String[] col_classes;
    int index = 0;
    int rows = 0;
    int cols = 0;
    static int buffersize = 2000;
    JTable table = null;
    boolean evitareOverlay = false;
    PrendiSwingWorker prendi = null;
    int rowIndex;
    private boolean loading = false;
    DelayedExecutor prendidelayed = new DelayedExecutor(new Runnable(){

        @Override
        public void run() {
            LazyResultSetModel.this.prendi.cancel(true);
            LazyResultSetModel.this.prendi = new PrendiSwingWorker(LazyResultSetModel.this.sql, LazyResultSetModel.this.rowIndex);
            LazyResultSetModel.this.prendi.execute();
        }
    }, 150L){

        public void update() {
            super.update();
        }
    };

    public LazyResultSetModel(String sql, DbI db) throws SQLException {
        this(sql, db, null, null);
    }

    public LazyResultSetModel(String sql, DbI db, JTable table, String[] colonne) throws SQLException {
        this.sql = sql;
        this.db = db;
        this.table = table;
        if (colonne != null) {
            super.setColumnIdentifiers(colonne);
        }
        if (table != null) {
            try {
                if (!(table.getParent().getParent().getParent() instanceof Overlayable)) {
                    JScrollPane scroll = (JScrollPane)table.getParent().getParent();
                    JPanel panel = (JPanel)scroll.getParent();
                    Window w = SwingUtilities.getWindowAncestor(table);
                    if (w instanceof JDialog && ((JDialog)w).getContentPane() == panel) {
                        this.evitareOverlay = true;
                    }
                    if (!this.evitareOverlay) {
                        JXBusyLabel jxbusy = new JXBusyLabel();
                        jxbusy.setText("...caricamento...");
                        jxbusy.setBusy(true);
                        DefaultOverlayable over = new DefaultOverlayable((JComponent)new JScrollPane(table));
                        panel.add((Component)over, "Center");
                        panel.revalidate();
                        over.addOverlayComponent((JComponent)jxbusy);
                        over.setOverlayVisible(false);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MicroBench mb = new MicroBench();
        mb.start();
        String sql2 = sql.replaceFirst("(?i)select ", "select SQL_CALC_FOUND_ROWS ");
        sql2 = sql2 + " limit " + buffersize * 2;
        System.out.println("LazyResultSetModel sql2 = " + sql2);
        Statement stat = db.getDbConn().createStatement();
        ResultSet r = stat.executeQuery(sql2);
        ResultSetMetaData m = r.getMetaData();
        this.cols = m.getColumnCount();
        this.col_names = new String[this.cols];
        this.col_classes = new String[this.cols];
        for (int i = 0; i < this.cols; ++i) {
            this.col_names[i] = m.getColumnLabel(i + 1);
            this.col_classes[i] = m.getColumnClassName(i + 1);
        }
        System.out.println("aggiungo: da open");
        int conta = 0;
        while (r.next()) {
            Object[] row = new Object[this.cols];
            for (int icol = 0; icol < this.cols; ++icol) {
                row[icol] = r.getObject(icol + 1);
            }
            this.cache.put(conta, row);
            ++conta;
        }
        r.close();
        ResultSet r2 = stat.executeQuery("SELECT FOUND_ROWS()");
        if (r2.next()) {
            this.rows = r2.getInt(1);
            System.out.println("LazyResultSetModel rows = " + this.rows);
        }
        System.out.println(mb.getDiff("open 1"));
        r2.close();
        stat.close();
        System.out.println(mb.getDiff("open 2"));
    }

    @Override
    public int getRowCount() {
        return this.rows;
    }

    @Override
    public int getColumnCount() {
        return this.cols;
    }

    private void setIsLoading(boolean val) {
        if (!this.evitareOverlay) {
            if (this.table != null && !this.loading && val) {
                OverlayableUtils.getOverlayable((JComponent)this.table).setOverlayVisible(true);
            } else if (this.table != null && this.loading && !val) {
                OverlayableUtils.getOverlayable((JComponent)this.table).setOverlayVisible(false);
            }
        }
        this.loading = val;
    }

    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        this.rowIndex = rowIndex;
        if (rowIndex <= this.index - buffersize || rowIndex >= this.index + buffersize) {
            if (this.prendi == null) {
                this.prendi = new PrendiSwingWorker(this.sql, rowIndex);
                this.prendi.execute();
            } else if (rowIndex <= this.prendi.row - buffersize || rowIndex >= this.prendi.row + buffersize) {
                this.prendidelayed.update();
            }
            return null;
        }
        try {
            return this.cache.get(rowIndex)[columnIndex];
        }
        catch (Exception e0) {
            e0.printStackTrace();
            System.out.println("get rowIndex:" + rowIndex + " index:" + this.index + " cond:" + rowIndex + " <= " + (this.index - buffersize) + " || " + rowIndex + " >= " + (this.index + buffersize));
            try {
                System.out.println("rows:" + this.rows);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                System.out.println("cache:" + this.cache);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                System.out.println("cache.get(rowIndex):" + this.cache.get(rowIndex));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                System.out.println("cache.get(rowIndex)[columnIndex]:" + this.cache.get(rowIndex)[columnIndex]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "?";
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        try {
            return Class.forName(this.col_classes[columnIndex]);
        }
        catch (ClassNotFoundException ex) {
            return Object.class;
        }
    }

    @Override
    public String getColumnName(int column) {
        return this.col_names[column];
    }

    private void prendi(ResultSet r, int i, PrendiSwingWorker worker) throws SQLException {
        int ls;
        int li = i - buffersize;
        if (li < 0) {
            li = 0;
        }
        if ((ls = i + buffersize) > this.rows) {
            ls = this.rows;
        }
        System.out.println("aggiungo: da " + li + " a " + ls);
        for (int conta = 0; conta < ls - li; ++conta) {
            if (worker.isCancelled()) {
                return;
            }
            r.next();
            Object[] row = new Object[this.cols];
            for (int icol = 0; icol < this.cols; ++icol) {
                row[icol] = r.getObject(icol + 1);
            }
            this.cache.put(li + conta, row);
        }
    }

    @Override
    public void removeRow(int row) {
        --this.rows;
        this.cache.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    @Override
    public void addRow(Object[] rowData) {
        ++this.rows;
        Integer max = Collections.max(this.cache.keySet());
        this.cache.put(max + 1, rowData);
        this.fireTableRowsInserted(max + 1, max + 1);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    class PrendiSwingWorker
    extends SwingWorker {
        String sql = null;
        int row;

        private PrendiSwingWorker(String sql, int row) {
            this.sql = sql;
            this.row = row;
            System.out.println("new PrendiSwingWorker row = " + row);
            LazyResultSetModel.this.setIsLoading(true);
        }

        protected Object doInBackground() throws Exception {
            String sql2 = this.sql + " limit " + ((this.row < buffersize ? buffersize : this.row) - buffersize) + ", " + buffersize * 2;
            try {
                if (this.isCancelled()) {
                    return null;
                }
                ResultSet r = Db.openResultSet(Db.getConn(), sql2);
                if (this.isCancelled()) {
                    return null;
                }
                LazyResultSetModel.this.cache.clear();
                LazyResultSetModel.this.prendi(r, this.row, this);
                LazyResultSetModel.this.index = this.row;
                dbu.close((ResultSet)r);
            }
            catch (Exception e) {
                return null;
            }
            return null;
        }

        protected void done() {
            if (!this.isCancelled()) {
                LazyResultSetModel.this.fireTableRowsUpdated(this.row - buffersize, this.row + buffersize);
            }
            LazyResultSetModel.this.setIsLoading(false);
        }
    }
}

