/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.dbeans.pdfPrint;

import com.Ostermiller.util.CSVPrinter;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.html.HtmlWriter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import it.tnx.commons.CastUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class PrintSimpleTable {
    public JTable table;
    public ResultSet rs;
    public NumberFormat f1 = new DecimalFormat(",##0.00###");
    public NumberFormat f2 = new DecimalFormat(",##0");
    public SimpleDateFormat f3 = new SimpleDateFormat("dd/MM/yy");
    public boolean totali = false;
    public boolean non_stampare_valori_ripetuti = false;
    public Integer non_stampare_valori_ripetuti_colonna = null;
    public HSSFWorkbook wb = null;
    public HSSFDataFormat format = null;
    public HSSFCellStyle style_double = null;
    public HSSFCellStyle style_int = null;
    public HSSFCellStyle style_date = null;

    public PrintSimpleTable(JTable table) {
        this.table = table;
        this.init();
    }

    public PrintSimpleTable(ResultSet rs) {
        this.rs = rs;
        this.init();
    }

    private void init() {
        this.wb = new HSSFWorkbook();
        this.style_double = this.wb.createCellStyle();
        this.style_int = this.wb.createCellStyle();
        this.style_date = this.wb.createCellStyle();
        this.format = this.wb.createDataFormat();
        this.style_double.setDataFormat(this.format.getFormat("#,##0.00###"));
        this.style_int.setDataFormat(this.format.getFormat("#,##0"));
        this.style_date.setDataFormat(this.format.getFormat("dd/MM/yy"));
    }

    public String print(String title, int[] headerWidth) {
        return this.print(title, headerWidth, "pdf", "", "");
    }

    public String print(String title, int[] headerWidth, String formato, String note_testa, String note_piede) {
        return this.print(title, headerWidth, formato, note_testa, note_piede, 0);
    }

    public String print(String title, int[] headerWidth, String formato, String note_testa, String note_piede, int font_adjust) {
        this.f1.setGroupingUsed(true);
        this.f2.setGroupingUsed(true);
        String nomeFilePdf = "tempStampa.pdf";
        String nomeFileHtml = "tempStampa.html";
        String nomeFileHtmlXls = "tempStampa.html.xls";
        try {
            Cell tempPdfCell;
            Document document = new Document(PageSize.A4);
            if (formato.equalsIgnoreCase("pdf")) {
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(nomeFilePdf));
            } else if (formato.equalsIgnoreCase("xls")) {
                HtmlWriter writerhtml = HtmlWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(nomeFileHtmlXls));
            } else {
                HtmlWriter htmlWriter = HtmlWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(nomeFileHtml));
            }
            document.addTitle("stampa tabella");
            document.addSubject("stampa tabella");
            document.addKeywords("stampa tabella");
            document.addAuthor("Invoicex");
            document.addHeader("Expires", "0");
            document.open();
            Font bf = new Font(1, (float)(8 + font_adjust), 0);
            Font bfb = new Font(1, (float)(8 + font_adjust), 1);
            BaseFont bfCour = BaseFont.createFont((String)"Courier", (String)"winansi", (boolean)false);
            BaseFont bf_italic = BaseFont.createFont((String)"Helvetica-Oblique", (String)"winansi", (boolean)false);
            BaseFont bf_bold = BaseFont.createFont((String)"Helvetica-Bold", (String)"winansi", (boolean)false);
            BaseFont bf_times = BaseFont.createFont((String)"Times-Roman", (String)"winansi", (boolean)false);
            boolean riga = false;
            double iy = 1.25;
            double y = 4.0;
            Table datatable = this.table != null ? new Table(this.table.getColumnCount()) : new Table(this.rs.getMetaData().getColumnCount());
            datatable.setBorder(0);
            datatable.setPadding(2.0f);
            if (headerWidth != null) {
                datatable.setWidths(headerWidth);
            }
            datatable.setWidth(100.0f);
            datatable.setCellsFitPage(true);
            Phrase intestazione = new Phrase();
            intestazione.add((Object)new Chunk(title, new Font(2, (float)(10 + font_adjust), 1)));
            document.add((Element)intestazione);
            if (note_testa != null && note_testa.length() > 0) {
                intestazione = new Phrase();
                System.out.println("leading:" + intestazione.getLeading());
                intestazione.setLeading(10.0f);
                intestazione.add((Object)new Chunk("\n" + note_testa, new Font(0, (float)(8 + font_adjust), 0)));
                document.add((Element)intestazione);
            }
            int columns = 0;
            columns = this.table != null ? this.table.getColumnCount() : this.rs.getMetaData().getColumnCount();
            for (int i = 0; i < columns; ++i) {
                tempPdfCell = this.table != null ? new Cell((Element)new Phrase(this.table.getColumnName(i), bf)) : new Cell((Element)new Phrase(this.rs.getMetaData().getColumnLabel(i + 1), bf));
                this.set1(tempPdfCell);
                datatable.addCell(tempPdfCell);
            }
            int rowcount = 0;
            if (this.table != null) {
                rowcount = this.table.getRowCount();
            } else {
                this.rs.last();
                rowcount = this.rs.getRow();
                this.rs.beforeFirst();
            }
            Object[] tots = new Object[columns];
            for (int j = 0; j < rowcount; ++j) {
                for (int i = 0; i < columns; ++i) {
                    Object o = null;
                    if (this.table != null) {
                        o = this.table.getValueAt(j, i);
                    } else {
                        this.rs.absolute(j + 1);
                        o = this.rs.getObject(i + 1);
                    }
                    if (o instanceof Double) {
                        tempPdfCell = new Cell((Element)new Phrase(this.f1.format((Double)o), bf));
                        this.set2r(tempPdfCell);
                        tots[i] = CastUtils.toDouble0((Object)tots[i]) + CastUtils.toDouble0((Object)o);
                    } else if (o instanceof BigDecimal) {
                        tempPdfCell = new Cell((Element)new Phrase(this.f1.format((BigDecimal)o), bf));
                        this.set2r(tempPdfCell);
                        tots[i] = CastUtils.toDouble0((Object)tots[i]) + CastUtils.toDouble0((Object)o);
                    } else if (o instanceof Integer) {
                        tempPdfCell = new Cell((Element)new Phrase(this.f2.format((Integer)o), bf));
                        this.set2r(tempPdfCell);
                        tots[i] = CastUtils.toInteger0((Object)tots[i]) + CastUtils.toInteger0((Object)o);
                    } else if (o instanceof Date) {
                        tempPdfCell = new Cell((Element)new Phrase(this.f3.format((Date)o), bf));
                        this.set2r(tempPdfCell);
                    } else if (o instanceof byte[]) {
                        tempPdfCell = new Cell((Element)new Phrase(new String((byte[])o), bf));
                        this.set2r(tempPdfCell);
                    } else if (o instanceof Long) {
                        tempPdfCell = new Cell((Element)new Phrase(this.f2.format((Long)o), bf));
                        this.set2r(tempPdfCell);
                        tots[i] = CastUtils.toDouble0((Object)tots[i]) + CastUtils.toDouble0((Object)o);
                    } else {
                        if (!(o instanceof String) && o != null) {
                            System.out.println(o.getClass().getName());
                        }
                        tempPdfCell = new Cell((Element)new Phrase(PrintSimpleTable.nz(o, ""), bf));
                        this.set2(tempPdfCell);
                    }
                    datatable.addCell(tempPdfCell);
                }
            }
            if (this.totali) {
                tempPdfCell = new Cell((Element)new Phrase("Totale", bfb));
                this.set2r(tempPdfCell);
                datatable.addCell(tempPdfCell);
                for (int i = 1; i < columns; ++i) {
                    Object o = tots[i];
                    if (o instanceof Double) {
                        tempPdfCell = new Cell((Element)new Phrase(this.f1.format((Double)o), bfb));
                        this.set2r(tempPdfCell);
                    } else if (o instanceof BigDecimal) {
                        tempPdfCell = new Cell((Element)new Phrase(this.f1.format((BigDecimal)o), bfb));
                        this.set2r(tempPdfCell);
                    } else if (o instanceof Integer) {
                        tempPdfCell = new Cell((Element)new Phrase(this.f2.format((Integer)o), bfb));
                        this.set2r(tempPdfCell);
                    } else if (o instanceof Long) {
                        tempPdfCell = new Cell((Element)new Phrase(this.f2.format((Long)o), bfb));
                        this.set2r(tempPdfCell);
                    } else {
                        tempPdfCell = new Cell((Element)new Phrase(PrintSimpleTable.nz(o, ""), bfb));
                        this.set2(tempPdfCell);
                    }
                    datatable.addCell(tempPdfCell);
                }
            }
            document.add((Element)datatable);
            if (note_piede != null && note_piede.length() > 0) {
                intestazione = new Phrase();
                intestazione.add((Object)new Chunk(note_piede, new Font(2, (float)(9 + font_adjust), 0)));
                document.add((Element)intestazione);
            }
            document.close();
            return nomeFilePdf;
        }
        catch (Exception err) {
            err.printStackTrace();
            SwingUtils.showErrorMessage(null, (String)err.getMessage());
            return null;
        }
    }

    void set1(Cell tempPdfCell) {
        tempPdfCell.setBackgroundColor(new Color(255, 255, 240));
        tempPdfCell.setBorderColor(new Color(200, 200, 200));
        tempPdfCell.setHorizontalAlignment(1);
    }

    void set2(Cell tempPdfCell) {
        tempPdfCell.setBackgroundColor(new Color(255, 255, 255));
        tempPdfCell.setBorderColor(new Color(200, 200, 200));
        tempPdfCell.setHorizontalAlignment(0);
    }

    void set2r(Cell tempPdfCell) {
        tempPdfCell.setBackgroundColor(new Color(255, 255, 255));
        tempPdfCell.setBorderColor(new Color(200, 200, 200));
        tempPdfCell.setHorizontalAlignment(2);
    }

    public static String nz(String valore, String seNullo) {
        if (valore == null) {
            return seNullo;
        }
        return valore;
    }

    public static String nz(Object valore, String seNullo) {
        if (valore == null) {
            return seNullo;
        }
        return valore.toString();
    }

    public String printExcel(String title, int[] headerWidth, String note_testa, String note_piede) {
        String nomeFileXls = "tempStampa_" + new java.util.Date().getTime() + ".xls";
        try {
            int i;
            HSSFSheet sheet = this.wb.createSheet("invoicex");
            sheet.getPrintSetup().setPaperSize((short)9);
            int contarows = 0;
            HSSFRow row = sheet.createRow(contarows);
            ++contarows;
            row.createCell(0).setCellValue(title);
            if (note_testa != null && note_testa.length() > 0) {
                row = sheet.createRow(contarows);
                row = sheet.createRow(++contarows);
                ++contarows;
                row.createCell(0).setCellValue(note_testa);
            }
            row = sheet.createRow(contarows);
            row = sheet.createRow(++contarows);
            ++contarows;
            int columns = 0;
            columns = this.table != null ? this.table.getColumnCount() : this.rs.getMetaData().getColumnCount();
            if (headerWidth == null && this.table != null) {
                headerWidth = new int[columns];
                for (i = 0; i < columns; ++i) {
                    headerWidth[i] = this.table.getColumnModel().getColumn(i).getWidth() / 7;
                }
            }
            for (i = 0; i < columns; ++i) {
                String col = "";
                col = this.table != null ? this.table.getColumnName(i) : this.rs.getMetaData().getColumnLabel(i + 1);
                row.createCell(i).setCellValue(col);
                if (headerWidth == null) continue;
                sheet.setColumnWidth(i, headerWidth[i] * 300);
            }
            int rowcount = 0;
            if (this.table != null) {
                rowcount = this.table.getRowCount();
            } else {
                this.rs.last();
                rowcount = this.rs.getRow();
                this.rs.beforeFirst();
            }
            HashMap<Integer, Object> oldrow = new HashMap<Integer, Object>();
            for (int j = 0; j < rowcount; ++j) {
                row = sheet.createRow(contarows);
                ++contarows;
                for (int i2 = 0; i2 < columns; ++i2) {
                    Object o = null;
                    if (this.table != null) {
                        o = this.table.getValueAt(j, i2);
                    } else {
                        this.rs.absolute(j + 1);
                        o = this.rs.getObject(i2 + 1);
                    }
                    boolean non_stampare = false;
                    if (this.non_stampare_valori_ripetuti && this.non_stampare_valori_ripetuti_colonna != null) {
                        Object ocol = null;
                        if (this.table != null) {
                            ocol = this.table.getValueAt(j, this.non_stampare_valori_ripetuti_colonna);
                        } else {
                            this.rs.absolute(j + 1);
                            ocol = this.rs.getObject(this.non_stampare_valori_ripetuti_colonna + 1);
                        }
                        if (cu.s((Object)ocol).equals(cu.s(oldrow.get(this.non_stampare_valori_ripetuti_colonna))) && cu.s((Object)o).equals(cu.s(oldrow.get(i2)))) {
                            non_stampare = true;
                        }
                    } else if (this.non_stampare_valori_ripetuti && this.non_stampare_valori_ripetuti_colonna == null && cu.s((Object)o).equals(cu.s(oldrow.get(i2)))) {
                        non_stampare = true;
                    }
                    if (non_stampare) {
                        row.createCell(i2).setCellValue("");
                    } else {
                        this.setCell(o, row, i2);
                    }
                    oldrow.put(i2, o);
                }
            }
            if (note_piede != null && note_piede.length() > 0) {
                row = sheet.createRow(contarows);
                row = sheet.createRow(++contarows);
                ++contarows;
                row.createCell(0).setCellValue(note_piede);
            }
            FileOutputStream fileOut = new FileOutputStream(nomeFileXls);
            this.wb.write((OutputStream)fileOut);
            fileOut.close();
            return nomeFileXls;
        }
        catch (Exception err) {
            JOptionPane.showMessageDialog(null, err.toString());
            err.printStackTrace();
            return null;
        }
    }

    public String printCsv(String title, int[] headerWidth, String note_testa, String note_piede) {
        File dir = new File(System.getProperty("user.home") + File.separator + ".invoicex" + File.separator + "Export");
        dir.mkdirs();
        String nomeFileCsv = System.getProperty("user.home") + File.separator + ".invoicex" + File.separator + "Export" + File.separator + "export_" + new java.util.Date().getTime() + ".csv";
        try {
            CSVPrinter csvp = new CSVPrinter((OutputStream)new FileOutputStream(nomeFileCsv));
            int contarows = 0;
            contarows = (short)(contarows + 1);
            int columns = 0;
            columns = this.table != null ? this.table.getColumnCount() : this.rs.getMetaData().getColumnCount();
            for (int i = 0; i < columns; ++i) {
                String col = "";
                col = this.table != null ? this.table.getColumnName(i) : this.rs.getMetaData().getColumnLabel(i + 1);
                csvp.print(col);
            }
            csvp.println();
            int rowcount = 0;
            if (this.table != null) {
                rowcount = this.table.getRowCount();
            } else {
                this.rs.last();
                rowcount = this.rs.getRow();
                this.rs.beforeFirst();
            }
            for (int j = 0; j < rowcount; ++j) {
                contarows = (short)(contarows + 1);
                for (int i = 0; i < columns; ++i) {
                    Object o = null;
                    if (this.table != null) {
                        o = this.table.getValueAt(j, i);
                    } else {
                        this.rs.absolute(j + 1);
                        o = this.rs.getObject(i + 1);
                    }
                    if (o instanceof Double) {
                        csvp.print(CastUtils.toString((Object)o));
                        continue;
                    }
                    if (o instanceof BigDecimal) {
                        csvp.print(CastUtils.toString((Object)o));
                        continue;
                    }
                    if (o instanceof Integer) {
                        csvp.print(CastUtils.toString((Object)o));
                        continue;
                    }
                    if (o instanceof Date) {
                        csvp.print(CastUtils.toString((Object)o));
                        continue;
                    }
                    if (o instanceof byte[]) {
                        csvp.print(new String((byte[])o));
                        continue;
                    }
                    if (o instanceof Long) {
                        csvp.print(CastUtils.toString((Object)o));
                        continue;
                    }
                    if (!(o instanceof String) && o != null) {
                        System.out.println(o.getClass());
                    }
                    csvp.print(PrintSimpleTable.nz(o, ""));
                }
                csvp.println();
            }
            csvp.close();
            return nomeFileCsv;
        }
        catch (Exception err) {
            JOptionPane.showMessageDialog(null, err.toString());
            err.printStackTrace();
            return null;
        }
    }

    public void setCell(Object o, HSSFRow row, int i) {
        if (o instanceof Double) {
            HSSFCell cell = row.createCell(i);
            cell.setCellValue(((Double)o).doubleValue());
            cell.setCellStyle(this.style_double);
        } else if (o instanceof BigDecimal) {
            HSSFCell cell = row.createCell(i);
            cell.setCellValue(((BigDecimal)o).doubleValue());
            cell.setCellStyle(this.style_double);
        } else if (o instanceof Integer) {
            HSSFCell cell = row.createCell(i);
            cell.setCellValue((double)((Integer)o).intValue());
            cell.setCellStyle(this.style_int);
        } else if (o instanceof Date) {
            HSSFCell cell = row.createCell(i);
            cell.setCellValue((java.util.Date)((Date)o));
            cell.setCellStyle(this.style_date);
        } else if (o instanceof byte[]) {
            HSSFCell cell = row.createCell(i);
            cell.setCellValue(new String((byte[])o));
            cell.setCellStyle(this.style_int);
            row.createCell(i).setCellValue(new String((byte[])o));
        } else if (o instanceof Long) {
            HSSFCell cell = row.createCell(i);
            cell.setCellValue((double)((Long)o).longValue());
            cell.setCellStyle(this.style_int);
        } else {
            if (!(o instanceof String) && o != null) {
                System.out.println(o.getClass());
            }
            row.createCell(i).setCellValue(PrintSimpleTable.nz(o, ""));
        }
    }
}

