/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.dbf;

import com.mindprod.ledatastream.LEDataInputStream;
import it.tnx.Checks;
import it.tnx.dbf.DbfField;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DbfTable {
    private static final short debug = 1;
    protected long recSize = 0L;
    protected long recCount = 0L;
    protected long currentRecord = 0L;
    public boolean isCurrentRecordDeleted = false;
    protected int fieldsCount = 0;
    private DbfField[] fields;
    private String tableName;
    private Object[] record;
    private LEDataInputStream ledis;
    private boolean eof = false;

    public DbfTable(String fileName, String tableName) {
        this.tableName = tableName;
        try {
            DbfTable.print("********************************************************************************");
            DbfTable.print("********************************************************************************");
        }
        catch (Exception err) {
            DbfTable.print("********************************************************************************");
            err.printStackTrace();
        }
        try {
            this.ledis = new LEDataInputStream(new FileInputStream(fileName));
            DbfTable.print("00:" + DbfTable.hexDump(this.ledis.readByte()));
            DbfTable.print("01:" + DbfTable.hexDump(this.ledis.readByte()));
            DbfTable.print("02:" + DbfTable.hexDump(this.ledis.readByte()));
            DbfTable.print("03:" + DbfTable.hexDump(this.ledis.readByte()));
            DbfTable.print("04-07:" + this.ledis.readInt());
            short tempBytesHeader = this.ledis.readShort();
            this.fieldsCount = (tempBytesHeader - 1) / 32 - 1;
            DbfTable.print("08-09:" + tempBytesHeader);
            DbfTable.print("fields count:" + this.fieldsCount);
            this.fields = new DbfField[this.fieldsCount];
            this.record = new Object[this.fieldsCount];
            short tempBytesRecord = this.ledis.readShort();
            DbfTable.print("10-11:" + tempBytesRecord);
            DbfTable.print("12-13:" + DbfTable.hexDump(this.ledis.readByte()) + " " + DbfTable.hexDump(this.ledis.readByte()));
            DbfTable.print("14:" + DbfTable.hexDump(this.ledis.readByte()));
            DbfTable.print("15:" + DbfTable.hexDump(this.ledis.readByte()));
            this.ledis.skipBytes(14);
            DbfTable.print("30-31:" + DbfTable.hexDump(this.ledis.readByte()) + " " + DbfTable.hexDump(this.ledis.readByte()));
            for (int fc = 0; fc < this.fieldsCount; ++fc) {
                this.fields[fc] = new DbfField();
                this.fields[fc].name = new String(DbfTable.readBytes(this.ledis, 11));
                this.fields[fc].name = this.fields[fc].name.substring(0, 8);
                this.fields[fc].type = new String(DbfTable.readBytes(this.ledis, 1));
                this.ledis.skipBytes(4);
                int len = this.ledis.readByte();
                if (len < 0) {
                    len = 256 + len;
                }
                this.fields[fc].length = new Integer(len).shortValue();
                this.recSize += (long)len;
                this.fields[fc].decimalPlaces = new Byte(this.ledis.readByte()).shortValue();
                this.ledis.skipBytes(2);
                this.ledis.skipBytes(1);
                this.ledis.skipBytes(10);
                this.ledis.skipBytes(1);
                DbfTable.print("f" + fc + ":" + this.fields[fc].name + " type:" + this.fields[fc].type + " lenBytes:" + this.fields[fc].length + " dec:" + this.fields[fc].decimalPlaces);
            }
            this.ledis.skipBytes(1);
            DbfTable.print("totale record size:" + this.recSize);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public String getSqlCreateTable() {
        if (this.fields.length > 0) {
            String sql = "create table " + this.tableName + " (";
            for (int i = 0; i < this.fields.length - 1; ++i) {
                sql = sql + this.fields[i].getSqlCreate() + ",";
            }
            sql = sql + this.fields[this.fields.length - 1].getSqlCreate() + "\n";
            sql = sql + ")";
            return sql;
        }
        System.out.println("Warning, fields length = 0");
        return null;
    }

    public synchronized boolean next() {
        if (!this.eof) {
            try {
                byte deleted = this.ledis.readByte();
                this.isCurrentRecordDeleted = deleted == 42;
                if (deleted != 26) {
                    for (int fc = 0; fc < this.fieldsCount; ++fc) {
                        if (this.fields[fc].type.equals("C")) {
                            this.record[fc] = new String(DbfTable.readBytes(this.ledis, this.fields[fc].length));
                            continue;
                        }
                        if (this.fields[fc].type.equals("D")) {
                            this.record[fc] = new String(DbfTable.readBytes(this.ledis, this.fields[fc].length));
                            continue;
                        }
                        if (this.fields[fc].type.equals("F")) {
                            this.record[fc] = new String(DbfTable.readBytes(this.ledis, this.fields[fc].length));
                            continue;
                        }
                        if (this.fields[fc].type.equals("N")) {
                            this.record[fc] = new String(DbfTable.readBytes(this.ledis, this.fields[fc].length));
                            continue;
                        }
                        if (this.fields[fc].type.equals("M")) {
                            String temp = new String(DbfTable.readBytes(this.ledis, this.fields[fc].length)).trim();
                            this.record[fc] = temp;
                            if (temp.length() <= 0) continue;
                            try {
                                File f = new File("/mnt/tnx/tnx/lavori/COMETA/Reports/archiviAdhoc/CLI_ENTI.FPT");
                                RandomAccessFile raf = new RandomAccessFile(f, "r");
                                int byteBlock = 512 + Integer.parseInt(temp) * 64;
                                raf.seek(byteBlock + 8);
                                byte[] b = new byte[56];
                                raf.read(b);
                                System.out.println("block=" + temp + ":byteBlock=" + byteBlock + ":" + new String(b));
                                raf.close();
                            }
                            catch (IOException iOException) {}
                            continue;
                        }
                        if (this.fields[fc].type.equals("V")) {
                            this.record[fc] = new String(DbfTable.readBytes(this.ledis, this.fields[fc].length));
                            continue;
                        }
                        if (this.fields[fc].type.equals("P")) {
                            this.record[fc] = new String(DbfTable.readBytes(this.ledis, this.fields[fc].length));
                            continue;
                        }
                        if (this.fields[fc].type.equals("B")) {
                            this.record[fc] = new String(DbfTable.readBytes(this.ledis, this.fields[fc].length));
                            continue;
                        }
                        if (this.fields[fc].type.equals("G")) {
                            this.record[fc] = new String(DbfTable.readBytes(this.ledis, this.fields[fc].length));
                            continue;
                        }
                        System.out.println("!!! !!! da gestire:" + this.fields[fc].type);
                        this.record[fc] = new String(DbfTable.readBytes(this.ledis, this.fields[fc].length));
                    }
                    ++this.currentRecord;
                    return true;
                }
                this.eof = true;
                return false;
            }
            catch (EOFException err) {
                System.out.println("DbfTable::Eof");
                this.eof = true;
                return false;
            }
            catch (Exception err) {
                err.printStackTrace();
                this.eof = true;
                return false;
            }
        }
        return false;
    }

    public String getSqlInsertRecord() {
        if (this.fields.length > 0) {
            int i;
            String sql = "insert into " + this.tableName + " (";
            for (i = 0; i < this.fields.length - 1; ++i) {
                sql = sql + DbfTable.getFieldName(this.fields[i].name.trim()) + ",";
            }
            sql = sql + this.fields[this.fields.length - 1].name.trim();
            sql = sql + ") values (";
            for (i = 0; i < this.record.length - 1; ++i) {
                sql = sql + DbfTable.pc(String.valueOf(this.record[i]).trim(), this.fields[i].type) + ",";
            }
            sql = sql + DbfTable.pc(String.valueOf(this.record[this.fields.length - 1]).trim(), this.fields[this.fields.length - 1].type);
            sql = sql + ")";
            return sql;
        }
        System.out.println("Warning, fields length = 0");
        return null;
    }

    protected void finalize() {
        try {
            this.ledis.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private static void print(String s) {
        System.out.println(s);
    }

    private static String hexDump(byte b) {
        String t = Integer.toHexString(b);
        if (t.length() == 1) {
            return "0x0" + t;
        }
        return "0x" + t;
    }

    private static byte[] readBytes(DataInput dis, int howmany) {
        byte[] b = new byte[howmany];
        try {
            for (int i = 0; i < howmany; ++i) {
                b[i] = dis.readByte();
            }
        }
        catch (EOFException eofErr) {
            System.out.println("DbfTable:readBytes::EOF");
        }
        catch (IOException err) {
            err.printStackTrace();
        }
        return b;
    }

    public static String aa(String stringa) {
        if (stringa != null && stringa.length() > 0) {
            return DbfTable.replaceChars(stringa, '\'', "''");
        }
        return "";
    }

    public static String pc(String campo, String tipoCampo) {
        if (tipoCampo.equalsIgnoreCase("N")) {
            if (campo.length() == 0) {
                return "null";
            }
            if (Checks.isNumber(campo)) {
                return "(" + campo + ")";
            }
            return "(0)";
        }
        if (tipoCampo.equalsIgnoreCase("C")) {
            return "'" + DbfTable.aa(campo) + "'";
        }
        if (tipoCampo.equalsIgnoreCase("M")) {
            return "'" + DbfTable.aa(campo) + "'";
        }
        if (tipoCampo.equalsIgnoreCase("D")) {
            if (campo.trim().length() == 8) {
                return "'" + campo.substring(0, 4) + "-" + campo.substring(4, 6) + "-" + campo.substring(6) + "'";
            }
            return "0";
        }
        return "'" + DbfTable.aa(campo) + "'";
    }

    public static String nz(String valore, String seNullo) {
        if (valore == null) {
            return seNullo;
        }
        return valore;
    }

    public static String nz(Object valore, String seNullo) {
        if (valore == null) {
            return seNullo;
        }
        return valore.toString();
    }

    public static String replaceChars(String stri, char daTrov, String daMett) {
        int leng = stri.length();
        String prim = "";
        String dopo = "";
        String risu = "";
        int oldI = 0;
        for (int i = 0; i < leng; ++i) {
            if (stri.charAt(i) != daTrov) continue;
            prim = stri.substring(oldI, i);
            risu = risu + prim + daMett;
            oldI = i + 1;
        }
        risu = risu + stri.substring(oldI, leng);
        return risu;
    }

    public static String replaceStrings(String object, String toFind, String toSubstitute) {
        return object.replaceAll("\\" + toFind, toSubstitute);
    }

    public static String getFieldName(String fieldName) {
        return fieldName.trim().replace('\u0000', '_');
    }
}

