/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.gui;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;

public class MyBasicArrowButton
extends BasicArrowButton {
    Color f_shadow = UIManager.getColor("ComboBox.buttonShadow");
    Color f_highlight = UIManager.getColor("ComboBox.buttonHighlight");
    Color f_darkShadow = UIManager.getColor("ComboBox.buttonDarkShadow");

    public MyBasicArrowButton(int direction, Color background, Color shadow, Color darkShadow, Color highlight) {
        super(direction, background, shadow, darkShadow, highlight);
    }

    public MyBasicArrowButton(int direction) {
        super(direction);
    }

    @Override
    public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
        super.paintTriangle(g, x, y, size, direction, isEnabled);
    }

    @Override
    public void paint(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        Color origColor = g.getColor();
        boolean isPressed = this.getModel().isPressed();
        boolean isEnabled = this.isEnabled();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w - 1, h - 1);
        if (this.getBorder() != null && !(this.getBorder() instanceof UIResource)) {
            this.paintBorder(g);
        } else if (isPressed) {
            g.setColor(this.f_shadow);
            g.fillRect(0, 0, w - 1, h - 1);
            g.setColor(this.f_darkShadow);
            g.drawRect(0, 0, w - 1, h - 1);
        } else {
            g.setColor(this.f_highlight);
            g.drawRect(0, 0, w - 1, h - 1);
            g.setColor(this.f_darkShadow);
        }
        if (h < 5 || w < 5) {
            g.setColor(origColor);
            return;
        }
        g.translate(1, 1);
        int size = Math.min((h - 4) / 3, (w - 4) / 3);
        size = Math.max(size, 2);
        this.paintTriangle(g, (w - size) / 2, (h - size) / 2, size, this.direction, isEnabled);
        if (isPressed) {
            g.translate(-1, -1);
        }
        g.setColor(origColor);
    }
}

