/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.importExportAscii;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class CSVFile {
    private File file;
    private BufferedReader reader;
    private String line;
    Vector fields;
    private String fileName;
    private char fieldSeparator;
    private char textDelimiter;
    private int fieldCount;

    public CSVFile(String fileName, char fieldSeparator, char textDelimiter) {
        this.fileName = fileName;
        this.fieldSeparator = fieldSeparator;
        this.textDelimiter = textDelimiter;
        try {
            this.file = new File(fileName);
            this.reader = new BufferedReader(new FileReader(fileName));
        }
        catch (Exception e) {
            throw new RuntimeException("CSVFile: Error opening file named \"" + fileName + "\" for reading");
        }
    }

    public boolean next() {
        if (this.fetchLine()) {
            System.out.println("line=" + this.line);
            System.out.println("---------------------------------------------");
            return true;
        }
        return false;
    }

    private boolean fetchLine() {
        Vector<String> v = new Vector<String>();
        this.line = "";
        try {
            this.line = this.reader.readLine();
            if (this.line != null) {
                String field = "";
                int s = 0;
                int e = 0;
                for (int i = 1; i < this.line.length(); ++i) {
                    if (this.line.charAt(i) != this.fieldSeparator) continue;
                    if (e == 0) {
                        e = i;
                        field = this.line.substring(s, e);
                        v.add(field);
                        s = i + 1;
                        continue;
                    }
                    if (s <= e) continue;
                    e = i;
                    field = this.line.substring(s, e);
                    v.add(field);
                    s = i + 1;
                }
                s = e + 1;
                e = this.line.length();
                field = this.line.substring(s, e);
                v.add(field);
            }
        }
        catch (IOException ioErr) {
            ioErr.printStackTrace();
            return false;
        }
        for (int i = 0; i < v.size(); ++i) {
        }
        this.fields = v;
        this.fieldCount = v.size();
        return this.line != null;
    }

    public String getFieldValue(int i) {
        return this.fields.get(i).toString();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
    }

    public char getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(char fieldSeparator) {
    }

    public char getTextDelimiter() {
        return this.textDelimiter;
    }

    public void setTextDelimiter(char textDelimiter) {
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public void setFieldCount(int fieldCount) {
    }
}

