/*
 * Decompiled with CFR 0.152.
 */
package it.tnx;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;

public class iniFile {
    protected Vector lines;
    protected Vector subjects;
    protected Vector variables;
    protected Vector values;
    public String fileName;
    protected boolean saveOnChange = true;

    public void IniFile(String name) {
    }

    public void IniFile(String name, boolean save) {
        this.saveOnChange = save;
        this.fileName = name;
        if (!new File(name).exists() && !this.createFile()) {
            return;
        }
        this.loadFile();
        this.parseLines();
    }

    public void loadFile() {
        this.lines = new Vector();
        this.subjects = new Vector();
        this.variables = new Vector();
        this.values = new Vector();
        String file = this.apriFileCifrato(this.fileName);
        StringTokenizer tk = new StringTokenizer(file, "\r\n");
        String line = tk.nextElement().toString();
        while (line != null) {
            this.lines.addElement(line.trim());
            try {
                line = tk.nextElement().toString();
            }
            catch (Exception err) {
                line = null;
            }
        }
    }

    protected boolean createFile() {
        try {
            DataOutputStream newFile = new DataOutputStream(new FileOutputStream(this.fileName));
            newFile.writeBytes(";INI File: " + this.fileName + System.getProperty("line.separator"));
            newFile.close();
            return true;
        }
        catch (IOException e) {
            System.out.println("IniFile create failed: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public void parseLines() {
        String currentLine = null;
        String currentSubject = null;
        for (int i = 0; i < this.lines.size(); ++i) {
            currentLine = (String)this.lines.elementAt(i);
            if (this.isaSubject(currentLine)) {
                currentSubject = currentLine.substring(1, currentLine.length() - 1);
                continue;
            }
            if (!this.isanAssignment(currentLine)) continue;
            String assignment = currentLine;
            this.addAssignment(currentSubject, assignment);
        }
    }

    protected boolean addAssignment(String subject, String assignment) {
        int index = assignment.indexOf("=");
        String variable = assignment.substring(0, index);
        String value = assignment.substring(index + 1, assignment.length());
        if (value.length() == 0 || variable.length() == 0) {
            return false;
        }
        return this.addValue(subject, variable, value, false);
    }

    public boolean setValue(String subject, String variable, String value) {
        if (variable.indexOf("pwd") < 0 && variable.indexOf("password") < 0) {
            System.out.println("ini:setValue:" + subject + ":" + variable + ":" + value);
        }
        boolean result = this.addValue(subject, variable, value, true);
        return result;
    }

    protected boolean addValue(String subject, String variable, String value, boolean addToLines) {
        if (subject == null || subject.length() == 0) {
            return false;
        }
        if (variable == null || variable.length() == 0) {
            return false;
        }
        if (!this.subjects.contains(subject)) {
            this.subjects.addElement(subject);
            this.variables.addElement(new Vector());
            this.values.addElement(new Vector());
        }
        int subjectIndex = this.subjects.indexOf(subject);
        Vector subjectVariables = (Vector)this.variables.elementAt(subjectIndex);
        Vector subjectValues = (Vector)this.values.elementAt(subjectIndex);
        if (!subjectVariables.contains(variable)) {
            subjectVariables.addElement(variable);
            subjectValues.addElement(value);
        }
        int variableIndex = subjectVariables.indexOf(variable);
        subjectValues.setElementAt(value, variableIndex);
        if (addToLines) {
            this.setLine(subject, variable, value);
        }
        return true;
    }

    protected boolean isaSubject(String line) {
        return line.startsWith("[") && line.endsWith("]");
    }

    protected void setLine(String subject, String variable, String value) {
        int endOfSubject;
        int lineNumber;
        int subjectLine = this.findSubjectLine(subject);
        if (subjectLine == -1) {
            this.addSubjectLine(subject);
            subjectLine = this.lines.size() - 1;
        }
        if ((lineNumber = this.findAssignmentBetween(variable, subjectLine, endOfSubject = this.endOfSubject(subjectLine))) == -1) {
            this.lines.insertElementAt(variable + "=" + value, endOfSubject);
        } else {
            this.lines.setElementAt(variable + "=" + value, lineNumber);
        }
    }

    protected int findAssignmentLine(String subject, String variable) {
        int start = this.findSubjectLine(subject);
        int end = this.endOfSubject(start);
        return this.findAssignmentBetween(variable, start, end);
    }

    protected int findAssignmentBetween(String variable, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (!((String)this.lines.elementAt(i)).startsWith(variable + "=")) continue;
            return i;
        }
        return -1;
    }

    protected void addSubjectLine(String subject) {
        this.lines.addElement("[" + subject + "]");
    }

    protected int findSubjectLine(String subject) {
        String formattedSubject = "[" + subject + "]";
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = (String)this.lines.elementAt(i);
            if (!formattedSubject.equals(line)) continue;
            return i;
        }
        return -1;
    }

    protected int endOfSubject(int start) {
        int endIndex = start + 1;
        if (start >= this.lines.size()) {
            return this.lines.size();
        }
        for (int i = start + 1; i < this.lines.size(); ++i) {
            if (this.isanAssignment((String)this.lines.elementAt(i))) {
                endIndex = i + 1;
            }
            if (!this.isaSubject((String)this.lines.elementAt(i))) continue;
            return endIndex;
        }
        return endIndex;
    }

    protected boolean isanAssignment(String line) {
        return line.indexOf("=") != -1 && !line.startsWith(";");
    }

    public Vector getLines() {
        return (Vector)this.lines.clone();
    }

    public String[] getVariables(String subject) {
        int index = this.subjects.indexOf(subject);
        if (index != -1) {
            Vector vars = (Vector)this.variables.elementAt(index);
            Object[] v = new String[vars.size()];
            vars.copyInto(v);
            return v;
        }
        String[] v = new String[]{};
        return v;
    }

    public String[] getSubjects() {
        Object[] s = new String[this.subjects.size()];
        this.subjects.copyInto(s);
        return s;
    }

    public String getValue(String subject, String variable) {
        int subjectIndex = this.subjects.indexOf(subject);
        if (subjectIndex == -1) {
            return "";
        }
        Vector valVector = (Vector)this.values.elementAt(subjectIndex);
        Vector varVector = (Vector)this.variables.elementAt(subjectIndex);
        int valueIndex = varVector.indexOf(variable);
        if (valueIndex != -1) {
            return (String)valVector.elementAt(valueIndex);
        }
        return "";
    }

    public void deleteValue(String subject, String variable) {
        int subjectIndex = this.subjects.indexOf(subject);
        if (subjectIndex == -1) {
            return;
        }
        Vector valVector = (Vector)this.values.elementAt(subjectIndex);
        Vector varVector = (Vector)this.variables.elementAt(subjectIndex);
        int valueIndex = varVector.indexOf(variable);
        if (valueIndex != -1) {
            valVector.removeElementAt(valueIndex);
            varVector.removeElementAt(valueIndex);
            int assignmentLine = this.findAssignmentLine(subject, variable);
            if (assignmentLine != -1) {
                this.lines.removeElementAt(assignmentLine);
            }
            if (varVector.size() == 0) {
                this.deleteSubject(subject);
            }
            if (this.saveOnChange) {
                this.saveFile();
            }
        }
    }

    public void deleteSubject(String subject) {
        int subjectIndex = this.subjects.indexOf(subject);
        if (subjectIndex == -1) {
            return;
        }
        this.values.removeElementAt(subjectIndex);
        this.variables.removeElementAt(subjectIndex);
        this.subjects.removeElementAt(subjectIndex);
        int start = this.findSubjectLine(subject);
        int end = this.endOfSubject(start);
        for (int i = start; i < end; ++i) {
            this.lines.removeElementAt(start);
        }
        if (this.saveOnChange) {
            this.saveFile();
        }
    }

    public void saveFile() {
        try {
            String fileCriptato = "";
            System.out.println("ini:start save");
            for (int i = 0; i < this.lines.size(); ++i) {
                fileCriptato = fileCriptato + (String)this.lines.elementAt(i) + System.getProperty("line.separator");
                if (this.lines.elementAt(i).toString().indexOf("pass") < 0 && this.lines.elementAt(i).toString().indexOf("pwd") < 0) {
                    System.out.println("ini:" + i + ":" + this.lines.elementAt(i));
                    continue;
                }
                System.out.println("ini:" + i + ":password:**************");
            }
            System.out.println("ini:end save -------------");
            fileCriptato = iniFile.simpleCrypt(fileCriptato, false);
            DataOutputStream outFile = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.fileName)));
            outFile.write(fileCriptato.getBytes());
            outFile.close();
            System.out.println("ini:saveFile");
        }
        catch (IOException e) {
            System.out.println("IniFile save failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void finalize() {
        this.saveFile();
    }

    public TreeModel getTreeModel() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(this.fileName);
        DefaultMutableTreeNode category = null;
        Object book = null;
        category = new DefaultMutableTreeNode("Books for Java Programmers");
        top.add(category);
        return (TreeModel)((Object)top);
    }

    public static String simpleCrypt(String toCrypt, boolean flagCrypt) {
        char[] crypt = toCrypt.toCharArray();
        char[] passwd = new char[]{'b', 'e', 'r', 'l', 'u', 's', 'o', 'n', 'i', 'c', 'a', 'p', 'o', 'd', 'e', 'l', 'l', 'a', 'm', 'a', 'f', 'i', 'a', '2', '0', '0', '2'};
        char[] out = crypt;
        int ip = 0;
        for (int i = 0; i < toCrypt.length(); ++i) {
            if (i % passwd.length == 0) {
                ip = 0;
            }
            out[i] = flagCrypt ? (char)(crypt[i] ^ passwd[ip]) : (char)(crypt[i] ^ passwd[ip]);
            ++ip;
        }
        return String.valueOf(out);
    }

    boolean scriviFile(String nomeFile, String contenuto) {
        File f = new File(nomeFile);
        try {
            FileOutputStream fout = new FileOutputStream(f);
            DataOutputStream out = new DataOutputStream(fout);
            out.write(contenuto.getBytes());
            out.flush();
            out.close();
            fout.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return true;
    }

    boolean scriviFileCifrato(String nomeFile, String contenuto) {
        File f = new File(nomeFile);
        try {
            FileOutputStream fout = new FileOutputStream(f);
            DataOutputStream out = new DataOutputStream(fout);
            out.write(iniFile.simpleCrypt(contenuto, true).getBytes());
            out.flush();
            out.close();
            fout.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return true;
    }

    public String apriFileCifrato(String nomeFile) {
        try {
            DataInputStream fileInput = new DataInputStream(new URL(nomeFile).openStream());
            String righe = "";
            boolean a = true;
            try {
                while (a) {
                    char in = (char)fileInput.readByte();
                    righe = righe + in;
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            righe = iniFile.simpleCrypt(righe, false);
            return righe;
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    public String apriFile(String nomeFile) {
        try {
            DataInputStream fileInput = new DataInputStream(new FileInputStream(new File(nomeFile)));
            String righe = "";
            boolean a = true;
            try {
                while (a) {
                    char in = (char)fileInput.readByte();
                    righe = righe + in;
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return righe;
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }
}

