/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex;

import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.Util;
import it.tnx.commons.HttpUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.invoicex.data.DatiAzienda;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.ResultSet;
import javax.swing.JOptionPane;

public class Attivazione {
    private boolean datiAziendaInseriti;

    public boolean isFlagDatiInviatiPrimaVolta() {
        String value = main.fileIni.getValue("attivazione", "flagDatiInviatiPrimaVolta");
        return Boolean.parseBoolean(value);
    }

    public void setFlagDatiInviatiPrimaVolta(boolean value) {
        main.fileIni.setValue("attivazione", "flagDatiInviatiPrimaVolta", String.valueOf(value));
    }

    public boolean isFlagDatiModificati() {
        String value = main.fileIni.getValue("attivazione", "flagDatiModificati");
        return Boolean.parseBoolean(value);
    }

    public void setFlagDatiModificati(boolean value) {
        main.fileIni.setValue("attivazione", "flagDatiModificati", String.valueOf(value));
    }

    public Integer getIdRegistrazione() {
        try {
            return Integer.parseInt(main.fileIni.getValue("attivazione", "idRegistrazione"));
        }
        catch (NumberFormatException err1) {
            return null;
        }
    }

    public void setIdRegistrazione(Integer value) {
        main.fileIni.setValue("attivazione", "idRegistrazione", String.valueOf(value));
    }

    public boolean isFlagDatiInviatiSuModifica() {
        return Boolean.parseBoolean(main.fileIni.getValue("attivazione", "flagDatiInviatiSuModifica"));
    }

    public boolean setFlagDatiInviatiSuModifica(boolean value) {
        return main.fileIni.setValue("attivazione", "flagDatiInviatiPrimaVolta", String.valueOf(value));
    }

    public boolean isDatiAziendaInseriti() {
        return this.datiAziendaInseriti;
    }

    public void setDatiAziendaInseriti(boolean datiAziendaInseriti) {
        this.datiAziendaInseriti = datiAziendaInseriti;
    }

    public boolean registra() {
        DatiAzienda dati = this.leggiDatiAzienda();
        if (this.invioReg(dati)) {
            System.out.println("dati inviato ok");
            return true;
        }
        return false;
    }

    public DatiAzienda getDatiAzienda() {
        return this.leggiDatiAzienda();
    }

    private DatiAzienda leggiDatiAzienda() {
        ResultSet r = Db.openResultSet("select ragione_sociale,piva,cfiscale,indirizzo,cap,localita,provincia,telefono,fax,sito_web,email from dati_azienda");
        try {
            r.next();
            DatiAzienda dati = new DatiAzienda();
            dati.setRagione_sociale(r.getString("ragione_sociale"));
            dati.setPartita_iva(r.getString("piva"));
            dati.setCodice_fiscale(r.getString("cfiscale"));
            dati.setIndirizzo(r.getString("indirizzo"));
            dati.setCap(r.getString("cap"));
            dati.setLocalita(r.getString("localita"));
            dati.setProvincia(r.getString("provincia"));
            dati.setTelefono(r.getString("telefono"));
            dati.setFax(r.getString("fax"));
            dati.setSito_web(r.getString("sito_web"));
            dati.setEmail(r.getString("email"));
            dati.setId_registrazione(this.getIdRegistrazione());
            return dati;
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    private boolean invioReg(DatiAzienda dati) {
        String acq = "";
        try {
            acq = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)"select codice from attivazione"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String surl = main.baseurlserver + "/connect2.php?";
            surl = surl + "reg=1";
            surl = surl + "&ver=" + URLEncoder.encode(main.version.toString()) + "";
            surl = surl + "&ver2=" + URLEncoder.encode(main.version.toString() + " " + main.build.toString()) + "";
            surl = surl + "&email=" + URLEncoder.encode(dati.getEmail()) + "";
            surl = surl + "&id_registrazione=" + URLEncoder.encode(Util.nz(main.attivazione.getIdRegistrazione())) + "";
            surl = surl + "&ragione_sociale=" + URLEncoder.encode(dati.getRagione_sociale(), "UTF-8") + "";
            surl = surl + "&partita_iva=" + URLEncoder.encode(dati.getPartita_iva()) + "";
            surl = surl + "&codice_fiscale=" + URLEncoder.encode(dati.getCodice_fiscale()) + "";
            surl = surl + "&indirizzo=" + URLEncoder.encode(dati.getIndirizzo()) + "";
            surl = surl + "&cap=" + URLEncoder.encode(dati.getCap()) + "";
            surl = surl + "&localita=" + URLEncoder.encode(dati.getLocalita()) + "";
            surl = surl + "&provincia=" + URLEncoder.encode(dati.getProvincia()) + "";
            surl = surl + "&telefono=" + URLEncoder.encode(dati.getTelefono()) + "";
            surl = surl + "&fax=" + URLEncoder.encode(dati.getFax()) + "";
            surl = surl + "&sito_web=" + URLEncoder.encode(dati.getSito_web());
            surl = surl + "&os=" + URLEncoder.encode(System.getProperty("os.name"));
            surl = surl + "&acq=" + URLEncoder.encode(acq);
            URL url = new URL(surl);
            String content = HttpUtils.getUrlToStringUTF8((String)surl);
            System.out.println("attivazione: response: " + content);
            if (content == null || content.trim().length() == 0) {
                JOptionPane.showMessageDialog(main.getPadreWindow(), "Errore nella richiesta di registrazione");
                return false;
            }
            String[] splitted = content.split("\\n");
            for (int i = 0; i < splitted.length; ++i) {
                String s = splitted[i];
                String[] splitted2 = s.split(":");
                if (splitted2[0].equalsIgnoreCase("error")) {
                    JOptionPane.showMessageDialog(main.getPadreWindow(), "Errore durante la registrazione: " + splitted2[1], "Errore", 0);
                    return false;
                }
                if (!splitted2[0].equalsIgnoreCase("id")) continue;
                main.attivazione.setIdRegistrazione(Integer.parseInt(splitted2[1]));
                return true;
            }
            return false;
        }
        catch (Exception err) {
            err.printStackTrace();
            JOptionPane.showMessageDialog(main.getPadreWindow(), "<html>Sembra che non sei collegato ad internet, la prima volta che usi il programma devi essere collegato.<br>Errore durante la registrazione: " + err.toString() + "</html>", "Errore", 0);
            return false;
        }
    }
}

