/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex;

import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.Util;
import it.tnx.commons.DbVersion;
import it.tnx.commons.DebugFastUtils;
import it.tnx.commons.MicroBench;
import it.tnx.commons.RunnableWithArgs;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.invoicex.InvoicexUtil;
import it.tnx.invoicex.PlatformUtils;
import it.tnx.invoicex.sync.Sync;
import it.tnx.invoicex2.InvoicexUtil2;
import it.tnx.shell.CurrentDir;
import java.awt.Component;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DbVersionChanges {
    DbVersion dbv = null;
    Exception excLock = null;
    public int lastId;

    public DbVersionChanges(String modulo) throws Exception {
        this(modulo, null);
    }

    public DbVersionChanges(String modulo, RunnableWithArgs showAttesa) throws Exception {
        try {
            if (!dbu.existColumn((Connection)Db.getConn(), (String)"db_version", (String)"running_chi")) {
                dbu.tryExecQuery((Connection)Db.getConn(), (String)"alter table db_version add \t`running_chi` VARCHAR(100) NULL DEFAULT NULL");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)e, (String)"Errore in aggiornamento struttura database\ndb_version, campo mancante running_chi\nContattare l'assistenza");
        }
        try {
            if (!dbu.existColumn((Connection)Db.getConn(), (String)"db_version", (String)"running_quando")) {
                dbu.tryExecQuery((Connection)Db.getConn(), (String)"alter table db_version add \t`running_quando` TIMESTAMP NULL DEFAULT NULL");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)e, (String)"Errore in aggiornamento struttura database\ndb_version, campo mancante running_quando\nContattare l'assistenza");
        }
        this.dbv = new DbVersion(Db.getConn(), modulo, showAttesa);
        this.excLock = new Exception("Impossibile apportare le modifiche\n" + DebugFastUtils.dumpAsString((Object)this.dbv.running));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean esegui() throws Exception {
        Connection conn = null;
        try {
            String[] tabs;
            String[] tabs2;
            conn = Db.getConnection();
            Integer id = 2;
            String sql = null;
            if (this.dbv.getVersion() < id) {
                if (!dbu.existColumn((Connection)conn, (String)"righ_ddt_acquisto_matricole", (String)"id_padre_righe")) {
                    if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                    conn.setAutoCommit(false);
                    System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                    for (String tab : tabs2 = new String[]{"righ_ddt_acquisto_matricole", "righ_ddt_matricole", "righ_fatt_acquisto_matricole", "righ_fatt_matricole"}) {
                        String nomeFileDump = CurrentDir.getCurrentDir() + "/backup/tab_" + tab;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmm");
                        Date d = new Date();
                        nomeFileDump = nomeFileDump + "_" + sdf.format(d) + ".txt";
                        FileOutputStream fos = new FileOutputStream(nomeFileDump, false);
                        Util.dumpTable(tab, Db.getConn(), fos);
                        System.out.println(tab + " : dumped");
                        fos.close();
                        dbu.tryExecQuery((Connection)conn, (String)("ALTER TABLE `" + tab + "`\n\tADD COLUMN `id_padre_righe` INT NULL DEFAULT NULL"), (boolean)false);
                        dbu.tryExecQuery((Connection)conn, (String)("update " + tab + " m join " + StringUtils.substringBefore((String)tab, (String)"_matricole") + " r on m.id_padre = r.id_padre and m.riga = r.riga set m.id_padre_righe = r.id"), (boolean)false);
                        dbu.tryExecQuery((Connection)conn, (String)("delete from `" + tab + "` where id_padre_righe is null"), (boolean)false);
                        dbu.tryExecQuery((Connection)conn, (String)("ALTER TABLE `" + tab + "`\n\tCHANGE COLUMN `serie` `serie_old` CHAR(1),\n\tCHANGE COLUMN `numero` `numero_old` INT,\n\tCHANGE COLUMN `anno` `anno_old` INT,\n\tCHANGE COLUMN `riga` `riga_old` INT,\n\tCHANGE COLUMN `id_padre` `id_padre_old` INT"), (boolean)false);
                    }
                    this.dbv.setVersion(conn, id);
                    this.dbv.rimuoviPrenotazioneChanges(conn);
                    conn.commit();
                } else {
                    this.dbv.setVersion(conn, id);
                }
            }
            id = 3;
            if (this.dbv.getVersion() < id) {
                if (!dbu.existColumn((Connection)conn, (String)"dati_azienda", (String)"export_fatture_esig_diff_iva")) {
                    if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                    conn.setAutoCommit(false);
                    System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                    dbu.tryExecQuery((Connection)conn, (String)"ALTER TABLE `dati_azienda` ADD COLUMN `export_fatture_esig_diff_iva` char(1) NULL NULL", (boolean)false);
                    this.dbv.setVersion(conn, id);
                    this.dbv.rimuoviPrenotazioneChanges(conn);
                    conn.commit();
                } else {
                    this.dbv.setVersion(conn, id);
                }
            }
            this.sql(conn, 4, 120, "ALTER TABLE `pagamenti`\tADD COLUMN `rid` CHAR(1) NULL DEFAULT 'N' AFTER `riba`;");
            this.sql(conn, 5, 30, "CREATE TABLE `test_fatt_acquisto_iva_ded` (\n\t`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,\n\t`id_padre` INT(10) UNSIGNED NOT NULL DEFAULT '0',\n\t`codice_iva` CHAR(3) NOT NULL DEFAULT '',\n\t`perc_deducibile` DOUBLE NULL DEFAULT NULL,\n\t`perc_iva` DECIMAL(5,2) NOT NULL DEFAULT '0.00',\n\t`imponibile` DECIMAL(15,5) NOT NULL DEFAULT '0.00000',\n\t`iva` DECIMAL(15,5) NOT NULL DEFAULT '0.00000',\n\t`totale` DECIMAL(15,5) NOT NULL DEFAULT '0.00000',\n\tPRIMARY KEY (`id`),\n\tUNIQUE INDEX `id_padre_codice_iva` (`id_padre`, `codice_iva`, `perc_deducibile`)\n)\nCOLLATE='utf8_general_ci'\nENGINE=" + Sync.getDbEngine("test_fatt_acquisto_iva_ded"));
            this.sql(conn, 6, 30, "update test_fatt_acquisto set ts_gen_totali = null");
            id = 7;
            if (this.dbv.getVersion() < id) {
                if (!dbu.existColumn((Connection)conn, (String)"dati_azienda", (String)"export_fatture_esig_diff_iva")) {
                    if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                    conn.setAutoCommit(false);
                    System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                    dbu.tryExecQuery((Connection)conn, (String)"ALTER TABLE `dati_azienda` ADD COLUMN `export_fatture_esig_diff_iva` char(1) NULL NULL", (boolean)false);
                    this.dbv.setVersion(conn, id);
                    this.dbv.rimuoviPrenotazioneChanges(conn);
                    conn.commit();
                } else {
                    this.dbv.setVersion(conn, id);
                }
            }
            id = 8;
            if (this.dbv.getVersion() < id) {
                if (!dbu.existColumn((Connection)conn, (String)"dati_azienda", (String)"gestione_campo_serie")) {
                    if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                    conn.setAutoCommit(false);
                    System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                    dbu.tryExecQuery((Connection)conn, (String)"ALTER TABLE `dati_azienda`\n\tADD COLUMN `nuovi_campi_centralizzati` TIMESTAMP NULL DEFAULT NULL,\n\tADD COLUMN `gestione_campo_serie` CHAR(1) NULL DEFAULT NULL,\n\tADD COLUMN `movimenti_fatt_imm` CHAR(2) NULL DEFAULT NULL,\n\tADD COLUMN `riporta_serie_in_conv` CHAR(2) NULL DEFAULT NULL,\n\tADD COLUMN `num_div_nc` CHAR(1) NULL DEFAULT NULL,\n\tADD COLUMN `agg_auto_prezzi` CHAR(1) NULL DEFAULT NULL,\n\tADD COLUMN `gestione_prezzi_per_cliente` CHAR(1) NULL DEFAULT NULL,\tADD COLUMN `stato_prev_dopo_conv` VARCHAR(50) NULL DEFAULT NULL;", (boolean)false);
                    this.dbv.setVersion(conn, id);
                    this.dbv.rimuoviPrenotazioneChanges(conn);
                    conn.commit();
                } else {
                    this.dbv.setVersion(conn, id);
                }
            }
            id = 9;
            if (this.dbv.getVersion() < id) {
                if (!dbu.existColumn((Connection)conn, (String)"dati_azienda", (String)"export_fatture_cod_pag_std")) {
                    if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                    conn.setAutoCommit(false);
                    System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                    dbu.tryExecQuery((Connection)conn, (String)"ALTER TABLE `dati_azienda` ADD COLUMN `export_fatture_cod_pag_std` char(3) NULL NULL , ADD COLUMN `export_fatture_tipo_eff_std` char(1) NULL NULL", (boolean)false);
                    dbu.tryExecQuery((Connection)conn, (String)"ALTER TABLE `pagamenti` CHANGE COLUMN `tipo_effetto_teamsystem` `tipo_effetto_teamsystem` CHAR(1) NULL DEFAULT NULL", (boolean)false);
                    dbu.tryExecQuery((Connection)conn, (String)"ALTER TABLE `pagamenti` CHANGE COLUMN `id_pagamento_teamsystem` `id_pagamento_teamsystem` CHAR(3) NULL DEFAULT NULL", (boolean)false);
                    this.dbv.setVersion(conn, id);
                    this.dbv.rimuoviPrenotazioneChanges(conn);
                    conn.commit();
                } else {
                    this.dbv.setVersion(conn, id);
                }
            }
            id = 10;
            if (this.dbv.getVersion() < id) {
                if (!dbu.existColumn((Connection)conn, (String)"clie_forn", (String)"email_pec")) {
                    if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                    conn.setAutoCommit(false);
                    System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                    dbu.tryExecQuery((Connection)conn, (String)"ALTER TABLE `clie_forn` ADD COLUMN `email_pec` varchar(100) NULL NULL , ADD COLUMN `includi_invio_email_pec` char(1) NULL NULL, ADD COLUMN `xmlpa_flag_pa` char(1) NULL NULL, ADD COLUMN `xmlpa_codice_dest` varchar(7) NULL NULL, ADD COLUMN `cod_for_filconad` varchar(15) NULL NULL", (boolean)false);
                    dbu.tryExecQuery((Connection)conn, (String)"update clie_forn set xmlpa_flag_pa = 'S' where ifnull(xmlpa_codice_ufficio,'') != '' or ifnull(split_payment,'') = 'S'", (boolean)false);
                    this.dbv.setVersion(conn, id);
                    this.dbv.rimuoviPrenotazioneChanges(conn);
                    conn.commit();
                } else {
                    this.dbv.setVersion(conn, id);
                }
            }
            id = 11;
            if (this.dbv.getVersion() < id) {
                if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                conn.setAutoCommit(false);
                System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                dbu.tryExecQuery((Connection)conn, (String)"update stati set nome = 'BOSNIA AND HERZEGOVINA' WHERE codice1 = 'BA' and nome = 'BOSNIA AND HERZEGOWINA';", (boolean)false);
                dbu.tryExecQuery((Connection)conn, (String)"insert IGNORE into stati set nome = 'SERBIA', codice1 = 'RS', codice2 = 'SRB', codice3 = '688', codice4 = 0;", (boolean)false);
                dbu.tryExecQuery((Connection)conn, (String)"insert IGNORE into stati set nome = 'MONTENEGRO', codice1 = 'ME', codice2 = 'MNE', codice3 = '499', codice4 = 0;", (boolean)false);
                this.dbv.setVersion(conn, id);
                this.dbv.rimuoviPrenotazioneChanges(conn);
                conn.commit();
            }
            id = 12;
            if (this.dbv.getVersion() < id && !dbu.existColumn((Connection)conn, (String)"articoli", (String)"xmlpa_cod_tipo")) {
                if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                conn.setAutoCommit(false);
                System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                dbu.tryExecQuery((Connection)conn, (String)"ALTER TABLE `articoli`\n\tADD COLUMN `xmlpa_cod_tipo` VARCHAR(35) NULL,\n\tADD COLUMN `xmlpa_cod_valore` VARCHAR(35) NULL", (boolean)false);
                this.dbv.setVersion(conn, id);
                this.dbv.rimuoviPrenotazioneChanges(conn);
                conn.commit();
            }
            id = 13;
            if (this.dbv.getVersion() < id && !dbu.existColumn((Connection)conn, (String)"righ_ordi_acquisto", (String)"xmlpa_cod_tipo")) {
                if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                conn.setAutoCommit(false);
                System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                for (String tab : tabs2 = new String[]{"righ_ddt", "righ_ddt_acquisto", "righ_fatt", "righ_fatt_acquisto", "righ_ordi", "righ_ordi_acquisto"}) {
                    dbu.tryExecQuery((Connection)conn, (String)("ALTER TABLE `" + tab + "`\n\tADD COLUMN `xmlpa_cod_tipo` VARCHAR(35) NULL,\tADD COLUMN `xmlpa_cod_valore` VARCHAR(35) NULL"), (boolean)false);
                }
                this.dbv.setVersion(conn, id);
                this.dbv.rimuoviPrenotazioneChanges(conn);
                conn.commit();
            }
            id = 14;
            if (this.dbv.getVersion() < id && !dbu.existColumn((Connection)conn, (String)"test_fatt_acquisto", (String)"risposta_mov_mag")) {
                if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                conn.setAutoCommit(false);
                System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                for (String tab : tabs2 = new String[]{"test_fatt", "test_fatt_acquisto"}) {
                    dbu.tryExecQuery((Connection)conn, (String)("ALTER TABLE `" + tab + "`\n\tADD COLUMN `risposta_mov_mag` CHAR(1) NULL"), (boolean)false);
                }
                this.dbv.setVersion(conn, id);
                this.dbv.rimuoviPrenotazioneChanges(conn);
                conn.commit();
            }
            id = 15;
            if (this.dbv.getVersion() < id && !dbu.existColumn((Connection)conn, (String)"codici_iva", (String)"codice_esterno")) {
                if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                conn.setAutoCommit(false);
                System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                dbu.tryExecQuery((Connection)conn, (String)"ALTER TABLE `codici_iva`\n\tADD COLUMN `codice_esterno` VARCHAR(10) NULL", (boolean)false);
                this.dbv.setVersion(conn, id);
                this.dbv.rimuoviPrenotazioneChanges(conn);
                conn.commit();
            }
            id = 16;
            if (this.dbv.getVersion() < id && !dbu.existColumn((Connection)conn, (String)"pagamenti", (String)"codice_esterno")) {
                if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                conn.setAutoCommit(false);
                System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                dbu.tryExecQuery((Connection)conn, (String)"ALTER TABLE `pagamenti`\n\tADD COLUMN `codice_esterno` VARCHAR(10) NULL", (boolean)false);
                this.dbv.setVersion(conn, id);
                this.dbv.rimuoviPrenotazioneChanges(conn);
                conn.commit();
            }
            id = 17;
            if (this.dbv.getVersion() < id) {
                if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                conn.setAutoCommit(false);
                System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                dbu.tryExecQuery((Connection)conn, (String)"update movimenti_magazzino m \n join test_fatt tf on tf.id = m.da_id \n set m.da_serie = tf.serie , m.da_numero = tf.numero, m.da_anno = tf.anno \n where m.da_tabella = 'test_fatt' and m.modificato_ts >= '2017-01-10' and m.modificato_ts <= '2017-02-10' \n and (tf.serie != m.da_serie or tf.numero != m.da_numero or tf.anno != m.da_anno)", (boolean)false);
                this.dbv.setVersion(conn, id);
                this.dbv.rimuoviPrenotazioneChanges(conn);
                conn.commit();
            }
            id = 18;
            if (this.dbv.getVersion() < id) {
                if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                conn.setAutoCommit(false);
                System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                dbu.tryExecQuery((Connection)conn, (String)"ALTER TABLE `sync_master` ADD COLUMN `id_group` BIGINT(20) UNSIGNED NULL DEFAULT NULL AFTER `id`;", (boolean)false);
                dbu.tryExecQuery((Connection)conn, (String)"ALTER TABLE `sync_slave` ADD COLUMN `id_group` BIGINT(20) UNSIGNED NULL DEFAULT NULL AFTER `id`;", (boolean)false);
                this.dbv.setVersion(conn, id);
                this.dbv.rimuoviPrenotazioneChanges(conn);
                conn.commit();
            }
            id = 19;
            if (this.dbv.getVersion() < id) {
                if (!dbu.existColumn((Connection)conn, (String)"dati_azienda", (String)"zero_come_uno")) {
                    if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                    conn.setAutoCommit(false);
                    System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                    dbu.tryExecQuery((Connection)conn, (String)"ALTER TABLE `dati_azienda` ADD COLUMN `zero_come_uno` char(1) NULL NULL", (boolean)false);
                    this.dbv.setVersion(conn, id);
                    this.dbv.rimuoviPrenotazioneChanges(conn);
                    conn.commit();
                } else {
                    this.dbv.setVersion(conn, id);
                }
            }
            this.sql(conn, 20, 30, "ALTER TABLE `provvigioni_dettagli`\n\tADD INDEX `id_test_fatt` (`id_test_fatt`),\n\tADD INDEX `id_riga` (`id_riga`);");
            this.sql(conn, 21, 30, "ALTER TABLE `dati_azienda` ADD COLUMN `export_fatture_usa_conti_contab` char(1) NULL");
            this.sql(conn, 22, 30, "ALTER TABLE `clie_forn` ADD COLUMN `tipo_porto` varchar(100) NULL");
            this.sql(conn, 23, 30, "ALTER TABLE `righ_ordi_acquisto`\tCHANGE COLUMN `quantita` `quantita` DECIMAL(15,5) NULL DEFAULT NULL AFTER `um`,\tCHANGE COLUMN `prezzo` `prezzo` DECIMAL(15,5) NULL DEFAULT '0.00000' AFTER `quantita`;");
            id = 24;
            if (this.dbv.getVersion() < id) {
                if (dbu.existTable((Connection)conn, (String)"provvigioni_copia_pre_id") && dbu.existTable((Connection)conn, (String)"scadenze_copia_pre_id") && !dbu.existColumn((Connection)conn, (String)"scadenze", (String)"id_doc")) {
                    if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                    conn.setAutoCommit(false);
                    System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                    try {
                        dbu.tryExecQuery((Connection)conn, (String)"drop table provvigioni_copia_pre_id", (boolean)false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        dbu.tryExecQuery((Connection)conn, (String)"drop table scadenze_copia_pre_id", (boolean)false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        main.splash("aggiornamenti struttura database: struttura scadenze e provvigioni", true);
                        if (main.db_in_rete) {
                            SwingUtils.showInfoMessage((Component)main.padre, (String)"Attenzione, \u00e8 necessario aggiornare la struttura del database.\nSe altri utenti stanno utilizzando Invoicex\ndovrebbero uscire prima di chiudere questo avviso !");
                        }
                        InvoicexUtil.aggiornaStrutturaScadenzeProvvigioniPerId();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.dbv.setVersion(conn, id);
                    this.dbv.rimuoviPrenotazioneChanges(conn);
                    conn.commit();
                } else {
                    this.dbv.setVersion(conn, id);
                }
            }
            this.sql(conn, 25, 30, "ALTER TABLE `clie_forn` ADD COLUMN `codice_esterno` VARCHAR(30) NULL DEFAULT NULL AFTER `codice`");
            this.sql(conn, 26, 30, "ALTER TABLE `dati_azienda` ADD COLUMN `clienti_dest_merce` char(1) NULL NULL");
            this.sqlIgnoreExc(conn, 27, 30, "ALTER TABLE `test_fatt` ADD INDEX `tipo_fattura` (`tipo_fattura`),ADD INDEX `data` (`data`);", "ALTER TABLE `test_fatt_acquisto`\tADD INDEX `tipo_fattura` (`tipo_fattura`),\tADD INDEX `data` (`data`);", "ALTER TABLE `test_ddt`\tADD INDEX `data` (`data`);", "ALTER TABLE `test_ddt_acquisto`\tADD INDEX `data` (`data`);", "ALTER TABLE `test_ordi`\tADD INDEX `data` (`data`);", "ALTER TABLE `test_ordi_acquisto`\tADD INDEX `data` (`data`);", "ALTER TABLE `righ_fatt`\tADD INDEX `id_padre` (`id_padre`);", "ALTER TABLE `righ_fatt_acquisto`\tADD INDEX `id_padre` (`id_padre`);", "ALTER TABLE `righ_ddt_acquisto`\tADD INDEX `id_padre` (`id_padre`);", "ALTER TABLE `righ_ordi`\tADD INDEX `id_padre` (`id_padre`);", "ALTER TABLE `righ_ordi_acquisto`\tADD INDEX `id_padre` (`id_padre`);");
            this.sql(conn, 28, 30, "ALTER TABLE `clie_forn` ADD COLUMN `vettore1` VARCHAR(255) NULL DEFAULT NULL");
            this.sqlIgnoreExc(conn, 29, 30, "ALTER TABLE `files_documenti` ADD INDEX `id_file` (`id_file`)");
            String[] qUKTestate = new String[]{"ALTER TABLE `test_ordi` ADD UNIQUE INDEX `serie_numero_anno_uk` (`serie`, `numero`, `anno`);", "ALTER TABLE `test_ddt` ADD UNIQUE INDEX `serie_numero_anno_uk` (`serie`, `numero`, `anno`);", "ALTER TABLE `test_fatt` ADD UNIQUE INDEX `serie_numero_anno_uk` (`serie`, `numero`, `anno`);", "ALTER TABLE `test_ordi_acquisto` ADD UNIQUE INDEX `serie_numero_anno_uk` (`serie`, `numero`, `anno`);", "ALTER TABLE `test_ddt_acquisto` ADD UNIQUE INDEX `serie_numero_anno_uk` (`serie`, `numero`, `anno`);", "ALTER TABLE `test_fatt_acquisto` ADD UNIQUE INDEX `serie_numero_anno_uk` (`serie`, `numero`, `anno`);"};
            if (Sync.isActive()) {
                this.sql(conn, 42, 30, qUKTestate);
            } else {
                this.sqlIgnoreExc(conn, 42, 30, qUKTestate);
            }
            this.sql(conn, 43, "ALTER TABLE `pagamenti` ADD COLUMN `spese_incasso` DECIMAL(15,5) NULL DEFAULT NULL");
            this.sql(conn, 44, "ALTER TABLE `dati_azienda` ADD COLUMN `codiceIvaSpeseIncasso` VARCHAR(10) NULL DEFAULT NULL");
            this.sql(conn, 45, "ALTER TABLE `pagamenti` ADD COLUMN `q_immediata` DECIMAL(5,2) NULL DEFAULT NULL , ADD COLUMN `q_30` DECIMAL(5,2) NULL DEFAULT NULL , ADD COLUMN `q_60` DECIMAL(5,2) NULL DEFAULT NULL , ADD COLUMN `q_90` DECIMAL(5,2) NULL DEFAULT NULL , ADD COLUMN `q_120` DECIMAL(5,2) NULL DEFAULT NULL , ADD COLUMN `q_150` DECIMAL(5,2) NULL DEFAULT NULL , ADD COLUMN `q_180` DECIMAL(5,2) NULL DEFAULT NULL , ADD COLUMN `q_210` DECIMAL(5,2) NULL DEFAULT NULL , ADD COLUMN `q_240` DECIMAL(5,2) NULL DEFAULT NULL , ADD COLUMN `q_270` DECIMAL(5,2) NULL DEFAULT NULL , ADD COLUMN `q_300` DECIMAL(5,2) NULL DEFAULT NULL , ADD COLUMN `q_330` DECIMAL(5,2) NULL DEFAULT NULL , ADD COLUMN `q_360` DECIMAL(5,2) NULL DEFAULT NULL , ADD COLUMN `q_auto` CHAR(1) NULL DEFAULT 'S'");
            this.sql(conn, 46, "alter table clie_forn  add column escl_scad_mese_1 TINYINT NULL DEFAULT NULL  , add column escl_scad_mese_2 TINYINT NULL DEFAULT NULL  , add column giorno_pagamento_rimandato TINYINT NULL DEFAULT NULL , add column no_spese_incasso CHAR(1) NULL DEFAULT NULL");
            this.sql(conn, 47, "update dati_azienda set codiceIvaSpeseIncasso = codiceIvaSpese");
            this.sql(conn, 48, "ALTER TABLE `dati_azienda` ADD COLUMN `codiceIvaSpeseRivalsa` VARCHAR(10) NULL DEFAULT NULL");
            this.sql(conn, 49, "update dati_azienda set codiceIvaSpeseRivalsa = codiceIvaSpese");
            this.sql(conn, 50, "ALTER TABLE `dati_azienda` ADD COLUMN `includi_rivalsa_in_imp_ritenuta` CHAR(1) NULL DEFAULT NULL");
            this.sql(conn, 51, "update dati_azienda set includi_rivalsa_in_imp_ritenuta = '" + (main.fileIni.getValueBoolean("pluginRitenute", "includi_rivalsa", true) != false ? "S" : "N") + "'");
            this.sql(conn, 52, "ALTER TABLE `dati_azienda` ADD COLUMN `includi_rivalsa_in_iva` CHAR(1) NULL DEFAULT NULL");
            this.sql(conn, 53, "update dati_azienda set includi_rivalsa_in_iva = '" + (main.fileIni.getValueBoolean("pluginRitenute", "includi_rivalsa_in_iva", true) != false ? "S" : "N") + "'");
            this.sql(conn, 54, "ALTER TABLE `dati_azienda` ADD COLUMN `sottrai_rivalsa` CHAR(1) NULL DEFAULT NULL");
            this.sql(conn, 55, "update dati_azienda set sottrai_rivalsa = '" + (main.fileIni.getValueBoolean("pluginRitenute", "sottrai_rivalsa", false) != false ? "S" : "N") + "'");
            this.sql(conn, 56, "ALTER TABLE `dati_azienda` ADD COLUMN `totale_fattura_in_elenco` CHAR(1) NULL DEFAULT NULL");
            this.sql(conn, 57, "update dati_azienda set totale_fattura_in_elenco = '" + (main.fileIni.getValueBoolean("pluginRitenute", "totale_fatture_in_elenco", false) != false ? "S" : "N") + "'");
            this.sql(conn, 58, "alter table test_fatt add column spesom_tipo_doc VARCHAR(10) NULL, add column spesom_non_esportare CHAR(1) NULL");
            this.sql(conn, 59, "alter table test_fatt_acquisto add column spesom_tipo_doc VARCHAR(10) NULL, add column spesom_non_esportare CHAR(1) NULL");
            this.sql(conn, 60, "alter table clie_forn add column persona_fisica CHAR(1) NULL after ragione_sociale, add column cognome VARCHAR(100) NULL after persona_fisica, add column nome VARCHAR(100) after cognome");
            id = 61;
            if (this.dbv.getVersion() < id) {
                if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                conn.setAutoCommit(false);
                System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                main.splash("agg.: pers.fisica/cognome/nome", true);
                ArrayList cflist = dbu.getListMap((Connection)conn, (String)"select codice, ragione_sociale, piva_cfiscale, cfiscale from clie_forn order by ragione_sociale");
                for (Map cf : cflist) {
                    if (cu.s(cf.get("cfiscale")).trim().length() != 16 || !StringUtils.isBlank((String)cu.s(cf.get("piva_cfiscale"))) || !StringUtils.isNotBlank((String)cu.s(cf.get("ragione_sociale")))) continue;
                    main.splash("agg. pers.fisica/cognome/nome: " + cu.s(cf.get("ragione_sociale")), true);
                    HashMap<String, String> m = new HashMap<String, String>();
                    m.put("persona_fisica", "S");
                    String cfiscale = cu.s(cf.get("cfiscale"));
                    String cfiscaleCogn = cfiscale.substring(0, 3).toLowerCase().replaceAll("a|e|i|o|u", "");
                    String cfiscaleNome = cfiscale.substring(3, 6).toLowerCase().replaceAll("a|e|i|o|u", "");
                    String ragSoc = cu.s(cf.get("ragione_sociale"));
                    ragSoc = ragSoc.replaceAll("(?i)b&b", "");
                    ragSoc = ragSoc.replaceAll("(?i)affittacamere", "");
                    ragSoc = ragSoc.replaceAll("(?i)az agr", "");
                    ragSoc = ragSoc.replaceAll("(?i)az. agr.", "");
                    ragSoc = ragSoc.replaceAll("(?i)azienda agr.", "");
                    ragSoc = ragSoc.replaceAll("(?i)az. agricola", "");
                    ragSoc = ragSoc.replaceAll("(?i)agricola", "");
                    ragSoc = ragSoc.replaceAll("(?i)azienda", "");
                    ragSoc = ragSoc.replaceAll("(?i)guest houses", "");
                    ragSoc = ragSoc.replaceAll("(?i)guest house", "");
                    ragSoc = ragSoc.replaceAll("(?i)residenza", "");
                    ragSoc = ragSoc.replaceAll("(?i)residence", "");
                    ragSoc = ragSoc.replaceAll("(?i)casa vacanze", "");
                    ragSoc = ragSoc.replaceAll("(?i)podere ", "");
                    ragSoc = ragSoc.replaceAll("(?i) podere ", "");
                    ragSoc = ragSoc.replaceAll("(?i)tenuta ", "");
                    ragSoc = ragSoc.replaceAll("(?i) tenuta", "");
                    ragSoc = ragSoc.replaceAll("(?i)villa ", "");
                    ragSoc = ragSoc.replaceAll("(?i) villa", "");
                    ragSoc = ragSoc.trim();
                    if (ragSoc.indexOf(" di ") >= 0) {
                        ragSoc = StringUtils.substringAfterLast((String)ragSoc, (String)" di ");
                    }
                    if (ragSoc.indexOf(" DI ") >= 0) {
                        ragSoc = StringUtils.substringAfterLast((String)ragSoc, (String)" DI ");
                    }
                    String ragSocCons = ragSoc.toLowerCase().replaceAll("a|e|i|o|u", "");
                    String[] ragSocConsSplit = StringUtils.split((String)ragSocCons, (String)" ");
                    Integer icogn = null;
                    Integer inome = null;
                    Object cognome = "";
                    String nome = "";
                    for (int i = 0; i < ragSocConsSplit.length; ++i) {
                        String s = ragSocConsSplit[i];
                        if (s.startsWith(cfiscaleCogn)) {
                            icogn = i;
                        }
                        if (!s.startsWith(cfiscaleNome)) continue;
                        inome = i;
                    }
                    Object[] ragSocSplit = StringUtils.split((String)ragSoc, (String)" ");
                    if (icogn != null || inome != null) {
                        if (inome == null) {
                            if (icogn == 0) {
                                cognome = ragSocSplit[0];
                                nome = StringUtils.join((Object[])ragSocSplit, (String)" ", (int)1, (int)ragSocSplit.length);
                            } else {
                                cognome = StringUtils.join((Object[])ragSocSplit, (String)" ", (int)icogn, (int)ragSocSplit.length);
                                nome = StringUtils.join((Object[])ragSocSplit, (String)" ", (int)0, (int)icogn);
                            }
                        } else if (icogn == null) {
                            if (inome == 0) {
                                nome = ragSocSplit[0];
                                cognome = StringUtils.join((Object[])ragSocSplit, (String)" ", (int)1, (int)ragSocSplit.length);
                            } else {
                                nome = StringUtils.join((Object[])ragSocSplit, (String)" ", (int)inome, (int)ragSocSplit.length);
                                cognome = StringUtils.join((Object[])ragSocSplit, (String)" ", (int)0, (int)inome);
                            }
                        } else if (inome > icogn) {
                            nome = StringUtils.join((Object[])ragSocSplit, (String)" ", (int)inome, (int)ragSocSplit.length);
                            cognome = StringUtils.join((Object[])ragSocSplit, (String)" ", (int)0, (int)inome);
                        } else {
                            cognome = StringUtils.join((Object[])ragSocSplit, (String)" ", (int)icogn, (int)ragSocSplit.length);
                            nome = StringUtils.join((Object[])ragSocSplit, (String)" ", (int)0, (int)icogn);
                        }
                    } else if (ragSoc.trim().length() >= 3 && ragSoc.indexOf(" ") > 0) {
                        cognome = ragSocSplit[0];
                        nome = StringUtils.join((Object[])ragSocSplit, (String)" ", (int)1, (int)ragSocSplit.length);
                    } else {
                        cognome = ragSoc;
                        nome = "";
                    }
                    m.put("cognome", (String)cognome);
                    m.put("nome", nome);
                    sql = "update clie_forn set " + dbu.prepareSqlFromMap(m) + " where codice = " + dbu.sql((Object)cu.s(cf.get("codice")));
                    dbu.tryExecQuery((Connection)conn, (String)sql);
                }
                this.dbv.setVersion(conn, id);
                this.dbv.rimuoviPrenotazioneChanges(conn);
                conn.commit();
            }
            this.sql(conn, 62, "ALTER TABLE `test_fatt` CHANGE COLUMN `tipo_fattura` `tipo_fattura` TINYINT(4) NULL DEFAULT NULL AFTER `anno`;");
            this.sql(conn, 63, "ALTER TABLE `clie_forn_dest`\tADD COLUMN `predefinito` CHAR(1) NULL DEFAULT NULL");
            this.sql(conn, 64, "alter table articoli add column scorta_minima decimal(15,5) NULL");
            this.sql(conn, 65, "alter table test_fatt add column imponibile_rivalsa decimal(15,5) NULL, add column imponibile_ritenuta decimal(15,5) NULL");
            this.sql(conn, 66, "alter table test_fatt_acquisto add column imponibile_rivalsa decimal(15,5) NULL, add column imponibile_ritenuta decimal(15,5) NULL");
            this.sql(conn, 67, "ALTER TABLE `accessi_log` ALTER `timestamp_login` DROP DEFAULT");
            this.sql(conn, 68, "ALTER TABLE `accessi_log` CHANGE COLUMN `timestamp_login` `timestamp_login` TIMESTAMP NULL AFTER `utente`,ADD COLUMN `utente_id` INT NULL AFTER `timestamp_login`,ADD COLUMN `ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP AFTER `utente_id`,ADD COLUMN `hostname` VARCHAR(255) NULL AFTER `ts`,ADD COLUMN `username_so` VARCHAR(255) NULL AFTER `hostname`,ADD COLUMN `nota` VARCHAR(500) NULL AFTER `username_so`,ADD COLUMN `ver` VARCHAR(50)");
            this.sql(conn, 69, "ALTER TABLE `accessi_log` ALTER `utente` DROP DEFAULT");
            this.sql(conn, 70, "ALTER TABLE `accessi_log` CHANGE COLUMN `utente` `utente` VARCHAR(255) NULL AFTER `id`");
            this.sql(conn, 71, "ALTER TABLE `test_fatt_xmlpa` \n add column `flag_pa` CHAR(1) NULL DEFAULT NULL \n, add column `dt_codice_ufficio` VARCHAR(6) NULL DEFAULT NULL \n, add column `dt_codice_dest` VARCHAR(7) NULL DEFAULT NULL \n, add column `dt_pec_dest` VARCHAR(100) NULL DEFAULT NULL \n, add column `cp_rif_amministrazione` VARCHAR(20) NULL DEFAULT NULL \n, add column `dg_tipo_rif_ordine` varchar(5) NULL DEFAULT NULL \n, add column `dg_rif_riferimentonumerolinea` VARCHAR(4) NULL DEFAULT NULL \n, add column `dg_rif_iddocumento` VARCHAR(20) NULL DEFAULT NULL \n, add column `dg_rif_data` DATE NULL DEFAULT NULL \n, add column `dg_rif_numitem` VARCHAR(20) NULL DEFAULT NULL \n, add column `dg_rif_codicecommessaconvenzione` VARCHAR(100) NULL DEFAULT NULL \n, add column `dg_rif_codicecup` VARCHAR(15) NULL DEFAULT NULL \n, add column `dg_rif_codicecig` VARCHAR(15) NULL DEFAULT NULL \n, add column `file_xml` MEDIUMTEXT NULL DEFAULT NULL \n, add column `file_xml_ts` TIMESTAMP NULL DEFAULT NULL");
            this.sql(conn, 72, "CREATE TABLE `fe_stati` (\n\t`id` CHAR(5) NOT NULL,\n\t`descrizione` VARCHAR(100) NULL DEFAULT NULL,\n\tPRIMARY KEY (`id`)\n)\nENGINE=MyISAM\n;");
            this.sql(conn, 73, "INSERT INTO `fe_stati` (`id`, `descrizione`) VALUES ('1', 'Invio');\nINSERT INTO `fe_stati` (`id`, `descrizione`) VALUES ('2A', 'Notifica di scarto');\nINSERT INTO `fe_stati` (`id`, `descrizione`) VALUES ('3A', 'Notifica di mancata consegna');\nINSERT INTO `fe_stati` (`id`, `descrizione`) VALUES ('3B', 'Ricevuta di consegna');\nINSERT INTO `fe_stati` (`id`, `descrizione`) VALUES ('4A', 'Notifica di esito');\nINSERT INTO `fe_stati` (`id`, `descrizione`) VALUES ('5', 'Notifica di decorrenza termini');\nINSERT INTO `fe_stati` (`id`, `descrizione`) VALUES ('6', 'Attestazione di avvenuta trasmissione con impossibilit\u00e0 di recapito');\n");
            this.sql(conn, 74, "ALTER TABLE `test_fatt` ADD COLUMN `fe_stato` CHAR(5) NULL DEFAULT NULL AFTER `imponibile_ritenuta`;");
            this.sql(conn, 75, "CREATE TABLE `test_fatt_acquisto_xmlpa` (\n\t`id_fattura` INT(11) NOT NULL,\n\t`dg_doa_riferimentonumerolinea` VARCHAR(4) NULL DEFAULT NULL,\n\t`dg_doa_iddocumento` VARCHAR(20) NULL DEFAULT NULL,\n\t`dg_doa_data` DATE NULL DEFAULT NULL,\n\t`dg_doa_numitem` VARCHAR(20) NULL DEFAULT NULL,\n\t`dg_doa_codicecommessaconvenzione` VARCHAR(100) NULL DEFAULT NULL,\n\t`dg_doa_codicecup` VARCHAR(15) NULL DEFAULT NULL,\n\t`dg_doa_codicecig` VARCHAR(15) NULL DEFAULT NULL,\n\t`dg_dc_riferimentonumerolinea` VARCHAR(4) NULL DEFAULT NULL,\n\t`dg_dc_iddocumento` VARCHAR(20) NULL DEFAULT NULL,\n\t`dg_dc_data` DATE NULL DEFAULT NULL,\n\t`dg_dc_numitem` VARCHAR(20) NULL DEFAULT NULL,\n\t`dg_dc_codicecommessaconvenzione` VARCHAR(100) NULL DEFAULT NULL,\n\t`dg_dc_codicecup` VARCHAR(15) NULL DEFAULT NULL,\n\t`dg_dc_codicecig` VARCHAR(15) NULL DEFAULT NULL,\n\t`dp_iban` VARCHAR(34) NULL DEFAULT NULL,\n\t`dp_istituto_finanziario` VARCHAR(80) NULL DEFAULT NULL,\n\t`dg_dr_tipo_ritenuta` VARCHAR(4) NULL DEFAULT NULL,\n\t`dg_dr_causale_pagamento` CHAR(2) NULL DEFAULT NULL,\n\t`dg_dcp_tipo_cassa` VARCHAR(4) NULL DEFAULT NULL,\n\t`dg_dr_totale_da_esportare` VARCHAR(30) NULL DEFAULT NULL,\n\t`dg_causale` VARCHAR(200) NULL DEFAULT NULL,\n\t`split_payment` CHAR(1) NULL DEFAULT NULL,\n\t`flag_pa` CHAR(1) NULL DEFAULT NULL,\n\t`dt_codice_ufficio` VARCHAR(6) NULL DEFAULT NULL,\n\t`dt_codice_dest` VARCHAR(7) NULL DEFAULT NULL,\n\t`dt_pec_dest` VARCHAR(100) NULL DEFAULT NULL,\n\t`cp_rif_amministrazione` VARCHAR(20) NULL DEFAULT NULL,\n\t`dg_tipo_rif_ordine` VARCHAR(5) NULL DEFAULT NULL,\n\t`dg_rif_riferimentonumerolinea` VARCHAR(4) NULL DEFAULT NULL,\n\t`dg_rif_iddocumento` VARCHAR(20) NULL DEFAULT NULL,\n\t`dg_rif_data` DATE NULL DEFAULT NULL,\n\t`dg_rif_numitem` VARCHAR(20) NULL DEFAULT NULL,\n\t`dg_rif_codicecommessaconvenzione` VARCHAR(100) NULL DEFAULT NULL,\n\t`dg_rif_codicecup` VARCHAR(15) NULL DEFAULT NULL,\n\t`dg_rif_codicecig` VARCHAR(15) NULL DEFAULT NULL,\n\t`file_xml` MEDIUMTEXT NULL,\n\t`file_xml_nome` VARCHAR(500) NULL DEFAULT NULL,\n\t`file_xml_ts` TIMESTAMP NULL DEFAULT NULL,\n `file_xml_prog` INT NULL DEFAULT NULL,\n\t`fe_provider_invio` VARCHAR(30) NULL DEFAULT NULL,\n\t`fe_inviata_ts` TIMESTAMP NULL DEFAULT NULL,\n\t`fe_upload_filename` VARCHAR(250) NULL DEFAULT NULL,\n\tPRIMARY KEY (`id_fattura`)\n)\nCOLLATE='utf8_general_ci'\nENGINE=MyISAM\n;");
            this.sql(conn, 76, "ALTER TABLE `test_fatt_xmlpa`\n\tADD COLUMN `file_xml_nome` VARCHAR(500) NULL DEFAULT NULL AFTER `file_xml`\t, ADD COLUMN `file_xml_prog` INT NULL DEFAULT NULL AFTER `file_xml_ts`\t, ADD COLUMN `fe_provider_invio` VARCHAR(30) NULL DEFAULT NULL\t, ADD COLUMN `fe_inviata_ts` TIMESTAMP NULL DEFAULT NULL\t, ADD COLUMN `fe_upload_filename` VARCHAR(250) NULL DEFAULT NULL");
            this.sql(conn, 77, "CREATE TABLE `test_fatt_iva_dettagli` ( `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT, `id_padre` INT(10) UNSIGNED NOT NULL, `tipo_riga` CHAR(2) NOT NULL, `codice_iva` CHAR(3) NOT NULL, `perc_iva` DECIMAL(5,2) NOT NULL, `imponibile` DECIMAL(15,5) NOT NULL, `iva` DECIMAL(15,5) NOT NULL, PRIMARY KEY (`id`) ) ENGINE=MyISAM");
            this.sql(conn, 78, "ALTER TABLE `vettori`\tALTER `nome` DROP DEFAULT;");
            this.sql(conn, 79, "ALTER TABLE `vettori` CHANGE COLUMN `nome` `nome` VARCHAR(255) NULL AFTER `id`,ADD COLUMN `nome_persona` VARCHAR(100) NULL AFTER `nome`,ADD COLUMN `cognome_persona` VARCHAR(100) NULL AFTER `nome_persona`,ADD COLUMN `piva` VARCHAR(100) NULL AFTER `cognome_persona`,ADD COLUMN `cfiscale` VARCHAR(100) NULL AFTER `piva`;");
            this.sql(conn, 80, "ALTER TABLE `test_fatt`          ADD COLUMN `peso_lordo_um` CHAR(3) NULL DEFAULT NULL AFTER `peso_lordo`, \tADD COLUMN `peso_netto_um` CHAR(3) NULL DEFAULT NULL AFTER `peso_netto`;");
            this.sql(conn, 81, "ALTER TABLE `test_ddt`           ADD COLUMN `peso_lordo_um` CHAR(3) NULL DEFAULT NULL AFTER `peso_lordo`, \tADD COLUMN `peso_netto_um` CHAR(3) NULL DEFAULT NULL AFTER `peso_netto`;");
            this.sql(conn, 82, "ALTER TABLE `test_ddt_acquisto`  ADD COLUMN `peso_lordo_um` CHAR(3) NULL DEFAULT NULL AFTER `peso_lordo`, \tADD COLUMN `peso_netto_um` CHAR(3) NULL DEFAULT NULL AFTER `peso_netto`;");
            this.sql(conn, 83, "ALTER TABLE `test_fatt` ADD COLUMN `vettore1_id` INT NULL DEFAULT NULL AFTER `vettore1`;");
            this.sql(conn, 84, "ALTER TABLE `test_ddt` ADD COLUMN `vettore1_id` INT NULL DEFAULT NULL AFTER `vettore1`;");
            this.sql(conn, 85, "ALTER TABLE `test_ddt_acquisto` ADD COLUMN `vettore1_id` INT NULL DEFAULT NULL AFTER `vettore1`;");
            this.sql(conn, 86, "CREATE TABLE IF NOT EXISTS `test_fatt_xmlpa_status` (\n\t`id` INT(11) NOT NULL AUTO_INCREMENT,\n\t`id_fattura` INT(11) NULL DEFAULT NULL,\n\t`numero_notifica` INT(11) NULL DEFAULT NULL,\n\t`ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,\n\t`ts_notifica` TIMESTAMP NULL DEFAULT NULL,\n\t`stato` CHAR(5) NULL DEFAULT NULL,\n\t`stato_provider` VARCHAR(50) NULL DEFAULT NULL,\n\t`file_xml_nome_notifica` VARCHAR(250) NULL DEFAULT NULL,\n\t`file_xml_notifica` MEDIUMTEXT NULL,\n\t`rif_fattura` VARCHAR(100) NULL DEFAULT NULL,\n\t`esito` VARCHAR(50) NULL DEFAULT NULL,\n\t`provider` VARCHAR(30) NULL DEFAULT NULL,\n\t`utente_invoicex` VARCHAR(50) NULL DEFAULT NULL,\n\t`utente_so` VARCHAR(50) NULL DEFAULT NULL,\n\tPRIMARY KEY (`id`),\n\tINDEX `id_fattura` (`id_fattura`)\n)\nCOLLATE='utf8_general_ci'\nENGINE=MyISAM;");
            this.sql(conn, 87, "update clie_forn set xmlpa_codice_dest = '0000000' where ifnull(xmlpa_flag_pa,'N') != 'S' and ifnull(paese, 'IT') = 'IT' and ifnull(xmlpa_codice_dest,'') = ''");
            this.sql(conn, 88, "ALTER TABLE `clie_forn` CHANGE COLUMN `piva_cfiscale` `piva_cfiscale` VARCHAR(28) NULL DEFAULT NULL");
            this.sql(conn, 89, "CREATE TABLE IF NOT EXISTS `tipi_ritenuta` (\n\t`id` INT(11) NOT NULL AUTO_INCREMENT,\n\t`descrizione` VARCHAR(200) NULL DEFAULT NULL,\n\t`percentuale` DECIMAL(6,3) NULL DEFAULT NULL,\n\t`conto_ven` VARCHAR(50) NULL DEFAULT NULL,\n\t`conto_acq` VARCHAR(50) NULL DEFAULT NULL,\n\t`dg_dr_tipo_ritenuta` VARCHAR(4) NULL DEFAULT NULL,\n\t`dg_dr_causale_pagamento` CHAR(2) NULL DEFAULT NULL,\n\tPRIMARY KEY (`id`)\n)\nCOLLATE='utf8_general_ci'\nENGINE=MyISAM;");
            this.sql(conn, 90, "CREATE TABLE IF NOT EXISTS `tipi_rivalsa` (\n\t`id` INT(11) NOT NULL AUTO_INCREMENT,\n\t`descrizione` VARCHAR(255) NULL DEFAULT NULL,\n\t`percentuale` DECIMAL(6,3) NULL DEFAULT NULL,\n\t`massimale` DECIMAL(10,2) NULL DEFAULT NULL,\n\t`conto_ven` VARCHAR(50) NULL DEFAULT NULL,\n\t`conto_acq` VARCHAR(50) NULL DEFAULT NULL,\n\t`dg_dcp_tipo_cassa` VARCHAR(4) NULL DEFAULT NULL,\n\tPRIMARY KEY (`id`)\n)\nCOLLATE='utf8_general_ci'\nENGINE=MyISAM;");
            this.sql(conn, 91, "update test_fatt_xmlpa \nset \n dg_tipo_rif_ordine = if(concat(ifnull(dg_doa_riferimentonumerolinea,''), ifnull(dg_doa_iddocumento,''), ifnull(dg_doa_data,''), ifnull(dg_doa_numitem,''), ifnull(dg_doa_codicecommessaconvenzione,''), ifnull(dg_doa_codicecup,''), ifnull(dg_doa_codicecig,'')) != '', 'OA', 'CNT')\n , dg_rif_riferimentonumerolinea = if(concat(ifnull(dg_doa_riferimentonumerolinea,''), ifnull(dg_doa_iddocumento,''), ifnull(dg_doa_data,''), ifnull(dg_doa_numitem,''), ifnull(dg_doa_codicecommessaconvenzione,''), ifnull(dg_doa_codicecup,''), ifnull(dg_doa_codicecig,'')) != '', dg_doa_riferimentonumerolinea, dg_dc_riferimentonumerolinea) \n , dg_rif_iddocumento = if(concat(ifnull(dg_doa_riferimentonumerolinea,''), ifnull(dg_doa_iddocumento,''), ifnull(dg_doa_data,''), ifnull(dg_doa_numitem,''), ifnull(dg_doa_codicecommessaconvenzione,''), ifnull(dg_doa_codicecup,''), ifnull(dg_doa_codicecig,'')) != '', dg_doa_iddocumento, dg_dc_iddocumento) \n , dg_rif_data = if(concat(ifnull(dg_doa_riferimentonumerolinea,''), ifnull(dg_doa_iddocumento,''), ifnull(dg_doa_data,''), ifnull(dg_doa_numitem,''), ifnull(dg_doa_codicecommessaconvenzione,''), ifnull(dg_doa_codicecup,''), ifnull(dg_doa_codicecig,'')) != '', dg_doa_data, dg_dc_data) \n , dg_rif_numitem = if(concat(ifnull(dg_doa_riferimentonumerolinea,''), ifnull(dg_doa_iddocumento,''), ifnull(dg_doa_data,''), ifnull(dg_doa_numitem,''), ifnull(dg_doa_codicecommessaconvenzione,''), ifnull(dg_doa_codicecup,''), ifnull(dg_doa_codicecig,'')) != '', dg_doa_numitem, dg_dc_numitem) \n , dg_rif_codicecommessaconvenzione = if(concat(ifnull(dg_doa_riferimentonumerolinea,''), ifnull(dg_doa_iddocumento,''), ifnull(dg_doa_data,''), ifnull(dg_doa_numitem,''), ifnull(dg_doa_codicecommessaconvenzione,''), ifnull(dg_doa_codicecup,''), ifnull(dg_doa_codicecig,'')) != '', dg_doa_codicecommessaconvenzione, dg_dc_codicecommessaconvenzione) \n , dg_rif_codicecup = if(concat(ifnull(dg_doa_riferimentonumerolinea,''), ifnull(dg_doa_iddocumento,''), ifnull(dg_doa_data,''), ifnull(dg_doa_numitem,''), ifnull(dg_doa_codicecommessaconvenzione,''), ifnull(dg_doa_codicecup,''), ifnull(dg_doa_codicecig,'')) != '', dg_doa_codicecup, dg_dc_codicecup) \n , dg_rif_codicecig = if(concat(ifnull(dg_doa_riferimentonumerolinea,''), ifnull(dg_doa_iddocumento,''), ifnull(dg_doa_data,''), ifnull(dg_doa_numitem,''), ifnull(dg_doa_codicecommessaconvenzione,''), ifnull(dg_doa_codicecup,''), ifnull(dg_doa_codicecig,'')) != '', dg_doa_codicecig, dg_dc_codicecig) \nwhere concat(ifnull(dg_rif_riferimentonumerolinea,''), ifnull(dg_rif_iddocumento,''), ifnull(dg_rif_data,''), ifnull(dg_rif_numitem,''), ifnull(dg_rif_codicecommessaconvenzione,''), ifnull(dg_rif_codicecup,''), ifnull(dg_rif_codicecig,'')) = ''\nand (\nconcat(ifnull(dg_doa_riferimentonumerolinea,''), ifnull(dg_doa_iddocumento,''), ifnull(dg_doa_data,''), ifnull(dg_doa_numitem,''), ifnull(dg_doa_codicecommessaconvenzione,''), ifnull(dg_doa_codicecup,''), ifnull(dg_doa_codicecig,'')) != ''\nor \nconcat(ifnull(dg_dc_riferimentonumerolinea,''), ifnull(dg_dc_iddocumento,''), ifnull(dg_dc_data,''), ifnull(dg_dc_numitem,''), ifnull(dg_dc_codicecommessaconvenzione,''), ifnull(dg_dc_codicecup,''), ifnull(dg_dc_codicecig,'')) != ''\n)");
            this.sql(conn, 92, "ALTER TABLE `vettori` ADD COLUMN `piva_paese` CHAR(2) NULL DEFAULT NULL AFTER `piva`;");
            this.sql(conn, 93, "ALTER TABLE test_fatt add column spese_trasporto_nette decimal(15,5) null, add column spese_incasso_nette decimal(15,5) null");
            this.sql(conn, 94, "ALTER TABLE test_fatt_acquisto add column spese_trasporto_nette decimal(15,5) null, add column spese_incasso_nette decimal(15,5) null");
            this.sql(conn, 95, "ALTER TABLE test_ddt add column spese_trasporto_nette decimal(15,5) null, add column spese_incasso_nette decimal(15,5) null");
            this.sql(conn, 96, "ALTER TABLE test_ddt_acquisto add column spese_trasporto_nette decimal(15,5) null, add column spese_incasso_nette decimal(15,5) null");
            this.sql(conn, 97, "ALTER TABLE test_ordi add column spese_trasporto_nette decimal(15,5) null, add column spese_incasso_nette decimal(15,5) null");
            this.sql(conn, 98, "ALTER TABLE test_ordi_acquisto add column spese_trasporto_nette decimal(15,5) null, add column spese_incasso_nette decimal(15,5) null");
            this.sql(conn, 99, "ALTER TABLE test_fatt_xmlpa add column fe_tipo_doc varchar(10) null");
            this.sql(conn, 100, "ALTER TABLE test_fatt_xmlpa add column fe_esigibilita_iva char(1) null");
            this.sql(conn, 101, "ALTER TABLE test_fatt add column filconad_tipodoc char(1) null");
            this.sql(conn, 102, "alter table test_fatt add column bollo_non_addebitare char(1) null default null after bollo_presente");
            this.sql(conn, 103, "ALTER TABLE `articoli`\n\tADD COLUMN `xmlpa_adg_tipo` VARCHAR(10) NULL,\n\tADD COLUMN `xmlpa_adg_testo` VARCHAR(60) NULL,\n\tADD COLUMN `xmlpa_adg_numero` VARCHAR(21) NULL,\n\tADD COLUMN `xmlpa_adg_data` VARCHAR(10) NULL");
            this.sql(conn, 104, "ALTER TABLE `righ_ordi`\n\tADD COLUMN `xmlpa_adg_tipo` VARCHAR(10) NULL,\n\tADD COLUMN `xmlpa_adg_testo` VARCHAR(60) NULL,\n\tADD COLUMN `xmlpa_adg_numero` VARCHAR(21) NULL,\n\tADD COLUMN `xmlpa_adg_data` VARCHAR(10) NULL");
            this.sql(conn, 105, "ALTER TABLE `righ_ddt`\n\tADD COLUMN `xmlpa_adg_tipo` VARCHAR(10) NULL,\n\tADD COLUMN `xmlpa_adg_testo` VARCHAR(60) NULL,\n\tADD COLUMN `xmlpa_adg_numero` VARCHAR(21) NULL,\n\tADD COLUMN `xmlpa_adg_data` VARCHAR(10) NULL");
            this.sql(conn, 106, "ALTER TABLE `righ_fatt`\n\tADD COLUMN `xmlpa_adg_tipo` VARCHAR(10) NULL,\n\tADD COLUMN `xmlpa_adg_testo` VARCHAR(60) NULL,\n\tADD COLUMN `xmlpa_adg_numero` VARCHAR(21) NULL,\n\tADD COLUMN `xmlpa_adg_data` VARCHAR(10) NULL");
            this.sql(conn, 107, "ALTER TABLE `righ_ordi_acquisto`\n\tADD COLUMN `xmlpa_adg_tipo` VARCHAR(10) NULL,\n\tADD COLUMN `xmlpa_adg_testo` VARCHAR(60) NULL,\n\tADD COLUMN `xmlpa_adg_numero` VARCHAR(21) NULL,\n\tADD COLUMN `xmlpa_adg_data` VARCHAR(10) NULL");
            this.sql(conn, 108, "ALTER TABLE `righ_ddt_acquisto`\n\tADD COLUMN `xmlpa_adg_tipo` VARCHAR(10) NULL,\n\tADD COLUMN `xmlpa_adg_testo` VARCHAR(60) NULL,\n\tADD COLUMN `xmlpa_adg_numero` VARCHAR(21) NULL,\n\tADD COLUMN `xmlpa_adg_data` VARCHAR(10) NULL");
            this.sql(conn, 109, "ALTER TABLE `righ_fatt_acquisto`\n\tADD COLUMN `xmlpa_adg_tipo` VARCHAR(10) NULL,\n\tADD COLUMN `xmlpa_adg_testo` VARCHAR(60) NULL,\n\tADD COLUMN `xmlpa_adg_numero` VARCHAR(21) NULL,\n\tADD COLUMN `xmlpa_adg_data` VARCHAR(10) NULL");
            id = 110;
            if (this.dbv.getVersion() < id) {
                if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                conn.setAutoCommit(false);
                System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                if (!dbu.existColumn((Connection)conn, (String)"articoli", (String)"xmlpa_cod_tipo")) {
                    dbu.tryExecQuery((Connection)conn, (String)"ALTER TABLE `articoli`\n\tADD COLUMN `xmlpa_cod_tipo` VARCHAR(35) NULL,\n\tADD COLUMN `xmlpa_cod_valore` VARCHAR(35) NULL", (boolean)false);
                }
                this.dbv.setVersion(conn, id);
                this.dbv.rimuoviPrenotazioneChanges(conn);
                conn.commit();
            }
            id = 111;
            if (this.dbv.getVersion() < id) {
                if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                conn.setAutoCommit(false);
                System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                for (String tab : tabs = new String[]{"righ_ddt", "righ_ddt_acquisto", "righ_fatt", "righ_fatt_acquisto", "righ_ordi", "righ_ordi_acquisto"}) {
                    if (dbu.existColumn((Connection)conn, (String)tab, (String)"xmlpa_cod_tipo")) continue;
                    dbu.tryExecQuery((Connection)conn, (String)("ALTER TABLE `" + tab + "`\n\tADD COLUMN `xmlpa_cod_tipo` VARCHAR(35) NULL,\tADD COLUMN `xmlpa_cod_valore` VARCHAR(35) NULL"), (boolean)false);
                }
                this.dbv.setVersion(conn, id);
                this.dbv.rimuoviPrenotazioneChanges(conn);
                conn.commit();
            }
            this.sql(conn, 112, "ALTER TABLE test_fatt_xmlpa ADD COLUMN dg_riferimenti_json VARCHAR(10000) NULL");
            this.sql(conn, 113, "ALTER TABLE test_fatt_acquisto_xmlpa ADD COLUMN dg_riferimenti_json VARCHAR(10000) NULL");
            this.sql(conn, 114, "alter table test_fatt add column esterom_forza_esportazione CHAR(1) NULL");
            this.sql(conn, 115, "alter table test_fatt_acquisto add column esterom_forza_esportazione CHAR(1) NULL");
            this.sql(conn, 116, "alter table clie_forn add column xmlpa_causale varchar(200) null");
            this.sql(conn, 117, "alter table clie_forn add column esterom_forza_esportazione CHAR(1) NULL");
            this.sql(conn, 118, "ALTER TABLE `test_fatt`\n\tCHANGE COLUMN `da_ddt_raggr` `da_ddt_raggr` VARCHAR(500) NULL DEFAULT NULL,\n\tCHANGE COLUMN `da_ordi_raggr` `da_ordi_raggr` VARCHAR(500) NULL DEFAULT NULL;");
            this.sql(conn, 119, "ALTER TABLE `test_fatt_acquisto`\n\tCHANGE COLUMN `da_ddt_raggr` `da_ddt_raggr` VARCHAR(500) NULL DEFAULT NULL,\n\tCHANGE COLUMN `da_ordi_raggr` `da_ordi_raggr` VARCHAR(500) NULL DEFAULT NULL;");
            this.sql(conn, 120, "ALTER TABLE `test_fatt` \n ADD COLUMN `includi_rivalsa_in_imp_ritenuta` CHAR(1) NULL DEFAULT NULL,\n ADD COLUMN `includi_rivalsa_in_iva` CHAR(1) NULL DEFAULT NULL,\n ADD COLUMN `sottrai_rivalsa` CHAR(1) NULL DEFAULT NULL,\n ADD COLUMN `codiceIvaSpeseRivalsa` VARCHAR(10) NULL DEFAULT NULL;\n");
            this.sql(conn, 121, "ALTER TABLE `test_fatt_acquisto` \n ADD COLUMN `includi_rivalsa_in_imp_ritenuta` CHAR(1) NULL DEFAULT NULL,\n ADD COLUMN `includi_rivalsa_in_iva` CHAR(1) NULL DEFAULT NULL,\n ADD COLUMN `sottrai_rivalsa` CHAR(1) NULL DEFAULT NULL,\n ADD COLUMN `codiceIvaSpeseRivalsa` VARCHAR(10) NULL DEFAULT NULL;\n");
            this.sql(conn, 122, "ALTER TABLE `test_fatt` ADD COLUMN `non_stampare_cod_art` CHAR(1) NULL");
            this.sql(conn, 123, "ALTER TABLE `test_fatt_acquisto` ADD COLUMN `non_stampare_cod_art` CHAR(1) NULL");
            this.sql(conn, 124, "ALTER TABLE `test_ddt` ADD COLUMN `non_stampare_cod_art` CHAR(1) NULL");
            this.sql(conn, 125, "ALTER TABLE `test_ddt_acquisto` ADD COLUMN `non_stampare_cod_art` CHAR(1) NULL");
            this.sql(conn, 126, "ALTER TABLE `test_ordi` ADD COLUMN `non_stampare_cod_art` CHAR(1) NULL");
            this.sql(conn, 127, "ALTER TABLE `test_ordi_acquisto` ADD COLUMN `non_stampare_cod_art` CHAR(1) NULL");
            this.sql(conn, 128, "ALTER TABLE `dati_azienda` ADD COLUMN `gen_prov_non_pag` CHAR(1) NULL");
            this.sql(conn, 129, "ALTER TABLE `provvigioni` ADD COLUMN `scadenza_parziale_pagata` CHAR(1) NULL");
            this.sql(conn, 130, "ALTER TABLE `test_fatt` ADD COLUMN `forzatura` CHAR(1) NULL");
            this.sql(conn, 131, "ALTER TABLE `test_fatt_acquisto` ADD COLUMN `forzatura` CHAR(1) NULL");
            this.sql(conn, 132, "ALTER TABLE `test_fatt`  ADD COLUMN `forzatura_importo_ritenuta` DECIMAL(15,5) NULL DEFAULT NULL , ADD COLUMN `forzatura_importo_rivalsa` DECIMAL(15,5) NULL DEFAULT NULL , ADD COLUMN `forzatura_totale_imponibile` DECIMAL(15,5) NULL DEFAULT NULL , ADD COLUMN `forzatura_totale_iva` DECIMAL(15,5) NULL DEFAULT NULL , ADD COLUMN `forzatura_totale` DECIMAL(15,5) NULL DEFAULT NULL , ADD COLUMN `forzatura_totale_da_pagare` DECIMAL(15,5) NULL DEFAULT NULL;");
            this.sql(conn, 133, "ALTER TABLE `test_fatt_acquisto`  ADD COLUMN `forzatura_importo_ritenuta` DECIMAL(15,5) NULL DEFAULT NULL , ADD COLUMN `forzatura_importo_rivalsa` DECIMAL(15,5) NULL DEFAULT NULL , ADD COLUMN `forzatura_totale_imponibile` DECIMAL(15,5) NULL DEFAULT NULL , ADD COLUMN `forzatura_totale_iva` DECIMAL(15,5) NULL DEFAULT NULL , ADD COLUMN `forzatura_totale` DECIMAL(15,5) NULL DEFAULT NULL , ADD COLUMN `forzatura_totale_da_pagare` DECIMAL(15,5) NULL DEFAULT NULL;");
            this.sql(conn, 134, "ALTER TABLE `dati_azienda` ADD COLUMN `con_gen_fat` CHAR(1) NULL");
            this.sql(conn, 135, "ALTER TABLE `dati_azienda` ADD COLUMN `con_gen_pag` CHAR(1) NULL");
            this.sql(conn, 136, "ALTER TABLE `clie_forn` ADD COLUMN `cede_titolo` VARCHAR(10) NULL DEFAULT NULL, ADD COLUMN `cede_reg_fiscale` CHAR(4) NULL DEFAULT NULL, ADD COLUMN `cede_rea_ufficio` CHAR(2) NULL DEFAULT NULL, ADD COLUMN `cede_rea_numero` VARCHAR(20) NULL DEFAULT NULL, ADD COLUMN `cede_rea_capitale_sociale` DECIMAL(15,5) NULL DEFAULT NULL, ADD COLUMN `cede_rea_socio_unico` CHAR(1) NULL DEFAULT NULL, ADD COLUMN `cede_rea_stato_liquidazione` CHAR(1) NULL DEFAULT NULL");
            this.sql(conn, 137, "ALTER TABLE `dati_azienda` ADD COLUMN `codice_dest` varchar(7) NULL NULL, ADD COLUMN `pec` varchar(100) NULL NULL");
            this.sql(conn, 138, "CREATE TABLE `test_fatt_acquisto_iva_dettagli` ( `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT, `id_padre` INT(10) UNSIGNED NOT NULL, `tipo_riga` CHAR(2) NOT NULL, `codice_iva` CHAR(3) NOT NULL, `perc_iva` DECIMAL(5,2) NOT NULL, `imponibile` DECIMAL(15,5) NOT NULL, `iva` DECIMAL(15,5) NOT NULL, PRIMARY KEY (`id`) ) ENGINE=MyISAM");
            this.sql(conn, 139, "ALTER TABLE `test_fatt_acquisto_xmlpa` ADD COLUMN `file_xml_gen` MEDIUMTEXT NULL NULL, ADD COLUMN `file_xml_nome_gen` VARCHAR(500) NULL NULL, ADD COLUMN `file_xml_ts_gen` TIMESTAMP NULL NULL, ADD COLUMN `file_xml_prog_gen` INT NULL NULL");
            this.sql(conn, 140, "ALTER TABLE test_fatt_acquisto_xmlpa add column fe_tipo_doc varchar(10) null");
            this.sql(conn, 141, "ALTER TABLE test_fatt_acquisto_xmlpa add column fe_esigibilita_iva char(1) null");
            this.sql(conn, 142, "alter table test_fatt add column build_ver INT NULL");
            this.sql(conn, 143, "alter table test_ddt add column build_ver INT NULL");
            this.sql(conn, 144, "alter table test_ordi add column build_ver INT NULL");
            this.sql(conn, 145, "alter table test_fatt_acquisto add column build_ver INT NULL");
            this.sql(conn, 146, "alter table test_ddt_acquisto add column build_ver INT NULL");
            this.sql(conn, 147, "alter table test_ordi_acquisto add column build_ver INT NULL");
            this.sql(conn, 148, "alter table articoli add column `obsoleto` VARCHAR(1) NULL");
            this.sql(conn, 149, "alter table tipi_ritenuta add column `conto_ven` VARCHAR(50) NULL DEFAULT NULL");
            this.sql(conn, 150, "alter table tipi_ritenuta add column `conto_acq` VARCHAR(50) NULL DEFAULT NULL");
            this.sql(conn, 151, "alter table tipi_ritenuta add column `dg_dr_tipo_ritenuta` VARCHAR(4) NULL DEFAULT NULL");
            this.sql(conn, 152, "alter table tipi_ritenuta add column `dg_dr_causale_pagamento` CHAR(2) NULL DEFAULT NULL");
            this.sql(conn, 153, "alter table tipi_rivalsa add column `conto_ven` VARCHAR(50) NULL DEFAULT NULL");
            this.sql(conn, 154, "alter table tipi_rivalsa add column `conto_acq` VARCHAR(50) NULL DEFAULT NULL");
            this.sql(conn, 155, "alter table tipi_rivalsa add column `dg_dcp_tipo_cassa` VARCHAR(5) NULL DEFAULT NULL");
            id = 156;
            if (this.dbv.getVersion() < id) {
                if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                conn.setAutoCommit(false);
                System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                if (cu.i0((Object)dbu.getObject((Connection)conn, (String)"select max(length(matricola)) from movimenti_magazzino")) <= 150) {
                    dbu.tryExecQuery((Connection)conn, (String)"ALTER TABLE `movimenti_magazzino` CHANGE COLUMN `matricola` `matricola` VARCHAR(150) NULL DEFAULT NULL;", (boolean)false);
                }
                if (cu.i0((Object)dbu.getObject((Connection)conn, (String)"select max(length(lotto)) from movimenti_magazzino")) <= 150) {
                    dbu.tryExecQuery((Connection)conn, (String)"ALTER TABLE `movimenti_magazzino` CHANGE COLUMN `lotto` `lotto` VARCHAR(150) NULL DEFAULT NULL;", (boolean)false);
                }
                this.dbv.setVersion(conn, id);
                this.dbv.rimuoviPrenotazioneChanges(conn);
                conn.commit();
            }
            id = 157;
            if (this.dbv.getVersion() < id) {
                if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                conn.setAutoCommit(false);
                System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                for (String tab : tabs = new String[]{"righ_ddt", "righ_ddt_acquisto", "righ_fatt", "righ_fatt_acquisto", "righ_ordi", "righ_ordi_acquisto"}) {
                    if (dbu.existColumn((Connection)conn, (String)tab, (String)"variante_id")) continue;
                    dbu.tryExecQuery((Connection)conn, (String)("ALTER TABLE `" + tab + "`\n\tADD COLUMN `variante_id` INT NULL"), (boolean)false);
                }
                this.dbv.setVersion(conn, id);
                this.dbv.rimuoviPrenotazioneChanges(conn);
                conn.commit();
            }
            this.sql(conn, 158, "ALTER TABLE `test_fatt_xmlpa_status` ADD COLUMN `esito_errore` TEXT NULL DEFAULT NULL AFTER `esito`");
            this.sql(conn, 159, "update test_fatt t\njoin test_fatt_xmlpa tx on t.id = tx.id_fattura\njoin clie_forn cf on t.cliente = cf.codice\nset tx.flag_pa = cf.xmlpa_flag_pa\nwhere ifnull(tx.flag_pa,'') = '' and ifnull(cf.xmlpa_flag_pa,'') = 'S'");
            id = 160;
            if (this.dbv.getVersion() < id && PlatformUtils.isLinux() && !main.db_in_rete) {
                if (!this.dbv.prenotaChanges(conn, 300)) throw this.excLock;
                conn.setAutoCommit(false);
                System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                dbu.tryExecQuery((Connection)conn, (String)"ALTER TABLE `test_fatt` COLLATE='utf8_general_ci', CONVERT TO CHARSET utf8;");
                this.dbv.setVersion(conn, id);
                this.dbv.rimuoviPrenotazioneChanges(conn);
                conn.commit();
            }
            if (Db.dbNameDB.equalsIgnoreCase("italiandesign")) {
                main.splash("aggiorna flag persona fisica", true);
                InvoicexUtil2.aggiornaPersonaFisicaDaPartitaIva();
            }
            main.splash("optimize table", true);
            MicroBench mb = new MicroBench(true);
            dbu.tryExecQuery((Connection)Db.getConn(), (String)"optimize table scadenze", (boolean)false, (boolean)true);
            mb.out("optimize table scadenze fine");
            conn.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            try {
                conn.rollback();
                conn.setAutoCommit(true);
                this.dbv.rimuoviPrenotazioneChanges(conn);
                throw ex;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void sql(Connection conn, int id, String ... sql) throws SQLException, Exception {
        this.sql(conn, id, 30, sql);
    }

    private void sql(Connection conn, int id, Integer timeout, String ... sql) throws SQLException, Exception {
        this.lastId = id;
        if (this.dbv.getVersion() < id) {
            if (id == 4 && dbu.existColumn((Connection)conn, (String)"pagamenti", (String)"rid")) {
                this.dbv.setVersion(conn, Integer.valueOf(id));
                return;
            }
            if (id == 5 && dbu.existTable((Connection)conn, (String)"test_fatt_acquisto_iva_ded")) {
                this.dbv.setVersion(conn, Integer.valueOf(id));
                return;
            }
            if (id == 78 && !dbu.existTable((Connection)conn, (String)"vettori")) {
                String sqlpre = "CREATE TABLE `vettori` (\n\t`id` INT(10) NOT NULL DEFAULT '0',\n\t`nome` VARCHAR(255) NULL DEFAULT NULL,\n\tPRIMARY KEY (`id`)\n)\nCOLLATE='utf8_general_ci'\nENGINE=MyISAM";
                try {
                    dbu.tryExecQuery((Connection)Db.getConn(), (String)sqlpre, (boolean)false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.dbv.prenotaChanges(conn, timeout == null ? 300 : timeout)) {
                if (this.dbv.getVersion() < id) {
                    conn.setAutoCommit(false);
                    System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                    for (String nsql : sql) {
                        try {
                            dbu.tryExecQuery((Connection)conn, (String)nsql, (boolean)false);
                        }
                        catch (SQLException sqle) {
                            System.out.println("DbVersionChanges sql (id:" + id + ") errcode:" + sqle.getErrorCode() + " sqlstate:" + sqle.getSQLState() + " msg:" + sqle.getMessage());
                            if (sqle.getErrorCode() == 1060 || sqle.getErrorCode() == 1061 || sqle.getErrorCode() == 1050) continue;
                            throw sqle;
                        }
                    }
                    this.dbv.setVersion(conn, Integer.valueOf(id));
                    this.dbv.rimuoviPrenotazioneChanges(conn);
                    conn.commit();
                }
            } else {
                throw this.excLock;
            }
        }
    }

    private void sqlIgnoreExc(Connection conn, int id, Integer timeout, String ... sql) throws SQLException, Exception {
        if (this.dbv.getVersion() < id) {
            if (this.dbv.prenotaChanges(conn, timeout == null ? 300 : timeout)) {
                if (this.dbv.getVersion() < id) {
                    conn.setAutoCommit(false);
                    System.out.println("DbVersionChanges " + DebugFastUtils.dumpAsString((Object)this.dbv.running));
                    for (String nsql : sql) {
                        try {
                            dbu.tryExecQuery((Connection)conn, (String)nsql, (boolean)false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.dbv.setVersion(conn, Integer.valueOf(id));
                    this.dbv.rimuoviPrenotazioneChanges(conn);
                    conn.commit();
                }
            } else {
                throw this.excLock;
            }
        }
    }
}

