/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.SimpleBookmark;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ItextUtil {
    public static void concatenate(String outFile, String[] args) {
        try {
            int pageOffset = 0;
            ArrayList master = new ArrayList();
            Document document = null;
            PdfCopy writer = null;
            for (int f = 0; f < args.length; ++f) {
                PdfReader reader = new PdfReader(args[f]);
                reader.consolidateNamedDestinations();
                int n = reader.getNumberOfPages();
                List bookmarks = SimpleBookmark.getBookmark((PdfReader)reader);
                if (bookmarks != null) {
                    if (pageOffset != 0) {
                        SimpleBookmark.shiftPageNumbers((List)bookmarks, (int)pageOffset, null);
                    }
                    master.addAll(bookmarks);
                }
                pageOffset += n;
                System.out.println("There are " + n + " pages in " + args[f]);
                if (f == 0) {
                    document = new Document(reader.getPageSizeWithRotation(1));
                    writer = new PdfCopy(document, (OutputStream)new FileOutputStream(outFile));
                    document.open();
                }
                int i = 0;
                while (i < n) {
                    PdfImportedPage page = writer.getImportedPage(reader, ++i);
                    writer.addPage(page);
                    System.out.println("Processed page " + i);
                }
                writer.freeReader(reader);
            }
            if (!master.isEmpty()) {
                writer.setOutlines(master);
            }
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

