/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex.gui;

import gestioneFatture.Util;
import it.tnx.Db;
import it.tnx.commons.DateUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.KeyValuePair;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.dbu;
import it.tnx.dbeans.JTableDb;
import it.tnx.dbeans.pdfPrint.PrintSimpleTable;
import it.tnx.invoicex.iu;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXDatePicker;
import tnxbeans.tnxComboField;

public class JDialogExportElencoDdt
extends JDialog {
    private JTableDb griglia;
    public JXDatePicker al;
    public JButton annulla;
    public tnxComboField causali;
    public tnxComboField comCliFor;
    public JXDatePicker dal;
    public JComboBox fatturato;
    public JComboBox formato;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JLabel jLabel4;
    public JLabel jLabel5;
    public JLabel jLabel6;
    public JLabel jLabel7;
    public JLabel jLabel8;
    public JSeparator jSeparator1;
    public JComboBox ordine;
    public JButton stampa;
    public JComboBox tipo;

    public JDialogExportElencoDdt(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.dal.setFormats(new DateFormat[]{new SimpleDateFormat("dd/MM/yyyy")});
        this.al.setFormats(new DateFormat[]{new SimpleDateFormat("dd/MM/yyyy")});
        this.comCliFor.dbAddElement("<tutti>", "*");
        this.comCliFor.dbOpenList(Db.getConn(), "SELECT ragione_sociale, codice FROM clie_forn ORDER BY ragione_sociale");
        this.causali.dbAddElement("<tutte>", "*");
        this.causali.dbOpenList(Db.getConn(), "SELECT distinct causale_trasporto, causale_trasporto FROM test_ddt ORDER BY causale_trasporto");
        Vector<KeyValuePair> v = new Vector<KeyValuePair>();
        v.add(new KeyValuePair((Object)"pdf", (Object)"PDF"));
        v.add(new KeyValuePair((Object)"html", (Object)"HTML"));
        v.add(new KeyValuePair((Object)"xls", (Object)"EXCEL"));
        v.add(new KeyValuePair((Object)"csv", (Object)"CSV"));
        SwingUtils.initJComboFromKVList((JComboBox)this.formato, v);
        v = new Vector();
        v.add(new KeyValuePair((Object)"t.anno, t.serie, t.numero", (Object)"Numero"));
        v.add(new KeyValuePair((Object)"t.data, t.anno, t.serie, t.numero", (Object)"Data, Numero"));
        v.add(new KeyValuePair((Object)"cf.ragione_sociale, t.anno, t.serie, t.numero", (Object)"Cliente/Fornitore, Numero"));
        SwingUtils.initJComboFromKVList((JComboBox)this.ordine, v);
    }

    private void initComponents() {
        this.stampa = new JButton();
        this.annulla = new JButton();
        this.tipo = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel5 = new JLabel();
        this.formato = new JComboBox();
        this.dal = new JXDatePicker();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.al = new JXDatePicker();
        this.jLabel7 = new JLabel();
        this.comCliFor = new tnxComboField();
        this.jLabel2 = new JLabel();
        this.ordine = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jLabel6 = new JLabel();
        this.fatturato = new JComboBox();
        this.jLabel8 = new JLabel();
        this.causali = new tnxComboField();
        FormListener formListener = new FormListener();
        this.setDefaultCloseOperation(2);
        this.setTitle("Elenco DDT");
        this.setMinimumSize(new Dimension(412, 215));
        this.stampa.setFont(this.stampa.getFont().deriveFont(this.stampa.getFont().getStyle() | 1));
        this.stampa.setIcon(iu.getIcon("conferma"));
        this.stampa.setText("Esporta");
        this.stampa.addActionListener(formListener);
        this.annulla.setIcon(iu.getIcon("annulla"));
        this.annulla.setText("Annulla");
        this.annulla.addActionListener(formListener);
        this.tipo.setModel(new DefaultComboBoxModel<String>(new String[]{"Vendita", "Acquisto"}));
        this.tipo.setSelectedItem("Vendita");
        this.tipo.addActionListener(formListener);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Origine");
        this.jLabel1.setPreferredSize(new Dimension(80, 14));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Formato Stampa");
        this.jLabel5.setPreferredSize(new Dimension(80, 14));
        this.formato.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Dal");
        this.jLabel3.setPreferredSize(new Dimension(80, 14));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Al");
        this.jLabel4.setPreferredSize(new Dimension(80, 14));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("Cliente/Fornitore");
        this.jLabel7.setPreferredSize(new Dimension(80, 14));
        this.comCliFor.setDbDescCampo("");
        this.comCliFor.setDbNomeCampo("");
        this.comCliFor.setDbTipoCampo("");
        this.comCliFor.setDbTrovaMentreScrive(true);
        this.comCliFor.addItemListener(formListener);
        this.comCliFor.addFocusListener(formListener);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Ordinamento");
        this.jLabel2.setPreferredSize(new Dimension(80, 14));
        this.ordine.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText("Fatturato");
        this.jLabel6.setPreferredSize(new Dimension(80, 14));
        this.fatturato.setModel(new DefaultComboBoxModel<String>(new String[]{"Tutti", "S\u00ec", "S\u00ec e Parziali", "Parziali", "No", " "}));
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText("Causale trasporto");
        this.jLabel8.setPreferredSize(new Dimension(80, 14));
        this.causali.setDbDescCampo("");
        this.causali.setDbNomeCampo("");
        this.causali.setDbTipoCampo("");
        this.causali.setDbTrovaMentreScrive(true);
        this.causali.addItemListener(formListener);
        this.causali.addFocusListener(formListener);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1, -2, -1, -2).addPreferredGap(0).add((Component)this.tipo, 0, -1, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel7, -2, -1, -2).addPreferredGap(0).add((Component)this.comCliFor, -2, 233, -2))).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel5, -2, 115, -2).addPreferredGap(0).add((Component)this.formato, 0, -1, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel4, -2, -1, -2).add(2, (Component)this.jLabel2, -2, -1, -2)).add((Component)this.jLabel3, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.ordine, -2, 194, -2).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.dal, -1, -1, Short.MAX_VALUE).add(1, (Component)this.al, -1, 137, Short.MAX_VALUE)))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel6, -2, -1, -2).addPreferredGap(0).add((Component)this.fatturato, -2, 194, -2)))).add(31, 31, 31)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jSeparator1, -1, 469, Short.MAX_VALUE).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel8, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.causali, -2, 233, -2).add(127, 127, 127))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.annulla).addPreferredGap(0).add((Component)this.stampa).addContainerGap()))));
        layout.linkSize(new Component[]{this.jLabel1, this.jLabel2, this.jLabel3, this.jLabel4, this.jLabel5, this.jLabel7}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1, -2, -1, -2).add((Component)this.tipo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.comCliFor, -2, -1, -2).add((Component)this.jLabel7, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3, -2, 18, -2).add((Component)this.dal, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4, -2, -1, -2).add((Component)this.al, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel6, -2, -1, -2).add((Component)this.fatturato, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel8, -2, -1, -2).add((Component)this.causali, -2, -1, -2)).add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2, -2, -1, -2).add((Component)this.ordine, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5, -2, -1, -2).add((Component)this.formato, -2, -1, -2)).addPreferredGap(0, 74, Short.MAX_VALUE).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.stampa).add((Component)this.annulla)).addContainerGap()));
        this.pack();
    }

    private void stampaActionPerformed(ActionEvent evt) {
        String nomeFile;
        this.setCursor(new Cursor(3));
        int[] headerWidth = null;
        String tabella = this.tipo.getSelectedItem().equals("Acquisto") ? "test_ddt_acquisto" : "test_ddt";
        String sql = "SELECT t.data, CONCAT(t.serie,t.numero) as numero";
        sql = tabella.equals("test_ddt") ? sql + ", cast(cf.codice as char(10)) as 'Cod. Cliente', cf.ragione_sociale as 'Cliente'" : sql + ", cast(cf.codice as char(10)) as 'Cod. Fornitore', cf.ragione_sociale as 'Fornitore'";
        sql = sql + ", t.causale_trasporto as 'Causale trasporto', IFNULL(t.evaso, '') as 'Fatturato',  t.totale_imponibile as 'Totale Imponibile', t.totale_iva as 'Iva', t.totale as 'Totale' ";
        sql = sql + ", IFNULL(t.acconto, 0) as 'acconto'";
        sql = sql + ", t.totale - IFNULL(t.acconto, 0) as 'Totale da pagare'";
        sql = sql + " FROM " + tabella + " t LEFT JOIN clie_forn cf";
        sql = tabella.equals("test_ddt") ? sql + " ON t.cliente = cf.codice " : sql + " ON t.fornitore = cf.codice ";
        sql = sql + " WHERE 1 = 1 ";
        if (this.dal.getDate() != null) {
            sql = sql + " AND data >= " + DbUtils.pc2((Date)this.dal.getDate(), (int)91);
        }
        if (this.al.getDate() != null) {
            sql = sql + " AND data <= " + DbUtils.pc2((Date)this.al.getDate(), (int)91);
        }
        if (this.fatturato.getSelectedItem().equals("S\u00ec")) {
            sql = sql + " and IFNULL(t.evaso, '') = 'S'";
        } else if (this.fatturato.getSelectedItem().equals("No")) {
            sql = sql + " and (IFNULL(t.evaso, '') = '' or IFNULL(t.evaso, '') = 'N')";
        } else if (this.fatturato.getSelectedItem().equals("S\u00ec e Parziali")) {
            sql = sql + " and (IFNULL(t.evaso, '') = 'S' or IFNULL(t.evaso, '') = 'P')";
        } else if (this.fatturato.getSelectedItem().equals("Parziali")) {
            sql = sql + " and (IFNULL(t.evaso, '') = 'P'";
        }
        if (this.causali.getSelectedIndex() > 0) {
            sql = sql + " and t.causale_trasporto = " + dbu.sql((Object)this.causali.getSelectedKey());
        }
        if (this.comCliFor.getSelectedIndex() > 0) {
            sql = sql + " and cf.codice = '" + this.comCliFor.getSelectedKey() + "'";
        }
        sql = sql + " ORDER BY " + ((KeyValuePair)this.ordine.getSelectedItem()).key;
        ResultSet rs = null;
        try {
            System.out.println("sql:\n" + sql);
            rs = DbUtils.tryOpenResultSetEditable((Connection)Db.conn, (String)sql);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setCursor(new Cursor(0));
            SwingUtils.showErrorMessage((Component)this, (String)ex.getMessage());
            return;
        }
        PrintSimpleTable print = new PrintSimpleTable(rs);
        print.totali = true;
        String caption = "Elenco DDT";
        String caption2 = "";
        try {
            ResultSet r = Db.openResultSet("select ragione_sociale from dati_azienda");
            if (r.next()) {
                caption2 = caption2 + r.getString(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (caption2.length() > 0) {
            caption2 = caption2 + " - ";
        }
        caption2 = caption2 + this.tipo.getSelectedItem();
        if (this.comCliFor.getSelectedIndex() > 0) {
            caption2 = caption2 + "\n" + this.comCliFor.getSelectedItem();
        }
        caption2 = caption2 + "\nDal: " + DateUtils.formatDate((Date)this.dal.getDate()) + " Al: " + DateUtils.formatDate((Date)this.al.getDate());
        headerWidth = new int[]{10, 10, 10, 40, 20, 10, 10, 10, 10, 10, 10};
        if (((KeyValuePair)this.formato.getSelectedItem()).key.toString().equalsIgnoreCase("pdf")) {
            print.print(caption, headerWidth, ((KeyValuePair)this.formato.getSelectedItem()).key.toString(), caption2, "", -2);
            Util.start("tempStampa.pdf");
        } else if (((KeyValuePair)this.formato.getSelectedItem()).key.toString().equalsIgnoreCase("xls")) {
            nomeFile = print.printExcel(caption, headerWidth, caption2, "");
            Util.start(nomeFile);
        } else if (((KeyValuePair)this.formato.getSelectedItem()).key.toString().equalsIgnoreCase("csv")) {
            nomeFile = print.printCsv(caption, headerWidth, caption2, "");
            File fdir = new File(new File(nomeFile).getAbsolutePath());
            fdir = fdir.getParentFile();
            System.out.println("fdir:" + fdir);
            Util.start(fdir.getAbsolutePath());
        } else {
            print.print(caption, headerWidth, ((KeyValuePair)this.formato.getSelectedItem()).key.toString(), caption2, "");
            Util.start("tempStampa.html");
        }
        try {
            rs.getStatement().close();
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCursor(new Cursor(0));
    }

    private void annullaActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void tipoActionPerformed(ActionEvent evt) {
    }

    private void comCliForFocusLost(FocusEvent evt) {
    }

    private void comCliForItemStateChanged(ItemEvent evt) {
    }

    private void causaliItemStateChanged(ItemEvent evt) {
    }

    private void causaliFocusLost(FocusEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDialogExportElencoDdt dialog = new JDialogExportElencoDdt((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public JTableDb getGriglia() {
        return this.griglia;
    }

    public void setGriglia(JTableDb griglia) {
        this.griglia = griglia;
    }

    private class FormListener
    implements ActionListener,
    FocusListener,
    ItemListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == JDialogExportElencoDdt.this.stampa) {
                JDialogExportElencoDdt.this.stampaActionPerformed(evt);
            } else if (evt.getSource() == JDialogExportElencoDdt.this.annulla) {
                JDialogExportElencoDdt.this.annullaActionPerformed(evt);
            } else if (evt.getSource() == JDialogExportElencoDdt.this.tipo) {
                JDialogExportElencoDdt.this.tipoActionPerformed(evt);
            }
        }

        @Override
        public void focusGained(FocusEvent evt) {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (evt.getSource() == JDialogExportElencoDdt.this.comCliFor) {
                JDialogExportElencoDdt.this.comCliForFocusLost(evt);
            } else if (evt.getSource() == JDialogExportElencoDdt.this.causali) {
                JDialogExportElencoDdt.this.causaliFocusLost(evt);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getSource() == JDialogExportElencoDdt.this.comCliFor) {
                JDialogExportElencoDdt.this.comCliForItemStateChanged(evt);
            } else if (evt.getSource() == JDialogExportElencoDdt.this.causali) {
                JDialogExportElencoDdt.this.causaliItemStateChanged(evt);
            }
        }
    }
}

