/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex.gui;

import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.commons.CastUtils;
import it.tnx.commons.DateUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.DebugUtils;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.KeyValuePair;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.commons.table.EditorUtils;
import it.tnx.invoicex.InvoicexUtil;
import it.tnx.invoicex.Magazzino;
import it.tnx.invoicex.data.Giacenza;
import it.tnx.invoicex.gui.LineBreakPanelRenderer;
import it.tnx.invoicex.gui.MultiLineHeaderRenderer;
import it.tnx.invoicex.iu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.layout.GroupLayout;

public class JDialogSceltaQuantita
extends JDialog {
    String tipodoc_da = null;
    String tipodoc_a = null;
    Integer[] ids = null;
    public boolean ok;
    public boolean loading = false;
    public boolean check_giacenze = false;
    KeyValuePair kvd1 = new KeyValuePair((Object)Magazzino.Depositi.TUTTI_DETTAGLIO, (Object)"<tutti i depositi>");
    public static HashMap cache_servizio;
    public JCheckBox cheMovimentaDaDeposito;
    private JButton conferma;
    public JComboBox deposito;
    private JLabel giacenze_da;
    public JLabel int1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    public JCheckBox non_evadere_ordine;
    public JButton selevadibile;
    private JButton seltutto;
    private JButton seltutto1;
    public JTable tab;
    private JCheckBox tutterigheconfermate;
    Map<Object, Map<String, Giacenza>> cache_giac = new HashMap<Object, Map<String, Giacenza>>();

    public JDialogSceltaQuantita(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.tab.getTableHeader().setReorderingAllowed(false);
        if (main.fileIni.getValueBoolean("pref", "tutterigheconfermate", false).booleanValue()) {
            this.tutterigheconfermate.setSelected(true);
        }
        this.tab.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        MultiLineHeaderRenderer renderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enum1 = this.tab.getColumnModel().getColumns();
        while (enum1.hasMoreElements()) {
            enum1.nextElement().setHeaderRenderer(renderer);
        }
        final JTextField tf = new JTextField();
        tf.setFont(this.tab.getFont());
        tf.setBorder(BorderFactory.createEmptyBorder());
        tf.setHorizontalAlignment(4);
        tf.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                tf.selectAll();
            }
        });
        DefaultCellEditor editor = new DefaultCellEditor(tf){
            boolean init;
            JTable table;
            int row;
            int col;
            {
                super(x0);
                this.init = false;
                this.table = null;
                this.row = -1;
                this.col = -1;
            }

            @Override
            public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, int row, int column) {
                JTextField tf2 = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
                if (!this.init) {
                    this.init = true;
                    this.table = table;
                    tf2.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            this.textchange(table.getSelectedRow());
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            this.textchange(table.getSelectedRow());
                        }

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            this.textchange(table.getSelectedRow());
                        }
                    });
                }
                this.row = row;
                this.col = column;
                tf2.setText(FormatUtils.formatPerc((double)CastUtils.toDouble0((Object)value)));
                int col_lotti = table.getColumn("gestione_lotti").getModelIndex();
                col_lotti = table.convertColumnIndexToView(col_lotti);
                tf2.setEditable(true);
                tf2.setToolTipText("Indicare la quantit\u00e0 da confermare per la conversione del documento");
                return tf2;
            }

            private void textchange(int row) {
                if (JDialogSceltaQuantita.this.loading) {
                    return;
                }
                if (row < 0) {
                    return;
                }
                if (row >= this.table.getRowCount()) {
                    return;
                }
                if (this.table != null) {
                    double qtaconf = CastUtils.toDouble0((Object)tf.getText());
                    double qta = CastUtils.toDouble0((Object)this.table.getValueAt(row, this.table.getColumn("quantit\u00e0").getModelIndex()));
                    double prezzo = CastUtils.toDouble0((Object)this.table.getValueAt(row, this.table.getColumn("prezzo").getModelIndex()));
                    JDialogSceltaQuantita.this.loading = true;
                    if (qtaconf > 0.0) {
                        this.table.setValueAt(true, row, this.table.getColumn("riga confermata").getModelIndex());
                    } else if (prezzo != 0.0 || qta > 0.0) {
                        this.table.setValueAt(false, row, this.table.getColumn("riga confermata").getModelIndex());
                    }
                    JDialogSceltaQuantita.this.loading = false;
                }
            }

            @Override
            public Object getCellEditorValue() {
                return CastUtils.toDouble((Object)super.getCellEditorValue());
            }

            @Override
            public int getClickCountToStart() {
                return 1;
            }
        };
        this.tab.getColumn("quantit\u00e0 confermata").setCellEditor(editor);
        this.non_evadere_ordine.setVisible(false);
    }

    public void load(String da_tipo_doc, String a_tipo_doc, Integer[] ids, Boolean dest_fatt_proforma) {
        String sql = "";
        this.tipodoc_da = da_tipo_doc;
        this.tipodoc_a = a_tipo_doc;
        this.ids = ids;
        if (dest_fatt_proforma == null) {
            dest_fatt_proforma = false;
        }
        if (main.getPersonalContain("consegna_e_scarico") && da_tipo_doc.equals(Db.TIPO_DOCUMENTO_ORDINE) && a_tipo_doc.equals(Db.TIPO_DOCUMENTO_FATTURA) && dest_fatt_proforma.booleanValue()) {
            this.non_evadere_ordine.setVisible(true);
            this.non_evadere_ordine.setSelected(true);
        }
        if (da_tipo_doc.equals(Db.TIPO_DOCUMENTO_DDT) || da_tipo_doc.equals(Db.TIPO_DOCUMENTO_DDT_ACQUISTO)) {
            this.cheMovimentaDaDeposito.setVisible(false);
        }
        this.setIntestazione();
        try {
            if (Magazzino.isMultiDeposito()) {
                SwingUtils.initJComboFromDb((JComboBox)this.deposito, (Connection)Db.getConn(), (String)"select id, nome from depositi order by nome", (String)"id", (String)"nome", (KeyValuePair[])new KeyValuePair[]{this.kvd1});
                if (!main.fileIni.existKey("pref", "depositoSceltaLottiDepositoStandard")) {
                    Integer id = ids[0];
                    sql = "select deposito";
                    sql = sql + " from " + Db.getNomeTabT(da_tipo_doc) + " t ";
                    sql = sql + " where id = " + id;
                    Integer codice_deposito = cu.i((Object)dbu.getObject((Connection)Db.getConn(), (String)sql));
                    if (codice_deposito != null) {
                        SwingUtils.findJComboKV((JComboBox)this.deposito, (Object)codice_deposito);
                        if (main.fileIni.getValueBoolean("pref", "cheMovimentaDaDeposito", true).booleanValue()) {
                            this.cheMovimentaDaDeposito.setSelected(true);
                        }
                    }
                }
            } else {
                this.giacenze_da.setVisible(false);
                this.deposito.setVisible(false);
                this.cheMovimentaDaDeposito.setVisible(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!main.getPersonalContain("snj") || !da_tipo_doc.contains(Db.TIPO_DOCUMENTO_ORDINE)) {
            this.tab.removeColumn(this.tab.getColumn("emissione fattura"));
            this.tab.removeColumn(this.tab.getColumn("percentuale"));
            this.tab.removeColumn(this.tab.getColumn("termini_pagamento"));
        }
        int conta_righe_totali = 0;
        for (int i = 0; i < ids.length; ++i) {
            int id = ids[i];
            try {
                sql = "select count(*) ";
                sql = sql + " from " + Db.getNomeTabT(da_tipo_doc) + " t left join " + Db.getNomeTabR(da_tipo_doc) + " r on t.id = r.id_padre";
                sql = sql + " where t.id = " + id;
                conta_righe_totali += cu.i0((Object)dbu.getObject((Connection)Db.conn, (String)sql)).intValue();
                continue;
            }
            catch (Exception e) {
                SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)e);
            }
        }
        try {
            if (cache_servizio == null && conta_righe_totali > 10 && cu.i0((Object)dbu.getObject((Connection)Db.getConn(), (String)"select count(*) from articoli")) < 100000) {
                cache_servizio = dbu.getListMapMap((Connection)Db.getConn(), (String)"select codice, servizio from articoli", (String)"codice");
                System.out.println(DebugUtils.getSize((Object)cache_servizio));
            }
        }
        catch (Exception ex) {
            SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)ex);
        }
        DefaultTableModel m = this.getModel();
        int riga = 0;
        for (int i = 0; i < ids.length; ++i) {
            int id = ids[i];
            try {
                sql = "select t.id as tid, t.serie, t.numero, t.data, t.anno, r.id as rid, r.riga, r.codice_articolo, r.descrizione, r.quantita, r.quantita_evasa, r." + this.getCampoin(a_tipo_doc) + " as dest_id, r." + this.getCampoin(a_tipo_doc) + "_riga as dest_id_riga, r.prezzo ";
                if (main.getPersonalContain("snj") && da_tipo_doc.equals(Db.TIPO_DOCUMENTO_ORDINE)) {
                    sql = sql + ", em.descrizione as emissione_fattura, r.percentuale, r.termini_pagamento ";
                }
                sql = sql + ", a.gestione_lotti ";
                sql = sql + " from " + Db.getNomeTabT(da_tipo_doc) + " t left join " + Db.getNomeTabR(da_tipo_doc) + " r on t.id = r.id_padre";
                sql = sql + " left join articoli a ON r.codice_articolo = a.codice ";
                if (main.getPersonalContain("snj") && da_tipo_doc.equals(Db.TIPO_DOCUMENTO_ORDINE)) {
                    sql = sql + " left join tipi_emissione_fattura em ON r.emissione_fattura = em.id ";
                }
                sql = sql + " where t.id = " + id + " order by r.riga";
                System.out.println("sql = " + sql);
                ArrayList righe = DbUtils.getListMap((Connection)Db.conn, (String)sql);
                if (righe != null && righe.size() > 0) {
                    Map map = (Map)righe.get(0);
                    Object[] row = new Object[m.getColumnCount()];
                    row[4] = "--- " + Db.getDescTipoDocNomeFile(da_tipo_doc) + " " + map.get("serie") + map.get("numero") + " del " + DateUtils.formatDateIta((Date)cu.toDate(map.get("data"))) + " ---";
                    this.getModel().addRow(row);
                    ++riga;
                }
                for (Map map : righe) {
                    Object[] row = new Object[m.getColumnCount()];
                    row[0] = Db.getDescTipoDocBreve(da_tipo_doc) + " " + map.get("id") + " " + map.get("serie") + "/" + map.get("numero") + "/" + map.get("anno");
                    row[1] = Db.getDescTipoDocBreve(a_tipo_doc);
                    row[2] = map.get("riga");
                    row[3] = map.get("codice_articolo");
                    row[4] = map.get("descrizione");
                    row[5] = map.get("quantita");
                    row[6] = 0;
                    row[7] = true;
                    row[8] = map.get("tid");
                    row[9] = map.get("rid");
                    row[10] = map.get("dest_id");
                    row[11] = map.get("dest_id_riga");
                    row[12] = cu.d0(map.get("quantita_evasa")) < 0.0 ? 0.0 : cu.d0(map.get("quantita_evasa"));
                    row[13] = map.get("prezzo");
                    if (main.getPersonalContain("snj") && da_tipo_doc.contains(Db.TIPO_DOCUMENTO_ORDINE)) {
                        row[14] = map.get("emissione_fattura");
                        row[15] = map.get("percentuale");
                        row[16] = map.get("termini_pagamento");
                    }
                    row[17] = map.get("gestione_lotti");
                    row[18] = this.getGiacenza(cu.s(map.get("codice_articolo")), riga);
                    this.getModel().addRow(row);
                    ++riga;
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.tab.getColumn("descrizione").setCellRenderer(new LineBreakPanelRenderer(this.tab.getFont()));
        try {
            this.tab.getColumn("quantit\u00e0").setCellRenderer(InvoicexUtil.getNumber0_5Renderer());
            this.tab.getColumn("quantit\u00e0 confermata").setCellRenderer(InvoicexUtil.getNumber0_5Renderer());
            DecimalFormat df1 = new DecimalFormat("0.#####");
            this.tab.getColumn("quantit\u00e0 confermata").setCellEditor((TableCellEditor)new EditorUtils.NumberEditor(new JTextField(), df1){

                public Object getCellEditorValue() {
                    String text = ((JTextField)this.editorComponent).getText();
                    Double qta_evasa = CastUtils.toDouble0All((Object)text);
                    return qta_evasa;
                }
            });
            this.tab.getColumn("giacenza").setCellRenderer(InvoicexUtil.getNumber0_5Renderer());
            this.tab.getColumn("riga confermata").setCellRenderer(new MyBooleanRenderer());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.seltuttoActionPerformed(null);
        this.tab.requestFocus();
        this.tab.editCellAt(0, this.tab.getColumn("quantit\u00e0 confermata").getModelIndex());
        this.tab.changeSelection(0, this.tab.getColumn("quantit\u00e0 confermata").getModelIndex(), false, false);
        if (this.deposito.getSelectedIndex() == 0) {
            this.cheMovimentaDaDeposito.setSelected(false);
            this.cheMovimentaDaDeposito.setEnabled(false);
        } else {
            this.cheMovimentaDaDeposito.setEnabled(true);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tab = this.getMyJTable();
        this.conferma = new JButton();
        this.int1 = new JLabel();
        this.seltutto = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.seltutto1 = new JButton();
        this.jLabel1 = new JLabel();
        this.tutterigheconfermate = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.selevadibile = new JButton();
        this.non_evadere_ordine = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.deposito = new JComboBox();
        this.giacenze_da = new JLabel();
        this.cheMovimentaDaDeposito = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.tab.setFont(this.tab.getFont().deriveFont((float)this.tab.getFont().getSize() + 2.0f));
        this.tab.setModel(new DefaultTableModel(new Object[0][], new String[]{"provenienza", "destinazione", "riga", "articolo", "descrizione", "quantit\u00e0", "quantit\u00e0 confermata", "riga confermata", "prov_id", "prov_id_riga", "dest_id", "dest_id_riga", "quantit\u00e0 gi\u00e0 confermata", "prezzo", "emissione fattura", "percentuale", "termini_pagamento", "gestione_lotti", "giacenza"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, Object.class, Integer.class, String.class, String.class, Double.class, Double.class, Boolean.class, Integer.class, Integer.class, Integer.class, Integer.class, Double.class, Double.class, Object.class, Integer.class, String.class, String.class, Double.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tab.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDialogSceltaQuantita.this.tabMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tab);
        if (this.tab.getColumnModel().getColumnCount() > 0) {
            this.tab.getColumnModel().getColumn(0).setMinWidth(0);
            this.tab.getColumnModel().getColumn(0).setPreferredWidth(0);
            this.tab.getColumnModel().getColumn(0).setMaxWidth(0);
            this.tab.getColumnModel().getColumn(1).setMinWidth(0);
            this.tab.getColumnModel().getColumn(1).setPreferredWidth(0);
            this.tab.getColumnModel().getColumn(1).setMaxWidth(0);
            this.tab.getColumnModel().getColumn(2).setPreferredWidth(20);
            this.tab.getColumnModel().getColumn(3).setPreferredWidth(50);
            this.tab.getColumnModel().getColumn(4).setPreferredWidth(200);
            this.tab.getColumnModel().getColumn(5).setPreferredWidth(30);
            this.tab.getColumnModel().getColumn(6).setPreferredWidth(30);
            this.tab.getColumnModel().getColumn(7).setPreferredWidth(30);
            this.tab.getColumnModel().getColumn(8).setMinWidth(0);
            this.tab.getColumnModel().getColumn(8).setPreferredWidth(0);
            this.tab.getColumnModel().getColumn(8).setMaxWidth(0);
            this.tab.getColumnModel().getColumn(9).setMinWidth(0);
            this.tab.getColumnModel().getColumn(9).setPreferredWidth(0);
            this.tab.getColumnModel().getColumn(9).setMaxWidth(0);
            this.tab.getColumnModel().getColumn(10).setMinWidth(0);
            this.tab.getColumnModel().getColumn(10).setPreferredWidth(0);
            this.tab.getColumnModel().getColumn(10).setMaxWidth(0);
            this.tab.getColumnModel().getColumn(11).setMinWidth(0);
            this.tab.getColumnModel().getColumn(11).setPreferredWidth(0);
            this.tab.getColumnModel().getColumn(11).setMaxWidth(0);
            this.tab.getColumnModel().getColumn(12).setPreferredWidth(30);
            this.tab.getColumnModel().getColumn(13).setMinWidth(0);
            this.tab.getColumnModel().getColumn(13).setPreferredWidth(0);
            this.tab.getColumnModel().getColumn(13).setMaxWidth(0);
            this.tab.getColumnModel().getColumn(17).setMinWidth(0);
            this.tab.getColumnModel().getColumn(17).setPreferredWidth(0);
            this.tab.getColumnModel().getColumn(17).setMaxWidth(0);
            this.tab.getColumnModel().getColumn(18).setPreferredWidth(20);
        }
        this.conferma.setIcon(iu.getIcon("conferma"));
        this.conferma.setText("Conferma");
        this.conferma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogSceltaQuantita.this.confermaActionPerformed(evt);
            }
        });
        this.int1.setText("...");
        this.seltutto.setText("Seleziona solo da confermare");
        this.seltutto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogSceltaQuantita.this.seltuttoActionPerformed(evt);
            }
        });
        this.jButton2.setText("Annulla tutto");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogSceltaQuantita.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setIcon(iu.getIcon("annulla"));
        this.jButton3.setText("Annulla");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogSceltaQuantita.this.jButton3ActionPerformed(evt);
            }
        });
        this.seltutto1.setText("Seleziona tutto");
        this.seltutto1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogSceltaQuantita.this.seltutto1ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("<html>Da questa schermata devi scegliere sia le quantit\u00e0 da confermare sia le righe stesse (colonna 'riga confermata'),<br />puoi scegliere ad esempio di impostare la quantit\u00e0 a 0 ma di esportare comunque la riga.<br>Le righe 'verdi' sono quelle che verranno portate nel nuovo documento</html>");
        this.tutterigheconfermate.setText("Preferisco come standard avere tutte le righe confermate ");
        this.tutterigheconfermate.setHorizontalTextPosition(2);
        this.tutterigheconfermate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogSceltaQuantita.this.tutterigheconfermateActionPerformed(evt);
            }
        });
        this.jSeparator1.setMinimumSize(new Dimension(50, 4));
        this.jSeparator1.setPreferredSize(new Dimension(50, 4));
        this.jSeparator1.setRequestFocusEnabled(false);
        this.selevadibile.setText("Seleziona solo evadibile");
        this.selevadibile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogSceltaQuantita.this.selevadibileActionPerformed(evt);
            }
        });
        this.non_evadere_ordine.setText("Non evadere l'ordine");
        this.non_evadere_ordine.setHorizontalTextPosition(2);
        this.deposito.setToolTipText("Da qui puoi scegliere da quale deposito controllare le giacenze ma non cambia il deposito da movimentare");
        this.deposito.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogSceltaQuantita.this.depositoActionPerformed(evt);
            }
        });
        this.giacenze_da.setText("Giacenze da");
        this.giacenze_da.setToolTipText("Da qui puoi scegliere da quale deposito controllare le giacenze ma non cambia il deposito da movimentare");
        this.cheMovimentaDaDeposito.setText("movimenta questo deposito");
        this.cheMovimentaDaDeposito.setToolTipText("Verr\u00e0 utilizzato come deposito da movimentare");
        this.cheMovimentaDaDeposito.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogSceltaQuantita.this.cheMovimentaDaDepositoActionPerformed(evt);
            }
        });
        this.jLabel3.setText(" ");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.tutterigheconfermate).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.non_evadere_ordine).addPreferredGap(0).add((Component)this.jLabel2)).add(2, (Component)this.jScrollPane1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jSeparator1, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jLabel1)).addPreferredGap(0, 41, Short.MAX_VALUE).add((Component)this.jButton3).addPreferredGap(0).add((Component)this.conferma)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.int1).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButton2).add(6, 6, 6).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.giacenze_da).addPreferredGap(0).add((Component)this.deposito, -2, -1, -2).addPreferredGap(0).add((Component)this.cheMovimentaDaDeposito).addPreferredGap(0).add((Component)this.jLabel3)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.seltutto).addPreferredGap(0).add((Component)this.selevadibile).addPreferredGap(0).add((Component)this.seltutto1))))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.int1).add((Component)this.seltutto1).add((Component)this.seltutto).add((Component)this.jButton2).add((Component)this.selevadibile)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.deposito, -2, -1, -2).add((Component)this.giacenze_da).add((Component)this.cheMovimentaDaDeposito).add((Component)this.jLabel3, -2, 1, -2)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 272, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.conferma).add((Component)this.jButton3).add((Component)this.jLabel1, -2, -1, -2)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 4, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.tutterigheconfermate).add((Component)this.non_evadere_ordine).add((Component)this.jLabel2)).addContainerGap()));
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        SwingUtils.mouse_wait((Component)this);
        for (int i = 0; i < this.tab.getRowCount(); ++i) {
            if (this.tab.getValueAt(i, 0) == null) continue;
            this.tab.setValueAt(0, i, this.tab.getColumn("quantit\u00e0 confermata").getModelIndex());
        }
        SwingUtils.mouse_def((Component)this);
    }

    private void seltuttoActionPerformed(ActionEvent evt) {
        SwingUtils.mouse_wait((Component)this);
        for (int i = 0; i < this.tab.getRowCount(); ++i) {
            double qta_evasa;
            if (this.tab.getValueAt(i, 0) == null) continue;
            double qta = CastUtils.toDouble0((Object)this.tab.getValueAt(i, this.tab.getColumn("quantit\u00e0").getModelIndex()));
            double qta_da_evadere = qta - (qta_evasa = CastUtils.toDouble0((Object)this.tab.getValueAt(i, this.tab.getColumn("quantit\u00e0 gi\u00e0 confermata").getModelIndex())).doubleValue());
            if (qta_da_evadere < 0.0) {
                qta_da_evadere = 0.0;
            }
            this.tab.setValueAt(qta_da_evadere, i, this.tab.getColumn("quantit\u00e0 confermata").getModelIndex());
            if (!this.tutterigheconfermate.isSelected()) {
                if (qta_evasa > 0.0 && qta_da_evadere <= 0.0) {
                    this.tab.setValueAt(false, i, this.tab.getColumn("riga confermata").getModelIndex());
                    continue;
                }
                if (qta_da_evadere > 0.0) {
                    this.tab.setValueAt(true, i, this.tab.getColumn("riga confermata").getModelIndex());
                    continue;
                }
                this.tab.setValueAt(false, i, this.tab.getColumn("riga confermata").getModelIndex());
                continue;
            }
            this.tab.setValueAt(true, i, this.tab.getColumn("riga confermata").getModelIndex());
        }
        SwingUtils.mouse_def((Component)this);
    }

    private void confermaActionPerformed(ActionEvent evt) {
        double qta_evasa;
        int i;
        this.ok = true;
        if (this.check_giacenze) {
            boolean giac_ok = true;
            for (i = 0; i < this.tab.getRowCount(); ++i) {
                qta_evasa = CastUtils.toDouble0((Object)this.tab.getValueAt(i, this.tab.getColumn("quantit\u00e0 confermata").getModelIndex()));
                Double giacenza = cu.d((Object)this.tab.getValueAt(i, this.tab.getColumnModel().getColumnIndex("giacenza")));
                if (giacenza == null || !(qta_evasa > giacenza)) continue;
                giac_ok = false;
                break;
            }
            if (!giac_ok && !SwingUtils.showYesNoMessage((Component)this, (String)"Ci sono uno o pi\u00f9 articoli con giacenza insufficiente per l'evasione, sicuro di continuare ?", (String)"Attenzione, giacenza insufficiente")) {
                return;
            }
        }
        if (main.getPersonalContain("snj")) {
            String terminiPagamento = "";
            for (i = 0; i < this.tab.getRowCount(); ++i) {
                qta_evasa = CastUtils.toDouble0((Object)this.tab.getValueAt(i, this.tab.getColumn("quantit\u00e0 confermata").getModelIndex()));
                boolean convertire = CastUtils.toBoolean((Object)this.tab.getValueAt(i, this.tab.getColumn("riga confermata").getModelIndex()));
                if (!convertire) continue;
                try {
                    String newTerminiPagamento = CastUtils.toString((Object)this.tab.getValueAt(i, this.tab.getColumn("termini_pagamento").getModelIndex()));
                    if (terminiPagamento.equals("")) {
                        terminiPagamento = newTerminiPagamento;
                        continue;
                    }
                    if (terminiPagamento.equals(newTerminiPagamento)) continue;
                    SwingUtils.showErrorMessage((Component)this, (String)"Non \u00e8 possibile convertire righe con termini di pagamento diversi", (String)"Errore Termini di Pagamento", (boolean)true);
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        this.setVisible(false);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.ok = false;
        this.setVisible(false);
    }

    private void seltutto1ActionPerformed(ActionEvent evt) {
        SwingUtils.mouse_wait((Component)this);
        for (int i = 0; i < this.tab.getRowCount(); ++i) {
            if (this.tab.getValueAt(i, 0) == null) continue;
            double qta = CastUtils.toDouble0((Object)this.tab.getValueAt(i, this.tab.getColumn("quantit\u00e0").getModelIndex()));
            double qta_evasa = CastUtils.toDouble0((Object)this.tab.getValueAt(i, this.tab.getColumn("quantit\u00e0 gi\u00e0 confermata").getModelIndex()));
            double qta_da_evadere = qta;
            this.tab.setValueAt(qta_da_evadere, i, this.tab.getColumn("quantit\u00e0 confermata").getModelIndex());
            this.tab.setValueAt(true, i, this.tab.getColumn("riga confermata").getModelIndex());
        }
        SwingUtils.mouse_def((Component)this);
    }

    private void tabMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2 && this.tab.getValueAt(this.tab.getSelectedRow(), 0) != null) {
            this.changeRigaConfermata();
        }
    }

    private void tutterigheconfermateActionPerformed(ActionEvent evt) {
        main.fileIni.setValue("pref", "tutterigheconfermate", this.tutterigheconfermate.isSelected());
    }

    private void selevadibileActionPerformed(ActionEvent evt) {
        SwingUtils.mouse_wait((Component)this);
        for (int i = 0; i < this.tab.getRowCount(); ++i) {
            if (this.tab.getValueAt(i, 0) == null) continue;
            double qta = CastUtils.toDouble0((Object)this.tab.getValueAt(i, this.tab.getColumn("quantit\u00e0").getModelIndex()));
            double qta_evasa = CastUtils.toDouble0((Object)this.tab.getValueAt(i, this.tab.getColumn("quantit\u00e0 gi\u00e0 confermata").getModelIndex()));
            double giacenza = CastUtils.toDouble0((Object)this.tab.getValueAt(i, this.tab.getColumnModel().getColumnIndex("giacenza")));
            double qta_da_evadere = qta - qta_evasa;
            if (qta_da_evadere < 0.0) {
                qta_da_evadere = 0.0;
            }
            if (qta_da_evadere > giacenza) {
                qta_da_evadere = giacenza;
            }
            this.tab.setValueAt(qta_da_evadere, i, this.tab.getColumn("quantit\u00e0 confermata").getModelIndex());
            if (!this.tutterigheconfermate.isSelected()) {
                if (qta_evasa > 0.0 && qta_da_evadere <= 0.0) {
                    this.tab.setValueAt(false, i, this.tab.getColumn("riga confermata").getModelIndex());
                    continue;
                }
                if (qta_da_evadere > 0.0) {
                    this.tab.setValueAt(true, i, this.tab.getColumn("riga confermata").getModelIndex());
                    continue;
                }
                this.tab.setValueAt(false, i, this.tab.getColumn("riga confermata").getModelIndex());
                continue;
            }
            this.tab.setValueAt(true, i, this.tab.getColumn("riga confermata").getModelIndex());
        }
        SwingUtils.mouse_def((Component)this);
    }

    private void depositoActionPerformed(ActionEvent evt) {
        this.loading = true;
        for (int i = 0; i < this.tab.getRowCount(); ++i) {
            String artriga = cu.s((Object)this.tab.getValueAt(i, this.tab.getColumn("articolo").getModelIndex()));
            if (!StringUtils.isNotBlank((String)artriga)) continue;
            Double giac = this.getGiacenza(artriga, i);
            this.tab.setValueAt(giac, i, this.tab.getColumnModel().getColumnIndex("giacenza"));
        }
        if (this.deposito.getSelectedIndex() == 0) {
            this.cheMovimentaDaDeposito.setSelected(false);
            this.cheMovimentaDaDeposito.setEnabled(false);
        } else {
            this.cheMovimentaDaDeposito.setEnabled(true);
        }
        this.loading = false;
    }

    private void cheMovimentaDaDepositoActionPerformed(ActionEvent evt) {
        main.fileIni.setValue("pref", "cheMovimentaDaDeposito", this.cheMovimentaDaDeposito.isSelected());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDialogSceltaQuantita dialog = new JDialogSceltaQuantita((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public DefaultTableModel getModel() {
        return (DefaultTableModel)this.tab.getModel();
    }

    public JTable getTable() {
        return this.tab;
    }

    private void setIntestazione() {
        this.int1.setText("Selezionare le quantit\u00e0 per il passaggio da " + Db.getDescTipoDoc(this.tipodoc_da) + " a " + Db.getDescTipoDoc(this.tipodoc_a));
        if (this.tipodoc_da == Db.TIPO_DOCUMENTO_ORDINE && (this.tipodoc_a == Db.TIPO_DOCUMENTO_DDT || this.tipodoc_a == Db.TIPO_DOCUMENTO_FATTURA)) {
            this.check_giacenze = true;
        } else {
            this.selevadibile.setVisible(false);
        }
    }

    private String getCampoin(String tipoDoc) {
        HashMap<String, String> val = new HashMap<String, String>();
        val.put(Db.TIPO_DOCUMENTO_DDT, "in_ddt");
        val.put(Db.TIPO_DOCUMENTO_DDT_ACQUISTO, "in_ddt");
        val.put(Db.TIPO_DOCUMENTO_FATTURA, "in_fatt");
        val.put(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA, "in_fatt");
        val.put(Db.TIPO_DOCUMENTO_SCONTRINO, "in_fatt");
        try {
            return (String)val.get(tipoDoc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return tipoDoc;
        }
    }

    private void changeRigaConfermata() {
        boolean val = CastUtils.toBoolean((Object)this.tab.getValueAt(this.tab.getSelectedRow(), this.tab.getColumn("riga confermata").getModelIndex()));
        if (val) {
            this.tab.setValueAt(false, this.tab.getSelectedRow(), this.tab.getColumn("riga confermata").getModelIndex());
        } else {
            this.tab.setValueAt(true, this.tab.getSelectedRow(), this.tab.getColumn("riga confermata").getModelIndex());
        }
    }

    private void ricalcolareGiacenze(String codart) {
        if (StringUtils.isNotBlank((String)codart)) {
            for (int i = 1; i < this.tab.getRowCount(); ++i) {
                String artriga = cu.s((Object)this.tab.getValueAt(i, this.tab.getColumn("articolo").getModelIndex()));
                if (this.tab.getValueAt(i, 0) == null || !artriga.equals(codart)) continue;
                Double giac = this.getGiacenza(artriga, i);
                this.tab.setValueAt(giac, i, this.tab.getColumnModel().getColumnIndex("giacenza"));
            }
        }
    }

    private Double getGiacenza(String articolo, int riga) {
        if (StringUtils.isBlank((String)articolo)) {
            return null;
        }
        String servizio = "";
        if (cache_servizio != null && cache_servizio.containsKey(articolo)) {
            servizio = cu.s(((Map)cache_servizio.get(articolo)).get("servizio"));
        } else {
            try {
                if (StringUtils.isNotBlank((String)articolo)) {
                    servizio = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)("select servizio from articoli where codice = " + dbu.sql((Object)articolo)), (boolean)false));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (servizio.equalsIgnoreCase("s")) {
            return null;
        }
        Object depkey = null;
        ArrayList list = null;
        Map<String, Giacenza> giacmap = null;
        try {
            if (this.deposito.isVisible()) {
                depkey = this.deposito.getSelectedItem();
            }
            if (this.cache_giac.get(depkey) == null) {
                list = !this.deposito.isVisible() || this.deposito.getSelectedItem() == this.kvd1 ? main.magazzino.getGiacenza(false, null, null, null, false, true, true, null) : main.magazzino.getGiacenza(false, null, null, null, false, true, true, ((KeyValuePair)this.deposito.getSelectedItem()).getKey());
                giacmap = new TreeMap<String, Giacenza>(String.CASE_INSENSITIVE_ORDER);
                for (Giacenza g : list) {
                    giacmap.put(g.getCodice_articolo(), g);
                }
                this.cache_giac.put(depkey, giacmap);
                list = null;
            }
            giacmap = this.cache_giac.get(depkey);
        }
        catch (Exception e) {
            e.printStackTrace();
            SwingUtils.showExceptionMessage((Component)this, (Exception)e);
        }
        double giacenza = 0.0;
        if (giacmap != null && giacmap.size() > 0) {
            try {
                Giacenza g = giacmap.get(articolo);
                if (g != null) {
                    giacenza = g.getGiacenza();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (riga > 0) {
            for (int i = riga - 1; i >= 0; --i) {
                String art_riga = cu.s((Object)this.tab.getValueAt(i, this.tab.getColumn("articolo").getModelIndex()));
                Double qta_conf = cu.d((Object)this.tab.getValueAt(i, this.tab.getColumn("quantit\u00e0 confermata").getModelIndex()));
                Boolean riga_conf = cu.toBoolean((Object)this.tab.getValueAt(i, this.tab.getColumn("riga confermata").getModelIndex()));
                if (art_riga == null || !art_riga.equalsIgnoreCase(articolo) || riga_conf == null || !riga_conf.booleanValue() || qta_conf == null) continue;
                giacenza -= qta_conf.doubleValue();
            }
        }
        return giacenza;
    }

    public JTable getMyJTable() {
        return new JTable(){
            Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

            @Override
            public boolean isCellEditable(int row, int column) {
                boolean ret = super.isCellEditable(row, column);
                if (this.getValueAt(row, 0) == null) {
                    return false;
                }
                return ret;
            }

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                super.changeSelection(row, column, toggle, extend);
                System.out.println("changeSel:" + row + " " + column);
                if (this.editCellAt(row, column)) {
                    Component comp = this.getEditorComponent();
                    comp.requestFocusInWindow();
                    if (comp instanceof JTextField) {
                        JTextField textComp = (JTextField)comp;
                        textComp.selectAll();
                    }
                }
            }

            @Override
            public void setValueAt(Object val, int row, int column) {
                super.setValueAt(val, row, column);
                if (!JDialogSceltaQuantita.this.loading && this.getValueAt(row, 0) != null) {
                    if (column == this.getColumn("quantit\u00e0 confermata").getModelIndex()) {
                        Double dval = CastUtils.toDouble0((Object)val);
                        double qtaconf = CastUtils.toDouble0((Object)this.getValueAt(row, this.getColumn("quantit\u00e0 confermata").getModelIndex()));
                        double qta = CastUtils.toDouble0((Object)this.getValueAt(row, this.getColumn("quantit\u00e0").getModelIndex()));
                        double prezzo = CastUtils.toDouble0((Object)this.getValueAt(row, this.getColumn("prezzo").getModelIndex()));
                        String codart = CastUtils.toString((Object)this.getValueAt(row, this.getColumn("articolo").getModelIndex()));
                        String descr = CastUtils.toString((Object)this.getValueAt(row, this.getColumn("descrizione").getModelIndex()));
                        JDialogSceltaQuantita.this.loading = true;
                        if (qtaconf > 0.0) {
                            this.setValueAt(true, row, this.getColumn("riga confermata").getModelIndex());
                        } else if (prezzo != 0.0 || qta > 0.0) {
                            this.setValueAt(false, row, this.getColumn("riga confermata").getModelIndex());
                        }
                        JDialogSceltaQuantita.this.loading = false;
                    } else if (column == this.getColumn("riga confermata").getModelIndex()) {
                        Boolean confermata = CastUtils.toBoolean((Object)this.getValueAt(row, this.getColumn("riga confermata").getModelIndex()));
                        JDialogSceltaQuantita.this.loading = true;
                        if (!confermata.booleanValue()) {
                            this.setValueAt(0, row, this.getColumn("quantit\u00e0 confermata").getModelIndex());
                        }
                        JDialogSceltaQuantita.this.loading = false;
                    }
                    if (column == this.getColumn("quantit\u00e0 confermata").getModelIndex() || column == this.getColumn("riga confermata").getModelIndex()) {
                        JDialogSceltaQuantita.this.ricalcolareGiacenze(cu.s((Object)this.getValueAt(row, this.getColumn("articolo").getModelIndex())));
                    }
                }
            }

            @Override
            public Component prepareEditor(TableCellEditor editor, int row, int column) {
                Component comp = super.prepareEditor(editor, row, column);
                Color back = Color.WHITE;
                if (CastUtils.toBoolean((Object)this.getValueAt(row, this.getColumn("riga confermata").getModelIndex()))) {
                    back = this.isCellSelected(row, column) ? (column == this.getColumn("quantit\u00e0 confermata").getModelIndex() ? new Color(240, 255, 240) : new Color(200, 255, 200)) : (column == this.getColumn("quantit\u00e0 confermata").getModelIndex() ? new Color(240, 255, 240) : new Color(220, 255, 220));
                } else if (this.isCellSelected(row, column)) {
                    back = new Color(245, 245, 245);
                }
                if (column == this.getColumnModel().getColumnIndex("quantit\u00e0 confermata") || column == this.getColumnModel().getColumnIndex("giacenza")) {
                    double qta_confermata = cu.d0((Object)this.getValueAt(row, this.getColumnModel().getColumnIndex("quantit\u00e0 confermata")));
                    Double giacenza = cu.d((Object)this.getValueAt(row, this.getColumnModel().getColumnIndex("giacenza")));
                    if (giacenza != null && qta_confermata > giacenza) {
                        back = new Color(245, 235, 225);
                    }
                }
                if (column == this.getColumn("quantit\u00e0 confermata").getModelIndex()) {
                    comp.setFont(this.getFont().deriveFont(1));
                } else {
                    comp.setFont(this.getFont().deriveFont(0));
                }
                comp.setBackground(back);
                comp.setForeground(Color.BLACK);
                return comp;
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                Color back = Color.WHITE;
                if (CastUtils.toBoolean((Object)this.getValueAt(row, this.getColumn("riga confermata").getModelIndex()))) {
                    back = this.isCellSelected(row, column) ? (column == this.getColumn("quantit\u00e0 confermata").getModelIndex() ? new Color(240, 255, 240) : new Color(200, 255, 200)) : (column == this.getColumn("quantit\u00e0 confermata").getModelIndex() ? new Color(240, 255, 240) : new Color(220, 255, 220));
                } else if (this.isCellSelected(row, column)) {
                    back = new Color(245, 245, 245);
                }
                if (column == this.getColumnModel().getColumnIndex("quantit\u00e0 confermata") || column == this.getColumnModel().getColumnIndex("giacenza")) {
                    double qta_confermata = cu.d0((Object)this.getValueAt(row, this.getColumnModel().getColumnIndex("quantit\u00e0 confermata")));
                    Double giacenza = cu.d((Object)this.getValueAt(row, this.getColumnModel().getColumnIndex("giacenza")));
                    if (giacenza != null && qta_confermata > giacenza) {
                        back = new Color(245, 235, 225);
                    }
                }
                if (this.getValueAt(row, 0) == null) {
                    comp.setFont(this.getFont().deriveFont(2));
                    back = new Color(250, 250, 250);
                } else {
                    comp.setFont(this.getFont().deriveFont(0));
                }
                comp.setForeground(Color.BLACK);
                comp.setBackground(back);
                if (column == this.getColumn("quantit\u00e0 confermata").getModelIndex()) {
                    comp.setFont(this.getFont().deriveFont(1));
                } else if (column == this.getColumnModel().getColumnIndex("giacenza")) {
                    Color c = comp.getForeground();
                    double qta = CastUtils.toDouble0All((Object)this.getValueAt(row, this.getColumnModel().getColumnIndex("giacenza")));
                    if (qta <= 0.0) {
                        if ((c.getRed() + c.getGreen() + c.getBlue()) / 3 > 125) {
                            comp.setForeground(new Color(255, 180, 180));
                        } else {
                            comp.setForeground(Color.RED);
                        }
                    }
                }
                if (comp instanceof JLabel) {
                    ((JLabel)comp).setBorder(this.noFocusBorder);
                }
                return comp;
            }
        };
    }

    static class SpinnerEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        final JSpinner spinner = new JSpinner();

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            try {
                if (value instanceof Double || value instanceof BigDecimal) {
                    double valMax = CastUtils.toDouble0((Object)table.getValueAt(row, column - 1));
                    double val = CastUtils.toDouble0((Object)value);
                    this.spinner.setModel(new SpinnerNumberModel(val, 0.0, valMax, 0.1));
                } else {
                    int valMax = CastUtils.toInteger0((Object)table.getValueAt(row, column - 1));
                    int val = CastUtils.toInteger0((Object)value);
                    this.spinner.setModel(new SpinnerNumberModel(val, 0, valMax, 1));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.spinner.setValue(value);
            return this.spinner;
        }

        @Override
        public boolean isCellEditable(EventObject evt) {
            if (evt instanceof MouseEvent) {
                return ((MouseEvent)evt).getClickCount() >= 2;
            }
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return this.spinner.getValue();
        }
    }

    public static class MyBooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private static final long serialVersionUID = 1L;
        private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        JLabel lab = new JLabel("");

        MyBooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.lab.setOpaque(true);
            this.lab.setBackground(new Color(250, 250, 250));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table.getValueAt(row, 0) == null) {
                return this.lab;
            }
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(this.noFocusBorder);
            }
            return this;
        }
    }
}

