/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex.gui;

import gestioneFatture.Db;
import gestioneFatture.main;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.lang.StringUtils;

public class JDialogSceltaVariante
extends JDialog {
    public Integer variante_id = null;
    public boolean confermato = false;
    public Double prezzo_lordo = null;
    public Double sconto1 = null;
    public Double sconto2 = null;
    public String descAggiuntiva = null;
    public boolean eng = false;
    List<ButtonGroup> bgVars = new ArrayList<ButtonGroup>();
    Map<JRadioButton, Map> mapRad = new HashMap<JRadioButton, Map>();
    public JButton butAnnulla;
    public JButton butConferma;
    public JScrollPane jScrollPane1;
    public JLabel labCodice;
    public JLabel labDescrizione;
    public JLabel labPrezzo;
    public JPanel panTipiVarianti;

    public JDialogSceltaVariante(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public void load(String codice, String descrizione, boolean eng) {
        this.labCodice.setText(codice);
        this.labDescrizione.setText(descrizione);
        this.labPrezzo.setText("");
        this.eng = eng;
        String sql = "select tv.id, tvl.ita from dettagliovarianti_varianti dvv\nleft join varianti v on dvv.variante_id = v.id\nleft join dettagliovarianti dv on dvv.dettagliovariante_id = dv.id\nleft join tipivariante tv on dv.tipovariante_id = tv.id\nleft join labels tvl on tv.nome_lbl_id = tvl.id\nwhere variante_id in (select id from varianti where articolo_id = " + dbu.sql((Object)codice) + ")\ngroup by tv.id\norder by tv.ord";
        try {
            ArrayList list = dbu.getListMap((Connection)Db.getConn(), (String)sql);
            for (Map m : list) {
                JPanel panvar = new JPanel();
                panvar.setLayout(new BoxLayout(panvar, 1));
                JLabel lab = new JLabel(cu.s(m.get("ita")));
                panvar.add(lab);
                sql = "select dv.id, dvl.ita as varIta, dvl.eng as varEng, tvl.ita as tipoIta, tvl.eng as tipoEng from dettagliovarianti_varianti dvv\nleft join varianti v on dvv.variante_id = v.id\nleft join dettagliovarianti dv on dvv.dettagliovariante_id = dv.id\nleft join labels dvl on dv.nome_lbl_id = dvl.id\nleft join tipivariante tv on dv.tipovariante_id = tv.id\nleft join labels tvl on tv.nome_lbl_id = tvl.id\nwhere variante_id in (select id from varianti where articolo_id = " + dbu.sql((Object)codice) + ")\nand tv.id = " + dbu.sql(m.get("id")) + "\ngroup by dv.id";
                ArrayList listVar = dbu.getListMap((Connection)Db.getConn(), (String)sql);
                ButtonGroup bgVar = new ButtonGroup();
                for (Map mvar : listVar) {
                    JRadioButton rad = new JRadioButton(cu.s(mvar.get("varIta")));
                    this.mapRad.put(rad, mvar);
                    panvar.add(rad);
                    rad.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                JDialogSceltaVariante.this.aggiornaPrezzo();
                            }
                            catch (Exception ex) {
                                SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)ex);
                            }
                        }
                    });
                    bgVar.add(rad);
                }
                this.bgVars.add(bgVar);
                this.panTipiVarianti.add(panvar);
            }
        }
        catch (Exception e) {
            SwingUtils.showExceptionMessage((Component)this, (Exception)e);
        }
    }

    private void aggiornaPrezzo() throws Exception {
        this.descAggiuntiva = "";
        int conta = 0;
        ArrayList<String> ids = new ArrayList<String>();
        for (JRadioButton r : this.mapRad.keySet()) {
            String var;
            if (!r.isSelected()) continue;
            ++conta;
            System.out.println("id var " + this.mapRad.get(r).get("id"));
            ids.add(" dettagliovariante_id = " + dbu.sql(this.mapRad.get(r).get("id")));
            String tipo = cu.s(this.mapRad.get(r).get(this.eng ? "tipoEng" : "tipoIta"));
            if (StringUtils.isBlank((String)tipo)) {
                tipo = cu.s(this.mapRad.get(r).get("tipoIta"));
            }
            if (StringUtils.isBlank((String)(var = cu.s(this.mapRad.get(r).get(this.eng ? "varEng" : "varIta"))))) {
                var = cu.s(this.mapRad.get(r).get("varIta"));
            }
            this.descAggiuntiva = this.descAggiuntiva + "\n" + tipo + ": " + var;
        }
        if (conta == this.bgVars.size()) {
            String sql = "select variante_id, count(*) from dettagliovarianti_varianti dv ";
            sql = sql + " join varianti v on dv.variante_id = v.id and v.articolo_id = " + dbu.sql((Object)this.labCodice.getText());
            sql = sql + " where ";
            sql = sql + StringUtils.join(ids, (String)" or ");
            sql = sql + " group by variante_id \n";
            sql = sql + " having count(*) = " + conta;
            System.out.println("sql = " + sql);
            Integer varid = cu.i((Object)dbu.getObject((Connection)Db.getConn(), (String)sql));
            sql = "select * from varianti where id = " + dbu.sql((Object)varid);
            ArrayList list = dbu.getListMap((Connection)Db.getConn(), (String)sql);
            if (list.size() > 0) {
                double base;
                Map m = (Map)list.get(0);
                this.variante_id = cu.i(m.get("id"));
                double prezzo = base = cu.d0(m.get("prezzo")).doubleValue();
                this.prezzo_lordo = base;
                String p = FormatUtils.formatEuroIta((double)cu.d0(m.get("prezzo"))) + " \u20ac";
                double sconto1 = cu.d0(m.get("sconto1"));
                this.sconto1 = sconto1;
                if (sconto1 != 0.0) {
                    prezzo *= (100.0 - sconto1) / 100.0;
                    p = p + " -" + FormatUtils.formatNum0_5Dec((double)sconto1) + "%";
                }
                double sconto2 = cu.d0(m.get("sconto2"));
                this.sconto2 = sconto2;
                if (sconto2 != 0.0) {
                    prezzo *= (100.0 - sconto2) / 100.0;
                    p = p + " -" + FormatUtils.formatNum0_5Dec((double)sconto2) + "%";
                }
                if (sconto1 != 0.0 || sconto2 != 0.0) {
                    p = p + " prezzo finale " + FormatUtils.formatEuroIta((double)cu.d0((Object)prezzo)) + " \u20ac";
                }
                this.labPrezzo.setText(p);
            } else {
                this.labPrezzo.setText("");
            }
        } else {
            this.labPrezzo.setText("");
        }
    }

    private void initComponents() {
        this.labCodice = new JLabel();
        this.labDescrizione = new JLabel();
        this.butConferma = new JButton();
        this.butAnnulla = new JButton();
        this.labPrezzo = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.panTipiVarianti = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Scelta Variante");
        this.labCodice.setText("jLabel1");
        this.labDescrizione.setText("jLabel2");
        this.butConferma.setText("Conferma");
        this.butConferma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogSceltaVariante.this.butConfermaActionPerformed(evt);
            }
        });
        this.butAnnulla.setText("Annulla");
        this.butAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogSceltaVariante.this.butAnnullaActionPerformed(evt);
            }
        });
        this.labPrezzo.setText("jLabel1");
        this.panTipiVarianti.setLayout(new BoxLayout(this.panTipiVarianti, 1));
        this.jScrollPane1.setViewportView(this.panTipiVarianti);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.labPrezzo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 433, Short.MAX_VALUE).addComponent(this.butAnnulla).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.butConferma)).addGroup(layout.createSequentialGroup().addComponent(this.labCodice).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labDescrizione).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labCodice).addComponent(this.labDescrizione)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 443, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.butConferma).addComponent(this.butAnnulla).addComponent(this.labPrezzo)).addContainerGap()));
        this.pack();
    }

    private void butConfermaActionPerformed(ActionEvent evt) {
        if (StringUtils.isBlank((String)this.labPrezzo.getText())) {
            SwingUtils.showErrorMessage((Component)this, (String)"Seleziona tutti i tipi di variante");
            return;
        }
        this.confermato = true;
        this.dispose();
    }

    private void butAnnullaActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(JDialogSceltaVariante.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(JDialogSceltaVariante.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(JDialogSceltaVariante.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(JDialogSceltaVariante.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDialogSceltaVariante dialog = new JDialogSceltaVariante((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

