/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex.gui;

import gestioneFatture.Util;
import it.tnx.Db;
import it.tnx.commons.DateUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.KeyValuePair;
import it.tnx.commons.SwingUtils;
import it.tnx.dbeans.JTableDb;
import it.tnx.dbeans.pdfPrint.PrintSimpleTable;
import it.tnx.invoicex.iu;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXDatePicker;
import tnxbeans.tnxComboField;

public class JDialogTotaliFatture
extends JDialog {
    private JTableDb griglia;
    public JXDatePicker al;
    public JButton annulla;
    public tnxComboField comAgente;
    public JXDatePicker dal;
    public JComboBox formato;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JLabel jLabel4;
    public JLabel jLabel5;
    public JLabel jLabel7;
    public JSeparator jSeparator1;
    public JComboBox ordine;
    public JButton stampa;
    public JComboBox tipo;

    public JDialogTotaliFatture(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.dal.setFormats(new DateFormat[]{new SimpleDateFormat("dd/MM/yyyy")});
        this.al.setFormats(new DateFormat[]{new SimpleDateFormat("dd/MM/yyyy")});
        this.comAgente.dbAddElement("<tutti gli agenti>", "*");
        this.comAgente.dbOpenList(Db.getConn(), "SELECT nome, id FROM agenti ORDER BY nome");
        Vector<KeyValuePair> v = new Vector<KeyValuePair>();
        v.add(new KeyValuePair((Object)"pdf", (Object)"PDF"));
        v.add(new KeyValuePair((Object)"html", (Object)"HTML"));
        v.add(new KeyValuePair((Object)"xls", (Object)"EXCEL"));
        v.add(new KeyValuePair((Object)"csv", (Object)"CSV"));
        SwingUtils.initJComboFromKVList((JComboBox)this.formato, v);
        v = new Vector();
        v.add(new KeyValuePair((Object)"clie.codice", (Object)"codice cliente/fornitore"));
        v.add(new KeyValuePair((Object)"clie.ragione_sociale", (Object)"ragione sociale cliente/fornitore"));
        v.add(new KeyValuePair((Object)"agen.id, clie.codice", (Object)"codice agente, codice cliente/fornitore"));
        v.add(new KeyValuePair((Object)"agen.nome, clie.ragione_sociale", (Object)"nome agente, ragione sociale cliente"));
        SwingUtils.initJComboFromKVList((JComboBox)this.ordine, v);
    }

    private void initComponents() {
        this.stampa = new JButton();
        this.annulla = new JButton();
        this.tipo = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel5 = new JLabel();
        this.formato = new JComboBox();
        this.dal = new JXDatePicker();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.al = new JXDatePicker();
        this.jLabel7 = new JLabel();
        this.comAgente = new tnxComboField();
        this.jLabel2 = new JLabel();
        this.ordine = new JComboBox();
        this.jSeparator1 = new JSeparator();
        FormListener formListener = new FormListener();
        this.setDefaultCloseOperation(2);
        this.setTitle("Export Totali Fatture");
        this.setMinimumSize(new Dimension(412, 215));
        this.stampa.setFont(this.stampa.getFont().deriveFont(this.stampa.getFont().getStyle() | 1));
        this.stampa.setIcon(iu.getIcon("conferma"));
        this.stampa.setText("Esporta");
        this.stampa.addActionListener(formListener);
        this.annulla.setIcon(iu.getIcon("annulla"));
        this.annulla.setText("Annulla");
        this.annulla.addActionListener(formListener);
        this.tipo.setModel(new DefaultComboBoxModel<String>(new String[]{"Vendita", "Acquisto"}));
        this.tipo.setSelectedItem("Vendita");
        this.tipo.addActionListener(formListener);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Origine");
        this.jLabel1.setPreferredSize(new Dimension(80, 14));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Formato Stampa");
        this.jLabel5.setPreferredSize(new Dimension(80, 14));
        this.formato.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Dal");
        this.jLabel3.setPreferredSize(new Dimension(80, 14));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Al");
        this.jLabel4.setPreferredSize(new Dimension(80, 14));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("Agente");
        this.jLabel7.setPreferredSize(new Dimension(80, 14));
        this.comAgente.setDbDescCampo("");
        this.comAgente.setDbNomeCampo("");
        this.comAgente.setDbTipoCampo("");
        this.comAgente.setDbTrovaMentreScrive(true);
        this.comAgente.addItemListener(formListener);
        this.comAgente.addFocusListener(formListener);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Ordinamento");
        this.jLabel2.setPreferredSize(new Dimension(80, 14));
        this.ordine.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1, -2, -1, -2).addPreferredGap(0).add((Component)this.tipo, 0, -1, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel7, -2, -1, -2).addPreferredGap(0).add((Component)this.comAgente, -2, 233, -2))).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel5, -2, 115, -2).addPreferredGap(0).add((Component)this.formato, 0, -1, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel4, -2, -1, -2).add(2, (Component)this.jLabel2, -2, -1, -2)).add((Component)this.jLabel3, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.ordine, -2, 194, -2).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.dal, -1, -1, Short.MAX_VALUE).add(1, (Component)this.al, -1, 137, Short.MAX_VALUE)))))).add(31, 31, 31)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jSeparator1, -1, 425, Short.MAX_VALUE).addContainerGap())).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.annulla).addPreferredGap(0).add((Component)this.stampa).addContainerGap()))));
        layout.linkSize(new Component[]{this.jLabel1, this.jLabel2, this.jLabel3, this.jLabel4, this.jLabel5, this.jLabel7}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1, -2, -1, -2).add((Component)this.tipo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.comAgente, -2, -1, -2).add((Component)this.jLabel7, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3, -2, 18, -2).add((Component)this.dal, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4, -2, -1, -2).add((Component)this.al, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2, -2, -1, -2).add((Component)this.ordine, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5, -2, -1, -2).add((Component)this.formato, -2, -1, -2)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.stampa).add((Component)this.annulla)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void stampaActionPerformed(ActionEvent evt) {
        String nomeFile;
        this.setCursor(new Cursor(3));
        int[] headerWidth = null;
        String tabella = this.tipo.getSelectedItem().equals("Acquisto") ? "test_fatt_acquisto" : "test_fatt";
        String sql = "SELECT ";
        sql = tabella.equals("test_fatt") ? sql + "clie.codice as 'Cod. Cliente', clie.ragione_sociale as 'Cliente', agen.nome as 'Agente', SUM(IF(fatt.tipo_fattura = 3, -fatt.totale_imponibile, fatt.totale_imponibile)) as 'Totale Imponibile', SUM(IF(fatt.tipo_fattura = 3,-fatt.totale_iva,fatt.totale_iva)) as 'Imposta', SUM(IF(fatt.tipo_fattura = 3, -fatt.totale,fatt.totale)) as 'Totale Fatturato'" : sql + "clie.codice as 'Cod. Cliente', clie.ragione_sociale as 'Cliente', SUM(IF(fatt.tipo_fattura = 9, -fatt.imponibile, fatt.imponibile)) as 'Totale Imponibile',  SUM(IF(fatt.tipo_fattura = 3,-fatt.iva,fatt.iva)) as 'Imposta', SUM(IF(fatt.tipo_fattura = 9,-fatt.importo,fatt.importo)) as 'Totale Fatturato' ";
        sql = sql + "FROM " + tabella + " fatt LEFT JOIN clie_forn clie";
        if (tabella.equals("test_fatt")) {
            sql = sql + " ON fatt.cliente = clie.codice ";
            sql = sql + "LEFT JOIN agenti agen ON fatt.agente_codice = agen.id ";
        } else {
            sql = sql + " ON fatt.fornitore = clie.codice ";
        }
        sql = sql + " WHERE 1 = 1 ";
        if (this.dal.getDate() != null) {
            sql = tabella.equals("test_fatt") ? sql + " AND data >= " + DbUtils.pc2((Date)this.dal.getDate(), (int)91) : sql + " AND data_doc >= " + DbUtils.pc2((Date)this.dal.getDate(), (int)91);
        }
        if (this.al.getDate() != null) {
            sql = tabella.equals("test_fatt") ? sql + " AND data <= " + DbUtils.pc2((Date)this.al.getDate(), (int)91) : sql + " AND data_doc <= " + DbUtils.pc2((Date)this.al.getDate(), (int)91);
        }
        if (this.comAgente.getSelectedIndex() > 0 && tabella.equals("test_fatt")) {
            sql = sql + " and agente_codice = '" + this.comAgente.getSelectedKey() + "'";
        }
        sql = sql + " GROUP BY clie.codice";
        if (tabella.equals("test_fatt")) {
            sql = sql + ", agen.id";
        }
        sql = sql + " ORDER BY " + ((KeyValuePair)this.ordine.getSelectedItem()).key;
        ResultSet rs = null;
        try {
            System.out.println("sql:\n" + sql);
            rs = DbUtils.tryOpenResultSetEditable((Connection)Db.conn, (String)sql);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setCursor(new Cursor(0));
            SwingUtils.showErrorMessage((Component)this, (String)ex.getMessage());
            return;
        }
        PrintSimpleTable print = new PrintSimpleTable(rs);
        print.totali = true;
        String caption = "Statistiche Totale Fatture";
        String caption2 = "";
        try {
            ResultSet r = Db.openResultSet("select ragione_sociale from dati_azienda");
            if (r.next()) {
                caption2 = caption2 + r.getString(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (caption2.length() > 0) {
            caption2 = caption2 + " - ";
        }
        caption2 = caption2 + this.tipo.getSelectedItem();
        caption2 = caption2 + "\nAgente: " + this.comAgente.getSelectedItem();
        caption2 = caption2 + "\nDal: " + DateUtils.formatDate((Date)this.dal.getDate()) + " Al: " + DateUtils.formatDate((Date)this.al.getDate());
        headerWidth = tabella.equals("test_fatt") ? new int[]{10, 40, 20, 10, 10, 10} : new int[]{10, 60, 10, 10, 10};
        if (((KeyValuePair)this.formato.getSelectedItem()).key.toString().equalsIgnoreCase("pdf")) {
            print.print(caption, headerWidth, ((KeyValuePair)this.formato.getSelectedItem()).key.toString(), caption2, "", -2);
            Util.start("tempStampa.pdf");
        } else if (((KeyValuePair)this.formato.getSelectedItem()).key.toString().equalsIgnoreCase("xls")) {
            nomeFile = print.printExcel(caption, headerWidth, caption2, "");
            Util.start(nomeFile);
        } else if (((KeyValuePair)this.formato.getSelectedItem()).key.toString().equalsIgnoreCase("csv")) {
            nomeFile = print.printCsv(caption, headerWidth, caption2, "");
            File fdir = new File(new File(nomeFile).getAbsolutePath());
            fdir = fdir.getParentFile();
            System.out.println("fdir:" + fdir);
            Util.start(fdir.getAbsolutePath());
        } else {
            print.print(caption, headerWidth, ((KeyValuePair)this.formato.getSelectedItem()).key.toString(), caption2, "");
            Util.start("tempStampa.html");
        }
        try {
            rs.getStatement().close();
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCursor(new Cursor(0));
    }

    private void annullaActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void comAgenteItemStateChanged(ItemEvent evt) {
    }

    private void comAgenteFocusLost(FocusEvent evt) {
    }

    private void tipoActionPerformed(ActionEvent evt) {
        if (this.tipo.getSelectedItem().equals("Acquisto")) {
            this.comAgente.setEnabled(false);
            Vector<KeyValuePair> v = new Vector<KeyValuePair>();
            v.add(new KeyValuePair((Object)"clie.codice", (Object)"codice cliente/fornitore"));
            v.add(new KeyValuePair((Object)"clie.ragione_sociale", (Object)"ragione sociale cliente/fornitore"));
            SwingUtils.initJComboFromKVList((JComboBox)this.ordine, v);
        } else {
            this.comAgente.setEnabled(true);
            Vector<KeyValuePair> v = new Vector<KeyValuePair>();
            v.add(new KeyValuePair((Object)"clie.codice", (Object)"codice cliente/fornitore"));
            v.add(new KeyValuePair((Object)"clie.ragione_sociale", (Object)"ragione sociale cliente/fornitore"));
            v.add(new KeyValuePair((Object)"agen.id, clie.codice", (Object)"codice agente, codice cliente/fornitore"));
            v.add(new KeyValuePair((Object)"agen.nome, clie.ragione_sociale", (Object)"nome agente, ragione sociale cliente"));
            SwingUtils.initJComboFromKVList((JComboBox)this.ordine, v);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDialogTotaliFatture dialog = new JDialogTotaliFatture((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public JTableDb getGriglia() {
        return this.griglia;
    }

    public void setGriglia(JTableDb griglia) {
        this.griglia = griglia;
    }

    private class FormListener
    implements ActionListener,
    FocusListener,
    ItemListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == JDialogTotaliFatture.this.stampa) {
                JDialogTotaliFatture.this.stampaActionPerformed(evt);
            } else if (evt.getSource() == JDialogTotaliFatture.this.annulla) {
                JDialogTotaliFatture.this.annullaActionPerformed(evt);
            } else if (evt.getSource() == JDialogTotaliFatture.this.tipo) {
                JDialogTotaliFatture.this.tipoActionPerformed(evt);
            }
        }

        @Override
        public void focusGained(FocusEvent evt) {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (evt.getSource() == JDialogTotaliFatture.this.comAgente) {
                JDialogTotaliFatture.this.comAgenteFocusLost(evt);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getSource() == JDialogTotaliFatture.this.comAgente) {
                JDialogTotaliFatture.this.comAgenteItemStateChanged(evt);
            }
        }
    }
}

