/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex.gui;

import gestioneFatture.ImagePreviewPanel;
import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.commons.CastUtils;
import it.tnx.commons.ImgUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.invoicex.gui.JPanelCategorie;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingworker.SwingWorker;
import org.jdesktop.swingx.JXBusyLabel;
import tnxbeans.DbEvent;
import tnxbeans.DbListener;
import tnxbeans.tnxCheckBox;
import tnxbeans.tnxDbPanel;
import tnxbeans.tnxMemoFieldLang;
import tnxbeans.tnxTextFieldLang;

public class JPanelCategorieDati
extends JPanel {
    private JButton butSave;
    private JButton butUndo;
    private tnxTextFieldLang categoria;
    private tnxDbPanel dati;
    private tnxMemoFieldLang descrizione;
    private JLabel jLabel1;
    private JLabel jLabel29;
    private JLabel jLabel38;
    private JPanel jPanel1;
    private JLabel labImmagine;
    public JXBusyLabel labStatusImgWeb;
    private JMenuItem menElimina;
    private JMenuItem menScegli;
    private JPopupMenu popupImmagine;
    private tnxCheckBox tnxCheckBox1;

    public JPanelCategorieDati() {
        this.initComponents();
        this.labStatusImgWeb.setVisible(false);
        List<String> langs = Arrays.asList("it", "en", "fr");
        this.dati.setLang(langs);
        this.categoria.setLang(langs);
        this.descrizione.setLang(langs);
        this.dati.dbNomeTabella = "categorie";
        Vector<String> chiave = new Vector<String>();
        chiave.add("id");
        this.dati.dbChiave = chiave;
        this.dati.butSave = this.butSave;
        this.dati.butUndo = this.butUndo;
        this.dati.addDbListener(new DbListener(){

            @Override
            public void statusFired(DbEvent event) {
                if (event.getStatus() == tnxDbPanel.STATUS_REFRESHING || event.getStatus() == tnxDbPanel.STATUS_ADDING) {
                    try {
                        JPanelCategorieDati.this.dati.getCampiAggiuntivi().remove("immagine1");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    JPanelCategorieDati.this.refreshImmagine();
                }
                if (event.getStatus() == tnxDbPanel.STATUS_ADDING) {
                    JPanelCategorieDati.this.labImmagine.setText("Nessuna immagine");
                    JPanelCategorieDati.this.labImmagine.setIcon(null);
                }
            }
        });
    }

    public void load(Integer id) {
        this.dati.dbOpen(Db.getConn(), "select * from categorie where id = " + id);
    }

    private void initComponents() {
        this.popupImmagine = new JPopupMenu();
        this.menScegli = new JMenuItem();
        this.menElimina = new JMenuItem();
        this.dati = new tnxDbPanel();
        this.categoria = new tnxTextFieldLang();
        this.jLabel1 = new JLabel();
        this.jLabel38 = new JLabel();
        this.labImmagine = new JLabel();
        this.labStatusImgWeb = new JXBusyLabel();
        this.jLabel29 = new JLabel();
        this.descrizione = new tnxMemoFieldLang();
        this.tnxCheckBox1 = new tnxCheckBox();
        this.jPanel1 = new JPanel();
        this.butUndo = new JButton();
        this.butSave = new JButton();
        this.menScegli.setText("Scegli Immagine");
        this.menScegli.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCategorieDati.this.menScegliActionPerformed(evt);
            }
        });
        this.popupImmagine.add(this.menScegli);
        this.menElimina.setText("Elimina");
        this.menElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCategorieDati.this.menEliminaActionPerformed(evt);
            }
        });
        this.popupImmagine.add(this.menElimina);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                JPanelCategorieDati.this.formComponentResized(evt);
            }

            @Override
            public void componentShown(ComponentEvent evt) {
                JPanelCategorieDati.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.categoria.setBorder(BorderFactory.createEtchedBorder());
        this.categoria.setDbNomeCampo("nome");
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Categoria");
        this.jLabel38.setHorizontalAlignment(4);
        this.jLabel38.setText("immagine");
        this.labImmagine.setHorizontalAlignment(0);
        this.labImmagine.setText("Nessuna immagine");
        this.labImmagine.setToolTipText("Clicca con il tasto destro per le opzioni");
        this.labImmagine.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.shadow")));
        this.labImmagine.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelCategorieDati.this.labImmagineMouseClicked(evt);
            }
        });
        this.labStatusImgWeb.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.labStatusImgWeb.setHorizontalAlignment(4);
        this.labStatusImgWeb.setText("...");
        this.labStatusImgWeb.setBusy(true);
        this.labStatusImgWeb.setHorizontalTextPosition(2);
        this.jLabel29.setHorizontalAlignment(4);
        this.jLabel29.setText("Descrizione");
        this.descrizione.setBorder(BorderFactory.createEtchedBorder());
        this.descrizione.setDbNomeCampo("descrizione");
        this.descrizione.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                JPanelCategorieDati.this.descrizioneFocusLost(evt);
            }
        });
        this.tnxCheckBox1.setText("Visibile solo se utente registrato");
        this.tnxCheckBox1.setDbNomeCampo("visibile_se_registrato");
        GroupLayout datiLayout = new GroupLayout((Container)this.dati);
        this.dati.setLayout((LayoutManager)datiLayout);
        datiLayout.setHorizontalGroup((GroupLayout.Group)datiLayout.createParallelGroup(1).add((GroupLayout.Group)datiLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)datiLayout.createParallelGroup(1).add((GroupLayout.Group)datiLayout.createSequentialGroup().add((Component)this.jLabel38, -2, 99, -2).addPreferredGap(0)).add((GroupLayout.Group)datiLayout.createParallelGroup(1).add((GroupLayout.Group)datiLayout.createSequentialGroup().add((Component)this.jLabel1, -1, 100, Short.MAX_VALUE).addPreferredGap(0)).add((GroupLayout.Group)datiLayout.createSequentialGroup().add((Component)this.jLabel29, -2, 99, -2).add(6, 6, 6)))).add((GroupLayout.Group)datiLayout.createParallelGroup(2).add((Component)this.labImmagine, -1, 470, Short.MAX_VALUE).add(1, (Component)this.tnxCheckBox1, -2, -1, -2).add(1, (Component)this.descrizione, -1, 470, Short.MAX_VALUE).add(1, (Component)this.categoria, -1, 470, Short.MAX_VALUE).add((GroupLayout.Group)datiLayout.createSequentialGroup().add(379, 379, 379).add((Component)this.labStatusImgWeb, -2, 62, -2))).addContainerGap()));
        datiLayout.setVerticalGroup((GroupLayout.Group)datiLayout.createParallelGroup(1).add((GroupLayout.Group)datiLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)datiLayout.createParallelGroup(1, false).add((Component)this.jLabel1, -1, -1, Short.MAX_VALUE).add((Component)this.categoria, -1, 26, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)datiLayout.createParallelGroup(1).add((Component)this.jLabel29).add((Component)this.descrizione, -1, 45, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)datiLayout.createParallelGroup(2).add(1, (GroupLayout.Group)datiLayout.createSequentialGroup().add((Component)this.tnxCheckBox1, -2, -1, -2).addPreferredGap(0).add((Component)this.labImmagine, -1, 158, Short.MAX_VALUE)).add((Component)this.jLabel38, -1, 183, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.labStatusImgWeb, -2, -1, -2).addContainerGap()));
        this.add((Component)this.dati, "Center");
        this.butUndo.setText("Annulla");
        this.butUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCategorieDati.this.butUndoActionPerformed(evt);
            }
        });
        this.butSave.setText("Conferma");
        this.butSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCategorieDati.this.butSaveActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(434, Short.MAX_VALUE).add((Component)this.butUndo).addPreferredGap(0).add((Component)this.butSave).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.butSave).add((Component)this.butUndo)).addContainerGap()));
        this.add((Component)this.jPanel1, "South");
    }

    private void labImmagineMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            this.menScegliActionPerformed(null);
        }
        if (SwingUtilities.isRightMouseButton(evt)) {
            this.popupImmagine.show(this.labImmagine, evt.getX(), evt.getY());
        }
    }

    private void menScegliActionPerformed(ActionEvent evt) {
        int ret;
        JFileChooser fileChoose = new JFileChooser();
        FileFilter filter1 = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().toLowerCase().endsWith(".jpg") || pathname.getAbsolutePath().toLowerCase().endsWith(".jpeg") || pathname.getAbsolutePath().toLowerCase().endsWith(".gif") || pathname.getAbsolutePath().toLowerCase().endsWith(".bmp") || pathname.getAbsolutePath().toLowerCase().endsWith(".png") || pathname.isDirectory();
            }

            @Override
            public String getDescription() {
                return "File Immagine (*.jpg, *.jpeg, *.gif, *.png, *.bmp)";
            }
        };
        fileChoose.addChoosableFileFilter(filter1);
        ImagePreviewPanel preview = new ImagePreviewPanel();
        fileChoose.setAccessory(preview);
        fileChoose.addPropertyChangeListener(preview);
        String path = main.prefs.get("articoli_path_chooser_immagine", null);
        if (path != null) {
            fileChoose.setCurrentDirectory(new File(path));
        }
        if ((ret = fileChoose.showOpenDialog(this)) == 0) {
            String file = fileChoose.getSelectedFile().getAbsolutePath();
            if (this.dati.getCampiAggiuntivi() == null) {
                this.dati.setCampiAggiuntivi(new Hashtable());
            }
            file = StringUtils.replace((String)file, (String)"\\", (String)"\\\\");
            this.dati.getCampiAggiuntivi().put("immagine1", Db.pc((Object)file, 12));
            this.dati.dbForzaModificati();
            this.refreshImmagine();
            this.uploadImmagine(file);
        }
        main.prefs.put("articoli_path_chooser_immagine", fileChoose.getCurrentDirectory().getAbsolutePath());
    }

    private void menEliminaActionPerformed(ActionEvent evt) {
        this.labImmagine.setText("Nessuna immagine");
        this.labImmagine.setIcon(null);
        this.labImmagine.setText("Nessuna immagine");
        this.labImmagine.setIcon(null);
        if (this.dati.getCampiAggiuntivi() == null) {
            this.dati.setCampiAggiuntivi(new Hashtable());
        }
        this.dati.getCampiAggiuntivi().put("immagine1", "null");
        this.dati.dbForzaModificati();
    }

    private void butSaveActionPerformed(ActionEvent evt) {
        if (this.dati.dbSave()) {
            this.dispose();
        }
    }

    private void butUndoActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void formComponentShown(ComponentEvent evt) {
        this.refreshImmagine();
    }

    private void formComponentResized(ComponentEvent evt) {
        this.refreshImmagine();
    }

    private void descrizioneFocusLost(FocusEvent evt) {
    }

    public void refreshImmagine() {
        int w0 = this.labImmagine.getWidth();
        int h0 = this.labImmagine.getHeight();
        if (w0 == 0 && h0 == 0) {
            w0 = 420;
            h0 = 155;
        }
        final int w = w0;
        final int h = h0;
        if (w > 0 && h > 0) {
            Thread t = new Thread("refresh immagine"){

                @Override
                public void run() {
                    try {
                        String immagine = null;
                        try {
                            immagine = StringUtils.replace((String)StringUtils.remove((String)((String)JPanelCategorieDati.this.dati.getCampiAggiuntivi().get("immagine1")), (String)"'"), (String)"\\\\", (String)"\\");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (immagine == null || immagine.length() == 0) {
                            immagine = CastUtils.toString((Object)JPanelCategorieDati.this.dati.dbGetField("immagine1"));
                        }
                        if (StringUtils.isEmpty((String)immagine)) {
                            SwingUtils.inEdt((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    JPanelCategorieDati.this.labImmagine.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.shadow")));
                                    JPanelCategorieDati.this.labImmagine.setIcon(null);
                                    JPanelCategorieDati.this.labImmagine.setText("Nessuna immagine");
                                }
                            });
                        } else {
                            SwingUtils.inEdtWait((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    JPanelCategorieDati.this.labImmagine.setBorder(null);
                                    JPanelCategorieDati.this.labImmagine.setIcon(null);
                                    JPanelCategorieDati.this.labImmagine.setText("... caricamento ...");
                                }
                            });
                            BufferedImage i = ImageIO.read(new File(immagine));
                            final BufferedImage ir = ImgUtils.applyFrame3((BufferedImage)ImgUtils.resizeQuality((BufferedImage)i, (Dimension)ImgUtils.getDimension((int)i.getWidth(), (int)i.getHeight(), (int)w, (int)h)), (Color)JPanelCategorieDati.this.labImmagine.getBackground());
                            SwingUtils.inEdt((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    JPanelCategorieDati.this.labImmagine.setText("");
                                    JPanelCategorieDati.this.labImmagine.setIcon(new ImageIcon(ir));
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        SwingUtils.inEdt((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                JPanelCategorieDati.this.labImmagine.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.shadow")));
                                JPanelCategorieDati.this.labImmagine.setIcon(null);
                                JPanelCategorieDati.this.labImmagine.setText("Nessuna immagine");
                            }
                        });
                    }
                }
            };
            t.start();
        }
    }

    public void dispose() {
    }

    public static void main(String[] args) throws IOException {
        JPanelCategorie.main(args);
    }

    private void uploadImmagine(final String file) {
        this.labStatusImgWeb.setVisible(true);
        this.labStatusImgWeb.setText("upload in corso...");
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                try {
                    File fupload = null;
                    BufferedImage image = ImageIO.read(new File(file));
                    File temp = null;
                    if (image.getWidth() > 1400 || image.getHeight() > 1200) {
                        temp = new File(main.wd + "temp_img_categorie_upload/" + new File(file).getName());
                        temp.getParentFile().mkdirs();
                        temp.delete();
                        image = ImgUtils.resizeQuality((BufferedImage)image, (Dimension)ImgUtils.getDimension((int)image.getWidth(), (int)image.getHeight(), (int)1400, (int)1200));
                        ImgUtils.writeJpeg((BufferedImage)image, (String)temp.getAbsolutePath(), (float)0.9f);
                        fupload = temp;
                    } else {
                        fupload = new File(file);
                    }
                    HttpClient httpclient = new HttpClient();
                    PostMethod post = new PostMethod("http://www.perlegitane.it/invoicex.php");
                    File f = new File(file);
                    Part[] parts = new Part[]{new StringPart("upload_img", "1"), new StringPart("categoria", JPanelCategorieDati.this.categoria.getText("it")), new FilePart(f.getName(), fupload)};
                    post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
                    int ret = httpclient.executeMethod((HttpMethod)post);
                    System.out.println("ret = " + ret);
                    String resp = post.getResponseBodyAsString();
                    System.out.println("resp = " + resp);
                    post.releaseConnection();
                    if (temp != null) {
                        temp.delete();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }

            protected void done() {
                JPanelCategorieDati.this.labStatusImgWeb.setVisible(false);
            }
        };
        worker.execute();
    }
}

