/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex.gui.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.AbstractBorder;

public class SmoothBorder
extends AbstractBorder {
    private Color borderColour;
    private int gap;

    public SmoothBorder(Color colour, int g) {
        this.borderColour = colour;
        this.gap = g;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        super.paintBorder(c, g, x, y, width, height);
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.setColor(this.borderColour);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            g2d.drawRoundRect(x + 1, y + 1, width - 2, height - 2, 15, 15);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(this.gap, this.gap, this.gap, this.gap));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = insets.bottom = this.gap;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

