/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex2;

import gestioneFatture.GenericFrmTest;
import gestioneFatture.InvoicexEvent;
import gestioneFatture.Menu;
import gestioneFatture.MenuPanel;
import gestioneFatture.UnZip;
import gestioneFatture.dbFattura;
import gestioneFatture.frmElenDDT;
import gestioneFatture.frmElenFatt;
import gestioneFatture.frmElenFattAcquisto;
import gestioneFatture.frmElenOrdini;
import gestioneFatture.frmElenSchedeLav;
import gestioneFatture.frmTestDocu;
import gestioneFatture.frmTestFatt;
import gestioneFatture.frmTestFattAcquisto;
import gestioneFatture.frmTestOrdine;
import gestioneFatture.frmTestSchedaLav;
import gestioneFatture.logic.documenti.DettaglioIva;
import gestioneFatture.logic.documenti.Documento;
import gestioneFatture.logic.documenti.IvaDed;
import gestioneFatture.main;
import it.tnx.ClassPathHacker;
import it.tnx.Db;
import it.tnx.Util;
import it.tnx.commons.DateUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.HttpUtils;
import it.tnx.commons.PlatformUtilsCommon;
import it.tnx.commons.RunnableWithArgs;
import it.tnx.commons.RuntimeUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.commons.table.EditorUtils;
import it.tnx.commons.table.RendererUtils;
import it.tnx.invoicex.InvoicexUtil;
import it.tnx.invoicex.iu;
import it.tnx.invoicex2.JDialogUpdate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import li.flor.nativejfilechooser.NativeJFileChooser;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingworker.SwingWorker;
import tnxbeans.tnxDbGrid;

public class InvoicexUtil2 {
    public static void aggiornaLimite100() {
        final MenuPanel mp = main.getPadrePanel();
        String color = "black";
        String msg = null;
        String tooltip = null;
        try {
            Integer anno = DateUtils.getCurrentYear();
            List<Map> list = InvoicexUtil2.getListLimite100(anno);
            Integer ordini = cu.i0(list.get(0).get("tot"));
            Integer ordini_acq = cu.i0(list.get(1).get("tot"));
            Integer ddt = cu.i0(list.get(2).get("tot"));
            Integer ddt_acq = cu.i0(list.get(3).get("tot"));
            Integer fatture = cu.i0(list.get(4).get("tot"));
            Integer fatture_acq = cu.i0(list.get(5).get("tot"));
            Integer tot = ordini + ordini_acq + ddt + ddt_acq + fatture + fatture_acq;
            if (tot >= 95) {
                color = "red";
            } else if (tot >= 75) {
                color = "red";
            }
            msg = ordini + ordini_acq + ddt + ddt_acq + fatture + fatture_acq + "/100";
            tooltip = "<html>Documenti per anno " + anno + "<br><br><table border=\"0\" cellpadding=\"2\" cellspacing=\"2\"><tr><td>preventivi/ordini vendita</td><td>" + ordini + "</td></tr><tr><td>preventivi/ordini acquisto</td><td>" + ordini_acq + "</td></tr><tr><td>ddt vendita</td><td>" + ddt + "</td></tr><tr><td>ddt acquisto</td><td>" + ddt_acq + "</td></tr><tr><td>fatture vendita</td><td>" + fatture + "</td></tr><tr><td>fatture acquisto</td><td>" + fatture_acq + "</td></tr><tr><td>totale</td><td><b>" + tot + "</b></td></tr></table><br></html>";
        }
        catch (Exception e) {
            e.printStackTrace();
            msg = "errore " + e.getMessage();
            tooltip = "";
        }
        final String text = "<html>Limte Invoicex Free: <b><font color='" + color + "'>" + msg + "</font></b></html>";
        final String ftooltip = tooltip;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                mp.menAiutoLimiti.setText(text);
                mp.menAiutoLimiti.setToolTipText(ftooltip);
                for (ActionListener al : mp.menAiutoLimiti.getActionListeners()) {
                    mp.menAiutoLimiti.removeActionListener(al);
                }
                mp.menAiutoLimiti.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingUtils.showInfoMessage((Component)main.getPadreFrame(), (String)ftooltip);
                    }
                });
            }
        });
    }

    public static boolean checkLimite100(Integer anno) throws Exception {
        if (!main.versione.equalsIgnoreCase("free")) {
            return true;
        }
        if (anno <= 2018) {
            return true;
        }
        List<Map> list = InvoicexUtil2.getListLimite100(anno);
        Integer tot = 0;
        for (Map m : list) {
            tot = tot + cu.i0(m.get("tot"));
        }
        if (tot >= 100) {
            Integer ordini = cu.i0(list.get(0).get("tot"));
            Integer ordini_acq = cu.i0(list.get(1).get("tot"));
            Integer ddt = cu.i0(list.get(2).get("tot"));
            Integer ddt_acq = cu.i0(list.get(3).get("tot"));
            Integer fatture = cu.i0(list.get(4).get("tot"));
            Integer fatture_acq = cu.i0(list.get(5).get("tot"));
            String msg = "Hai raggiunto il limite di documenti gestibili da Invoicex Free (100 documenti per anno)\nHai " + tot + " documenti per l'anno " + anno + "\n\nDettagli:\npreventivi/ordini vendita : " + ordini + "\npreventivi/ordini acquisto : " + ordini_acq + "\nddt vendita : " + ddt + "\nddt acquisto : " + ddt_acq + "\nfatture vendita : " + fatture + "\nfatture acquisto : " + fatture_acq + "\n\ntotale : " + tot;
            SwingUtils.showInfoMessage((Component)InvoicexUtil.getActiveJInternalFrame(), (String)msg, (String)"Invoicex Free - limite 100 documenti raggiunto");
            return false;
        }
        return true;
    }

    private static List<Map> getListLimite100(Integer anno) throws Exception {
        String sql = "select 'prev./ordini vendita', count(*) as tot from test_ordi where year(data) = " + anno + "\nunion all\nselect 'prev./ordini acquisto', count(*) as tot from test_ordi_acquisto where year(data) = " + anno + "\nunion all\nselect 'ddt vendita', count(*) as tot from test_ddt where year(data) = " + anno + "\nunion all\nselect 'ddt acquisto', count(*) as tot from test_ddt_acquisto where year(data) = " + anno + "\nunion all\nselect 'fatture vendita', count(*) as tot from test_fatt where year(data) = " + anno + "\nunion all\nselect 'fatture acquisto', count(*) as tot from test_fatt_acquisto where year(data) = " + anno + "";
        return dbu.getListMap((Connection)Db.getConn(), (String)sql);
    }

    public static int getCountLimite100() throws Exception {
        if (!main.versione.equalsIgnoreCase("free") && !main.debug) {
            return 0;
        }
        List<Map> list = InvoicexUtil2.getListLimite100(DateUtils.getCurrentYear());
        Integer tot = 0;
        for (Map m : list) {
            tot = tot + cu.i0(m.get("tot"));
        }
        return tot;
    }

    public static boolean isValidEmailAddress(String email) {
        boolean result = true;
        try {
            InternetAddress emailAddr = new InternetAddress(email);
            emailAddr.validate();
        }
        catch (AddressException ex) {
            result = false;
        }
        return result;
    }

    public static void editDoc(Component parent, String tipoDocumento, Integer id) {
        InvoicexUtil2.editDoc(parent, tipoDocumento, id, null);
    }

    public static void editDoc(final Component parent, final String tipoDocumento, final Integer id, final RunnableWithArgs runAfter) {
        try {
            if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_FATTURA) && dbFattura.fatturaBloccata(id, (Integer)dbu.getObject((Connection)Db.getConn(), (String)("SELECT tipo_fattura FROM test_fatt WHERE id = " + dbu.sql((Object)id)), (boolean)true))) {
                SwingUtils.showErrorMessage((Component)parent, (String)"Impossibile procedere, la fattura risulta bloccata perch\u00e8 inclusa in una stampa definitiva del registro iva!\nPuoi vederne il contenuto con il pulsante di Stampa");
                return;
            }
            if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA) && dbFattura.fatturaBloccata(id, 7)) {
                SwingUtils.showErrorMessage((Component)parent, (String)"Impossibile procedere, la fattura risulta bloccata perch\u00e8 inclusa in una stampa definitiva del registro iva!\nPuoi vederne il contenuto con il pulsante di Stampa");
                return;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(frmElenFatt.class.getName()).log(Level.SEVERE, null, ex);
        }
        List<JInternalFrame> frames = InvoicexUtil.getFrames(GenericFrmTest.class);
        for (JInternalFrame iframe : frames) {
            GenericFrmTest f = (GenericFrmTest)((Object)iframe);
            if (!InvoicexUtil2.isFrmTipoDocumento(f, tipoDocumento) || f.getId() == null || !f.getId().equals(id)) continue;
            main.getPadre().getDesktopPane().getDesktopManager().activateFrame((JInternalFrame)((Object)f));
            if (runAfter != null) {
                runAfter.run(new Object[]{f});
            }
            return;
        }
        final tnxDbGrid griglia = (tnxDbGrid)SwingUtils.getCompByNameRicorsivoContainer((Container)((Container)parent), (String)"griglia");
        if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_FATTURA)) {
            String sql = "";
            try {
                String msg;
                int ret;
                Statement stat = Db.getConn().createStatement();
                sql = "select stampato from test_fatt";
                sql = sql + " where id = " + id;
                ResultSet resu = stat.executeQuery(sql);
                if (resu.next()) {
                    GregorianCalendar cal = new GregorianCalendar();
                    if (resu.getDate("stampato") != null) {
                        String msg2;
                        int ret2;
                        cal.setTime(resu.getDate("stampato"));
                        if (cal.get(1) >= 2000 && (ret2 = JOptionPane.showConfirmDialog(null, msg2 = "La fattura e' gia' stata stampata, Sicuro di proseguire ?", "Attenzione", 0, 0)) == 1) {
                            parent.setCursor(new Cursor(0));
                            if (griglia != null) {
                                griglia.setCursor(new Cursor(0));
                            }
                            return;
                        }
                    }
                }
                sql = "select id, data_scadenza, importo, distinta from scadenze";
                sql = sql + " where documento_tipo = " + Db.pc((Object)Db.TIPO_DOCUMENTO_FATTURA, 12);
                sql = sql + " and id_doc = " + id;
                resu = stat.executeQuery(sql = sql + " and distinta is not null");
                if (resu.next() && (ret = JOptionPane.showConfirmDialog(null, msg = "La fattura e' legata ad una o piu' scadenze gia' stampate in distinta\nSicuro di proseguire ?", "Attenzione", 0)) == 1) {
                    parent.setCursor(new Cursor(0));
                    if (griglia != null) {
                        griglia.setCursor(new Cursor(0));
                    }
                    return;
                }
            }
            catch (Exception err) {
                err.printStackTrace();
                JOptionPane.showMessageDialog(parent, "Errore:" + err.toString(), "Attenzione", 0);
            }
            try {
                String err = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)("select tipo_fattura from test_fatt where id = " + id), (boolean)true));
            }
            catch (Exception e) {
                SwingUtils.showInfoMessage((Component)parent, (String)"Impossibile trovare il documento");
                parent.setCursor(new Cursor(0));
                return;
            }
        }
        SwingUtils.inEdt((Runnable)new Runnable(){

            @Override
            public void run() {
                System.out.println("wait cursor");
                parent.setCursor(new Cursor(3));
                if (griglia != null) {
                    griglia.setCursor(new Cursor(3));
                }
            }
        });
        if (!InvoicexUtil.checkLock(Db.getNomeTabT(tipoDocumento), id, true, parent)) {
            parent.setCursor(new Cursor(0));
            return;
        }
        SwingWorker worker1 = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                String numerocompleto = InvoicexUtil.getNumeroSerieDataDaId(tipoDocumento, id);
                String cosa = "fattura";
                String cosa2 = "fattura";
                if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
                    cosa = cosa + " acquisto";
                } else if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_DDT)) {
                    cosa = "ddt ";
                    cosa2 = "ddt";
                } else if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_DDT_ACQUISTO)) {
                    cosa = "ddt acquisto ";
                    cosa2 = "ddt";
                } else if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_ORDINE)) {
                    cosa = "ordine ";
                    cosa2 = "ordine";
                } else if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_SCHEDELAV)) {
                    cosa = "schedalav ";
                    cosa2 = "schedalav";
                } else if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO)) {
                    cosa = "ordine acquisto ";
                    cosa2 = "ordine";
                }
                InvoicexUtil.storicizza("modifica " + cosa + " id:" + id + " numero:" + numerocompleto, cosa2, id, false);
                try {
                    InvoicexUtil.aggiornaTotaliRighe(tipoDocumento, id);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }

            protected void done() {
                Map dati = null;
                try {
                    dati = InvoicexUtil.getSerieNumeroAnno(tipoDocumento, id);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_FATTURA)) {
                    frmTestFatt frm;
                    frmTestFatt testFatt;
                    block29: {
                        testFatt = null;
                        frm = null;
                        try {
                            String tipo = "";
                            if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_FATTURA)) {
                                tipo = "";
                            }
                            if (!tipo.equals("SC")) {
                                testFatt = new frmTestFatt();
                                testFatt.init(frmTestDocu.DB_MODIFICA, cu.s(dati.get("serie")), cu.i(dati.get("numero")), "P", cu.i(dati.get("anno")), 0, id);
                                if (parent instanceof frmElenFatt) {
                                    testFatt.from = (frmElenFatt)parent;
                                }
                                frm = testFatt;
                                break block29;
                            }
                            try {
                                InvoicexEvent event = new InvoicexEvent(parent);
                                event.type = 24;
                                main.events.fireInvoicexEvent(event);
                                parent.setCursor(new Cursor(0));
                                if (griglia != null) {
                                    griglia.setCursor(new Cursor(0));
                                }
                                return;
                            }
                            catch (Exception err) {
                                err.printStackTrace();
                            }
                        }
                        catch (Exception err) {
                            err.printStackTrace();
                        }
                    }
                    if (testFatt != null && testFatt.trow != null) {
                        SwingUtils.showErrorMessage((Component)main.getPadreWindow(), (String)testFatt.trow.getMessage());
                    } else {
                        MenuPanel m = main.getPadrePanel();
                        m.openFrame(frm, 740, InvoicexUtil.getHeightIntFrame(750));
                        if (runAfter != null) {
                            runAfter.run(new Object[]{frm});
                        }
                    }
                } else if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
                    frmTestFattAcquisto frmTemp = new frmTestFattAcquisto(frmTestFatt.DB_MODIFICA, cu.s(dati.get("serie")), cu.i(dati.get("numero")), "P", cu.i(dati.get("anno")), 0, id);
                    frmTemp.from = (frmElenFattAcquisto)parent;
                    Menu m = main.getPadre();
                    m.openFrame(frmTemp, 740, InvoicexUtil.getHeightIntFrame(750));
                    if (runAfter != null) {
                        runAfter.run(new Object[]{frmTemp});
                    }
                } else if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_ORDINE) || tipoDocumento.equals(Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO)) {
                    String stato;
                    boolean acquisto = false;
                    if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO)) {
                        acquisto = true;
                    }
                    stato = (stato = cu.s((Object)griglia.getValueAt(griglia.getSelectedRow(), griglia.getColumnByName("Stato")))).toLowerCase().contains("ordin") || stato.toLowerCase().contains("order") ? "O" : "P";
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("source", (Object)this);
                    param.put("id", id);
                    param.put("tabella", griglia.dbNomeTabella);
                    InvoicexEvent event = new InvoicexEvent(param);
                    event.type = 105;
                    Object ret = main.events.fireInvoicexEventWResult(event);
                    if (ret != null && !cu.toBoolean((Object)ret)) {
                        return;
                    }
                    String tipoSNJ = "";
                    if (main.getPersonalContain("snj") && (tipoSNJ = String.valueOf(griglia.getValueAt(griglia.getSelectedRow(), griglia.getColumnByName("Tipologia")))).equals("")) {
                        tipoSNJ = null;
                    }
                    frmTestOrdine frm = new frmTestOrdine(frmTestOrdine.DB_MODIFICA, cu.s(dati.get("serie")), cu.i(dati.get("numero")), stato, cu.i(dati.get("anno")), 0, id, acquisto, tipoSNJ);
                    frm.from = (frmElenOrdini)parent;
                    Menu m = main.getPadre();
                    m.openFrame(frm, 740, InvoicexUtil.getHeightIntFrame(750));
                } else if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_SCHEDELAV)) {
                    String stato = cu.s((Object)griglia.getValueAt(griglia.getSelectedRow(), griglia.getColumnByName("Stato")));
                    stato = stato.toLowerCase().contains("ordin") || stato.toLowerCase().contains("order") ? "O" : "P";
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("source", (Object)this);
                    param.put("id", id);
                    param.put("tabella", griglia.dbNomeTabella);
                    InvoicexEvent event = new InvoicexEvent(param);
                    event.type = 105;
                    Object ret = main.events.fireInvoicexEventWResult(event);
                    if (ret != null && !cu.toBoolean((Object)ret)) {
                        return;
                    }
                    frmTestSchedaLav frm = new frmTestSchedaLav(frmTestSchedaLav.DB_MODIFICA, cu.s(dati.get("serie")), cu.i(dati.get("numero")), stato, cu.i(dati.get("anno")), 0, id, false, null);
                    frm.from = (frmElenSchedeLav)parent;
                    Menu m = main.getPadre();
                    m.openFrame(frm, 740, InvoicexUtil.getHeightIntFrame(750));
                } else if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_DDT) || tipoDocumento.equals(Db.TIPO_DOCUMENTO_DDT_ACQUISTO)) {
                    boolean acquisto = false;
                    if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_DDT_ACQUISTO)) {
                        acquisto = true;
                    }
                    frmTestDocu frm = new frmTestDocu(frmTestDocu.DB_MODIFICA, cu.s(dati.get("serie")), cu.i(dati.get("numero")), "P", cu.i(dati.get("anno")), id, acquisto);
                    frm.from = (frmElenDDT)parent;
                    Menu m = main.getPadre();
                    m.openFrame(frm, 740, InvoicexUtil.getHeightIntFrame(750));
                }
                System.out.println("def cursor");
                parent.setCursor(new Cursor(0));
                if (griglia != null) {
                    griglia.setCursor(new Cursor(0));
                }
            }
        };
        worker1.execute();
    }

    public static String getIbanFromString(String str) {
        String expression = "[a-zA-Z]{2}[0-9]{2}[a-zA-Z0-9]{4}[0-9]{7}([a-zA-Z0-9]?){0,16}";
        String inputStr = cu.s((Object)str);
        Pattern pattern = Pattern.compile(expression);
        Matcher matcher = pattern.matcher(inputStr);
        if (matcher.find()) {
            try {
                return matcher.group(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((matcher = pattern.matcher(inputStr = cu.s((Object)(str = StringUtils.replace((String)str, (String)" ", (String)""))))).find()) {
            try {
                return matcher.group(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static File getFileFromDialog(Component parent, String name) {
        String path = main.fileIni.getValue("file_open_path", name);
        JFileChooser filech = null;
        try {
            filech = NativeJFileChooser.getNativeJFileChooser(path);
        }
        catch (Exception ex) {
            SwingUtils.showExceptionMessage((Component)parent, (Exception)ex);
        }
        filech.showOpenDialog(parent);
        File f = filech.getSelectedFile();
        if (f != null) {
            main.fileIni.setValue("file_open_path", name, f.getParentFile().getAbsoluteFile());
            return f;
        }
        return null;
    }

    public static void collega(Integer[] ids, Integer id_fattura) throws Exception {
        String sql = "update righ_ddt_acquisto set quantita_evasa = quantita, in_fatt = " + dbu.sql((Object)id_fattura) + " where id_padre in (" + StringUtils.join((Object[])ids, (String)",") + ")";
        dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
        sql = "update test_fatt_acquisto set da_ddt_raggr = " + dbu.sql((Object)StringUtils.join((Object[])ids, (String)",")) + " where id = " + dbu.sql((Object)id_fattura);
        dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
        sql = "update test_ddt_acquisto set evaso = 'S' where id in (" + StringUtils.join((Object[])ids, (String)",") + ")";
        dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
        for (int i = 0; i < ids.length; ++i) {
            Integer idn = ids[i];
            String convertito = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)("select convertito from test_ddt_acquisto t where t.id = " + ids[i])));
            String numero = InvoicexUtil.getNumeroDaId(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA, id_fattura, false);
            convertito = StringUtils.replace((String)convertito, (String)"null", (String)"");
            convertito = StringUtils.replace((String)convertito, (String)("\n" + numero), (String)"");
            convertito = StringUtils.replace((String)convertito, (String)numero, (String)"");
            convertito = convertito + (convertito.length() > 0 ? "\n" : "") + numero;
            sql = "update test_ddt_acquisto t";
            sql = sql + " set convertito = " + Db.pc(convertito, "VARCHAR");
            sql = sql + " where t.id = " + ids[i];
            System.out.println("sql = " + sql);
            dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
        }
        iu.aggiornaElenchiDDT();
    }

    public static boolean isDbTnx() {
        return gestioneFatture.Db.dbServ.equalsIgnoreCase("due.tnx.it") || gestioneFatture.Db.dbServ.equalsIgnoreCase("tre.tnx.it") || gestioneFatture.Db.dbServ.equalsIgnoreCase("tnx.it") || gestioneFatture.Db.dbServ.equalsIgnoreCase("web.tnx.it");
    }

    private static boolean isFrmTipoDocumento(GenericFrmTest f, String tipoDocumento) {
        if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_DDT) && f instanceof frmTestDocu && f.getDatiPanel().dbNomeTabella.indexOf("acquisto") < 0) {
            return true;
        }
        if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_DDT_ACQUISTO) && f instanceof frmTestDocu && f.getDatiPanel().dbNomeTabella.indexOf("acquisto") >= 0) {
            return true;
        }
        if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_ORDINE) && f instanceof frmTestOrdine && f.getDatiPanel().dbNomeTabella.indexOf("acquisto") < 0) {
            return true;
        }
        if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO) && f instanceof frmTestOrdine && f.getDatiPanel().dbNomeTabella.indexOf("acquisto") >= 0) {
            return true;
        }
        if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_FATTURA) && f instanceof frmTestFatt) {
            return true;
        }
        return tipoDocumento.equals(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA) && f instanceof frmTestFattAcquisto;
    }

    public static String getStack(Exception ex) {
        StackTraceElement[] stes = ex.getStackTrace();
        String stack = "";
        for (StackTraceElement st : stes) {
            if (!st.getClassName().startsWith("gestioneFatture") && !st.getClassName().startsWith("it.tnx") && !st.getClassName().startsWith("invoicex") || st.getFileName().equalsIgnoreCase("SwingUtils.java")) continue;
            stack = stack + " at " + st.getClassName() + "." + st.getMethodName() + "(" + st.getFileName() + ":" + st.getLineNumber() + ")\n";
        }
        return stack;
    }

    public static String getMsgTarget(Exception ex) {
        StackTraceElement[] stes = ex.getStackTrace();
        String msgTarget = "";
        if (ex instanceof InvocationTargetException) {
            Throwable t = ((InvocationTargetException)ex).getTargetException();
            msgTarget = msgTarget + "\nDerivante da:\n" + t.toString() + "\n\n";
            for (StackTraceElement st : stes = t.getStackTrace()) {
                if (!st.getClassName().startsWith("gestioneFatture") && !st.getClassName().startsWith("it.tnx") && !st.getClassName().startsWith("invoicex") || st.getFileName().equalsIgnoreCase("SwingUtils.java")) continue;
                msgTarget = msgTarget + " at " + st.getClassName() + "." + st.getMethodName() + "(" + st.getFileName() + ":" + st.getLineNumber() + ")\n";
            }
        }
        return msgTarget;
    }

    public static boolean isAzienda(String azienda) {
        HashMap<String, String> aziende = new HashMap<String, String>();
        aziende.put("cirri", "04502130489");
        String piva_azienda = cu.s(((Map)main.GLOB.get("dati_azienda")).get("piva"));
        for (Map.Entry a : aziende.entrySet()) {
            String piva = (String)a.getValue();
            if (piva_azienda.indexOf(piva) < 0) continue;
            return true;
        }
        return false;
    }

    public static void aggiornaForzatura(Documento doc, JTable tabForzaturaCastelletto, JTextField texForzaturaRitenuta, JTextField texForzaturaRivalsa, JTextField texForzaturaImponibile, JTextField texForzaturaIva, JTextField texForzaturaTotale, JTextField texForzaturaTotaleDaPagare) {
        DefaultTableModel model = (DefaultTableModel)tabForzaturaCastelletto.getModel();
        model.setRowCount(0);
        model.setRowCount(doc.dettagliIvaDedMap.size());
        Iterator<IvaDed> ivaiter = doc.dettagliIvaDedMap.keySet().iterator();
        int row = 0;
        try {
            HashMap codici_iva = dbu.getListMapMap((Connection)Db.getConn(), (String)"select * from codici_iva", (String)"codice");
            while (ivaiter.hasNext()) {
                IvaDed ivakey = ivaiter.next();
                DettaglioIva d = doc.dettagliIvaDedMap.get(ivakey);
                model.setValueAt(d.getCodice(), row, 0);
                model.setValueAt(((Map)codici_iva.get(d.getCodice())).get("descrizione"), row, 1);
                model.setValueAt(d.getPercentuale(), row, 2);
                if (doc.tipoDocumento.equals(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
                    model.setValueAt(d.getPerc_deducibilita(), row, tabForzaturaCastelletto.getColumn("Deducibilit\u00e0").getModelIndex());
                }
                model.setValueAt(d.getImponibile(), row, tabForzaturaCastelletto.getColumn("Imponibile").getModelIndex());
                model.setValueAt(d.getImposta(), row, tabForzaturaCastelletto.getColumn("Imposta").getModelIndex());
                ++row;
            }
            texForzaturaImponibile.setText(FormatUtils.formatEuroIta((double)doc.getTotaleImponibile()));
            texForzaturaIva.setText(FormatUtils.formatEuroIta((double)doc.getTotaleIva()));
            texForzaturaTotale.setText(FormatUtils.formatEuroIta((double)doc.getTotale()));
            texForzaturaTotaleDaPagare.setText(FormatUtils.formatEuroIta((double)doc.getTotale_da_pagare_finale()));
            texForzaturaRitenuta.setText(FormatUtils.formatEuroIta((double)doc.getTotale_ritenuta()));
            texForzaturaRivalsa.setText(FormatUtils.formatEuroIta((double)doc.getTotale_rivalsa()));
        }
        catch (Exception e) {
            SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)e);
        }
    }

    public static void impostaTabForzatura(JTable tab) {
        tab.getColumn("Imponibile").setCellEditor((TableCellEditor)new EditorUtils.NumberEditor());
        tab.getColumn("Imponibile").setCellRenderer((TableCellRenderer)new RendererUtils.NumberRenderer());
        tab.getColumn("Imposta").setCellEditor((TableCellEditor)new EditorUtils.NumberEditor());
        tab.getColumn("Imposta").setCellRenderer((TableCellRenderer)new RendererUtils.NumberRenderer());
    }

    public static void salvaTotaliIva(String nome_tab, Integer id, Vector dettagliIva, Map<IvaDed, DettaglioIva> dettagliIvaDedMap) throws Exception {
        HashMap<String, Object> m;
        DettaglioIva diva;
        String sql = "delete from " + nome_tab + "_iva where id_padre = " + id;
        DbUtils.tryExecQuery((Connection)gestioneFatture.Db.getConn(), (String)sql);
        for (Object odet : dettagliIva) {
            diva = (DettaglioIva)odet;
            m = new HashMap<String, Object>();
            m.put("id_padre", id);
            m.put("codice_iva", diva.getCodice());
            m.put("perc_iva", diva.getPercentuale());
            m.put("imponibile", diva.getImponibile());
            m.put("iva", diva.getImposta());
            m.put("totale", Util.round(diva.getImponibile() + diva.getImposta(), 2));
            sql = "insert into " + nome_tab + "_iva set " + DbUtils.prepareSqlFromMap(m);
            System.out.println("sql = " + sql);
            DbUtils.tryExecQuery((Connection)gestioneFatture.Db.getConn(), (String)sql);
        }
        if (nome_tab.endsWith("_acquisto")) {
            sql = "delete from " + nome_tab + "_iva_ded where id_padre = " + id;
            DbUtils.tryExecQuery((Connection)gestioneFatture.Db.getConn(), (String)sql);
            for (IvaDed ivaded : dettagliIvaDedMap.keySet()) {
                System.out.println("ivaded = " + ivaded);
                diva = dettagliIvaDedMap.get(ivaded);
                m = new HashMap();
                m.put("id_padre", id);
                m.put("codice_iva", diva.getCodice());
                m.put("perc_iva", diva.getPercentuale());
                m.put("perc_deducibile", diva.getPerc_deducibilita());
                m.put("imponibile", diva.getImponibile());
                m.put("iva", diva.getImposta());
                m.put("totale", Util.round(diva.getImponibile() + diva.getImposta(), 2));
                sql = "insert into " + nome_tab + "_iva_ded set " + DbUtils.prepareSqlFromMap(m);
                System.out.println("sql = " + sql);
                DbUtils.tryExecQuery((Connection)gestioneFatture.Db.getConn(), (String)sql);
            }
        }
        String tab_righe = gestioneFatture.Db.getNomeTabRdaTabT(nome_tab);
        sql = "update " + tab_righe + " set ts_gen_totali = CURRENT_TIMESTAMP where id_padre = " + id;
        DbUtils.tryExecQuery((Connection)gestioneFatture.Db.getConn(), (String)sql);
        sql = "update " + nome_tab + " set ts_gen_totali = CURRENT_TIMESTAMP where id = " + id;
        DbUtils.tryExecQuery((Connection)gestioneFatture.Db.getConn(), (String)sql);
    }

    public static void caricaCastellettoForzatura(String nome_tab, JTable tabForzaturaCastelletto, Integer id) throws Exception {
        DefaultTableModel model = (DefaultTableModel)tabForzaturaCastelletto.getModel();
        model.setRowCount(0);
        String nome_tab_iva = nome_tab + "_iva";
        if (nome_tab.endsWith("_acquisto")) {
            nome_tab_iva = nome_tab + "_iva_ded";
        }
        String sql = "select * from " + nome_tab_iva + " where id_padre = " + id;
        ArrayList list = dbu.getListMap((Connection)Db.getConn(), (String)sql);
        HashMap codici_iva = dbu.getListMapMap((Connection)Db.getConn(), (String)"select * from codici_iva", (String)"codice");
        model.setRowCount(list.size());
        try {
            int row = 0;
            for (Map m : list) {
                model.setValueAt(m.get("codice_iva"), row, 0);
                model.setValueAt(((Map)codici_iva.get(m.get("codice_iva"))).get("descrizione"), row, 1);
                model.setValueAt(m.get("perc_iva"), row, 2);
                if (nome_tab.endsWith("_acquisto")) {
                    model.setValueAt(m.get("perc_deducibile"), row, tabForzaturaCastelletto.getColumn("Deducibilit\u00e0").getModelIndex());
                }
                model.setValueAt(m.get("imponibile"), row, tabForzaturaCastelletto.getColumn("Imponibile").getModelIndex());
                model.setValueAt(m.get("iva"), row, tabForzaturaCastelletto.getColumn("Imposta").getModelIndex());
                ++row;
            }
        }
        catch (Exception e) {
            SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)e);
        }
    }

    public static Vector getDettagliIvaForzatura(JTable tab, boolean acquisto) {
        Vector<DettaglioIva> v = new Vector<DettaglioIva>();
        HashMap<String, Double> listImp = new HashMap<String, Double>();
        HashMap<String, Double> listIva = new HashMap<String, Double>();
        HashMap<String, Double> listPerc = new HashMap<String, Double>();
        HashMap<String, String> listDesc = new HashMap<String, String>();
        for (int i = 0; i < tab.getRowCount(); ++i) {
            String codice_iva = cu.s((Object)tab.getValueAt(i, 0));
            DettaglioIva d = null;
            if (acquisto) {
                listPerc.put(codice_iva, cu.d((Object)tab.getValueAt(i, 2)));
                listDesc.put(codice_iva, cu.s((Object)tab.getValueAt(i, 1)));
                if (listImp.get(codice_iva) != null) {
                    listImp.put(codice_iva, cu.d0(listImp.get(codice_iva)) + cu.d0((Object)tab.getValueAt(i, 4)));
                } else {
                    listImp.put(codice_iva, cu.d0((Object)tab.getValueAt(i, 4)));
                }
                if (listIva.get(codice_iva) != null) {
                    listIva.put(codice_iva, cu.d0(listIva.get(codice_iva)) + cu.d0((Object)tab.getValueAt(i, 5)));
                    continue;
                }
                listIva.put(codice_iva, cu.d0((Object)tab.getValueAt(i, 5)));
                continue;
            }
            d = new DettaglioIva(codice_iva, cu.d((Object)tab.getValueAt(i, 2)), cu.s((Object)tab.getValueAt(i, 1)), cu.s((Object)tab.getValueAt(i, 1)), cu.d((Object)tab.getValueAt(i, 3)), cu.d((Object)tab.getValueAt(i, 4)));
            v.add(d);
        }
        for (Object okey : listImp.keySet()) {
            String codice_iva = (String)okey;
            DettaglioIva d = new DettaglioIva(codice_iva, cu.d(listPerc.get(codice_iva)), cu.s(listDesc.get(codice_iva)), cu.s(listDesc.get(codice_iva)), cu.d(listImp.get(codice_iva)), cu.d(listIva.get(codice_iva)));
            v.add(d);
        }
        return v;
    }

    public static Vector getDettagliIvaForzaturaDb(String nome_tab, Integer id) throws Exception {
        String sql = "select * from " + nome_tab + "_iva where id_padre = " + id;
        ArrayList list = dbu.getListMap((Connection)Db.getConn(), (String)sql);
        HashMap codici_iva = dbu.getListMapMap((Connection)Db.getConn(), (String)"select * from codici_iva", (String)"codice");
        Vector<DettaglioIva> v = new Vector<DettaglioIva>();
        for (Map m : list) {
            DettaglioIva d = new DettaglioIva(cu.s(m.get("codice_iva")), cu.d0(m.get("perc_iva")), cu.s(((Map)codici_iva.get(m.get("codice_iva"))).get("descrizione")), cu.s(((Map)codici_iva.get(m.get("codice_iva"))).get("descrizione")), cu.d0(m.get("imponibile")), cu.d0(m.get("iva")));
            v.add(d);
        }
        return v;
    }

    public static Map<IvaDed, DettaglioIva> getDettagliIvaForzaturaDedMap(JTable tab) {
        LinkedHashMap<IvaDed, DettaglioIva> dettagliIvaDedMap = new LinkedHashMap<IvaDed, DettaglioIva>();
        for (int i = 0; i < tab.getRowCount(); ++i) {
            IvaDed kivaded = new IvaDed(cu.s((Object)tab.getValueAt(i, 0)), cu.d((Object)tab.getValueAt(i, 3)));
            DettaglioIva d = new DettaglioIva(cu.s((Object)tab.getValueAt(i, 0)), cu.d((Object)tab.getValueAt(i, 2)), cu.s((Object)tab.getValueAt(i, 1)), cu.s((Object)tab.getValueAt(i, 1)), cu.d((Object)tab.getValueAt(i, 4)), cu.d((Object)tab.getValueAt(i, 5)));
            d.setPerc_deducibilita(cu.d((Object)tab.getValueAt(i, 3)));
            dettagliIvaDedMap.put(kivaded, d);
        }
        return dettagliIvaDedMap;
    }

    public static double getImpDeducibile(List<Map> list_iva_ded) {
        double ret = 0.0;
        for (Map m : list_iva_ded) {
            double imp = cu.d0(m.get("imponibile"));
            double imp_ded = cu.d0(m.get("imponibile")) / 100.0 * cu.d0(m.get("perc_deducibile"));
            ret += imp_ded;
        }
        return ret;
    }

    public static double getImpNonDeducibile(List<Map> list_iva_ded) {
        double ret = 0.0;
        for (Map m : list_iva_ded) {
            double imp = cu.d0(m.get("imponibile"));
            double imp_ded = cu.d0(m.get("imponibile")) / 100.0 * cu.d0(m.get("perc_deducibile"));
            double imp_ind = imp - imp_ded;
            ret += imp_ind;
        }
        return ret;
    }

    public static double getImpIvaDeducibile(List<Map> list_iva_ded, String codice_iva) {
        double ret = 0.0;
        for (Map m : list_iva_ded) {
            if (codice_iva != null && !codice_iva.equalsIgnoreCase(cu.s(m.get("codice_iva")))) continue;
            double imp = cu.d0(m.get("imponibile"));
            double imp_ded = cu.d0(m.get("imponibile")) / 100.0 * cu.d0(m.get("perc_deducibile"));
            ret += imp_ded;
        }
        return ret;
    }

    public static double getIvaDeducibile(List<Map> list_iva_ded, String codice_iva) {
        double ret = 0.0;
        for (Map m : list_iva_ded) {
            if (codice_iva != null && !codice_iva.equalsIgnoreCase(cu.s(m.get("codice_iva")))) continue;
            double imp = cu.d0(m.get("iva"));
            double imp_ded = cu.d0(m.get("iva")) / 100.0 * cu.d0(m.get("perc_deducibile"));
            ret += imp_ded;
        }
        return ret;
    }

    public static double getImpIvaNonDeducibile(List<Map> list_iva_ded, String codice_iva) {
        double ret = 0.0;
        for (Map m : list_iva_ded) {
            if (codice_iva != null && !codice_iva.equalsIgnoreCase(cu.s(m.get("codice_iva")))) continue;
            double iva = cu.d0(m.get("iva"));
            double iva_ded = cu.d0(m.get("iva")) / 100.0 * cu.d0(m.get("perc_deducibile"));
            ret += iva - iva_ded;
        }
        return ret;
    }

    public static double getImpIva(List<Map> list_iva, String codice_iva) {
        double ret = 0.0;
        for (Map m : list_iva) {
            if (codice_iva != null && !codice_iva.equalsIgnoreCase(cu.s(m.get("codice_iva")))) continue;
            double imp = cu.d0(m.get("imponibile"));
            ret += imp;
        }
        return ret;
    }

    public static double getIvaIva(List<Map> list_iva_ded, String codice_iva) {
        double ret = 0.0;
        for (Map m : list_iva_ded) {
            if (codice_iva != null && !codice_iva.equalsIgnoreCase(cu.s(m.get("codice_iva")))) continue;
            double iva = cu.d0(m.get("iva"));
            ret += iva;
        }
        return ret;
    }

    public static void aggiornaJava() {
        block6: {
            try {
                final String ver = HttpUtils.getUrlToStringUTF8((String)"https://server.invoicex.it/download/jre/ver.txt");
                String ver_qui = System.getProperty("java.version");
                if (ver.equals(ver_qui)) {
                    SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)("Hai gi\u00e0 la versione pi\u00f9 recente " + ver_qui));
                    return;
                }
                if (PlatformUtilsCommon.is64bit()) {
                    try {
                        Class<?> clazz = Class.forName("invoicexpluginautoupdate.MainUpdateJre");
                    }
                    catch (Throwable tr) {
                        tr.printStackTrace();
                        SwingUtils.showInfoMessage((Component)main.getPadreFrame(), (String)"Errore, pluginAutoupdate troppo vecchio, manca la classe MainUpdateJre");
                    }
                    final JDialogUpdate dialog = new JDialogUpdate((Frame)main.getPadreFrame(), false);
                    dialog.labTitolo.setText("Aggiornamento Java per Invoicex");
                    dialog.pack();
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                    dialog.toFront();
                    SwingWorker w = new SwingWorker(){

                        protected Object doInBackground() throws Exception {
                            String out;
                            File f;
                            this.publish(new Object[]{"scaricamento nuovo exe"});
                            long tempo = System.currentTimeMillis();
                            Thread.sleep(1000L);
                            String estver = "";
                            estver = main.versione.equalsIgnoreCase("professional") ? "pro" : (main.versione.equalsIgnoreCase("professional plus") ? "plus" : (main.versione.equalsIgnoreCase("enterprise") ? "ent" : "free"));
                            if (PlatformUtilsCommon.isWindows()) {
                                String url = main.baseurlserver + "/download/invoicex/Invoicex-" + estver + "-wild-jre.jar";
                                f = new File("Invoicex-" + estver + "-wild-jre.jar");
                                if (f.exists()) {
                                    f.delete();
                                }
                                if ((f = new File("Invoicex-old-wild-jre.exe")).exists()) {
                                    f.delete();
                                }
                                HttpUtils.saveFile((String)url, (String)("Invoicex-" + estver + "-wild-jre.jar"));
                                UnZip.unzip(new File("Invoicex-" + estver + "-wild-jre.jar"), new File("./"));
                                f = new File("Invoicex.exe");
                                File f2 = new File("Invoicex-old-wild-jre.exe");
                                f.renameTo(f2);
                                f = new File("Invoicex-" + estver + "-wild-jre.exe");
                                f2 = new File("Invoicex.exe");
                                f.renameTo(f2);
                            } else if (PlatformUtilsCommon.isMac()) {
                                String java = "../PlugIns/Java.runtime/Contents/Home/bin/java";
                                FileWriter fw = new FileWriter("Invoicex");
                                IOUtils.write((String)("#!/bin/sh\ncd \"$( dirname \"$0\" )\"\n" + java + " -Xdock:name=\"Invoicex\" -Xdock:icon=../Resources/icona.icns -cp Invoicex.jar:lib/*:lib_plugins/*:plugins/* it.tnx.invoicex.Invoicex"), (Writer)fw);
                                fw.close();
                            } else if (PlatformUtilsCommon.isLinux()) {
                                FileWriter fw = new FileWriter("invoicex.sh");
                                IOUtils.write((String)"#!/bin/bash\njavabin=\"./jre/bin/java\"\n$javabin -cp Invoicex.jar:lib/*:lib_plugins/*:plugins/* it.tnx.invoicex.Invoicex", (Writer)fw);
                                fw.close();
                            }
                            this.publish(new Object[]{"scaricamento aggiornamento Java"});
                            File fInvoicexOld = new File("Invoicex.old");
                            f = new File("jre_new.zip");
                            f.delete();
                            String tempurl = "https://server.invoicex.it/download/jre/win/openjdk-" + ver + "_windows-x64_bin.zip";
                            if (PlatformUtilsCommon.isMac()) {
                                tempurl = "https://server.invoicex.it/download/jre/mac/openjdk-" + ver + "_osx-x64_bin.tar.gz";
                                f = new File("openjdk-" + ver + "_osx-x64_bin.tar.gz");
                            } else if (PlatformUtilsCommon.isLinux()) {
                                tempurl = "https://server.invoicex.it/download/jre/lin/openjdk-" + ver + "_linux-x64_bin.tar.gz";
                                f = new File("openjdk-" + ver + "_linux-x64_bin.tar.gz");
                            }
                            final String url = tempurl;
                            HttpUtils.saveBigFile((String)url, (String)f.getName(), (HttpUtils.SaveFileEventListener)new HttpUtils.SaveFileEventListener(){

                                public void event(float progression) {
                                    System.out.println(url + " progression = " + progression);
                                    this.publish(new Object[]{Float.valueOf(progression)});
                                }
                            });
                            this.publish(new Object[]{"decompressione in corso"});
                            if (PlatformUtilsCommon.isMac()) {
                                out = RuntimeUtils.runWait((String[])new String[]{"tar", "-zxvf", "openjdk-" + ver + "_osx-x64_bin.tar.gz"});
                                System.out.println("out = " + out);
                                out = RuntimeUtils.runWait((String[])new String[]{"rm", "-Rvf", "jdk-" + ver + ".jdk/Contents/Home/jmods"});
                                System.out.println("out = " + out);
                                out = RuntimeUtils.runWait((String[])new String[]{"rm", "-Rvf", "jdk-" + ver + ".jdk/Contents/Home/lib/src.zip"});
                                System.out.println("out = " + out);
                                out = RuntimeUtils.runWait((String[])new String[]{"rm", "-Rvf", "jre_new"});
                                System.out.println("out = " + out);
                                out = RuntimeUtils.runWait((String[])new String[]{"mv", "jdk-" + ver + ".jdk", "jre_new"});
                                System.out.println("out = " + out);
                            } else if (PlatformUtilsCommon.isLinux()) {
                                out = RuntimeUtils.runWait((String[])new String[]{"tar", "-zxvf", "openjdk-" + ver + "_linux-x64_bin.tar.gz"});
                                System.out.println("out = " + out);
                                out = RuntimeUtils.runWait((String[])new String[]{"rm", "-Rvf", "jdk-" + ver + "/jmods"});
                                System.out.println("out = " + out);
                                out = RuntimeUtils.runWait((String[])new String[]{"rm", "-Rvf", "jdk-" + ver + "/lib/src.zip"});
                                System.out.println("out = " + out);
                                out = RuntimeUtils.runWait((String[])new String[]{"rm", "-Rvf", "jre_new"});
                                System.out.println("out = " + out);
                                out = RuntimeUtils.runWait((String[])new String[]{"mv", "jdk-" + ver, "jre_new"});
                                System.out.println("out = " + out);
                            } else {
                                UnZip unzip = new UnZip();
                                UnZip.unzip(new File("jre_new.zip"), new File("./"));
                            }
                            Map dati = (Map)dbu.getListMap((Connection)Db.getConn(), (String)"select ragione_sociale,piva,cfiscale,indirizzo,cap,localita,provincia,telefono,fax,sito_web,email from dati_azienda").get(0);
                            Runtime.getRuntime().addShutdownHook(new Thread("auto update shutdown hook agg java"){

                                @Override
                                public void run() {
                                    String cmd = "jre_new/bin/java -cp plugins/InvoicexPluginAutoUpdate.jar invoicexpluginautoupdate.MainUpdateJre -r";
                                    if (PlatformUtilsCommon.isMac()) {
                                        cmd = "jre_new/Contents/Home/bin/java -cp plugins/InvoicexPluginAutoUpdate.jar invoicexpluginautoupdate.MainUpdateJre -r";
                                    }
                                    try {
                                        System.out.println("cmd = " + cmd);
                                        Runtime.getRuntime().exec(cmd);
                                        System.out.println("eseguito");
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            });
                            this.publish(new Object[]{"chiusura in corso"});
                            return null;
                        }

                        protected void done() {
                            dialog.setVisible(false);
                            try {
                                Object object = this.get();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)e);
                                try {
                                    Map dati = (Map)dbu.getListMap((Connection)Db.getConn(), (String)"select ragione_sociale,piva,cfiscale,indirizzo,cap,localita,provincia,telefono,fax,sito_web,email from dati_azienda").get(0);
                                    InvoicexUtil.segnala2("aggiornamento java Errore " + e.toString() + "\n\n" + InvoicexUtil2.getStack(e), "aggiornamento java Errore " + e.toString(), dati);
                                }
                                catch (Exception e2) {
                                    e2.printStackTrace();
                                }
                            }
                            main.exitMain(true);
                        }

                        protected void process(List chunks) {
                            dialog.toFront();
                            for (Object o : chunks) {
                                if (o instanceof Float) {
                                    dialog.pro.setValue(cu.i0(o));
                                    continue;
                                }
                                dialog.labStatus.setText(cu.s(o));
                            }
                        }
                    };
                    w.execute();
                    break block6;
                }
                SwingUtils.showInfoMessage((Component)main.getPadreFrame(), (String)"Il tuo sistema operativo \u00e8 a 32bit e non \u00e8 disponibile l'aggiornamento Java");
            }
            catch (Exception e) {
                SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)e);
            }
        }
    }

    public static void checkPhpMustache() {
        File ftestquercus = new File("lib/quercus.jar");
        if (!ftestquercus.exists()) {
            JWindow w = SwingUtils.showFlashMessage2((String)"Attendere download librerie aggiuntive", (int)60, null, (Color)Color.red, null, (boolean)true);
            try {
                HttpUtils.saveBigFile((String)"http://server.invoicex.it/download/invoicex/lib/quercus.jar", (String)ftestquercus.getAbsolutePath());
                ClassPathHacker.addFile(ftestquercus);
            }
            catch (Exception ex) {
                SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)ex);
            }
            w.dispose();
        }
        File ftestphp = new File("php");
        File ftestphpMustacheZip = new File("php/Mustache.zip");
        File ftestphpMustacheAutoloader = new File("php/Mustache/Autoloader.php");
        File ftestphpstats = new File("php/stats.php");
        File ftestphptpl = new File("php/templates");
        File ftestphptplagente = new File("php/templates/stats_agente.html");
        if (!(ftestphp.exists() && ftestphpstats.exists() && ftestphptplagente.exists() && ftestphpMustacheAutoloader.exists() && ftestphpstats.length() != 0L && ftestphptplagente.length() != 0L)) {
            try {
                ftestphp.mkdir();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ftestphptpl.mkdir();
            }
            catch (Exception exception) {
                // empty catch block
            }
            JWindow w = SwingUtils.showFlashMessage2((String)"Attendere download librerie aggiuntive", (int)60, null, (Color)Color.red, null, (boolean)true);
            try {
                HttpUtils.saveFile((String)"http://server.invoicex.it/download/invoicex/php/Mustache.zip", (String)ftestphpMustacheZip.getAbsolutePath());
                UnZip.unzip(ftestphpMustacheZip, ftestphp);
                HttpUtils.saveFile((String)"http://server.invoicex.it/download/invoicex/php/stats.php", (String)ftestphpstats.getAbsolutePath());
                HttpUtils.saveFile((String)"http://server.invoicex.it/download/invoicex/php/templates/stats_agente.html", (String)ftestphptplagente.getAbsolutePath());
            }
            catch (Exception ex) {
                SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)ex);
            }
            w.dispose();
        }
    }

    public static void aggiornaPersonaFisicaDaPartitaIva() throws Exception {
        String sql = "update clie_forn set persona_fisica = 'S' where ifnull(piva_cfiscale,'') = ''";
        dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
        sql = "update clie_forn set persona_fisica = 'N' where ifnull(piva_cfiscale,'') != ''";
        dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
        ArrayList list = dbu.getListMap((Connection)Db.getConn(), (String)"select codice, ragione_sociale, nome, cognome, persona_fisica from clie_forn where persona_fisica = 'S' and ifnull(cognome,'') = ''");
        for (Map m : list) {
            try {
                sql = "update clie_forn set ";
                Object[] splits = StringUtils.split((String)cu.s(m.get("ragione_sociale")), (String)" ");
                if (splits.length < 2) continue;
                if (splits.length == 2) {
                    sql = sql + " nome = " + dbu.sql((Object)splits[0]) + ", cognome = " + dbu.sql((Object)splits[1]);
                } else if (splits.length > 2) {
                    sql = splits[0].length() > 2 ? sql + " cognome = " + dbu.sql((Object)(splits[0] + " " + splits[1])) + ", nome = " + dbu.sql((Object)StringUtils.join((Object[])splits, (String)" ", (int)2, (int)splits.length)) : sql + " nome = " + dbu.sql((Object)splits[0]) + ", cognome = " + dbu.sql((Object)StringUtils.join((Object[])splits, (String)" ", (int)1, (int)splits.length));
                }
                sql = sql + " where codice = " + dbu.sql(m.get("codice"));
                dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

