/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex2;

import com.jidesoft.utils.ColorUtils;
import gestioneFatture.Db;
import gestioneFatture.main;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.commons.swing.DelayedExecutor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import mjpf.EntryDescriptor;
import org.apache.commons.lang.StringUtils;
import org.imgscalr.Scalr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SfondoMenuPanel {
    Image img = null;
    private int imgW = 0;
    private int imgH = 0;
    private float scala = 1.0f;
    private String tipo = null;
    JComponent parent = null;
    private File oldImmagine = null;
    private File immagine = null;
    private String aspettoImmagine = null;
    private Color colore = null;
    private boolean stampaIntestazioneLicenza = false;
    Map datiAzienda = null;
    boolean printSeStesso = false;
    BufferedImage i = null;
    int oldw = 0;
    int oldh = 0;
    DelayedExecutor delexec = null;

    public String getTipo() {
        return this.tipo;
    }

    public boolean isStampaIntestazioneLicenza() {
        return this.stampaIntestazioneLicenza;
    }

    public void setStampaIntestazioneLicenza(boolean stampaIntestazioneLicenza) {
        this.stampaIntestazioneLicenza = stampaIntestazioneLicenza;
        this.parent.repaint();
    }

    public File getImmagine() {
        return this.immagine;
    }

    public void setImmagine(File immagine) {
        this.immagine = immagine;
        this.caricaImg();
        this.parent.repaint();
    }

    public Color getColore() {
        return this.colore;
    }

    public void setColore(Color colore) {
        this.colore = colore;
        this.parent.repaint();
    }

    public int getImgW() {
        return this.imgW;
    }

    public void setImgW(int imgW) {
        this.imgW = imgW;
    }

    public int getImgH() {
        return this.imgH;
    }

    public void setImgH(int imgH) {
        this.imgH = imgH;
    }

    public SfondoMenuPanel(JComponent parent, String tipo, File immagine, String aspettoImmagine, Color colore, boolean stampaIntestazioneLicenza) {
        this.parent = parent;
        parent.setOpaque(true);
        this.immagine = immagine;
        this.aspettoImmagine = aspettoImmagine;
        this.colore = colore;
        this.stampaIntestazioneLicenza = stampaIntestazioneLicenza;
        if (tipo == null) {
            tipo = "Logo Invoicex scuro";
        }
        this.caricaDatiAzienda();
        this.setTipo(tipo);
    }

    public void paintMenuDesktop(Graphics g) {
        boolean scuro;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        int w = this.parent.getWidth();
        int h = this.parent.getHeight();
        this.parent.setBackground(this.getColore());
        if (this.getTipo().equals("Immagine") && this.aspettoImmagine.equals("Ripeti") && this.img != null || this.getTipo().equals("Logo Invoicex scuro") || this.getTipo().equals("Logo Invoicex chiaro")) {
            g.drawImage(this.img, 0, 0, this.getImgW(), this.getImgH(), null);
            if (this.getImgW() > 0 && this.getImgH() > 0) {
                int xw = w / this.getImgW() + 1;
                int xh = h / this.getImgH() + 1;
                for (int iw = 0; iw < xw; ++iw) {
                    for (int ih = 0; ih < xh; ++ih) {
                        g.drawImage(this.img, iw * this.getImgW(), ih * this.getImgH(), this.getImgW(), this.getImgH(), null);
                    }
                }
            }
        } else if (this.getTipo().equals("Immagine") && this.aspettoImmagine.equals("Adatta") && this.img != null) {
            if (this.oldw != w || this.oldh != h || this.oldImmagine != this.immagine || this.i == null) {
                long t1 = System.currentTimeMillis();
                this.drawImage(Scalr.Method.SPEED);
                long t2 = System.currentTimeMillis();
                if (this.delexec == null) {
                    this.delexec = new DelayedExecutor(new Runnable(){

                        @Override
                        public void run() {
                            long t1 = System.currentTimeMillis();
                            SfondoMenuPanel.this.drawImage(Scalr.Method.QUALITY);
                            long t2 = System.currentTimeMillis();
                            System.out.println("tempo scalr dealyed " + (t2 - t1));
                        }
                    });
                }
                this.delexec.update();
                System.out.println("tempo scalr " + (t2 - t1));
            }
            if (this.i != null) {
                g.drawImage(this.i, 0, 0, this.i.getWidth(null), this.i.getHeight(null), null);
            }
        }
        if (this.isStampaIntestazioneLicenza()) {
            scuro = true;
            Color colore1 = Color.DARK_GRAY;
            Color colore2 = Color.WHITE;
            String s1 = cu.s(this.datiAzienda.get("ragione_sociale"));
            if (StringUtils.isNotBlank((String)s1)) {
                String s2 = "";
                if (!cu.sIsBlank(this.datiAzienda.get("indirizzo"))) {
                    s2 = s2 + this.datiAzienda.get("indirizzo") + ", ";
                }
                s2 = s2 + this.datiAzienda.get("localita");
                if (!cu.sIsBlank(this.datiAzienda.get("provincia"))) {
                    s2 = s2 + " (" + this.datiAzienda.get("provincia") + ")";
                }
                String s3 = "";
                s3 = !cu.sIsBlank(this.datiAzienda.get("piva")) ? s3 + "P.IVA " + this.datiAzienda.get("piva") : s3 + "P.IVA <vuota>";
                if (!cu.sIsBlank(this.datiAzienda.get("email"))) {
                    s3 = s3 + " Email " + this.datiAzienda.get("email");
                }
                Font labFont = UIManager.getFont("Label.font");
                if (this.getTipo().equals("Logo Invoicex chiaro")) {
                    scuro = false;
                } else if (this.getTipo().equals("Colore")) {
                    float[] hsl = ColorUtils.RGBtoHSL((Color)this.colore);
                    System.out.println(hsl[2]);
                    if ((double)hsl[2] > 0.5) {
                        scuro = false;
                    }
                }
                if (!scuro) {
                    colore1 = Color.LIGHT_GRAY;
                    colore2 = Color.BLACK;
                }
                g2d.setPaint(!scuro ? new Color(255, 255, 255, 75) : new Color(0, 0, 0, 100));
                g.setFont(labFont.deriveFont(14.0f * this.getScala()));
                int w1 = g.getFontMetrics().stringWidth(s1);
                g.setFont(labFont.deriveFont(12.0f * this.getScala()));
                int w2 = g.getFontMetrics().stringWidth(s2);
                int w3 = g.getFontMetrics().stringWidth(s3);
                int maxw = Math.max(w1, w2);
                maxw = Math.max(w3, maxw);
                g2d.fillRoundRect((int)(5.0f * this.scala), this.parent.getHeight() - (int)(85.0f * this.scala), (int)((float)maxw + 25.0f * this.scala), (int)(80.0f * this.scala), (int)(10.0f * this.scala), (int)(10.0f * this.scala));
                g2d.setPaint(colore1);
                g.setFont(labFont.deriveFont(14.0f * this.getScala()));
                g.drawString(s1, (int)(15.0f * this.getScala()), this.parent.getHeight() - (int)(60.0f * this.getScala()));
                g.setFont(labFont.deriveFont(12.0f * this.getScala()));
                g.drawString(s2, (int)(15.0f * this.getScala()), this.parent.getHeight() - (int)(40.0f * this.getScala()));
                g.drawString(s3, (int)(15.0f * this.getScala()), this.parent.getHeight() - (int)(20.0f * this.getScala()));
                g.setColor(colore2);
                g.setFont(labFont.deriveFont(14.0f * this.getScala()));
                g.drawString(s1, (int)(16.0f * this.getScala()), this.parent.getHeight() - (int)(61.0f * this.getScala()));
                g.setFont(labFont.deriveFont(12.0f * this.getScala()));
                g.drawString(s2, (int)(16.0f * this.getScala()), this.parent.getHeight() - (int)(41.0f * this.getScala()));
                g.drawString(s3, (int)(16.0f * this.getScala()), this.parent.getHeight() - (int)(21.0f * this.getScala()));
            }
        }
        if (main.debug) {
            scuro = true;
            Color colore1 = Color.DARK_GRAY;
            Color colore2 = Color.WHITE;
            String s1 = "Debug";
            if (main.pf != null && main.pf.getAllEntryDescriptor() != null) {
                Iterator ipl = main.pf.getAllEntryDescriptor().iterator();
                String s2 = cu.s((Object)"Plugins:\n");
                while (ipl.hasNext()) {
                    Object pe = ipl.next();
                    EntryDescriptor pd = (EntryDescriptor)pe;
                    s2 = s2 + ((EntryDescriptor)pe).getNomeFileJar() + " " + pd.getVer() + " " + pd.getData_string() + "\n";
                }
                try {
                    File finvplugin = new File("lib/InvoicexPluginInvoicex.jar");
                    if (finvplugin.exists()) {
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        Document doc = db.parse(new URL("jar:file:" + finvplugin.getAbsolutePath() + "!/descriptor.xml").openStream());
                        String data = cu.s((Object)((Element)doc.getElementsByTagName("entry").item(0)).getElementsByTagName("data").item(0).getFirstChild().getNodeValue());
                        String ver = cu.s((Object)((Element)doc.getElementsByTagName("entry").item(0)).getElementsByTagName("ver").item(0).getFirstChild().getNodeValue());
                        s2 = s2 + finvplugin + " " + data + " " + ver;
                    }
                }
                catch (Exception finvplugin) {
                    // empty catch block
                }
                String s3 = "";
                Font labFont = UIManager.getFont("Label.font");
                if (this.getTipo().equals("Logo Invoicex chiaro")) {
                    scuro = false;
                } else if (this.getTipo().equals("Colore")) {
                    float[] hsl = ColorUtils.RGBtoHSL((Color)this.colore);
                    System.out.println(hsl[2]);
                    if ((double)hsl[2] > 0.5) {
                        scuro = false;
                    }
                }
                if (!scuro) {
                    colore1 = Color.LIGHT_GRAY;
                    colore2 = Color.BLACK;
                }
                g2d.setPaint(!scuro ? new Color(255, 255, 255, 75) : new Color(0, 0, 0, 100));
                g.setFont(labFont.deriveFont(14.0f * this.getScala()));
                int w1 = g.getFontMetrics().stringWidth(s1);
                g.setFont(labFont.deriveFont(12.0f * this.getScala()));
                int w2 = 0;
                for (String line : s2.split("\n")) {
                    w2 = Math.max(w2, g.getFontMetrics().stringWidth(line));
                }
                int w3 = g.getFontMetrics().stringWidth(s3);
                int maxw = Math.max(w1, w2);
                maxw = Math.max(w3, maxw);
                int y = this.parent.getHeight() - (int)(440.0f * this.getScala());
                for (String line : s2.split("\n")) {
                    y = (int)((float)y + (float)g.getFontMetrics().getHeight() * this.scala);
                }
                g2d.fillRoundRect((int)(5.0f * this.scala), this.parent.getHeight() - (int)(485.0f * this.scala), (int)((float)maxw + 25.0f * this.scala), (int)(300.0f * this.scala), (int)(10.0f * this.scala), (int)(10.0f * this.scala));
                g2d.setPaint(colore2);
                g.setFont(labFont.deriveFont(14.0f * this.getScala()));
                g.drawString(s1, (int)(15.0f * this.getScala()), this.parent.getHeight() - (int)(460.0f * this.getScala()));
                g.setFont(labFont.deriveFont(12.0f * this.getScala()));
                y = this.parent.getHeight() - (int)(440.0f * this.getScala());
                for (String line : s2.split("\n")) {
                    g.drawString(line, (int)(15.0f * this.getScala()), y);
                    y = (int)((float)y + (float)g.getFontMetrics().getHeight() * this.scala);
                }
                g.drawString(s3, (int)(15.0f * this.getScala()), y);
            }
        }
        this.oldw = w;
        this.oldh = h;
        this.oldImmagine = this.immagine;
    }

    public float getScala() {
        return this.scala;
    }

    public void setScala(float scala) {
        this.scala = scala;
        this.setImgW((int)((float)this.getImgW() * scala));
        this.setImgH((int)((float)this.getImgH() * scala));
        this.parent.repaint();
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
        this.caricaImg();
        this.parent.repaint();
    }

    private void caricaImg() {
        try {
            URL url = this.getClass().getResource("/it/tnx/invoicex2/res/sfondo_logo_150.png");
            if (this.getTipo().equals("Logo Invoicex chiaro")) {
                url = this.getClass().getResource("/it/tnx/invoicex2/res/sfondo_logo_chiaro_150.png");
            } else if (this.getTipo().equals("Immagine")) {
                url = this.immagine.toURI().toURL();
            }
            this.img = ImageIO.read(url);
            this.imgW = 0;
            this.imgH = 0;
            if (this.img != null) {
                this.imgW = (int)((float)this.img.getWidth(null) * this.getScala());
                this.imgH = (int)((float)this.img.getHeight(null) * this.getScala());
            }
        }
        catch (Exception ex) {
            SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)ex);
        }
    }

    public void caricaDatiAzienda() {
        try {
            this.datiAzienda = (Map)dbu.getListMap((Connection)Db.getConn(), (String)"select ragione_sociale, indirizzo, localita, cap, provincia, telefono, fax, piva, cfiscale, sito_web, email from dati_azienda").get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.datiAzienda = new HashMap();
        }
    }

    public String getAspettoImmagine() {
        return this.aspettoImmagine;
    }

    public void setAspettoImmagine(String aspettoImmagine) {
        this.aspettoImmagine = aspettoImmagine;
        this.parent.repaint();
    }

    private void drawImage(Scalr.Method method) {
        float coefinv;
        int w = this.parent.getWidth();
        int h = this.parent.getHeight();
        float coefimg = (float)this.getImgW() / (float)this.getImgH();
        this.i = coefimg > (coefinv = (float)w / (float)h) ? Scalr.resize((BufferedImage)this.img, method, Scalr.Mode.FIT_TO_HEIGHT, w, h, new BufferedImageOp[0]) : Scalr.resize((BufferedImage)this.img, method, Scalr.Mode.FIT_TO_WIDTH, w, h, new BufferedImageOp[0]);
        this.i = Scalr.crop(this.i, (this.i.getWidth() - w) / 2, (this.i.getHeight() - h) / 2, w, h, new BufferedImageOp[0]);
        this.parent.repaint();
    }
}

