/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex2.fe;

import gestioneFatture.JDialogImpostazioni;
import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.commons.DateUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.SystemUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.invoicex.InvoicexUtil;
import it.tnx.invoicex.gui.JDialogProgress;
import it.tnx.invoicex.iu;
import it.tnx.invoicex2.fe.Sdi;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingworker.SwingWorker;
import tnxbeans.tnxComboField;

public class FEUtils {
    public static Sdi sdi = null;

    public static String getUrlDocFatturaXml() {
        return "http://www.fatturapa.gov.it/export/fatturazione/sdi/fatturapa/v1.2.1/Rappresentazione_tabellare_del_tracciato_FatturaPA_versione_1.2.1.pdf";
    }

    public static boolean isFatturaElettronica(Date data) {
        Date primoGen2019 = DateUtils.getDate((int)2019, (int)1, (int)1);
        return !data.before(primoGen2019);
    }

    public static String getTabTestate(String tipo) {
        return tipo.equalsIgnoreCase("A") ? "test_fatt_acquisto" : "test_fatt";
    }

    public static String getTabXml(String tipo) {
        return tipo.equalsIgnoreCase("A") ? "test_fatt_acquisto_xmlpa" : "test_fatt_xmlpa";
    }

    public static String getXmlDaFattura(String tipo, Integer id) throws Exception {
        return cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)("select file_xml from " + FEUtils.getTabXml(tipo) + " where id_fattura = " + id)));
    }

    public static String getFilenameXmlDaFattura(String tipo, Integer id) throws Exception {
        String tab = "test_fatt_xmlpa";
        if (tipo.equalsIgnoreCase("A")) {
            tab = "test_fatt_acquisto_xmlpa";
        }
        return cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)("select file_xml_nome from " + FEUtils.getTabXml(tipo) + " where id_fattura = " + id)));
    }

    public static Sdi getSdiImpl() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> cl = Class.forName("it.tnx.invoicex2.fe.impl." + cu.s(FEUtils.sdi.param.get("provider")) + "Sdi");
        return (Sdi)cl.newInstance();
    }

    public static Sdi getSdiImpl(String provider) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> cl = Class.forName("it.tnx.invoicex2.fe.impl." + provider + "Sdi");
        return (Sdi)cl.newInstance();
    }

    public static String getFileXml(String tipo, Integer id, boolean trow) throws Exception {
        String xml = FEUtils.getXmlDaFattura(tipo, id);
        String msg = "Non \u00e8 stato generato il file xml per la fattura " + InvoicexUtil.getNumeroSerieDataDaId(Db.TIPO_DOCUMENTO_FATTURA, id) + ", prima esegui la generazione fattura elettronica";
        if (StringUtils.isBlank((String)xml)) {
            if (trow) {
                throw new Exception(msg);
            }
            SwingUtils.showInfoMessage((Component)main.getPadreWindow(), (String)msg);
            return null;
        }
        String filename = FEUtils.getFilenameXmlDaFattura(tipo, id);
        if (StringUtils.isBlank((String)filename)) {
            if (trow) {
                throw new Exception(msg);
            }
            SwingUtils.showInfoMessage((Component)main.getPadreWindow(), (String)msg);
            return null;
        }
        File ftest = new File(FEUtils.getPathFECustom());
        if (!ftest.exists()) {
            ftest.mkdirs();
        }
        filename = FEUtils.getPathFECustom() + File.separator + filename;
        System.out.println("filename = " + filename);
        FileOutputStream fouts = new FileOutputStream(filename);
        IOUtils.write((String)xml, (OutputStream)fouts, (String)"UTF-8");
        fouts.close();
        return filename;
    }

    public static String getPathFE() {
        String path = SystemUtils.getUserDocumentsFolder() + File.separator + "Invoicex" + File.separator + "export" + File.separator + "fatture-elettroniche";
        return path;
    }

    public static String getPathFECustom() {
        String fe_cartella_export = null;
        try {
            fe_cartella_export = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)"select fe_cartella_export from export_xml_pa_parametri", (boolean)false));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String path = FEUtils.getPathFE();
        File custom = new File(fe_cartella_export);
        if (custom != null && custom.exists() && custom.isDirectory()) {
            path = fe_cartella_export;
        }
        return path;
    }

    public static boolean checkFeProviderSettings() {
        try {
            sdi.caricaParam();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (StringUtils.isBlank((String)cu.s(FEUtils.sdi.param.get("provider")))) {
            SwingUtils.showInfoMessage((Component)main.getPadreFrame(), (String)"Per utilizzare questa funzione devi impostare i parametri per il servizio di invio a SdI\nClicca su Ok per aprire le impostazioni");
            JDialogImpostazioni imp = new JDialogImpostazioni((Frame)main.getPadreFrame(), true, "impostazioni_fe");
            return false;
        }
        return true;
    }

    public static void inviaTramiteServizioEsternoIntegrato(final Component parent, final Integer[] ids) {
        if (!FEUtils.checkFeProviderSettings()) {
            return;
        }
        SwingUtils.mouse_wait((Component)parent);
        final JDialogProgress wait = new JDialogProgress((Frame)main.getPadreFrame(), false);
        wait.setLocationRelativeTo(main.getPadreFrame());
        wait.progressbar.setMaximum(ids.length);
        wait.progressbar.setValue(1);
        wait.progressbar.setIndeterminate(false);
        wait.setVisible(true);
        SwingWorker w = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                int conta = 0;
                for (Integer id : ids) {
                    String filename = FEUtils.getFileXml("V", id, true);
                    if (filename == null) {
                        return false;
                    }
                    this.publish(new Object[]{++conta});
                    Sdi sdi = FEUtils.getSdiImpl();
                    sdi.inviaASdi(filename, "V", id);
                }
                return true;
            }

            protected void process(List chunks) {
                for (Object o : chunks) {
                    Integer i = cu.i(o);
                    wait.labStatus.setText(cu.s((Object)i) + "/" + ids.length);
                    wait.progressbar.setValue(i);
                    iu.aggiornaElenchiFattureRefreshSelected();
                }
            }

            protected void done() {
                SwingUtils.mouse_def((Component)parent);
                wait.setVisible(false);
                try {
                    if (cu.b((Object)this.get()).booleanValue()) {
                        SwingUtils.showInfoMessage((Component)parent, (String)"Invio completato");
                    }
                }
                catch (Exception e) {
                    if (cu.s(FEUtils.sdi.param.get("provider")).equals("Aruba") && e.getCause() != null && cu.s((Object)e.getCause().getMessage()).startsWith("0012: Errore autenticazione")) {
                        SwingUtils.showErrorMessage((Component)parent, (String)("Hai verificato che la delega con TNX nel pannello di Aruba sia attivata ?\nMessaggio da Aruba: " + e.getMessage()));
                    }
                    SwingUtils.showExceptionMessage((Component)parent, (Exception)((Exception)e.getCause()));
                }
            }
        };
        w.execute();
    }

    static String getCartellaDiInvioTemporanea(boolean emptyFolder) {
        String folder = FEUtils.getPathFECustom() + "-temp-invio";
        if (emptyFolder) {
            it.tnx.commons.FileUtils.deleteDirContent((File)new File(folder));
        }
        return folder;
    }

    public static void apriPortale() throws URISyntaxException, IOException {
        Desktop.getDesktop().browse(new URI("https://ivaservizi.agenziaentrate.gov.it/portale/"));
    }

    public static void apriPEC(Integer id, String pec_sdi) throws UnsupportedEncodingException, URISyntaxException, IOException {
        String fattura = InvoicexUtil.getTipoFattVenditaDaId(id) + " " + InvoicexUtil.getNumeroSerieDataDaId(Db.TIPO_DOCUMENTO_FATTURA, id, false);
        Desktop.getDesktop().mail(new URI("mailto:" + pec_sdi + "?subject=" + URLEncoder.encode("Invio " + fattura, "UTF-8").replace("+", "%20")));
    }

    public static void memorizzaMetodo(String metodo) throws Exception {
        dbu.tryExecQuery((Connection)Db.getConn(), (String)("update export_xml_pa_parametri set metodo_invio = " + dbu.sql((Object)metodo)));
    }

    public static File getFileXMLInCartellaDiInvio(Component parent, Integer id_fattura) {
        try {
            String filename = FEUtils.getFileXml("V", id_fattura, false);
            String folder = FEUtils.getCartellaDiInvioTemporanea(true);
            File newFilename = new File(folder + File.separator + new File(filename).getName());
            FileUtils.copyFile((File)new File(filename), (File)newFilename);
            return newFilename;
        }
        catch (Exception ex) {
            SwingUtils.showExceptionMessage((Component)parent, (Exception)ex);
            return null;
        }
    }

    public static File getFilesXMLInCartellaDiInvio(Component parent, Integer[] ids) {
        try {
            String folder = FEUtils.getCartellaDiInvioTemporanea(true);
            for (Integer id_fattura : ids) {
                String filename = FEUtils.getFileXml("V", id_fattura, false);
                File newFilename = new File(folder + File.separator + new File(filename).getName());
                FileUtils.copyFile((File)new File(filename), (File)newFilename);
            }
            return new File(folder);
        }
        catch (Exception ex) {
            SwingUtils.showExceptionMessage((Component)parent, (Exception)ex);
            return null;
        }
    }

    public static void apriServizioEsternoManuale() throws Exception {
        sdi.caricaParam();
        if (!cu.sIsBlank(FEUtils.sdi.param.get("url_invio_esterno"))) {
            Desktop.getDesktop().browse(new URI(cu.s(FEUtils.sdi.param.get("url_invio_esterno"))));
        }
    }

    public static void marca(Integer id, String stato, String metodo) throws Exception {
        FEUtils.marca(new Integer[]{id}, stato, metodo);
    }

    public static void marca(Integer[] ids, String stato_sdi, String metodo) throws Exception {
        for (Integer id : ids) {
            String sql = "update test_fatt set fe_stato = " + (stato_sdi.equals(Sdi.STATO_AZZERA) || stato_sdi.equals(Sdi.STATO_AZZERA_TUTTO) ? "null" : dbu.sql((Object)stato_sdi)) + " where id = " + dbu.sql((Object)id);
            dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
            if (stato_sdi.equals(Sdi.STATO_AZZERA) || stato_sdi.equals(Sdi.STATO_AZZERA_TUTTO)) {
                sql = "delete from test_fatt_xmlpa_status where id_fattura = " + dbu.sql((Object)id);
                dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
            } else {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("id_fattura", id);
                m.put("stato", stato_sdi);
                m.put("provider", "manuale");
                if (main.utente != null) {
                    m.put("utente_invoicex", main.utente.getNomeUtente());
                }
                m.put("utente_so", main.utente.getNomeUtente());
                sql = "insert into test_fatt_xmlpa_status set " + dbu.prepareSqlFromMap(m);
                dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
            }
            if (!stato_sdi.equals(Sdi.STATO_AZZERA_TUTTO)) continue;
            sql = "update test_fatt_xmlpa set file_xml = null, file_xml_nome = null, file_xml_ts = null, file_xml_prog = null, fe_provider_invio = null, fe_inviata_ts = null, fe_upload_filename = null where id_fattura = " + dbu.sql((Object)id);
            dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
        }
    }

    public static void caricaTipiRitenuta(tnxComboField dg_dr_tipo_ritenuta) {
        dg_dr_tipo_ritenuta.dbAddElement("", "");
        dg_dr_tipo_ritenuta.dbAddElement("RT01 - Ritenuta persone fisiche", "RT01");
        dg_dr_tipo_ritenuta.dbAddElement("RT02 - Ritenuta persone giuridiche", "RT02");
    }

    public static void caricaCausaliPagamento(tnxComboField dg_dr_causale_pagamento) {
        dg_dr_causale_pagamento.dbAddElement("", "");
        dg_dr_causale_pagamento.dbAddElement("A - Prestazioni di lavoro autonomo rientranti nell\u2019esercizio di arte o professione abituale.", "A");
        dg_dr_causale_pagamento.dbAddElement("B - Utilizzazione economica, da parte dell\u2019autore o dell\u2019inventore, di opere dell\u2019ingegno ...", "B");
        dg_dr_causale_pagamento.dbAddElement("C - Utili derivanti da contratti di associazione in partecipazione e da contratti di cointeressenza ...", "C");
        dg_dr_causale_pagamento.dbAddElement("D - Utili spettanti ai soci promotori e ai soci fondatori delle societ\u00e0 di capitali.", "D");
        dg_dr_causale_pagamento.dbAddElement("E - Levata di protesti cambiari da parte dei segretari comunali.", "E");
        dg_dr_causale_pagamento.dbAddElement("G - Indennit\u00e0 corrisposte per la cessazione di attivit\u00e0 sportiva professionale.", "G");
        dg_dr_causale_pagamento.dbAddElement("H - Indennit\u00e0 corrisposte per la cessazione dei rapporti di agenzia delle p. fisiche e delle soc. di persone ...", "H");
        dg_dr_causale_pagamento.dbAddElement("I - Indennit\u00e0 corrisposte per la cessazione da funzioni notarili.", "I");
        dg_dr_causale_pagamento.dbAddElement("L - Utilizzazione economica, da parte di soggetto diverso dall\u2019autore o dall\u2019inventore, di opere dell\u2019ingegno ...", "L");
        dg_dr_causale_pagamento.dbAddElement("L1 - redditi derivanti dall\u2019utilizzazione economica di opere dell\u2019ingegno, di brevetti industriali e ...", "L1");
        dg_dr_causale_pagamento.dbAddElement("M - Prestazioni di lavoro aut. non esercitate abitualmente, obblighi di fare, di non fare o permettere.", "M");
        dg_dr_causale_pagamento.dbAddElement("M1 - redditi derivanti dall\u2019assunzione di obblighi di fare, di non fare o permettere", "M1");
        dg_dr_causale_pagamento.dbAddElement("N - Indennit\u00e0 di trasferta, rimborso forfetario di spese, premi e compensi erogati ...", "N");
        dg_dr_causale_pagamento.dbAddElement("O - Prestazioni di lavoro aut. non esercitate abitualmente, senza obbligo di iscrizione alla gest. separata ...", "O");
        dg_dr_causale_pagamento.dbAddElement("O1 - redditi derivanti dall\u2019assunzione di obblighi di fare, di non fare o permettere, per le quali non sussiste ...", "O1");
        dg_dr_causale_pagamento.dbAddElement("P - Compensi corrisposti a soggetti non residenti privi di stabile organizzazione per l\u2019uso ...", "P");
        dg_dr_causale_pagamento.dbAddElement("Q - Provvigioni corrisposte ad agente o rappresentante di commercio monomandatario.", "Q");
        dg_dr_causale_pagamento.dbAddElement("R - Provvigioni corrisposte ad agente o rappresentante di commercio plurimandatario.", "R");
        dg_dr_causale_pagamento.dbAddElement("S - Provvigioni corrisposte a commissionario.", "S");
        dg_dr_causale_pagamento.dbAddElement("T - Provvigioni corrisposte a mediatore.", "T");
        dg_dr_causale_pagamento.dbAddElement("U - Provvigioni corrisposte a procacciatore di affari.", "U");
        dg_dr_causale_pagamento.dbAddElement("V - Provvigioni corrisposte per le vendite a domicilio / ambulante di giornali quotidiani e periodici ...", "V");
        dg_dr_causale_pagamento.dbAddElement("V1 - redditi derivanti da attivit\u00e0 commerciali non esercitate abitualmente (ad esempio, provvigioni corrisposte ...", "V1");
        dg_dr_causale_pagamento.dbAddElement("W - Corrispettivi erogati nel 2018 per prestazioni relative a contratti d\u2019appalto ...", "W");
        dg_dr_causale_pagamento.dbAddElement("X - Canoni corrisposti nel 2004 da societ\u00e0 o enti residenti, ovvero da stabili organizzazioni di societ\u00e0 estere ...", "X");
        dg_dr_causale_pagamento.dbAddElement("Y - Canoni corrisposti dal 1.01.2005 al 26.07.2005 da soggetti di cui al punto precedente.", "Y");
        dg_dr_causale_pagamento.dbAddElement("Z - Titolo diverso dai precedenti.", "Z");
    }

    public static void caricaTipiCassa(tnxComboField dg_dcp_tipo_cassa) {
        dg_dcp_tipo_cassa.dbAddElement("", "");
        dg_dcp_tipo_cassa.dbAddElement("TC01 - Cassa nazionale previdenza e assistenza avvocati e procuratori legali", "TC01");
        dg_dcp_tipo_cassa.dbAddElement("TC02 - Cassa previdenza dottori commercialisti", "TC02");
        dg_dcp_tipo_cassa.dbAddElement("TC03 - Cassa previdenza e assistenza geometri", "TC03");
        dg_dcp_tipo_cassa.dbAddElement("TC04 - Cassa nazionale previdenza e assistenza ingegneri e architetti liberi professionisti", "TC04");
        dg_dcp_tipo_cassa.dbAddElement("TC05 - Cassa nazionale del notariato", "TC05");
        dg_dcp_tipo_cassa.dbAddElement("TC06 - Cassa nazionale previdenza e assistenza ragionieri e periti commerciali", "TC06");
        dg_dcp_tipo_cassa.dbAddElement("TC07 - Ente nazionale assistenza agenti e rappresentanti di commercio (ENASARCO)", "TC07");
        dg_dcp_tipo_cassa.dbAddElement("TC08 - Ente nazionale previdenza e assistenza consulenti del lavoro (ENPACL)", "TC08");
        dg_dcp_tipo_cassa.dbAddElement("TC09 - Ente nazionale previdenza e assistenza medici (ENPAM)", "TC09");
        dg_dcp_tipo_cassa.dbAddElement("TC10 - Ente nazionale previdenza e assistenza farmacisti (ENPAF)", "TC10");
        dg_dcp_tipo_cassa.dbAddElement("TC11 - Ente nazionale previdenza e assistenza veterinari (ENPAV)", "TC11");
        dg_dcp_tipo_cassa.dbAddElement("TC12 - Ente nazionale previdenza e assistenza impiegati dell'agricoltura (ENPAIA)", "TC12");
        dg_dcp_tipo_cassa.dbAddElement("TC13 - Fondo previdenza impiegati imprese di spedizione e agenzie marittime", "TC13");
        dg_dcp_tipo_cassa.dbAddElement("TC14 - Istituto nazionale previdenza giornalisti italiani (INPGI)", "TC14");
        dg_dcp_tipo_cassa.dbAddElement("TC15 - Opera nazionale assistenza orfani sanitari italiani (ONAOSI)", "TC15");
        dg_dcp_tipo_cassa.dbAddElement("TC16 - Cassa autonoma assistenza integrativa giornalisti italiani (CASAGIT)", "TC16");
        dg_dcp_tipo_cassa.dbAddElement("TC17 - Ente previdenza periti industriali e periti industriali laureati (EPPI)", "TC17");
        dg_dcp_tipo_cassa.dbAddElement("TC18 - Ente previdenza e assistenza pluricategoriale (EPAP)", "TC18");
        dg_dcp_tipo_cassa.dbAddElement("TC19 - Ente nazionale previdenza e assistenza biologi (ENPAB)", "TC19");
        dg_dcp_tipo_cassa.dbAddElement("TC20 - Ente nazionale previdenza e assistenza professione infermieristica (ENPAPI)", "TC20");
        dg_dcp_tipo_cassa.dbAddElement("TC21 - Ente nazionale previdenza e assistenza psicologi (ENPAP)", "TC21");
        dg_dcp_tipo_cassa.dbAddElement("TC22 - INPS", "TC22");
    }

    public static void changeUtf8ToLatin(File filexml) throws IOException {
        String xml = it.tnx.commons.FileUtils.readContent((File)filexml);
        xml = StringUtils.replaceOnce((String)xml, (String)"encoding=\"UTF-8", (String)"encoding=\"ISO-8859-1");
        FileUtils.writeByteArrayToFile((File)filexml, (byte[])xml.getBytes("ISO-8859-1"));
    }

    static {
        try {
            sdi = new Sdi();
        }
        catch (Exception ex) {
            SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)ex);
        }
    }
}

