/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex2.fe;

import gestioneFatture.frmElenFatt;
import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.commons.DateUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.commons.table.RendererUtils;
import it.tnx.invoicex.InvoicexUtil;
import it.tnx.invoicex.iu;
import it.tnx.invoicex2.fe.EsitoRicezione;
import it.tnx.invoicex2.fe.FEUtils;
import it.tnx.invoicex2.fe.JDialogEsitoRicezione;
import it.tnx.invoicex2.fe.MyGlassPane;
import it.tnx.invoicex2.fe.Sdi;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingworker.SwingWorker;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.SortOrder;

public class JDialogRicezione
extends JDialog {
    private Integer[] ids;
    File cartella = null;
    Sdi sdi = null;
    frmElenFatt elenco = null;
    public MyGlassPane myGlassPane;
    private JXDatePicker al;
    private JButton butAnnulla;
    private JButton butDeseTutt;
    private JButton butImporta;
    private JButton butSeleTutt;
    private JComboBox comDataRegistrazione;
    private JXDatePicker dal;
    private JTextField feSerieFattAcq;
    private JCheckBox fe_genera_contab;
    private JCheckBox fe_genera_movimenti;
    private JButton jButton1;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel labAl;
    private JLabel labFattRic;
    private JLabel labSerie;
    private JLabel labTitolo;
    private JLabel labTotali;
    private JTable tabFatture;

    public JDialogRicezione(Frame parent, boolean modal) {
        this(parent, modal, null);
    }

    public JDialogRicezione(Frame parent, boolean modal, File cartella) {
        super(parent, modal);
        this.cartella = cartella;
        this.initComponents();
        if (!main.isPluginContabilitaAttivo()) {
            this.fe_genera_contab.setVisible(false);
        }
        if (cartella != null) {
            this.labFattRic.setVisible(false);
            this.labAl.setVisible(false);
            this.dal.setVisible(false);
            this.al.setVisible(false);
        }
        this.comDataRegistrazione.setSelectedItem(main.fileIni.getValue("pref", "ricezione_data_reg", "Data ricezione"));
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        this.dal.setDate(cal.getTime());
        this.al.setDate(new Date());
        this.tabFatture.setRowHeight(this.tabFatture.getRowHeight() + 4);
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy");
        this.tabFatture.getColumn("Data").setCellRenderer((TableCellRenderer)new RendererUtils.DateRenderer((DateFormat)sdf));
        this.tabFatture.getColumn("Data ricezione").setCellRenderer((TableCellRenderer)new RendererUtils.DateRenderer((DateFormat)sdf));
        this.myGlassPane = new MyGlassPane(this);
        this.setGlassPane(this.myGlassPane);
        this.myGlassPane.setVisible(true);
        this.load();
        ((DefaultTableModel)this.tabFatture.getModel()).addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                JDialogRicezione.this.aggiornaLabTotali();
            }
        });
    }

    public void load() {
        SwingUtils.mouse_wait((Component)this);
        this.myGlassPane.msg = "Aggiornamento elenco fatture";
        SwingWorker w = new SwingWorker(){
            int row = 0;
            Sdi sdi = null;
            Map param = null;

            protected Object doInBackground() throws Exception {
                ArrayList list = dbu.getListMap((Connection)Db.getConn(), (String)"select * from export_xml_pa_parametri");
                if (list.size() > 0) {
                    this.param = (Map)list.get(0);
                }
                if (JDialogRicezione.this.cartella != null) {
                    this.sdi = FEUtils.getSdiImpl("Folder");
                    this.sdi.param.put("cartella", JDialogRicezione.this.cartella);
                } else {
                    this.sdi = FEUtils.getSdiImpl();
                }
                this.sdi.setCurrentWorker(this);
                EsitoRicezione esito = this.sdi.riceviElencoDaSdi(JDialogRicezione.this.dal.getDate(), JDialogRicezione.this.al.getDate());
                if (esito.fatture != null) {
                    String sql = "SELECT tf.id, tf.serie, tf.numero, tf.data, tf.numero_doc, tf.serie_doc, tf.data_doc, tfx.file_xml_nome, cf.ragione_sociale, cf.piva_cfiscale, cf.cfiscale from test_fatt_acquisto tf left join test_fatt_acquisto_xmlpa tfx on tf.id = tfx.id_fattura left join clie_forn cf on tf.fornitore = cf.codice where tf.`data` > DATE_SUB(NOW(), INTERVAL 12 MONTH) order by id desc";
                    list = dbu.getListMap((Connection)Db.getConn(), (String)sql);
                    for (Map m : esito.fatture) {
                        Map fat;
                        System.out.println("m.id = " + m.get("id"));
                        String piva = cu.s(m.get("partita_iva"));
                        if (StringUtils.isBlank((String)piva)) {
                            piva = cu.s(m.get("codice_fiscale"));
                        }
                        if ((fat = JDialogRicezione.this.trovaFattura(m, list)) == null) continue;
                        m.put("gia_registrata", cu.s(fat.get("serie")) + cu.s(fat.get("numero")) + " " + DateUtils.formatDateIta((Date)cu.toDate(fat.get("data"))));
                    }
                    this.publish(new Object[]{esito});
                }
                return null;
            }

            protected void process(List chunks) {
                for (Object o : chunks) {
                    if (o instanceof EsitoRicezione) {
                        DefaultTableModel model = (DefaultTableModel)JDialogRicezione.this.tabFatture.getModel();
                        model.setRowCount(0);
                        EsitoRicezione esito = (EsitoRicezione)o;
                        for (Map m : esito.fatture) {
                            String piva = cu.s(m.get("partita_iva"));
                            if (StringUtils.isBlank((String)piva)) {
                                piva = cu.s(m.get("codice_fiscale"));
                            }
                            System.out.println("process m.get(id): " + m.get("id"));
                            Object[] row = new Object[]{m.get("id"), m.get("numero"), m.get("data"), m.get("data_ricezione"), m.get("fornitore"), piva, null, m.get("gia_registrata"), cu.sIsBlank(m.get("gia_registrata")), m};
                            model.addRow(row);
                        }
                        continue;
                    }
                    if (!(o instanceof String)) continue;
                    JDialogRicezione.this.myGlassPane.msg = cu.s(o);
                    JDialogRicezione.this.myGlassPane.repaint();
                    JDialogRicezione.this.myGlassPane.validate();
                }
            }

            protected void done() {
                super.done();
                try {
                    this.get();
                    ((JXTable)JDialogRicezione.this.tabFatture).setSortOrder((Object)"Data ricezione", SortOrder.DESCENDING);
                    String serie = cu.s(this.param.get("fe_serie_import"));
                    String serie_spec = cu.s(this.param.get("serie_fatt_acq"));
                    if (StringUtils.isBlank((String)serie) || serie.equals(Sdi.SERIE_IMPORT_SPECIFICA) || serie.equals(Sdi.SERIE_IMPORT_CHIEDI)) {
                        JDialogRicezione.this.feSerieFattAcq.setText(serie_spec);
                    } else if (serie.equals(Sdi.SERIE_IMPORT_NO)) {
                        JDialogRicezione.this.feSerieFattAcq.setText("");
                        JDialogRicezione.this.feSerieFattAcq.setEnabled(false);
                        JDialogRicezione.this.labSerie.setEnabled(false);
                    }
                    String movimenti = cu.s(this.param.get("fe_genera_movimenti"));
                    if (StringUtils.isBlank((String)movimenti) || movimenti.equals(Sdi.GENERA_MOVIMENTI_NO)) {
                        JDialogRicezione.this.fe_genera_movimenti.setSelected(false);
                    } else {
                        JDialogRicezione.this.fe_genera_movimenti.setSelected(true);
                    }
                    if (main.pluginContabilita && main.isPluginContabilitaAttivo()) {
                        String gen = cu.s(((Map)main.GLOB.get("dati_azienda")).get("con_gen_pag"));
                        boolean continua = false;
                        if (gen.equalsIgnoreCase("") || gen.equalsIgnoreCase("C")) {
                            if (main.fileIni.getValueBoolean("pref", "genera_contab_in_import_fe", false).booleanValue()) {
                                continua = true;
                            }
                        } else if (gen.equalsIgnoreCase("S")) {
                            continua = true;
                        }
                        if (continua) {
                            JDialogRicezione.this.fe_genera_contab.setSelected(true);
                        } else {
                            JDialogRicezione.this.fe_genera_contab.setSelected(false);
                        }
                    }
                }
                catch (Exception e) {
                    SwingUtils.showExceptionMessage((Component)JDialogRicezione.this, (Exception)e);
                }
                SwingUtils.mouse_def((Component)JDialogRicezione.this);
                if (this.sdi != null) {
                    this.sdi.setCurrentWorker(null);
                }
                JDialogRicezione.this.myGlassPane.msg = null;
                JDialogRicezione.this.myGlassPane.setVisible(false);
                SwingUtils.mouse_def((Component)JDialogRicezione.this);
                JDialogRicezione.this.aggiornaLabTotali();
            }
        };
        w.execute();
    }

    private Map trovaFattura(Map m, List<Map> list) {
        String data1 = DateUtils.formatDateIta((Date)cu.toDate(m.get("data")));
        String numero1 = cu.s(m.get("numero")).trim();
        String piva1 = cu.s(m.get("partita_iva")).trim();
        String cfiscale1 = cu.s(m.get("codice_fiscale")).trim();
        for (Map mn : list) {
            String data2 = DateUtils.formatDateIta((Date)cu.toDate(mn.get("data_doc")));
            String numero2 = cu.s(mn.get("numero_doc")).trim();
            String piva2 = cu.s(mn.get("piva_cfiscale")).trim();
            piva2 = piva2.toUpperCase();
            String cfiscale2 = cu.s(mn.get("cfiscale")).trim();
            cfiscale2 = cfiscale2.toUpperCase();
            piva2 = StringUtils.removeStart((String)piva2, (String)"IT");
            piva2 = piva2.trim();
            if (cfiscale2.length() < 16) {
                cfiscale2 = StringUtils.removeStart((String)cfiscale2, (String)"IT");
                cfiscale2 = cfiscale2.trim();
            }
            if (!data1.equals(data2) || !numero1.equals(numero2) || !(piva1.length() > 0 && piva1.equalsIgnoreCase(piva2) || piva1.length() > 0 && piva1.equalsIgnoreCase(cfiscale2) || cfiscale1.length() > 0 && cfiscale1.equalsIgnoreCase(cfiscale2)) && (cfiscale1.length() <= 0 || !cfiscale1.equalsIgnoreCase(piva2))) continue;
            return mn;
        }
        return null;
    }

    private void initComponents() {
        this.butImporta = new JButton();
        this.feSerieFattAcq = new JTextField();
        this.labSerie = new JLabel();
        this.labTitolo = new JLabel();
        this.butAnnulla = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tabFatture = new JXTable(){
            Color color_hover = new Color(200, 200, 220);
            Color color_sel = new Color(155, 155, 175);
            Color color_fatt = new Color(255, 255, 255);
            Color color_back_gia = new Color(235, 235, 235);

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                boolean gia_registrata = !cu.sIsBlank((Object)this.getValueAt(row, this.getColumnModel().getColumnIndex("Gi\u00e0 registrata")));
                Color back = this.colorForRow(row, c);
                c.setForeground(gia_registrata ? Color.DARK_GRAY : Color.BLACK);
                if (this.isRowSelected(row)) {
                    c.setBackground(SwingUtils.mixColours((Color[])new Color[]{back, this.color_sel}));
                } else {
                    c.setBackground(back);
                }
                return c;
            }

            protected Color colorForRow(int row, Component c) {
                try {
                    boolean gia_registrata;
                    boolean bl = gia_registrata = !cu.sIsBlank((Object)this.getValueAt(row, this.getColumnModel().getColumnIndex("Gi\u00e0 registrata")));
                    if (gia_registrata) {
                        return this.color_back_gia;
                    }
                    return Color.WHITE;
                }
                catch (Exception exception) {
                    return c.getBackground();
                }
            }
        };
        this.fe_genera_movimenti = new JCheckBox();
        this.jButton1 = new JButton();
        this.dal = new JXDatePicker();
        this.labFattRic = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.labAl = new JLabel();
        this.al = new JXDatePicker();
        this.butSeleTutt = new JButton();
        this.butDeseTutt = new JButton();
        this.labTotali = new JLabel();
        this.comDataRegistrazione = new JComboBox();
        this.jLabel3 = new JLabel();
        this.fe_genera_contab = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Ricezione fatture elettroniche");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JDialogRicezione.this.formWindowClosing(evt);
            }
        });
        this.butImporta.setIcon(iu.getIcon("conferma"));
        this.butImporta.setText("Importa");
        this.butImporta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogRicezione.this.butImportaActionPerformed(evt);
            }
        });
        this.feSerieFattAcq.setColumns(2);
        this.feSerieFattAcq.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JDialogRicezione.this.feSerieFattAcqKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                JDialogRicezione.this.feSerieFattAcqKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                JDialogRicezione.this.feSerieFattAcqKeyTyped(evt);
            }
        });
        this.labSerie.setHorizontalAlignment(4);
        this.labSerie.setText("Serie da utilizzare per le nuove fatture");
        this.labTitolo.setText("Anteprima fatture da importare");
        this.butAnnulla.setIcon(iu.getIcon("annulla"));
        this.butAnnulla.setText("Annulla");
        this.butAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogRicezione.this.butAnnullaActionPerformed(evt);
            }
        });
        this.tabFatture.setModel(new DefaultTableModel(new Object[0][], new String[]{"ID Provider", "Numero", "Data", "Data ricezione", "Fornitore", "Partita IVA Forn.", "Totale", "Gi\u00e0 registrata", "Importare", "m"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class, Object.class, Object.class, String.class, Object.class, Double.class, Object.class, Boolean.class, Object.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, true, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tabFatture.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDialogRicezione.this.tabFattureMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tabFatture);
        if (this.tabFatture.getColumnModel().getColumnCount() > 0) {
            this.tabFatture.getColumnModel().getColumn(0).setPreferredWidth(20);
            this.tabFatture.getColumnModel().getColumn(1).setPreferredWidth(20);
            this.tabFatture.getColumnModel().getColumn(2).setPreferredWidth(20);
            this.tabFatture.getColumnModel().getColumn(3).setPreferredWidth(20);
            this.tabFatture.getColumnModel().getColumn(4).setPreferredWidth(200);
            this.tabFatture.getColumnModel().getColumn(5).setPreferredWidth(40);
            this.tabFatture.getColumnModel().getColumn(6).setMinWidth(0);
            this.tabFatture.getColumnModel().getColumn(6).setPreferredWidth(0);
            this.tabFatture.getColumnModel().getColumn(6).setMaxWidth(0);
            this.tabFatture.getColumnModel().getColumn(7).setPreferredWidth(30);
            this.tabFatture.getColumnModel().getColumn(8).setPreferredWidth(20);
            this.tabFatture.getColumnModel().getColumn(9).setMinWidth(0);
            this.tabFatture.getColumnModel().getColumn(9).setPreferredWidth(0);
            this.tabFatture.getColumnModel().getColumn(9).setMaxWidth(0);
        }
        this.fe_genera_movimenti.setText("Generazione movimenti di magazzino");
        this.fe_genera_movimenti.setHorizontalTextPosition(2);
        this.jButton1.setText("Aggiorna");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogRicezione.this.jButton1ActionPerformed(evt);
            }
        });
        this.labFattRic.setText("Fatture ricevute dal");
        this.jSeparator1.setOrientation(1);
        this.labAl.setText("al");
        this.butSeleTutt.setIcon(iu.getIcon("Select_All"));
        this.butSeleTutt.setText("Seleziona tutte");
        this.butSeleTutt.setMargin(new Insets(2, 2, 2, 2));
        this.butSeleTutt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogRicezione.this.butSeleTuttActionPerformed(evt);
            }
        });
        this.butDeseTutt.setIcon(iu.getIcon("Broom"));
        this.butDeseTutt.setText("Deseleziona tutte");
        this.butDeseTutt.setMargin(new Insets(2, 2, 2, 2));
        this.butDeseTutt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogRicezione.this.butDeseTuttActionPerformed(evt);
            }
        });
        this.labTotali.setText("...");
        this.comDataRegistrazione.setModel(new DefaultComboBoxModel<String>(new String[]{"Data ricezione", "Data odierna"}));
        this.comDataRegistrazione.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogRicezione.this.comDataRegistrazioneActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Data registrazione");
        this.fe_genera_contab.setText("Generazione registrazioni di prima nota");
        this.fe_genera_contab.setHorizontalTextPosition(2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((Component)this.labTitolo).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.labFattRic).addPreferredGap(0).add((Component)this.dal, -2, -1, -2).addPreferredGap(1).add((Component)this.labAl).addPreferredGap(0).add((Component)this.al, -2, -1, -2).addPreferredGap(1).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((Component)this.jButton1)).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.butAnnulla).addPreferredGap(0).add((Component)this.butImporta)).add((Component)this.jScrollPane1, -1, 983, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.labSerie).addPreferredGap(0).add((Component)this.feSerieFattAcq, -2, -1, -2)).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.labTotali).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.comDataRegistrazione, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.fe_genera_contab).add((Component)this.fe_genera_movimenti).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.butDeseTutt).addPreferredGap(0).add((Component)this.butSeleTutt))))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.dal, -2, -1, -2).add((Component)this.labFattRic)).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.al, -2, -1, -2).add((Component)this.labAl)).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.labTitolo).add((Component)this.jButton1)).add((Component)this.jSeparator1)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.butDeseTutt).add((Component)this.butSeleTutt)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 393, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.labTotali).add((Component)this.comDataRegistrazione, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.feSerieFattAcq, -2, -1, -2).add((Component)this.labSerie)).addPreferredGap(0).add((Component)this.fe_genera_movimenti).addPreferredGap(1).add((Component)this.fe_genera_contab).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.butImporta).add((Component)this.butAnnulla)).addContainerGap()));
        this.pack();
    }

    private void butImportaActionPerformed(ActionEvent evt) {
        main.fileIni.setValue("pref", "ricezione_data_reg", this.comDataRegistrazione.getSelectedItem());
        main.fileIni.setValue("pref", "genera_contab_in_import_fe", this.fe_genera_contab.isSelected());
        boolean alcuneGiaImportate = false;
        for (int i = 0; i < this.tabFatture.getRowCount(); ++i) {
            String gia;
            boolean sel = cu.toBoolean((Object)this.tabFatture.getValueAt(i, this.tabFatture.getColumnModel().getColumnIndex("Importare")));
            if (!sel || StringUtils.isBlank((String)(gia = cu.s((Object)this.tabFatture.getValueAt(i, this.tabFatture.getColumnModel().getColumnIndex("Gi\u00e0 registrata")))))) continue;
            alcuneGiaImportate = true;
            break;
        }
        if (alcuneGiaImportate && !SwingUtils.showYesNoMessage((Component)this, (String)"Hai selezionato una o pi\u00f9 fatture che risultano gi\u00e0 registrate, proseguendo verranno duplicate.\nProseguire ?")) {
            return;
        }
        this.myGlassPane.setVisible(true);
        this.myGlassPane.msg = "Importazione in corso";
        SwingWorker w = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                Sdi sdi = null;
                if (JDialogRicezione.this.cartella != null) {
                    sdi = FEUtils.getSdiImpl("Folder");
                    sdi.param.put("cartella", JDialogRicezione.this.cartella);
                } else {
                    sdi = FEUtils.getSdiImpl();
                }
                ArrayList<Sdi.FatturaSdi> list = new ArrayList<Sdi.FatturaSdi>();
                for (int i = 0; i < JDialogRicezione.this.tabFatture.getRowCount(); ++i) {
                    boolean sel = cu.toBoolean((Object)JDialogRicezione.this.tabFatture.getValueAt(i, JDialogRicezione.this.tabFatture.getColumnModel().getColumnIndex("Importare")));
                    if (!sel) continue;
                    String id = cu.s((Object)JDialogRicezione.this.tabFatture.getValueAt(i, JDialogRicezione.this.tabFatture.getColumnModel().getColumnIndex("ID Provider")));
                    System.out.println("sel id:" + id);
                    Sdi.FatturaSdi f = new Sdi.FatturaSdi();
                    f.id = id;
                    f.dati = (Map)JDialogRicezione.this.tabFatture.getValueAt(i, JDialogRicezione.this.tabFatture.getColumnModel().getColumnIndex("m"));
                    list.add(f);
                }
                for (Sdi.FatturaSdi f : list) {
                    System.out.println("f:" + f.id);
                }
                Collections.sort(list, new Comparator<Sdi.FatturaSdi>(){

                    @Override
                    public int compare(Sdi.FatturaSdi f1, Sdi.FatturaSdi f2) {
                        if (cu.toDate(f1.dati.get("data_ricezione")).getTime() > cu.toDate(f2.dati.get("data_ricezione")).getTime()) {
                            return 1;
                        }
                        return -1;
                    }
                });
                for (Sdi.FatturaSdi f : list) {
                    System.out.println("f:" + f.id);
                }
                Sdi.EsitoImportDaSdi esito = sdi.riceviDaSdiImporta(list, JDialogRicezione.this, true, JDialogRicezione.this.fe_genera_movimenti.isSelected(), JDialogRicezione.this.fe_genera_contab.isSelected(), JDialogRicezione.this.feSerieFattAcq.getText(), cu.s((Object)JDialogRicezione.this.comDataRegistrazione.getSelectedItem()), this);
                return esito;
            }

            protected void process(List chunks) {
                for (Object o : chunks) {
                    if (!(o instanceof String)) continue;
                    JDialogRicezione.this.myGlassPane.msg = cu.s(o);
                    JDialogRicezione.this.myGlassPane.repaint();
                    JDialogRicezione.this.myGlassPane.validate();
                }
            }

            protected void done() {
                SwingUtils.mouse_def((Component)JDialogRicezione.this);
                try {
                    Sdi.EsitoImportDaSdi esito = (Sdi.EsitoImportDaSdi)this.get();
                    boolean avvisi_in_esiti = false;
                    for (Map m : esito.esiti) {
                        if (m.get("avvisi") == null) continue;
                        avvisi_in_esiti = true;
                        break;
                    }
                    InvoicexUtil.aggiornaElenchiFattureAcquisto();
                    if (esito.fatture_ricevute > esito.fatture_importate || avvisi_in_esiti) {
                        JDialogEsitoRicezione desito = new JDialogEsitoRicezione((Dialog)JDialogRicezione.this, true);
                        desito.setLocationRelativeTo(JDialogRicezione.this);
                        desito.load(esito);
                        desito.pack();
                        desito.setVisible(true);
                    } else {
                        SwingUtils.showInfoMessage((Component)JDialogRicezione.this, (String)("<html>Importate <b>" + esito.fatture_importate + "</b> fatture</html>"));
                    }
                }
                catch (Exception e) {
                    SwingUtils.showExceptionMessage((Component)JDialogRicezione.this, (Exception)e);
                }
                JDialogRicezione.this.dispose();
            }
        };
        SwingUtils.mouse_wait((Component)this);
        w.execute();
    }

    private void formWindowClosing(WindowEvent evt) {
    }

    private void butAnnullaActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void tabFattureMouseClicked(MouseEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.myGlassPane.setVisible(true);
        this.load();
    }

    private void butSeleTuttActionPerformed(ActionEvent evt) {
        for (int row = 0; row < this.tabFatture.getRowCount(); ++row) {
            this.tabFatture.setValueAt(true, row, this.tabFatture.getColumnModel().getColumnIndex("Importare"));
        }
        this.aggiornaLabTotali();
    }

    private void butDeseTuttActionPerformed(ActionEvent evt) {
        for (int row = 0; row < this.tabFatture.getRowCount(); ++row) {
            this.tabFatture.setValueAt(false, row, this.tabFatture.getColumnModel().getColumnIndex("Importare"));
        }
        this.aggiornaLabTotali();
    }

    private void feSerieFattAcqKeyPressed(KeyEvent evt) {
        this.feSerieFattAcq.setText(this.feSerieFattAcq.getText().toUpperCase());
    }

    private void feSerieFattAcqKeyReleased(KeyEvent evt) {
        this.feSerieFattAcq.setText(this.feSerieFattAcq.getText().toUpperCase());
    }

    private void feSerieFattAcqKeyTyped(KeyEvent evt) {
    }

    private void comDataRegistrazioneActionPerformed(ActionEvent evt) {
    }

    public void aggiornaLabTotali() {
        int selezionate = 0;
        if (this.tabFatture.getRowCount() > 0 && this.tabFatture.getModel().getRowCount() > 0) {
            for (int row = 0; row < this.tabFatture.getRowCount(); ++row) {
                if (!cu.toBoolean((Object)this.tabFatture.getValueAt(row, this.tabFatture.getColumnModel().getColumnIndex("Importare")))) continue;
                ++selezionate;
            }
            this.labTotali.setText("Totale fatture " + this.tabFatture.getRowCount() + ", selezionate " + selezionate);
        } else {
            this.labTotali.setText("");
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(JDialogRicezione.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(JDialogRicezione.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(JDialogRicezione.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(JDialogRicezione.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDialogRicezione dialog = new JDialogRicezione((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

