/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex2.fe.impl;

import com.google.gson.Gson;
import gestioneFatture.iniFileProp;
import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.invoicex.iu;
import it.tnx.invoicex2.fe.EsitoRicezione;
import it.tnx.invoicex2.fe.FEUtils;
import it.tnx.invoicex2.fe.Sdi;
import it.tnx.invoicex2.fe.impl.Base64Utils;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class CloudFinanceSdi
extends Sdi {
    static String url_ws_sandbox = "https://sandbox.freeinvoice.it/api/v1";
    static String url_ws = "https://webapp.freeinvoice.it/api/v1";
    String apikey = null;
    String access_token = null;

    public CloudFinanceSdi() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }

    @Override
    public boolean testConnessione(String username, String password, String key1, String key2) throws Exception {
        return this.login(username, password, key1, key2);
    }

    @Override
    public boolean inviaASdi(String file, String tipo, Integer id) throws Exception {
        if (this.login()) {
            HttpURLConnection con = (HttpURLConnection)new URL(this.getUrl() + "/invoices/usend").openConnection();
            HashMap<String, String> data = new HashMap<String, String>();
            String dataFile = IOUtils.toString((Reader)new FileReader(file));
            String dataFile64 = new String(Base64.encodeBase64((byte[])dataFile.getBytes()));
            System.out.println("dataFile64 = " + dataFile64);
            File ffile = new File(file);
            data.put("apiKey", this.apikey);
            data.put("invoiceFileBase64", dataFile64);
            Sdi.HttpResp resp = CloudFinanceSdi.doRequest(con, "POST", Sdi.ContentType.json, data);
            System.out.println("resp = " + resp.http_status_code);
            System.out.println("resp = " + resp.http_status_msg);
            System.out.println("resp = " + resp.output);
            con.disconnect();
            JSONParser p = new JSONParser();
            JSONObject jo = (JSONObject)p.parse(resp.output);
            String error = "";
            String invoiceId = "";
            try {
                JSONObject jdata = (JSONObject)((JSONArray)jo.get("data")).get(0);
                invoiceId = cu.s(jdata.get("invoiceId"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String fe_upload_filename = invoiceId;
            if (StringUtils.isBlank((String)fe_upload_filename)) {
                throw new Exception("Errore CloudFinanceSdi: uploadFileName vuoto");
            }
            String sql = "update " + FEUtils.getTabXml(tipo) + " set fe_upload_filename = " + dbu.sql((Object)fe_upload_filename) + ", fe_inviata_ts = CURRENT_TIMESTAMP, fe_provider_invio = " + dbu.sql((Object)this.getClass().getSimpleName()) + " where id_fattura = " + dbu.sql((Object)id);
            dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
            this.aggiornaStatoFattura("V", id, STATO_INVIATA);
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("id_fattura", id);
            m.put("stato", STATO_INVIATA);
            m.put("provider", this.getClass().getSimpleName());
            if (main.utente != null) {
                m.put("utente_invoicex", main.utente.getNomeUtente());
            }
            m.put("utente_so", main.utente.getNomeUtente());
            sql = "insert into test_fatt_xmlpa_status set " + dbu.prepareSqlFromMap(m);
            dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
            iu.aggiornaElenchiFattureRefreshSelected();
        }
        return true;
    }

    @Override
    public Object getStatus(String tipo_fattura, Integer id) throws Exception {
        throw new Exception("CloudFinance non disponibile");
    }

    private boolean login() throws Exception {
        return this.login(cu.s(this.param.get("provider_username")), iniFileProp.decrypt(cu.s(this.param.get("provider_password"))), cu.s(this.param.get("provider_key1")), cu.s(this.param.get("provider_key2")));
    }

    private boolean login(String username, String password, String key1, String key2) throws Exception {
        this.apikey = key1;
        return true;
    }

    @Override
    public EsitoRicezione riceviElencoDaSdi(Date dalDate, Date alDate) throws Exception {
        throw new Exception("non disponibile");
    }

    private void addFatture(List<Map> l, Map jo) {
        List list = (List)jo.get("content");
        for (Object o : list) {
            Map m = (Map)o;
            HashMap f = new HashMap();
            f.put("fornitore", ((Map)m.get("sender")).get("description"));
            f.put("partita_iva", ((Map)m.get("sender")).get("vatCode"));
            f.put("codice_fiscale", ((Map)m.get("sender")).get("fiscalCode"));
            f.put("data_ricezione", this.getDateCreation(StringUtils.removeEnd((String)cu.s(m.get("creationDate")), (String)"+0000")));
            Map inv = (Map)((List)m.get("invoices")).get(0);
            f.put("data", this.getDate(inv.get("invoiceDate")));
            f.put("numero", inv.get("number"));
            f.put("id", m.get("filename"));
            l.add(f);
        }
    }

    @Override
    public byte[] riceviDaSdi(String id) throws Exception {
        if (this.login()) {
            HttpURLConnection con = (HttpURLConnection)new URL(url_ws + "/services/invoice/in/getByFilename?filename=" + id).openConnection();
            HashMap<String, String> add_headers = new HashMap<String, String>();
            add_headers.put("Authorization", "Bearer " + this.access_token);
            Sdi.HttpResp resp = CloudFinanceSdi.doRequest(con, "GET", Sdi.ContentType.json, null, add_headers);
            System.out.println("resp = " + resp.http_status_code);
            System.out.println("resp = " + resp.http_status_msg);
            System.out.println("resp = " + resp.output);
            con.disconnect();
            Gson gson = new Gson();
            Map jo = (Map)gson.fromJson(resp.output, Map.class);
            String error = (String)jo.get("errorCode");
            String error_desc = (String)jo.get("errorDescription");
            if (!StringUtils.isBlank((String)error) && !cu.s((Object)error).equalsIgnoreCase("0000")) {
                throw new Exception(error + ": " + error_desc);
            }
            String xml = cu.s(jo.get("file"));
            return Base64Utils.base64Decode(xml);
        }
        return null;
    }

    private Date getDateCreation(Object data) {
        Timestamp ts = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            ts = new Timestamp(sdf.parse(cu.s((Object)data)).getTime());
            return new Date(ts.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Date getDate(Object data) {
        Timestamp ts = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            ts = new Timestamp(sdf.parse(cu.s((Object)data)).getTime());
            return new Date(ts.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getUrl() {
        return url_ws_sandbox;
    }
}

