/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex2.fe.impl;

import gestioneFatture.iniFileProp;
import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.commons.DebugFastUtils;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.invoicex.iu;
import it.tnx.invoicex2.fe.EsitoRicezione;
import it.tnx.invoicex2.fe.FEUtils;
import it.tnx.invoicex2.fe.Sdi;
import it.tnx.invoicex2.fe.impl.XPathUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FolderSdi
extends Sdi {
    String url = "https://api.fatturapa.com/ws/V10.svc/rest/";
    String apikey = null;
    private Map datiStatus;
    String access_token = null;

    public FolderSdi() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }

    @Override
    public boolean testConnessione(String username, String password, String key1, String key2) throws Exception {
        return this.login(username, password);
    }

    @Override
    public boolean inviaASdi(String file, String tipo, Integer id) throws Exception {
        if (this.login()) {
            HttpURLConnection con = (HttpURLConnection)new URL(this.url + "UploadStart/" + this.apikey).openConnection();
            Sdi.HttpResp resp = Sdi.doRequest(con, "GET", Sdi.ContentType.json, null);
            System.out.println("FatturaPA status :" + resp.http_status_code + " " + resp.http_status_msg);
            System.out.println("FatturaPA output :" + resp.output);
            if (resp.http_status_code != 200) {
                throw new Exception("FatturaPA : Errore in fase UploadStart: " + resp.http_status_code + " " + resp.http_status_msg);
            }
            JSONParser p = new JSONParser();
            JSONObject jo = (JSONObject)p.parse(resp.output);
            String complete = (String)jo.get("Complete");
            System.out.println("FatturaPA: Complete = " + complete);
            String name = (String)jo.get("Name");
            System.out.println("FatturaPA: Name = " + name);
            if (StringUtils.isBlank((String)complete)) {
                throw new Exception("FatturaPA : Errore campo 'complete' vuoto");
            }
            if (StringUtils.isBlank((String)name)) {
                throw new Exception("FatturaPA : Errore campo 'name' vuoto");
            }
            con = (HttpURLConnection)new URL(complete).openConnection();
            resp = Sdi.sendFileMSAzureBlob(con, new File(file));
            System.out.println("FatturaPA: sendfile resp");
            DebugFastUtils.dump((Object)resp);
            String fileName = name;
            con = (HttpURLConnection)new URL(this.url + "UploadStop/" + this.apikey + "/" + fileName).openConnection();
            resp = Sdi.doRequest(con, "GET", Sdi.ContentType.json, null);
            System.out.println("FatturaPA status :" + resp.http_status_code + " " + resp.http_status_msg);
            System.out.println("FatturaPA output :" + resp.output);
            if (resp.http_status_code != 200) {
                if (resp.http_status_code == 500) {
                    String fault = XPathUtils.get(resp.output, "//Fault/Reason/Text");
                    if (StringUtils.isNotBlank((String)fault)) {
                        throw new Exception("FatturaPA : Errore in fase UploadStop: " + fault);
                    }
                    throw new Exception("FatturaPA : Errore in fase UploadStop: " + resp.output);
                }
                throw new Exception("FatturaPA : Errore in fase UploadStop: " + resp.http_status_code + " " + resp.http_status_msg);
            }
            String sql = "update " + FEUtils.getTabXml(tipo) + " set fe_upload_filename = " + dbu.sql((Object)name) + ", fe_inviata_ts = CURRENT_TIMESTAMP, fe_provider_invio = " + dbu.sql((Object)this.getClass().getSimpleName()) + " where id_fattura = " + dbu.sql((Object)id);
            dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
            this.aggiornaStatoFattura("V", id, STATO_INVIATA);
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("id_fattura", id);
            m.put("stato", STATO_INVIATA);
            m.put("provider", this.getClass().getSimpleName());
            if (main.utente != null) {
                m.put("utente_invoicex", main.utente.getNomeUtente());
            }
            m.put("utente_so", main.utente.getNomeUtente());
            sql = "insert into test_fatt_xmlpa_status set " + dbu.prepareSqlFromMap(m);
            dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
            iu.aggiornaElenchiFattureRefreshSelected();
        }
        return true;
    }

    @Override
    public Object getStatus(String tipo_fattura, Integer id) throws Exception {
        Map ultimoStatusFattura;
        List list;
        String filename = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)("select fe_upload_filename from " + FEUtils.getTabXml(tipo_fattura) + " where id_fattura = " + dbu.sql((Object)id))));
        if (this.datiStatus == null) {
            if (this.login()) {
                this.datiStatus = new HashMap();
                HashMap<String, String> ultimoStatusFattura2 = new HashMap<String, String>();
                Object con = (HttpURLConnection)new URL(this.url + "Pool/" + this.apikey).openConnection();
                Sdi.HttpResp resp = Sdi.doRequest((HttpURLConnection)con, "GET");
                System.out.println("resp = " + resp.output);
                JSONParser p = new JSONParser();
                JSONObject jo = (JSONObject)p.parse(resp.output);
                String complete = (String)jo.get("Complete");
                System.out.println("Complete = " + complete);
                con = (HttpURLConnection)new URL(complete).openConnection();
                HashMap<String, String> h = new HashMap<String, String>();
                h.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8");
                resp = Sdi.doRequest((HttpURLConnection)con, "GET", Sdi.ContentType.json, null, h);
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(new ByteArrayInputStream(resp.output.getBytes()));
                doc.getDocumentElement().normalize();
                XPathFactory xPathfactory = XPathFactory.newInstance();
                XPath xpath = xPathfactory.newXPath();
                String root = doc.getDocumentElement().getNodeName();
                System.out.println("root = " + root);
                HashMap ret = new HashMap();
                NodeList list2 = (NodeList)xpath.evaluate("//*[local-name()='Name']", doc, XPathConstants.NODESET);
                System.out.println("list = " + list2.getLength());
                for (int i = 0; i < list2.getLength(); ++i) {
                    System.out.println("i = " + i);
                    Element e1 = (Element)list2.item(i);
                    System.out.println("e1 = " + e1);
                    System.out.println("e1 = " + e1.getTagName());
                    System.out.println("e1 = " + e1.getTextContent());
                    String name = e1.getTextContent();
                    String filenameRowkey = ((Element)((Element)e1.getParentNode()).getElementsByTagName("d:RowKey").item(0)).getTextContent();
                    System.out.println("filename = " + filename);
                    String tipo = ((Element)((Element)e1.getParentNode()).getElementsByTagName("d:Tipo").item(0)).getTextContent();
                    System.out.println("tipo = " + tipo);
                    String ts = ((Element)((Element)e1.getParentNode()).getElementsByTagName("d:Timestamp").item(0)).getTextContent();
                    System.out.println("ts = " + ts);
                    Calendar cal = DatatypeConverter.parseDateTime((String)ts);
                    Date dts = cal.getTime();
                    ArrayList listPerFattura = (ArrayList)this.datiStatus.get(name);
                    int numeroNotifica = 0;
                    if (listPerFattura == null) {
                        listPerFattura = new ArrayList();
                        numeroNotifica = 1;
                    } else {
                        numeroNotifica = listPerFattura.size() + 1;
                    }
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    m.put("numero_notifica", numeroNotifica);
                    m.put("name", name);
                    m.put("ts", ts);
                    m.put("dts", dts);
                    m.put("tipo", tipo);
                    listPerFattura.add(m);
                    this.datiStatus.put(name, listPerFattura);
                    String stato = null;
                    if (tipo.equalsIgnoreCase("Trasmissione")) {
                        stato = STATO_INVIATA;
                    } else if (tipo.equalsIgnoreCase("NotificaScarto")) {
                        stato = STATO_SCARTATA;
                    } else if (tipo.equalsIgnoreCase("RicevutaConsegna")) {
                        stato = STATO_CONSEGNATA;
                    } else if (tipo.equalsIgnoreCase("NotificaMancataConsegna")) {
                        stato = STATO_MANCATA_CONSEGNA;
                    } else if (tipo.equalsIgnoreCase("NotificaEsito") || tipo.equalsIgnoreCase("AttestazioneTrasmissioneFattura")) {
                        stato = STATO_RICEVUTA;
                    }
                    ultimoStatusFattura2.put(name, stato);
                }
                this.datiStatus.put("ultimoStatusFattura", ultimoStatusFattura2);
            } else {
                throw new Exception("FatturaPA : Errore in fase di login");
            }
        }
        if ((list = (List)this.datiStatus.get(filename)) != null) {
            for (Map m : list) {
                HashMap<String, Object> dati = new HashMap<String, Object>();
                dati.put("id_fattura", id);
                dati.put("numero_notifica", m.get("numero_notifica"));
                dati.put("ts_notifica", m.get("ts"));
                dati.put("stato_provider", m.get("tipo"));
                dati.put("provider", this.getClass().getSimpleName());
                if (main.utente != null) {
                    dati.put("utente_invoicex", main.utente.getNomeUtente());
                }
                dati.put("utente_so", main.utente.getNomeUtente());
                String sql = "insert into " + FEUtils.getTabXml(tipo_fattura) + "_status set " + dbu.prepareSqlFromMap(dati);
                try {
                    dbu.tryExecQuery((Connection)gestioneFatture.Db.getConn(), (String)sql);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if ((ultimoStatusFattura = (Map)this.datiStatus.get("ultimoStatusFattura")) != null && ultimoStatusFattura.get(filename) != null) {
            String statusFattura = (String)ultimoStatusFattura.get(filename);
            this.aggiornaStatoFattura(tipo_fattura, id, statusFattura);
        }
        return true;
    }

    private boolean login() throws Exception {
        return this.login(cu.s(this.param.get("provider_username")), iniFileProp.decrypt(cu.s(this.param.get("provider_password"))));
    }

    private boolean login(String username, String password) throws Exception {
        HttpURLConnection con = (HttpURLConnection)new URL(this.url + "Verify/" + username).openConnection();
        Sdi.HttpResp resp = Sdi.doRequest(con, "GET", Sdi.ContentType.json, null);
        System.out.println(resp.http_status_code + " " + resp.http_status_msg);
        System.out.println(resp.output);
        if (resp.http_status_code != 200) {
            throw new Exception("FatturaPA : Errore in fase di login: " + resp.http_status_code + " " + resp.http_status_msg);
        }
        if (resp.output.equalsIgnoreCase("true")) {
            this.apikey = username;
            return true;
        }
        throw new Exception("FatturaPA : Errore in fase di login: " + resp.http_status_code + " " + resp.http_status_msg + " output:" + resp.output);
    }

    @Override
    public EsitoRicezione riceviElencoDaSdi(Date dalDate, Date alDate) throws Exception {
        EsitoRicezione esito = new EsitoRicezione();
        File cartella = (File)this.param.get("cartella");
        String dal = FormatUtils.formatMysqlDate((Object)dalDate);
        String al = FormatUtils.formatMysqlDate((Object)alDate);
        ArrayList<Map> l = new ArrayList<Map>();
        File[] list = cartella.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml") || name.toLowerCase().endsWith(".p7m");
            }
        });
        if (list != null) {
            File f;
            boolean firmato;
            int i;
            for (i = 0; i < list.length; ++i) {
                firmato = false;
                f = list[i];
                if (!f.getName().toLowerCase().endsWith(".p7m")) continue;
                firmato = true;
                byte[] buffer = new byte[(int)f.length()];
                DataInputStream in = new DataInputStream(new FileInputStream(f));
                in.readFully(buffer);
                in.close();
                CMSSignedData signature = null;
                try {
                    signature = new CMSSignedData(buffer);
                }
                catch (CMSException e) {
                    buffer = Base64.decodeBase64((byte[])buffer);
                    signature = new CMSSignedData(buffer);
                }
                Store cs = signature.getCertificates();
                SignerInformationStore signers = signature.getSignerInfos();
                Collection c = signers.getSigners();
                Iterator it = c.iterator();
                byte[] data = null;
                int conta = 0;
                while (it.hasNext()) {
                    SignerInformation signer = (SignerInformation)it.next();
                    Collection certCollection = cs.getMatches((Selector)signer.getSID());
                    Iterator certIt = certCollection.iterator();
                    X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
                    CMSTypedData sc = signature.getSignedContent();
                    data = (byte[])sc.getContent();
                    String nomeFile = StringUtils.substringBeforeLast((String)f.getName(), (String)".p7m");
                    if (conta > 0) {
                        nomeFile = StringUtils.substringBeforeLast((String)nomeFile, (String)".") + "_" + conta + "." + StringUtils.substringAfterLast((String)nomeFile, (String)".");
                    }
                    String dirtemp = cartella.getAbsolutePath() + File.separatorChar;
                    String nomeFileContent = dirtemp + nomeFile;
                    try {
                        File ftempdir = new File(dirtemp);
                        ftempdir.mkdir();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    FileWriter fwcontent = new FileWriter(nomeFileContent);
                    IOUtils.write((byte[])data, (Writer)fwcontent);
                    fwcontent.close();
                    File fnomeFileContent = new File(nomeFileContent);
                    fnomeFileContent.setLastModified(f.lastModified());
                    ++conta;
                }
                f.delete();
            }
            list = cartella.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".xml");
                }
            });
            for (i = 0; i < list.length; ++i) {
                firmato = false;
                f = list[i];
                Date data_file = new Date(f.lastModified());
                Map dati = this.getFromXml(f);
                DebugFastUtils.dump((Object)dati);
                HashMap m = new HashMap();
                Map clifor = (Map)dati.get("clifor");
                List fatture = (List)dati.get("fatture");
                for (Map dati_fattura : fatture) {
                    Map fattura = (Map)dati_fattura.get("fattura");
                    m.put("fornitore", clifor.get("ragione_sociale"));
                    if (cu.sIsBlank(m.get("fornitore"))) {
                        m.put("fornitore", clifor.get("cognome") + " " + clifor.get("nome"));
                    }
                    m.put("partita_iva", clifor.get("piva_cfiscale"));
                    m.put("codice_fiscale", clifor.get("cfiscale"));
                    m.put("data", cu.toDate(fattura.get("data")));
                    m.put("data_ricezione", data_file);
                    m.put("numero", fattura.get("numero"));
                    m.put("id", f.getName());
                    System.out.println("f.getName():" + f.getName());
                    System.out.println("f.getAbsolutePath():" + f.getAbsolutePath());
                    l.add(m);
                }
            }
        }
        esito.fatture = l;
        return esito;
    }

    @Override
    public byte[] riceviDaSdi(String uri) throws Exception {
        System.out.println("uri = " + uri);
        File cartella = (File)this.param.get("cartella");
        File file = new File(cartella.getAbsolutePath() + File.separatorChar + uri);
        System.out.println("file = " + file);
        return IOUtils.toByteArray((InputStream)new FileInputStream(file));
    }
}

