/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex2.fe.impl;

import gestioneFatture.iniFileProp;
import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.commons.su;
import it.tnx.invoicex.iu;
import it.tnx.invoicex2.fe.FEUtils;
import it.tnx.invoicex2.fe.Sdi;
import it.tnx.invoicex2.fe.impl.Base64Utils;
import java.io.FileReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class InvoicexHSSdi
extends Sdi {
    static String url = "https://ws.archivia.online/ws_Api.php";
    String access_token = null;

    public InvoicexHSSdi() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }

    @Override
    public boolean testConnessione(String username, String password, String key1, String key2) throws Exception {
        return this.login(username, password, key1, key2);
    }

    @Override
    public boolean inviaASdi(String file, String tipo, Integer id) throws Exception {
        if (this.login()) {
            HttpURLConnection con = (HttpURLConnection)new URL(url + "/services/invoice/upload").openConnection();
            HashMap<String, String> add_headers = new HashMap<String, String>();
            add_headers.put("Authorization", "Bearer " + this.access_token);
            HashMap<String, String> data = new HashMap<String, String>();
            String dataFile = IOUtils.toString((Reader)new FileReader(file));
            String dataFile64 = new String(Base64.encodeBase64((byte[])dataFile.getBytes()));
            System.out.println("dataFile64 = " + dataFile64);
            data.put("dataFile", dataFile64);
            data.put("credential", "");
            data.put("domain", "");
            Sdi.HttpResp resp = InvoicexHSSdi.doRequest(con, "POST", Sdi.ContentType.json, data, add_headers);
            System.out.println("resp = " + resp.http_status_code);
            System.out.println("resp = " + resp.http_status_msg);
            System.out.println("resp = " + resp.output);
            con.disconnect();
            JSONParser p = new JSONParser();
            JSONObject jo = (JSONObject)p.parse(resp.output);
            String error = (String)jo.get("errorCode");
            String error_desc = (String)jo.get("errorDescription");
            if (!StringUtils.isBlank((String)error_desc)) {
                throw new Exception(error + ": " + error_desc);
            }
            String fe_upload_filename = cu.s(jo.get("uploadFileName"));
            if (StringUtils.isBlank((String)fe_upload_filename)) {
                throw new Exception("Errore ArubaSdi: uploadFileName vuoto");
            }
            String sql = "update " + FEUtils.getTabXml(tipo) + " set fe_upload_filename = " + dbu.sql((Object)fe_upload_filename) + ", fe_inviata_ts = CURRENT_TIMESTAMP, fe_provider_invio = " + dbu.sql((Object)this.getClass().getSimpleName()) + " where id_fattura = " + dbu.sql((Object)id);
            dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
            this.aggiornaStatoFattura("V", id, STATO_INVIATA);
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("id_fattura", id);
            m.put("stato", STATO_INVIATA);
            m.put("provider", this.getClass().getSimpleName());
            if (main.utente != null) {
                m.put("utente_invoicex", main.utente.getNomeUtente());
            }
            m.put("utente_so", main.utente.getNomeUtente());
            sql = "insert into test_fatt_xmlpa_status set " + dbu.prepareSqlFromMap(m);
            dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
            iu.aggiornaElenchiFattureRefreshSelected();
        }
        return true;
    }

    @Override
    public Object getStatus(String tipo_fattura, Integer id) throws Exception {
        String filename = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)("select fe_upload_filename from " + FEUtils.getTabXml(tipo_fattura) + " where id_fattura = " + dbu.sql((Object)id))));
        if (this.login()) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("invoiceFilename", filename);
            HttpURLConnection con = (HttpURLConnection)new URL(url + "/services/notification/out/getByInvoiceFilename?" + InvoicexHSSdi.getQueryString(data)).openConnection();
            HashMap<String, String> add_headers = new HashMap<String, String>();
            add_headers.put("Authorization", "Bearer " + this.access_token);
            Sdi.HttpResp resp = InvoicexHSSdi.doRequest(con, "GET", null, null, add_headers);
            System.out.println("resp = " + resp.http_status_code);
            System.out.println("resp = " + resp.http_status_msg);
            System.out.println("resp = " + resp.output);
            if (resp.http_status_code != 200) {
                if (resp.http_status_code == 401) {
                    throw new Exception("Hai verificato che la delega con TNX nel pannello di Aruba sia attivata ?\nAruba : Errore in fase getStatus: " + resp.http_status_code + " " + resp.http_status_msg);
                }
                throw new Exception("Aruba : Errore in fase getStatus: " + resp.http_status_code + " " + resp.http_status_msg);
            }
            con.disconnect();
            JSONParser p = new JSONParser();
            JSONObject jo = null;
            try {
                jo = (JSONObject)p.parse(resp.output);
            }
            catch (ParseException e) {
                throw new Exception("Errore nell'analisi della risposta\n\n" + su.html2text((String)resp.output));
            }
            String error = (String)jo.get("errorCode");
            String error_desc = (String)jo.get("errorDescription");
            if (!StringUtils.isBlank((String)error_desc)) {
                throw new Exception(error + ": " + error_desc);
            }
            String ultimoStatus = "";
            JSONArray list = (JSONArray)jo.get("notifications");
            for (Object o : list) {
                JSONObject jon = (JSONObject)o;
                HashMap<String, Object> dati = new HashMap<String, Object>();
                dati.put("id_fattura", id);
                dati.put("ts_notifica", jon.get("date"));
                dati.put("rif_fattura", jon.get("invoiceId"));
                dati.put("file_xml_nome_notifica", jon.get("filename"));
                dati.put("file_xml_notifica", new String(Base64Utils.base64Decode(cu.s(jon.get("file")))));
                dati.put("stato_provider", jon.get("docType"));
                ultimoStatus = cu.s(jon.get("docType"));
                dati.put("numero_notifica", jon.get("number"));
                dati.put("esito", jon.get("result"));
                dati.put("provider", this.getClass().getSimpleName());
                if (main.utente != null) {
                    dati.put("utente_invoicex", main.utente.getNomeUtente());
                }
                dati.put("utente_so", main.utente.getNomeUtente());
                String sql = "insert into " + FEUtils.getTabXml(tipo_fattura) + "_status set " + dbu.prepareSqlFromMap(dati);
                try {
                    dbu.tryExecQuery((Connection)gestioneFatture.Db.getConn(), (String)sql);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String statusFattura = null;
            if (ultimoStatus.equalsIgnoreCase("RC")) {
                statusFattura = STATO_CONSEGNATA;
            } else if (ultimoStatus.equalsIgnoreCase("NS") || ultimoStatus.equalsIgnoreCase("AT")) {
                statusFattura = STATO_SCARTATA;
            }
            if (statusFattura != null) {
                this.aggiornaStatoFattura(tipo_fattura, id, statusFattura);
            }
            return true;
        }
        throw new Exception("ArubaSdi : Errore in fase di login");
    }

    private boolean login() throws Exception {
        return this.login(cu.s(this.param.get("provider_username")), iniFileProp.decrypt(cu.s(this.param.get("provider_password"))), cu.s(this.param.get("provider_key1")), cu.s(this.param.get("provider_key2")));
    }

    private boolean login(String username, String password, String key1, String key2) throws Exception {
        HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
        System.out.println("InvoicexHsSdi login = " + username);
        String x = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<HSREQ xmlns:x=\"urn:gif:pdc:hsreq\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"urn:gif:pdc:hsreq ./xsd/hsreq.xsd\">  <USER>" + username + "</USER>\n  <RICHIESTA>RX-VERFAT</RICHIESTA>\n  <RX-VERFAT>";
        x = x + this.getRxVerfat();
        x = x + "</RX-VERFAT>\n</HSREQ>";
        System.out.println("x = " + x);
        Sdi.HttpResp resp = InvoicexHSSdi.doRequest(con, "POST", Sdi.ContentType.raw, null, x);
        con.disconnect();
        System.out.println(resp.http_status_code);
        System.out.println(resp.output);
        return true;
    }

    private String getRxVerfat() {
        return "xxx";
    }
}

