/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex2.fe.impl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class PKCS11LibraryFileAndPINCodeDialog
extends JDialog {
    private static final String CONFIG_FILE_NAME = ".smart_card_signer_applet.config";
    private static final String PKCS11_LIBRARY_FILE_NAME_KEY = "last-PKCS11-file-name";
    private JButton mBrowseForLibraryFileButton = new JButton();
    private JTextField mLibraryFileNameTextField = new JTextField();
    private JLabel mChooseLibraryFileLabel = new JLabel();
    private JTextField mPINCodeTextField = new JPasswordField();
    private JLabel mEnterPINCodeLabel = new JLabel();
    private JButton mSignButton = new JButton();
    private JButton mCancelButton = new JButton();
    private boolean mResult = false;

    public PKCS11LibraryFileAndPINCodeDialog() {
        this.getContentPane().setLayout(null);
        this.setSize(new Dimension(426, 165));
        this.setBackground(SystemColor.control);
        this.setTitle("Select PKCS#11 library file and smart card PIN code");
        this.setResizable(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        int centerPosX = (screenSize.width - dialogSize.width) / 2;
        int centerPosY = (screenSize.height - dialogSize.height) / 2;
        this.setLocation(centerPosX, centerPosY);
        this.mChooseLibraryFileLabel.setText("Please select your PKCS#11 implementation library file (.dll / .so) :");
        this.mChooseLibraryFileLabel.setBounds(new Rectangle(10, 5, 400, 15));
        this.mChooseLibraryFileLabel.setFont(new Font("Dialog", 0, 12));
        this.mLibraryFileNameTextField.setBounds(new Rectangle(10, 25, 315, 20));
        this.mLibraryFileNameTextField.setFont(new Font("DialogInput", 0, 12));
        this.mLibraryFileNameTextField.setEditable(false);
        this.mLibraryFileNameTextField.setBackground(SystemColor.control);
        this.mBrowseForLibraryFileButton.setText("Browse");
        this.mBrowseForLibraryFileButton.setBounds(new Rectangle(330, 25, 80, 20));
        this.mBrowseForLibraryFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PKCS11LibraryFileAndPINCodeDialog.this.browseForLibraryButton_actionPerformed();
            }
        });
        this.mEnterPINCodeLabel.setText("Enter the PIN code to access your smart card:");
        this.mEnterPINCodeLabel.setBounds(new Rectangle(10, 55, 350, 15));
        this.mEnterPINCodeLabel.setFont(new Font("Dialog", 0, 12));
        this.mPINCodeTextField.setBounds(new Rectangle(10, 75, 400, 20));
        this.mPINCodeTextField.setFont(new Font("DialogInput", 0, 12));
        this.mPINCodeTextField.setText("66491905");
        this.mSignButton.setText("Sign");
        this.mSignButton.setBounds(new Rectangle(110, 105, 75, 25));
        this.mSignButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PKCS11LibraryFileAndPINCodeDialog.this.signButton_actionPerformed();
            }
        });
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.setBounds(new Rectangle(220, 105, 75, 25));
        this.mCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PKCS11LibraryFileAndPINCodeDialog.this.cancelButton_actionPerformed();
            }
        });
        this.getContentPane().add((Component)this.mChooseLibraryFileLabel, null);
        this.getContentPane().add((Component)this.mLibraryFileNameTextField, null);
        this.getContentPane().add((Component)this.mBrowseForLibraryFileButton, null);
        this.getContentPane().add((Component)this.mEnterPINCodeLabel, null);
        this.getContentPane().add((Component)this.mPINCodeTextField, null);
        this.getContentPane().add((Component)this.mSignButton, null);
        this.getContentPane().add((Component)this.mCancelButton, null);
        this.getRootPane().setDefaultButton(this.mSignButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                String libraryFileName = PKCS11LibraryFileAndPINCodeDialog.this.mLibraryFileNameTextField.getText();
                if (libraryFileName != null && libraryFileName.length() != 0) {
                    PKCS11LibraryFileAndPINCodeDialog.this.mPINCodeTextField.requestFocus();
                } else {
                    PKCS11LibraryFileAndPINCodeDialog.this.mBrowseForLibraryFileButton.requestFocus();
                }
            }
        });
    }

    private void browseForLibraryButton_actionPerformed() {
        JFileChooser fileChooser = new JFileChooser();
        LibraryFileFilter libraryFileFilter = new LibraryFileFilter();
        fileChooser.addChoosableFileFilter(libraryFileFilter);
        String libraryFileName = this.mLibraryFileNameTextField.getText();
        File directory = new File(libraryFileName).getParentFile();
        fileChooser.setCurrentDirectory(directory);
        if (fileChooser.showOpenDialog(this) == 0) {
            String selectedLibFile = fileChooser.getSelectedFile().getAbsolutePath();
            this.mLibraryFileNameTextField.setText(selectedLibFile);
        }
    }

    private void signButton_actionPerformed() {
        this.mResult = true;
        this.setVisible(false);
    }

    private void cancelButton_actionPerformed() {
        this.mResult = false;
        this.setVisible(false);
    }

    private String getConfigFileName() {
        String configFileName = System.getProperty("user.home") + System.getProperty("file.separator") + CONFIG_FILE_NAME;
        return configFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettings() throws IOException {
        String configFileName = this.getConfigFileName();
        FileInputStream configFileStream = new FileInputStream(configFileName);
        try {
            Properties configProps = new Properties();
            configProps.load(configFileStream);
            String lastLibraryFileName = configProps.getProperty(PKCS11_LIBRARY_FILE_NAME_KEY);
            if (lastLibraryFileName != null) {
                this.mLibraryFileNameTextField.setText(lastLibraryFileName);
            } else {
                this.mLibraryFileNameTextField.setText("");
            }
        }
        finally {
            configFileStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSettings() throws IOException {
        Properties configProps = new Properties();
        String currentLibraryFileName = this.mLibraryFileNameTextField.getText();
        configProps.setProperty(PKCS11_LIBRARY_FILE_NAME_KEY, currentLibraryFileName);
        String configFileName = this.getConfigFileName();
        FileOutputStream configFileStream = new FileOutputStream(configFileName);
        try {
            configProps.store(configFileStream, "");
        }
        finally {
            configFileStream.close();
        }
    }

    public String getLibraryFileName() {
        String libraryFileName = this.mLibraryFileNameTextField.getText();
        return libraryFileName;
    }

    public String getSmartCardPINCode() {
        String pinCode = this.mPINCodeTextField.getText();
        return pinCode;
    }

    public boolean run() {
        try {
            this.loadSettings();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setModal(true);
        this.setVisible(true);
        try {
            if (this.mResult) {
                this.saveSettings();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.mResult;
    }

    private static class LibraryFileFilter
    extends FileFilter {
        private LibraryFileFilter() {
        }

        @Override
        public boolean accept(File aFile) {
            if (aFile.isDirectory()) {
                return true;
            }
            String fileName = aFile.getName().toLowerCase();
            boolean accepted = fileName.endsWith(".dll") || fileName.endsWith(".so");
            return accepted;
        }

        @Override
        public String getDescription() {
            return "PKCS#11 v2.0 ot later implementation library (.dll, .so)";
        }
    }
}

