/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.proto;

import it.tnx.commons.SwingUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jdesktop.jxlayer_old.JXLayer;
import org.jdesktop.jxlayer_old.plaf.ext.LockableUI;
import org.jdesktop.swingx.painter.BusyPainter;

public class LockableBusyPainterUI
extends LockableUI
implements ActionListener {
    private BusyPainter busyPainter = new BusyPainter(){

        protected void doPaint(Graphics2D g, Object t, int width, int height) {
            Rectangle r = new Rectangle(((JComponent)t).getSize().width, ((JComponent)t).getSize().height);
            g.setColor(new Color(100, 100, 100, 50));
            g.fill(r);
            super.doPaint(g, t, width, height);
        }
    };
    private Timer timer;
    private int frameNumber;

    public LockableBusyPainterUI() {
        this.busyPainter.setPaintCentered(true);
        this.busyPainter.setPointShape((Shape)new Ellipse2D.Float(0.0f, 0.0f, 8.0f, 8.0f));
        this.busyPainter.setTrajectory((Shape)new Ellipse2D.Float(0.0f, 0.0f, 26.0f, 26.0f));
        this.timer = new Timer(75, this);
    }

    @Override
    protected void paintLayer(Graphics2D g2, JXLayer<? extends JComponent> l) {
        try {
            super.paintLayer(g2, l);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isLocked()) {
            this.busyPainter.paint(g2, l, l.getWidth(), l.getHeight());
        }
    }

    @Override
    public void setLocked(boolean isLocked) {
        super.setLocked(isLocked);
        if (isLocked) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SwingUtils.inEdt((Runnable)new Runnable(){

            @Override
            public void run() {
                LockableBusyPainterUI.this.frameNumber = (LockableBusyPainterUI.this.frameNumber + 1) % 8;
                LockableBusyPainterUI.this.busyPainter.setFrame(LockableBusyPainterUI.this.frameNumber);
                LockableBusyPainterUI.this.setDirty(true);
            }
        });
    }
}

