/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.proto;

import com.jhlabs.image.GaussianFilter;
import it.tnx.commons.SwingUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.Timer;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.jdesktop.jxlayer_old.JXLayer;
import org.jdesktop.jxlayer_old.plaf.ext.LockableUI;
import org.jdesktop.swingx.painter.BusyPainter;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.ease.Linear;

public class LockableCircularBusyPainterUI
extends LockableUI
implements ActionListener {
    private BusyPainter busyPainter;
    private Timer timer;
    private int frameNumber;
    private static final int ROTATION_ANIMATOR_DURATION = 4000;
    private static final int SWEEP_ANIMATOR_DURATION = 1200;
    private static final int END_ANIMATOR_DURATION = 400;
    private Rectangle fBounds = new Rectangle(10, 10, 50, 50);
    private Timeline mRotationAnimator;
    private Timeline mSweepAppearingAnimator;
    private Timeline mSweepDisappearingAnimator;
    private boolean mModeAppearing;
    private boolean mRunning;
    private int mCurrentColor;
    private int mCurrentIndexColor = 0;
    private float mCurrentSweepAngle;
    private float mCurrentRotationAngleOffset = 0.0f;
    private float mCurrentRotationAngle = 0.0f;
    private float mCurrentEndRatio = 1.0f;
    private float mBorderWidth = 4.0f;
    private int[] mColors;
    private float mSweepSpeed = 1.0f;
    private float mRotationSpeed = 1.0f;
    private int mMinSweepAngle = 10;
    private int mMaxSweepAngle = 330;
    private boolean mFirstSweepAnimation;
    private Integer angleInterpolator = 0;
    private Integer sweepAppearingInterpolator = 0;
    private Integer sweepDisappearingInterpolator = 0;
    private boolean primorender;
    private JXLayer layer = null;
    BufferedImage bImage = null;
    GaussianFilter gf = null;
    Boolean aggiuntoListenerPerStop = false;

    private void setCurrentRotationAngle(float angle) {
        this.mCurrentRotationAngle = angle;
    }

    public void setCurrentSweepAngle(float currentSweepAngle) {
        this.mCurrentSweepAngle = currentSweepAngle;
    }

    public float getCurrentSweepAngle() {
        return this.mCurrentSweepAngle;
    }

    private void setDisappearing() {
        this.mModeAppearing = false;
        this.mCurrentRotationAngleOffset += (float)(360 - this.mMaxSweepAngle);
    }

    private void setAppearing() {
        this.mModeAppearing = true;
        this.mCurrentRotationAngleOffset += (float)this.mMinSweepAngle;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void stop() {
        try {
            this.mRotationAnimator.abort();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.mSweepAppearingAnimator.abort();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.mSweepDisappearingAnimator.abort();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupAnimations() {
        this.mRotationAnimator = new Timeline(this);
        this.mRotationAnimator.addPropertyToInterpolate("angleInterpolator", 0, 360);
        this.mRotationAnimator.setDuration((long)(4000.0f / this.mRotationSpeed));
        this.mRotationAnimator.setEase(new Linear());
        this.mRotationAnimator.setDuration(1200L);
        this.mRotationAnimator.addCallback(new TimelineCallback(){

            @Override
            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
            }

            @Override
            public void onTimelinePulse(float durationFraction, float timelinePosition) {
                float angle = durationFraction * 360.0f;
                LockableCircularBusyPainterUI.this.setCurrentRotationAngle(angle);
            }
        });
        this.mRotationAnimator.playLoop(Timeline.RepeatBehavior.LOOP);
        this.mSweepAppearingAnimator = new Timeline(this);
        this.mSweepAppearingAnimator.addPropertyToInterpolate("sweepAppearingInterpolator", this.mMinSweepAngle, this.mMaxSweepAngle);
        this.mSweepAppearingAnimator.setDuration((long)(1200.0f / this.mSweepSpeed));
        this.mSweepAppearingAnimator.addCallback(new TimelineCallback(){

            @Override
            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                if (oldState == Timeline.TimelineState.PLAYING_FORWARD && newState == Timeline.TimelineState.DONE) {
                    LockableCircularBusyPainterUI.this.mFirstSweepAnimation = false;
                    LockableCircularBusyPainterUI.this.setDisappearing();
                    LockableCircularBusyPainterUI.this.mSweepDisappearingAnimator.play();
                }
            }

            @Override
            public void onTimelinePulse(float durationFraction, float timelinePosition) {
                float animatedFraction = durationFraction;
                float angle = LockableCircularBusyPainterUI.this.mFirstSweepAnimation ? animatedFraction * (float)LockableCircularBusyPainterUI.this.mMaxSweepAngle : (float)LockableCircularBusyPainterUI.this.mMinSweepAngle + animatedFraction * (float)(LockableCircularBusyPainterUI.this.mMaxSweepAngle - LockableCircularBusyPainterUI.this.mMinSweepAngle);
                LockableCircularBusyPainterUI.this.setCurrentSweepAngle(angle);
            }
        });
        this.mModeAppearing = true;
        this.mSweepAppearingAnimator.play();
        this.mSweepDisappearingAnimator = new Timeline(this);
        this.mSweepDisappearingAnimator.addPropertyToInterpolate("sweepDisappearingInterpolator", this.mMinSweepAngle, this.mMaxSweepAngle);
        this.mSweepDisappearingAnimator.setDuration((long)(1200.0f / this.mSweepSpeed));
        this.mSweepDisappearingAnimator.addCallback(new TimelineCallback(){

            @Override
            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                if (oldState == Timeline.TimelineState.PLAYING_FORWARD && newState == Timeline.TimelineState.DONE) {
                    LockableCircularBusyPainterUI.this.setAppearing();
                    LockableCircularBusyPainterUI.this.mSweepAppearingAnimator.play();
                }
            }

            @Override
            public void onTimelinePulse(float durationFraction, float timelinePosition) {
                float animatedFraction = durationFraction;
                LockableCircularBusyPainterUI.this.setCurrentSweepAngle((float)LockableCircularBusyPainterUI.this.mMaxSweepAngle - animatedFraction * (float)(LockableCircularBusyPainterUI.this.mMaxSweepAngle - LockableCircularBusyPainterUI.this.mMinSweepAngle));
            }
        });
    }

    public Integer getAngleInterpolator() {
        return this.angleInterpolator;
    }

    public void setAngleInterpolator(Integer angleInterpolator) {
        this.angleInterpolator = angleInterpolator;
    }

    public Integer getSweepAppearingInterpolator() {
        return this.sweepAppearingInterpolator;
    }

    public void setSweepAppearingInterpolator(Integer sweepAppearingInterpolator) {
        this.sweepAppearingInterpolator = sweepAppearingInterpolator;
    }

    public Integer getSweepDisappearingInterpolator() {
        return this.sweepDisappearingInterpolator;
    }

    public void setSweepDisappearingInterpolator(Integer sweepDisappearingInterpolator) {
        this.sweepDisappearingInterpolator = sweepDisappearingInterpolator;
    }

    public LockableCircularBusyPainterUI() {
        this.setupAnimations();
        this.timer = new Timer(16, this);
    }

    @Override
    protected void paintLayer(Graphics2D g2, JXLayer<? extends JComponent> l) {
        try {
            super.paintLayer(g2, l);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l != null && !this.aggiuntoListenerPerStop.booleanValue()) {
            this.aggiuntoListenerPerStop = true;
            if (SwingUtils.getParentJInternalFrame(l) instanceof JInternalFrame) {
                SwingUtils.getParentJInternalFrame(l).addInternalFrameListener(new InternalFrameAdapter(){

                    @Override
                    public void internalFrameClosed(InternalFrameEvent e) {
                        super.internalFrameClosed(e);
                        LockableCircularBusyPainterUI.this.stop();
                    }
                });
            }
        }
        if (this.isLocked()) {
            this.fBounds = new Rectangle(l.getWidth() / 2 - 25, l.getHeight() / 2 - 25, 50, 50);
            Rectangle r = new Rectangle(this.getLayer().getSize().width, this.getLayer().getSize().height);
            g2.setColor(new Color(255, 255, 255, 150));
            g2.fill(r);
            float startAngle = this.mCurrentRotationAngle - this.mCurrentRotationAngleOffset;
            float sweepAngle = this.mCurrentSweepAngle;
            if (!this.mModeAppearing) {
                startAngle += 360.0f - sweepAngle;
            }
            startAngle %= 360.0f;
            if (this.mCurrentEndRatio < 1.0f) {
                float newSweepAngle = sweepAngle * this.mCurrentEndRatio;
                startAngle = (startAngle + (sweepAngle - newSweepAngle)) % 360.0f;
                sweepAngle = newSweepAngle;
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2.setColor(new Color(67, 135, 239));
            g2.setStroke(new BasicStroke(6.0f, 1, 1));
            g2.drawArc(this.fBounds.x, this.fBounds.y, this.fBounds.width, this.fBounds.height, (int)startAngle, (int)sweepAngle);
        }
    }

    @Override
    public void setLocked(boolean isLocked) {
        super.setLocked(isLocked);
        if (isLocked) {
            this.timer.start();
            this.mRotationAnimator.resume();
            this.mSweepAppearingAnimator.resume();
            this.mSweepDisappearingAnimator.resume();
        } else {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.mRotationAnimator.suspend();
            this.mSweepAppearingAnimator.suspend();
            this.mSweepDisappearingAnimator.suspend();
            this.bImage = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setDirty(true);
    }
}

