/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip;

import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.CustomBalloonTip;
import net.java.balloontip.positioners.BalloonTipPositioner;
import net.java.balloontip.styles.BalloonTipStyle;

public class TreeNodeBalloonTip
extends CustomBalloonTip {
    protected TreePath path;
    private TreeExpansionListener expansionListener = new TreeExpansionListener(){

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            if (TreeNodeBalloonTip.this.getTree().isVisible(TreeNodeBalloonTip.this.path)) {
                TreeNodeBalloonTip.this.visibilityControl.setCriterionAndUpdate("treeExpansion", true);
            }
            TreeNodeBalloonTip.this.setTreePath(TreeNodeBalloonTip.this.path);
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
            if (!TreeNodeBalloonTip.this.getTree().isVisible(TreeNodeBalloonTip.this.path)) {
                TreeNodeBalloonTip.this.visibilityControl.setCriterionAndUpdate("treeExpansion", false);
            } else {
                TreeNodeBalloonTip.this.setTreePath(TreeNodeBalloonTip.this.path);
            }
        }
    };
    private TreeModelListener modelListener = new TreeModelListener(){

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            TreeNodeBalloonTip.this.setTreePath(TreeNodeBalloonTip.this.path);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            boolean closeBalloon = false;
            for (Object child : e.getChildren()) {
                if (!e.getTreePath().pathByAddingChild(child).isDescendant(TreeNodeBalloonTip.this.path)) continue;
                closeBalloon = true;
            }
            if (closeBalloon) {
                TreeNodeBalloonTip.this.closeBalloon();
            } else {
                TreeNodeBalloonTip.this.setTreePath(TreeNodeBalloonTip.this.path);
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            TreeNodeBalloonTip.this.setTreePath(TreeNodeBalloonTip.this.path);
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            TreeNodeBalloonTip.this.setTreePath(TreeNodeBalloonTip.this.path);
        }
    };
    private static final long serialVersionUID = -7270789090236631717L;

    public TreeNodeBalloonTip(JTree tree, JComponent component, TreePath path, BalloonTipStyle style, BalloonTip.Orientation alignment, BalloonTip.AttachLocation attachLocation, int horizontalOffset, int verticalOffset, boolean useCloseButton) {
        super(tree, component, tree.getPathBounds(path), style, alignment, attachLocation, horizontalOffset, verticalOffset, useCloseButton);
        this.setup(path);
    }

    public TreeNodeBalloonTip(JTree tree, JComponent component, TreePath path, BalloonTipStyle style, BalloonTipPositioner positioner, JButton closeButton) {
        super(tree, component, tree.getPathBounds(path), style, positioner, closeButton);
        this.setup(path);
    }

    public void setTreePath(TreePath path) {
        this.path = path;
        Rectangle bounds = this.getTree().getPathBounds(path);
        if (bounds != null) {
            this.setOffset(bounds);
        }
    }

    @Override
    public void closeBalloon() {
        JTree tree = this.getTree();
        tree.removeTreeExpansionListener(this.expansionListener);
        tree.getModel().removeTreeModelListener(this.modelListener);
        super.closeBalloon();
    }

    private void setup(TreePath path) {
        this.path = path;
        if (!this.getTree().isVisible(path)) {
            this.visibilityControl.setCriterionAndUpdate("treePath", false);
        }
        JTree tree = this.getTree();
        tree.addTreeExpansionListener(this.expansionListener);
        tree.getModel().addTreeModelListener(this.modelListener);
    }

    private JTree getTree() {
        return (JTree)this.attachedComponent;
    }
}

