/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.styles;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import net.java.balloontip.styles.BalloonTipStyle;

public class IsometricBalloonStyle
extends BalloonTipStyle {
    private final Color sideColor;
    private final Color frontColor;
    private int depth;

    public IsometricBalloonStyle(Color frontColor, Color sideColor, int depth) {
        this.sideColor = sideColor;
        this.frontColor = frontColor;
        this.depth = depth;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (this.flipY) {
            return new Insets(this.verticalOffset + this.depth + 1, 1, 1, this.depth + 1);
        }
        return new Insets(this.depth + 1, 1, this.verticalOffset + 1, this.depth + 1);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        GeneralPath tipSide;
        int yBottom;
        int yTop;
        Graphics2D g2d = (Graphics2D)g;
        width -= this.depth + 1;
        --height;
        if (this.flipY) {
            yTop = y + this.verticalOffset + this.depth;
            yBottom = y + height;
        } else {
            yTop = y + this.depth;
            yBottom = y + height - this.verticalOffset;
        }
        GeneralPath top = new GeneralPath();
        top.moveTo(x, yTop);
        top.lineTo(width, yTop);
        top.lineTo(width + this.depth, yTop - this.depth);
        top.lineTo(x + this.depth, yTop - this.depth);
        top.closePath();
        g2d.setPaint(this.sideColor);
        g2d.fill(top);
        GeneralPath side = new GeneralPath();
        side.moveTo(width, yTop);
        side.lineTo(width + this.depth, yTop - this.depth);
        side.lineTo(width + this.depth, yBottom - this.depth);
        side.lineTo(width, yBottom);
        side.closePath();
        g2d.setPaint(this.sideColor.darker());
        g2d.fill(side);
        if (this.flipX && !this.flipY) {
            tipSide = new GeneralPath();
            tipSide.moveTo(x + width - this.horizontalOffset, yBottom);
            tipSide.lineTo(x + width - this.horizontalOffset + this.depth, yBottom);
            tipSide.lineTo(x + width - this.horizontalOffset + this.depth, yBottom + this.verticalOffset - this.depth);
            tipSide.lineTo(x + width - this.horizontalOffset, yBottom + this.verticalOffset);
            tipSide.closePath();
            g2d.setPaint(this.sideColor.darker());
            g2d.fill(tipSide);
        } else if (!this.flipX && this.flipY) {
            tipSide = new GeneralPath();
            tipSide.moveTo(x + this.horizontalOffset, yTop - this.verticalOffset);
            tipSide.lineTo(x + this.horizontalOffset + this.depth, yTop - this.verticalOffset - this.depth);
            tipSide.lineTo(x + this.horizontalOffset + this.verticalOffset + this.depth, yTop - this.depth);
            tipSide.lineTo(x + this.horizontalOffset + this.verticalOffset, yTop);
            tipSide.closePath();
            g2d.setPaint(this.sideColor.darker());
            g2d.fill(tipSide);
        } else if (this.flipX && this.flipY) {
            tipSide = new GeneralPath();
            tipSide.moveTo(x + width - this.horizontalOffset, yTop);
            tipSide.lineTo(x + width - this.horizontalOffset + this.depth, yTop - this.depth);
            tipSide.lineTo(x + width - this.horizontalOffset + this.depth, yTop - this.depth - this.verticalOffset);
            tipSide.lineTo(x + width - this.horizontalOffset, yTop - this.verticalOffset);
            tipSide.closePath();
            g2d.setPaint(this.sideColor.darker());
            g2d.fill(tipSide);
        }
        GeneralPath front = new GeneralPath();
        front.moveTo(x, yTop);
        front.lineTo(x, yBottom);
        if (!this.flipX && !this.flipY) {
            front.lineTo(x + this.horizontalOffset, yBottom);
            front.lineTo(x + this.horizontalOffset, yBottom + this.verticalOffset);
            front.lineTo(x + this.horizontalOffset + this.verticalOffset, yBottom);
        } else if (this.flipX && !this.flipY) {
            front.lineTo(x + width - this.horizontalOffset - this.verticalOffset, yBottom);
            front.lineTo(x + width - this.horizontalOffset, yBottom + this.verticalOffset);
            front.lineTo(x + width - this.horizontalOffset, yBottom);
        }
        front.lineTo(x + width, yBottom);
        front.lineTo(x + width, yTop);
        if (!this.flipX && this.flipY) {
            front.lineTo(x + this.horizontalOffset + this.verticalOffset, yTop);
            front.lineTo(x + this.horizontalOffset, yTop - this.verticalOffset);
            front.lineTo(x + this.horizontalOffset, yTop);
        } else if (this.flipX && this.flipY) {
            front.lineTo(x + width - this.horizontalOffset, yTop);
            front.lineTo(x + width - this.horizontalOffset, yTop - this.verticalOffset);
            front.lineTo(x + width - this.horizontalOffset - this.verticalOffset, yTop);
        }
        front.closePath();
        g2d.setPaint(this.frontColor);
        g2d.fill(front);
    }
}

