/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.styles;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import net.java.balloontip.styles.BalloonTipStyle;

public class ModernBalloonStyle
extends BalloonTipStyle {
    private final int arcWidth;
    private final int arcHeight;
    private boolean topLeft = true;
    private boolean topRight = false;
    private boolean bottomLeft = false;
    private boolean bottomRight = true;
    private int borderThickness = 1;
    private boolean AAenabled = false;
    private final Color topFillColor;
    private final Color bottomFillColor;
    private final Color borderColor;

    public ModernBalloonStyle(int arcWidth, int arcHeight, Color topFillColor, Color bottomFillColor, Color borderColor) {
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.topFillColor = topFillColor;
        this.bottomFillColor = bottomFillColor;
        this.borderColor = borderColor;
    }

    public void setCornerStyles(boolean topLeft, boolean topRight, boolean bottomLeft, boolean bottomRight) {
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomLeft = bottomLeft;
        this.bottomRight = bottomRight;
    }

    public void setBorderThickness(int thickness) {
        this.borderThickness = thickness;
    }

    public void enableAntiAliasing(boolean enable) {
        this.AAenabled = enable;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (this.flipY) {
            return new Insets(this.verticalOffset + this.arcHeight, this.arcWidth, this.arcHeight, this.arcWidth);
        }
        return new Insets(this.arcHeight, this.arcWidth, this.arcHeight + this.verticalOffset, this.arcWidth);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int yBottom;
        int yTop;
        Graphics2D g2d = (Graphics2D)g;
        if (this.AAenabled) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        x += this.borderThickness - 1;
        y += this.borderThickness - 1;
        width -= this.borderThickness * 2;
        height -= this.borderThickness * 2;
        if (this.flipY) {
            yTop = y + this.verticalOffset;
            yBottom = y + height;
        } else {
            yTop = y;
            yBottom = y + height - this.verticalOffset;
        }
        GeneralPath outline = new GeneralPath();
        outline.moveTo(x + this.arcWidth, yTop);
        if (this.topLeft) {
            outline.quadTo(x, yTop, x, yTop + this.arcHeight);
        } else {
            outline.lineTo(x, yTop);
            outline.lineTo(x, yTop + this.arcHeight);
        }
        outline.lineTo(x, yBottom - this.arcHeight);
        if (this.bottomLeft) {
            outline.quadTo(x, yBottom, x + this.arcWidth, yBottom);
        } else {
            outline.lineTo(x, yBottom);
            outline.lineTo(x + this.arcWidth, yBottom);
        }
        if (!this.flipX && !this.flipY) {
            outline.lineTo(x + this.horizontalOffset, yBottom);
            outline.lineTo(x + this.horizontalOffset, yBottom + this.verticalOffset);
            outline.lineTo(x + this.horizontalOffset + this.verticalOffset, yBottom);
        } else if (this.flipX && !this.flipY) {
            outline.lineTo(x + width - this.horizontalOffset - this.verticalOffset, yBottom);
            outline.lineTo(x + width - this.horizontalOffset, yBottom + this.verticalOffset);
            outline.lineTo(x + width - this.horizontalOffset, yBottom);
        }
        outline.lineTo(x + width - this.arcWidth, yBottom);
        if (this.bottomRight) {
            outline.quadTo(x + width, yBottom, x + width, yBottom - this.arcHeight);
        } else {
            outline.lineTo(x + width, yBottom);
            outline.lineTo(x + width, yBottom - this.arcHeight);
        }
        outline.lineTo(x + width, yTop + this.arcHeight);
        if (this.topRight) {
            outline.quadTo(x + width, yTop, x + width - this.arcWidth, yTop);
        } else {
            outline.lineTo(x + width, yTop);
            outline.lineTo(x + width - this.arcWidth, yTop);
        }
        if (!this.flipX && this.flipY) {
            outline.lineTo(x + this.horizontalOffset + this.verticalOffset, yTop);
            outline.lineTo(x + this.horizontalOffset, yTop - this.verticalOffset);
            outline.lineTo(x + this.horizontalOffset, yTop);
        } else if (this.flipX && this.flipY) {
            outline.lineTo(x + width - this.horizontalOffset, yTop);
            outline.lineTo(x + width - this.horizontalOffset, yTop - this.verticalOffset);
            outline.lineTo(x + width - this.horizontalOffset - this.verticalOffset, yTop);
        }
        outline.closePath();
        g2d.setPaint(new GradientPaint(0.0f, yTop, this.topFillColor, 0.0f, yBottom, this.bottomFillColor));
        g2d.fill(outline);
        g2d.setPaint(this.borderColor);
        Stroke backup = g2d.getStroke();
        g2d.setStroke(new BasicStroke(this.borderThickness));
        g2d.draw(outline);
        g2d.setStroke(backup);
    }

    @Override
    public int getMinimalHorizontalOffset() {
        return this.arcWidth + this.verticalOffset + this.borderThickness;
    }
}

