/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import javax.swing.Timer;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.CustomBalloonTip;

public final class ToolTipUtils {
    private ToolTipUtils() {
    }

    public static void balloonToToolTip(BalloonTip bT, int initialDelay, int showDelay) {
        bT.setVisible(false);
        ToolTipController tTC = new ToolTipController(bT, initialDelay, showDelay);
        bT.getAttachedComponent().addMouseListener(tTC);
        bT.getAttachedComponent().addMouseMotionListener(tTC);
    }

    public static void toolTipToBalloon(BalloonTip bT) {
        for (MouseListener mouseListener : bT.getAttachedComponent().getMouseListeners()) {
            if (!(mouseListener instanceof ToolTipController)) continue;
            bT.getAttachedComponent().removeMouseListener(mouseListener);
            ((ToolTipController)mouseListener).stopTimers();
            break;
        }
        for (EventListener eventListener : bT.getAttachedComponent().getMouseMotionListeners()) {
            if (!(eventListener instanceof ToolTipController)) continue;
            bT.getAttachedComponent().removeMouseMotionListener((MouseMotionListener)eventListener);
            break;
        }
        bT.setVisible(true);
    }

    private static class ToolTipController
    extends MouseAdapter
    implements MouseMotionListener {
        private final BalloonTip balloonTip;
        private final Timer initialTimer;
        private final Timer showTimer;

        public ToolTipController(final BalloonTip balloonTip, int initialDelay, int showDelay) {
            this.balloonTip = balloonTip;
            this.initialTimer = new Timer(initialDelay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    balloonTip.setVisible(true);
                    ToolTipController.this.showTimer.start();
                }
            });
            this.initialTimer.setRepeats(false);
            this.showTimer = new Timer(showDelay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    balloonTip.setVisible(false);
                }
            });
            this.showTimer.setRepeats(false);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.initialTimer.start();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.balloonTip instanceof CustomBalloonTip) {
                if (((CustomBalloonTip)this.balloonTip).getOffset().contains(e.getPoint())) {
                    if (!this.balloonTip.isVisible() && !this.initialTimer.isRunning()) {
                        this.initialTimer.start();
                    }
                } else {
                    this.stopTimers();
                    this.balloonTip.setVisible(false);
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.stopTimers();
            this.balloonTip.setVisible(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.stopTimers();
            this.balloonTip.setVisible(false);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        private void stopTimers() {
            this.initialTimer.stop();
            this.showTimer.stop();
        }
    }
}

