/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer_old.demo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.geom.Ellipse2D;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.jxlayer_old.JXLayer;
import org.jdesktop.jxlayer_old.demo.util.LafMenu;
import org.jdesktop.jxlayer_old.plaf.ext.SpotLightUI;

public class SpotLightDemo
extends JFrame {
    private SpotLightUI spotLightUI = new SpotLightUI(15);
    private Ellipse2D shape;

    public SpotLightDemo() {
        super("SpotLight effect demo");
        this.setDefaultCloseOperation(3);
        JXLayer<JComponent> layer = new JXLayer<JComponent>(this.createDemoPanel(4, 5), this.spotLightUI);
        JScrollPane pane = new JScrollPane(layer);
        this.add(pane);
        this.shape = new Ellipse2D.Double(20.0, 20.0, 120.0, 120.0);
        this.spotLightUI.addShape(this.shape);
        this.add((Component)this.createToolPanel(), "South");
        this.setSize(400, 300);
        this.setLocationRelativeTo(null);
        this.setJMenuBar(LafMenu.createMenuBar());
    }

    private JComponent createDemoPanel(int w, int h) {
        JPanel panel = new JPanel(new GridLayout(w, h));
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                JButton button = new JButton("Hello");
                button.setFocusable(false);
                panel.add(button);
            }
        }
        panel.setPreferredSize(new Dimension(500, 400));
        return panel;
    }

    private JComponent createToolPanel() {
        JPanel panel = new JPanel();
        final JSpinner xspinner = new JSpinner(new SpinnerNumberModel((int)this.shape.getX(), 0, 400, 5));
        final JSpinner yspinner = new JSpinner(new SpinnerNumberModel((int)this.shape.getY(), 0, 400, 5));
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpotLightDemo.this.spotLightUI.reset();
                SpotLightDemo.this.shape.setFrame(((Integer)xspinner.getValue()).intValue(), ((Integer)yspinner.getValue()).intValue(), SpotLightDemo.this.shape.getWidth(), SpotLightDemo.this.shape.getHeight());
                SpotLightDemo.this.spotLightUI.addShape(SpotLightDemo.this.shape);
            }
        };
        xspinner.addChangeListener(listener);
        yspinner.addChangeListener(listener);
        panel.add(new JLabel("X:"));
        panel.add(xspinner);
        panel.add(new JLabel(" Y:"));
        panel.add(yspinner);
        final JSpinner clipSpinner = new JSpinner(new SpinnerNumberModel(15, 0, 100, 1));
        clipSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpotLightDemo.this.spotLightUI.setSoftClipWidth((Integer)clipSpinner.getValue());
            }
        });
        panel.add(new JLabel(" Border size:"));
        panel.add(clipSpinner);
        return panel;
    }

    public static void main(String[] args) throws Exception {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SpotLightDemo().setVisible(true);
            }
        });
    }
}

