/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer_old.plaf.ext;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jdesktop.jxlayer_old.JXLayer;
import org.jdesktop.jxlayer_old.plaf.AbstractLayerUI;

public class ButtonPanelUI
extends AbstractLayerUI<JComponent> {
    private boolean isFocusCyclic;

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setFocusTraversalPolicyProvider(true);
        c.setFocusTraversalPolicy(new ButtonPanelFocusTraversalPolicy());
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.setFocusTraversalPolicyProvider(false);
        c.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
    }

    public ButtonPanelUI() {
        this(false);
    }

    public ButtonPanelUI(boolean cyclic) {
        this.isFocusCyclic = cyclic;
    }

    public boolean isFocusCyclic() {
        return this.isFocusCyclic;
    }

    public void setFocusCyclic(boolean isFocusCyclic) {
        this.isFocusCyclic = isFocusCyclic;
    }

    private ButtonGroup getButtonGroup(AbstractButton button) {
        ButtonModel model = button.getModel();
        if (model instanceof DefaultButtonModel) {
            return ((DefaultButtonModel)model).getGroup();
        }
        return null;
    }

    @Override
    protected void processKeyEvent(KeyEvent e, JXLayer<? extends JComponent> l) {
        super.processKeyEvent(e, l);
        if (e.getID() == 401) {
            switch (e.getKeyCode()) {
                case 39: 
                case 40: {
                    this.moveFocus(true, l);
                    break;
                }
                case 37: 
                case 38: {
                    this.moveFocus(false, l);
                }
            }
        }
    }

    private void moveFocus(boolean isForward, JXLayer<? extends JComponent> l) {
        Component fo = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        ButtonPanelFocusTraversalPolicy bftp = (ButtonPanelFocusTraversalPolicy)l.getFocusTraversalPolicy();
        if (fo instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)fo;
            bftp.setAlternativeFocusMode(true);
            Component next = isForward ? bftp.getComponentAfter(l, fo) : bftp.getComponentBefore(l, fo);
            bftp.setAlternativeFocusMode(false);
            b.getModel().setPressed(false);
            if (next instanceof AbstractButton) {
                AbstractButton nextButton;
                ButtonGroup group = this.getButtonGroup((AbstractButton)fo);
                if (group != this.getButtonGroup(nextButton = (AbstractButton)next)) {
                    return;
                }
                if (group != null && group.getSelection() != null && !nextButton.isSelected()) {
                    nextButton.setSelected(true);
                }
                next.requestFocusInWindow();
            }
        }
    }

    private class ButtonPanelFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private boolean isAlternativeFocusMode;

        private ButtonPanelFocusTraversalPolicy() {
        }

        public boolean isAlternativeFocusMode() {
            return this.isAlternativeFocusMode;
        }

        public void setAlternativeFocusMode(boolean alternativeFocusMode) {
            this.isAlternativeFocusMode = alternativeFocusMode;
        }

        @Override
        protected boolean accept(Component c) {
            AbstractButton button;
            ButtonGroup group;
            if (!this.isAlternativeFocusMode() && c instanceof AbstractButton && (group = ButtonPanelUI.this.getButtonGroup(button = (AbstractButton)c)) != null && group.getSelection() != null && !button.isSelected()) {
                return false;
            }
            return super.accept(c);
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            Component componentAfter = super.getComponentAfter(aContainer, aComponent);
            if (!this.isAlternativeFocusMode()) {
                return componentAfter;
            }
            if (ButtonPanelUI.this.isFocusCyclic()) {
                return componentAfter == null ? this.getFirstComponent(aContainer) : componentAfter;
            }
            if (aComponent == this.getLastComponent(aContainer)) {
                return aComponent;
            }
            return componentAfter;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            Component componentBefore = super.getComponentBefore(aContainer, aComponent);
            if (!this.isAlternativeFocusMode()) {
                return componentBefore;
            }
            if (ButtonPanelUI.this.isFocusCyclic()) {
                return componentBefore == null ? this.getLastComponent(aContainer) : componentBefore;
            }
            if (aComponent == this.getFirstComponent(aContainer)) {
                return aComponent;
            }
            return componentBefore;
        }
    }
}

