/*
 * Decompiled with CFR 0.152.
 */
package org.jibble.logtailer;

import java.awt.Color;
import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class HighlightRule
implements Serializable {
    private String _name;
    private String _regexp;
    private Pattern _pattern;
    private boolean _underlined;
    private boolean _bold;
    private boolean _filtered;
    private boolean _beep;
    private Color _color = null;

    public HighlightRule() {
        this("Default", "^.*$", false, false, false, false, Color.black);
    }

    public HighlightRule(String name, String regexp, boolean underlined, boolean bold, boolean filtered, boolean beep, Color color) throws PatternSyntaxException {
        this._name = name;
        this._regexp = regexp;
        this._pattern = Pattern.compile(regexp);
        this._underlined = underlined;
        this._bold = bold;
        this._beep = beep;
        this._filtered = filtered;
        this._color = color;
    }

    public void alterAttributeSet(SimpleAttributeSet attr) {
        StyleConstants.setForeground(attr, this._color);
        StyleConstants.setBold(attr, this._bold);
        StyleConstants.setUnderline(attr, this._underlined);
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this.getName();
    }

    public String getRegexp() {
        return this._regexp;
    }

    public Pattern getPattern() {
        return this._pattern;
    }

    public boolean getFiltered() {
        return this._filtered;
    }

    public boolean getBold() {
        return this._bold;
    }

    public boolean getUnderlined() {
        return this._underlined;
    }

    public boolean getBeep() {
        return this._beep;
    }

    public Color getColor() {
        return this._color;
    }
}

