/*
 * Decompiled with CFR 0.152.
 */
package org.jibble.logtailer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.jibble.logtailer.HighlightRule;
import org.jibble.logtailer.JLogTailerInternalFrame;

public class JLogTailerFrame
extends JFrame
implements Serializable {
    public static final File SETTINGS_FILE = new File(System.getProperties().getProperty("user.home"), "JLogTailer2.xml");
    private transient JDesktopPane _desktop = new JDesktopPane();
    private File _currentDir = null;

    public JLogTailerFrame(String title, int width, int height) {
        this.setTitle(title);
        this.setSize(width, height);
        this.setDefaultCloseOperation(2);
        Container pane = this.getContentPane();
        pane.add((Component)this._desktop, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        JMenu windowMenu = new JMenu("Window");
        menuBar.add(windowMenu);
        JMenu helpMenu = new JMenu("Help");
        menuBar.add(helpMenu);
        JMenuItem fileOpenItem = new JMenuItem("Open log");
        fileMenu.add(fileOpenItem);
        JMenuItem fileExitItem = new JMenuItem("Exit");
        fileMenu.add(fileExitItem);
        JMenuItem windowTileVerticallyItem = new JMenuItem("Tile vertically");
        windowMenu.add(windowTileVerticallyItem);
        JMenuItem windowTileBoxedItem = new JMenuItem("Tile boxed");
        windowMenu.add(windowTileBoxedItem);
        JMenuItem helpTipsItem = new JMenuItem("Tips");
        helpMenu.add(helpTipsItem);
        JMenuItem helpAboutItem = new JMenuItem("About");
        helpMenu.add(helpAboutItem);
        this.setJMenuBar(menuBar);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                JLogTailerFrame.this.exit();
            }
        });
        fileOpenItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser chooser = new JFileChooser(JLogTailerFrame.this._currentDir);
                int returnVal = chooser.showOpenDialog(JLogTailerFrame.this);
                if (returnVal == 0) {
                    File file = new File(chooser.getCurrentDirectory(), chooser.getSelectedFile().getName());
                    try {
                        JLogTailerFrame.this.startLogging(file, null, new Rectangle(600, 400));
                        JLogTailerFrame.this._currentDir = file.getParentFile();
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(JLogTailerFrame.this, file.toString() + " cannot be tail logged.", "Logging not started", 1);
                    }
                }
            }
        });
        fileExitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JLogTailerFrame.this.exit();
            }
        });
        windowTileVerticallyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JLogTailerFrame.this.tileInternalFramesVertically();
            }
        });
        windowTileBoxedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JLogTailerFrame.this.tileInternalFramesBoxed();
            }
        });
        helpAboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JOptionPane.showMessageDialog(JLogTailerFrame.this, "JLogTailer 2.0.0\nA Java log tailer by Paul Mutton\nhttp://www.jibble.org/", "About", 1);
            }
        });
        helpTipsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JOptionPane.showMessageDialog(JLogTailerFrame.this, "When you start JLogTailer, it will remember which files you were last looking at.\nLine highlighting rules are also remembered between sessions.\nCheck out the highlighting options to make certain lines coloured, bold, underlined, etc.\nAll configuration is saved in your home directory as JLogTailer2.xml\nRead the javadoc documentation for the Pattern class for help with regular expressions.\nDon't forget that you can order lists of multiple rules for any file.", "Tips", 1);
            }
        });
        this.readConfig();
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLogging(File file, ArrayList rules, Rectangle bounds) throws IOException {
        JLogTailerInternalFrame iFrame = new JLogTailerInternalFrame(this, file, bounds);
        if (rules != null) {
            ArrayList logRules;
            ArrayList arrayList = logRules = iFrame.getRules();
            synchronized (arrayList) {
                logRules.addAll(rules);
            }
        }
        this._desktop.add(iFrame);
        iFrame.moveToFront();
        Thread t = new Thread(iFrame);
        t.start();
    }

    private void readConfig() {
        try {
            System.out.println("Trying to read previous configuration...");
            XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(SETTINGS_FILE)));
            this.setBounds((Rectangle)decoder.readObject());
            int frameCount = (Integer)decoder.readObject();
            for (int i = 0; i < frameCount; ++i) {
                String path = (String)decoder.readObject();
                File file = new File(path);
                Rectangle bounds = (Rectangle)decoder.readObject();
                int ruleCount = (Integer)decoder.readObject();
                ArrayList<HighlightRule> rules = new ArrayList<HighlightRule>();
                for (int j = 0; j < ruleCount; ++j) {
                    String name = (String)decoder.readObject();
                    String regexp = (String)decoder.readObject();
                    boolean underlined = (Boolean)decoder.readObject();
                    boolean bold = (Boolean)decoder.readObject();
                    boolean filtered = (Boolean)decoder.readObject();
                    boolean beep = (Boolean)decoder.readObject();
                    Color color = (Color)decoder.readObject();
                    HighlightRule rule = new HighlightRule(name, regexp, underlined, bold, filtered, beep, color);
                    rules.add(rule);
                }
            }
            decoder.close();
        }
        catch (Exception e) {
            System.out.println("Could not find previous configuration: assuming defaults.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exit() {
        this.setVisible(false);
        try {
            XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(SETTINGS_FILE)));
            encoder.writeObject(this.getBounds());
            JInternalFrame[] frames = this._desktop.getAllFrames();
            int frameCount = frames.length;
            encoder.writeObject(new Integer(frameCount));
            for (int n = 0; n < frameCount; ++n) {
                ArrayList rules;
                JLogTailerInternalFrame frame = (JLogTailerInternalFrame)frames[n];
                encoder.writeObject(frame.getFile().getPath());
                encoder.writeObject(frame.getBounds());
                ArrayList arrayList = rules = frame.getRules();
                synchronized (arrayList) {
                    encoder.writeObject(new Integer(rules.size()));
                    for (int i = 0; i < rules.size(); ++i) {
                        HighlightRule rule = (HighlightRule)rules.get(i);
                        encoder.writeObject(rule.getName());
                        encoder.writeObject(rule.getRegexp());
                        encoder.writeObject(new Boolean(rule.getUnderlined()));
                        encoder.writeObject(new Boolean(rule.getBold()));
                        encoder.writeObject(new Boolean(rule.getFiltered()));
                        encoder.writeObject(new Boolean(rule.getBeep()));
                        encoder.writeObject(rule.getColor());
                    }
                    continue;
                }
            }
            encoder.flush();
            encoder.close();
            System.out.println("Configuration saved.");
        }
        catch (Exception e) {
            System.out.println("Unable to save configuration for next use: " + e);
        }
    }

    private void tileInternalFramesVertically() {
        int desktopWidth = this._desktop.getWidth();
        int desktopHeight = this._desktop.getHeight();
        JInternalFrame[] frames = this._desktop.getAllFrames();
        int frameCount = frames.length;
        for (int n = 0; n < frameCount; ++n) {
            JInternalFrame frame = frames[n];
            try {
                frame.setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            frame.reshape(0, n * desktopHeight / frameCount, desktopWidth, desktopHeight / frameCount);
            frame.setVisible(true);
            frame.toFront();
        }
    }

    private void tileInternalFramesBoxed() {
        int desktopWidth = this._desktop.getWidth();
        int desktopHeight = this._desktop.getHeight();
        JInternalFrame[] frames = this._desktop.getAllFrames();
        int frameCount = frames.length;
        int totalRows = (int)Math.sqrt(frameCount);
        int totalCols = 1;
        while (totalCols * totalRows < frameCount) {
            ++totalCols;
        }
        int windowsDrawn = 0;
        for (int row = 0; row < totalRows; ++row) {
            for (int col = 0; col < totalCols && windowsDrawn != frameCount; ++windowsDrawn, ++col) {
                JInternalFrame frame = frames[row * totalCols + col];
                try {
                    frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                frame.reshape(col * desktopWidth / totalCols, row * desktopHeight / totalRows, desktopWidth / totalCols, desktopHeight / totalRows);
                frame.setVisible(true);
                frame.toFront();
            }
        }
    }
}

