/*
 * Decompiled with CFR 0.152.
 */
package org.jibble.logtailer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTextPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jibble.logtailer.AutoScrollTextArea;
import org.jibble.logtailer.HighlightRule;
import org.jibble.logtailer.SettingsDialog;

public class JLogTailerInternalFrame
extends JInternalFrame
implements Runnable,
Serializable {
    private int _maxLines = 500;
    private int _linesShown = 0;
    private boolean _running = true;
    private int _updateInterval = 1000;
    private File _file;
    private long _filePointer;
    private AutoScrollTextArea _asta = new AutoScrollTextArea();
    private ArrayList _rules = new ArrayList();
    private HighlightRule _defaultRule = new HighlightRule();
    private JFrame _owner;

    public JLogTailerInternalFrame() {
    }

    public JLogTailerInternalFrame(JFrame owner, File file, Rectangle bounds) throws IOException {
        this._owner = owner;
        this._file = file;
        Container pane = this.getContentPane();
        pane.add((Component)this._asta, "Center");
        this.setResizable(true);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.setBounds(bounds);
        this.setTitle(file.getName());
        this.setDefaultCloseOperation(0);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent ife) {
                JLogTailerInternalFrame.this._running = false;
                JLogTailerInternalFrame.this.dispose();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        JMenu highlightingMenu = new JMenu("Highlighting");
        menuBar.add(highlightingMenu);
        JMenuItem fileCloseItem = new JMenuItem("Close");
        fileMenu.add(fileCloseItem);
        JMenuItem highlightingOptionsItem = new JMenuItem("Highlighting options");
        highlightingMenu.add(highlightingOptionsItem);
        this.setJMenuBar(menuBar);
        fileCloseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JLogTailerInternalFrame.this._running = false;
                JLogTailerInternalFrame.this.dispose();
            }
        });
        highlightingOptionsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                new SettingsDialog((Frame)JLogTailerInternalFrame.this._owner, JLogTailerInternalFrame.this);
            }
        });
        if (!file.exists() || file.isDirectory() || !file.canRead()) {
            throw new IOException("Can't read this file.");
        }
        this._filePointer = this._file.length();
        this.appendMessage("Log tailing started on " + this._file.toString());
        this.setVisible(true);
    }

    @Override
    public void run() {
        try {
            while (this._running) {
                Thread.sleep(this._updateInterval);
                long len = this._file.length();
                if (len < this._filePointer) {
                    this.appendMessage("Log file was reset. Restarting logging from start of file.");
                    this._filePointer = len;
                    continue;
                }
                if (len <= this._filePointer) continue;
                RandomAccessFile raf = new RandomAccessFile(this._file, "r");
                raf.seek(this._filePointer);
                String line = null;
                while ((line = raf.readLine()) != null) {
                    this.appendLine(line);
                }
                this._filePointer = raf.getFilePointer();
                raf.close();
            }
        }
        catch (Exception e) {
            this.appendMessage("Fatal error reading log file, log tailing has stopped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendLine(String line) {
        try {
            HighlightRule rule = this._defaultRule;
            ArrayList arrayList = this._rules;
            synchronized (arrayList) {
                for (int i = 0; i < this._rules.size(); ++i) {
                    HighlightRule candidate = (HighlightRule)this._rules.get(i);
                    Pattern pattern = candidate.getPattern();
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.find()) continue;
                    rule = candidate;
                    break;
                }
            }
            if (rule.getBeep()) {
                this.getToolkit().beep();
            }
            if (rule.getFiltered()) {
                return;
            }
            JTextPane textPane = this._asta.getTextPane();
            Document document = this._asta.getDocument();
            SimpleAttributeSet attr = this._asta.getSimpleAttributeSet();
            rule.alterAttributeSet(attr);
            this._asta.append(line + "\n");
            textPane.setDocument(document);
            if (++this._linesShown > this._maxLines) {
                int len = textPane.getText().indexOf(10);
                document.remove(0, len);
                --this._linesShown;
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException("Tried to add a new line to a bad place.");
        }
    }

    public void appendMessage(String message) {
        SimpleAttributeSet attr = this._asta.getSimpleAttributeSet();
        StyleConstants.setForeground(attr, Color.red);
        this.appendLine("[" + new Date().toString() + ", " + message + "]");
        StyleConstants.setForeground(attr, Color.black);
    }

    public String getFilename() {
        return this._file.toString();
    }

    public ArrayList getRules() {
        return this._rules;
    }

    public File getFile() {
        return this._file;
    }
}

