/*
 * Decompiled with CFR 0.152.
 */
package org.jibble.logtailer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jibble.logtailer.HighlightRule;
import org.jibble.logtailer.HighlightRuleDialog;
import org.jibble.logtailer.JLogTailerInternalFrame;

public class SettingsDialog
extends JDialog {
    private JList _list;
    private JLogTailerInternalFrame _tailer;
    private JButton _newRule = new JButton("New");
    private JButton _modifyRule = new JButton("Modify");
    private JButton _deleteRule = new JButton("Delete");
    private JButton _moveUp = new JButton("Move up");
    private JButton _moveDown = new JButton("Move down");
    private JButton _okay = new JButton("Okay");

    public SettingsDialog(Frame owner, JLogTailerInternalFrame tailer) {
        super(owner);
        this._tailer = tailer;
        this._list = new JList<Object>(this._tailer.getRules().toArray());
        Container pane = this.getContentPane();
        JPanel rulesPanel = new JPanel(new BorderLayout());
        JPanel buttonsPanel = new JPanel(new GridLayout(5, 1));
        buttonsPanel.add(this._newRule);
        buttonsPanel.add(this._modifyRule);
        buttonsPanel.add(this._deleteRule);
        buttonsPanel.add(this._moveUp);
        buttonsPanel.add(this._moveDown);
        this._newRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HighlightRule rule = new HighlightRule("NewRule", "^.*$", false, false, false, false, Color.black);
                HighlightRuleDialog dialog = new HighlightRuleDialog((Dialog)SettingsDialog.this, rule);
                if ((rule = dialog.getRule()) != null) {
                    ArrayList rules = SettingsDialog.this._tailer.getRules();
                    rules.add(0, rule);
                    SettingsDialog.this._list.setListData(rules.toArray());
                }
            }
        });
        this._modifyRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int selection = SettingsDialog.this._list.getSelectedIndex();
                if (selection >= 0) {
                    ArrayList rules = SettingsDialog.this._tailer.getRules();
                    HighlightRule rule = (HighlightRule)rules.get(selection);
                    HighlightRuleDialog dialog = new HighlightRuleDialog((Dialog)SettingsDialog.this, rule);
                    if (dialog.getRule() != null) {
                        rules.set(selection, dialog.getRule());
                    }
                    SettingsDialog.this._list.setListData(rules.toArray());
                }
            }
        });
        this._deleteRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int selection = SettingsDialog.this._list.getSelectedIndex();
                if (selection >= 0) {
                    ArrayList rules = SettingsDialog.this._tailer.getRules();
                    rules.remove(selection);
                    SettingsDialog.this._list.setListData(rules.toArray());
                }
            }
        });
        this._moveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int selection = SettingsDialog.this._list.getSelectedIndex();
                if (selection > 0) {
                    ArrayList rules = SettingsDialog.this._tailer.getRules();
                    Object temp = rules.get(selection);
                    rules.set(selection, rules.get(selection - 1));
                    rules.set(selection - 1, temp);
                    SettingsDialog.this._list.setListData(rules.toArray());
                    SettingsDialog.this._list.setSelectedIndex(selection - 1);
                }
            }
        });
        this._moveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ArrayList rules;
                int selection = SettingsDialog.this._list.getSelectedIndex();
                if (selection < (rules = SettingsDialog.this._tailer.getRules()).size() - 1) {
                    Object temp = rules.get(selection + 1);
                    rules.set(selection + 1, rules.get(selection));
                    rules.set(selection, temp);
                    SettingsDialog.this._list.setListData(rules.toArray());
                    SettingsDialog.this._list.setSelectedIndex(selection + 1);
                }
            }
        });
        this._okay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SettingsDialog.this.dispose();
            }
        });
        JScrollPane scroller = new JScrollPane(this._list);
        scroller.setPreferredSize(new Dimension(200, 300));
        rulesPanel.add((Component)new JLabel("Ordered rules settings"), "North");
        rulesPanel.add((Component)scroller, "Center");
        rulesPanel.add((Component)buttonsPanel, "East");
        rulesPanel.add((Component)this._okay, "South");
        pane.add((Component)rulesPanel, "Center");
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setTitle("Options for " + this._tailer.getFilename());
        this.setModal(true);
        this.setResizable(false);
        this.setVisible(true);
    }
}

