/*
 * Decompiled with CFR 0.152.
 */
package reports;

import gestioneFatture.Db;
import gestioneFatture.logic.clienti.Cliente;
import gestioneFatture.logic.documenti.DettaglioIva;
import gestioneFatture.logic.documenti.Documento;
import gestioneFatture.main;
import it.tnx.Util;
import it.tnx.commons.CastUtils;
import it.tnx.commons.cu;
import it.tnx.invoicex.InvoicexUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.commons.lang.StringUtils;
import reports.JRDSBase;
import reports.JRDSInvoice;
import reports.testReport;

public class JRDSDdt
extends JRDSBase
implements JRDataSource {
    private int conta = 0;
    String sql = "";
    ResultSet rDocu = null;
    ResultSet rCliente = null;
    private Documento doc;
    DettaglioIva diva = null;
    String serie = "";
    int numero = 1;
    int anno = 2004;
    String banca_sede;
    String banca_solo_sede;
    String banca_agenzia;
    String banca_iban;
    String iva_codice_1 = "";
    String iva_desc_1 = "";
    String iva_imp_1 = "";
    String iva_perc_1 = "";
    String iva_imposta_1 = "";
    String iva_codice_2 = "";
    String iva_desc_2 = "";
    String iva_imp_2 = "";
    String iva_perc_2 = "";
    String iva_imposta_2 = "";
    String iva_codice_3 = "";
    String iva_desc_3 = "";
    String iva_imp_3 = "";
    String iva_perc_3 = "";
    String iva_imposta_3 = "";
    String scadenze = "";
    Vector scadenze_date = new Vector();
    Vector scadenze_importi = new Vector();
    String intestazione1 = "";
    String intestazione2 = "";
    String intestazione3 = "";
    String intestazione4 = "";
    String intestazione5 = "";
    String intestazione6 = "";
    String etichettaCliente = "";
    String etichettaDestinazione = "";
    String etichettaCliente_eng = "";
    String etichettaDestinazione_eng = "";
    String notePiede = "";
    boolean stampaInvoicexRiga = true;
    Preferences preferences = Preferences.userNodeForPackage(main.class);
    boolean stampa_dest_div = false;
    String ragione_sociale_1 = "";
    String indirizzo_1 = "";
    String cap_loc_prov_1 = "";
    String piva_cfiscale_desc_1 = "";
    String recapito_1 = "";
    String ragione_sociale_2 = "";
    String indirizzo_2 = "";
    String cap_loc_prov_2 = "";
    String piva_cfiscale_desc_2 = "";
    String piva_cfiscale_desc_2_sotto = "";
    String recapito_2 = "";
    String recapito_2_sotto = "";
    String email_2 = "";
    boolean perEmail = false;
    public Integer codiceCliente = null;
    boolean italian = true;
    public String nomeClienteFile;
    String tipodoc = Db.TIPO_DOCUMENTO_DDT;
    boolean acquisto = false;
    String tabt = "test_ddt";
    String tabr = "righ_ddt";
    String ccliente = "cliente";
    boolean prezzi_ivati = false;
    String etichettaFornitore = "";
    String etichettaFornitore_eng = "";
    String valuta = "\u20ac";

    public JRDSDdt(Connection conn, String serie, int numero, int anno, boolean perEmail, boolean acquisto, Integer id) {
        String nonStampareLogo;
        DettaglioIva diva;
        Iterator ivaiter;
        this.serie = serie;
        this.numero = numero;
        this.anno = anno;
        this.perEmail = perEmail;
        this.doc = new Documento();
        this.acquisto = acquisto;
        if (acquisto) {
            this.tipodoc = Db.TIPO_DOCUMENTO_DDT_ACQUISTO;
            this.tabt = "test_ddt_acquisto";
            this.tabr = "righ_ddt_acquisto";
            this.ccliente = "fornitore";
        }
        this.doc.load(Db.INSTANCE, numero, serie, anno, this.tipodoc, id);
        this.doc.calcolaTotali();
        this.doc.visualizzaCastellettoIva();
        InvoicexUtil.aggiornaPrezziNettiUnitari(Db.getConn(), this.tabr, this.tabt, id);
        int ivaSize = this.doc.dettagliIva.size();
        if (ivaSize > 3) {
            JOptionPane.showMessageDialog(null, "Ci sono piu' di 3 tipi di iva ma ne verranno stampati solo 3 !!!");
        }
        if ((ivaiter = this.doc.dettagliIva.iterator()).hasNext()) {
            diva = (DettaglioIva)ivaiter.next();
            this.iva_codice_1 = diva.getCodice();
            this.iva_desc_1 = diva.getDescrizione();
            this.iva_imp_1 = Util.formatValutaEuro(diva.getImponibile());
            this.iva_perc_1 = Util.formatNumero2Decimali(diva.getPercentuale());
            this.iva_imposta_1 = Util.formatValutaEuro(diva.getImposta());
        }
        if (ivaiter.hasNext()) {
            diva = (DettaglioIva)ivaiter.next();
            this.iva_codice_2 = diva.getCodice();
            this.iva_desc_2 = diva.getDescrizione();
            this.iva_imp_2 = Util.formatValutaEuro(diva.getImponibile());
            this.iva_perc_2 = Util.formatNumero2Decimali(diva.getPercentuale());
            this.iva_imposta_2 = Util.formatValutaEuro(diva.getImposta());
        }
        if (ivaiter.hasNext()) {
            diva = (DettaglioIva)ivaiter.next();
            this.iva_codice_3 = diva.getCodice();
            this.iva_desc_3 = diva.getDescrizione();
            this.iva_imp_3 = Util.formatValutaEuro(diva.getImponibile());
            this.iva_perc_3 = Util.formatNumero2Decimali(diva.getPercentuale());
            this.iva_imposta_3 = Util.formatValutaEuro(diva.getImposta());
        }
        this.sql = "select t.*,r.*,clie_forn.*, clie_forn_dest.*, agenti.*, articoli.*  , clie_forn.codice as codice_cliente2 " + (acquisto ? ", '' as cliente, '' as cliente_destinazione " : "") + " , l.codice as listino \n , l.descrizione as listino_descrizione \n , l.ricarico_flag as listino_ricarico_flag \n , l.ricarico_perc as listino_ricarico_perc \n , l.ricarico_listino as listino_ricarico_listino \n , l2.codice as listino2 \n , l2.descrizione as listino2_descrizione \n , l2.ricarico_flag as listino2_ricarico_flag \n , l2.ricarico_perc as listino2_ricarico_perc \n , l2.ricarico_listino as listino2_ricarico_listino \n , ap.prezzo as listino_prezzo \n , ap2.prezzo as listino2_prezzo \n , agenti.nome as agente_nome \n , articoli.codice_a_barre \n , RIGHT(IFNULL(articoli.codice_a_barre,''),6) as codice_a_barre_ultimi6 \n , articoli.codice_fornitore \n , articoli.immagine1 \n , dep.id as dep_id \n , dep.nome as dep_nome \n , dep.intestazione_personalizzata \n , dep.intestazione_riga1 \n , dep.intestazione_riga2 \n , dep.intestazione_riga3 \n , dep.intestazione_riga4 \n , dep.intestazione_riga5 \n , dep.intestazione_riga6 \n from ((" + this.tabt + " t left join " + this.tabr + " r on t.id = r.id_padre ) \n left join clie_forn on t." + this.ccliente + " = clie_forn.codice) \n left join clie_forn_dest on t.id_" + this.ccliente + "_destinazione = clie_forn_dest.id \n left join agenti on t.agente_codice = agenti.id \n left join tipi_listino l on t.listino_consigliato = l.codice \n left join articoli_prezzi ap on r.codice_articolo = ap.articolo and ap.listino = l.codice \n left join tipi_listino l2 on l.ricarico_listino = l2.codice \n left join articoli_prezzi ap2 on r.codice_articolo = ap2.articolo and ap2.listino = l2.codice \n left join articoli on r.codice_articolo = articoli.codice \n left join depositi dep ON t.deposito = dep.id \n where t.id = " + Db.pc(id, 4) + " group by r.id order by r.riga";
        System.out.println("jasper sql:" + this.sql);
        try {
            String temp;
            String capLocProv;
            Statement stat = conn.createStatement();
            this.rDocu = stat.executeQuery(this.sql);
            Statement statCliente = conn.createStatement();
            this.banca_sede = "";
            this.banca_agenzia = "";
            this.rDocu.next();
            Preferences preferences = Preferences.userNodeForPackage(main.class);
            if (main.fileIni.getValueBoolean("pref", "soloItaliano", true).booleanValue()) {
                this.italian = true;
            } else {
                this.codiceCliente = this.rDocu.getInt(this.ccliente);
                Cliente cliente = new Cliente(this.codiceCliente.intValue());
                this.italian = cliente.isItalian();
            }
            String prezzi_ivati_s = CastUtils.toString((Object)this.rDocu.getString("prezzi_ivati"));
            if (prezzi_ivati_s.equalsIgnoreCase("S")) {
                this.prezzi_ivati = true;
            }
            this.rCliente = statCliente.executeQuery("select * from clie_forn where codice = " + this.rDocu.getInt(this.ccliente));
            this.rCliente.next();
            this.nomeClienteFile = JRDSDdt.getRagSoc(this.rCliente);
            if (this.rDocu.getString("t.banca_iban") != null && this.rDocu.getString("t.banca_iban").length() > 0) {
                this.banca_iban = "IBAN " + this.rDocu.getString("t.banca_iban");
            }
            this.stampa_dest_div = StringUtils.isNotBlank((String)this.rDocu.getString("dest_ragione_sociale")) || StringUtils.isNotBlank((String)this.rDocu.getString("dest_indirizzo"));
            if (main.fileIni.getValueBoolean("pref", "stampaDestDiversaSotto", false).booleanValue() && this.stampa_dest_div) {
                this.ragione_sociale_1 = JRDSDdt.getRagSoc(this.rCliente);
                this.indirizzo_1 = this.rCliente.getString("indirizzo");
                capLocProv = "";
                if ((capLocProv = capLocProv + it.tnx.Db.nz(this.rCliente.getString("cap"), "")).length() > 0) {
                    capLocProv = capLocProv + " ";
                }
                capLocProv = capLocProv + it.tnx.Db.nz(this.rCliente.getString("localita"), "");
                if (it.tnx.Db.nz(this.rCliente.getString("provincia"), "").length() > 0) {
                    capLocProv = capLocProv + " (" + it.tnx.Db.nz(this.rCliente.getString("provincia"), "") + ")";
                }
                this.cap_loc_prov_1 = capLocProv;
                this.piva_cfiscale_desc_1 = JRDSBase.getPivaCfiscale(this.italian, this.rCliente);
                try {
                    this.recapito_1 = Db.lookUp(this.rCliente.getString("paese"), "codice1", "stati").getString("nome");
                }
                catch (Exception ex) {
                    this.recapito_1 = "";
                }
                if (!main.pluginAttivi.contains("pluginToysforyou") && "ITALY".equals(this.recapito_1)) {
                    this.recapito_1 = "";
                }
                this.recapito_1 = InvoicexUtil.aggiungi_recapiti(this.recapito_1, false, this.rCliente, this.rDocu);
                this.ragione_sociale_2 = this.rDocu.getString("dest_ragione_sociale");
                this.indirizzo_2 = this.rDocu.getString("dest_indirizzo");
                capLocProv = "";
                if ((capLocProv = capLocProv + it.tnx.Db.nz(this.rDocu.getString("dest_cap"), "")).length() > 0) {
                    capLocProv = capLocProv + " ";
                }
                capLocProv = capLocProv + it.tnx.Db.nz(this.rDocu.getString("dest_localita"), "");
                if (it.tnx.Db.nz(this.rDocu.getString("dest_provincia"), "").length() > 0) {
                    capLocProv = capLocProv + " (" + it.tnx.Db.nz(this.rDocu.getString("dest_provincia"), "") + ")";
                }
                this.cap_loc_prov_2 = capLocProv;
                this.piva_cfiscale_desc_2 = "";
                try {
                    this.recapito_2 = Db.lookUp(this.rDocu.getString("dest_paese"), "codice1", "stati").getString("nome");
                }
                catch (Exception ex) {
                    this.recapito_2 = "";
                }
                if (!main.pluginAttivi.contains("pluginToysforyou") && "ITALY".equals(this.recapito_2)) {
                    this.recapito_2 = "";
                }
                this.recapito_2_sotto = this.recapito_2 = InvoicexUtil.aggiungi_recapiti(this.recapito_2, true, this.rCliente, this.rDocu);
                this.email_2 = CastUtils.toString((Object)this.rDocu.getString("email"));
                this.email_2 = this.email_2.equals("") ? "" : "<br>Email: " + this.email_2;
            } else {
                this.ragione_sociale_2 = JRDSDdt.getRagSoc(this.rCliente);
                this.indirizzo_2 = this.rCliente.getString("indirizzo");
                capLocProv = "";
                if ((capLocProv = capLocProv + it.tnx.Db.nz(this.rCliente.getString("cap"), "")).length() > 0) {
                    capLocProv = capLocProv + " ";
                }
                capLocProv = capLocProv + it.tnx.Db.nz(this.rCliente.getString("localita"), "");
                if (it.tnx.Db.nz(this.rCliente.getString("provincia"), "").length() > 0) {
                    capLocProv = capLocProv + " (" + it.tnx.Db.nz(this.rCliente.getString("provincia"), "") + ")";
                }
                this.cap_loc_prov_2 = capLocProv;
                String piva_lbl = "";
                String cfisc_lbl = "";
                String piva_txt = this.rCliente.getString("piva_cfiscale");
                String cfisc_txt = this.rCliente.getString("cfiscale");
                if (this.italian) {
                    piva_lbl = "P.IVA";
                    cfisc_lbl = "Cod. Fisc.";
                } else {
                    piva_lbl = "Vat no.";
                    cfisc_lbl = "Vat Code";
                }
                this.piva_cfiscale_desc_2 = "";
                if (!StringUtils.isEmpty((String)piva_txt)) {
                    this.piva_cfiscale_desc_2 = this.piva_cfiscale_desc_2 + piva_lbl + " " + piva_txt;
                }
                if (!StringUtils.isEmpty((String)cfisc_txt)) {
                    this.piva_cfiscale_desc_2 = this.piva_cfiscale_desc_2 + (StringUtils.isBlank((String)piva_txt) ? "" : " ") + cfisc_lbl + " " + cfisc_txt;
                }
                this.piva_cfiscale_desc_2_sotto = this.piva_cfiscale_desc_2;
                try {
                    this.recapito_2 = Db.lookUp(this.rCliente.getString("paese"), "codice1", "stati").getString("nome");
                }
                catch (Exception ex) {
                    this.recapito_2 = "";
                }
                if (!main.pluginAttivi.contains("pluginToysforyou") && "ITALY".equals(this.recapito_2)) {
                    this.recapito_2 = "";
                }
                this.recapito_2_sotto = this.recapito_2 = InvoicexUtil.aggiungi_recapiti(this.recapito_2, false, this.rCliente, this.rDocu);
                this.email_2 = CastUtils.toString((Object)this.rCliente.getString("email"));
                this.email_2 = this.email_2.equals("") ? "" : "<br>Email: " + this.email_2;
                this.ragione_sociale_1 = this.rDocu.getString("dest_ragione_sociale");
                this.indirizzo_1 = this.rDocu.getString("dest_indirizzo");
                capLocProv = "";
                if ((capLocProv = capLocProv + it.tnx.Db.nz(this.rDocu.getString("dest_cap"), "")).length() > 0) {
                    capLocProv = capLocProv + " ";
                }
                capLocProv = capLocProv + it.tnx.Db.nz(this.rDocu.getString("dest_localita"), "");
                if (it.tnx.Db.nz(this.rDocu.getString("dest_provincia"), "").length() > 0) {
                    capLocProv = capLocProv + " (" + it.tnx.Db.nz(this.rDocu.getString("dest_provincia"), "") + ")";
                }
                this.cap_loc_prov_1 = capLocProv;
                this.piva_cfiscale_desc_1 = "";
                try {
                    this.recapito_1 = Db.lookUp(this.rDocu.getString("dest_paese"), "codice1", "stati").getString("nome");
                }
                catch (Exception ex) {
                    this.recapito_1 = "";
                }
                if (!main.pluginAttivi.contains("pluginToysforyou") && "ITALY".equals(this.recapito_1)) {
                    this.recapito_1 = "";
                }
                this.recapito_1 = InvoicexUtil.aggiungi_recapiti(this.recapito_1, true, this.rCliente, this.rDocu);
            }
            if (!StringUtils.isBlank((String)this.recapito_2)) {
                temp = this.piva_cfiscale_desc_2;
                this.piva_cfiscale_desc_2 = this.recapito_2;
                this.recapito_2 = temp;
            }
            if (!StringUtils.isBlank((String)this.recapito_1)) {
                temp = this.piva_cfiscale_desc_1;
                this.piva_cfiscale_desc_1 = this.recapito_1;
                this.recapito_1 = temp;
            }
            this.dep_intestazione_personalizzata = cu.toBoolean((Object)this.rDocu.getString("intestazione_personalizzata"));
            if (this.dep_intestazione_personalizzata) {
                this.dep_id = cu.i((Object)this.rDocu.getObject("dep_id"));
                this.intestazione1 = this.rDocu.getString("intestazione_riga1");
                this.intestazione2 = this.rDocu.getString("intestazione_riga2");
                this.intestazione3 = this.rDocu.getString("intestazione_riga3");
                this.intestazione4 = this.rDocu.getString("intestazione_riga4");
                this.intestazione5 = this.rDocu.getString("intestazione_riga5");
                this.intestazione6 = this.rDocu.getString("intestazione_riga6");
            }
            this.rDocu.previous();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        try {
            Statement sDatiAzienda = conn.createStatement();
            ResultSet rDatiAzienda = sDatiAzienda.executeQuery("select " + main.campiDatiAzienda + " from dati_azienda");
            if (rDatiAzienda.next()) {
                if (!this.dep_intestazione_personalizzata) {
                    this.intestazione1 = rDatiAzienda.getString("intestazione_riga1");
                    this.intestazione2 = rDatiAzienda.getString("intestazione_riga2");
                    this.intestazione3 = rDatiAzienda.getString("intestazione_riga3");
                    this.intestazione4 = rDatiAzienda.getString("intestazione_riga4");
                    this.intestazione5 = rDatiAzienda.getString("intestazione_riga5");
                    this.intestazione6 = rDatiAzienda.getString("intestazione_riga6");
                }
                this.etichettaCliente = rDatiAzienda.getString("label_cliente");
                this.etichettaDestinazione = rDatiAzienda.getString("label_destinazione");
                this.etichettaCliente_eng = rDatiAzienda.getString("label_cliente_eng");
                this.etichettaDestinazione_eng = rDatiAzienda.getString("label_destinazione_eng");
                this.etichettaFornitore = rDatiAzienda.getString("label_fornitore");
                this.etichettaFornitore_eng = rDatiAzienda.getString("label_fornitore_eng");
                String nomeCampoNotePiede = acquisto ? "testo_piede_docu_a" : "testo_piede_docu_v";
                this.notePiede = rDatiAzienda.getString(nomeCampoNotePiede);
                this.stampaInvoicexRiga = rDatiAzienda.getInt("stampa_riga_invoicex") == 1;
            }
            rDatiAzienda.close();
            sDatiAzienda.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        File testprivacy = new File("reports/privacy.pdf");
        if (testprivacy.exists() && (nonStampareLogo = main.fileIni.getValue("varie", "non_stampare_logo")) != null && nonStampareLogo.equalsIgnoreCase("si")) {
            this.intestazione1 = "";
            this.intestazione2 = "";
            this.intestazione3 = "";
            this.intestazione4 = "";
            this.intestazione5 = "";
            this.intestazione6 = "";
        }
    }

    @Override
    public Object getFieldValue(JRField jRField) throws JRException {
        try {
            if (jRField.getName().equalsIgnoreCase("codice_articolo") && cu.s((Object)this.rDocu.getString("non_stampare_cod_art")).equalsIgnoreCase("s")) {
                return "";
            }
            if (jRField.getName().equalsIgnoreCase("ragione_sociale1")) {
                return this.ragione_sociale_1;
            }
            if (jRField.getName().equalsIgnoreCase("indirizzo1")) {
                return this.indirizzo_1;
            }
            if (jRField.getName().equalsIgnoreCase("cap_loc_prov1")) {
                return this.cap_loc_prov_1;
            }
            if (jRField.getName().equalsIgnoreCase("piva_cfiscale_desc1")) {
                return this.piva_cfiscale_desc_1;
            }
            if (jRField.getName().equalsIgnoreCase("recapito1")) {
                return this.recapito_1;
            }
            if (jRField.getName().equalsIgnoreCase("ragione_sociale2")) {
                return this.ragione_sociale_2;
            }
            if (jRField.getName().equalsIgnoreCase("indirizzo2")) {
                return this.indirizzo_2;
            }
            if (jRField.getName().equalsIgnoreCase("cap_loc_prov2")) {
                return this.cap_loc_prov_2;
            }
            if (jRField.getName().equalsIgnoreCase("piva_cfiscale_desc2")) {
                return this.piva_cfiscale_desc_2;
            }
            if (jRField.getName().equalsIgnoreCase("piva_cfiscale_desc_2_sotto")) {
                if (this.recapito_2_sotto.length() > 0 && !this.recapito_2_sotto.endsWith("<br>") && !main.fileIni.getValueBoolean("pref", "stampaPivaSotto", false).booleanValue()) {
                    return "<br>" + this.piva_cfiscale_desc_2_sotto;
                }
                return this.piva_cfiscale_desc_2_sotto;
            }
            if (jRField.getName().equalsIgnoreCase("recapito2")) {
                return this.recapito_2;
            }
            if (jRField.getName().equalsIgnoreCase("recapito_2_sotto")) {
                return this.recapito_2_sotto;
            }
            if (jRField.getName().equalsIgnoreCase("email_2")) {
                return this.email_2;
            }
            if (jRField.getName().equalsIgnoreCase("condizioni")) {
                if (this.acquisto) {
                    return main.fileIni.getValue("pref", "condizioniAcquistoDdt", "");
                }
                return main.fileIni.getValue("pref", "condizioniVenditaDdt", "");
            }
            if (jRField.getName().equalsIgnoreCase("stampa_dest_div")) {
                return this.stampa_dest_div;
            }
            if (jRField.getName().equalsIgnoreCase("stampa_dest_div")) {
                return this.stampa_dest_div;
            }
            if (jRField.getName().equalsIgnoreCase("etichetta_int1")) {
                if (main.fileIni.getValueBoolean("pref", "stampaDestDiversaSotto", false).booleanValue() && this.stampa_dest_div) {
                    if (this.italian) {
                        return this.acquisto ? this.etichettaFornitore : this.etichettaCliente;
                    }
                    return this.acquisto ? this.etichettaFornitore_eng : this.etichettaCliente_eng;
                }
                if (this.italian) {
                    return this.etichettaDestinazione;
                }
                return this.etichettaDestinazione_eng;
            }
            if (jRField.getName().equalsIgnoreCase("etichetta_int2")) {
                if (main.fileIni.getValueBoolean("pref", "stampaDestDiversaSotto", false).booleanValue() && this.stampa_dest_div) {
                    if (this.italian) {
                        return this.etichettaDestinazione;
                    }
                    return this.etichettaDestinazione_eng;
                }
                if (this.italian) {
                    return this.acquisto ? this.etichettaFornitore : this.etichettaCliente;
                }
                return this.acquisto ? this.etichettaFornitore_eng : this.etichettaCliente_eng;
            }
            if (jRField.getName().equalsIgnoreCase("ragione_sociale")) {
                return this.rCliente.getString(jRField.getName());
            }
            if (jRField.getName().equalsIgnoreCase("indirizzo")) {
                return this.rCliente.getString(jRField.getName());
            }
            if (jRField.getName().equalsIgnoreCase("piva_cfiscale")) {
                return this.rCliente.getString(jRField.getName());
            }
            if (jRField.getName().equalsIgnoreCase("piva_cfiscale_desc")) {
                return JRDSBase.getPivaCfiscale(this.italian, this.rCliente);
            }
            if (jRField.getName().equalsIgnoreCase("cap_loc_prov")) {
                String capLocProv = "";
                if ((capLocProv = capLocProv + it.tnx.Db.nz(this.rCliente.getString("cap"), "")).length() > 0) {
                    capLocProv = capLocProv + " ";
                }
                capLocProv = capLocProv + it.tnx.Db.nz(this.rCliente.getString("localita"), "");
                if (it.tnx.Db.nz(this.rCliente.getString("provincia"), "").length() > 0) {
                    capLocProv = capLocProv + " (" + it.tnx.Db.nz(this.rCliente.getString("provincia"), "") + ")";
                }
                return capLocProv;
            }
            if (jRField.getName().equalsIgnoreCase("dest_cap_loc_prov")) {
                String capLocProv = "";
                if ((capLocProv = capLocProv + it.tnx.Db.nz(this.rDocu.getString("dest_cap"), "")).length() > 0) {
                    capLocProv = capLocProv + " ";
                }
                capLocProv = capLocProv + it.tnx.Db.nz(this.rDocu.getString("dest_localita"), "");
                if (it.tnx.Db.nz(this.rDocu.getString("dest_provincia"), "").length() > 0) {
                    capLocProv = capLocProv + " (" + it.tnx.Db.nz(this.rDocu.getString("dest_provincia"), "") + ")";
                }
                return capLocProv;
            }
            if (jRField.getName().equalsIgnoreCase("recapito")) {
                if (!main.fileIni.getValueBoolean("pref", "stampaCellulare", true).booleanValue()) {
                    return "";
                }
                String recapito = "";
                if (it.tnx.Db.nz(this.rCliente.getString("telefono"), "").length() > 0) {
                    recapito = recapito + "Tel. " + this.rCliente.getString("telefono");
                }
                if (it.tnx.Db.nz(this.rCliente.getString("cellulare"), "").length() > 0) {
                    if (recapito.length() > 0) {
                        recapito = recapito + " ";
                    }
                    recapito = recapito + "Cell. " + this.rCliente.getString("cellulare");
                }
                return recapito;
            }
            if (jRField.getName().equalsIgnoreCase("dest_recapito")) {
                if (!main.fileIni.getValueBoolean("pref", "stampaCellulare", true).booleanValue()) {
                    return "";
                }
                String recapito = "";
                if (it.tnx.Db.nz(this.rDocu.getString("dest_telefono"), "").length() > 0) {
                    recapito = recapito + "Tel. " + this.rDocu.getString("dest_telefono");
                }
                if (it.tnx.Db.nz(this.rDocu.getString("dest_cellulare"), "").length() > 0) {
                    if (recapito.length() > 0) {
                        recapito = recapito + " ";
                    }
                    recapito = recapito + "Cell. " + this.rDocu.getString("dest_cellulare");
                }
                return recapito;
            }
            if (jRField.getName().equalsIgnoreCase("numero_fattura")) {
                String num = "";
                if (it.tnx.Db.nz(this.rDocu.getString("serie"), "").length() > 0) {
                    num = num + this.rDocu.getString("serie") + "/";
                }
                num = num + this.rDocu.getString("numero");
                return num;
            }
            if (jRField.getName().equalsIgnoreCase("sconti")) {
                String sconti = "";
                if (this.rDocu.getDouble("r.sconto1") != 0.0) {
                    sconti = Util.formatNumero2Decimali(this.rDocu.getDouble("r.sconto1"));
                    if (this.rDocu.getDouble("r.sconto2") != 0.0) {
                        sconti = sconti + " + " + Util.formatNumero2Decimali(this.rDocu.getDouble("r.sconto2"));
                    }
                }
                return sconti;
            }
            if (jRField.getName().equalsIgnoreCase("s_quantita")) {
                String ret = "";
                if (this.rDocu.getDouble("quantita") != 0.0) {
                    ret = Util.formatNumero5Decimali(this.rDocu.getDouble("quantita"));
                }
                return ret;
            }
            if (jRField.getName().equalsIgnoreCase("s_numcasse")) {
                String ret = "";
                if (this.rDocu.getDouble("numero_casse") != 0.0) {
                    ret = Util.int2str(this.rDocu.getInt("numero_casse"));
                }
                return ret;
            }
            if (jRField.getName().equalsIgnoreCase("s_prezzo")) {
                String ret = "";
                if (!this.prezzi_ivati) {
                    if (this.rDocu.getDouble("prezzo") != 0.0 || this.rDocu.getDouble("r.sconto1") == 100.0 || this.rDocu.getDouble("quantita") != 0.0) {
                        ret = Db.formatDecimal5(this.rDocu.getDouble("prezzo"));
                    }
                } else if (this.rDocu.getDouble("prezzo_ivato") != 0.0 || this.rDocu.getDouble("r.sconto1") == 100.0 || this.rDocu.getDouble("quantita") != 0.0) {
                    ret = Db.formatDecimal5(this.rDocu.getDouble("prezzo_ivato"));
                }
                return ret;
            }
            if (jRField.getName().equalsIgnoreCase("s_prezzo_consigliato")) {
                String ret = "";
                double prezzo = 0.0;
                if (this.rDocu.getObject("listino_ricarico_flag") != null && this.rDocu.getString("listino_ricarico_flag").equals("S")) {
                    prezzo = this.rDocu.getDouble("listino2_prezzo");
                    prezzo += prezzo / 100.0 * this.rDocu.getDouble("listino_ricarico_perc");
                } else {
                    prezzo = this.rDocu.getDouble("listino_prezzo");
                }
                if (prezzo != 0.0) {
                    ret = Util.format2Decimali(prezzo);
                }
                return ret;
            }
            if (jRField.getName().equalsIgnoreCase("is_descrizione")) {
                return Db.nz(this.rDocu.getString("is_descrizione"), "N").equals("S");
            }
            if (jRField.getName().equalsIgnoreCase("s_importo")) {
                String ret = "";
                if (!this.prezzi_ivati) {
                    if (this.rDocu.getDouble("r.totale_imponibile") != 0.0 || this.rDocu.getDouble("r.sconto1") == 100.0 || this.rDocu.getDouble("quantita") != 0.0) {
                        ret = Util.format2Decimali(this.rDocu.getDouble("r.totale_imponibile"));
                    }
                } else if (this.rDocu.getDouble("r.totale_ivato") != 0.0 || this.rDocu.getDouble("r.sconto1") == 100.0 || this.rDocu.getDouble("quantita") != 0.0) {
                    ret = Util.format2Decimali(this.rDocu.getDouble("r.totale_ivato"));
                }
                return ret;
            }
            if (jRField.getName().equalsIgnoreCase("s_iva")) {
                return cu.s((Object)this.rDocu.getObject("iva"));
            }
            if (jRField.getName().equalsIgnoreCase("s_banca_sede")) {
                return this.banca_sede;
            }
            if (jRField.getName().equalsIgnoreCase("s_banca_solo_sede")) {
                return this.banca_solo_sede;
            }
            if (jRField.getName().equalsIgnoreCase("s_banca_agenzia")) {
                return this.banca_agenzia;
            }
            if (jRField.getName().equalsIgnoreCase("s_spese_trasporto")) {
                String ret = "";
                if (this.rDocu.getDouble("spese_trasporto") != 0.0) {
                    ret = this.valuta + " " + Util.format2Decimali(this.rDocu.getDouble("spese_trasporto"));
                }
                return ret;
            }
            if (jRField.getName().equalsIgnoreCase("s_spese_incasso")) {
                String ret = "";
                if (this.rDocu.getDouble("spese_incasso") != 0.0) {
                    ret = this.valuta + " " + Util.format2Decimali(this.rDocu.getDouble("spese_incasso"));
                }
                return ret;
            }
            if (jRField.getName().equalsIgnoreCase("s_sconti")) {
                return super.getSSconti(this.rDocu);
            }
            if (jRField.getName().equalsIgnoreCase("messaggio")) {
                String ret = main.fileIni.getValue("varie", "messaggioStampaDDT");
                return ret;
            }
            if (jRField.getName().equalsIgnoreCase("iva_codice_1")) {
                return this.iva_codice_1;
            }
            if (jRField.getName().equalsIgnoreCase("iva_desc_1")) {
                return this.iva_desc_1;
            }
            if (jRField.getName().equalsIgnoreCase("iva_imp_1")) {
                return this.iva_imp_1;
            }
            if (jRField.getName().equalsIgnoreCase("iva_perc_1")) {
                return this.iva_perc_1;
            }
            if (jRField.getName().equalsIgnoreCase("iva_imposta_1")) {
                return this.iva_imposta_1;
            }
            if (jRField.getName().equalsIgnoreCase("iva_codice_2")) {
                return this.iva_codice_2;
            }
            if (jRField.getName().equalsIgnoreCase("iva_desc_2")) {
                return this.iva_desc_2;
            }
            if (jRField.getName().equalsIgnoreCase("iva_imp_2")) {
                return this.iva_imp_2;
            }
            if (jRField.getName().equalsIgnoreCase("iva_perc_2")) {
                return this.iva_perc_2;
            }
            if (jRField.getName().equalsIgnoreCase("iva_imposta_2")) {
                return this.iva_imposta_2;
            }
            if (jRField.getName().equalsIgnoreCase("iva_codice_3")) {
                return this.iva_codice_3;
            }
            if (jRField.getName().equalsIgnoreCase("iva_desc_3")) {
                return this.iva_desc_3;
            }
            if (jRField.getName().equalsIgnoreCase("iva_imp_3")) {
                return this.iva_imp_3;
            }
            if (jRField.getName().equalsIgnoreCase("iva_perc_3")) {
                return this.iva_perc_3;
            }
            if (jRField.getName().equalsIgnoreCase("iva_imposta_3")) {
                return this.iva_imposta_3;
            }
            if (jRField.getName().startsWith("scadenze_data_")) {
                int i = CastUtils.toInteger0((Object)StringUtils.substringAfterLast((String)jRField.getName(), (String)"_"));
                if (this.scadenze_date.size() >= i) {
                    return this.scadenze_date.get(i - 1);
                }
                return "";
            }
            if (jRField.getName().startsWith("scadenze_importo_")) {
                int i = CastUtils.toInteger0((Object)StringUtils.substringAfterLast((String)jRField.getName(), (String)"_"));
                if (this.scadenze_importi.size() >= i) {
                    return this.scadenze_importi.get(i - 1);
                }
                return "";
            }
            if (jRField.getName().equalsIgnoreCase("s_totale_imponibile")) {
                return this.valuta + "  " + Util.format2Decimali(this.doc.getTotaleImponibile());
            }
            if (jRField.getName().equalsIgnoreCase("s_totale_iva")) {
                return this.valuta + "  " + Util.format2Decimali(this.doc.getTotaleIva());
            }
            if (jRField.getName().equalsIgnoreCase("s_totale")) {
                return this.valuta + "  " + Util.format2Decimali(this.doc.getTotale());
            }
            if (jRField.getName().equalsIgnoreCase("s_totale_da_pagare_finale")) {
                return this.valuta + "  " + Util.format2Decimali(this.doc.getTotale_da_pagare_finale());
            }
            if (jRField.getName().equalsIgnoreCase("s_acconto")) {
                return this.valuta + "  " + Util.format2Decimali(this.doc.getAcconto());
            }
            if (jRField.getName().equalsIgnoreCase("flag_ritenuta")) {
                if (this.doc.getRitenuta() == 0) {
                    return false;
                }
                return true;
            }
            if (jRField.getName().equalsIgnoreCase("file_logo")) {
                return this.getImg(true, false);
            }
            if (jRField.getName().equalsIgnoreCase("file_logo_input")) {
                return this.getImg(true, true);
            }
            if (jRField.getName().equalsIgnoreCase("file_sfondo_input")) {
                return this.getImg(false, true);
            }
            if (jRField.getName().equalsIgnoreCase("acquisto")) {
                return this.acquisto;
            }
            if (jRField.getName().equalsIgnoreCase("intestazione1")) {
                return this.intestazione1;
            }
            if (jRField.getName().equalsIgnoreCase("intestazione2")) {
                return this.intestazione2;
            }
            if (jRField.getName().equalsIgnoreCase("intestazione3")) {
                return this.intestazione3;
            }
            if (jRField.getName().equalsIgnoreCase("intestazione4")) {
                return this.intestazione4;
            }
            if (jRField.getName().equalsIgnoreCase("intestazione5")) {
                return this.intestazione5;
            }
            if (jRField.getName().equalsIgnoreCase("intestazione6")) {
                return this.intestazione6;
            }
            if (jRField.getName().equalsIgnoreCase("note_da_impostazioni")) {
                return this.notePiede;
            }
            if (jRField.getName().equalsIgnoreCase("stampa_riga_aggiuntiva")) {
                return this.stampaInvoicexRiga;
            }
            if (jRField.getName().equalsIgnoreCase("peso_netto")) {
                String peso_netto = Db.nz(this.rDocu.getString(jRField.getName()), "");
                if (peso_netto.length() > 0) {
                    return peso_netto;
                }
                if (this.doc.totalePeso == 0.0) {
                    return "";
                }
                return Util.format2Decimali(this.doc.totalePeso) + " Kg";
            }
            if (jRField.getName().equalsIgnoreCase("totale_quantita")) {
                return this.doc.getTotaleQuantita();
            }
            if (jRField.getName().equalsIgnoreCase("int_dest_1")) {
                String s = main.fileIni.getValue("varie", "int_dest_1", main.int_dest_1_default);
                s = this.sostituisci(s);
                return s;
            }
            if (jRField.getName().equalsIgnoreCase("int_dest_2")) {
                String s = main.fileIni.getValue("varie", "int_dest_2", main.int_dest_2_default);
                s = this.sostituisci(s);
                return s;
            }
            if (jRField.getValueClassName().equals("java.lang.String")) {
                String s = Db.nz(this.rDocu.getString(jRField.getName()), "");
                s = StringUtils.replace((String)s, (String)"\t", (String)"   ");
                return s;
            }
            if (jRField.getValueClassName().equals("java.lang.Object")) {
                String s = Db.nz(this.rDocu.getObject(jRField.getName()), "");
                s = StringUtils.replace((String)s, (String)"\t", (String)"   ");
                return s;
            }
            if (jRField.getValueClassName().equals("java.util.Date")) {
                return this.rDocu.getDate(jRField.getName());
            }
            if (jRField.getValueClassName().equals("java.lang.Double")) {
                return new Double(this.rDocu.getDouble(jRField.getName()));
            }
            if (jRField.getValueClassName().equals("java.lang.Integer")) {
                return new Integer(this.rDocu.getInt(jRField.getName()));
            }
            if (jRField.getValueClassName().equals("java.lang.Long")) {
                return new Long(this.rDocu.getLong(jRField.getName()));
            }
            return this.rDocu.getObject(jRField.getName());
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    public boolean next() throws JRException {
        ++this.conta;
        try {
            boolean ret = this.rDocu.next();
            return ret;
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        testReport t = new testReport();
    }

    private Object getImg(boolean isLogo, boolean isInputStream) {
        return JRDSInvoice.getImg(isLogo, isInputStream, this.serie, this.numero, this.anno, this.perEmail, this.acquisto, this.acquisto ? "test_ddt_acquisto" : "test_ddt", this.dep_id);
    }
}

