/*
 * Decompiled with CFR 0.152.
 */
package sas.swing.samples;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.LabelUI;
import sas.swing.GradientPanel;
import sas.swing.MultiLineLabel;
import sas.swing.plaf.MultiLineLabelUI;
import sas.swing.plaf.MultiLineShadowUI;

public class MultiLineSample
implements Runnable {
    @Override
    public void run() {
        JFrame frame = new JFrame("Multiline JLabels");
        frame.setDefaultCloseOperation(3);
        GradientPanel contentPane = new GradientPanel(Color.GRAY, Color.DARK_GRAY);
        contentPane.setLayout(new BorderLayout());
        final JLabel title = new JLabel("Multiline label's sample");
        title.setUI(MultiLineLabelUI.labelUI);
        title.setFont(title.getFont().deriveFont(22.0f));
        title.setForeground(Color.WHITE);
        contentPane.add((Component)title, "North");
        final MultiLineLabel mLabel = new MultiLineLabel("Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus non sapien quam. Fusce posuere, nisl vitae tristique volutpat, augue erat faucibus nisl, nec venenatis metus sem vel enim. Cras in libero sapien, vitae euismod neque. Proin hendrerit, odio et faucibus suscipit, eros tellus blandit justo, ac cursus risus elit ut risus.");
        mLabel.setForeground(Color.WHITE);
        contentPane.add((Component)mLabel, "Center");
        JCheckBox effectBox = new JCheckBox(new AbstractAction("Drop shadow"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = ((JCheckBox)e.getSource()).isSelected();
                LabelUI ui = selected ? MultiLineShadowUI.labelUI : MultiLineLabelUI.labelUI;
                this.installUI(ui, mLabel, title);
            }

            private void installUI(LabelUI ui, JLabel ... labels) {
                for (JLabel label : labels) {
                    Font font = label.getFont();
                    label.setUI(ui);
                    label.setFont(font);
                }
            }
        });
        JCheckBox alignBox = new JCheckBox(new AbstractAction("Alignment"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    mLabel.setHorizontalTextAlignment(0);
                    mLabel.setVerticalTextAlignment(3);
                } else {
                    mLabel.setHorizontalTextAlignment(2);
                    mLabel.setVerticalTextAlignment(0);
                }
                mLabel.repaint();
            }
        });
        JPanel boxes = new JPanel(new FlowLayout());
        boxes.setOpaque(false);
        boxes.add(effectBox);
        boxes.add(alignBox);
        contentPane.add((Component)boxes, "South");
        frame.setContentPane(contentPane);
        frame.setSize(240, 320);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new MultiLineSample());
    }
}

