/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.LinkedList;
import jcifs.UniAddress;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbSession;

public class SmbFunction {
    private UniAddress domain;
    private NtlmPasswordAuthentication authentication;

    public void login(String address, String username, String password) throws Exception {
        this.setDomain(UniAddress.getByName((String)address));
        this.setAuthentication(new NtlmPasswordAuthentication(address, username, password));
        SmbSession.logon((UniAddress)this.getDomain(), (NtlmPasswordAuthentication)this.authentication);
    }

    public LinkedList<String> getList(String path) throws Exception {
        LinkedList<String> fList = new LinkedList<String>();
        SmbFile f = new SmbFile(path, this.authentication);
        SmbFile[] fArr = f.listFiles();
        for (int a = 0; a < fArr.length; ++a) {
            fList.add(fArr[a].getName());
            System.out.println(fArr[a].getName());
        }
        return fList;
    }

    public boolean checkDirectory(String path) throws Exception {
        if (!this.isExist(path)) {
            System.out.println(path + " not exist");
            return false;
        }
        if (!this.isDir(path)) {
            System.out.println(path + " not a directory");
            return false;
        }
        return true;
    }

    public boolean isExist(String path) throws Exception {
        SmbFile sFile = new SmbFile(path, this.authentication);
        return sFile.exists();
    }

    public boolean isDir(String path) throws Exception {
        SmbFile sFile = new SmbFile(path, this.authentication);
        return sFile.isDirectory();
    }

    public void createDir(String path) throws Exception {
        SmbFile sFile = new SmbFile(path, this.authentication);
        sFile.mkdir();
    }

    public void delete(String path) throws Exception {
        SmbFile sFile = new SmbFile(path, this.authentication);
        sFile.delete();
    }

    public long size(String path) throws Exception {
        SmbFile sFile = new SmbFile(path, this.authentication);
        return sFile.length();
    }

    public String getFileName(String path) throws Exception {
        SmbFile sFile = new SmbFile(path, this.authentication);
        return sFile.getName();
    }

    public UniAddress getDomain() {
        return this.domain;
    }

    public void setDomain(UniAddress domain) {
        this.domain = domain;
    }

    public NtlmPasswordAuthentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(NtlmPasswordAuthentication authentication) {
        this.authentication = authentication;
    }
}

